import java.util.*;
import java.io.*;

class Main {
    private java.util.Scanner stdin = new java.util.Scanner(System.in);
    private java.util.logging.Logger logger = null;
    public static String loggerName = "MainLogger";

    /**
     * log information for debugging.
     */
    public void logInfo(String a, Object... args) {
	if (logger != null) {
	    logger.info(String.format(a,args));
	}
    }

    public void main2(String args[]) {
	this.logger = java.util.logging.Logger.getLogger(Main.loggerName);
	logInfo("Start");

	Properties props = System.getProperties();
	String prop1 = props.getProperty("org.sqlite.lib.path");
	if (prop1 == null) {
	    logInfo("org.sqlite.lib.path=null");
	} else {
	    logInfo("org.sqlite.lib.path=%1$s", prop1);
	}
	/*
	try {
	    Class.forName("com.mysql.jdbc.Driver");
	} catch (Exception e) {
	    logger.severe("Cannot find JDBC driver");
	    System.exit(1);
	}
	*/
	java.sql.Connection connection = null;
	try {
	    logInfo("Create connection");
	    connection = java.sql.DriverManager.getConnection("jdbc:sqlite:test001.db");

	    logInfo("Create statement");
	    java.sql.Statement statement = connection.createStatement();
	    statement.setQueryTimeout(30);  // set timeout to 30 sec.

	    statement.executeUpdate("drop table if exists person");
	    statement.executeUpdate("create table person (id integer, name string)");
	    statement.executeUpdate("insert into person values(1, 'leo')");
	    statement.executeUpdate("insert into person values(2, 'yui')");
	    java.sql.ResultSet rs = statement.executeQuery("select * from person");
	    while (rs.next()) {
		// read the result set
		System.out.println("name = " + rs.getString("name"));
		System.out.println("id = " + rs.getInt("id"));
	    }
	} catch (java.sql.SQLException e) {
	    // if the error message is "out of memory",
	    // it probably means no database file is found
	    logger.severe(e.getMessage());
	    System.exit(1);
	} finally {
	    try {
		if (connection != null) {
		    connection.close();
		}
	    } catch(java.sql.SQLException e) {
		// connection close failed.
		logger.severe(e.getMessage());
		System.exit(1);
	    }
        }
    }

    public static void main (String args[]) {
	Main myMain = new Main();
	java.util.logging.Logger.getLogger(Main.loggerName).setLevel(java.util.logging.Level.INFO);
	myMain.main2(args);
    }
}
