class NameNode
UDEFS = {
  "%" => "1e-2",  "Au" => "astronomical_unit",  "Bq" => "s-1",
  "C" => "A.s",  "Celsius" => "K @ 273.15",  "F" => "C/V",
  "Fahrenheit" => "degree_F",  "G" => "gauss",  "Gal" => "cm s-2",
  "Gy" => "J.kg-1",  "H" => "Wb.A-1",  "Hg" => "mercury",
  "Hz" => "1/s",  "J" => "N.m",  "Julian_year" => "365.25 day",
  "L" => "litre",  "N" => "kg.m.s-2",  "P" => "poise",  "Pa" => "N.m-2",
  "Pascal" => "Pa",  "S" => "A/V",  "St" => "stokes",  "Sv" => "J.kg-1",
  "T" => "Wb.m-2",  "V" => "J/C",  "W" => "J/s",  "Wb" => "V.s",
  "a" => "are",  "ac" => "acre",  "acre" => "10 chain2",
  "ampere" => "A",  "angstrom" => "1.0e-10 m",
  "angular_degree" => "degree",  "angular_minute" => "minute_angle",
  "angular_second" => "second_angle",  "are" => "100 m2",
  "astronomical_unit" => "1.49597870e11 m",
  "astronomical_units" => "1.49597870e11 m",  "atm" => "atmosphere",
  "atmosphere" => "101325 Pa",  "bar" => "1e6 dyn.cm-2",
  "cal" => "calorie",  "calorie" => "4.18605 J",  "candela" => "cd",
  "celsius" => "K @ 273.15",  "centigrade" => "K @ 273.15",
  "century" => "100 year",  "chain" => "22 yard",
  "common_year" => "365 day",
  "conventional_mercury" => "gravity 13595.10 kg/m3",  "coulomb" => "C",
  "d" => "24 hour",  "day" => "24 hour",  "degC" => "K @ 273.15",
  "degF" => "degree_F",  "degK" => "K",  "deg_C" => "K @ 273.15",
  "deg_F" => "degree_F",  "deg_K" => "K",  "degree" => "pi.rad/180",
  "degreeC" => "K @ 273.15",  "degreeF" => "degree_F",
  "degreeK" => "K",  "degree_C" => "K @ 273.15",
  "degree_E" => "degree",  "degree_F" => "degree_R @ 459.67",
  "degree_N" => "degree",  "degree_R" => "K / 1.8",
  "degree_S" => "degree",  "degree_W" => "degree",
  "degree_c" => "K @ 273.15",  "degree_east" => "degree_E",
  "degree_f" => "degree_R @ 459.67",  "degree_north" => "degree_N",
  "degree_south" => "degree_S",  "degree_west" => "degree_W",
  "degrees_east" => "degree_E",  "degrees_north" => "degree_N",
  "degrees_south" => "degree_S",  "degrees_west" => "degree_W",
  "dyn" => "g.cm.s-2",  "dyne" => "g.cm.s-2",  "erg" => "dyn cm",
  "fahrenheit" => "degree_F",  "farad" => "coulomb/volt",
  "feet" => "foot",  "fermi" => "1.0e-15 m",  "foot" => "12 inch",
  "force" => "9.80665 m.s-2",  "ft" => "foot",  "g" => "kg/1000",
  "gal" => "cm s-2",  "gauss" => "T / 10000",  "gpm" => "m",
  "gram" => "kg/1000",  "gravity" => "9.806650 meter/second2",
  "h" => "60 min",  "hectare" => "100 are",  "hertz" => "Hz",
  "hg" => "mercury",  "horse_power" => "75 m kilogram-force / s",
  "hour" => "60 min",  "hr" => "60 min",  "in" => "inch",
  "inch" => "2.54 cm",  "joule" => "J",  "kelvin" => "K",
  "kgf" => "kilogram-force",  "kilogram" => "kg",
  "knot" => "nautical_mile / hour",  "kph" => "km / hour",
  "lb" => "pound",  "light_speed" => "299792458 m/s",
  "light_year" => "9.46e15 m",  "light_years" => "9.46e15 m",
  "litre" => "1.0e-3 m3",  "lm" => "cd.sr",  "lx" => "lm.m-2",
  "ly" => "light_year",  "mb" => "bar / 1000",
  "mercury" => "conventional_mercury",  "meter" => "metre",
  "metre" => "m",  "mgal" => "cm s-2 / 1000",  "micron" => "1.0e-6 m",
  "mile" => "1760 yard",  "millibar" => "bar / 1000",  "min" => "60 s",
  "minute" => "60 s",  "minute_angle" => "pi.rad/180/60",
  "mole" => "mol",  "mon" => "month",  "month" => "6 pentad",
  "mph" => "mile / hour",  "nautical_mile" => "1852 m",
  "nautical_miles" => "1852 m",  "newton" => "N",  "ohm" => "V/A",
  "ounce" => "pound / 16",  "oz" => "ounce",  "parsec" => "3.0857e16 m",
  "pascal" => "Pa",  "pc" => "parsec",  "percent" => "1e-2",
  "permil" => "1e-3",  "pi" => "3.141592653589793238462",
  "poise" => "dyn s / cm2",  "pound" => "453.6 g",
  "psi" => "pound-force / inch2",  "radian" => "rad",  "second" => "s",
  "second_angle" => "pi.rad/180/60/60",  "steradian" => "sr",
  "stokes" => "cm2 / s",  "t" => "ton",  "tesla" => "Wb.m-2",
  "ton" => "1000 kg",  "tonne" => "ton",  "torr" => "133.322 Pa",
  "volt" => "V",  "watt" => "W",  "weber" => "Wb",  "yard" => "6 feet",
  "yd" => "yard",  "year" => "12 month",  "yr" => "year",
}
UALIASES = {
  "Celsiuses" => [0, "Celsius"],  "EA" => [18, "A"],
  "EAu" => [18, "Au"],  "EBq" => [18, "Bq"],  "EC" => [18, "C"],
  "EF" => [18, "F"],  "EG" => [18, "G"],  "EGal" => [18, "Gal"],
  "EGy" => [18, "Gy"],  "EH" => [18, "H"],  "EHg" => [18, "Hg"],
  "EHz" => [18, "Hz"],  "EJ" => [18, "J"],  "EK" => [18, "K"],
  "EL" => [18, "L"],  "EN" => [18, "N"],  "EP" => [18, "P"],
  "EPa" => [18, "Pa"],  "ES" => [18, "S"],  "ESt" => [18, "St"],
  "ESv" => [18, "Sv"],  "ET" => [18, "T"],  "EV" => [18, "V"],
  "EW" => [18, "W"],  "EWb" => [18, "Wb"],  "Ea" => [18, "a"],
  "Eac" => [18, "ac"],  "Eatm" => [18, "atm"],  "Ebar" => [18, "bar"],
  "Ecal" => [18, "cal"],  "Ecd" => [18, "cd"],
  "Econventional_mercury" => [18, "conventional_mercury"],
  "EdegC" => [18, "degC"],  "EdegF" => [18, "degF"],
  "Edeg_C" => [18, "deg_C"],  "Edeg_F" => [18, "deg_F"],
  "EdegreeC" => [18, "degreeC"],  "EdegreeF" => [18, "degreeF"],
  "Edegree_C" => [18, "degree_C"],  "Edegree_E" => [18, "degree_E"],
  "Edegree_F" => [18, "degree_F"],  "Edegree_N" => [18, "degree_N"],
  "Edegree_R" => [18, "degree_R"],  "Edegree_S" => [18, "degree_S"],
  "Edegree_W" => [18, "degree_W"],  "Edegree_c" => [18, "degree_c"],
  "Edegree_east" => [18, "degree_east"],
  "Edegree_f" => [18, "degree_f"],
  "Edegree_north" => [18, "degree_north"],
  "Edegree_south" => [18, "degree_south"],
  "Edegree_west" => [18, "degree_west"],
  "Edegrees_east" => [18, "degrees_east"],
  "Edegrees_north" => [18, "degrees_north"],
  "Edegrees_south" => [18, "degrees_south"],
  "Edegrees_west" => [18, "degrees_west"],  "Edyn" => [18, "dyn"],
  "Eerg" => [18, "erg"],  "Eforce" => [18, "force"],  "Eg" => [18, "g"],
  "Egravity" => [18, "gravity"],  "Eh" => [18, "h"],
  "Ehg" => [18, "hg"],  "Ehr" => [18, "hr"],  "Ein" => [18, "in"],
  "Ekgf" => [18, "kgf"],  "Ekph" => [18, "kph"],  "Elb" => [18, "lb"],
  "Elm" => [18, "lm"],  "Elx" => [18, "lx"],  "Ely" => [18, "ly"],
  "Em" => [18, "m"],  "Emb" => [18, "mb"],
  "Emercury" => [18, "mercury"],  "Emgal" => [18, "mgal"],
  "Emin" => [18, "min"],  "Emol" => [18, "mol"],  "Emon" => [18, "mon"],
  "Emph" => [18, "mph"],  "Eohm" => [18, "ohm"],  "Eoz" => [18, "oz"],
  "Epc" => [18, "pc"],  "Epsi" => [18, "psi"],  "Erad" => [18, "rad"],
  "Es" => [18, "s"],  "Esr" => [18, "sr"],  "Et" => [18, "t"],
  "Eyr" => [18, "yr"],  "Fahrenheits" => [0, "Fahrenheit"],
  "GA" => [9, "A"],  "GAu" => [9, "Au"],  "GBq" => [9, "Bq"],
  "GC" => [9, "C"],  "GF" => [9, "F"],  "GG" => [9, "G"],
  "GGal" => [9, "Gal"],  "GGy" => [9, "Gy"],  "GH" => [9, "H"],
  "GHg" => [9, "Hg"],  "GHz" => [9, "Hz"],  "GJ" => [9, "J"],
  "GK" => [9, "K"],  "GL" => [9, "L"],  "GN" => [9, "N"],
  "GP" => [9, "P"],  "GPa" => [9, "Pa"],  "GS" => [9, "S"],
  "GSt" => [9, "St"],  "GSv" => [9, "Sv"],  "GT" => [9, "T"],
  "GV" => [9, "V"],  "GW" => [9, "W"],  "GWb" => [9, "Wb"],
  "Ga" => [9, "a"],  "Gac" => [9, "ac"],  "Gatm" => [9, "atm"],
  "Gbar" => [9, "bar"],  "Gcal" => [9, "cal"],  "Gcd" => [9, "cd"],
  "Gconventional_mercury" => [9, "conventional_mercury"],
  "GdegC" => [9, "degC"],  "GdegF" => [9, "degF"],
  "Gdeg_C" => [9, "deg_C"],  "Gdeg_F" => [9, "deg_F"],
  "GdegreeC" => [9, "degreeC"],  "GdegreeF" => [9, "degreeF"],
  "Gdegree_C" => [9, "degree_C"],  "Gdegree_E" => [9, "degree_E"],
  "Gdegree_F" => [9, "degree_F"],  "Gdegree_N" => [9, "degree_N"],
  "Gdegree_R" => [9, "degree_R"],  "Gdegree_S" => [9, "degree_S"],
  "Gdegree_W" => [9, "degree_W"],  "Gdegree_c" => [9, "degree_c"],
  "Gdegree_east" => [9, "degree_east"],  "Gdegree_f" => [9, "degree_f"],
  "Gdegree_north" => [9, "degree_north"],
  "Gdegree_south" => [9, "degree_south"],
  "Gdegree_west" => [9, "degree_west"],
  "Gdegrees_east" => [9, "degrees_east"],
  "Gdegrees_north" => [9, "degrees_north"],
  "Gdegrees_south" => [9, "degrees_south"],
  "Gdegrees_west" => [9, "degrees_west"],  "Gdyn" => [9, "dyn"],
  "Gerg" => [9, "erg"],  "Gforce" => [9, "force"],  "Gg" => [9, "g"],
  "Ggravity" => [9, "gravity"],  "Gh" => [9, "h"],  "Ghg" => [9, "hg"],
  "Ghr" => [9, "hr"],  "Gin" => [9, "in"],  "Gkgf" => [9, "kgf"],
  "Gkph" => [9, "kph"],  "Glb" => [9, "lb"],  "Glm" => [9, "lm"],
  "Glx" => [9, "lx"],  "Gly" => [9, "ly"],  "Gm" => [9, "m"],
  "Gmb" => [9, "mb"],  "Gmercury" => [9, "mercury"],
  "Gmgal" => [9, "mgal"],  "Gmin" => [9, "min"],  "Gmol" => [9, "mol"],
  "Gmon" => [9, "mon"],  "Gmph" => [9, "mph"],  "Gohm" => [9, "ohm"],
  "Goz" => [9, "oz"],  "Gpc" => [9, "pc"],  "Gpsi" => [9, "psi"],
  "Grad" => [9, "rad"],  "Gs" => [9, "s"],  "Gsr" => [9, "sr"],
  "Gt" => [9, "t"],  "Gyr" => [9, "yr"],
  "Julians_year" => [0, "Julian_year"],  "MA" => [6, "A"],
  "MAu" => [6, "Au"],  "MBq" => [6, "Bq"],  "MC" => [6, "C"],
  "MF" => [6, "F"],  "MG" => [6, "G"],  "MGal" => [6, "Gal"],
  "MGy" => [6, "Gy"],  "MH" => [6, "H"],  "MHg" => [6, "Hg"],
  "MHz" => [6, "Hz"],  "MJ" => [6, "J"],  "MK" => [6, "K"],
  "ML" => [6, "L"],  "MN" => [6, "N"],  "MP" => [6, "P"],
  "MPa" => [6, "Pa"],  "MS" => [6, "S"],  "MSt" => [6, "St"],
  "MSv" => [6, "Sv"],  "MT" => [6, "T"],  "MV" => [6, "V"],
  "MW" => [6, "W"],  "MWb" => [6, "Wb"],  "Ma" => [6, "a"],
  "Mac" => [6, "ac"],  "Matm" => [6, "atm"],  "Mbar" => [6, "bar"],
  "Mcal" => [6, "cal"],  "Mcd" => [6, "cd"],
  "Mconventional_mercury" => [6, "conventional_mercury"],
  "MdegC" => [6, "degC"],  "MdegF" => [6, "degF"],
  "Mdeg_C" => [6, "deg_C"],  "Mdeg_F" => [6, "deg_F"],
  "MdegreeC" => [6, "degreeC"],  "MdegreeF" => [6, "degreeF"],
  "Mdegree_C" => [6, "degree_C"],  "Mdegree_E" => [6, "degree_E"],
  "Mdegree_F" => [6, "degree_F"],  "Mdegree_N" => [6, "degree_N"],
  "Mdegree_R" => [6, "degree_R"],  "Mdegree_S" => [6, "degree_S"],
  "Mdegree_W" => [6, "degree_W"],  "Mdegree_c" => [6, "degree_c"],
  "Mdegree_east" => [6, "degree_east"],  "Mdegree_f" => [6, "degree_f"],
  "Mdegree_north" => [6, "degree_north"],
  "Mdegree_south" => [6, "degree_south"],
  "Mdegree_west" => [6, "degree_west"],
  "Mdegrees_east" => [6, "degrees_east"],
  "Mdegrees_north" => [6, "degrees_north"],
  "Mdegrees_south" => [6, "degrees_south"],
  "Mdegrees_west" => [6, "degrees_west"],  "Mdyn" => [6, "dyn"],
  "Merg" => [6, "erg"],  "Mforce" => [6, "force"],  "Mg" => [6, "g"],
  "Mgravity" => [6, "gravity"],  "Mh" => [6, "h"],  "Mhg" => [6, "hg"],
  "Mhr" => [6, "hr"],  "Min" => [6, "in"],  "Mkgf" => [6, "kgf"],
  "Mkph" => [6, "kph"],  "Mlb" => [6, "lb"],  "Mlm" => [6, "lm"],
  "Mlx" => [6, "lx"],  "Mly" => [6, "ly"],  "Mm" => [6, "m"],
  "Mmb" => [6, "mb"],  "Mmercury" => [6, "mercury"],
  "Mmgal" => [6, "mgal"],  "Mmin" => [6, "min"],  "Mmol" => [6, "mol"],
  "Mmon" => [6, "mon"],  "Mmph" => [6, "mph"],  "Mohm" => [6, "ohm"],
  "Moz" => [6, "oz"],  "Mpc" => [6, "pc"],  "Mpsi" => [6, "psi"],
  "Mrad" => [6, "rad"],  "Ms" => [6, "s"],  "Msr" => [6, "sr"],
  "Mt" => [6, "t"],  "Myr" => [6, "yr"],  "PA" => [15, "A"],
  "PAu" => [15, "Au"],  "PBq" => [15, "Bq"],  "PC" => [15, "C"],
  "PF" => [15, "F"],  "PG" => [15, "G"],  "PGal" => [15, "Gal"],
  "PGy" => [15, "Gy"],  "PH" => [15, "H"],  "PHg" => [15, "Hg"],
  "PHz" => [15, "Hz"],  "PJ" => [15, "J"],  "PK" => [15, "K"],
  "PL" => [15, "L"],  "PN" => [15, "N"],  "PP" => [15, "P"],
  "PPa" => [15, "Pa"],  "PS" => [15, "S"],  "PSt" => [15, "St"],
  "PSv" => [15, "Sv"],  "PT" => [15, "T"],  "PV" => [15, "V"],
  "PW" => [15, "W"],  "PWb" => [15, "Wb"],  "Pa" => [15, "a"],
  "Pac" => [15, "ac"],  "Pascals" => [0, "Pascal"],
  "Patm" => [15, "atm"],  "Pbar" => [15, "bar"],  "Pcal" => [15, "cal"],
  "Pcd" => [15, "cd"],
  "Pconventional_mercury" => [15, "conventional_mercury"],
  "PdegC" => [15, "degC"],  "PdegF" => [15, "degF"],
  "Pdeg_C" => [15, "deg_C"],  "Pdeg_F" => [15, "deg_F"],
  "PdegreeC" => [15, "degreeC"],  "PdegreeF" => [15, "degreeF"],
  "Pdegree_C" => [15, "degree_C"],  "Pdegree_E" => [15, "degree_E"],
  "Pdegree_F" => [15, "degree_F"],  "Pdegree_N" => [15, "degree_N"],
  "Pdegree_R" => [15, "degree_R"],  "Pdegree_S" => [15, "degree_S"],
  "Pdegree_W" => [15, "degree_W"],  "Pdegree_c" => [15, "degree_c"],
  "Pdegree_east" => [15, "degree_east"],
  "Pdegree_f" => [15, "degree_f"],
  "Pdegree_north" => [15, "degree_north"],
  "Pdegree_south" => [15, "degree_south"],
  "Pdegree_west" => [15, "degree_west"],
  "Pdegrees_east" => [15, "degrees_east"],
  "Pdegrees_north" => [15, "degrees_north"],
  "Pdegrees_south" => [15, "degrees_south"],
  "Pdegrees_west" => [15, "degrees_west"],  "Pdyn" => [15, "dyn"],
  "Perg" => [15, "erg"],  "Pforce" => [15, "force"],  "Pg" => [15, "g"],
  "Pgravity" => [15, "gravity"],  "Ph" => [15, "h"],
  "Phg" => [15, "hg"],  "Phr" => [15, "hr"],  "Pin" => [15, "in"],
  "Pkgf" => [15, "kgf"],  "Pkph" => [15, "kph"],  "Plb" => [15, "lb"],
  "Plm" => [15, "lm"],  "Plx" => [15, "lx"],  "Ply" => [15, "ly"],
  "Pm" => [15, "m"],  "Pmb" => [15, "mb"],
  "Pmercury" => [15, "mercury"],  "Pmgal" => [15, "mgal"],
  "Pmin" => [15, "min"],  "Pmol" => [15, "mol"],  "Pmon" => [15, "mon"],
  "Pmph" => [15, "mph"],  "Pohm" => [15, "ohm"],  "Poz" => [15, "oz"],
  "Ppc" => [15, "pc"],  "Ppsi" => [15, "psi"],  "Prad" => [15, "rad"],
  "Ps" => [15, "s"],  "Psr" => [15, "sr"],  "Pt" => [15, "t"],
  "Pyr" => [15, "yr"],  "TA" => [12, "A"],  "TAu" => [12, "Au"],
  "TBq" => [12, "Bq"],  "TC" => [12, "C"],  "TF" => [12, "F"],
  "TG" => [12, "G"],  "TGal" => [12, "Gal"],  "TGy" => [12, "Gy"],
  "TH" => [12, "H"],  "THg" => [12, "Hg"],  "THz" => [12, "Hz"],
  "TJ" => [12, "J"],  "TK" => [12, "K"],  "TL" => [12, "L"],
  "TN" => [12, "N"],  "TP" => [12, "P"],  "TPa" => [12, "Pa"],
  "TS" => [12, "S"],  "TSt" => [12, "St"],  "TSv" => [12, "Sv"],
  "TT" => [12, "T"],  "TV" => [12, "V"],  "TW" => [12, "W"],
  "TWb" => [12, "Wb"],  "Ta" => [12, "a"],  "Tac" => [12, "ac"],
  "Tatm" => [12, "atm"],  "Tbar" => [12, "bar"],  "Tcal" => [12, "cal"],
  "Tcd" => [12, "cd"],
  "Tconventional_mercury" => [12, "conventional_mercury"],
  "TdegC" => [12, "degC"],  "TdegF" => [12, "degF"],
  "Tdeg_C" => [12, "deg_C"],  "Tdeg_F" => [12, "deg_F"],
  "TdegreeC" => [12, "degreeC"],  "TdegreeF" => [12, "degreeF"],
  "Tdegree_C" => [12, "degree_C"],  "Tdegree_E" => [12, "degree_E"],
  "Tdegree_F" => [12, "degree_F"],  "Tdegree_N" => [12, "degree_N"],
  "Tdegree_R" => [12, "degree_R"],  "Tdegree_S" => [12, "degree_S"],
  "Tdegree_W" => [12, "degree_W"],  "Tdegree_c" => [12, "degree_c"],
  "Tdegree_east" => [12, "degree_east"],
  "Tdegree_f" => [12, "degree_f"],
  "Tdegree_north" => [12, "degree_north"],
  "Tdegree_south" => [12, "degree_south"],
  "Tdegree_west" => [12, "degree_west"],
  "Tdegrees_east" => [12, "degrees_east"],
  "Tdegrees_north" => [12, "degrees_north"],
  "Tdegrees_south" => [12, "degrees_south"],
  "Tdegrees_west" => [12, "degrees_west"],  "Tdyn" => [12, "dyn"],
  "Terg" => [12, "erg"],  "Tforce" => [12, "force"],  "Tg" => [12, "g"],
  "Tgravity" => [12, "gravity"],  "Th" => [12, "h"],
  "Thg" => [12, "hg"],  "Thr" => [12, "hr"],  "Tin" => [12, "in"],
  "Tkgf" => [12, "kgf"],  "Tkph" => [12, "kph"],  "Tlb" => [12, "lb"],
  "Tlm" => [12, "lm"],  "Tlx" => [12, "lx"],  "Tly" => [12, "ly"],
  "Tm" => [12, "m"],  "Tmb" => [12, "mb"],
  "Tmercury" => [12, "mercury"],  "Tmgal" => [12, "mgal"],
  "Tmin" => [12, "min"],  "Tmol" => [12, "mol"],  "Tmon" => [12, "mon"],
  "Tmph" => [12, "mph"],  "Tohm" => [12, "ohm"],  "Toz" => [12, "oz"],
  "Tpc" => [12, "pc"],  "Tpsi" => [12, "psi"],  "Trad" => [12, "rad"],
  "Ts" => [12, "s"],  "Tsr" => [12, "sr"],  "Tt" => [12, "t"],
  "Tyr" => [12, "yr"],  "aA" => [-18, "A"],  "aAu" => [-18, "Au"],
  "aBq" => [-18, "Bq"],  "aC" => [-18, "C"],  "aF" => [-18, "F"],
  "aG" => [-18, "G"],  "aGal" => [-18, "Gal"],  "aGy" => [-18, "Gy"],
  "aH" => [-18, "H"],  "aHg" => [-18, "Hg"],  "aHz" => [-18, "Hz"],
  "aJ" => [-18, "J"],  "aK" => [-18, "K"],  "aL" => [-18, "L"],
  "aN" => [-18, "N"],  "aP" => [-18, "P"],  "aPa" => [-18, "Pa"],
  "aS" => [-18, "S"],  "aSt" => [-18, "St"],  "aSv" => [-18, "Sv"],
  "aT" => [-18, "T"],  "aV" => [-18, "V"],  "aW" => [-18, "W"],
  "aWb" => [-18, "Wb"],  "aa" => [-18, "a"],  "aac" => [-18, "ac"],
  "aatm" => [-18, "atm"],  "abar" => [-18, "bar"],
  "acal" => [-18, "cal"],  "acd" => [-18, "cd"],
  "aconventional_mercury" => [-18, "conventional_mercury"],
  "acres" => [0, "acre"],  "adegC" => [-18, "degC"],
  "adegF" => [-18, "degF"],  "adeg_C" => [-18, "deg_C"],
  "adeg_F" => [-18, "deg_F"],  "adegreeC" => [-18, "degreeC"],
  "adegreeF" => [-18, "degreeF"],  "adegree_C" => [-18, "degree_C"],
  "adegree_E" => [-18, "degree_E"],  "adegree_F" => [-18, "degree_F"],
  "adegree_N" => [-18, "degree_N"],  "adegree_R" => [-18, "degree_R"],
  "adegree_S" => [-18, "degree_S"],  "adegree_W" => [-18, "degree_W"],
  "adegree_c" => [-18, "degree_c"],
  "adegree_east" => [-18, "degree_east"],
  "adegree_f" => [-18, "degree_f"],
  "adegree_north" => [-18, "degree_north"],
  "adegree_south" => [-18, "degree_south"],
  "adegree_west" => [-18, "degree_west"],
  "adegrees_east" => [-18, "degrees_east"],
  "adegrees_north" => [-18, "degrees_north"],
  "adegrees_south" => [-18, "degrees_south"],
  "adegrees_west" => [-18, "degrees_west"],  "adyn" => [-18, "dyn"],
  "aerg" => [-18, "erg"],  "aforce" => [-18, "force"],
  "ag" => [-18, "g"],  "agravity" => [-18, "gravity"],
  "ah" => [-18, "h"],  "ahg" => [-18, "hg"],  "ahr" => [-18, "hr"],
  "ain" => [-18, "in"],  "akgf" => [-18, "kgf"],
  "akph" => [-18, "kph"],  "alb" => [-18, "lb"],  "alm" => [-18, "lm"],
  "alx" => [-18, "lx"],  "aly" => [-18, "ly"],  "am" => [-18, "m"],
  "amb" => [-18, "mb"],  "amercury" => [-18, "mercury"],
  "amgal" => [-18, "mgal"],  "amin" => [-18, "min"],
  "amol" => [-18, "mol"],  "amon" => [-18, "mon"],
  "amperes" => [0, "ampere"],  "amph" => [-18, "mph"],
  "angstroms" => [0, "angstrom"],
  "angulars_degree" => [0, "angular_degree"],
  "angulars_minute" => [0, "angular_minute"],
  "angulars_second" => [0, "angular_second"],  "aohm" => [-18, "ohm"],
  "aoz" => [-18, "oz"],  "apc" => [-18, "pc"],  "apsi" => [-18, "psi"],
  "arad" => [-18, "rad"],  "ares" => [0, "are"],  "as" => [-18, "s"],
  "asr" => [-18, "sr"],  "at" => [-18, "t"],
  "atmospheres" => [0, "atmosphere"],
  "attoCelsius" => [-18, "Celsius"],
  "attoFahrenheit" => [-18, "Fahrenheit"],
  "attoJulian_year" => [-18, "Julian_year"],
  "attoPascal" => [-18, "Pascal"],  "attoacre" => [-18, "acre"],
  "attoampere" => [-18, "ampere"],  "attoangstrom" => [-18, "angstrom"],
  "attoangular_degree" => [-18, "angular_degree"],
  "attoangular_minute" => [-18, "angular_minute"],
  "attoangular_second" => [-18, "angular_second"],
  "attoare" => [-18, "are"],  "attoatmosphere" => [-18, "atmosphere"],
  "attocalorie" => [-18, "calorie"],  "attocandela" => [-18, "candela"],
  "attocelsius" => [-18, "celsius"],
  "attocentigrade" => [-18, "centigrade"],
  "attocentury" => [-18, "century"],  "attochain" => [-18, "chain"],
  "attocommon_year" => [-18, "common_year"],
  "attocoulomb" => [-18, "coulomb"],  "attoday" => [-18, "day"],
  "attodegK" => [-18, "degK"],  "attodeg_K" => [-18, "deg_K"],
  "attodegree" => [-18, "degree"],  "attodegreeK" => [-18, "degreeK"],
  "attodyne" => [-18, "dyne"],  "attoerg" => [-18, "erg"],
  "attofahrenheit" => [-18, "fahrenheit"],
  "attofarad" => [-18, "farad"],  "attofermi" => [-18, "fermi"],
  "attogal" => [-18, "gal"],  "attogauss" => [-18, "gauss"],
  "attogram" => [-18, "gram"],  "attohectare" => [-18, "hectare"],
  "attohertz" => [-18, "hertz"],  "attohour" => [-18, "hour"],
  "attoinch" => [-18, "inch"],  "attojoule" => [-18, "joule"],
  "attokelvin" => [-18, "kelvin"],  "attokilogram" => [-18, "kilogram"],
  "attoknot" => [-18, "knot"],  "attolitre" => [-18, "litre"],
  "attometer" => [-18, "meter"],  "attometre" => [-18, "metre"],
  "attomicron" => [-18, "micron"],  "attomile" => [-18, "mile"],
  "attomillibar" => [-18, "millibar"],  "attominute" => [-18, "minute"],
  "attominute_angle" => [-18, "minute_angle"],
  "attomole" => [-18, "mole"],  "attomonth" => [-18, "month"],
  "attonewton" => [-18, "newton"],  "attoounce" => [-18, "ounce"],
  "attoparsec" => [-18, "parsec"],  "attopascal" => [-18, "pascal"],
  "attopentad" => [-18, "pentad"],  "attopercent" => [-18, "percent"],
  "attopoise" => [-18, "poise"],  "attopound" => [-18, "pound"],
  "attoradian" => [-18, "radian"],  "attosecond" => [-18, "second"],
  "attosecond_angle" => [-18, "second_angle"],
  "attosteradian" => [-18, "steradian"],
  "attostokes" => [-18, "stokes"],  "attotesla" => [-18, "tesla"],
  "attoton" => [-18, "ton"],  "attotonne" => [-18, "tonne"],
  "attotorr" => [-18, "torr"],  "attovolt" => [-18, "volt"],
  "attowatt" => [-18, "watt"],  "attoweber" => [-18, "weber"],
  "attoyard" => [-18, "yard"],  "attoyd" => [-18, "yd"],
  "attoyear" => [-18, "year"],  "ayr" => [-18, "yr"],
  "cA" => [-2, "A"],  "cAu" => [-2, "Au"],  "cBq" => [-2, "Bq"],
  "cC" => [-2, "C"],  "cF" => [-2, "F"],  "cG" => [-2, "G"],
  "cGal" => [-2, "Gal"],  "cGy" => [-2, "Gy"],  "cH" => [-2, "H"],
  "cHg" => [-2, "Hg"],  "cHz" => [-2, "Hz"],  "cJ" => [-2, "J"],
  "cK" => [-2, "K"],  "cL" => [-2, "L"],  "cN" => [-2, "N"],
  "cP" => [-2, "P"],  "cPa" => [-2, "Pa"],  "cS" => [-2, "S"],
  "cSt" => [-2, "St"],  "cSv" => [-2, "Sv"],  "cT" => [-2, "T"],
  "cV" => [-2, "V"],  "cW" => [-2, "W"],  "cWb" => [-2, "Wb"],
  "ca" => [-2, "a"],  "cac" => [-2, "ac"],
  "calories" => [0, "calorie"],  "candelas" => [0, "candela"],
  "catm" => [-2, "atm"],  "cbar" => [-2, "bar"],  "ccal" => [-2, "cal"],
  "ccd" => [-2, "cd"],
  "cconventional_mercury" => [-2, "conventional_mercury"],
  "cdegC" => [-2, "degC"],  "cdegF" => [-2, "degF"],
  "cdeg_C" => [-2, "deg_C"],  "cdeg_F" => [-2, "deg_F"],
  "cdegreeC" => [-2, "degreeC"],  "cdegreeF" => [-2, "degreeF"],
  "cdegree_C" => [-2, "degree_C"],  "cdegree_E" => [-2, "degree_E"],
  "cdegree_F" => [-2, "degree_F"],  "cdegree_N" => [-2, "degree_N"],
  "cdegree_R" => [-2, "degree_R"],  "cdegree_S" => [-2, "degree_S"],
  "cdegree_W" => [-2, "degree_W"],  "cdegree_c" => [-2, "degree_c"],
  "cdegree_east" => [-2, "degree_east"],
  "cdegree_f" => [-2, "degree_f"],
  "cdegree_north" => [-2, "degree_north"],
  "cdegree_south" => [-2, "degree_south"],
  "cdegree_west" => [-2, "degree_west"],
  "cdegrees_east" => [-2, "degrees_east"],
  "cdegrees_north" => [-2, "degrees_north"],
  "cdegrees_south" => [-2, "degrees_south"],
  "cdegrees_west" => [-2, "degrees_west"],  "cdyn" => [-2, "dyn"],
  "celsiuses" => [0, "celsius"],  "centiCelsius" => [-2, "Celsius"],
  "centiFahrenheit" => [-2, "Fahrenheit"],
  "centiJulian_year" => [-2, "Julian_year"],
  "centiPascal" => [-2, "Pascal"],  "centiacre" => [-2, "acre"],
  "centiampere" => [-2, "ampere"],  "centiangstrom" => [-2, "angstrom"],
  "centiangular_degree" => [-2, "angular_degree"],
  "centiangular_minute" => [-2, "angular_minute"],
  "centiangular_second" => [-2, "angular_second"],
  "centiare" => [-2, "are"],  "centiatmosphere" => [-2, "atmosphere"],
  "centicalorie" => [-2, "calorie"],  "centicandela" => [-2, "candela"],
  "centicelsius" => [-2, "celsius"],
  "centicentigrade" => [-2, "centigrade"],
  "centicentury" => [-2, "century"],  "centichain" => [-2, "chain"],
  "centicommon_year" => [-2, "common_year"],
  "centicoulomb" => [-2, "coulomb"],  "centiday" => [-2, "day"],
  "centidegK" => [-2, "degK"],  "centideg_K" => [-2, "deg_K"],
  "centidegree" => [-2, "degree"],  "centidegreeK" => [-2, "degreeK"],
  "centidyne" => [-2, "dyne"],  "centierg" => [-2, "erg"],
  "centifahrenheit" => [-2, "fahrenheit"],
  "centifarad" => [-2, "farad"],  "centifermi" => [-2, "fermi"],
  "centigal" => [-2, "gal"],  "centigauss" => [-2, "gauss"],
  "centigrades" => [0, "centigrade"],  "centigram" => [-2, "gram"],
  "centihectare" => [-2, "hectare"],  "centihertz" => [-2, "hertz"],
  "centihour" => [-2, "hour"],  "centiinch" => [-2, "inch"],
  "centijoule" => [-2, "joule"],  "centikelvin" => [-2, "kelvin"],
  "centikilogram" => [-2, "kilogram"],  "centiknot" => [-2, "knot"],
  "centilitre" => [-2, "litre"],  "centimeter" => [-2, "meter"],
  "centimetre" => [-2, "metre"],  "centimicron" => [-2, "micron"],
  "centimile" => [-2, "mile"],  "centimillibar" => [-2, "millibar"],
  "centiminute" => [-2, "minute"],
  "centiminute_angle" => [-2, "minute_angle"],
  "centimole" => [-2, "mole"],  "centimonth" => [-2, "month"],
  "centinewton" => [-2, "newton"],  "centiounce" => [-2, "ounce"],
  "centiparsec" => [-2, "parsec"],  "centipascal" => [-2, "pascal"],
  "centipentad" => [-2, "pentad"],  "centipercent" => [-2, "percent"],
  "centipoise" => [-2, "poise"],  "centipound" => [-2, "pound"],
  "centiradian" => [-2, "radian"],  "centisecond" => [-2, "second"],
  "centisecond_angle" => [-2, "second_angle"],
  "centisteradian" => [-2, "steradian"],
  "centistokes" => [-2, "stokes"],  "centitesla" => [-2, "tesla"],
  "centiton" => [-2, "ton"],  "centitonne" => [-2, "tonne"],
  "centitorr" => [-2, "torr"],  "centivolt" => [-2, "volt"],
  "centiwatt" => [-2, "watt"],  "centiweber" => [-2, "weber"],
  "centiyard" => [-2, "yard"],  "centiyd" => [-2, "yd"],
  "centiyear" => [-2, "year"],  "centuries" => [0, "century"],
  "cerg" => [-2, "erg"],  "cforce" => [-2, "force"],  "cg" => [-2, "g"],
  "cgravity" => [-2, "gravity"],  "ch" => [-2, "h"],
  "chains" => [0, "chain"],  "chg" => [-2, "hg"],  "chr" => [-2, "hr"],
  "cin" => [-2, "in"],  "ckgf" => [-2, "kgf"],  "ckph" => [-2, "kph"],
  "clb" => [-2, "lb"],  "clm" => [-2, "lm"],  "clx" => [-2, "lx"],
  "cly" => [-2, "ly"],  "cm" => [-2, "m"],  "cmb" => [-2, "mb"],
  "cmercury" => [-2, "mercury"],  "cmgal" => [-2, "mgal"],
  "cmin" => [-2, "min"],  "cmol" => [-2, "mol"],  "cmon" => [-2, "mon"],
  "cmph" => [-2, "mph"],  "cohm" => [-2, "ohm"],
  "commons_year" => [0, "common_year"],  "coulombs" => [0, "coulomb"],
  "coz" => [-2, "oz"],  "cpc" => [-2, "pc"],  "cpsi" => [-2, "psi"],
  "crad" => [-2, "rad"],  "cs" => [-2, "s"],  "csr" => [-2, "sr"],
  "ct" => [-2, "t"],  "cyr" => [-2, "yr"],  "dA" => [-1, "A"],
  "dAu" => [-1, "Au"],  "dBq" => [-1, "Bq"],  "dC" => [-1, "C"],
  "dF" => [-1, "F"],  "dG" => [-1, "G"],  "dGal" => [-1, "Gal"],
  "dGy" => [-1, "Gy"],  "dH" => [-1, "H"],  "dHg" => [-1, "Hg"],
  "dHz" => [-1, "Hz"],  "dJ" => [-1, "J"],  "dK" => [-1, "K"],
  "dL" => [-1, "L"],  "dN" => [-1, "N"],  "dP" => [-1, "P"],
  "dPa" => [-1, "Pa"],  "dS" => [-1, "S"],  "dSt" => [-1, "St"],
  "dSv" => [-1, "Sv"],  "dT" => [-1, "T"],  "dV" => [-1, "V"],
  "dW" => [-1, "W"],  "dWb" => [-1, "Wb"],  "da" => [-1, "a"],
  "daA" => [1, "A"],  "daAu" => [1, "Au"],  "daBq" => [1, "Bq"],
  "daC" => [1, "C"],  "daF" => [1, "F"],  "daG" => [1, "G"],
  "daGal" => [1, "Gal"],  "daGy" => [1, "Gy"],  "daH" => [1, "H"],
  "daHg" => [1, "Hg"],  "daHz" => [1, "Hz"],  "daJ" => [1, "J"],
  "daK" => [1, "K"],  "daL" => [1, "L"],  "daN" => [1, "N"],
  "daP" => [1, "P"],  "daPa" => [1, "Pa"],  "daS" => [1, "S"],
  "daSt" => [1, "St"],  "daSv" => [1, "Sv"],  "daT" => [1, "T"],
  "daV" => [1, "V"],  "daW" => [1, "W"],  "daWb" => [1, "Wb"],
  "daa" => [1, "a"],  "daac" => [1, "ac"],  "daatm" => [1, "atm"],
  "dabar" => [1, "bar"],  "dac" => [-1, "ac"],  "dacal" => [1, "cal"],
  "dacd" => [1, "cd"],
  "daconventional_mercury" => [1, "conventional_mercury"],
  "dadegC" => [1, "degC"],  "dadegF" => [1, "degF"],
  "dadeg_C" => [1, "deg_C"],  "dadeg_F" => [1, "deg_F"],
  "dadegreeC" => [1, "degreeC"],  "dadegreeF" => [1, "degreeF"],
  "dadegree_C" => [1, "degree_C"],  "dadegree_E" => [1, "degree_E"],
  "dadegree_F" => [1, "degree_F"],  "dadegree_N" => [1, "degree_N"],
  "dadegree_R" => [1, "degree_R"],  "dadegree_S" => [1, "degree_S"],
  "dadegree_W" => [1, "degree_W"],  "dadegree_c" => [1, "degree_c"],
  "dadegree_east" => [1, "degree_east"],
  "dadegree_f" => [1, "degree_f"],
  "dadegree_north" => [1, "degree_north"],
  "dadegree_south" => [1, "degree_south"],
  "dadegree_west" => [1, "degree_west"],
  "dadegrees_east" => [1, "degrees_east"],
  "dadegrees_north" => [1, "degrees_north"],
  "dadegrees_south" => [1, "degrees_south"],
  "dadegrees_west" => [1, "degrees_west"],  "dadyn" => [1, "dyn"],
  "daerg" => [1, "erg"],  "daforce" => [1, "force"],  "dag" => [1, "g"],
  "dagravity" => [1, "gravity"],  "dah" => [1, "h"],
  "dahg" => [1, "hg"],  "dahr" => [1, "hr"],  "dain" => [1, "in"],
  "dakgf" => [1, "kgf"],  "dakph" => [1, "kph"],  "dalb" => [1, "lb"],
  "dalm" => [1, "lm"],  "dalx" => [1, "lx"],  "daly" => [1, "ly"],
  "dam" => [1, "m"],  "damb" => [1, "mb"],
  "damercury" => [1, "mercury"],  "damgal" => [1, "mgal"],
  "damin" => [1, "min"],  "damol" => [1, "mol"],  "damon" => [1, "mon"],
  "damph" => [1, "mph"],  "daohm" => [1, "ohm"],  "daoz" => [1, "oz"],
  "dapc" => [1, "pc"],  "dapsi" => [1, "psi"],  "darad" => [1, "rad"],
  "das" => [1, "s"],  "dasr" => [1, "sr"],  "dat" => [1, "t"],
  "datm" => [-1, "atm"],  "dayr" => [1, "yr"],  "days" => [0, "day"],
  "dbar" => [-1, "bar"],  "dcal" => [-1, "cal"],  "dcd" => [-1, "cd"],
  "dconventional_mercury" => [-1, "conventional_mercury"],
  "ddegC" => [-1, "degC"],  "ddegF" => [-1, "degF"],
  "ddeg_C" => [-1, "deg_C"],  "ddeg_F" => [-1, "deg_F"],
  "ddegreeC" => [-1, "degreeC"],  "ddegreeF" => [-1, "degreeF"],
  "ddegree_C" => [-1, "degree_C"],  "ddegree_E" => [-1, "degree_E"],
  "ddegree_F" => [-1, "degree_F"],  "ddegree_N" => [-1, "degree_N"],
  "ddegree_R" => [-1, "degree_R"],  "ddegree_S" => [-1, "degree_S"],
  "ddegree_W" => [-1, "degree_W"],  "ddegree_c" => [-1, "degree_c"],
  "ddegree_east" => [-1, "degree_east"],
  "ddegree_f" => [-1, "degree_f"],
  "ddegree_north" => [-1, "degree_north"],
  "ddegree_south" => [-1, "degree_south"],
  "ddegree_west" => [-1, "degree_west"],
  "ddegrees_east" => [-1, "degrees_east"],
  "ddegrees_north" => [-1, "degrees_north"],
  "ddegrees_south" => [-1, "degrees_south"],
  "ddegrees_west" => [-1, "degrees_west"],  "ddyn" => [-1, "dyn"],
  "decaCelsius" => [1, "Celsius"],
  "decaFahrenheit" => [1, "Fahrenheit"],
  "decaJulian_year" => [1, "Julian_year"],
  "decaPascal" => [1, "Pascal"],  "decaacre" => [1, "acre"],
  "decaampere" => [1, "ampere"],  "decaangstrom" => [1, "angstrom"],
  "decaangular_degree" => [1, "angular_degree"],
  "decaangular_minute" => [1, "angular_minute"],
  "decaangular_second" => [1, "angular_second"],
  "decaare" => [1, "are"],  "decaatmosphere" => [1, "atmosphere"],
  "decacalorie" => [1, "calorie"],  "decacandela" => [1, "candela"],
  "decacelsius" => [1, "celsius"],
  "decacentigrade" => [1, "centigrade"],
  "decacentury" => [1, "century"],  "decachain" => [1, "chain"],
  "decacommon_year" => [1, "common_year"],
  "decacoulomb" => [1, "coulomb"],  "decaday" => [1, "day"],
  "decadegK" => [1, "degK"],  "decadeg_K" => [1, "deg_K"],
  "decadegree" => [1, "degree"],  "decadegreeK" => [1, "degreeK"],
  "decadyne" => [1, "dyne"],  "decaerg" => [1, "erg"],
  "decafahrenheit" => [1, "fahrenheit"],  "decafarad" => [1, "farad"],
  "decafermi" => [1, "fermi"],  "decagal" => [1, "gal"],
  "decagauss" => [1, "gauss"],  "decagram" => [1, "gram"],
  "decahectare" => [1, "hectare"],  "decahertz" => [1, "hertz"],
  "decahour" => [1, "hour"],  "decainch" => [1, "inch"],
  "decajoule" => [1, "joule"],  "decakelvin" => [1, "kelvin"],
  "decakilogram" => [1, "kilogram"],  "decaknot" => [1, "knot"],
  "decalitre" => [1, "litre"],  "decameter" => [1, "meter"],
  "decametre" => [1, "metre"],  "decamicron" => [1, "micron"],
  "decamile" => [1, "mile"],  "decamillibar" => [1, "millibar"],
  "decaminute" => [1, "minute"],
  "decaminute_angle" => [1, "minute_angle"],  "decamole" => [1, "mole"],
  "decamonth" => [1, "month"],  "decanewton" => [1, "newton"],
  "decaounce" => [1, "ounce"],  "decaparsec" => [1, "parsec"],
  "decapascal" => [1, "pascal"],  "decapentad" => [1, "pentad"],
  "decapercent" => [1, "percent"],  "decapoise" => [1, "poise"],
  "decapound" => [1, "pound"],  "decaradian" => [1, "radian"],
  "decasecond" => [1, "second"],
  "decasecond_angle" => [1, "second_angle"],
  "decasteradian" => [1, "steradian"],  "decastokes" => [1, "stokes"],
  "decatesla" => [1, "tesla"],  "decaton" => [1, "ton"],
  "decatonne" => [1, "tonne"],  "decatorr" => [1, "torr"],
  "decavolt" => [1, "volt"],  "decawatt" => [1, "watt"],
  "decaweber" => [1, "weber"],  "decayard" => [1, "yard"],
  "decayd" => [1, "yd"],  "decayear" => [1, "year"],
  "deciCelsius" => [-1, "Celsius"],
  "deciFahrenheit" => [-1, "Fahrenheit"],
  "deciJulian_year" => [-1, "Julian_year"],
  "deciPascal" => [-1, "Pascal"],  "deciacre" => [-1, "acre"],
  "deciampere" => [-1, "ampere"],  "deciangstrom" => [-1, "angstrom"],
  "deciangular_degree" => [-1, "angular_degree"],
  "deciangular_minute" => [-1, "angular_minute"],
  "deciangular_second" => [-1, "angular_second"],
  "deciare" => [-1, "are"],  "deciatmosphere" => [-1, "atmosphere"],
  "decicalorie" => [-1, "calorie"],  "decicandela" => [-1, "candela"],
  "decicelsius" => [-1, "celsius"],
  "decicentigrade" => [-1, "centigrade"],
  "decicentury" => [-1, "century"],  "decichain" => [-1, "chain"],
  "decicommon_year" => [-1, "common_year"],
  "decicoulomb" => [-1, "coulomb"],  "deciday" => [-1, "day"],
  "decidegK" => [-1, "degK"],  "decideg_K" => [-1, "deg_K"],
  "decidegree" => [-1, "degree"],  "decidegreeK" => [-1, "degreeK"],
  "decidyne" => [-1, "dyne"],  "decierg" => [-1, "erg"],
  "decifahrenheit" => [-1, "fahrenheit"],  "decifarad" => [-1, "farad"],
  "decifermi" => [-1, "fermi"],  "decigal" => [-1, "gal"],
  "decigauss" => [-1, "gauss"],  "decigram" => [-1, "gram"],
  "decihectare" => [-1, "hectare"],  "decihertz" => [-1, "hertz"],
  "decihour" => [-1, "hour"],  "deciinch" => [-1, "inch"],
  "decijoule" => [-1, "joule"],  "decikelvin" => [-1, "kelvin"],
  "decikilogram" => [-1, "kilogram"],  "deciknot" => [-1, "knot"],
  "decilitre" => [-1, "litre"],  "decimeter" => [-1, "meter"],
  "decimetre" => [-1, "metre"],  "decimicron" => [-1, "micron"],
  "decimile" => [-1, "mile"],  "decimillibar" => [-1, "millibar"],
  "deciminute" => [-1, "minute"],
  "deciminute_angle" => [-1, "minute_angle"],
  "decimole" => [-1, "mole"],  "decimonth" => [-1, "month"],
  "decinewton" => [-1, "newton"],  "deciounce" => [-1, "ounce"],
  "deciparsec" => [-1, "parsec"],  "decipascal" => [-1, "pascal"],
  "decipentad" => [-1, "pentad"],  "decipercent" => [-1, "percent"],
  "decipoise" => [-1, "poise"],  "decipound" => [-1, "pound"],
  "deciradian" => [-1, "radian"],  "decisecond" => [-1, "second"],
  "decisecond_angle" => [-1, "second_angle"],
  "decisteradian" => [-1, "steradian"],  "decistokes" => [-1, "stokes"],
  "decitesla" => [-1, "tesla"],  "deciton" => [-1, "ton"],
  "decitonne" => [-1, "tonne"],  "decitorr" => [-1, "torr"],
  "decivolt" => [-1, "volt"],  "deciwatt" => [-1, "watt"],
  "deciweber" => [-1, "weber"],  "deciyard" => [-1, "yard"],
  "deciyd" => [-1, "yd"],  "deciyear" => [-1, "year"],
  "degKs" => [0, "degK"],  "degreeKs" => [0, "degreeK"],
  "degrees" => [0, "degree"],  "degs_K" => [0, "deg_K"],
  "derg" => [-1, "erg"],  "dforce" => [-1, "force"],  "dg" => [-1, "g"],
  "dgravity" => [-1, "gravity"],  "dh" => [-1, "h"],
  "dhg" => [-1, "hg"],  "dhr" => [-1, "hr"],  "din" => [-1, "in"],
  "dkgf" => [-1, "kgf"],  "dkph" => [-1, "kph"],  "dlb" => [-1, "lb"],
  "dlm" => [-1, "lm"],  "dlx" => [-1, "lx"],  "dly" => [-1, "ly"],
  "dm" => [-1, "m"],  "dmb" => [-1, "mb"],
  "dmercury" => [-1, "mercury"],  "dmgal" => [-1, "mgal"],
  "dmin" => [-1, "min"],  "dmol" => [-1, "mol"],  "dmon" => [-1, "mon"],
  "dmph" => [-1, "mph"],  "dohm" => [-1, "ohm"],  "doz" => [-1, "oz"],
  "dpc" => [-1, "pc"],  "dpsi" => [-1, "psi"],  "drad" => [-1, "rad"],
  "ds" => [-1, "s"],  "dsr" => [-1, "sr"],  "dt" => [-1, "t"],
  "dynes" => [0, "dyne"],  "dyr" => [-1, "yr"],  "ergs" => [0, "erg"],
  "exaCelsius" => [18, "Celsius"],
  "exaFahrenheit" => [18, "Fahrenheit"],
  "exaJulian_year" => [18, "Julian_year"],
  "exaPascal" => [18, "Pascal"],  "exaacre" => [18, "acre"],
  "exaampere" => [18, "ampere"],  "exaangstrom" => [18, "angstrom"],
  "exaangular_degree" => [18, "angular_degree"],
  "exaangular_minute" => [18, "angular_minute"],
  "exaangular_second" => [18, "angular_second"],
  "exaare" => [18, "are"],  "exaatmosphere" => [18, "atmosphere"],
  "exacalorie" => [18, "calorie"],  "exacandela" => [18, "candela"],
  "exacelsius" => [18, "celsius"],
  "exacentigrade" => [18, "centigrade"],
  "exacentury" => [18, "century"],  "exachain" => [18, "chain"],
  "exacommon_year" => [18, "common_year"],
  "exacoulomb" => [18, "coulomb"],  "exaday" => [18, "day"],
  "exadegK" => [18, "degK"],  "exadeg_K" => [18, "deg_K"],
  "exadegree" => [18, "degree"],  "exadegreeK" => [18, "degreeK"],
  "exadyne" => [18, "dyne"],  "exaerg" => [18, "erg"],
  "exafahrenheit" => [18, "fahrenheit"],  "exafarad" => [18, "farad"],
  "exafermi" => [18, "fermi"],  "exagal" => [18, "gal"],
  "exagauss" => [18, "gauss"],  "exagram" => [18, "gram"],
  "exahectare" => [18, "hectare"],  "exahertz" => [18, "hertz"],
  "exahour" => [18, "hour"],  "exainch" => [18, "inch"],
  "exajoule" => [18, "joule"],  "exakelvin" => [18, "kelvin"],
  "exakilogram" => [18, "kilogram"],  "exaknot" => [18, "knot"],
  "exalitre" => [18, "litre"],  "exameter" => [18, "meter"],
  "exametre" => [18, "metre"],  "examicron" => [18, "micron"],
  "examile" => [18, "mile"],  "examillibar" => [18, "millibar"],
  "examinute" => [18, "minute"],
  "examinute_angle" => [18, "minute_angle"],  "examole" => [18, "mole"],
  "examonth" => [18, "month"],  "exanewton" => [18, "newton"],
  "exaounce" => [18, "ounce"],  "exaparsec" => [18, "parsec"],
  "exapascal" => [18, "pascal"],  "exapentad" => [18, "pentad"],
  "exapercent" => [18, "percent"],  "exapoise" => [18, "poise"],
  "exapound" => [18, "pound"],  "exaradian" => [18, "radian"],
  "exasecond" => [18, "second"],
  "exasecond_angle" => [18, "second_angle"],
  "exasteradian" => [18, "steradian"],  "exastokes" => [18, "stokes"],
  "exatesla" => [18, "tesla"],  "exaton" => [18, "ton"],
  "exatonne" => [18, "tonne"],  "exatorr" => [18, "torr"],
  "exavolt" => [18, "volt"],  "exawatt" => [18, "watt"],
  "exaweber" => [18, "weber"],  "exayard" => [18, "yard"],
  "exayd" => [18, "yd"],  "exayear" => [18, "year"],
  "fA" => [-15, "A"],  "fAu" => [-15, "Au"],  "fBq" => [-15, "Bq"],
  "fC" => [-15, "C"],  "fF" => [-15, "F"],  "fG" => [-15, "G"],
  "fGal" => [-15, "Gal"],  "fGy" => [-15, "Gy"],  "fH" => [-15, "H"],
  "fHg" => [-15, "Hg"],  "fHz" => [-15, "Hz"],  "fJ" => [-15, "J"],
  "fK" => [-15, "K"],  "fL" => [-15, "L"],  "fN" => [-15, "N"],
  "fP" => [-15, "P"],  "fPa" => [-15, "Pa"],  "fS" => [-15, "S"],
  "fSt" => [-15, "St"],  "fSv" => [-15, "Sv"],  "fT" => [-15, "T"],
  "fV" => [-15, "V"],  "fW" => [-15, "W"],  "fWb" => [-15, "Wb"],
  "fa" => [-15, "a"],  "fac" => [-15, "ac"],
  "fahrenheits" => [0, "fahrenheit"],  "farads" => [0, "farad"],
  "fatm" => [-15, "atm"],  "fbar" => [-15, "bar"],
  "fcal" => [-15, "cal"],  "fcd" => [-15, "cd"],
  "fconventional_mercury" => [-15, "conventional_mercury"],
  "fdegC" => [-15, "degC"],  "fdegF" => [-15, "degF"],
  "fdeg_C" => [-15, "deg_C"],  "fdeg_F" => [-15, "deg_F"],
  "fdegreeC" => [-15, "degreeC"],  "fdegreeF" => [-15, "degreeF"],
  "fdegree_C" => [-15, "degree_C"],  "fdegree_E" => [-15, "degree_E"],
  "fdegree_F" => [-15, "degree_F"],  "fdegree_N" => [-15, "degree_N"],
  "fdegree_R" => [-15, "degree_R"],  "fdegree_S" => [-15, "degree_S"],
  "fdegree_W" => [-15, "degree_W"],  "fdegree_c" => [-15, "degree_c"],
  "fdegree_east" => [-15, "degree_east"],
  "fdegree_f" => [-15, "degree_f"],
  "fdegree_north" => [-15, "degree_north"],
  "fdegree_south" => [-15, "degree_south"],
  "fdegree_west" => [-15, "degree_west"],
  "fdegrees_east" => [-15, "degrees_east"],
  "fdegrees_north" => [-15, "degrees_north"],
  "fdegrees_south" => [-15, "degrees_south"],
  "fdegrees_west" => [-15, "degrees_west"],  "fdyn" => [-15, "dyn"],
  "femtoCelsius" => [-15, "Celsius"],
  "femtoFahrenheit" => [-15, "Fahrenheit"],
  "femtoJulian_year" => [-15, "Julian_year"],
  "femtoPascal" => [-15, "Pascal"],  "femtoacre" => [-15, "acre"],
  "femtoampere" => [-15, "ampere"],
  "femtoangstrom" => [-15, "angstrom"],
  "femtoangular_degree" => [-15, "angular_degree"],
  "femtoangular_minute" => [-15, "angular_minute"],
  "femtoangular_second" => [-15, "angular_second"],
  "femtoare" => [-15, "are"],  "femtoatmosphere" => [-15, "atmosphere"],
  "femtocalorie" => [-15, "calorie"],
  "femtocandela" => [-15, "candela"],
  "femtocelsius" => [-15, "celsius"],
  "femtocentigrade" => [-15, "centigrade"],
  "femtocentury" => [-15, "century"],  "femtochain" => [-15, "chain"],
  "femtocommon_year" => [-15, "common_year"],
  "femtocoulomb" => [-15, "coulomb"],  "femtoday" => [-15, "day"],
  "femtodegK" => [-15, "degK"],  "femtodeg_K" => [-15, "deg_K"],
  "femtodegree" => [-15, "degree"],  "femtodegreeK" => [-15, "degreeK"],
  "femtodyne" => [-15, "dyne"],  "femtoerg" => [-15, "erg"],
  "femtofahrenheit" => [-15, "fahrenheit"],
  "femtofarad" => [-15, "farad"],  "femtofermi" => [-15, "fermi"],
  "femtogal" => [-15, "gal"],  "femtogauss" => [-15, "gauss"],
  "femtogram" => [-15, "gram"],  "femtohectare" => [-15, "hectare"],
  "femtohertz" => [-15, "hertz"],  "femtohour" => [-15, "hour"],
  "femtoinch" => [-15, "inch"],  "femtojoule" => [-15, "joule"],
  "femtokelvin" => [-15, "kelvin"],
  "femtokilogram" => [-15, "kilogram"],  "femtoknot" => [-15, "knot"],
  "femtolitre" => [-15, "litre"],  "femtometer" => [-15, "meter"],
  "femtometre" => [-15, "metre"],  "femtomicron" => [-15, "micron"],
  "femtomile" => [-15, "mile"],  "femtomillibar" => [-15, "millibar"],
  "femtominute" => [-15, "minute"],
  "femtominute_angle" => [-15, "minute_angle"],
  "femtomole" => [-15, "mole"],  "femtomonth" => [-15, "month"],
  "femtonewton" => [-15, "newton"],  "femtoounce" => [-15, "ounce"],
  "femtoparsec" => [-15, "parsec"],  "femtopascal" => [-15, "pascal"],
  "femtopentad" => [-15, "pentad"],  "femtopercent" => [-15, "percent"],
  "femtopoise" => [-15, "poise"],  "femtopound" => [-15, "pound"],
  "femtoradian" => [-15, "radian"],  "femtosecond" => [-15, "second"],
  "femtosecond_angle" => [-15, "second_angle"],
  "femtosteradian" => [-15, "steradian"],
  "femtostokes" => [-15, "stokes"],  "femtotesla" => [-15, "tesla"],
  "femtoton" => [-15, "ton"],  "femtotonne" => [-15, "tonne"],
  "femtotorr" => [-15, "torr"],  "femtovolt" => [-15, "volt"],
  "femtowatt" => [-15, "watt"],  "femtoweber" => [-15, "weber"],
  "femtoyard" => [-15, "yard"],  "femtoyd" => [-15, "yd"],
  "femtoyear" => [-15, "year"],  "ferg" => [-15, "erg"],
  "fermis" => [0, "fermi"],  "fforce" => [-15, "force"],
  "fg" => [-15, "g"],  "fgravity" => [-15, "gravity"],
  "fh" => [-15, "h"],  "fhg" => [-15, "hg"],  "fhr" => [-15, "hr"],
  "fin" => [-15, "in"],  "fkgf" => [-15, "kgf"],
  "fkph" => [-15, "kph"],  "flb" => [-15, "lb"],  "flm" => [-15, "lm"],
  "flx" => [-15, "lx"],  "fly" => [-15, "ly"],  "fm" => [-15, "m"],
  "fmb" => [-15, "mb"],  "fmercury" => [-15, "mercury"],
  "fmgal" => [-15, "mgal"],  "fmin" => [-15, "min"],
  "fmol" => [-15, "mol"],  "fmon" => [-15, "mon"],
  "fmph" => [-15, "mph"],  "fohm" => [-15, "ohm"],
  "foz" => [-15, "oz"],  "fpc" => [-15, "pc"],  "fpsi" => [-15, "psi"],
  "frad" => [-15, "rad"],  "fs" => [-15, "s"],  "fsr" => [-15, "sr"],
  "ft" => [-15, "t"],  "fyr" => [-15, "yr"],  "gals" => [0, "gal"],
  "gausses" => [0, "gauss"],  "gigaCelsius" => [9, "Celsius"],
  "gigaFahrenheit" => [9, "Fahrenheit"],
  "gigaJulian_year" => [9, "Julian_year"],
  "gigaPascal" => [9, "Pascal"],  "gigaacre" => [9, "acre"],
  "gigaampere" => [9, "ampere"],  "gigaangstrom" => [9, "angstrom"],
  "gigaangular_degree" => [9, "angular_degree"],
  "gigaangular_minute" => [9, "angular_minute"],
  "gigaangular_second" => [9, "angular_second"],
  "gigaare" => [9, "are"],  "gigaatmosphere" => [9, "atmosphere"],
  "gigacalorie" => [9, "calorie"],  "gigacandela" => [9, "candela"],
  "gigacelsius" => [9, "celsius"],
  "gigacentigrade" => [9, "centigrade"],
  "gigacentury" => [9, "century"],  "gigachain" => [9, "chain"],
  "gigacommon_year" => [9, "common_year"],
  "gigacoulomb" => [9, "coulomb"],  "gigaday" => [9, "day"],
  "gigadegK" => [9, "degK"],  "gigadeg_K" => [9, "deg_K"],
  "gigadegree" => [9, "degree"],  "gigadegreeK" => [9, "degreeK"],
  "gigadyne" => [9, "dyne"],  "gigaerg" => [9, "erg"],
  "gigafahrenheit" => [9, "fahrenheit"],  "gigafarad" => [9, "farad"],
  "gigafermi" => [9, "fermi"],  "gigagal" => [9, "gal"],
  "gigagauss" => [9, "gauss"],  "gigagram" => [9, "gram"],
  "gigahectare" => [9, "hectare"],  "gigahertz" => [9, "hertz"],
  "gigahour" => [9, "hour"],  "gigainch" => [9, "inch"],
  "gigajoule" => [9, "joule"],  "gigakelvin" => [9, "kelvin"],
  "gigakilogram" => [9, "kilogram"],  "gigaknot" => [9, "knot"],
  "gigalitre" => [9, "litre"],  "gigameter" => [9, "meter"],
  "gigametre" => [9, "metre"],  "gigamicron" => [9, "micron"],
  "gigamile" => [9, "mile"],  "gigamillibar" => [9, "millibar"],
  "gigaminute" => [9, "minute"],
  "gigaminute_angle" => [9, "minute_angle"],  "gigamole" => [9, "mole"],
  "gigamonth" => [9, "month"],  "giganewton" => [9, "newton"],
  "gigaounce" => [9, "ounce"],  "gigaparsec" => [9, "parsec"],
  "gigapascal" => [9, "pascal"],  "gigapentad" => [9, "pentad"],
  "gigapercent" => [9, "percent"],  "gigapoise" => [9, "poise"],
  "gigapound" => [9, "pound"],  "gigaradian" => [9, "radian"],
  "gigasecond" => [9, "second"],
  "gigasecond_angle" => [9, "second_angle"],
  "gigasteradian" => [9, "steradian"],  "gigastokes" => [9, "stokes"],
  "gigatesla" => [9, "tesla"],  "gigaton" => [9, "ton"],
  "gigatonne" => [9, "tonne"],  "gigatorr" => [9, "torr"],
  "gigavolt" => [9, "volt"],  "gigawatt" => [9, "watt"],
  "gigaweber" => [9, "weber"],  "gigayard" => [9, "yard"],
  "gigayd" => [9, "yd"],  "gigayear" => [9, "year"],
  "grams" => [0, "gram"],  "hA" => [2, "A"],  "hAu" => [2, "Au"],
  "hBq" => [2, "Bq"],  "hC" => [2, "C"],  "hF" => [2, "F"],
  "hG" => [2, "G"],  "hGal" => [2, "Gal"],  "hGy" => [2, "Gy"],
  "hH" => [2, "H"],  "hHg" => [2, "Hg"],  "hHz" => [2, "Hz"],
  "hJ" => [2, "J"],  "hK" => [2, "K"],  "hL" => [2, "L"],
  "hN" => [2, "N"],  "hP" => [2, "P"],  "hPa" => [2, "Pa"],
  "hS" => [2, "S"],  "hSt" => [2, "St"],  "hSv" => [2, "Sv"],
  "hT" => [2, "T"],  "hV" => [2, "V"],  "hW" => [2, "W"],
  "hWb" => [2, "Wb"],  "ha" => [2, "a"],  "hac" => [2, "ac"],
  "hatm" => [2, "atm"],  "hbar" => [2, "bar"],  "hcal" => [2, "cal"],
  "hcd" => [2, "cd"],
  "hconventional_mercury" => [2, "conventional_mercury"],
  "hdegC" => [2, "degC"],  "hdegF" => [2, "degF"],
  "hdeg_C" => [2, "deg_C"],  "hdeg_F" => [2, "deg_F"],
  "hdegreeC" => [2, "degreeC"],  "hdegreeF" => [2, "degreeF"],
  "hdegree_C" => [2, "degree_C"],  "hdegree_E" => [2, "degree_E"],
  "hdegree_F" => [2, "degree_F"],  "hdegree_N" => [2, "degree_N"],
  "hdegree_R" => [2, "degree_R"],  "hdegree_S" => [2, "degree_S"],
  "hdegree_W" => [2, "degree_W"],  "hdegree_c" => [2, "degree_c"],
  "hdegree_east" => [2, "degree_east"],  "hdegree_f" => [2, "degree_f"],
  "hdegree_north" => [2, "degree_north"],
  "hdegree_south" => [2, "degree_south"],
  "hdegree_west" => [2, "degree_west"],
  "hdegrees_east" => [2, "degrees_east"],
  "hdegrees_north" => [2, "degrees_north"],
  "hdegrees_south" => [2, "degrees_south"],
  "hdegrees_west" => [2, "degrees_west"],  "hdyn" => [2, "dyn"],
  "hectares" => [0, "hectare"],  "hectoCelsius" => [2, "Celsius"],
  "hectoFahrenheit" => [2, "Fahrenheit"],
  "hectoJulian_year" => [2, "Julian_year"],
  "hectoPascal" => [2, "Pascal"],  "hectoacre" => [2, "acre"],
  "hectoampere" => [2, "ampere"],  "hectoangstrom" => [2, "angstrom"],
  "hectoangular_degree" => [2, "angular_degree"],
  "hectoangular_minute" => [2, "angular_minute"],
  "hectoangular_second" => [2, "angular_second"],
  "hectoare" => [2, "are"],  "hectoatmosphere" => [2, "atmosphere"],
  "hectocalorie" => [2, "calorie"],  "hectocandela" => [2, "candela"],
  "hectocelsius" => [2, "celsius"],
  "hectocentigrade" => [2, "centigrade"],
  "hectocentury" => [2, "century"],  "hectochain" => [2, "chain"],
  "hectocommon_year" => [2, "common_year"],
  "hectocoulomb" => [2, "coulomb"],  "hectoday" => [2, "day"],
  "hectodegK" => [2, "degK"],  "hectodeg_K" => [2, "deg_K"],
  "hectodegree" => [2, "degree"],  "hectodegreeK" => [2, "degreeK"],
  "hectodyne" => [2, "dyne"],  "hectoerg" => [2, "erg"],
  "hectofahrenheit" => [2, "fahrenheit"],  "hectofarad" => [2, "farad"],
  "hectofermi" => [2, "fermi"],  "hectogal" => [2, "gal"],
  "hectogauss" => [2, "gauss"],  "hectogram" => [2, "gram"],
  "hectohectare" => [2, "hectare"],  "hectohertz" => [2, "hertz"],
  "hectohour" => [2, "hour"],  "hectoinch" => [2, "inch"],
  "hectojoule" => [2, "joule"],  "hectokelvin" => [2, "kelvin"],
  "hectokilogram" => [2, "kilogram"],  "hectoknot" => [2, "knot"],
  "hectolitre" => [2, "litre"],  "hectometer" => [2, "meter"],
  "hectometre" => [2, "metre"],  "hectomicron" => [2, "micron"],
  "hectomile" => [2, "mile"],  "hectomillibar" => [2, "millibar"],
  "hectominute" => [2, "minute"],
  "hectominute_angle" => [2, "minute_angle"],
  "hectomole" => [2, "mole"],  "hectomonth" => [2, "month"],
  "hectonewton" => [2, "newton"],  "hectoounce" => [2, "ounce"],
  "hectoparsec" => [2, "parsec"],  "hectopascal" => [2, "pascal"],
  "hectopentad" => [2, "pentad"],  "hectopercent" => [2, "percent"],
  "hectopoise" => [2, "poise"],  "hectopound" => [2, "pound"],
  "hectoradian" => [2, "radian"],  "hectosecond" => [2, "second"],
  "hectosecond_angle" => [2, "second_angle"],
  "hectosteradian" => [2, "steradian"],  "hectostokes" => [2, "stokes"],
  "hectotesla" => [2, "tesla"],  "hectoton" => [2, "ton"],
  "hectotonne" => [2, "tonne"],  "hectotorr" => [2, "torr"],
  "hectovolt" => [2, "volt"],  "hectowatt" => [2, "watt"],
  "hectoweber" => [2, "weber"],  "hectoyard" => [2, "yard"],
  "hectoyd" => [2, "yd"],  "hectoyear" => [2, "year"],
  "herg" => [2, "erg"],  "hertzes" => [0, "hertz"],
  "hforce" => [2, "force"],  "hg" => [2, "g"],
  "hgravity" => [2, "gravity"],  "hh" => [2, "h"],  "hhg" => [2, "hg"],
  "hhr" => [2, "hr"],  "hin" => [2, "in"],  "hkgf" => [2, "kgf"],
  "hkph" => [2, "kph"],  "hlb" => [2, "lb"],  "hlm" => [2, "lm"],
  "hlx" => [2, "lx"],  "hly" => [2, "ly"],  "hm" => [2, "m"],
  "hmb" => [2, "mb"],  "hmercury" => [2, "mercury"],
  "hmgal" => [2, "mgal"],  "hmin" => [2, "min"],  "hmol" => [2, "mol"],
  "hmon" => [2, "mon"],  "hmph" => [2, "mph"],  "hohm" => [2, "ohm"],
  "hours" => [0, "hour"],  "hoz" => [2, "oz"],  "hpc" => [2, "pc"],
  "hpsi" => [2, "psi"],  "hrad" => [2, "rad"],  "hs" => [2, "s"],
  "hsr" => [2, "sr"],  "ht" => [2, "t"],  "hyr" => [2, "yr"],
  "inchs" => [0, "inch"],  "joules" => [0, "joule"],  "kA" => [3, "A"],
  "kAu" => [3, "Au"],  "kBq" => [3, "Bq"],  "kC" => [3, "C"],
  "kF" => [3, "F"],  "kG" => [3, "G"],  "kGal" => [3, "Gal"],
  "kGy" => [3, "Gy"],  "kH" => [3, "H"],  "kHg" => [3, "Hg"],
  "kHz" => [3, "Hz"],  "kJ" => [3, "J"],  "kK" => [3, "K"],
  "kL" => [3, "L"],  "kN" => [3, "N"],  "kP" => [3, "P"],
  "kPa" => [3, "Pa"],  "kS" => [3, "S"],  "kSt" => [3, "St"],
  "kSv" => [3, "Sv"],  "kT" => [3, "T"],  "kV" => [3, "V"],
  "kW" => [3, "W"],  "kWb" => [3, "Wb"],  "ka" => [3, "a"],
  "kac" => [3, "ac"],  "katm" => [3, "atm"],  "kbar" => [3, "bar"],
  "kcal" => [3, "cal"],  "kcd" => [3, "cd"],
  "kconventional_mercury" => [3, "conventional_mercury"],
  "kdegC" => [3, "degC"],  "kdegF" => [3, "degF"],
  "kdeg_C" => [3, "deg_C"],  "kdeg_F" => [3, "deg_F"],
  "kdegreeC" => [3, "degreeC"],  "kdegreeF" => [3, "degreeF"],
  "kdegree_C" => [3, "degree_C"],  "kdegree_E" => [3, "degree_E"],
  "kdegree_F" => [3, "degree_F"],  "kdegree_N" => [3, "degree_N"],
  "kdegree_R" => [3, "degree_R"],  "kdegree_S" => [3, "degree_S"],
  "kdegree_W" => [3, "degree_W"],  "kdegree_c" => [3, "degree_c"],
  "kdegree_east" => [3, "degree_east"],  "kdegree_f" => [3, "degree_f"],
  "kdegree_north" => [3, "degree_north"],
  "kdegree_south" => [3, "degree_south"],
  "kdegree_west" => [3, "degree_west"],
  "kdegrees_east" => [3, "degrees_east"],
  "kdegrees_north" => [3, "degrees_north"],
  "kdegrees_south" => [3, "degrees_south"],
  "kdegrees_west" => [3, "degrees_west"],  "kdyn" => [3, "dyn"],
  "kelvins" => [0, "kelvin"],  "kerg" => [3, "erg"],
  "kforce" => [3, "force"],  "kgravity" => [3, "gravity"],
  "kh" => [3, "h"],  "khg" => [3, "hg"],  "khr" => [3, "hr"],
  "kiloCelsius" => [3, "Celsius"],
  "kiloFahrenheit" => [3, "Fahrenheit"],
  "kiloJulian_year" => [3, "Julian_year"],
  "kiloPascal" => [3, "Pascal"],  "kiloacre" => [3, "acre"],
  "kiloampere" => [3, "ampere"],  "kiloangstrom" => [3, "angstrom"],
  "kiloangular_degree" => [3, "angular_degree"],
  "kiloangular_minute" => [3, "angular_minute"],
  "kiloangular_second" => [3, "angular_second"],
  "kiloare" => [3, "are"],  "kiloatmosphere" => [3, "atmosphere"],
  "kilocalorie" => [3, "calorie"],  "kilocandela" => [3, "candela"],
  "kilocelsius" => [3, "celsius"],
  "kilocentigrade" => [3, "centigrade"],
  "kilocentury" => [3, "century"],  "kilochain" => [3, "chain"],
  "kilocommon_year" => [3, "common_year"],
  "kilocoulomb" => [3, "coulomb"],  "kiloday" => [3, "day"],
  "kilodegK" => [3, "degK"],  "kilodeg_K" => [3, "deg_K"],
  "kilodegree" => [3, "degree"],  "kilodegreeK" => [3, "degreeK"],
  "kilodyne" => [3, "dyne"],  "kiloerg" => [3, "erg"],
  "kilofahrenheit" => [3, "fahrenheit"],  "kilofarad" => [3, "farad"],
  "kilofermi" => [3, "fermi"],  "kilogal" => [3, "gal"],
  "kilogauss" => [3, "gauss"],  "kilogram" => [3, "gram"],
  "kilograms" => [0, "kilogram"],  "kilohectare" => [3, "hectare"],
  "kilohertz" => [3, "hertz"],  "kilohour" => [3, "hour"],
  "kiloinch" => [3, "inch"],  "kilojoule" => [3, "joule"],
  "kilokelvin" => [3, "kelvin"],  "kilokilogram" => [3, "kilogram"],
  "kiloknot" => [3, "knot"],  "kilolitre" => [3, "litre"],
  "kilometer" => [3, "meter"],  "kilometre" => [3, "metre"],
  "kilomicron" => [3, "micron"],  "kilomile" => [3, "mile"],
  "kilomillibar" => [3, "millibar"],  "kilominute" => [3, "minute"],
  "kilominute_angle" => [3, "minute_angle"],  "kilomole" => [3, "mole"],
  "kilomonth" => [3, "month"],  "kilonewton" => [3, "newton"],
  "kiloounce" => [3, "ounce"],  "kiloparsec" => [3, "parsec"],
  "kilopascal" => [3, "pascal"],  "kilopentad" => [3, "pentad"],
  "kilopercent" => [3, "percent"],  "kilopoise" => [3, "poise"],
  "kilopound" => [3, "pound"],  "kiloradian" => [3, "radian"],
  "kilosecond" => [3, "second"],
  "kilosecond_angle" => [3, "second_angle"],
  "kilosteradian" => [3, "steradian"],  "kilostokes" => [3, "stokes"],
  "kilotesla" => [3, "tesla"],  "kiloton" => [3, "ton"],
  "kilotonne" => [3, "tonne"],  "kilotorr" => [3, "torr"],
  "kilovolt" => [3, "volt"],  "kilowatt" => [3, "watt"],
  "kiloweber" => [3, "weber"],  "kiloyard" => [3, "yard"],
  "kiloyd" => [3, "yd"],  "kiloyear" => [3, "year"],
  "kin" => [3, "in"],  "kkgf" => [3, "kgf"],  "kkph" => [3, "kph"],
  "klb" => [3, "lb"],  "klm" => [3, "lm"],  "klx" => [3, "lx"],
  "kly" => [3, "ly"],  "km" => [3, "m"],  "kmb" => [3, "mb"],
  "kmercury" => [3, "mercury"],  "kmgal" => [3, "mgal"],
  "kmin" => [3, "min"],  "kmol" => [3, "mol"],  "kmon" => [3, "mon"],
  "kmph" => [3, "mph"],  "knots" => [0, "knot"],  "kohm" => [3, "ohm"],
  "koz" => [3, "oz"],  "kpc" => [3, "pc"],  "kpsi" => [3, "psi"],
  "krad" => [3, "rad"],  "ks" => [3, "s"],  "ksr" => [3, "sr"],
  "kt" => [3, "t"],  "kyr" => [3, "yr"],  "litres" => [0, "litre"],
  "mA" => [-3, "A"],  "mAu" => [-3, "Au"],  "mBq" => [-3, "Bq"],
  "mC" => [-3, "C"],  "mF" => [-3, "F"],  "mG" => [-3, "G"],
  "mGal" => [-3, "Gal"],  "mGy" => [-3, "Gy"],  "mH" => [-3, "H"],
  "mHg" => [-3, "Hg"],  "mHz" => [-3, "Hz"],  "mJ" => [-3, "J"],
  "mK" => [-3, "K"],  "mL" => [-3, "L"],  "mN" => [-3, "N"],
  "mP" => [-3, "P"],  "mPa" => [-3, "Pa"],  "mS" => [-3, "S"],
  "mSt" => [-3, "St"],  "mSv" => [-3, "Sv"],  "mT" => [-3, "T"],
  "mV" => [-3, "V"],  "mW" => [-3, "W"],  "mWb" => [-3, "Wb"],
  "ma" => [-3, "a"],  "mac" => [-3, "ac"],  "matm" => [-3, "atm"],
  "mbar" => [-3, "bar"],  "mcal" => [-3, "cal"],  "mcd" => [-3, "cd"],
  "mconventional_mercury" => [-3, "conventional_mercury"],
  "mdegC" => [-3, "degC"],  "mdegF" => [-3, "degF"],
  "mdeg_C" => [-3, "deg_C"],  "mdeg_F" => [-3, "deg_F"],
  "mdegreeC" => [-3, "degreeC"],  "mdegreeF" => [-3, "degreeF"],
  "mdegree_C" => [-3, "degree_C"],  "mdegree_E" => [-3, "degree_E"],
  "mdegree_F" => [-3, "degree_F"],  "mdegree_N" => [-3, "degree_N"],
  "mdegree_R" => [-3, "degree_R"],  "mdegree_S" => [-3, "degree_S"],
  "mdegree_W" => [-3, "degree_W"],  "mdegree_c" => [-3, "degree_c"],
  "mdegree_east" => [-3, "degree_east"],
  "mdegree_f" => [-3, "degree_f"],
  "mdegree_north" => [-3, "degree_north"],
  "mdegree_south" => [-3, "degree_south"],
  "mdegree_west" => [-3, "degree_west"],
  "mdegrees_east" => [-3, "degrees_east"],
  "mdegrees_north" => [-3, "degrees_north"],
  "mdegrees_south" => [-3, "degrees_south"],
  "mdegrees_west" => [-3, "degrees_west"],  "mdyn" => [-3, "dyn"],
  "megaCelsius" => [6, "Celsius"],
  "megaFahrenheit" => [6, "Fahrenheit"],
  "megaJulian_year" => [6, "Julian_year"],
  "megaPascal" => [6, "Pascal"],  "megaacre" => [6, "acre"],
  "megaampere" => [6, "ampere"],  "megaangstrom" => [6, "angstrom"],
  "megaangular_degree" => [6, "angular_degree"],
  "megaangular_minute" => [6, "angular_minute"],
  "megaangular_second" => [6, "angular_second"],
  "megaare" => [6, "are"],  "megaatmosphere" => [6, "atmosphere"],
  "megacalorie" => [6, "calorie"],  "megacandela" => [6, "candela"],
  "megacelsius" => [6, "celsius"],
  "megacentigrade" => [6, "centigrade"],
  "megacentury" => [6, "century"],  "megachain" => [6, "chain"],
  "megacommon_year" => [6, "common_year"],
  "megacoulomb" => [6, "coulomb"],  "megaday" => [6, "day"],
  "megadegK" => [6, "degK"],  "megadeg_K" => [6, "deg_K"],
  "megadegree" => [6, "degree"],  "megadegreeK" => [6, "degreeK"],
  "megadyne" => [6, "dyne"],  "megaerg" => [6, "erg"],
  "megafahrenheit" => [6, "fahrenheit"],  "megafarad" => [6, "farad"],
  "megafermi" => [6, "fermi"],  "megagal" => [6, "gal"],
  "megagauss" => [6, "gauss"],  "megagram" => [6, "gram"],
  "megahectare" => [6, "hectare"],  "megahertz" => [6, "hertz"],
  "megahour" => [6, "hour"],  "megainch" => [6, "inch"],
  "megajoule" => [6, "joule"],  "megakelvin" => [6, "kelvin"],
  "megakilogram" => [6, "kilogram"],  "megaknot" => [6, "knot"],
  "megalitre" => [6, "litre"],  "megameter" => [6, "meter"],
  "megametre" => [6, "metre"],  "megamicron" => [6, "micron"],
  "megamile" => [6, "mile"],  "megamillibar" => [6, "millibar"],
  "megaminute" => [6, "minute"],
  "megaminute_angle" => [6, "minute_angle"],  "megamole" => [6, "mole"],
  "megamonth" => [6, "month"],  "meganewton" => [6, "newton"],
  "megaounce" => [6, "ounce"],  "megaparsec" => [6, "parsec"],
  "megapascal" => [6, "pascal"],  "megapentad" => [6, "pentad"],
  "megapercent" => [6, "percent"],  "megapoise" => [6, "poise"],
  "megapound" => [6, "pound"],  "megaradian" => [6, "radian"],
  "megasecond" => [6, "second"],
  "megasecond_angle" => [6, "second_angle"],
  "megasteradian" => [6, "steradian"],  "megastokes" => [6, "stokes"],
  "megatesla" => [6, "tesla"],  "megaton" => [6, "ton"],
  "megatonne" => [6, "tonne"],  "megatorr" => [6, "torr"],
  "megavolt" => [6, "volt"],  "megawatt" => [6, "watt"],
  "megaweber" => [6, "weber"],  "megayard" => [6, "yard"],
  "megayd" => [6, "yd"],  "megayear" => [6, "year"],
  "merg" => [-3, "erg"],  "meters" => [0, "meter"],
  "metres" => [0, "metre"],  "mforce" => [-3, "force"],
  "mg" => [-3, "g"],  "mgravity" => [-3, "gravity"],  "mh" => [-3, "h"],
  "mhg" => [-3, "hg"],  "mhr" => [-3, "hr"],
  "microCelsius" => [-6, "Celsius"],
  "microFahrenheit" => [-6, "Fahrenheit"],
  "microJulian_year" => [-6, "Julian_year"],
  "microPascal" => [-6, "Pascal"],  "microacre" => [-6, "acre"],
  "microampere" => [-6, "ampere"],  "microangstrom" => [-6, "angstrom"],
  "microangular_degree" => [-6, "angular_degree"],
  "microangular_minute" => [-6, "angular_minute"],
  "microangular_second" => [-6, "angular_second"],
  "microare" => [-6, "are"],  "microatmosphere" => [-6, "atmosphere"],
  "microcalorie" => [-6, "calorie"],  "microcandela" => [-6, "candela"],
  "microcelsius" => [-6, "celsius"],
  "microcentigrade" => [-6, "centigrade"],
  "microcentury" => [-6, "century"],  "microchain" => [-6, "chain"],
  "microcommon_year" => [-6, "common_year"],
  "microcoulomb" => [-6, "coulomb"],  "microday" => [-6, "day"],
  "microdegK" => [-6, "degK"],  "microdeg_K" => [-6, "deg_K"],
  "microdegree" => [-6, "degree"],  "microdegreeK" => [-6, "degreeK"],
  "microdyne" => [-6, "dyne"],  "microerg" => [-6, "erg"],
  "microfahrenheit" => [-6, "fahrenheit"],
  "microfarad" => [-6, "farad"],  "microfermi" => [-6, "fermi"],
  "microgal" => [-6, "gal"],  "microgauss" => [-6, "gauss"],
  "microgram" => [-6, "gram"],  "microhectare" => [-6, "hectare"],
  "microhertz" => [-6, "hertz"],  "microhour" => [-6, "hour"],
  "microinch" => [-6, "inch"],  "microjoule" => [-6, "joule"],
  "microkelvin" => [-6, "kelvin"],  "microkilogram" => [-6, "kilogram"],
  "microknot" => [-6, "knot"],  "microlitre" => [-6, "litre"],
  "micrometer" => [-6, "meter"],  "micrometre" => [-6, "metre"],
  "micromicron" => [-6, "micron"],  "micromile" => [-6, "mile"],
  "micromillibar" => [-6, "millibar"],  "microminute" => [-6, "minute"],
  "microminute_angle" => [-6, "minute_angle"],
  "micromole" => [-6, "mole"],  "micromonth" => [-6, "month"],
  "micronewton" => [-6, "newton"],  "microns" => [0, "micron"],
  "microounce" => [-6, "ounce"],  "microparsec" => [-6, "parsec"],
  "micropascal" => [-6, "pascal"],  "micropentad" => [-6, "pentad"],
  "micropercent" => [-6, "percent"],  "micropoise" => [-6, "poise"],
  "micropound" => [-6, "pound"],  "microradian" => [-6, "radian"],
  "microsecond" => [-6, "second"],
  "microsecond_angle" => [-6, "second_angle"],
  "microsteradian" => [-6, "steradian"],
  "microstokes" => [-6, "stokes"],  "microtesla" => [-6, "tesla"],
  "microton" => [-6, "ton"],  "microtonne" => [-6, "tonne"],
  "microtorr" => [-6, "torr"],  "microvolt" => [-6, "volt"],
  "microwatt" => [-6, "watt"],  "microweber" => [-6, "weber"],
  "microyard" => [-6, "yard"],  "microyd" => [-6, "yd"],
  "microyear" => [-6, "year"],  "miles" => [0, "mile"],
  "milliCelsius" => [-3, "Celsius"],
  "milliFahrenheit" => [-3, "Fahrenheit"],
  "milliJulian_year" => [-3, "Julian_year"],
  "milliPascal" => [-3, "Pascal"],  "milliacre" => [-3, "acre"],
  "milliampere" => [-3, "ampere"],  "milliangstrom" => [-3, "angstrom"],
  "milliangular_degree" => [-3, "angular_degree"],
  "milliangular_minute" => [-3, "angular_minute"],
  "milliangular_second" => [-3, "angular_second"],
  "milliare" => [-3, "are"],  "milliatmosphere" => [-3, "atmosphere"],
  "millibars" => [0, "millibar"],  "millicalorie" => [-3, "calorie"],
  "millicandela" => [-3, "candela"],  "millicelsius" => [-3, "celsius"],
  "millicentigrade" => [-3, "centigrade"],
  "millicentury" => [-3, "century"],  "millichain" => [-3, "chain"],
  "millicommon_year" => [-3, "common_year"],
  "millicoulomb" => [-3, "coulomb"],  "milliday" => [-3, "day"],
  "millidegK" => [-3, "degK"],  "millideg_K" => [-3, "deg_K"],
  "millidegree" => [-3, "degree"],  "millidegreeK" => [-3, "degreeK"],
  "millidyne" => [-3, "dyne"],  "millierg" => [-3, "erg"],
  "millifahrenheit" => [-3, "fahrenheit"],
  "millifarad" => [-3, "farad"],  "millifermi" => [-3, "fermi"],
  "milligal" => [-3, "gal"],  "milligauss" => [-3, "gauss"],
  "milligram" => [-3, "gram"],  "millihectare" => [-3, "hectare"],
  "millihertz" => [-3, "hertz"],  "millihour" => [-3, "hour"],
  "milliinch" => [-3, "inch"],  "millijoule" => [-3, "joule"],
  "millikelvin" => [-3, "kelvin"],  "millikilogram" => [-3, "kilogram"],
  "milliknot" => [-3, "knot"],  "millilitre" => [-3, "litre"],
  "millimeter" => [-3, "meter"],  "millimetre" => [-3, "metre"],
  "millimicron" => [-3, "micron"],  "millimile" => [-3, "mile"],
  "millimillibar" => [-3, "millibar"],  "milliminute" => [-3, "minute"],
  "milliminute_angle" => [-3, "minute_angle"],
  "millimole" => [-3, "mole"],  "millimonth" => [-3, "month"],
  "millinewton" => [-3, "newton"],  "milliounce" => [-3, "ounce"],
  "milliparsec" => [-3, "parsec"],  "millipascal" => [-3, "pascal"],
  "millipentad" => [-3, "pentad"],  "millipercent" => [-3, "percent"],
  "millipoise" => [-3, "poise"],  "millipound" => [-3, "pound"],
  "milliradian" => [-3, "radian"],  "millisecond" => [-3, "second"],
  "millisecond_angle" => [-3, "second_angle"],
  "millisteradian" => [-3, "steradian"],
  "millistokes" => [-3, "stokes"],  "millitesla" => [-3, "tesla"],
  "milliton" => [-3, "ton"],  "millitonne" => [-3, "tonne"],
  "millitorr" => [-3, "torr"],  "millivolt" => [-3, "volt"],
  "milliwatt" => [-3, "watt"],  "milliweber" => [-3, "weber"],
  "milliyard" => [-3, "yard"],  "milliyd" => [-3, "yd"],
  "milliyear" => [-3, "year"],  "min" => [-3, "in"],
  "minutes" => [0, "minute"],  "minutes_angle" => [0, "minute_angle"],
  "mkgf" => [-3, "kgf"],  "mkph" => [-3, "kph"],  "mlb" => [-3, "lb"],
  "mlm" => [-3, "lm"],  "mlx" => [-3, "lx"],  "mly" => [-3, "ly"],
  "mm" => [-3, "m"],  "mmb" => [-3, "mb"],
  "mmercury" => [-3, "mercury"],  "mmgal" => [-3, "mgal"],
  "mmin" => [-3, "min"],  "mmol" => [-3, "mol"],  "mmon" => [-3, "mon"],
  "mmph" => [-3, "mph"],  "mohm" => [-3, "ohm"],
  "moles" => [0, "mole"],  "months" => [0, "month"],
  "moz" => [-3, "oz"],  "mpc" => [-3, "pc"],  "mpsi" => [-3, "psi"],
  "mrad" => [-3, "rad"],  "ms" => [-3, "s"],  "msr" => [-3, "sr"],
  "mt" => [-3, "t"],  "myr" => [-3, "yr"],  "nA" => [-9, "A"],
  "nAu" => [-9, "Au"],  "nBq" => [-9, "Bq"],  "nC" => [-9, "C"],
  "nF" => [-9, "F"],  "nG" => [-9, "G"],  "nGal" => [-9, "Gal"],
  "nGy" => [-9, "Gy"],  "nH" => [-9, "H"],  "nHg" => [-9, "Hg"],
  "nHz" => [-9, "Hz"],  "nJ" => [-9, "J"],  "nK" => [-9, "K"],
  "nL" => [-9, "L"],  "nN" => [-9, "N"],  "nP" => [-9, "P"],
  "nPa" => [-9, "Pa"],  "nS" => [-9, "S"],  "nSt" => [-9, "St"],
  "nSv" => [-9, "Sv"],  "nT" => [-9, "T"],  "nV" => [-9, "V"],
  "nW" => [-9, "W"],  "nWb" => [-9, "Wb"],  "na" => [-9, "a"],
  "nac" => [-9, "ac"],  "nanoCelsius" => [-9, "Celsius"],
  "nanoFahrenheit" => [-9, "Fahrenheit"],
  "nanoJulian_year" => [-9, "Julian_year"],
  "nanoPascal" => [-9, "Pascal"],  "nanoacre" => [-9, "acre"],
  "nanoampere" => [-9, "ampere"],  "nanoangstrom" => [-9, "angstrom"],
  "nanoangular_degree" => [-9, "angular_degree"],
  "nanoangular_minute" => [-9, "angular_minute"],
  "nanoangular_second" => [-9, "angular_second"],
  "nanoare" => [-9, "are"],  "nanoatmosphere" => [-9, "atmosphere"],
  "nanocalorie" => [-9, "calorie"],  "nanocandela" => [-9, "candela"],
  "nanocelsius" => [-9, "celsius"],
  "nanocentigrade" => [-9, "centigrade"],
  "nanocentury" => [-9, "century"],  "nanochain" => [-9, "chain"],
  "nanocommon_year" => [-9, "common_year"],
  "nanocoulomb" => [-9, "coulomb"],  "nanoday" => [-9, "day"],
  "nanodegK" => [-9, "degK"],  "nanodeg_K" => [-9, "deg_K"],
  "nanodegree" => [-9, "degree"],  "nanodegreeK" => [-9, "degreeK"],
  "nanodyne" => [-9, "dyne"],  "nanoerg" => [-9, "erg"],
  "nanofahrenheit" => [-9, "fahrenheit"],  "nanofarad" => [-9, "farad"],
  "nanofermi" => [-9, "fermi"],  "nanogal" => [-9, "gal"],
  "nanogauss" => [-9, "gauss"],  "nanogram" => [-9, "gram"],
  "nanohectare" => [-9, "hectare"],  "nanohertz" => [-9, "hertz"],
  "nanohour" => [-9, "hour"],  "nanoinch" => [-9, "inch"],
  "nanojoule" => [-9, "joule"],  "nanokelvin" => [-9, "kelvin"],
  "nanokilogram" => [-9, "kilogram"],  "nanoknot" => [-9, "knot"],
  "nanolitre" => [-9, "litre"],  "nanometer" => [-9, "meter"],
  "nanometre" => [-9, "metre"],  "nanomicron" => [-9, "micron"],
  "nanomile" => [-9, "mile"],  "nanomillibar" => [-9, "millibar"],
  "nanominute" => [-9, "minute"],
  "nanominute_angle" => [-9, "minute_angle"],
  "nanomole" => [-9, "mole"],  "nanomonth" => [-9, "month"],
  "nanonewton" => [-9, "newton"],  "nanoounce" => [-9, "ounce"],
  "nanoparsec" => [-9, "parsec"],  "nanopascal" => [-9, "pascal"],
  "nanopentad" => [-9, "pentad"],  "nanopercent" => [-9, "percent"],
  "nanopoise" => [-9, "poise"],  "nanopound" => [-9, "pound"],
  "nanoradian" => [-9, "radian"],  "nanosecond" => [-9, "second"],
  "nanosecond_angle" => [-9, "second_angle"],
  "nanosteradian" => [-9, "steradian"],  "nanostokes" => [-9, "stokes"],
  "nanotesla" => [-9, "tesla"],  "nanoton" => [-9, "ton"],
  "nanotonne" => [-9, "tonne"],  "nanotorr" => [-9, "torr"],
  "nanovolt" => [-9, "volt"],  "nanowatt" => [-9, "watt"],
  "nanoweber" => [-9, "weber"],  "nanoyard" => [-9, "yard"],
  "nanoyd" => [-9, "yd"],  "nanoyear" => [-9, "year"],
  "natm" => [-9, "atm"],  "nbar" => [-9, "bar"],  "ncal" => [-9, "cal"],
  "ncd" => [-9, "cd"],
  "nconventional_mercury" => [-9, "conventional_mercury"],
  "ndegC" => [-9, "degC"],  "ndegF" => [-9, "degF"],
  "ndeg_C" => [-9, "deg_C"],  "ndeg_F" => [-9, "deg_F"],
  "ndegreeC" => [-9, "degreeC"],  "ndegreeF" => [-9, "degreeF"],
  "ndegree_C" => [-9, "degree_C"],  "ndegree_E" => [-9, "degree_E"],
  "ndegree_F" => [-9, "degree_F"],  "ndegree_N" => [-9, "degree_N"],
  "ndegree_R" => [-9, "degree_R"],  "ndegree_S" => [-9, "degree_S"],
  "ndegree_W" => [-9, "degree_W"],  "ndegree_c" => [-9, "degree_c"],
  "ndegree_east" => [-9, "degree_east"],
  "ndegree_f" => [-9, "degree_f"],
  "ndegree_north" => [-9, "degree_north"],
  "ndegree_south" => [-9, "degree_south"],
  "ndegree_west" => [-9, "degree_west"],
  "ndegrees_east" => [-9, "degrees_east"],
  "ndegrees_north" => [-9, "degrees_north"],
  "ndegrees_south" => [-9, "degrees_south"],
  "ndegrees_west" => [-9, "degrees_west"],  "ndyn" => [-9, "dyn"],
  "nerg" => [-9, "erg"],  "newtons" => [0, "newton"],
  "nforce" => [-9, "force"],  "ng" => [-9, "g"],
  "ngravity" => [-9, "gravity"],  "nh" => [-9, "h"],
  "nhg" => [-9, "hg"],  "nhr" => [-9, "hr"],  "nin" => [-9, "in"],
  "nkgf" => [-9, "kgf"],  "nkph" => [-9, "kph"],  "nlb" => [-9, "lb"],
  "nlm" => [-9, "lm"],  "nlx" => [-9, "lx"],  "nly" => [-9, "ly"],
  "nm" => [-9, "m"],  "nmb" => [-9, "mb"],
  "nmercury" => [-9, "mercury"],  "nmgal" => [-9, "mgal"],
  "nmin" => [-9, "min"],  "nmol" => [-9, "mol"],  "nmon" => [-9, "mon"],
  "nmph" => [-9, "mph"],  "nohm" => [-9, "ohm"],  "noz" => [-9, "oz"],
  "npc" => [-9, "pc"],  "npsi" => [-9, "psi"],  "nrad" => [-9, "rad"],
  "ns" => [-9, "s"],  "nsr" => [-9, "sr"],  "nt" => [-9, "t"],
  "nyr" => [-9, "yr"],  "ounces" => [0, "ounce"],  "pA" => [-12, "A"],
  "pAu" => [-12, "Au"],  "pBq" => [-12, "Bq"],  "pC" => [-12, "C"],
  "pF" => [-12, "F"],  "pG" => [-12, "G"],  "pGal" => [-12, "Gal"],
  "pGy" => [-12, "Gy"],  "pH" => [-12, "H"],  "pHg" => [-12, "Hg"],
  "pHz" => [-12, "Hz"],  "pJ" => [-12, "J"],  "pK" => [-12, "K"],
  "pL" => [-12, "L"],  "pN" => [-12, "N"],  "pP" => [-12, "P"],
  "pPa" => [-12, "Pa"],  "pS" => [-12, "S"],  "pSt" => [-12, "St"],
  "pSv" => [-12, "Sv"],  "pT" => [-12, "T"],  "pV" => [-12, "V"],
  "pW" => [-12, "W"],  "pWb" => [-12, "Wb"],  "pa" => [-12, "a"],
  "pac" => [-12, "ac"],  "parsecs" => [0, "parsec"],
  "pascals" => [0, "pascal"],  "patm" => [-12, "atm"],
  "pbar" => [-12, "bar"],  "pcal" => [-12, "cal"],
  "pcd" => [-12, "cd"],
  "pconventional_mercury" => [-12, "conventional_mercury"],
  "pdegC" => [-12, "degC"],  "pdegF" => [-12, "degF"],
  "pdeg_C" => [-12, "deg_C"],  "pdeg_F" => [-12, "deg_F"],
  "pdegreeC" => [-12, "degreeC"],  "pdegreeF" => [-12, "degreeF"],
  "pdegree_C" => [-12, "degree_C"],  "pdegree_E" => [-12, "degree_E"],
  "pdegree_F" => [-12, "degree_F"],  "pdegree_N" => [-12, "degree_N"],
  "pdegree_R" => [-12, "degree_R"],  "pdegree_S" => [-12, "degree_S"],
  "pdegree_W" => [-12, "degree_W"],  "pdegree_c" => [-12, "degree_c"],
  "pdegree_east" => [-12, "degree_east"],
  "pdegree_f" => [-12, "degree_f"],
  "pdegree_north" => [-12, "degree_north"],
  "pdegree_south" => [-12, "degree_south"],
  "pdegree_west" => [-12, "degree_west"],
  "pdegrees_east" => [-12, "degrees_east"],
  "pdegrees_north" => [-12, "degrees_north"],
  "pdegrees_south" => [-12, "degrees_south"],
  "pdegrees_west" => [-12, "degrees_west"],  "pdyn" => [-12, "dyn"],
  "pentads" => [0, "pentad"],  "percents" => [0, "percent"],
  "perg" => [-12, "erg"],  "petaCelsius" => [15, "Celsius"],
  "petaFahrenheit" => [15, "Fahrenheit"],
  "petaJulian_year" => [15, "Julian_year"],
  "petaPascal" => [15, "Pascal"],  "petaacre" => [15, "acre"],
  "petaampere" => [15, "ampere"],  "petaangstrom" => [15, "angstrom"],
  "petaangular_degree" => [15, "angular_degree"],
  "petaangular_minute" => [15, "angular_minute"],
  "petaangular_second" => [15, "angular_second"],
  "petaare" => [15, "are"],  "petaatmosphere" => [15, "atmosphere"],
  "petacalorie" => [15, "calorie"],  "petacandela" => [15, "candela"],
  "petacelsius" => [15, "celsius"],
  "petacentigrade" => [15, "centigrade"],
  "petacentury" => [15, "century"],  "petachain" => [15, "chain"],
  "petacommon_year" => [15, "common_year"],
  "petacoulomb" => [15, "coulomb"],  "petaday" => [15, "day"],
  "petadegK" => [15, "degK"],  "petadeg_K" => [15, "deg_K"],
  "petadegree" => [15, "degree"],  "petadegreeK" => [15, "degreeK"],
  "petadyne" => [15, "dyne"],  "petaerg" => [15, "erg"],
  "petafahrenheit" => [15, "fahrenheit"],  "petafarad" => [15, "farad"],
  "petafermi" => [15, "fermi"],  "petagal" => [15, "gal"],
  "petagauss" => [15, "gauss"],  "petagram" => [15, "gram"],
  "petahectare" => [15, "hectare"],  "petahertz" => [15, "hertz"],
  "petahour" => [15, "hour"],  "petainch" => [15, "inch"],
  "petajoule" => [15, "joule"],  "petakelvin" => [15, "kelvin"],
  "petakilogram" => [15, "kilogram"],  "petaknot" => [15, "knot"],
  "petalitre" => [15, "litre"],  "petameter" => [15, "meter"],
  "petametre" => [15, "metre"],  "petamicron" => [15, "micron"],
  "petamile" => [15, "mile"],  "petamillibar" => [15, "millibar"],
  "petaminute" => [15, "minute"],
  "petaminute_angle" => [15, "minute_angle"],
  "petamole" => [15, "mole"],  "petamonth" => [15, "month"],
  "petanewton" => [15, "newton"],  "petaounce" => [15, "ounce"],
  "petaparsec" => [15, "parsec"],  "petapascal" => [15, "pascal"],
  "petapentad" => [15, "pentad"],  "petapercent" => [15, "percent"],
  "petapoise" => [15, "poise"],  "petapound" => [15, "pound"],
  "petaradian" => [15, "radian"],  "petasecond" => [15, "second"],
  "petasecond_angle" => [15, "second_angle"],
  "petasteradian" => [15, "steradian"],  "petastokes" => [15, "stokes"],
  "petatesla" => [15, "tesla"],  "petaton" => [15, "ton"],
  "petatonne" => [15, "tonne"],  "petatorr" => [15, "torr"],
  "petavolt" => [15, "volt"],  "petawatt" => [15, "watt"],
  "petaweber" => [15, "weber"],  "petayard" => [15, "yard"],
  "petayd" => [15, "yd"],  "petayear" => [15, "year"],
  "pforce" => [-12, "force"],  "pg" => [-12, "g"],
  "pgravity" => [-12, "gravity"],  "ph" => [-12, "h"],
  "phg" => [-12, "hg"],  "phr" => [-12, "hr"],
  "picoCelsius" => [-12, "Celsius"],
  "picoFahrenheit" => [-12, "Fahrenheit"],
  "picoJulian_year" => [-12, "Julian_year"],
  "picoPascal" => [-12, "Pascal"],  "picoacre" => [-12, "acre"],
  "picoampere" => [-12, "ampere"],  "picoangstrom" => [-12, "angstrom"],
  "picoangular_degree" => [-12, "angular_degree"],
  "picoangular_minute" => [-12, "angular_minute"],
  "picoangular_second" => [-12, "angular_second"],
  "picoare" => [-12, "are"],  "picoatmosphere" => [-12, "atmosphere"],
  "picocalorie" => [-12, "calorie"],  "picocandela" => [-12, "candela"],
  "picocelsius" => [-12, "celsius"],
  "picocentigrade" => [-12, "centigrade"],
  "picocentury" => [-12, "century"],  "picochain" => [-12, "chain"],
  "picocommon_year" => [-12, "common_year"],
  "picocoulomb" => [-12, "coulomb"],  "picoday" => [-12, "day"],
  "picodegK" => [-12, "degK"],  "picodeg_K" => [-12, "deg_K"],
  "picodegree" => [-12, "degree"],  "picodegreeK" => [-12, "degreeK"],
  "picodyne" => [-12, "dyne"],  "picoerg" => [-12, "erg"],
  "picofahrenheit" => [-12, "fahrenheit"],
  "picofarad" => [-12, "farad"],  "picofermi" => [-12, "fermi"],
  "picogal" => [-12, "gal"],  "picogauss" => [-12, "gauss"],
  "picogram" => [-12, "gram"],  "picohectare" => [-12, "hectare"],
  "picohertz" => [-12, "hertz"],  "picohour" => [-12, "hour"],
  "picoinch" => [-12, "inch"],  "picojoule" => [-12, "joule"],
  "picokelvin" => [-12, "kelvin"],  "picokilogram" => [-12, "kilogram"],
  "picoknot" => [-12, "knot"],  "picolitre" => [-12, "litre"],
  "picometer" => [-12, "meter"],  "picometre" => [-12, "metre"],
  "picomicron" => [-12, "micron"],  "picomile" => [-12, "mile"],
  "picomillibar" => [-12, "millibar"],  "picominute" => [-12, "minute"],
  "picominute_angle" => [-12, "minute_angle"],
  "picomole" => [-12, "mole"],  "picomonth" => [-12, "month"],
  "piconewton" => [-12, "newton"],  "picoounce" => [-12, "ounce"],
  "picoparsec" => [-12, "parsec"],  "picopascal" => [-12, "pascal"],
  "picopentad" => [-12, "pentad"],  "picopercent" => [-12, "percent"],
  "picopoise" => [-12, "poise"],  "picopound" => [-12, "pound"],
  "picoradian" => [-12, "radian"],  "picosecond" => [-12, "second"],
  "picosecond_angle" => [-12, "second_angle"],
  "picosteradian" => [-12, "steradian"],
  "picostokes" => [-12, "stokes"],  "picotesla" => [-12, "tesla"],
  "picoton" => [-12, "ton"],  "picotonne" => [-12, "tonne"],
  "picotorr" => [-12, "torr"],  "picovolt" => [-12, "volt"],
  "picowatt" => [-12, "watt"],  "picoweber" => [-12, "weber"],
  "picoyard" => [-12, "yard"],  "picoyd" => [-12, "yd"],
  "picoyear" => [-12, "year"],  "pin" => [-12, "in"],
  "pkgf" => [-12, "kgf"],  "pkph" => [-12, "kph"],
  "plb" => [-12, "lb"],  "plm" => [-12, "lm"],  "plx" => [-12, "lx"],
  "ply" => [-12, "ly"],  "pm" => [-12, "m"],  "pmb" => [-12, "mb"],
  "pmercury" => [-12, "mercury"],  "pmgal" => [-12, "mgal"],
  "pmin" => [-12, "min"],  "pmol" => [-12, "mol"],
  "pmon" => [-12, "mon"],  "pmph" => [-12, "mph"],
  "pohm" => [-12, "ohm"],  "poises" => [0, "poise"],
  "pounds" => [0, "pound"],  "poz" => [-12, "oz"],
  "ppc" => [-12, "pc"],  "ppsi" => [-12, "psi"],
  "prad" => [-12, "rad"],  "ps" => [-12, "s"],  "psr" => [-12, "sr"],
  "pt" => [-12, "t"],  "pyr" => [-12, "yr"],
  "radians" => [0, "radian"],  "seconds" => [0, "second"],
  "seconds_angle" => [0, "second_angle"],
  "steradians" => [0, "steradian"],  "stokeses" => [0, "stokes"],
  "telaCelsius" => [12, "Celsius"],
  "telaFahrenheit" => [12, "Fahrenheit"],
  "telaJulian_year" => [12, "Julian_year"],
  "telaPascal" => [12, "Pascal"],  "telaacre" => [12, "acre"],
  "telaampere" => [12, "ampere"],  "telaangstrom" => [12, "angstrom"],
  "telaangular_degree" => [12, "angular_degree"],
  "telaangular_minute" => [12, "angular_minute"],
  "telaangular_second" => [12, "angular_second"],
  "telaare" => [12, "are"],  "telaatmosphere" => [12, "atmosphere"],
  "telacalorie" => [12, "calorie"],  "telacandela" => [12, "candela"],
  "telacelsius" => [12, "celsius"],
  "telacentigrade" => [12, "centigrade"],
  "telacentury" => [12, "century"],  "telachain" => [12, "chain"],
  "telacommon_year" => [12, "common_year"],
  "telacoulomb" => [12, "coulomb"],  "teladay" => [12, "day"],
  "teladegK" => [12, "degK"],  "teladeg_K" => [12, "deg_K"],
  "teladegree" => [12, "degree"],  "teladegreeK" => [12, "degreeK"],
  "teladyne" => [12, "dyne"],  "telaerg" => [12, "erg"],
  "telafahrenheit" => [12, "fahrenheit"],  "telafarad" => [12, "farad"],
  "telafermi" => [12, "fermi"],  "telagal" => [12, "gal"],
  "telagauss" => [12, "gauss"],  "telagram" => [12, "gram"],
  "telahectare" => [12, "hectare"],  "telahertz" => [12, "hertz"],
  "telahour" => [12, "hour"],  "telainch" => [12, "inch"],
  "telajoule" => [12, "joule"],  "telakelvin" => [12, "kelvin"],
  "telakilogram" => [12, "kilogram"],  "telaknot" => [12, "knot"],
  "telalitre" => [12, "litre"],  "telameter" => [12, "meter"],
  "telametre" => [12, "metre"],  "telamicron" => [12, "micron"],
  "telamile" => [12, "mile"],  "telamillibar" => [12, "millibar"],
  "telaminute" => [12, "minute"],
  "telaminute_angle" => [12, "minute_angle"],
  "telamole" => [12, "mole"],  "telamonth" => [12, "month"],
  "telanewton" => [12, "newton"],  "telaounce" => [12, "ounce"],
  "telaparsec" => [12, "parsec"],  "telapascal" => [12, "pascal"],
  "telapentad" => [12, "pentad"],  "telapercent" => [12, "percent"],
  "telapoise" => [12, "poise"],  "telapound" => [12, "pound"],
  "telaradian" => [12, "radian"],  "telasecond" => [12, "second"],
  "telasecond_angle" => [12, "second_angle"],
  "telasteradian" => [12, "steradian"],  "telastokes" => [12, "stokes"],
  "telatesla" => [12, "tesla"],  "telaton" => [12, "ton"],
  "telatonne" => [12, "tonne"],  "telatorr" => [12, "torr"],
  "telavolt" => [12, "volt"],  "telawatt" => [12, "watt"],
  "telaweber" => [12, "weber"],  "telayard" => [12, "yard"],
  "telayd" => [12, "yd"],  "telayear" => [12, "year"],
  "teslas" => [0, "tesla"],  "tonnes" => [0, "tonne"],
  "tons" => [0, "ton"],  "torrs" => [0, "torr"],  "uA" => [-6, "A"],
  "uAu" => [-6, "Au"],  "uBq" => [-6, "Bq"],  "uC" => [-6, "C"],
  "uF" => [-6, "F"],  "uG" => [-6, "G"],  "uGal" => [-6, "Gal"],
  "uGy" => [-6, "Gy"],  "uH" => [-6, "H"],  "uHg" => [-6, "Hg"],
  "uHz" => [-6, "Hz"],  "uJ" => [-6, "J"],  "uK" => [-6, "K"],
  "uL" => [-6, "L"],  "uN" => [-6, "N"],  "uP" => [-6, "P"],
  "uPa" => [-6, "Pa"],  "uS" => [-6, "S"],  "uSt" => [-6, "St"],
  "uSv" => [-6, "Sv"],  "uT" => [-6, "T"],  "uV" => [-6, "V"],
  "uW" => [-6, "W"],  "uWb" => [-6, "Wb"],  "ua" => [-6, "a"],
  "uac" => [-6, "ac"],  "uatm" => [-6, "atm"],  "ubar" => [-6, "bar"],
  "ucal" => [-6, "cal"],  "ucd" => [-6, "cd"],
  "uconventional_mercury" => [-6, "conventional_mercury"],
  "udegC" => [-6, "degC"],  "udegF" => [-6, "degF"],
  "udeg_C" => [-6, "deg_C"],  "udeg_F" => [-6, "deg_F"],
  "udegreeC" => [-6, "degreeC"],  "udegreeF" => [-6, "degreeF"],
  "udegree_C" => [-6, "degree_C"],  "udegree_E" => [-6, "degree_E"],
  "udegree_F" => [-6, "degree_F"],  "udegree_N" => [-6, "degree_N"],
  "udegree_R" => [-6, "degree_R"],  "udegree_S" => [-6, "degree_S"],
  "udegree_W" => [-6, "degree_W"],  "udegree_c" => [-6, "degree_c"],
  "udegree_east" => [-6, "degree_east"],
  "udegree_f" => [-6, "degree_f"],
  "udegree_north" => [-6, "degree_north"],
  "udegree_south" => [-6, "degree_south"],
  "udegree_west" => [-6, "degree_west"],
  "udegrees_east" => [-6, "degrees_east"],
  "udegrees_north" => [-6, "degrees_north"],
  "udegrees_south" => [-6, "degrees_south"],
  "udegrees_west" => [-6, "degrees_west"],  "udyn" => [-6, "dyn"],
  "uerg" => [-6, "erg"],  "uforce" => [-6, "force"],  "ug" => [-6, "g"],
  "ugravity" => [-6, "gravity"],  "uh" => [-6, "h"],
  "uhg" => [-6, "hg"],  "uhr" => [-6, "hr"],  "uin" => [-6, "in"],
  "ukgf" => [-6, "kgf"],  "ukph" => [-6, "kph"],  "ulb" => [-6, "lb"],
  "ulm" => [-6, "lm"],  "ulx" => [-6, "lx"],  "uly" => [-6, "ly"],
  "um" => [-6, "m"],  "umb" => [-6, "mb"],
  "umercury" => [-6, "mercury"],  "umgal" => [-6, "mgal"],
  "umin" => [-6, "min"],  "umol" => [-6, "mol"],  "umon" => [-6, "mon"],
  "umph" => [-6, "mph"],  "uohm" => [-6, "ohm"],  "uoz" => [-6, "oz"],
  "upc" => [-6, "pc"],  "upsi" => [-6, "psi"],  "urad" => [-6, "rad"],
  "us" => [-6, "s"],  "usr" => [-6, "sr"],  "ut" => [-6, "t"],
  "uyr" => [-6, "yr"],  "volts" => [0, "volt"],  "watts" => [0, "watt"],
  "webers" => [0, "weber"],  "yards" => [0, "yard"],
  "yds" => [0, "yd"],  "years" => [0, "year"],
}
UPLURALS = {
  "Celsiuses" => "Celsius",  "Fahrenheits" => "Fahrenheit",
  "Julians_year" => "Julian_year",  "Pascals" => "Pascal",
  "acres" => "acre",  "amperes" => "ampere",  "angstroms" => "angstrom",
  "angulars_degree" => "angular_degree",
  "angulars_minute" => "angular_minute",
  "angulars_second" => "angular_second",  "ares" => "are",
  "atmospheres" => "atmosphere",  "calories" => "calorie",
  "candelas" => "candela",  "celsiuses" => "celsius",
  "centigrades" => "centigrade",  "centuries" => "century",
  "chains" => "chain",  "commons_year" => "common_year",
  "coulombs" => "coulomb",  "days" => "day",  "degKs" => "degK",
  "degreeKs" => "degreeK",  "degrees" => "degree",  "degs_K" => "deg_K",
  "dynes" => "dyne",  "ergs" => "erg",  "fahrenheits" => "fahrenheit",
  "farads" => "farad",  "fermis" => "fermi",  "gals" => "gal",
  "gausses" => "gauss",  "grams" => "gram",  "hectares" => "hectare",
  "hertzes" => "hertz",  "hours" => "hour",  "inchs" => "inch",
  "joules" => "joule",  "kelvins" => "kelvin",
  "kilograms" => "kilogram",  "knots" => "knot",  "litres" => "litre",
  "meters" => "meter",  "metres" => "metre",  "microns" => "micron",
  "miles" => "mile",  "millibars" => "millibar",  "minutes" => "minute",
  "minutes_angle" => "minute_angle",  "moles" => "mole",
  "months" => "month",  "newtons" => "newton",  "ounces" => "ounce",
  "parsecs" => "parsec",  "pascals" => "pascal",  "pentads" => "pentad",
  "percents" => "percent",  "poises" => "poise",  "pounds" => "pound",
  "radians" => "radian",  "seconds" => "second",
  "seconds_angle" => "second_angle",  "steradians" => "steradian",
  "stokeses" => "stokes",  "teslas" => "tesla",  "tonnes" => "tonne",
  "tons" => "ton",  "torrs" => "torr",  "volts" => "volt",
  "watts" => "watt",  "webers" => "weber",  "yards" => "yard",
  "yds" => "yd",  "years" => "year",
}
end
