# Copyright (c) 2006-2024 Broadcom. All Rights Reserved.
# Broadcom Confidential. The term "Broadcom" refers to Broadcom Inc.
# and/or its subsidiaries.

# ******* WARNING - AUTO GENERATED CODE - DO NOT EDIT *******

from typing import NoReturn
from typing import Optional

from pyVmomi.VmomiSupport import ManagedObject

from pyVmomi.vim import ClusterComputeResource
from pyVmomi.vim import Task

from pyVmomi.vim.cluster import VsanIscsiInitiatorGroup
from pyVmomi.vim.cluster import VsanIscsiLUN
from pyVmomi.vim.cluster import VsanIscsiLUNSpec
from pyVmomi.vim.cluster import VsanIscsiTarget
from pyVmomi.vim.cluster import VsanIscsiTargetSpec
from pyVmomi.vim.cluster import VsanObjectInformation

class VsanIscsiTargetSystem(ManagedObject):
   def QueryIscsiTargetServiceVersion(self) -> str: ...
   def GetHomeObject(self, cluster: ClusterComputeResource) -> VsanObjectInformation: ...
   def GetIscsiTargets(self, cluster: ClusterComputeResource) -> list[VsanIscsiTarget]: ...
   def GetIscsiTarget(self, cluster: ClusterComputeResource, targetAlias: str) -> Optional[VsanIscsiTarget]: ...
   def AddIscsiTarget(self, cluster: ClusterComputeResource, targetSpec: VsanIscsiTargetSpec) -> Optional[Task]: ...
   def EditIscsiTarget(self, cluster: ClusterComputeResource, targetSpec: VsanIscsiTargetSpec) -> Optional[Task]: ...
   def RemoveIscsiTarget(self, cluster: ClusterComputeResource, targetAlias: str) -> Optional[Task]: ...
   def GetIscsiLUNs(self, cluster: ClusterComputeResource, targetAliases: list[str]) -> list[VsanIscsiLUN]: ...
   def GetIscsiLUN(self, cluster: ClusterComputeResource, targetAlias: str, lunId: int) -> Optional[VsanIscsiLUN]: ...
   def AddIscsiLUN(self, cluster: ClusterComputeResource, targetAlias: str, lunSpec: VsanIscsiLUNSpec) -> Optional[Task]: ...
   def EditIscsiLUN(self, cluster: ClusterComputeResource, targetAlias: str, lunSpec: VsanIscsiLUNSpec) -> Optional[Task]: ...
   def RemoveIscsiLUN(self, cluster: ClusterComputeResource, targetAlias: str, lunId: int) -> Optional[Task]: ...
   def AddIscsiInitiatorsToTarget(self, cluster: ClusterComputeResource, targetAlias: str, initiatorNames: list[str]) -> NoReturn: ...
   def RemoveIscsiInitiatorsFromTarget(self, cluster: ClusterComputeResource, targetAlias: str, initiatorNames: list[str]) -> NoReturn: ...
   def GetIscsiInitiatorGroups(self, cluster: ClusterComputeResource) -> list[VsanIscsiInitiatorGroup]: ...
   def GetIscsiInitiatorGroup(self, cluster: ClusterComputeResource, initiatorGroupName: str) -> Optional[VsanIscsiInitiatorGroup]: ...
   def AddIscsiInitiatorGroup(self, cluster: ClusterComputeResource, initiatorGroupName: str) -> NoReturn: ...
   def RemoveIscsiInitiatorGroup(self, cluster: ClusterComputeResource, initiatorGroupName: str) -> NoReturn: ...
   def AddIscsiInitiatorsToGroup(self, cluster: ClusterComputeResource, initiatorGroupName: str, initiatorNames: list[str]) -> NoReturn: ...
   def RemoveIscsiInitiatorsFromGroup(self, cluster: ClusterComputeResource, initiatorGroupName: str, initiatorNames: list[str]) -> NoReturn: ...
   def AddIscsiTargetToGroup(self, cluster: ClusterComputeResource, initiatorGroupName: str, targetAlias: str) -> NoReturn: ...
   def RemoveIscsiTargetFromGroup(self, cluster: ClusterComputeResource, initiatorGroupName: str, targetAlias: str) -> NoReturn: ...
   def RemediateIscsiLunsRuntimeStatus(self, cluster: ClusterComputeResource) -> Task: ...
