/*
Copyright 2015, 2016 OpenMarket Ltd

Licensed under the Apache License, Version 2.0 (the "License");
you may not use this file except in compliance with the License.
You may obtain a copy of the License at

    http://www.apache.org/licenses/LICENSE-2.0

Unless required by applicable law or agreed to in writing, software
distributed under the License is distributed on an "AS IS" BASIS,
WITHOUT WARRANTIES OR CONDITIONS OF ANY KIND, either express or implied.
See the License for the specific language governing permissions and
limitations under the License.
*/

/**
 * A mock implementation of the webstorage api
 * @constructor
 */
function MockStorageApi() {
    this.data = {};
    this.keys = [];
    this.length = 0;
}

MockStorageApi.prototype = {
    setItem: function(k, v) {
        this.data[k] = v;
        this._recalc();
    },
    getItem: function(k) {
        return this.data[k] || null;
    },
    removeItem: function(k) {
        delete this.data[k];
        this._recalc();
    },
    key: function(index) {
        return this.keys[index];
    },
    _recalc: function() {
        const keys = [];
        for (const k in this.data) {
            if (!this.data.hasOwnProperty(k)) {
                continue;
            }
            keys.push(k);
        }
        this.keys = keys;
        this.length = keys.length;
    },
};

/** */
module.exports = MockStorageApi;
