/*
 * JBoss, the OpenSource J2EE webOS
 *
 * Distributable under LGPL license.
 * See terms of license at gnu.org.
 */
package org.jboss.cache.eviction;

import org.jboss.cache.Region;


/**
 * @author Daniel Huang
 * @version $Revision: 5671 $
 */
public class ElementSizeAlgorithm extends BaseSortedEvictionAlgorithm
{
   @Override
   protected EvictionQueue setupEvictionQueue(Region region) throws EvictionException
   {
      return new ElementSizeQueue();
   }

   @Override
   protected boolean shouldEvictNode(NodeEntry ne)
   {
      // check the minimum time to live and see if we should not evict the node.  This check will
      // ensure that, if configured, nodes are kept alive for at least a minimum period of time.
      if (isYoungerThanMinimumTimeToLive(ne)) return false;

      ElementSizeConfiguration config = (ElementSizeConfiguration) region.getEvictionPolicyConfig();

      int size = this.getEvictionQueue().getNumberOfNodes();
      return config.getMaxNodes() != 0 && size > config.getMaxNodes() || ne.getNumberOfElements() > config.getMaxElementsPerNode();
   }

   @Override
   protected void prune() throws EvictionException
   {
      super.prune();

      // clean up the Queue's eviction removals
      ((ElementSizeQueue) this.evictionQueue).prune();
   }

}
