/*
 * @(#)AutoDocLogUTestI.java
 *
 * Copyright (C) 2002-2003 Matt Albrecht
 * groboclown@users.sourceforge.net
 * http://groboutils.sourceforge.net
 *
 *  Permission is hereby granted, free of charge, to any person obtaining a
 *  copy of this software and associated documentation files (the "Software"),
 *  to deal in the Software without restriction, including without limitation
 *  the rights to use, copy, modify, merge, publish, distribute, sublicense,
 *  and/or sell copies of the Software, and to permit persons to whom the 
 *  Software is furnished to do so, subject to the following conditions:
 *
 *  The above copyright notice and this permission notice shall be included in 
 *  all copies or substantial portions of the Software. 
 *
 *  THE SOFTWARE IS PROVIDED "AS IS", WITHOUT WARRANTY OF ANY KIND, EXPRESS OR 
 *  IMPLIED, INCLUDING BUT NOT LIMITED TO THE WARRANTIES OF MERCHANTABILITY, 
 *  FITNESS FOR A PARTICULAR PURPOSE AND NONINFRINGEMENT.  IN NO EVENT SHALL 
 *  THE AUTHORS OR COPYRIGHT HOLDERS BE LIABLE FOR ANY CLAIM, DAMAGES OR OTHER 
 *  LIABILITY, WHETHER IN AN ACTION OF CONTRACT, TORT OR OTHERWISE, ARISING 
 *  FROM, OUT OF OR IN CONNECTION WITH THE SOFTWARE OR THE USE OR OTHER 
 *  DEALINGS IN THE SOFTWARE.
 */

package net.sourceforge.groboutils.autodoc.v1;

//import net.sourceforge.groboutils.testing.junitlog.v1.*;
import org.easymock.EasyMock;
import org.easymock.MockControl;
import net.sourceforge.groboutils.junit.v1.iftc.*;
import junit.framework.Test;
import junit.framework.TestCase;
import junit.framework.TestSuite;


/**
 * Tests the AutoDocLog interface.
 *
 * @author    Matt Albrecht <a href="mailto:groboclown@users.sourceforge.net">groboclown@users.sourceforge.net</a>
 * @version   $Date: 2003/02/10 22:52:14 $
 * @since     March 27, 2002
 */
public class AutoDocLogUTestI extends InterfaceTestCase
{
    //-------------------------------------------------------------------------
    // Standard JUnit Class-specific declarations
    
    private static final Class THIS_CLASS = AutoDocLogUTestI.class;
//    private static final IJUnitDocumentor LOG = (new JUnitLog(THIS_CLASS)).getDocumentor();
    
    public AutoDocLogUTestI( String name, ImplFactory f )
    {
        super( name, AutoDocLog.class, f );
    }

    
    public AutoDocLog createAutoDocLog()
    {
        return (AutoDocLog)createImplObject();
    }


    //-------------------------------------------------------------------------
    // Tests
    
    public void testDebug1()
    {
        createAutoDocLog().debug( (Object)null );
    }
    
    public void testDebug2()
    {
        createAutoDocLog().debug( "test message" );
    }
    
    public void testDebug3()
    {
        createAutoDocLog().debug( (Object[])null );
    }
    
    public void testDebug4()
    {
        createAutoDocLog().debug( new Object[2] );
    }
    
    public void testDebug4a()
    {
        createAutoDocLog().debug( new Object[0] );
    }
    
    public void testDebug5()
    {
        createAutoDocLog().debug( new Object[] { "a", null, new Integer(1) } );
    }
    
    public void testDebug5a()
    {
        createAutoDocLog().debug( new Object[] { "a", "b", new Integer(1) } );
    }
    
    public void testDebug6()
    {
        createAutoDocLog().debug( (Object)null, null );
    }
    
    public void testDebug7()
    {
        createAutoDocLog().debug( (Object)null, new Throwable("ignore") );
    }
    
    public void testDebug8()
    {
        createAutoDocLog().debug( new Object(), null );
    }
    
    public void testDebug9()
    {
        createAutoDocLog().debug( new Object(), new Throwable("ignore") );
    }

    public void testDebug10()
    {
        createAutoDocLog().debug( (Object[])null, null );
    }
    
    public void testDebug11()
    {
        createAutoDocLog().debug( new Object[2], null );
    }
    
    public void testDebug12()
    {
        createAutoDocLog().debug( new Object[0], null );
    }
    
    public void testDebug13()
    {
        createAutoDocLog().debug( new Object[] { "a", null, "b" }, null );
    }
    
    public void testDebug13a()
    {
        createAutoDocLog().debug( new Object[] { "a", "b" }, null );
    }

    public void testDebug14()
    {
        createAutoDocLog().debug( (Object[])null, new Throwable("ignore") );
    }
    
    public void testDebug15()
    {
        createAutoDocLog().debug( new Object[2], new Throwable("ignore") );
    }
    
    public void testDebug16()
    {
        createAutoDocLog().debug( new Object[0], new Throwable("ignore") );
    }
    
    public void testDebug17()
    {
        createAutoDocLog().debug( new Object[] { "a", null, "b" },
            new Throwable("ignore") );
    }
    
    public void testDebug18()
    {
        createAutoDocLog().debug( new Object[] { "a", "b" },
            new Throwable("ignore") );
    }
    
    
    //-------------------------------------------------------------------------
    
    public void testInfo1()
    {
        createAutoDocLog().info( (Object)null );
    }
    
    public void testInfo2()
    {
        createAutoDocLog().info( "test message" );
    }
    
    public void testInfo3()
    {
        createAutoDocLog().info( (Object[])null );
    }
    
    public void testInfo4()
    {
        createAutoDocLog().info( new Object[2] );
    }
    
    public void testInfo5()
    {
        createAutoDocLog().info( new Object[0] );
    }
    
    public void testInfo6()
    {
        createAutoDocLog().info( new Object[] { "a", null, new Integer(1) } );
    }
    
    public void testInfo7()
    {
        createAutoDocLog().info( new Object[] { "a", "b", new Integer(1) } );
    }
    
    public void testInfo8()
    {
        createAutoDocLog().info( (Object)null, null );
    }
    
    public void testInfo9()
    {
        createAutoDocLog().info( (Object)null, new Throwable("ignore") );
    }
    
    public void testInfo10()
    {
        createAutoDocLog().info( new Object(), null );
    }
    
    public void testInfo11()
    {
        createAutoDocLog().info( new Object(), new Throwable("ignore") );
    }

    public void testInfo12()
    {
        createAutoDocLog().info( (Object[])null, null );
    }
    
    public void testInfo13()
    {
        createAutoDocLog().info( new Object[2], null );
    }
    
    public void testInfo14()
    {
        createAutoDocLog().info( new Object[0], null );
    }
    
    public void testInfo15()
    {
        createAutoDocLog().info( new Object[] { "a", null, "b" }, null );
    }
    
    public void testInfo16()
    {
        createAutoDocLog().info( new Object[] { "a", "b" }, null );
    }

    public void testInfo17()
    {
        createAutoDocLog().info( (Object[])null, new Throwable("ignore") );
    }
    
    public void testInfo18()
    {
        createAutoDocLog().info( new Object[2], new Throwable("ignore") );
    }
    
    public void testInfo19()
    {
        createAutoDocLog().info( new Object[0], new Throwable("ignore") );
    }
    
    public void testInfo20()
    {
        createAutoDocLog().info( new Object[] { "a", null, "b" },
            new Throwable("ignore") );
    }
    
    public void testInfo21()
    {
        createAutoDocLog().info( new Object[] { "a", "b" },
            new Throwable("ignore") );
    }


    
    
    //-------------------------------------------------------------------------
    
    public void testWarn1()
    {
        createAutoDocLog().warn( (Object)null );
    }
    
    public void testWarn2()
    {
        createAutoDocLog().warn( "test message" );
    }
    
    public void testWarn3()
    {
        createAutoDocLog().warn( (Object[])null );
    }
    
    public void testWarn4()
    {
        createAutoDocLog().warn( new Object[2] );
    }
    
    public void testWarn5()
    {
        createAutoDocLog().warn( new Object[0] );
    }
    
    public void testWarn6()
    {
        createAutoDocLog().warn( new Object[] { "a", null, new Integer(1) } );
    }
    
    public void testWarn7()
    {
        createAutoDocLog().warn( new Object[] { "a", "b", new Integer(1) } );
    }
    
    public void testWarn8()
    {
        createAutoDocLog().warn( (Object)null, null );
    }
    
    public void testWarn9()
    {
        createAutoDocLog().warn( (Object)null, new Throwable("ignore") );
    }
    
    public void testWarn10()
    {
        createAutoDocLog().warn( new Object(), null );
    }
    
    public void testWarn11()
    {
        createAutoDocLog().warn( new Object(), new Throwable("ignore") );
    }

    public void testWarn12()
    {
        createAutoDocLog().warn( (Object[])null, null );
    }
    
    public void testWarn13()
    {
        createAutoDocLog().warn( new Object[2], null );
    }
    
    public void testWarn14()
    {
        createAutoDocLog().warn( new Object[0], null );
    }
    
    public void testWarn15()
    {
        createAutoDocLog().warn( new Object[] { "a", null, "b" }, null );
    }
    
    public void testWarn16()
    {
        createAutoDocLog().warn( new Object[] { "a", "b" }, null );
    }

    public void testWarn17()
    {
        createAutoDocLog().warn( (Object[])null, new Throwable("ignore") );
    }
    
    public void testWarn18()
    {
        createAutoDocLog().warn( new Object[2], new Throwable("ignore") );
    }
    
    public void testWarn19()
    {
        createAutoDocLog().warn( new Object[0], new Throwable("ignore") );
    }
    
    public void testWarn20()
    {
        createAutoDocLog().warn( new Object[] { "a", null, "b" },
            new Throwable("ignore") );
    }
    
    public void testWarn21()
    {
        createAutoDocLog().warn( new Object[] { "a", "b" },
            new Throwable("ignore") );
    }
    
    
    
    //-------------------------------------------------------------------------
    // Standard JUnit declarations
    
    
    public static InterfaceTestSuite suite()
    {
        InterfaceTestSuite suite = new InterfaceTestSuite( THIS_CLASS );
        
        return suite;
    }
    
    public static void main( String[] args )
    {
        String[] name = { THIS_CLASS.getName() };
        
        // junit.textui.TestRunner.main( name );
        // junit.swingui.TestRunner.main( name );
        
        junit.textui.TestRunner.main( name );
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void setUp() throws Exception
    {
        super.setUp();
        
        // set ourself up
    }
    
    
    /**
     * 
     * @exception Exception thrown under any exceptional condition.
     */
    protected void tearDown() throws Exception
    {
        // tear ourself down
        
        
        super.tearDown();
    }
}

