// Autogenerated AST node
package org.python.antlr.ast;

import org.antlr.runtime.Token;
import org.python.antlr.AST;
import org.python.antlr.PythonTree;
import org.python.antlr.adapter.AstAdapters;
import org.python.antlr.base.expr;
import org.python.core.ArgParser;
import org.python.core.Py;
import org.python.core.PyObject;
import org.python.core.PyString;
import org.python.core.PyStringMap;
import org.python.core.PyType;
import org.python.core.Visitproc;
import org.python.expose.ExposedGet;
import org.python.expose.ExposedMethod;
import org.python.expose.ExposedNew;
import org.python.expose.ExposedSet;
import org.python.expose.ExposedType;

@ExposedType(name = "_ast.keyword", base = AST.class)
public class keyword extends PythonTree {
    public static final PyType TYPE = PyType.fromClass(keyword.class);
    private String arg;
    public String getInternalArg() {
        return arg;
    }
    @ExposedGet(name = "arg")
    public PyObject getArg() {
        if (arg == null) return Py.None;
        return new PyString(arg);
    }
    @ExposedSet(name = "arg")
    public void setArg(PyObject arg) {
        this.arg = AstAdapters.py2identifier(arg);
    }

    private expr value;
    public expr getInternalValue() {
        return value;
    }
    @ExposedGet(name = "value")
    public PyObject getValue() {
        return value;
    }
    @ExposedSet(name = "value")
    public void setValue(PyObject value) {
        this.value = AstAdapters.py2expr(value);
    }


    private final static PyString[] fields =
    new PyString[] {new PyString("arg"), new PyString("value")};
    @ExposedGet(name = "_fields")
    public PyString[] get_fields() { return fields; }

    private final static PyString[] attributes = new PyString[0];
    @ExposedGet(name = "_attributes")
    public PyString[] get_attributes() { return attributes; }

    public keyword(PyType subType) {
        super(subType);
    }
    public keyword() {
        this(TYPE);
    }
    @ExposedNew
    @ExposedMethod
    public void keyword___init__(PyObject[] args, String[] keywords) {
        ArgParser ap = new ArgParser("keyword", args, keywords, new String[]
            {"arg", "value"}, 2, true);
        setArg(ap.getPyObject(0, Py.None));
        setValue(ap.getPyObject(1, Py.None));
    }

    public keyword(PyObject arg, PyObject value) {
        setArg(arg);
        setValue(value);
    }

    public keyword(Token token, String arg, expr value) {
        super(token);
        this.arg = arg;
        this.value = value;
        addChild(value);
    }

    public keyword(Integer ttype, Token token, String arg, expr value) {
        super(ttype, token);
        this.arg = arg;
        this.value = value;
        addChild(value);
    }

    public keyword(PythonTree tree, String arg, expr value) {
        super(tree);
        this.arg = arg;
        this.value = value;
        addChild(value);
    }

    @ExposedGet(name = "repr")
    public String toString() {
        return "keyword";
    }

    public String toStringTree() {
        StringBuffer sb = new StringBuffer("keyword(");
        sb.append("arg=");
        sb.append(dumpThis(arg));
        sb.append(",");
        sb.append("value=");
        sb.append(dumpThis(value));
        sb.append(",");
        sb.append(")");
        return sb.toString();
    }

    public <R> R accept(VisitorIF<R> visitor) throws Exception {
        traverse(visitor);
        return null;
    }

    public void traverse(VisitorIF<?> visitor) throws Exception {
        if (value != null)
            value.accept(visitor);
    }

    public PyObject __dict__;

    @Override
    public PyObject fastGetDict() {
        ensureDict();
        return __dict__;
    }

    @ExposedGet(name = "__dict__")
    public PyObject getDict() {
        return fastGetDict();
    }

    private void ensureDict() {
        if (__dict__ == null) {
            __dict__ = new PyStringMap();
        }
    }


    /* Traverseproc implementation */
    @Override
    public int traverse(Visitproc visit, Object arg) {
        return value != null ? visit.visit(value,  arg) : 0;
    }

    @Override
    public boolean refersDirectlyTo(PyObject ob) {
        return ob != null && (ob == value || super.refersDirectlyTo(ob));
    }
}
