//====================================================================
// morpho_noise_reduction.h
// [SJIS/CRLF] {  p }
//
// Copyright(c) 2006-2012 Morpho,Inc.
//====================================================================

#ifndef MORPHO_NOISE_REDUCTION_H
# define MORPHO_NOISE_REDUCTION_H

//--------------------------------------------------------------------

# include "morpho_api.h"
# include "morpho_error.h"
# include "morpho_image_data.h"
# include "morpho_motion_data.h"
# include "morpho_rect_int.h"

//--------------------------------------------------------------------

# ifdef __cplusplus
extern "C" {
# endif

//====================================================================

/** o[W */
# define MORPHO_NOISE_REDUCTION_VERSION "Morpho Noise Reduction Ver.0.9.0 2012/08/09"

//--------------------------------------------------------------------
/** mCY */
typedef struct
{
    void *p; /**< \̂ւ̃|C^ */
} morpho_NoiseReduction;

//--------------------------------------------------------------------

/**
 * o[W擾
 *
 * @return o[W(MORPHO_IMAGE_STABILIZER_VERSION)
 */
MORPHO_API(const char *)
morpho_NoiseReduction_getVersion(void);

/**
 * mCYɕKvȃTCY擾
 * włtH[}bgTRMQƁB
 *
 * @param[in] width  ͉摜̕
 * @param[in] height ͉摜̍
 * @param[in] format 摜tH[}bg
 * @return KvȃTCY(byte)
 */
MORPHO_API(int)
morpho_NoiseReduction_getBufferSize(
    int width,
    int height,
    const char *format);

/**
 * mCY̏
 *
 * @param[out] reducer  mCY
 * @param[out] buffer      mCYɊ蓖Ă郁ւ̃|C^
 * @param[in]  buffer_size mCYɊ蓖Ă郁̃TCY.
 * @return G[R[h(morpho_error.h)
 */
MORPHO_API(int)
morpho_NoiseReduction_initialize(
    morpho_NoiseReduction *reducer,
    void *buffer,
    int buffer_size);

/**
 * mCỸN[Abv
 *
 * @param[in,out] reducer mCY
 * @return G[R[h(morpho_error.h)
 */
MORPHO_API(int)
morpho_NoiseReduction_finalize(
    morpho_NoiseReduction *reducer);

/**
 * mCY: Jn
 * o͉摜(output_image)1ڂ͉̓摜Ɠłǂ
 *
 * @param[in,out] reducer    mCY
 * @param[out]    output_image  o͉摜
 * @return G[R[h(morpho_error.h)
 */
MORPHO_API(int)
morpho_NoiseReduction_start(
    morpho_NoiseReduction *reducer,
    morpho_ImageData *output_image);

/**
 * mCY: mCY
 *
 * @param[in,out] reducer   mCY
 * @param[out]    input_image  o͉摜
 * @return G[R[h(morpho_error.h)
 */
MORPHO_API(int)
morpho_NoiseReduction_reduceNoise(
    morpho_NoiseReduction *reducer,
    morpho_ImageData *input_image);

/**
 * 摜tH[}bg擾
 * initialize()sɎ擾\
 * obt@TCY32ȏƂ邱
 *
 * @param[in,out] reducer mCY
 * @param[out] format 摜tH[}bg񂪊i[
 * @param[in] buffer_size obt@TCY
 * @return G[R[h(morpho_error.h)
 */
MORPHO_API(int)
morpho_NoiseReduction_getImageFormat(
    morpho_NoiseReduction *reducer,
    char *format,
    const int buffer_size);

/**
 * PxmCYxx擾
 * initialize()sɎ擾\
 *
 * @param[in,out] reducer mCY
 * @param[out] level PxmCYxxi[
 * @return G[R[h(morpho_error.h)
 */
MORPHO_API(int)
morpho_NoiseReduction_getLumaNoiseReductionLevel(
    morpho_NoiseReduction *reducer,
    int *level);

/**
 * N}mCYxx擾
 * initialize()sɎ擾\
 *
 * @param[in,out] reducer mCY
 * @param[out] level N}mCYxxi[
 * @return G[R[h(morpho_error.h)
 */
MORPHO_API(int)
morpho_NoiseReduction_getChromaNoiseReductionLevel(
    morpho_NoiseReduction *reducer,
    int *level);

/**
 * 摜tH[}bgݒ
 * initialize()sォstart()sOɐݒ\
 * włtH[}bgTRMQƁB
 *
 * @param[in,out] reducer mCY
 * @param[in] format 摜tH[}bg
 * @return G[R[h(morpho_error.h)
 */
MORPHO_API(int)
morpho_NoiseReduction_setImageFormat(
    morpho_NoiseReduction *reducer,
    const char *format);

/**
 * PxmCYxxݒ
 * initialize()sォstart()sOɐݒ\
 *
 * @param[in,out] reducer mCY
 * @param[in] level PxmCYxx(0-7)
 * @return G[R[h(morpho_error.h)
 */
MORPHO_API(int)
morpho_NoiseReduction_setLumaNoiseReductionLevel(
    morpho_NoiseReduction *reducer,
    int level);

/**
 * N}mCYxxݒ
 * initialize()sォstart()sOɐݒ\
 *
 * @param[in,out] reducer mCY
 * @param[in] level N}mCYxx(0-7)
 * @return G[R[h(morpho_error.h)
 */
MORPHO_API(int)
morpho_NoiseReduction_setChromaNoiseReductionLevel(
    morpho_NoiseReduction *reducer,
    int level);

//====================================================================

# ifdef __cplusplus
} // extern "C"
# endif

//--------------------------------------------------------------------

#endif // !MORPHO_IMAGE_STABILIZER3_H

//====================================================================
// [EOF]
