/**********************************************************************
 *
 *    FILE:            AzimElevationSector.cpp
 *
 *    DESCRIPTION:    Read/Write osgSim::AzimElevationSector in binary format to disk.
 *
 *    CREATED BY:        Auto generated by iveGenerator.exe
 *                    and later modified by Rune Schmidt Jensen.
 *
 *    HISTORY:        Created 9.9.2003
 *
 **********************************************************************/

#include "Exception.h"
#include "AzimElevationSector.h"

using namespace ive;

void AzimElevationSector::write(DataOutputStream* out){
    // Write AzimElevationSector's identification.
    out->writeInt(IVEAZIMELEVATIONSECTOR);
    // Write AzimElevationSector's properties.
    out->writeFloat(getMinElevation());
    out->writeFloat(getMaxElevation());
    out->writeFloat(getFadeAngle());

    float minAzimuth, maxAzimuth, fadeAngle;
    getAzimuthRange(minAzimuth, maxAzimuth, fadeAngle);
    out->writeFloat(minAzimuth);
    out->writeFloat(maxAzimuth);
    out->writeFloat(fadeAngle);
}

void AzimElevationSector::read(DataInputStream* in){
    // Peek on AzimElevationSector's identification.
    int id = in->peekInt();
    if(id == IVEAZIMELEVATIONSECTOR){
        // Read AzimElevationSector's identification.
        id = in->readInt();
        // Read AzimElevationSector's properties
        float minElevation = in->readFloat();
        float maxElevation = in->readFloat();
        float fadeAngle = in->readFloat();
        setElevationRange(minElevation, maxElevation, fadeAngle);

        float minAzimuth = in->readFloat();
        float maxAzimuth = in->readFloat();
        fadeAngle = in->readFloat();
        setAzimuthRange(minAzimuth, maxAzimuth, fadeAngle);
    }
    else{
        in_THROW_EXCEPTION("AzimElevationSector::read(): Expected AzimElevationSector identification.");
    }
}
