# io.js TC Meeting 2015-01-28

## Links

* **Google Hangouts Video**: http://www.youtube.com/watch?v=k27NObxy0ps
* **GitHub Issue**: https://github.com/nodejs/io.js/issues/565
* **Original Minutes Google Doc**: https://docs.google.com/document/d/1IIfubVivCORgP0nQfo8Mf4gXhwBrndRm9cwmNGBXmtE

## Agenda

Extracted from https://github.com/nodejs/io.js/labels/tc-agenda prior to meeting.

*  governance: Add new Collaborators [#234](https://github.com/nodejs/io.js/issues/234) / feedback and more contribs / @chrisdickinson
*  Stabilization and Release Cycles and Process [#405](https://github.com/nodejs/io.js/issues/405) / further discussion / @iojs/tc
  -  doc: add releases document detail release cycle [#630](https://github.com/nodejs/io.js/issues/630) / proposal from @chrisdickinson
*  dgram: implicit binds should be exclusive [#325](https://github.com/nodejs/io.js/issues/325) / minor version bump / @bnoordhuis
*  buffer: implement `iterable` interface [#525](https://github.com/nodejs/io.js/issues/525)  / minor version bump / @bnoordhuis
* replace util.isType() with typeof [#607](https://github.com/nodejs/io.js/issues/607) / general use of util.is*() in core re perf
* docs: lower the maximum stability level to "stable" [#633](https://github.com/nodejs/io.js/pull/633)
* maintain our own package registries for io.js related packages [#640](https://github.com/nodejs/io.js/issues/640#issuecomment-71882645)
* Working Groups PR [#599](https://github.com/nodejs/io.js/pull/599)
* Remove “unstable” from messaging [#108](https://github.com/nodejs/website/issues/108)

## Minutes

### Present

* Ben (TC)
* Bert (TC)
* Chris (TC)
* Colin (TC)
* Fedor (TC)
* Isaac (TC)
* Mikeal
* Rod

Apologies from:

* Trevor (TC)
* Domenic

### Mini stand-up

* Ben: Reviewed/landed pull requests, fixed bugs, the usual
* Bert: Same as Ben, but not as much
* Chris: On-boarding stuff
* Colin: 
* Fedor: working on pyg (gyp alternative in C)
* Rod: ARMv6 builds, fixing persistent bug on Ubuntu 10.04, yay!
* Isaacs: Only doing npm CEO stuff
* Mikeal: social media stuff for io.js, PR, roadmap, feedback from Big Cos.

### Review of last meeting

* Invite Domenic Denicola to the TC Meetings (https://github.com/nodejs/io.js/issues/403)
* Governance: Add new collaborators (https://github.com/nodejs/io.js/issues/234)
* Stabilization and Release Cycles and Process (https://github.com/nodejs/io.js/issues/405)
  * also: the state of ES6 on io.js (re: V8 upgrade policy) (https://github.com/nodejs/io.js/issues/251)
* doc: bump punycode api stability to ‘stable’ (https://github.com/nodejs/io.js/issues/470)
* Working group reports
 * Streams
 * Website
* ICU

### governance: Add new Collaborators

[#234](https://github.com/nodejs/io.js/issues/234) / feedback and more contribs / @chrisdickinson

* Chris: Onboarded 2 groups of 4 new collaborators last week. (first group: @vkurchatkin, @micnic, @seishun, @brendanashworth, second group: @evanlucas, @Fishrock123, @Qard, @thlorenz)
  - 30 min summary of how everything works, gov, git, etc.
  - took exit poll to get reactions
  - notes here: https://gist.github.com/chrisdickinson/80df88b9089c19e0459e
* Rod: how do we iterate?
* Chris: Do it again next week with ~4 more
* Discussed timezones and how that works

### Stabilization and Release Cycles and Process

[#405](https://github.com/nodejs/io.js/issues/405) / further discussion / @iojs/tc

***Also:*** doc: add releases document detail release cycle [#630](https://github.com/nodejs/io.js/issues/630) / proposal from @chrisdickinson

Moved straight to Chris’ proposal:

* Chris discussed thoughts in his proposal @ https://github.com/nodejs/io.js/issues/630
* Mikeal: would rather not have a static number/list of supported versions, let that be dynamic as people & companies step up to help support them
* Ben: “stable” and “next” would be easiest to reason about
* Chris: “dev” is for ad-hoc semver releases, replaces nightlies with a better train system.
* Chris: branches will be “master” - development happens here, maintain “v1.x”, “v2.x” etc. for major releases. Ideally LTS would be from major versions.
* Fedor asked about communication to users and how much fragmentation this would cause
* Ben: how do you keep the delta between dev and stable from getting too big
* Chris: at most there would be a 2-week lag between something hitting dev and something going out on stable
* Bert: suggested that we need a better batching mechanism, particularly for breaking changes, so we’re not constantly bumping major.

### dgram: implicit binds should be exclusive 

[#325](https://github.com/nodejs/io.js/issues/325) / minor version bump / @bnoordhuis

* Ben: this is about minor version bump, that’s been decided and we’re doing a 1.1.0 so this is being merged and released

### buffer: implement `iterable` interface

[#525](https://github.com/nodejs/io.js/issues/525)  / minor version bump / @bnoordhuis

* Ben: same as previous issue, resolved

### replace util.isType() with typeof 

[#607](https://github.com/nodejs/io.js/issues/607) / general use of util.is*() in core re perf

* Bert: find with direct comparisons and checks where it makes sense (undefined, simple stuff)
* Isaac: hate it all, they are difficult to inline so manually inline--pick one and use it across all
* Colin: working on a PR to do the replacement already
* Chris volunteered to PR a style-guide into docs
* Isaac: better linter would be great

### Doc-tool - Should we merge with the joyent/node version?

* Isaac: Robert Kowalski reached out to me to ask about this.
  - Seems silly to have two nearly-identical tools for this.
  - Delegate to doc working group?
  - Suggested that he just pick one from io.js or joyent/node and send a PR for that
* Mikeal: Website WG is meeting next week, will pull in Robert to that discussion

### docs: lower the maximum stability level to "stable" 

[#633](https://github.com/nodejs/io.js/issues/633)

* General disagreement about this
* Mikeal suggested moving things that are likely to change into vendored packages (like streams)
* Motivation was to set some things (frozen/locked) as unchangable because they would break too much stuff
* Bert: we effectively have 4 levels: strict-deprecation, soft-deprecation, moving, pretty-much-done
* Mikeal: proposed punting this for a few weeks
* Isaac: the labels are useful for guiding people on where best to contribute and where to not bother

### maintain our own package registries for io.js related packages

[#640](https://github.com/nodejs/io.js/issues/640)

* Mikeal: each distro (Homebrew, Debian, etc.) has their own conception of “stable”, suggestion is to maintain them under io.js and instruct people how to do this. e.g. using our own custom Homebrew end-point and instruct people how to use it with `brew`. Also could bring in complicated packages from the community.
* Mikeal: Should come under the Build WG for now, ideally a single repo where external projects can put in a single PR to update their stuff.

### Working Groups PR 

[#599](https://github.com/nodejs/io.js/issues/599)

* Mikeal introduced his proposal: if you’re going to do the work in a WG then you can spin that up as a separate concern
* Ben asked for clarification about whether WGs get a free-pass in core
  - Mikeal: no, they are isolated from core
* Rod: clarification about relationship to TC
  - TC has charter-revocation powers, beyond that they don’t have control over the activities of a WG
* Consensus reached, Mikeal will put in the suggested fixes (in the PR) into the docs and merge

### Remove “unstable” from messaging

[#108](https://github.com/nodejs/io.js/issues/108)

* Remove “unstable” from the website but not say it’s “stable”
* Bert: big +1, use semver, don’t try and message something else, only concern is the version of V8 we are using
* Discussed V8 4.1 and how “stable” it is

### Node.js and io.js should not break each other (no, they shouldn't)

[#631](https://github.com/nodejs/io.js/issues/631)

Rod brought this up for quick discussion and draw attention to TC members for possible input.
* Mikeal suggested that this should be taken to the website WG for better documentation

### Working group reports

* Streams
 - first WG meeting this week
* Website
 - meeting next week

### Next meeting

* 4th of February

