# Package maintainers

This page tracks the package maintainers for Netdata, for various operating systems and versions.

> Feel free to update it, so that it reflects the current status.

---

## Official Linux Distributions

| Linux Distribution | Netdata Version | Maintainer | Related URL |
| :-: | :-: | :-: | :-- |
| Arch Linux | Release | @svenstaro | [netdata @ Arch Linux](https://www.archlinux.org/packages/community/x86_64/netdata/) |
| Arch Linux AUR | Git | @sanskritfritz | [netdata @ AUR](https://aur.archlinux.org/packages/netdata-git/) |
| Gentoo Linux | Release + Git | @candrews | [netdata @ gentoo](https://github.com/gentoo/gentoo/tree/master/net-analyzer/netdata) |
| Debian | Release | @lhw @FedericoCeratto | [netdata @ debian](http://salsa.debian.org/debian/netdata) |
| Slackware | Release | @willysr | [netdata @ slackbuilds](https://slackbuilds.org/repository/14.2/system/netdata/) |
| Ubuntu |  |  |  |
| Red Hat / Fedora / CentOS |  |  |  |
| SUSE SLE / openSUSE Tumbleweed & Leap |  |  | [netdata @ SUSE OpenBuildService](https://software.opensuse.org/package/netdata) |

---

## FreeBSD

| System  | Initial PR | Core Developer | Package Maintainer
|:-:|:-:|:-:|:-:|
| FreeBSD | #1321      | @vlvkobal|@mmokhi

---

## macOS

| System | URL | Core Developer | Package Maintainer
|:-:|:-:|:-:|:-:|
| macOS Homebrew Formula|[link](https://github.com/Homebrew/homebrew-core/blob/master/Formula/netdata.rb)|@vlvkobal|@rickard-von-essen

---

## Unofficial Linux Packages

| Linux Distribution | Netdata Version | Maintainer | Related URL |
| :-: | :-: | :-: | :-- |
| Ubuntu             | Release         | @gslin     | [netdata @ gslin ppa](https://launchpad.net/~gslin/+archive/ubuntu/netdata) https://github.com/netdata/netdata/issues/69#issuecomment-217458543 |
---

## Embedded Linux

| Embedded Linux | Netdata Version | Maintainer | Related URL |
| :-: | :-: | :-: | :-- |
| ASUSTOR NAS | ? | William Lin | https://www.asustor.com/apps/app_detail?id=532 |
| OpenWRT | Release | @nitroshift | [openwrt package](https://github.com/openwrt/packages/tree/master/admin/netdata) |
| ReadyNAS | Release | @NAStools | https://github.com/nastools/netdata |
| QNAP | Release | QNAP_Stephane | https://forum.qnap.com/viewtopic.php?t=121518 |
| DietPi | Release | @Fourdee | https://github.com/Fourdee/DietPi |

---

## Linux Containers

| Containers | Netdata Version | Maintainer | Related URL |
| :-: | :-: | :-: | :-- |
| Docker     | Git             | @titpetric | https://github.com/titpetric/netdata |

---

## Automation Systems

| Automation Systems | Netdata Version | Maintainer | Related URL |
| :-: | :-: | :-: | :-- |
| Ansible            | git             | @jffz | https://galaxy.ansible.com/jffz/netdata/ |
| Chef               | ?               | @sergiopena | https://github.com/sergiopena/netdata-cookbook |

---

## Packages summary from repology.org

[![Packaging status](https://repology.org/badge/vertical-allrepos/netdata.svg)](https://repology.org/metapackage/netdata/versions)


