# - Try to locate SDL2
# This module defines:
#
#  SDL2_INCLUDE_DIR
#  SDL2_LIBRARY
#  SDL2_FOUND
#

FIND_PATH(SDL2_INCLUDE_DIR NAMES SDL.h PATH_SUFFIXES SDL2)

FIND_LIBRARY(SDL2_LIBRARY NAMES SDL2)

IF(SDL2_INCLUDE_DIR AND SDL2_LIBRARY)
	SET(SDL2_FOUND TRUE)
ENDIF(SDL2_INCLUDE_DIR AND SDL2_LIBRARY)

IF(SDL2_FOUND)
	IF(NOT SDL2_FIND_QUIETLY)
		MESSAGE(STATUS "Found SDL2: -I${SDL2_INCLUDE_DIR}, ${SDL2_LIBRARY}")
	ENDIF(NOT SDL2_FIND_QUIETLY)
ELSE(SDL2_FOUND)
	IF(SDL2_FIND_REQUIRED)
		MESSAGE(FATAL_ERROR "Could not find SDL2")
	ENDIF(SDL2_FIND_REQUIRED)
ENDIF(SDL2_FOUND)

MARK_AS_ADVANCED(SDL2_INCLUDE_DIR SDL2_LIBRARY SDL2_FOUND)
