/*
 * Decompiled with CFR 0.152.
 */
package com.amazon.aes.webservices.client.cmd;

import com.amazon.aes.webservices.client.Jec2;
import com.amazon.aes.webservices.client.RequestResult;
import com.amazon.aes.webservices.client.RequestResultPair;
import com.amazon.aes.webservices.client.SnapshotAttribute;
import com.amazon.aes.webservices.client.cmd.MissingArgument;
import com.amazon.aes.webservices.client.cmd.Outputter;
import com.amazon.aes.webservices.client.cmd.SnapshotAttributeBaseCmd;
import org.apache.commons.cli.OptionBuilder;
import org.apache.commons.cli.Options;

public class ResetSnapshotAttribute
extends SnapshotAttributeBaseCmd {
    private static final String CREATE_VOLUME_PERMISSION_DESC = "Reset create volume permissions granted on your snapshot.";
    public static final String[] RESET_ATTRIBUTE_ARGS = new String[]{"create-volume-permission"};

    public ResetSnapshotAttribute(String[] args) {
        super("ec2rsnapatt", "ec2-reset-snapshot-attribute");
        this.init(this.getOptions());
        this.parseOpts(args);
    }

    private Options getOptions() {
        Options result = new Options();
        OptionBuilder.withLongOpt((String)"create-volume-permission");
        OptionBuilder.withDescription((String)this.joinDescription(CREATE_VOLUME_PERMISSION_DESC));
        result.addOption(OptionBuilder.create((String)"c"));
        return result;
    }

    @Override
    protected String getOptionString() {
        return "SNAPSHOT -c";
    }

    @Override
    public void printOptions() {
        super.printOptions(true);
        this.printOption("create-volume-permission");
    }

    @Override
    public void printDescription() {
        super.printDescription();
        System.out.println("     Reset an attribute of a snapshot. The SNAPSHOT parameter is the ID of");
        System.out.println("     the snapshot for which to reset an attribute.");
    }

    @Override
    protected boolean invokeOnline(Jec2 jec2, Outputter out) throws Exception {
        String snapshotId = this.getSnapshotId();
        this.assertAtLeastOneOptionSet(RESET_ATTRIBUTE_ARGS);
        this.assertOnlyOneOptionSet(RESET_ATTRIBUTE_ARGS);
        SnapshotAttribute.SnapshotAttributeType attributeType = this.getSnapshotAttributeType(jec2);
        RequestResultPair rsp = jec2.resetSnapshotAttribute(snapshotId, attributeType);
        if (((Boolean)rsp.getResponse()).booleanValue()) {
            out.output(System.out, snapshotId, attributeType);
        }
        out.printRequestId(System.out, (RequestResult)rsp);
        return (Boolean)rsp.getResponse();
    }

    public SnapshotAttribute.SnapshotAttributeType getSnapshotAttribute() {
        this.assertOnlyOneOptionSet(RESET_ATTRIBUTE_ARGS);
        if (this.isOptionSet("create-volume-permission")) {
            return SnapshotAttribute.SnapshotAttributeType.createVolumePermission;
        }
        throw new MissingArgument("create-volume-permission");
    }

    public static void main(String[] args) {
        new ResetSnapshotAttribute(args).invoke();
    }
}

