/* -*- Mode: C++; tab-width: 4; indent-tabs-mode: nil; c-basic-offset: 4 -*- */
/*
 * This file is part of the libgltf project.
 *
 * This Source Code Form is subject to the terms of the Mozilla Public
 * License, v. 2.0. If a copy of the MPL was not distributed with this
 * file, You can obtain one at http://mozilla.org/MPL/2.0/.
 */

#ifndef CAMERA_H
#define CAMERA_H

#include <GL/glew.h>
#include <glm/glm.hpp>

namespace libgltf
{

class CPhysicalCamera
{
public:
    float curquatY[4];
    float curquatX[4];
    glm::vec3 vSpeed;
    double fSetTime;
    double fTotalMoveTime;
    bool bMove_camera_flag;
    bool bAontrolCamera;
    double fSensitivity;
    glm::mat4 mTrackBallY;
    glm::mat4 mTrackBallX;

    double AerialViewY;
    double flength;
    glm::vec3 vModelCenterPos;

    void setViewMatrix(const glm::mat4& rViewMatrix);
    const glm::mat4& getViewMatrix() const;

    void setPerspective(glm::mat4 Perspective);
    const glm::mat4 getPerspective();

    void setAerialView( bool bAerialView );
    void getCameraPosVectors(glm::vec3* pEye, glm::vec3* pView, glm::vec3* pUp) const;

    void moveCamera(double x, double y, double z, double time);

    glm::mat4 getModelViewMatrix(glm::mat4 lookat,
                                 glm::mat4& matrix,
                                 float fMoveTime,
                                 float fPreTime);
    void rotateObjectMouse(double horizontal, double vertical,
                           double planar);
    void rotateCamera(double horizontal, double vertical,
                      double planar);
    void buildRotMatrix(glm::mat4& m, float q[4]);

    CPhysicalCamera();
private:
    glm::mat4 mViewMatrix;
    glm::mat4 mProjection;

    bool mbAerialView;
};

} // namespace libgltf

#endif

/* vim:set shiftwidth=4 softtabstop=4 expandtab: */
