/* SPDX-License-Identifier: (GPL-2.0-only OR BSD-2-Clause) */
/*
 * Copyright (c) 2023-2025 Rockchip Electronics Co., Ltd.
 * Author: Finley Xiao <finley.xiao@rock-chips.com>
 */

#ifndef _DT_BINDINGS_CLK_ROCKCHIP_RK3506_H
#define _DT_BINDINGS_CLK_ROCKCHIP_RK3506_H

/* cru plls */
#define PLL_GPLL			0
#define PLL_V0PLL			1
#define PLL_V1PLL			2

/* cru-clocks indices */
#define ARMCLK				3
#define CLK_DDR				4
#define XIN24M_GATE			5
#define CLK_GPLL_GATE			6
#define CLK_V0PLL_GATE			7
#define CLK_V1PLL_GATE			8
#define CLK_GPLL_DIV			9
#define CLK_GPLL_DIV_100M		10
#define CLK_V0PLL_DIV			11
#define CLK_V1PLL_DIV			12
#define CLK_INT_VOICE_MATRIX0		13
#define CLK_INT_VOICE_MATRIX1		14
#define CLK_INT_VOICE_MATRIX2		15
#define CLK_FRAC_UART_MATRIX0_MUX	16
#define CLK_FRAC_UART_MATRIX1_MUX	17
#define CLK_FRAC_VOICE_MATRIX0_MUX	18
#define CLK_FRAC_VOICE_MATRIX1_MUX	19
#define CLK_FRAC_COMMON_MATRIX0_MUX	20
#define CLK_FRAC_COMMON_MATRIX1_MUX	21
#define CLK_FRAC_COMMON_MATRIX2_MUX	22
#define CLK_FRAC_UART_MATRIX0		23
#define CLK_FRAC_UART_MATRIX1		24
#define CLK_FRAC_VOICE_MATRIX0		25
#define CLK_FRAC_VOICE_MATRIX1		26
#define CLK_FRAC_COMMON_MATRIX0		27
#define CLK_FRAC_COMMON_MATRIX1		28
#define CLK_FRAC_COMMON_MATRIX2		29
#define CLK_REF_USBPHY_TOP		30
#define CLK_REF_DPHY_TOP		31
#define ACLK_CORE_ROOT			32
#define PCLK_CORE_ROOT			33
#define PCLK_DBG			34
#define PCLK_CORE_GRF			35
#define PCLK_CORE_CRU			36
#define CLK_CORE_EMA_DETECT		37
#define CLK_REF_PVTPLL_CORE		38
#define PCLK_GPIO1			39
#define DBCLK_GPIO1			40
#define ACLK_CORE_PERI_ROOT		41
#define HCLK_CORE_PERI_ROOT		42
#define PCLK_CORE_PERI_ROOT		43
#define CLK_DSMC			44
#define ACLK_DSMC			45
#define PCLK_DSMC			46
#define CLK_FLEXBUS_TX			47
#define CLK_FLEXBUS_RX			48
#define ACLK_FLEXBUS			49
#define HCLK_FLEXBUS			50
#define ACLK_DSMC_SLV			51
#define HCLK_DSMC_SLV			52
#define ACLK_BUS_ROOT			53
#define HCLK_BUS_ROOT			54
#define PCLK_BUS_ROOT			55
#define ACLK_SYSRAM			56
#define HCLK_SYSRAM			57
#define ACLK_DMAC0			58
#define ACLK_DMAC1			59
#define HCLK_M0				60
#define PCLK_BUS_GRF			61
#define PCLK_TIMER			62
#define CLK_TIMER0_CH0			63
#define CLK_TIMER0_CH1			64
#define CLK_TIMER0_CH2			65
#define CLK_TIMER0_CH3			66
#define CLK_TIMER0_CH4			67
#define CLK_TIMER0_CH5			68
#define PCLK_WDT0			69
#define TCLK_WDT0			70
#define PCLK_WDT1			71
#define TCLK_WDT1			72
#define PCLK_MAILBOX			73
#define PCLK_INTMUX			74
#define PCLK_SPINLOCK			75
#define PCLK_DDRC			76
#define HCLK_DDRPHY			77
#define PCLK_DDRMON			78
#define CLK_DDRMON_OSC			79
#define PCLK_STDBY			80
#define HCLK_USBOTG0			81
#define HCLK_USBOTG0_PMU		82
#define CLK_USBOTG0_ADP			83
#define HCLK_USBOTG1			84
#define HCLK_USBOTG1_PMU		85
#define CLK_USBOTG1_ADP			86
#define PCLK_USBPHY			87
#define ACLK_DMA2DDR			88
#define PCLK_DMA2DDR			89
#define STCLK_M0			90
#define CLK_DDRPHY			91
#define CLK_DDRC_SRC			92
#define ACLK_DDRC_0			93
#define ACLK_DDRC_1			94
#define CLK_DDRC			95
#define CLK_DDRMON			96
#define HCLK_LSPERI_ROOT		97
#define PCLK_LSPERI_ROOT		98
#define PCLK_UART0			99
#define PCLK_UART1			100
#define PCLK_UART2			101
#define PCLK_UART3			102
#define PCLK_UART4			103
#define SCLK_UART0			104
#define SCLK_UART1			105
#define SCLK_UART2			106
#define SCLK_UART3			107
#define SCLK_UART4			108
#define PCLK_I2C0			109
#define CLK_I2C0			110
#define PCLK_I2C1			111
#define CLK_I2C1			112
#define PCLK_I2C2			113
#define CLK_I2C2			114
#define PCLK_PWM1			115
#define CLK_PWM1			116
#define CLK_OSC_PWM1			117
#define CLK_RC_PWM1			118
#define CLK_FREQ_PWM1			119
#define CLK_COUNTER_PWM1		120
#define PCLK_SPI0			121
#define CLK_SPI0			122
#define PCLK_SPI1			123
#define CLK_SPI1			124
#define PCLK_GPIO2			125
#define DBCLK_GPIO2			126
#define PCLK_GPIO3			127
#define DBCLK_GPIO3			128
#define PCLK_GPIO4			129
#define DBCLK_GPIO4			130
#define HCLK_CAN0			131
#define CLK_CAN0			132
#define HCLK_CAN1			133
#define CLK_CAN1			134
#define HCLK_PDM			135
#define MCLK_PDM			136
#define CLKOUT_PDM			137
#define MCLK_SPDIFTX			138
#define HCLK_SPDIFTX			139
#define HCLK_SPDIFRX			140
#define MCLK_SPDIFRX			141
#define MCLK_SAI0			142
#define HCLK_SAI0			143
#define MCLK_OUT_SAI0			144
#define MCLK_SAI1			145
#define HCLK_SAI1			146
#define MCLK_OUT_SAI1			147
#define HCLK_ASRC0			148
#define CLK_ASRC0			149
#define HCLK_ASRC1			150
#define CLK_ASRC1			151
#define PCLK_CRU			152
#define PCLK_PMU_ROOT			153
#define MCLK_ASRC0			154
#define MCLK_ASRC1			155
#define MCLK_ASRC2			156
#define MCLK_ASRC3			157
#define LRCK_ASRC0_SRC			158
#define LRCK_ASRC0_DST			159
#define LRCK_ASRC1_SRC			160
#define LRCK_ASRC1_DST			161
#define ACLK_HSPERI_ROOT		162
#define HCLK_HSPERI_ROOT		163
#define PCLK_HSPERI_ROOT		164
#define CCLK_SRC_SDMMC			165
#define HCLK_SDMMC			166
#define HCLK_FSPI			167
#define SCLK_FSPI			168
#define PCLK_SPI2			169
#define ACLK_MAC0			170
#define ACLK_MAC1			171
#define PCLK_MAC0			172
#define PCLK_MAC1			173
#define CLK_MAC_ROOT			174
#define CLK_MAC0			175
#define CLK_MAC1			176
#define MCLK_SAI2			177
#define HCLK_SAI2			178
#define MCLK_OUT_SAI2			179
#define MCLK_SAI3_SRC			180
#define HCLK_SAI3			181
#define MCLK_SAI3			182
#define MCLK_OUT_SAI3			183
#define MCLK_SAI4_SRC			184
#define HCLK_SAI4			185
#define MCLK_SAI4			186
#define HCLK_DSM			187
#define MCLK_DSM			188
#define PCLK_AUDIO_ADC			189
#define MCLK_AUDIO_ADC			190
#define MCLK_AUDIO_ADC_DIV4		191
#define PCLK_SARADC			192
#define CLK_SARADC			193
#define PCLK_OTPC_NS			194
#define CLK_SBPI_OTPC_NS		195
#define CLK_USER_OTPC_NS		196
#define PCLK_UART5			197
#define SCLK_UART5			198
#define PCLK_GPIO234_IOC		199
#define CLK_MAC_PTP_ROOT		200
#define CLK_MAC0_PTP			201
#define CLK_MAC1_PTP			202
#define CLK_SPI2			203
#define ACLK_VIO_ROOT			204
#define HCLK_VIO_ROOT			205
#define PCLK_VIO_ROOT			206
#define HCLK_RGA			207
#define ACLK_RGA			208
#define CLK_CORE_RGA			209
#define ACLK_VOP			210
#define HCLK_VOP			211
#define DCLK_VOP			212
#define PCLK_DPHY			213
#define PCLK_DSI_HOST			214
#define PCLK_TSADC			215
#define CLK_TSADC			216
#define CLK_TSADC_TSEN			217
#define PCLK_GPIO1_IOC			218
#define PCLK_OTPC_S			219
#define CLK_SBPI_OTPC_S			220
#define CLK_USER_OTPC_S			221
#define PCLK_OTP_MASK			222
#define PCLK_KEYREADER			223
#define HCLK_BOOTROM			224
#define PCLK_DDR_SERVICE		225
#define HCLK_CRYPTO_S			226
#define HCLK_KEYLAD			227
#define CLK_CORE_CRYPTO			228
#define CLK_PKA_CRYPTO			229
#define CLK_CORE_CRYPTO_S		230
#define CLK_PKA_CRYPTO_S		231
#define ACLK_CRYPTO_S			232
#define HCLK_RNG_S			233
#define CLK_CORE_CRYPTO_NS		234
#define CLK_PKA_CRYPTO_NS		235
#define ACLK_CRYPTO_NS			236
#define HCLK_CRYPTO_NS			237
#define HCLK_RNG			238
#define CLK_PMU				239
#define PCLK_PMU			240
#define CLK_PMU_32K			241
#define PCLK_PMU_CRU			242
#define PCLK_PMU_GRF			243
#define PCLK_GPIO0_IOC			244
#define PCLK_GPIO0			245
#define DBCLK_GPIO0			246
#define PCLK_GPIO1_SHADOW		247
#define DBCLK_GPIO1_SHADOW		248
#define PCLK_PMU_HP_TIMER		249
#define CLK_PMU_HP_TIMER		250
#define CLK_PMU_HP_TIMER_32K		251
#define PCLK_PWM0			252
#define CLK_PWM0			253
#define CLK_OSC_PWM0			254
#define CLK_RC_PWM0			255
#define CLK_MAC_OUT			256
#define CLK_REF_OUT0			257
#define CLK_REF_OUT1			258
#define CLK_32K_FRAC			259
#define CLK_32K_RC			260
#define CLK_32K				261
#define CLK_32K_PMU			262
#define PCLK_TOUCH_KEY			263
#define CLK_TOUCH_KEY			264
#define CLK_REF_PHY_PLL			265
#define CLK_REF_PHY_PMU_MUX		266
#define CLK_WIFI_OUT			267
#define CLK_V0PLL_REF			268
#define CLK_V1PLL_REF			269
#define CLK_32K_FRAC_MUX		270

#endif
