#############################################################
#
# pam
#
#############################################################
ifeq ($(USE_GLIBC),true)
ifneq ($(USE_CVS),true)
PAM_SOURCE:=pam.tar.gz
PAM_CAT:=zcat
endif

PAM_DIR:=$(BUILD_DIR)/pam
PAM_BINARY:=modules/pam_xauth/pam_xauth.so
PAM_TARGET_BINARY:=lib/security/pam_xauth.so

ifneq ($(USE_CVS),true)
pam-source: $(DL_DIR)/$(PAM_SOURCE)
else
pam-source:
endif

PAM_CVSCO:=cd $(BUILD_DIR) && $(CVS) $(CVS_REPO) $(CVS_CLIENT) co -d pam $(CVS_TAG) $(CVS_PREFIX)pam

pam-checkout:
	@$(PAM_CVSCO)

$(PAM_DIR)/.unpacked: $(DL_DIR)/$(PAM_SOURCE)
ifneq ($(USE_CVS),true)
	$(PAM_CAT) $(DL_DIR)/$(PAM_SOURCE) | tar -C $(BUILD_DIR) -xvf -
else
	@$(PAM_CVSCO)
endif
	cp $(SOURCE_DIR)/config.sub $(PAM_DIR)/
	sed -i -e "s,shell glib-config,shell $(STAGING_DIR)/usr/bin/glib-config,g" $(PAM_DIR)/modules/pam_console/Makefile
	touch $(PAM_DIR)/.unpacked

$(PAM_DIR)/.configured: $(PAM_DIR)/.unpacked
	(cd $(PAM_DIR); rm -rf config.cache; \
		export $(TARGET_CONFIGURE_OPTS) ; \
		LD=$(TARGET_CROSS)gcc \
		CFLAGS="$(TARGET_CFLAGS) -fPIC" \
		./configure \
		--target=$(GNU_TARGET_NAME) \
		--host=$(GNU_TARGET_NAME) \
		--build=$(GNU_HOST_NAME) \
		--prefix= \
		--exec-prefix= \
		--bindir=/bin \
		--sbindir=/sbin \
		--libexecdir=/usr/lib \
		--libdir=/lib \
		--sysconfdir=/etc \
		--datadir=/usr/share \
		--localstatedir=/var \
		--mandir=/usr/man \
		--infodir=/usr/info \
		$(DISABLE_NLS) \
		--enable-static-libpam \
		--enable-fakeroot=$(TARGET_DIR) \
	);
	touch  $(PAM_DIR)/.configured

$(PAM_DIR)/$(PAM_BINARY): $(PAM_DIR)/.configured
	$(MAKE) -C $(PAM_DIR)

$(STAGING_DIR)/$(PAM_TARGET_BINARY): $(PAM_DIR)/$(PAM_BINARY)
	$(MAKE) \
		FAKEROOT=$(STAGING_DIR) \
		-C $(PAM_DIR) \
		install

$(TARGET_DIR)/$(PAM_TARGET_BINARY): $(STAGING_DIR)/$(PAM_TARGET_BINARY)
	$(MAKE) \
		FAKEROOT=$(TARGET_DIR) \
		-C $(PAM_DIR) \
		install
	for lib in libpam libpamc libpam_misc ; do \
		ln -sf $${lib}.so.0.75 $(TARGET_DIR)/lib/$${lib}.so.0 ; \
		ln -sf $${lib}.so.0.75 $(STAGING_DIR)/lib/$${lib}.so.0 ; \
	done
	install -d $(DOC_DIR)/doc/pam
	@for f in Copyright README ; do \
		install -m0644 $(PAM_DIR)/$$f $(DOC_DIR)/doc/pam/$$f ;\
	done
	-mv $(TARGET_DIR)/usr/doc/Linux-PAM/* $(DOC_DIR)/doc/pam/
	install -m0644 $(PAM_DIR)/doc/txts/README* $(DOC_DIR)/doc/pam/text
	rm -rf $(TARGET_DIR)/usr/doc/Linux-PAM \
		$(TARGET_DIR)/usr/include/security
	rm -f $(TARGET_DIR)/lib/libpam*.a
	install -d -m0755 $(TARGET_DIR)/etc/pam.d
	install -m644 $(PAM_DIR)/other.pamd \
		$(TARGET_DIR)/etc/pam.d/other
	install -m644 $(PAM_DIR)/system-auth.pamd \
		$(TARGET_DIR)/etc/pam.d/system-auth
	$(STRIP) $(TARGET_DIR)/sbin/pam_console_apply \
		$(TARGET_DIR)/sbin/pwdb_chkpwd \
		$(TARGET_DIR)/sbin/pam_tally \
		$(TARGET_DIR)/sbin/pam_timestamp_check \
		$(TARGET_DIR)/sbin/unix_chkpwd \
		$(TARGET_DIR)/lib/libpam*.so* \
		$(TARGET_DIR)/lib/security/*.so
	rm -f $(TARGET_DIR)/lib/security/pam_radius.so \
		$(DOC_DIR)/doc/pam/text/README.pam_radius
	chmod 0755 $(TARGET_DIR)/etc/security
	find $(TARGET_DIR)/etc/security -type f | xargs chmod 0644

pam: uclibc /usr/bin/sgml2html pwdb glib cracklib $(TARGET_DIR)/$(PAM_TARGET_BINARY)

pam-clean:
	-rm -f $(TARGET_DIR)/$(PAM_TARGET_BINARY) \
		$(STAGING_DIR)/$(PAM_TARGET_BINARY) \
		$(TARGET_DIR)/lib/libpam* \
		$(STAGING_DIR)/lib/libpam* \
		$(TARGET_DIR)/usr/man/man*/pam* \
		$(STAGING_DIR)/usr/man/man*/pam*
	-rm -rf $(TARGET_DIR)/lib/security \
		$(STAGING_DIR)/lib/security \
		$(TARGET_DIR)/etc/security \
		$(STAGING_DIR)/etc/security 
	-rm -rf $(DOC_DIR)/doc/pam
	-$(MAKE) -C $(PAM_DIR) clean

pam-dirclean:
	rm -rf $(PAM_DIR)

endif

