try:
    import finch  # noqa: F401
except ModuleNotFoundError as e:
    raise ImportError("Finch not installed. Run `pip install sparse[finch]` to enable Finch backend") from e

from finch import (
    SparseArray,
    abs,
    acos,
    acosh,
    add,
    all,
    any,
    arange,
    asarray,
    asin,
    asinh,
    astype,
    atan,
    atan2,
    atanh,
    bitwise_and,
    bitwise_invert,
    bitwise_left_shift,
    bitwise_or,
    bitwise_right_shift,
    bitwise_xor,
    bool,
    can_cast,
    ceil,
    compiled,
    complex64,
    complex128,
    compute,
    conj,
    cos,
    cosh,
    divide,
    e,
    empty,
    empty_like,
    equal,
    exp,
    expm1,
    eye,
    finfo,
    float16,
    float32,
    float64,
    floor,
    floor_divide,
    full,
    full_like,
    greater,
    greater_equal,
    iinfo,
    imag,
    inf,
    int8,
    int16,
    int32,
    int64,
    int_,
    isfinite,
    isinf,
    isnan,
    lazy,
    less,
    less_equal,
    linspace,
    log,
    log1p,
    log2,
    log10,
    logaddexp,
    logical_and,
    logical_or,
    logical_xor,
    matmul,
    max,
    min,
    multiply,
    nan,
    negative,
    newaxis,
    nonzero,
    not_equal,
    ones,
    ones_like,
    permute_dims,
    pi,
    positive,
    pow,
    prod,
    random,
    real,
    remainder,
    reshape,
    round,
    sign,
    sin,
    sinh,
    sqrt,
    square,
    subtract,
    sum,
    tan,
    tanh,
    tensordot,
    trunc,
    uint,
    uint8,
    uint16,
    uint32,
    uint64,
    where,
    zeros,
    zeros_like,
)

__all__ = [
    "SparseArray",
    "abs",
    "acos",
    "acosh",
    "add",
    "asarray",
    "asin",
    "asinh",
    "astype",
    "atan",
    "atan2",
    "atanh",
    "bitwise_and",
    "bitwise_invert",
    "bitwise_left_shift",
    "bitwise_or",
    "bitwise_right_shift",
    "bitwise_xor",
    "bool",
    "compiled",
    "complex64",
    "complex128",
    "compute",
    "cos",
    "cosh",
    "divide",
    "eye",
    "float16",
    "float32",
    "float64",
    "floor_divide",
    "int8",
    "int16",
    "int32",
    "int64",
    "int_",
    "lazy",
    "matmul",
    "multiply",
    "negative",
    "permute_dims",
    "positive",
    "pow",
    "prod",
    "random",
    "sin",
    "sinh",
    "subtract",
    "sum",
    "tan",
    "tanh",
    "tensordot",
    "uint",
    "uint8",
    "uint16",
    "uint32",
    "uint64",
    "max",
    "min",
    "all",
    "any",
    "log",
    "log10",
    "log1p",
    "log2",
    "sqrt",
    "exp",
    "expm1",
    "sign",
    "round",
    "floor",
    "ceil",
    "nonzero",
    "where",
    "full",
    "full_like",
    "ones",
    "ones_like",
    "zeros",
    "zeros_like",
    "equal",
    "not_equal",
    "less",
    "less_equal",
    "greater",
    "greater_equal",
    "e",
    "pi",
    "inf",
    "nan",
    "newaxis",
    "isnan",
    "isfinite",
    "isinf",
    "reshape",
    "square",
    "logaddexp",
    "trunc",
    "remainder",
    "logical_and",
    "logical_or",
    "logical_xor",
    "finfo",
    "iinfo",
    "can_cast",
    "real",
    "imag",
    "conj",
    "empty",
    "empty_like",
    "arange",
    "linspace",
]
