---
layout: default
built_from_commit: 70303b65ae864066c583e1436011ff135847f6ad
title: 'Man Page: puppet help'
canonical: "/puppet/latest/man/help.html"
---

# Man Page: puppet help

> **NOTE:** This page was generated from the Puppet source code on 2024-08-29 17:41:46 -0700

## NAME
**puppet-help** - Display Puppet help.

## SYNOPSIS
puppet help *action*

## OPTIONS
Note that any setting that\'s valid in the configuration file is also a
valid long argument, although it may or may not be relevant to the
present action. For example, **server** and **run_mode** are valid
settings, so you can specify **\--server \<servername\>**, or
**\--run_mode \<runmode\>** as an argument.

See the configuration file documentation at
*https://puppet.com/docs/puppet/latest/configuration.html* for the full
list of acceptable parameters. A commented list of all configuration
options can also be generated by running puppet with **\--genconfig**.

\--render-as FORMAT

:   The format in which to render output. The most common formats are
    **json**, **s** (string), **yaml**, and **console**, but other
    options such as **dot** are sometimes available.

\--verbose

:   Whether to log verbosely.

\--debug

:   Whether to log debug information.

## ACTIONS
**help** - Display help about Puppet subcommands and their actions.

:   **SYNOPSIS**

    puppet help \[\--version VERSION\] \[\--ronn\] \[*subcommand*\]
    \[*action*\]

    **DESCRIPTION**

    Display help about Puppet subcommands and their actions.

    **OPTIONS** *\--ronn* - Whether to render the help text in ronn
    format.

    *\--version VERSION* - The version of the subcommand for which to
    show help.

    **RETURNS**

    Short help text for the specified subcommand or action.

## EXAMPLES
**help**

Get help for an action:

\$ puppet help

## COPYRIGHT AND LICENSE
Copyright 2011 by Puppet Inc. Apache 2 license; see COPYING
