//
//  Stream.h
//  obs-mac-virtualcam
//
//  Created by John Boiles  on 4/10/20.
//
//  obs-mac-virtualcam is free software: you can redistribute it and/or modify
//  it under the terms of the GNU General Public License as published by
//  the Free Software Foundation, either version 2 of the License, or
//  (at your option) any later version.
//
//  obs-mac-virtualcam is distributed in the hope that it will be useful,
//  but WITHOUT ANY WARRANTY; without even the implied warranty of
//  MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
//  GNU General Public License for more details.
//
//  You should have received a copy of the GNU General Public License
//  along with obs-mac-virtualcam. If not, see <http://www.gnu.org/licenses/>.

#import <Foundation/Foundation.h>

#import "OBSDALObjectStore.h"

NS_ASSUME_NONNULL_BEGIN

@interface OBSDALStream : NSObject <CMIOObject>

@property CMIOStreamID objectId;

- (instancetype _Nonnull)init;

- (CMSimpleQueueRef)copyBufferQueueWithAlteredProc:
			    (CMIODeviceStreamQueueAlteredProc)alteredProc
				     alteredRefCon:(void *)alteredRefCon;

- (void)startServingDefaultFrames;

- (void)stopServingDefaultFrames;

- (void)queueFrameWithSize:(NSSize)size
		 timestamp:(uint64_t)timestamp
	      fpsNumerator:(uint32_t)fpsNumerator
	    fpsDenominator:(uint32_t)fpsDenominator
		 frameData:(NSData *)frameData;

@end

NS_ASSUME_NONNULL_END
