# set-getter [![NPM version](https://img.shields.io/npm/v/set-getter.svg?style=flat)](https://www.npmjs.com/package/set-getter) [![NPM monthly downloads](https://img.shields.io/npm/dm/set-getter.svg?style=flat)](https://npmjs.org/package/set-getter) [![NPM total downloads](https://img.shields.io/npm/dt/set-getter.svg?style=flat)](https://npmjs.org/package/set-getter) [![Linux Build Status](https://img.shields.io/travis/doowb/set-getter.svg?style=flat&label=Travis)](https://travis-ci.org/doowb/set-getter)

> Create nested getter properties and any intermediary dot notation (`'a.b.c'`) paths

Please consider following this project's author, [Brian Woodward](https://github.com/doowb), and consider starring the project to show your :heart: and support.

## Install

Install with [npm](https://www.npmjs.com/):

```sh
$ npm install --save set-getter
```

## Usage

```js
var getter = require('set-getter');
```

set-getter works like [set-value](https://github.com/jonschlinkert/set-value) by adding a property to an object or an object hierarchy using dot notation. The main difference is that the property is added using `Object.defineProperty` and is expected to be a getter function that returns a value.

**Example**

```js
var obj = {};

// root level property
getter(obj, 'foo', function() {
  return 'bar';
});
console.log(obj.foo);
//=> 'bar'

// property dot notation
getter(obj, 'bar.baz', function() {
  return 'qux';
});
console.log(obj.bar.baz);
//=> 'qux'

// property array notation
getter(obj, ['beep', 'boop'], function() {
  return 'bop';
});
console.log(obj.beep.boop);
//=> 'bop'
```

## API

### [setGetter](index.js#L31)

Defines a getter function on an object using property path notation.

**Params**

* `obj` **{Object}**: Object to add property to.
* `prop` **{String|Array}**: Property string or array to add.
* `getter` **{Function}**: Getter function to add as a property.

**Example**

```js
var obj = {};
getter(obj, 'foo', function() {
  return 'bar';
});
```

## About

<details>
<summary><strong>Contributing</strong></summary>

Pull requests and stars are always welcome. For bugs and feature requests, [please create an issue](../../issues/new).

</details>

<details>
<summary><strong>Running Tests</strong></summary>

Running and reviewing unit tests is a great way to get familiarized with a library and its API. You can install dependencies and run tests with the following command:

```sh
$ npm install && npm test
```

</details>

<details>
<summary><strong>Building docs</strong></summary>

_(This project's readme.md is generated by [verb](https://github.com/verbose/verb-generate-readme), please don't edit the readme directly. Any changes to the readme must be made in the [.verb.md](.verb.md) readme template.)_

To generate the readme, run the following command:

```sh
$ npm install -g verbose/verb#dev verb-generate-readme && verb
```

</details>

### Author

**Brian Woodward**

* [GitHub Profile](https://github.com/doowb)
* [Twitter Profile](https://twitter.com/doowb)
* [LinkedIn Profile](https://linkedin.com/in/woodwardbrian)

### License

Copyright © 2021, [Brian Woodward](https://github.com/doowb).
Released under the [MIT License](LICENSE).

***

_This file was generated by [verb-generate-readme](https://github.com/verbose/verb-generate-readme), v0.8.0, on June 18, 2021._