.\" *********************************** start of \input{common.tex}
.\" *********************************** end of \input{common.tex}
'\" t
.\" Manual page created with latex2man on Tue Aug 29 10:53:42 2023
.\" NOTE: This file is generated, DO NOT EDIT.
.de Vb
.ft CW
.nf
..
.de Ve
.ft R

.fi
..
.TH "UNW\\_STEP" "3libunwind" "29 August 2023" "Programming Library " "Programming Library "
.SH NAME
unw_step
\-\- advance to next stack frame 
.PP
.SH SYNOPSIS

.PP
#include <libunwind.h>
.br
.PP
int
unw_step(unw_cursor_t *cp);
.br
.PP
.SH DESCRIPTION

.PP
The unw_step()
routine advances the unwind cursor cp
to 
the next older, less deeply nested stack frame. 
.PP
.SH RETURN VALUE

.PP
On successful completion, unw_step()
returns a positive value 
if the updated cursor refers to a valid stack frame, or 0 if the 
previous stack frame was the last frame in the chain. On error, the 
negative value of one of the error\-codes below is returned. 
.PP
.SH THREAD AND SIGNAL SAFETY

.PP
unw_step()
is thread\-safe. If cursor cp
is in the local 
address\-space, this routine is also safe to use from a signal handler. 
.PP
.SH ERRORS

.PP
.TP
UNW_EUNSPEC
 An unspecified error occurred. 
.TP
UNW_ENOINFO
 Libunwind
was unable to locate the 
unwind\-info needed to complete the operation. 
.TP
UNW_EBADVERSION
 The unwind\-info needed to complete the 
operation has a version or a format that is not understood by 
libunwind\&.
.TP
UNW_EINVALIDIP
 The instruction\-pointer 
(``program\-counter\&'') of the next stack frame is invalid (e.g., not 
properly aligned). 
.TP
UNW_EBADFRAME
 The next stack frame is invalid. 
.TP
UNW_ESTOPUNWIND
 Returned if a call to 
find_proc_info()
returned \-UNW_ESTOPUNWIND\&.
.PP
In addition, unw_step()
may return any error returned by the 
find_proc_info(),
get_dyn_info_list_addr(),
access_mem(),
access_reg(),
or access_fpreg()
call\-backs (see unw_create_addr_space(3libunwind)).
.PP
.SH SEE ALSO

.PP
libunwind(3libunwind),
unw_create_addr_space(3libunwind)
.PP
.SH AUTHOR

.PP
David Mosberger\-Tang
.br
Email: \fBdmosberger@gmail.com\fP
.br
WWW: \fBhttp://www.nongnu.org/libunwind/\fP\&.
.\" NOTE: This file is generated, DO NOT EDIT.
