#define I_SYS
#define I_SOCKET
#define I_ERRNO
#define I_STRING

#include "includes.h"

#ifdef NO_UNIX_DOMAIN
#include <fcntl.h>
#endif

int bind_tcp(int port)
{
  struct sockaddr_in sin;
  int s;

#if 0 
/* This is not necessary here! - ot */
  struct hostent *hp;
  char host_name[100];

#ifdef SYSV
  struct utsname unam;

  if (uname(&unam) == -1) {
    perror("uname");
    return -1;
  }
  strcpy(host_name, unam.nodename);
#else
  if (gethostname(host_name, sizeof(host_name)) == -1) {
    perror("gethostname");
    return -1;
    }  
#endif /* SYSV */

  hp = gethostbyname(host_name); /* Find the name of the machine we */
				/* are running.. */
  if (hp == 0) {		/* Probly doesn't run TCP/IP. oh well. */
    fprintf(stderr, "Gethostbyname: Unknown host.\n");
    return -1;
    }

  memset(&sin, 0, sizeof(sin));
  memcpy(&sin.sin_addr, hp->h_addr, hp->h_length);
  sin.sin_family = hp->h_addrtype;
#endif 
  sin.sin_port = htons( port );
  sin.sin_addr.s_addr = INADDR_ANY; 
/*  s = socket(hp->h_addrtype, SOCK_STREAM, 0); */
  s = socket(AF_INET, SOCK_STREAM, 0);

  if (s == -1) {
    perror("socket");
    return -1;
    }
				/* Ok. Now we look for a socket that */
				/* isn't bound. This is probably a */
				/* little scummy, but some ppl like it */
				/* this way.. We try a maximum of 100 */
				/* times... */
  while (bind(s, (struct sockaddr * ) &sin,
	      sizeof(sin)) < 0) { /* while an error.. */
    if (errno != EADDRINUSE) {	/* if it wasn't in use */
      close(s);
      return -1; 		/* then we can't handle it, so abort. */
    }
    close(s);
    return -2;			/* handled specially by some clients. */
  } /*NOTREACHED*/

  if (listen(s, 5) == -1) {	/* If we can't listen... */
    perror("listen");		/* then just dump. We can't handle */
				/* errors here. */
    close(s);
    return -1;
    }
  return s;
}


#ifdef NO_UNIX_DOMAIN
/*
 *	We bind the socket, and then write the address to the requested
 *	file.  We are the server.
 */
#endif

#ifdef STREAMS_PIPE
/*
 *	This is a bit of a hack.  If STREAMS_PIPE is defined, we look for the
 *	environment variable TERM_BORROWED_DISPLAY_NUMBER, and interpret the
 *	value as an X-server display number, and use that streams pipe as
 *	our client/server IPC channel.
 *
 *	This is for SCO.  It would probably work on other systems if you
 *	became root and set up the appropriate /dev/X?R and /dev/X?S entries
 */
#endif

int bind_unix(char *path) 
{
#ifdef NO_UNIX_DOMAIN
  struct sockaddr_in sock_in;
  int size_in;
  int fd;
#else
  struct sockaddr_un sock_un;
#endif
#ifdef STREAMS_PIPE
  char *borrowed_display_number;
#endif

  int s;

#ifdef STREAMS_PIPE
  borrowed_display_number = getenv("TERM_BORROWED_DISPLAY_NUMBER");
  if (borrowed_display_number != 0) {
	s = open_stream_pipe(atoi(borrowed_display_number));
	if (s < 0) {
		fprintf(stderr, "cannot borrow X display channel %s\n", borrowed_display_number);
		return -1;
	} else {
		fprintf(stderr, "Borrowed X display channel %d\n", atoi(borrowed_display_number));
		return s;
	}
  }

#endif

#ifdef NO_UNIX_DOMAIN
  if ((s = socket(AF_INET, SOCK_STREAM, 0 )) < 0) {
    perror("Socket");
    return -1;
  }

  sock_in.sin_family = AF_INET;
  sock_in.sin_addr.s_addr = htonl(INADDR_ANY);
  sock_in.sin_port = htons(0);
  if (bind(s, (struct sockaddr *) &sock_in, sizeof(sock_in)) < 0) {
    perror("Bind");
    close(s);
    return -1;
  }

  size_in = sizeof(sock_in);
  if (getsockname(s, (struct sockaddr *) &sock_in, &size_in) < 0) {
	perror("getsockname");
	close(s);
	return -1;
  }
  fd = open(path, O_WRONLY|O_CREAT, 0666);
  if (fd < 0) {
	perror("open path");
	close(s);
	return -1;
  }

  if (write(fd, &sock_in.sin_port, sizeof(sock_in.sin_port)) < 0) {
	perror("write port number");
	close(fd);
	close(s);
	return -1;
  }

  fprintf(stderr, "port is %d\n", sock_in.sin_port);
#else
  if ((s = socket(AF_UNIX, SOCK_STREAM, 0 )) < 0) {
    perror("Socket");
    return -1;
  }

  sock_un.sun_family = AF_UNIX;
  
  strcpy(sock_un.sun_path, path);
  unlink(sock_un.sun_path);
  if (bind(s, (struct sockaddr *) &sock_un, strlen(sock_un.sun_path) + 2)) {
    perror("Bind");
    close(s);
    return -1;
  }

#endif
  /* ok. Start looking for connections. */
  if (listen(s, 5) < 0) {
    perror("Listen");
    close(s);
    return -1;
  }
  return s;
}

#ifdef STREAMS_PIPE

/*
 *	This is a bit of a hack.  If STREAMS_PIPE is defined, we look for the
 *	environment variable TERM_BORROWED_DISPLAY_NUMBER, and interpret the
 *	value as an X-server display number, and use that streams pipe as
 *	our client/server IPC channel.
 *
 *	This is for SCO.  It would probably work on other systems if you
 *	became root and set up the appropriate /dev/X?R and /dev/X?S entries
 */

#endif

int open_unix(char *p) 
{
#ifdef NO_UNIX_DOMAIN
  struct sockaddr_in sock_in;
  int fd;
#else
  struct sockaddr_un sock_un;
#endif
#ifdef STREAMS_PIPE
  char *borrowed_display_number;
#endif
  int s;

#ifdef STREAMS_PIPE
  borrowed_display_number = getenv("TERM_BORROWED_DISPLAY_NUMBER");
  if (borrowed_display_number != 0) {
	s = MakeStreamPipeConnection(atoi(borrowed_display_number));
	if (s < 0) {
		fprintf(stderr, "cannot borrow X display channel %s\n", borrowed_display_number);
		return -1;
	} else {
		return s;
	}
  }

#endif

#ifdef NO_UNIX_DOMAIN

  fd = open(p, O_RDONLY);
  if (fd < 0) {
	perror("open port path");
	return -1;
  }

  if (read(fd, &sock_in.sin_port, sizeof(sock_in.sin_port)) < 0) {
	perror("read port path");
	close(fd);
	return -1;
  }

  close(fd);

  if ((s = socket(AF_INET, SOCK_STREAM, 0 )) < 0) {
    perror("Socket");
    return -1;
  }

  sock_in.sin_family = AF_INET;
  sock_in.sin_addr.s_addr = inet_addr("127.0.0.1");	/* localhost */

  if (connect(s, (struct sockaddr *) &sock_in, sizeof(sock_in))) {
    perror("Connect");
    close(s);
    return -1;
  }
#else
  if ((s = socket(AF_UNIX, SOCK_STREAM, 0 )) < 0) {
    perror("Socket");
    return -1;
  }

  sock_un.sun_family = AF_UNIX;
  
  sprintf(sock_un.sun_path,"%s",p);
  
  if (connect(s, (struct sockaddr *) &sock_un, 
	      strlen(sock_un.sun_path) + 2)) {
    perror("Connect");
    close(s);
    return -1;
  }
#endif
  return s;
  
}


