 

/*
 * $Id: libselect.c,v 1.7 1993/06/16 16:41:30 wade Exp $
 *
 * $Log: libselect.c,v $
 * Revision 1.7  1993/06/16  16:41:30  wade
 * never found weird AIX mpi problem; changed index file instead
 *
 * Revision 1.6  1993/06/08  18:24:47  wade
 * fixed performance server name check
 *
 * Revision 1.5  1993/05/28  19:49:04  wade
 * *** empty log message ***
 *
 * Revision 1.4  1993/01/01  18:48:08  wade
 * corrected contextual help message for class selection mode
 *
 * Revision 1.3  1992/12/15  21:06:05  wade
 * using text instead of bitmaps for contextual help
 *
 * Revision 1.2  1992/12/05  17:15:51  larose
 * added rcs logging.
 *
 *
 */

#include "xnl.h"
#include "performance.h"

make_libSelect(w)
Widget w;
{
    Arg args[20];
    register int n;

	con_help[MODE_LIBSELECT] = "\n\
In Library Selection mode the description\n\
file for a library is displayed.\n\
\n\
The dog-eared page icon,\n\
indicates a file you may wish to download.\n\
To select, click on the line with the left\n\
mouse button.\n\
\n\
The folder icon,\n\
indicates another library, often a sublibrary\n\
of the current one. Selecting this jumps you\n\
to that library. Clicking on 'Go Up' brings you\n\
back.\n";

    n = 0;
    XtSetArg(args[n], XtNtype, XawUtkasciiFile); n++;
    XtSetArg(args[n], XtNgetAllButton, True); n++;
    XtSetArg(args[n], XtNstring, "/dev/null"); n++;
    libSelForm = XtCreateManagedWidget("libText",
            utkasciiTextWidgetClass, topPane, args, n);
}

Popup_libSelect(lib_name)
String lib_name;
{
    Arg args[20];
    register int n;
    char filename[MAXLINE];
    char line[MAXLINE];

	strcpy(currentLib, lib_name);

    Mode = MODE_LIBSELECT;

	if (helpPic) {
		Arg args[3];
		XtSetArg(args[0], XtNstring, con_help[Mode]);
		XtSetValues (helpPic, args, 1);
	}


    grey_the_button(gobackButton, True);


	if (strncmp("performance", lib_name, strlen("performance")) == 0) {
      sprintf(filename, "%s/%s/%s/index", XNL_PATH, 
            PERFORMANCE_SERVER, lib_name);
	} else {
      sprintf(filename, "%s/%s/%s/index", XNL_PATH, 
            server_list[lib2server(lib_name)], lib_name);
	}
    
    confirmFile(filename, (PUBDATA) ? 1 : 0, True, False);
    XtVaSetValues(libSelForm, XtNstring, filename, NULL);

	XtManageChild(libSelForm);

	currentDisplayText = libSelForm;

    sprintf(line, "Index for %s ", lib_name);
    set_status(line, GREEN);

    return 1;
}

Popdown_libSelect(w)
Widget w;
{
    XtUnmanageChild(libSelForm);

	currentDisplayText = NULL;

    Mode_last = MODE_LIBSELECT;

    grey_the_button(gobackButton, False);

    return 1;
}


void
subdirJump(w, call_data, closure)
Widget w;
XtPointer call_data, closure;
{
	Arg args[5];
    String s;

	XtSetArg(args[0], XtNlabel, &s);
	XtGetValues(w, args, 1);

    if (Mode == MODE_KEYWORD)
        Popdown_keyword(w);

    Mode_last = MODE_LIBSELECT;

    Popup_libSelect(s);
}




void
gobackCB(w, call_data, closure)
Widget w;
XtPointer call_data, closure;
{
    char s[MAXLINE];
    register int i;

    strcpy(s, currentLib);
	
	/* remove last directory element ( /sdfs/sdfs --> /sdfs ) */
    i = strlen(s);
    while (i && (s[i] != '/'))
        i--;
    s[i] = '\0';

    if (s[0]) {
        Popup_libSelect(s);
    } else {
        Popdown_libSelect(w);
        if (LibOrClass == MODE_LIBRARY)
            Popup_library(toplevel);
        else if (Mode == MODE_CLASSSELECT) {
            Popdown_classSelect(w);
            Popup_classification(w);
        } else if (LibOrClass == MODE_CLASSSELECT)
            Popup_classSelect(LastClassItem);
        else if (LibOrClass == MODE_KEYWORD)
            Popup_keyword(toplevel);
        else if (LibOrClass == MODE_INDEX)
            Popup_index(toplevel);
#ifdef STUB
        else if (LibOrClass == MODE_STUB)
            Popup_stub(toplevel);
#endif
#ifdef PERFORMANCE
        else if (LibOrClass == MODE_PERFORMANCE)
            Popup_performance(toplevel);
#endif
		else
            Popup_motd(toplevel);
    }

}


