/*
 * lastlog.h: header for lastlog.c 
 *
 * Written By Michael Sandrof
 *
 * Copyright(c) 1990 
 *
 * See the COPYRIGHT file, or do a HELP IRCII COPYRIGHT 
 */

#ifndef _LASTLOG_H_
#define _LASTLOG_H_

typedef struct	lastlog_stru
{
	int	level;
	char	*msg;
	struct	lastlog_stru	*next;
	struct	lastlog_stru	*prev;
}	Lastlog;

#define LOG_NONE 0
#define LOG_CURRENT 0
#define LOG_CRAP 1
#define LOG_PUBLIC 2
#define LOG_MSG 4
#define LOG_NOTICE 8
#define LOG_WALL 16
#define LOG_WALLOP 32
#define LOG_NOTES 64
#define LOG_OPNOTE 128
#define	LOG_SNOTE 256
#define LOG_ACTION 512
#define	LOG_DCC 1024
#define	LOG_USER1 2048
#define LOG_USER2 4096
#define LOG_USER3 8192
#define LOG_USER4 16384

#define LOG_ALL (LOG_CRAP | LOG_PUBLIC | LOG_MSG | LOG_NOTICE | LOG_WALL | \
	LOG_WALLOP | LOG_NOTES | LOG_OPNOTE | LOG_ACTION | LOG_DCC)

extern	void	set_lastlog_level();
extern	int	set_lastlog_msg_level();
extern	void	set_lastlog_size();
extern	void	lastlog();
extern	void	add_to_lastlog();
extern	char	*bits_to_lastlog_level();

#endif /* _LASTLOG_H_ */
