/*
**	MPUMON -- filter to display mpu data.
**	P. Langston, 2/88
*/
#include	<stdio.h>
#include	<midi.h>

main(argc, argv)
char	*argv[];
{
	char *arg;
	int i, n, status, mflg = 0;

	for (i = 1; i < argc; i++) {
	    arg = argv[i];
	    if (arg[0] == '-') {
		switch (arg[1]) {
		case 'm':			/* midi data (no time tags) */
		    mflg++;
		    break;
		default:
		    syntax(argv[0]);
		}
	    } else
		syntax(argv[0]);
	}
	status = 0;
	for (status = 0; (i = getc(stdin)) != EOF; putc('\n', stderr)) {
	    putc(i, stdout);
	    if ((i & M_CMD_MASK) != 0xF0 && mflg == 0) {
		fprintf(stderr, "%02x ", i);		/* time tag */
		if ((i = getc(stdin)) == EOF)
		    break;
		putc(i, stdout);
	    } else
		fprintf(stderr, "   ");
	    if ((i & M_CMD) == 0x00)		/* running status */
		fprintf(stderr, "   ");
	    fprintf(stderr, "%02x", i);
	    n = statproc(&status, i);
	    if (n < 0) {				/* Sys Excl */
		n = 0;
		while ((i = getc(stdin)) != EOF) {
		    putc(i, stdout);
		    if (n++ == 15) {
			n = 0;
			fprintf(stderr, "\n     ");
		    }
		    fprintf(stderr, " %02x", i);
		    if (i == SX_EOB)
			break;
		}
	    } else {
		while (--n > 0 && (i = getc(stdin)) != EOF) {
		    putc(i, stdout);
		    fprintf(stderr, " %02x", i);
		}
	    }
	}
}

syntax(argv0)
{
	fprintf(stderr, "Usage: sourceprog | %s [-midi] | destprog\n", argv0);
	exit(2);
}
