/******************************************************************************
 *
 * File:        midiconst.h
 * Version:     $Id: midiconst.h,v 1.3 1995/07/30 01:37:34 burgaard Exp $
 *
 * Project:     MIDI/Sequencer library.
 *              Roland MPU-401 Device driver.
 * Authors:     Kim Burgaard, <burgaard@daimi.aau.dk>
 * Copyrights:  Copyright (c) 1994 Kim Burgaard.
 *
 *	This package is free software; you can redistribute it and/or modify it
 *	under the terms of the GNU General Public License as published by the
 *	Free Software Foundation; either version 2, or (at your option) any
 *	later version.
 *
 *	This package is distributed in the hope that it will be useful, but
 *	WITHOUT ANY WARRANTY; without even the implied warranty of
 *	MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the GNU General
 *	Public License for more details.
 *
 *	You should have received a copy of the GNU General Public License along
 *	with this program; see the file COPYING. If not, write to the Free
 *	Software Foundation, 675 Mass Ave, Cambridge, MA 02139, USA.
 *
 ******************************************************************************/

/*** INCLUDES & DEFINES *******************************************************/

#ifndef __MIDI_CONST_H
#define __MIDI_CONST_H

/*** ENUMERATIONS *************************************************************/

/* These constants conform to the Standard MIDI specs. */
enum eMIDIEventType {
   MID_EVENT_CHMSG_FIRST   = 0x80,
   MID_EVENT_NOTE_OFF      = 0x80,
   MID_EVENT_NOTE_ON       = 0x90,
   MID_EVENT_POLY_PRESSURE = 0xA0,
   MID_EVENT_CONTROL       = 0xB0,
   MID_EVENT_PROG_CHG      = 0xC0,
   MID_EVENT_CH_PRESSURE   = 0xD0,
   MID_EVENT_PITCH_BEND    = 0xE0,
   MID_EVENT_CHMSG_LAST    = 0xE0,

   MID_EVENT_OTHER         = 0xF7, /* Other event. */
   MID_EVENT_META          = 0xFF  /* Meta event */
};

/* These constants are the META EVENT ID's */
enum eMIDIMetaEventType {
   MID_META_SEQ_NUMBER   = 0x00, /* Sequence number */
   MID_META_TEXT_FIRST   = 0x01, /* --- first text type meta event --- */
   MID_META_TEXT         = 0x01, /* Text */
   MID_META_COPYRIGHT    = 0x02, /* Copyright Notice */
   MID_META_SEQ_NAME     = 0x03, /* Sequence Name */
   MID_META_INST_NAME    = 0x04, /* Instrument name */
   MID_META_LYRIC        = 0x05, /* Lyric */
   MID_META_MARKER       = 0x06, /* Marker */
   MID_META_CUE_POINT    = 0x07, /* Cue point */
   MID_META_TEXT_LAST    = 0x07, /* --- last text type meta event --- */
   MID_META_CH_PREFIX    = 0x20, /* Channel Prefix */
   MID_META_EOT          = 0x2F, /* End Of Track */
   MID_META_SET_TEMPO    = 0x51,
   MID_META_SMPTE_OFFSET = 0x54,
   MID_META_TIME_SIG     = 0x58, /* Time signature */
   MID_META_KEY_SIG	 = 0x59, /* Key signature */
   MID_META_SEQ_SPECIFIC = 0x7F  /* ? */
};

/* These constants are the CHANNEL MESSAGE CONTROL ID's */
enum eMIDIControl {
   MID_CTRL_BANK_MSB	    = 0x00,
   MID_CTRL_MODULATION	    = 0x01,
   MID_CTRL_PORTAMENTO_TIME = 0x05,
   MID_CTRL_DATA_MSB	    = 0x06,
   MID_CTRL_VOLUME  	    = 0x07,
   MID_CTRL_PAN_POT 	    = 0x0A,
   MID_CTRL_EXPRESSION      = 0x0B,
   MID_CTRL_BANK_LSB	    = 0x20,
   MID_CTRL_DATA_LSB	    = 0x26,
   MID_CTRL_HOLD_1          = 0x40,
   MID_CTRL_PORTAMENTO      = 0x41,
   MID_CTRL_SOSTENUTO       = 0x42,
   MID_CTRL_SOFT            = 0x43,
   MID_CTRL_GENERAL_4       = 0x44,
   MID_CTRL_HOLD_2	    = 0x45,
   MID_CTRL_GENERAL_5       = 0x50,
   MID_CTRL_GENERAL_6       = 0x51,
   MID_CTRL_GENERAL_7       = 0x52,
   MID_CTRL_GENERAL_8       = 0x53,
   MID_CTRL_PORTAMENTO_CTRL = 0x54,
   MID_CTRL_REVERB_LEVEL    = 0x5B,
   MID_CTRL_CHORUS_LEVEL    = 0x5D,
   MID_CTRL_TREMOLO_DEPTH   = 0x5C,
   MID_CTRL_CHORUS_DEPTH    = 0x5D,
   MID_CTRL_DETUNE	    = 0x5E,
   MID_CTRL_PHASER_DEPTH    = 0x5F,
   MID_CTRL_DATA_INC        = 0x60,
   MID_CTRL_DATA_DEC        = 0x61,
   MID_CTRL_NON_REG_LSB     = 0x62,
   MID_CTRL_NON_REG_MSB     = 0x63,
   MID_CTRL_REG_LSB	    = 0x64,
   MID_CTRL_REG_MSB	    = 0x65,
   MID_CTRL_ALL_SOUNDS_OFF  = 0x78,
   MID_CTRL_RESET_ALL_CTRL  = 0x79,
   MID_CTRL_ALL_NOTES_OFF   = 0x7B,
   MID_CTRL_OMNI_OFF        = 0x7C,
   MID_CTRL_OMNI_ON         = 0x7D,
   MID_CTRL_MONO            = 0x7E,
   MID_CTRL_POLY            = 0x7F
};

/* These constants are General MIDI RPN Control ID's */
enum eMIDIRPNControl {
  MID_RPN_PITCH_BEND_SENSE   = 0x0000,
  MID_RPN_MASTER_FINE_TUNE   = 0x0001,
  MID_RPN_MASTER_COARSE_TUNE = 0x0002,
  MID_RPN_RPN_RESET          = 0x7F7F
};

/* These constants are Roland GS NRPN Control ID's */
enum eMIDINRPN_GSControl {
  MID_NRPN_GS_VIBRA_RATE    = 0x0108,
  MID_NRPN_GS_VIBRA_DEPTH   = 0x0109,
  MID_NRPN_GS_VIBRA_DELAY   = 0x010a,
  MID_NRPN_GS_TVF_CUTOFF    = 0x0120,
  MID_NRPN_GS_TVF_RESONANCE = 0x0121,
  MID_NRPN_GS_ENV_ATTACK    = 0x0163,
  MID_NRPN_GS_ENV_DECAY     = 0x0164,
  MID_NRPN_GS_ENV_RELEASE   = 0x0166,
  /* Drum parameters, only compare with MSB! */
  MID_NRPN_GS_DRUM_PITCH    = 0x18,
  MID_NRPN_GS_DRUM_VOLUME   = 0x1a,
  MID_NRPN_GS_DRUM_PAN_POT  = 0x1c,
  MID_NRPN_GS_DRUM_REVERB   = 0x1d,
  MID_NRPN_GS_DRUM_CHORUS   = 0x1e
};

/* These constants are the MIDI SYSTEM ID's */
enum eMIDISystem {
   MID_SYS_SYSEX           = 0xF0,
   MID_SYS_SONG_POS	   = 0xF2,
   MID_SYS_SONG_SEL	   = 0xF3,
   MID_SYS_TUNE_REQ	   = 0xF6,
   MID_SYS_EOX             = 0xF7
};

enum eMIDIRealTime {
   MID_RTM_START         = 0xFA,
   MID_RTM_CONTINUE      = 0xFB,
   MID_RTM_STOP          = 0xFC,
   MID_RTM_ACTIVE_SENSE  = 0xFE
};

/* SYSTEM EXCLUSIVE messages */
enum eMIDISysEx {
   /* The following define the "target" */
   MID_SYS_SEQ_CIRCUITS    = 0x01, /* Sequential Circuits Inc. */
   MID_SYS_BIG_BRIAR       = 0x02, /* Big Briar Inc. */
   MID_SYS_OCTAVE          = 0x03, /* Octave/Plateau */
   MID_SYS_MOOG            = 0x04, /* Moog Music */
   MID_SYS_PASSPORT        = 0x05, /* Passport Designs */
   MID_SYS_LEXICON         = 0x06,
   MID_SYS_TEMPI           = 0x20, /* Bon Tempi */
   MID_SYS_SIEL            = 0x21, /* S.I.E.L. */
   MID_SYS_KAWAI           = 0x41,
   MID_SYS_ROLAND          = 0x42,
   MID_SYS_KORG            = 0x42,
   MID_SYS_YAMAHA          = 0x43,
   MID_SYS_UNI_NONREALTIME = 0x7E,
   MID_SYS_UNI_REALTIME    = 0x7F
};

#endif /* __MIDI_CONST_H */

/*** End of File **************************************************************/
