
/*
 *   Linux port include file.
 *
 *   Provides defines needed for missing DOS functions.
 */


#define  inp		inb
#define  inpw		inw

#define  outp		outb
#define  outpw		outw

static inline void outb (short port, char val)
{
  ioperm(port, 1, 1);
  __asm__ volatile ("out%B0 %0,%1" : :"a" (val), "d" (port));
}

static inline void outw (short port, short val)
{
  ioperm(port, 1, 1);
  __asm__ volatile ("out%B0 %0,%1" : :"a" (val), "d" (port));
}

static inline unsigned char inb (short port)
{
  unsigned int ret;
  ioperm(port, 1, 1);  
  __asm__ volatile ("in%B0 %1,%0" : "=a" (ret) : "d" (port));
  return ret;
}

static inline unsigned short inw (short port)
{
  unsigned short ret;
  ioperm(port, 1, 1);
  __asm__ volatile ("in%B0 %1,%0" : "=a" (ret) : "d" (port));
  return ret;
}
