.TH xfilemanager 1 "Version 0.1"
.SH Name
.B xfilemanager
\- X11 based Unix filemanager
.SH Syntax
.B xfilemanger
[-rootDir 
.I path
] [-iconDir 
.I path
] [-iconFont 
.I fontname
] [-selectColor
.I color_name
] [-doubleClickInterval 
.I time
] [-multiWindow/-singleWindow] [-saveWS] [-noDragCopyAsk] [-noDragMoveAsk] 
[-noDragExecAsk] [-noDragDeleteAsk]
.SH Introduction
.B xfilemanager
is a X11 based Unix filemanager with Drag'n Drop abilities. When
.B xfilemanager
starts up, it popups either one big window with an iconbar on top
and three seperated regions below, or with two seperated windows.
.B xfilemanager
considers three main types of regions (called windows in later
reference) - the path-, directory- and workspacewindow.

.SS Pathwindow
The pathwindows shows the entire directorytree, begining from a given root-directory.
Within this window, directories can be opened by clicking upon their name or icon.
If a directory opens while clicking upon it's entry with a single click, all
direct subdirectories of this directory will be inserted in the directory tree.
To investigate the whole contents of this directory, you have to double click
upon the icon. If the present display mode is set into the multi-window-mode, a new
window will be opened, showing all files of this directory.
In single-window-mode, the middlest window will be updated with the contents of the
directory.

.SS Directorywindow
The directorywindow displays, depending on the current filterin method, the whole
contents of a directory. Within this window, files can be selected for moving, copying,
deleting, etc. by clicking upon their icons or names.
Double clicks are forcing the filemanager to execute a determined action, depending on
the type of the file. Example: double clicking upon a directory will open a new
directorywindow or display the contents of this directory in the directorywindow.

.SS Workspacewindow
The workspacewindow serves as a kind of container for executables. Executables can be
either draged from directorywindows to the workspacewindow or added by using the
.I Add_Workspace_Entry
Button.

.SS Fileoperations
To invoke several fileoperations (copy, delete, move, newdir, status) you can either
press one of the buttons on top of each window or by draging files into the destination
window or over the action buttons.

.SS Filetypes
To determine what file belongs to what kind of fileclass, the user can edit his
own ~/.xfmrc file, which specifies the executable, the fileendings, the iconfile and
a short description.

.SH Option
.B -rootDir 
.I path
 - sets the rootdirectory of the pathwindow. The default is the users HOME-directory.

.B -iconDir
.I path
 - sets the directory that contains the fileicons.

.B -iconFont
.I fontname
 - specifies the font to be used within the different windows to display the name of
files.

.B -selectColor
.I colorname
 - determines the color to be used to mark selected files

.B -doubleClickTime
.I time
 - specifies the interval within mouseclicks will be threated as doubleclicks. Default 300
milliseconds.

.B -multiWindow
 - uses serperate windows for each directory.

.B -singleWindow
 - uses one big window instead of many little windows.

.B -saveWS
 - save workspace on exit

.B -noDragCopyAsk/-noDragDeleteAsk/-noDragMoveAsk/-NoDragExecAsk
- prevent the filemanager from displaying a dialog box on copying/removing/moveing/copying files
by draging them.


.SH Resources

.B *rootDir
.I (String)
- same as rootDir option

.B *iconDir
.I (String)
-same as iconDir option

.B *doubleClickInterval
.I (time)
- same as doubleClickInterval option

.B *selectColor
.I (color)
- same as selectColor option

.B *iconFomt
.I (fontname)
- same as iconFont option

.B *multiWindow
.I (Boolean)
- wheter to use the multiwindowmode or not.

.B *dragCopyAsk
.I (Boolean)

.B *dragMoveAsk
.I (Boolean)

.B *dragDeleteAsk
.I (Boolean)

.B *dragExecAsk
.I (Boolean)

.B *saveWSOnExit
.I (Boolean)
- look at saveWS option

.B *iconGrid
.I (Dimension)
- specifies the grid in which the icons will be arranged when pressing the cleanup-button
in the workspacewindow. Default: 70

.B *snapGrid
.I (Dimension)
- determines the possible positions when moving icons arond in the workspace. Default: 1

.SH Author
Ove Kalkan (kalkan@ramz.ing.tu-bs.de)

.SH Copyright
Copyrighted in 1993 by Ove Kalkan - all rights reserved
