/*
 * Copyright 1993 by Ove Kalkan, Cremlingen, Germany
 *
 * Permission to use, copy, modify, distribute and sell this software and it's
 * documentation for any purpose is hereby granted without fee, rpovided that
 * the above copyright notice and this permission appear in supporting
 * documentation, and that the name of Ove Kalkan not to be used in
 * advertising or publicity pertaining to distributiopn of the software without
 * specific, written prior permission. Ove Kalkan makes no representations
 * about the suitability of this software for any purpose. It is provided
 * as is without express or implied warranty.
 *
 * OVE KALKAN DISPLAIMS ALL WARRANTIES WITH REGARD TO THIS SOFTWARE,
 * INCLUDING ALL IMPLIED WARRANTIES OF MERCHANTABLILITY AND FITNESS, IN NO
 * EVENT SHALL OVE KALKAN BE LIABLE FOR ANY SPECIAL, INDIRECT OR
 * CONSEQUENTIAL DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE,
 * DATA OR PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER
 * TORTIOUS ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR
 * PERFORMANCE OF THIS SOFTWARE.
 *
 * $Header: filename,v 1.0 yyyy/mm/dd hh:mm:ss loginname Exp $
 */

#ifdef ISC
#define	_POSIX_SOURCE
#endif

#include <stdio.h>
#include <stdlib.h>

#include <X11/X.h>
#include <X11/Intrinsic.h>
#include <X11/StringDefs.h>

#include <signal.h>

#include "struct.h"
#include "config.h"

/*
 * Global variables
 */
extern	Widget	dialog;			/* Das Dialogwidget */
extern	Widget	text_1, text_2;		/* Zum Verschieben braucht man 2 Text,
					   sonst nur einen */
extern	Pixmap	Icon_Exec_PM;
extern	Pixmap	icon_pixmap;

extern	Boolean		FILE_CHANGED;
extern	Boolean		DIR_CHANGED;
extern	Folder_Glyph	*selc_fo;
extern	Dimension	selc_f;
extern	Dir_Glyph	*selc_g;

/*
 * Function Prototypes
 */
void	init_exec      (char *file, char *data);
void	exec_exec_cb   (void);
void	exec_exec      (char *file, char *data);

extern	Widget		makeDialog     (Dimension text,
					char *label1, char *label2,
					char *text1, char *text2,
					char *title, Boolean cancel, Boolean OVERRIDE);
extern	XtActionProc	refresh_files  (Widget w, XExposeEvent *e,
					String *s, Cardinal *c);
extern	void		updateFolder   (Folder_Glyph *folder);
extern	void		hide_dialog    (void);
extern	void		WARNING	       (char *text);
extern	void		setSize	       (void);





/*********************************************************
 * name:	init_exec
 * description:	erzeugt ein Fenster mit 2 texten zum Ausfuehren
 *		von Programmen
 * input:	char *file
 * output:	none
 * date:	10.5.93
 *********************************************************/
void	init_exec (char *prog, char *file)
{
	Widget	but;
	char	cmd[2000];

	/*
	 * Das Dialogfenster erzeugen
	 */
	sprintf(cmd,"%s %s",(prog ? prog : ""),(file ? file : ""));
	icon_pixmap = Icon_Exec_PM;
	but = makeDialog(1,"Command :",NULL,cmd,NULL,
			 "Program executer",TRUE,FALSE);

	XtAddCallback(but,XtNcallback,(XtCallbackProc) exec_exec_cb,NULL);

	/*
	 * Zum Schluss die Dialogshell managen
	 */
	XtManageChild (dialog);

	/*
	 * Max und Minsize setzen
	 */
	setSize();
}



/*********************************************************
 * name:	exec_exec
 * description:	Ausfuehren von Programmen starten
 * input:	none
 * output:	none
 * date:	
 *********************************************************/
void	exec_exec_cb (void)
{
	char	*prog;
	Arg	args[1];
	char	buf[1024];

	/*
	 * Die Texte der beiden Textfelder holen
	 */
	XtSetArg(args[0],XtNstring,&prog);
	XtGetValues(text_1,args,1);

	/*
	 * Ueberpruefen ob in beiden ein Text steht, sonst
	 * Warnung ausgeben
	 */
	if (!strlen(prog)) {
		WARNING ("Insuffisant Arguments.\nOperation aborted.");
		return;
	}

	/*
	 * Befehl generieren und ausfuehren
	 */
	exec_exec(prog,NULL);
}


/*********************************************************
 * name:	exec_exec
 * description:	Ausfuehren von Programmen starten
 * input:	none
 * output:	none
 * date:	
 *********************************************************/
void	exec_exec (char	*prog, char *file)
{
	char	buf[1024];

	/*
	 * Befehl generieren und ausfuehren
	 */
	sprintf(buf,"%s &",prog);
	if (SYSTEM(buf)) {
		WARNING("Execution aborted.");
		return;
	}
	else {
		/*
		 * Dialogfenster loeschen
		 */
		if (dialog)
			XtDestroyWidget(dialog);
		dialog = NULL;

		/*
		 * Hier muss ein Update der veranderten Felder kommen
		 * Bisher unvollstaendig. Problem: Feststellen was
		 * veraendert wurde oder ob ueberhaupt etwas veraendert
		 * wurde.
		 */
	}
}



/*********************************************************
 * name:	SYSTEM
 * description:	Ausfuehren von Programmen. Extraroutine notwendig,
 *		da unter Linux z.B. Zombies erzeugt werden.
 * input:	char	*cmd;
 * output:	0 wenn alles gut ging, sonst 1
 * author:	Ove Kalkan
 * date:	5.8.1993
 *********************************************************/
int	SYSTEM (char *cmd)
{
/*
 * Note: If this routine causes trouble while compiling, you are free to
 * exhange it with  return(system(cmd));
 * I had to use such a routine, because Linux creates many zombies when I
 * am using the system(3) call.
 */


	#define	SHELL	"/bin/sh"
	int	pid,status;

	switch ((pid = fork())) {
	case -1:
		return(-1);
	case 0:
		for (status = 3; status < 100; status++)
			close(status);
		execl(SHELL,"sh","-c",cmd,(char *) 0);
		WARNING("System Error: Execl failed!");
		_exit(127);
	default:
		return(0);
	}
}
