/* $Header: /sys/linux-0.96a/kernel/chr_drv/RCS/tpqicint.S,v 0.1.0.2 1992/05/31 14:02:38 root Exp root $
 *
 * Interrupt handler for tape_qic driver. Adapted from kernel/sys_call.s
 *
 * This file contains lowlevel system dependent interrupt code.
 * Hennus Bergman, April 1992.
 *
 * $Log: tpqicint.S,v $
 * Revision 0.1.0.2  1992/05/31  14:02:38  root
 * Corrected typo
 *
 * Revision 0.1.0.1  1992/05/27  12:12:03  root
 * *** empty log message ***
 *
 * Revision 0.1  1992/05/26  01:22:44  root
 * Initial version. Copyright H. H. Bergman 1992
 *
 */

/* file is to be pre-processed by 'cpp' and then assembled by 'gas' */


#define __DEFONLY__
#include <linux/config.h>	/* need IRQ number */

#ifdef CONFIG_TAPE_QIC02

#include <linux/system.h>	/* need IRQ defs */
#include <linux/timer.h>	/* need TAPE_QIC_TIMER */

/* This works as long as the includes only contain 'defines'! */

/* This is called when the tape controller asserts its IRQ line.
 * _tape_qic02_interrupt then calls do_tape_qic02_interrupt(). 
 * No sleeping allowed during interrupts!
 * Note that this code does NOT do 'unexpected_..._interrupt' but
 * it does clear the timer.
 */

	.text
	.globl _tape_qic02_interrupt

	.align 2		# may need '.align 4' in 486 mode
_tape_qic02_interrupt:
	cld			# Clear direction flag. Not sure why
	pushl %eax
	pushl %ecx
	pushl %edx
	push %ds
	push %es
	push %fs
	movl $0x10,%eax
	mov %ax,%ds
	mov %ax,%es
	movl $0x17,%eax
	mov %ax,%fs
	movb $ PIC_EOI, %al	# Need space between $ and PIC_EOI for cpp.

/* do a (static) check to see if we need to send EOI to slave PIC */
#if ((TAPE_QIC02_IRQ>=IRQ8) && (TAPE_QIC02_IRQ<=IRQ15))
	outb %al,$ IO_PIC2	# EOI to slave interrupt controller
	jmp 1f			# give port chance to breathe
1:	jmp 1f
1:	jmp 1f			# CPUs go faster and faster...
#endif
1:	outb %al,$ IO_PIC1	# send EOI to master PIC

/* Disable the timer. */
	andl $~(1 << TAPE_QIC02_TIMER),_timer_active
	call _do_tape_qic02_interrupt
	pop %fs
	pop %es
	pop %ds
	popl %edx
	popl %ecx
	popl %eax
	iret

#endif /* CONFIG_TAPE_QIC02 */
