/*
** yp_networks.h              YP Network map access definitions
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Authors: Peter Eriksson <pen@signum.se>
**          Michael A. Griffith <grif@cs.ucr.edu>
*/

#ifndef __YPLIB_NETWORKS_H__
#define __YPLIB_NETWORKS_H__

#include <sys/types.h>
#include <netdb.h>

extern void yp_setnetent(int stayopen);
extern void yp_endnetent(void);
extern struct netent *yp_getnetent(void);
extern struct netent *yp_getnetbyaddr(long net, int type);
extern struct netent *yp_getnetbyname(const char *name);

#endif
