/*
** hosts.c                           /etc/hosts access functions
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
**
** Copyright (c) 1985, 1988 Regents of the University of California.
** All rights reserved.
** 
** Redistribution and use in source and binary forms, with or without
** modification, are permitted provided that the following conditions
** are met:
** 1. Redistributions of source code must retain the above copyright
**    notice, this list of conditions and the following disclaimer.
** 2. Redistributions in binary form must reproduce the above copyright
**    notice, this list of conditions and the following disclaimer in the
**    documentation and/or other materials provided with the distribution.
** 3. All advertising materials mentioning features or use of this software
**    must display the following acknowledgement:
** 	This product includes software developed by the University of
** 	California, Berkeley and its contributors.
** 4. Neither the name of the University nor the names of its contributors
**    may be used to endorse or promote products derived from this software
**    without specific prior written permission.
** 
** THIS SOFTWARE IS PROVIDED BY THE REGENTS AND CONTRIBUTORS ``AS IS'' AND
** ANY EXPRESS OR IMPLIED WARRANTIES, INCLUDING, BUT NOT LIMITED TO, THE
** IMPLIED WARRANTIES OF MERCHANTABILITY AND FITNESS FOR A PARTICULAR PURPOSE
** ARE DISCLAIMED.  IN NO EVENT SHALL THE REGENTS OR CONTRIBUTORS BE LIABLE
** FOR ANY DIRECT, INDIRECT, INCIDENTAL, SPECIAL, EXEMPLARY, OR CONSEQUENTIAL
** DAMAGES (INCLUDING, BUT NOT LIMITED TO, PROCUREMENT OF SUBSTITUTE GOODS
** OR SERVICES; LOSS OF USE, DATA, OR PROFITS; OR BUSINESS INTERRUPTION)
** HOWEVER CAUSED AND ON ANY THEORY OF LIABILITY, WHETHER IN CONTRACT, STRICT
** LIABILITY, OR TORT (INCLUDING NEGLIGENCE OR OTHERWISE) ARISING IN ANY WAY
** OUT OF THE USE OF THIS SOFTWARE, EVEN IF ADVISED OF THE POSSIBILITY OF
** SUCH DAMAGE.
** -
** Portions Copyright (c) 1993 by Digital Equipment Corporation.
** 
** Permission to use, copy, modify, and distribute this software for any
** purpose with or without fee is hereby granted, provided that the above
** copyright notice and this permission notice appear in all copies, and that
** the name of Digital Equipment Corporation not be used in advertising or
** publicity pertaining to distribution of the document or software without
** specific, written prior permission.
** 
** THE SOFTWARE IS PROVIDED "AS IS" AND DIGITAL EQUIPMENT CORP. DISCLAIMS ALL
** WARRANTIES WITH REGARD TO THIS SOFTWARE, INCLUDING ALL IMPLIED WARRANTIES
** OF MERCHANTABILITY AND FITNESS.   IN NO EVENT SHALL DIGITAL EQUIPMENT
** CORPORATION BE LIABLE FOR ANY SPECIAL, DIRECT, INDIRECT, OR CONSEQUENTIAL
** DAMAGES OR ANY DAMAGES WHATSOEVER RESULTING FROM LOSS OF USE, DATA OR
** PROFITS, WHETHER IN AN ACTION OF CONTRACT, NEGLIGENCE OR OTHER TORTIOUS
** ACTION, ARISING OUT OF OR IN CONNECTION WITH THE USE OR PERFORMANCE OF THIS
** SOFTWARE.
** Author: Peter Eriksson <pen@signum.se>
*/

#include <stdio.h>
#include <string.h>
#include <ctype.h>
#include <netdb.h>
#include <sys/socket.h>
#include <netinet/in.h>
#include <arpa/inet.h>


#define MAXALIASES 35
#define MAXADDRS   35

static FILE *hfp = NULL;
static struct hostent host;
static char *host_aliases[MAXALIASES];
static char hostbuf[BUFSIZ+1];
static char hostaddr[MAXADDRS];
static char *host_addrs[2];
static int stayopen = 0;


void _sethostent(int f)
{
    if (hfp == NULL)
	hfp = fopen(_PATH_HOSTS, "r");
    else
	rewind(hfp);

    stayopen |= f;
}

void _endhostent(void)
{
    if (hfp && !stayopen)
    {
	fclose(hfp);
	hfp = NULL;
    }
}



struct hostent *_gethostent(void)
{
    char *p;
    register char *cp, **q;

    
    if (hfp == NULL)
	_sethostent(0);
    
    if (hfp == NULL)
	return NULL;

  Again:
    if ((p = fgets(hostbuf, BUFSIZ, hfp)) == NULL)
	return (NULL);
    
    if (*p == '#')
	goto Again;
    
    cp = strpbrk(p, "#\n");
    if (cp == NULL)
	goto Again;
    
    *cp = '\0';
    
    cp = strpbrk(p, " \t");
    if (cp == NULL)
	goto Again;
    
    *cp++ = '\0';
    
    /* THIS STUFF IS INTERNET SPECIFIC */
#if BSD >= 43 || defined(h_addr)	/* new-style hostent structure */
    host.h_addr_list = host_addrs;
#endif
    host.h_addr = hostaddr;
    *((unsigned long *)host.h_addr) = inet_addr(p);
    host.h_length = sizeof (unsigned long);
    host.h_addrtype = AF_INET;
    
    while (*cp == ' ' || *cp == '\t')
	cp++;
    
    host.h_name = cp;
    q = host.h_aliases = host_aliases;
    
    cp = strpbrk(cp, " \t");
    if (cp != NULL) 
	*cp++ = '\0';
    
    while (cp && *cp)
    {
	if (*cp == ' ' || *cp == '\t')
	{
	    cp++;
	    continue;
	}
	
	if (q < &host_aliases[MAXALIASES - 1])
	    *q++ = cp;
	
	cp = strpbrk(cp, " \t");
	if (cp != NULL)
	    *cp++ = '\0';
    }
    
    *q = NULL;
    
    return (&host);
}

struct hostent *_gethostbyname(char *name)
{
    struct hostent *hp;
    char **cp;
	

    _sethostent(0);
    while ((hp = _gethostent()) != NULL)
    {
	if (strcasecmp(hp->h_name, name) == 0)
	    break;

	for (cp = hp->h_aliases; cp && *cp; cp++)
	    if (strcasecmp(*cp, name) == 0)
		goto End;
    }

  End:

    _endhostent();

    return hp;
}


struct hostent *_gethostbyaddr(char *addr, int alen, int type)
{
    struct hostent *hp;

    
    _sethostent(0);

    while ((hp = _gethostent()) != NULL)
	if (hp->h_addrtype == type && !memcmp(hp->h_addr, addr, alen))
	    break;

    _endhostent();
    
    return hp;
}
