/*
** nsw_passwd.h           Passwd cover routines for the Name Service Switch
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
*/

#ifndef __NSSWITCH_PASSWD_H__
#define __NSSWITCH_PASSWD_H__

#include <sys/types.h>
#include <pwd.h>

#ifdef ENABLE_NIS
#include "../nis/nis_passwd.h"
#endif

#ifdef ENABLE_YP
#include "../yp/yp_passwd.h"
#endif

#ifdef ENABLE_DNS
#include "../dns/dns_passwd.h"
#endif

void _ENSWF(_setpwent)(void);
void _ENSWF(_endpwent)(void);
struct passwd * _ENSWF(_getpwent)(void);
struct passwd * _ENSWF(_getpwuid)(uid_t uid);
struct passwd * _ENSWF(_getpwnam)(char *name);

#endif
