/*
** hosts_addr.c
**
** Copyright (c) 1993 Signum Support AB, Sweden
**
** This file is part of the NYS Library.
**
** The NYS Library is free software; you can redistribute it and/or
** modify it under the terms of the GNU Library General Public License as
** published by the Free Software Foundation; either version 2 of the
** License, or (at your option) any later version.
**
** The NYS Library is distributed in the hope that it will be useful,
** but WITHOUT ANY WARRANTY; without even the implied warranty of
** MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the GNU
** Library General Public License for more details.
** 
** You should have received a copy of the GNU Library General Public
** License along with the NYS Library; see the file COPYING.LIB.  If
** not, write to the Free Software Foundation, Inc., 675 Mass Ave,
** Cambridge, MA 02139, USA.
**
** Authors: Peter Eriksson <pen@signum.se>
**          Michael A. Griffith <grif@cs.ucr.edu>  
*/

#include <stdio.h>
#include <stdlib.h>
#include <linux/socket.h>
#include <linux/in.h>
#include "yp_hosts.h"
#include "yp_misc.h"

extern void print_hosts(struct hostent *);


int
main(int argc, char *argv[])
{
   struct hostent *host;
   unsigned long test;

   if (argc >= 2)
      test = htonl(_yp_readaddr(argv[1]));

   host = yp_gethostbyaddr((char *) &test, sizeof(unsigned long),
			   AF_INET, NULL);

    if (host)
	print_hosts(host);
    else
	printf("No entry found\n");
    
    exit(0);
}
