#include <sys/types.h>
#include <sys/time.h>
#include <unistd.h>
#include <stdio.h>
#include <sys/ioctl.h>
#include <fcntl.h>
#include <linux/pcmcia.h>

void main(int argc, char *argv[])
  {
  int fd[8], i, ret, val, event;
  struct pcmcia_io_map io;
  struct pcmcia_mem_map mem;
  fd_set fds;

  argv++; argc--;
  for (i = 0; i < argc; i++) {
    fd[i] = open(argv[i], O_RDONLY);
    if (fd[i] < 0) {
      perror("open()");
      exit(-1);
      }
    }

  for (i = 0; i < argc; i++) {
    ret = ioctl(fd[i], PCMCIA_GET_STATUS, &val);
    if (ret < 0) {
      perror("ioctl()");
      exit(-1);
      }
    printf("%s:", argv[i]);
    printf("%s", (val & PC_DETECT) ? " present" : " vacant");
    if (val & PC_READY) printf(" ready");
    if (val & PC_POWERON) printf(" poweron");
    printf("\n");
    }

  for (;;) {
    FD_ZERO(&fds);
    for (i = 0; i < argc; i++) FD_SET(fd[i], &fds);
    ret = select(10, &fds, NULL, NULL, NULL);
    if (ret < 0) {
      perror("ioctl()");
      exit(-1);
      }
    for (i = 0; i < argc; i++)
      if (FD_ISSET(fd[i], &fds)) {
        ret = read(fd[i], &event, 4);
        if (ret != 4) {
          fprintf(stderr, "read() failed: ret = %d\n", ret);
          exit(-1);
          }
        ret = ioctl(fd[i], PCMCIA_GET_STATUS, &val);
        if (ret < 0) {
          perror("ioctl()");
          exit(-1);
          }
        printf("%s:", argv[i]);
        if (event & PC_DETECT)
          printf("%s", (val & PC_DETECT) ? " inserted" : " removed");
        printf("\n");
        }
    } /* big loop */
  }
