/***********************license start***************
 * Copyright (c) 2003-2010  Cavium Networks (support@cavium.com). All rights
 * reserved.
 *
 *
 * Redistribution and use in source and binary forms, with or without
 * modification, are permitted provided that the following conditions are
 * met:
 *
 *   * Redistributions of source code must retain the above copyright
 *     notice, this list of conditions and the following disclaimer.
 *
 *   * Redistributions in binary form must reproduce the above
 *     copyright notice, this list of conditions and the following
 *     disclaimer in the documentation and/or other materials provided
 *     with the distribution.

 *   * Neither the name of Cavium Networks nor the names of
 *     its contributors may be used to endorse or promote products
 *     derived from this software without specific prior written
 *     permission.

 * This Software, including technical data, may be subject to U.S. export  control
 * laws, including the U.S. Export Administration Act and its  associated
 * regulations, and may be subject to export or import  regulations in other
 * countries.

 * TO THE MAXIMUM EXTENT PERMITTED BY LAW, THE SOFTWARE IS PROVIDED "AS IS"
 * AND WITH ALL FAULTS AND CAVIUM  NETWORKS MAKES NO PROMISES, REPRESENTATIONS OR
 * WARRANTIES, EITHER EXPRESS, IMPLIED, STATUTORY, OR OTHERWISE, WITH RESPECT TO
 * THE SOFTWARE, INCLUDING ITS CONDITION, ITS CONFORMITY TO ANY REPRESENTATION OR
 * DESCRIPTION, OR THE EXISTENCE OF ANY LATENT OR PATENT DEFECTS, AND CAVIUM
 * SPECIFICALLY DISCLAIMS ALL IMPLIED (IF ANY) WARRANTIES OF TITLE,
 * MERCHANTABILITY, NONINFRINGEMENT, FITNESS FOR A PARTICULAR PURPOSE, LACK OF
 * VIRUSES, ACCURACY OR COMPLETENESS, QUIET ENJOYMENT, QUIET POSSESSION OR
 * CORRESPONDENCE TO DESCRIPTION. THE ENTIRE  RISK ARISING OUT OF USE OR
 * PERFORMANCE OF THE SOFTWARE LIES WITH YOU.
 ***********************license end**************************************/


/**
 * cvmx-npi-defs.h
 *
 * Configuration and status register (CSR) type definitions for
 * Octeon npi.
 *
 * This file is auto generated. Do not edit.
 *
 * <hr>$Revision$<hr>
 *
 */
#ifndef __CVMX_NPI_TYPEDEFS_H__
#define __CVMX_NPI_TYPEDEFS_H__

#define CVMX_NPI_BASE_ADDR_INPUT0 CVMX_NPI_BASE_ADDR_INPUTX(0)
#define CVMX_NPI_BASE_ADDR_INPUT1 CVMX_NPI_BASE_ADDR_INPUTX(1)
#define CVMX_NPI_BASE_ADDR_INPUT2 CVMX_NPI_BASE_ADDR_INPUTX(2)
#define CVMX_NPI_BASE_ADDR_INPUT3 CVMX_NPI_BASE_ADDR_INPUTX(3)
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_NPI_BASE_ADDR_INPUTX(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN30XX) && ((offset == 0))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN31XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN38XX) && ((offset <= 3))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN50XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN58XX) && ((offset <= 3)))))
		cvmx_warn("CVMX_NPI_BASE_ADDR_INPUTX(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000000070ull) + ((offset) & 3) * 16;
}
#else
#define CVMX_NPI_BASE_ADDR_INPUTX(offset) (CVMX_ADD_IO_SEG(0x00011F0000000070ull) + ((offset) & 3) * 16)
#endif
#define CVMX_NPI_BASE_ADDR_OUTPUT0 CVMX_NPI_BASE_ADDR_OUTPUTX(0)
#define CVMX_NPI_BASE_ADDR_OUTPUT1 CVMX_NPI_BASE_ADDR_OUTPUTX(1)
#define CVMX_NPI_BASE_ADDR_OUTPUT2 CVMX_NPI_BASE_ADDR_OUTPUTX(2)
#define CVMX_NPI_BASE_ADDR_OUTPUT3 CVMX_NPI_BASE_ADDR_OUTPUTX(3)
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_NPI_BASE_ADDR_OUTPUTX(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN30XX) && ((offset == 0))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN31XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN38XX) && ((offset <= 3))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN50XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN58XX) && ((offset <= 3)))))
		cvmx_warn("CVMX_NPI_BASE_ADDR_OUTPUTX(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F00000000B8ull) + ((offset) & 3) * 8;
}
#else
#define CVMX_NPI_BASE_ADDR_OUTPUTX(offset) (CVMX_ADD_IO_SEG(0x00011F00000000B8ull) + ((offset) & 3) * 8)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_BIST_STATUS CVMX_NPI_BIST_STATUS_FUNC()
static inline uint64_t CVMX_NPI_BIST_STATUS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_BIST_STATUS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000003F8ull);
}
#else
#define CVMX_NPI_BIST_STATUS (CVMX_ADD_IO_SEG(0x00011F00000003F8ull))
#endif
#define CVMX_NPI_BUFF_SIZE_OUTPUT0 CVMX_NPI_BUFF_SIZE_OUTPUTX(0)
#define CVMX_NPI_BUFF_SIZE_OUTPUT1 CVMX_NPI_BUFF_SIZE_OUTPUTX(1)
#define CVMX_NPI_BUFF_SIZE_OUTPUT2 CVMX_NPI_BUFF_SIZE_OUTPUTX(2)
#define CVMX_NPI_BUFF_SIZE_OUTPUT3 CVMX_NPI_BUFF_SIZE_OUTPUTX(3)
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_NPI_BUFF_SIZE_OUTPUTX(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN30XX) && ((offset == 0))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN31XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN38XX) && ((offset <= 3))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN50XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN58XX) && ((offset <= 3)))))
		cvmx_warn("CVMX_NPI_BUFF_SIZE_OUTPUTX(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F00000000E0ull) + ((offset) & 3) * 8;
}
#else
#define CVMX_NPI_BUFF_SIZE_OUTPUTX(offset) (CVMX_ADD_IO_SEG(0x00011F00000000E0ull) + ((offset) & 3) * 8)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_COMP_CTL CVMX_NPI_COMP_CTL_FUNC()
static inline uint64_t CVMX_NPI_COMP_CTL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_COMP_CTL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000218ull);
}
#else
#define CVMX_NPI_COMP_CTL (CVMX_ADD_IO_SEG(0x00011F0000000218ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_CTL_STATUS CVMX_NPI_CTL_STATUS_FUNC()
static inline uint64_t CVMX_NPI_CTL_STATUS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_CTL_STATUS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000010ull);
}
#else
#define CVMX_NPI_CTL_STATUS (CVMX_ADD_IO_SEG(0x00011F0000000010ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_DBG_SELECT CVMX_NPI_DBG_SELECT_FUNC()
static inline uint64_t CVMX_NPI_DBG_SELECT_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_DBG_SELECT not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000008ull);
}
#else
#define CVMX_NPI_DBG_SELECT (CVMX_ADD_IO_SEG(0x00011F0000000008ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_DMA_CONTROL CVMX_NPI_DMA_CONTROL_FUNC()
static inline uint64_t CVMX_NPI_DMA_CONTROL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_DMA_CONTROL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000128ull);
}
#else
#define CVMX_NPI_DMA_CONTROL (CVMX_ADD_IO_SEG(0x00011F0000000128ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_DMA_HIGHP_COUNTS CVMX_NPI_DMA_HIGHP_COUNTS_FUNC()
static inline uint64_t CVMX_NPI_DMA_HIGHP_COUNTS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_DMA_HIGHP_COUNTS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000148ull);
}
#else
#define CVMX_NPI_DMA_HIGHP_COUNTS (CVMX_ADD_IO_SEG(0x00011F0000000148ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_DMA_HIGHP_NADDR CVMX_NPI_DMA_HIGHP_NADDR_FUNC()
static inline uint64_t CVMX_NPI_DMA_HIGHP_NADDR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_DMA_HIGHP_NADDR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000158ull);
}
#else
#define CVMX_NPI_DMA_HIGHP_NADDR (CVMX_ADD_IO_SEG(0x00011F0000000158ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_DMA_LOWP_COUNTS CVMX_NPI_DMA_LOWP_COUNTS_FUNC()
static inline uint64_t CVMX_NPI_DMA_LOWP_COUNTS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_DMA_LOWP_COUNTS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000140ull);
}
#else
#define CVMX_NPI_DMA_LOWP_COUNTS (CVMX_ADD_IO_SEG(0x00011F0000000140ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_DMA_LOWP_NADDR CVMX_NPI_DMA_LOWP_NADDR_FUNC()
static inline uint64_t CVMX_NPI_DMA_LOWP_NADDR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_DMA_LOWP_NADDR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000150ull);
}
#else
#define CVMX_NPI_DMA_LOWP_NADDR (CVMX_ADD_IO_SEG(0x00011F0000000150ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_HIGHP_DBELL CVMX_NPI_HIGHP_DBELL_FUNC()
static inline uint64_t CVMX_NPI_HIGHP_DBELL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_HIGHP_DBELL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000120ull);
}
#else
#define CVMX_NPI_HIGHP_DBELL (CVMX_ADD_IO_SEG(0x00011F0000000120ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_HIGHP_IBUFF_SADDR CVMX_NPI_HIGHP_IBUFF_SADDR_FUNC()
static inline uint64_t CVMX_NPI_HIGHP_IBUFF_SADDR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_HIGHP_IBUFF_SADDR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000110ull);
}
#else
#define CVMX_NPI_HIGHP_IBUFF_SADDR (CVMX_ADD_IO_SEG(0x00011F0000000110ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_INPUT_CONTROL CVMX_NPI_INPUT_CONTROL_FUNC()
static inline uint64_t CVMX_NPI_INPUT_CONTROL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_INPUT_CONTROL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000138ull);
}
#else
#define CVMX_NPI_INPUT_CONTROL (CVMX_ADD_IO_SEG(0x00011F0000000138ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_INT_ENB CVMX_NPI_INT_ENB_FUNC()
static inline uint64_t CVMX_NPI_INT_ENB_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_INT_ENB not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000020ull);
}
#else
#define CVMX_NPI_INT_ENB (CVMX_ADD_IO_SEG(0x00011F0000000020ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_INT_SUM CVMX_NPI_INT_SUM_FUNC()
static inline uint64_t CVMX_NPI_INT_SUM_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_INT_SUM not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000018ull);
}
#else
#define CVMX_NPI_INT_SUM (CVMX_ADD_IO_SEG(0x00011F0000000018ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_LOWP_DBELL CVMX_NPI_LOWP_DBELL_FUNC()
static inline uint64_t CVMX_NPI_LOWP_DBELL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_LOWP_DBELL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000118ull);
}
#else
#define CVMX_NPI_LOWP_DBELL (CVMX_ADD_IO_SEG(0x00011F0000000118ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_LOWP_IBUFF_SADDR CVMX_NPI_LOWP_IBUFF_SADDR_FUNC()
static inline uint64_t CVMX_NPI_LOWP_IBUFF_SADDR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_LOWP_IBUFF_SADDR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000108ull);
}
#else
#define CVMX_NPI_LOWP_IBUFF_SADDR (CVMX_ADD_IO_SEG(0x00011F0000000108ull))
#endif
#define CVMX_NPI_MEM_ACCESS_SUBID3 CVMX_NPI_MEM_ACCESS_SUBIDX(3)
#define CVMX_NPI_MEM_ACCESS_SUBID4 CVMX_NPI_MEM_ACCESS_SUBIDX(4)
#define CVMX_NPI_MEM_ACCESS_SUBID5 CVMX_NPI_MEM_ACCESS_SUBIDX(5)
#define CVMX_NPI_MEM_ACCESS_SUBID6 CVMX_NPI_MEM_ACCESS_SUBIDX(6)
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_NPI_MEM_ACCESS_SUBIDX(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN30XX) && (((offset >= 3) && (offset <= 6)))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN31XX) && (((offset >= 3) && (offset <= 6)))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN38XX) && (((offset >= 3) && (offset <= 6)))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN50XX) && (((offset >= 3) && (offset <= 6)))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN58XX) && (((offset >= 3) && (offset <= 6))))))
		cvmx_warn("CVMX_NPI_MEM_ACCESS_SUBIDX(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000000028ull) + ((offset) & 7) * 8 - 8*3;
}
#else
#define CVMX_NPI_MEM_ACCESS_SUBIDX(offset) (CVMX_ADD_IO_SEG(0x00011F0000000028ull) + ((offset) & 7) * 8 - 8*3)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_MSI_RCV CVMX_NPI_MSI_RCV_FUNC()
static inline uint64_t CVMX_NPI_MSI_RCV_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_MSI_RCV not supported on this chip\n");
	return 0x0000000000000190ull;
}
#else
#define CVMX_NPI_MSI_RCV (0x0000000000000190ull)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_NPI_MSI_RCV CVMX_NPI_NPI_MSI_RCV_FUNC()
static inline uint64_t CVMX_NPI_NPI_MSI_RCV_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_NPI_MSI_RCV not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001190ull);
}
#else
#define CVMX_NPI_NPI_MSI_RCV (CVMX_ADD_IO_SEG(0x00011F0000001190ull))
#endif
#define CVMX_NPI_NUM_DESC_OUTPUT0 CVMX_NPI_NUM_DESC_OUTPUTX(0)
#define CVMX_NPI_NUM_DESC_OUTPUT1 CVMX_NPI_NUM_DESC_OUTPUTX(1)
#define CVMX_NPI_NUM_DESC_OUTPUT2 CVMX_NPI_NUM_DESC_OUTPUTX(2)
#define CVMX_NPI_NUM_DESC_OUTPUT3 CVMX_NPI_NUM_DESC_OUTPUTX(3)
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_NPI_NUM_DESC_OUTPUTX(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN30XX) && ((offset == 0))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN31XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN38XX) && ((offset <= 3))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN50XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN58XX) && ((offset <= 3)))))
		cvmx_warn("CVMX_NPI_NUM_DESC_OUTPUTX(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000000050ull) + ((offset) & 3) * 8;
}
#else
#define CVMX_NPI_NUM_DESC_OUTPUTX(offset) (CVMX_ADD_IO_SEG(0x00011F0000000050ull) + ((offset) & 3) * 8)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_OUTPUT_CONTROL CVMX_NPI_OUTPUT_CONTROL_FUNC()
static inline uint64_t CVMX_NPI_OUTPUT_CONTROL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_OUTPUT_CONTROL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000100ull);
}
#else
#define CVMX_NPI_OUTPUT_CONTROL (CVMX_ADD_IO_SEG(0x00011F0000000100ull))
#endif
#define CVMX_NPI_P0_DBPAIR_ADDR CVMX_NPI_PX_DBPAIR_ADDR(0)
#define CVMX_NPI_P0_INSTR_ADDR CVMX_NPI_PX_INSTR_ADDR(0)
#define CVMX_NPI_P0_INSTR_CNTS CVMX_NPI_PX_INSTR_CNTS(0)
#define CVMX_NPI_P0_PAIR_CNTS CVMX_NPI_PX_PAIR_CNTS(0)
#define CVMX_NPI_P1_DBPAIR_ADDR CVMX_NPI_PX_DBPAIR_ADDR(1)
#define CVMX_NPI_P1_INSTR_ADDR CVMX_NPI_PX_INSTR_ADDR(1)
#define CVMX_NPI_P1_INSTR_CNTS CVMX_NPI_PX_INSTR_CNTS(1)
#define CVMX_NPI_P1_PAIR_CNTS CVMX_NPI_PX_PAIR_CNTS(1)
#define CVMX_NPI_P2_DBPAIR_ADDR CVMX_NPI_PX_DBPAIR_ADDR(2)
#define CVMX_NPI_P2_INSTR_ADDR CVMX_NPI_PX_INSTR_ADDR(2)
#define CVMX_NPI_P2_INSTR_CNTS CVMX_NPI_PX_INSTR_CNTS(2)
#define CVMX_NPI_P2_PAIR_CNTS CVMX_NPI_PX_PAIR_CNTS(2)
#define CVMX_NPI_P3_DBPAIR_ADDR CVMX_NPI_PX_DBPAIR_ADDR(3)
#define CVMX_NPI_P3_INSTR_ADDR CVMX_NPI_PX_INSTR_ADDR(3)
#define CVMX_NPI_P3_INSTR_CNTS CVMX_NPI_PX_INSTR_CNTS(3)
#define CVMX_NPI_P3_PAIR_CNTS CVMX_NPI_PX_PAIR_CNTS(3)
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_NPI_PCI_BAR1_INDEXX(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN30XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN31XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN38XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN50XX) && ((offset <= 31))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN58XX) && ((offset <= 31)))))
		cvmx_warn("CVMX_NPI_PCI_BAR1_INDEXX(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000001100ull) + ((offset) & 31) * 4;
}
#else
#define CVMX_NPI_PCI_BAR1_INDEXX(offset) (CVMX_ADD_IO_SEG(0x00011F0000001100ull) + ((offset) & 31) * 4)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_BIST_REG CVMX_NPI_PCI_BIST_REG_FUNC()
static inline uint64_t CVMX_NPI_PCI_BIST_REG_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN50XX)))
		cvmx_warn("CVMX_NPI_PCI_BIST_REG not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000011C0ull);
}
#else
#define CVMX_NPI_PCI_BIST_REG (CVMX_ADD_IO_SEG(0x00011F00000011C0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_BURST_SIZE CVMX_NPI_PCI_BURST_SIZE_FUNC()
static inline uint64_t CVMX_NPI_PCI_BURST_SIZE_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_BURST_SIZE not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000000D8ull);
}
#else
#define CVMX_NPI_PCI_BURST_SIZE (CVMX_ADD_IO_SEG(0x00011F00000000D8ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG00 CVMX_NPI_PCI_CFG00_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG00_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG00 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001800ull);
}
#else
#define CVMX_NPI_PCI_CFG00 (CVMX_ADD_IO_SEG(0x00011F0000001800ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG01 CVMX_NPI_PCI_CFG01_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG01_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG01 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001804ull);
}
#else
#define CVMX_NPI_PCI_CFG01 (CVMX_ADD_IO_SEG(0x00011F0000001804ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG02 CVMX_NPI_PCI_CFG02_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG02_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG02 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001808ull);
}
#else
#define CVMX_NPI_PCI_CFG02 (CVMX_ADD_IO_SEG(0x00011F0000001808ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG03 CVMX_NPI_PCI_CFG03_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG03_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG03 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000180Cull);
}
#else
#define CVMX_NPI_PCI_CFG03 (CVMX_ADD_IO_SEG(0x00011F000000180Cull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG04 CVMX_NPI_PCI_CFG04_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG04_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG04 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001810ull);
}
#else
#define CVMX_NPI_PCI_CFG04 (CVMX_ADD_IO_SEG(0x00011F0000001810ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG05 CVMX_NPI_PCI_CFG05_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG05_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG05 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001814ull);
}
#else
#define CVMX_NPI_PCI_CFG05 (CVMX_ADD_IO_SEG(0x00011F0000001814ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG06 CVMX_NPI_PCI_CFG06_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG06_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG06 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001818ull);
}
#else
#define CVMX_NPI_PCI_CFG06 (CVMX_ADD_IO_SEG(0x00011F0000001818ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG07 CVMX_NPI_PCI_CFG07_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG07_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG07 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000181Cull);
}
#else
#define CVMX_NPI_PCI_CFG07 (CVMX_ADD_IO_SEG(0x00011F000000181Cull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG08 CVMX_NPI_PCI_CFG08_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG08_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG08 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001820ull);
}
#else
#define CVMX_NPI_PCI_CFG08 (CVMX_ADD_IO_SEG(0x00011F0000001820ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG09 CVMX_NPI_PCI_CFG09_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG09_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG09 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001824ull);
}
#else
#define CVMX_NPI_PCI_CFG09 (CVMX_ADD_IO_SEG(0x00011F0000001824ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG10 CVMX_NPI_PCI_CFG10_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG10_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG10 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001828ull);
}
#else
#define CVMX_NPI_PCI_CFG10 (CVMX_ADD_IO_SEG(0x00011F0000001828ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG11 CVMX_NPI_PCI_CFG11_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG11_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG11 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000182Cull);
}
#else
#define CVMX_NPI_PCI_CFG11 (CVMX_ADD_IO_SEG(0x00011F000000182Cull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG12 CVMX_NPI_PCI_CFG12_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG12_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG12 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001830ull);
}
#else
#define CVMX_NPI_PCI_CFG12 (CVMX_ADD_IO_SEG(0x00011F0000001830ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG13 CVMX_NPI_PCI_CFG13_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG13_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG13 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001834ull);
}
#else
#define CVMX_NPI_PCI_CFG13 (CVMX_ADD_IO_SEG(0x00011F0000001834ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG15 CVMX_NPI_PCI_CFG15_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG15_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG15 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000183Cull);
}
#else
#define CVMX_NPI_PCI_CFG15 (CVMX_ADD_IO_SEG(0x00011F000000183Cull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG16 CVMX_NPI_PCI_CFG16_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG16_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG16 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001840ull);
}
#else
#define CVMX_NPI_PCI_CFG16 (CVMX_ADD_IO_SEG(0x00011F0000001840ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG17 CVMX_NPI_PCI_CFG17_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG17_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG17 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001844ull);
}
#else
#define CVMX_NPI_PCI_CFG17 (CVMX_ADD_IO_SEG(0x00011F0000001844ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG18 CVMX_NPI_PCI_CFG18_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG18_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG18 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001848ull);
}
#else
#define CVMX_NPI_PCI_CFG18 (CVMX_ADD_IO_SEG(0x00011F0000001848ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG19 CVMX_NPI_PCI_CFG19_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG19_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG19 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000184Cull);
}
#else
#define CVMX_NPI_PCI_CFG19 (CVMX_ADD_IO_SEG(0x00011F000000184Cull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG20 CVMX_NPI_PCI_CFG20_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG20_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG20 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001850ull);
}
#else
#define CVMX_NPI_PCI_CFG20 (CVMX_ADD_IO_SEG(0x00011F0000001850ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG21 CVMX_NPI_PCI_CFG21_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG21_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG21 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001854ull);
}
#else
#define CVMX_NPI_PCI_CFG21 (CVMX_ADD_IO_SEG(0x00011F0000001854ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG22 CVMX_NPI_PCI_CFG22_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG22_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG22 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001858ull);
}
#else
#define CVMX_NPI_PCI_CFG22 (CVMX_ADD_IO_SEG(0x00011F0000001858ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG56 CVMX_NPI_PCI_CFG56_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG56_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG56 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000018E0ull);
}
#else
#define CVMX_NPI_PCI_CFG56 (CVMX_ADD_IO_SEG(0x00011F00000018E0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG57 CVMX_NPI_PCI_CFG57_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG57_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG57 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000018E4ull);
}
#else
#define CVMX_NPI_PCI_CFG57 (CVMX_ADD_IO_SEG(0x00011F00000018E4ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG58 CVMX_NPI_PCI_CFG58_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG58_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG58 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000018E8ull);
}
#else
#define CVMX_NPI_PCI_CFG58 (CVMX_ADD_IO_SEG(0x00011F00000018E8ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG59 CVMX_NPI_PCI_CFG59_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG59_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG59 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000018ECull);
}
#else
#define CVMX_NPI_PCI_CFG59 (CVMX_ADD_IO_SEG(0x00011F00000018ECull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG60 CVMX_NPI_PCI_CFG60_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG60_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG60 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000018F0ull);
}
#else
#define CVMX_NPI_PCI_CFG60 (CVMX_ADD_IO_SEG(0x00011F00000018F0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG61 CVMX_NPI_PCI_CFG61_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG61_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG61 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000018F4ull);
}
#else
#define CVMX_NPI_PCI_CFG61 (CVMX_ADD_IO_SEG(0x00011F00000018F4ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG62 CVMX_NPI_PCI_CFG62_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG62_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG62 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000018F8ull);
}
#else
#define CVMX_NPI_PCI_CFG62 (CVMX_ADD_IO_SEG(0x00011F00000018F8ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CFG63 CVMX_NPI_PCI_CFG63_FUNC()
static inline uint64_t CVMX_NPI_PCI_CFG63_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CFG63 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000018FCull);
}
#else
#define CVMX_NPI_PCI_CFG63 (CVMX_ADD_IO_SEG(0x00011F00000018FCull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CNT_REG CVMX_NPI_PCI_CNT_REG_FUNC()
static inline uint64_t CVMX_NPI_PCI_CNT_REG_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CNT_REG not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000011B8ull);
}
#else
#define CVMX_NPI_PCI_CNT_REG (CVMX_ADD_IO_SEG(0x00011F00000011B8ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_CTL_STATUS_2 CVMX_NPI_PCI_CTL_STATUS_2_FUNC()
static inline uint64_t CVMX_NPI_PCI_CTL_STATUS_2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_CTL_STATUS_2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F000000118Cull);
}
#else
#define CVMX_NPI_PCI_CTL_STATUS_2 (CVMX_ADD_IO_SEG(0x00011F000000118Cull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_INT_ARB_CFG CVMX_NPI_PCI_INT_ARB_CFG_FUNC()
static inline uint64_t CVMX_NPI_PCI_INT_ARB_CFG_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_INT_ARB_CFG not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000130ull);
}
#else
#define CVMX_NPI_PCI_INT_ARB_CFG (CVMX_ADD_IO_SEG(0x00011F0000000130ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_INT_ENB2 CVMX_NPI_PCI_INT_ENB2_FUNC()
static inline uint64_t CVMX_NPI_PCI_INT_ENB2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_INT_ENB2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000011A0ull);
}
#else
#define CVMX_NPI_PCI_INT_ENB2 (CVMX_ADD_IO_SEG(0x00011F00000011A0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_INT_SUM2 CVMX_NPI_PCI_INT_SUM2_FUNC()
static inline uint64_t CVMX_NPI_PCI_INT_SUM2_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_INT_SUM2 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001198ull);
}
#else
#define CVMX_NPI_PCI_INT_SUM2 (CVMX_ADD_IO_SEG(0x00011F0000001198ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_READ_CMD CVMX_NPI_PCI_READ_CMD_FUNC()
static inline uint64_t CVMX_NPI_PCI_READ_CMD_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_READ_CMD not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000048ull);
}
#else
#define CVMX_NPI_PCI_READ_CMD (CVMX_ADD_IO_SEG(0x00011F0000000048ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_READ_CMD_6 CVMX_NPI_PCI_READ_CMD_6_FUNC()
static inline uint64_t CVMX_NPI_PCI_READ_CMD_6_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_READ_CMD_6 not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001180ull);
}
#else
#define CVMX_NPI_PCI_READ_CMD_6 (CVMX_ADD_IO_SEG(0x00011F0000001180ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_READ_CMD_C CVMX_NPI_PCI_READ_CMD_C_FUNC()
static inline uint64_t CVMX_NPI_PCI_READ_CMD_C_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_READ_CMD_C not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001184ull);
}
#else
#define CVMX_NPI_PCI_READ_CMD_C (CVMX_ADD_IO_SEG(0x00011F0000001184ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_READ_CMD_E CVMX_NPI_PCI_READ_CMD_E_FUNC()
static inline uint64_t CVMX_NPI_PCI_READ_CMD_E_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_READ_CMD_E not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000001188ull);
}
#else
#define CVMX_NPI_PCI_READ_CMD_E (CVMX_ADD_IO_SEG(0x00011F0000001188ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_SCM_REG CVMX_NPI_PCI_SCM_REG_FUNC()
static inline uint64_t CVMX_NPI_PCI_SCM_REG_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_SCM_REG not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000011A8ull);
}
#else
#define CVMX_NPI_PCI_SCM_REG (CVMX_ADD_IO_SEG(0x00011F00000011A8ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PCI_TSR_REG CVMX_NPI_PCI_TSR_REG_FUNC()
static inline uint64_t CVMX_NPI_PCI_TSR_REG_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PCI_TSR_REG not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000011B0ull);
}
#else
#define CVMX_NPI_PCI_TSR_REG (CVMX_ADD_IO_SEG(0x00011F00000011B0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PORT32_INSTR_HDR CVMX_NPI_PORT32_INSTR_HDR_FUNC()
static inline uint64_t CVMX_NPI_PORT32_INSTR_HDR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PORT32_INSTR_HDR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000001F8ull);
}
#else
#define CVMX_NPI_PORT32_INSTR_HDR (CVMX_ADD_IO_SEG(0x00011F00000001F8ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PORT33_INSTR_HDR CVMX_NPI_PORT33_INSTR_HDR_FUNC()
static inline uint64_t CVMX_NPI_PORT33_INSTR_HDR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN31XX) || OCTEON_IS_MODEL(OCTEON_CN38XX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PORT33_INSTR_HDR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000200ull);
}
#else
#define CVMX_NPI_PORT33_INSTR_HDR (CVMX_ADD_IO_SEG(0x00011F0000000200ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PORT34_INSTR_HDR CVMX_NPI_PORT34_INSTR_HDR_FUNC()
static inline uint64_t CVMX_NPI_PORT34_INSTR_HDR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN38XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PORT34_INSTR_HDR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000208ull);
}
#else
#define CVMX_NPI_PORT34_INSTR_HDR (CVMX_ADD_IO_SEG(0x00011F0000000208ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PORT35_INSTR_HDR CVMX_NPI_PORT35_INSTR_HDR_FUNC()
static inline uint64_t CVMX_NPI_PORT35_INSTR_HDR_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN38XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PORT35_INSTR_HDR not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000210ull);
}
#else
#define CVMX_NPI_PORT35_INSTR_HDR (CVMX_ADD_IO_SEG(0x00011F0000000210ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_PORT_BP_CONTROL CVMX_NPI_PORT_BP_CONTROL_FUNC()
static inline uint64_t CVMX_NPI_PORT_BP_CONTROL_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_PORT_BP_CONTROL not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000001F0ull);
}
#else
#define CVMX_NPI_PORT_BP_CONTROL (CVMX_ADD_IO_SEG(0x00011F00000001F0ull))
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_NPI_PX_DBPAIR_ADDR(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN30XX) && ((offset == 0))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN31XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN38XX) && ((offset <= 3))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN50XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN58XX) && ((offset <= 3)))))
		cvmx_warn("CVMX_NPI_PX_DBPAIR_ADDR(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000000180ull) + ((offset) & 3) * 8;
}
#else
#define CVMX_NPI_PX_DBPAIR_ADDR(offset) (CVMX_ADD_IO_SEG(0x00011F0000000180ull) + ((offset) & 3) * 8)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_NPI_PX_INSTR_ADDR(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN30XX) && ((offset == 0))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN31XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN38XX) && ((offset <= 3))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN50XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN58XX) && ((offset <= 3)))))
		cvmx_warn("CVMX_NPI_PX_INSTR_ADDR(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F00000001C0ull) + ((offset) & 3) * 8;
}
#else
#define CVMX_NPI_PX_INSTR_ADDR(offset) (CVMX_ADD_IO_SEG(0x00011F00000001C0ull) + ((offset) & 3) * 8)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_NPI_PX_INSTR_CNTS(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN30XX) && ((offset == 0))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN31XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN38XX) && ((offset <= 3))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN50XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN58XX) && ((offset <= 3)))))
		cvmx_warn("CVMX_NPI_PX_INSTR_CNTS(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F00000001A0ull) + ((offset) & 3) * 8;
}
#else
#define CVMX_NPI_PX_INSTR_CNTS(offset) (CVMX_ADD_IO_SEG(0x00011F00000001A0ull) + ((offset) & 3) * 8)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_NPI_PX_PAIR_CNTS(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN30XX) && ((offset == 0))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN31XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN38XX) && ((offset <= 3))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN50XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN58XX) && ((offset <= 3)))))
		cvmx_warn("CVMX_NPI_PX_PAIR_CNTS(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000000160ull) + ((offset) & 3) * 8;
}
#else
#define CVMX_NPI_PX_PAIR_CNTS(offset) (CVMX_ADD_IO_SEG(0x00011F0000000160ull) + ((offset) & 3) * 8)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_RSL_INT_BLOCKS CVMX_NPI_RSL_INT_BLOCKS_FUNC()
static inline uint64_t CVMX_NPI_RSL_INT_BLOCKS_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_RSL_INT_BLOCKS not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F0000000000ull);
}
#else
#define CVMX_NPI_RSL_INT_BLOCKS (CVMX_ADD_IO_SEG(0x00011F0000000000ull))
#endif
#define CVMX_NPI_SIZE_INPUT0 CVMX_NPI_SIZE_INPUTX(0)
#define CVMX_NPI_SIZE_INPUT1 CVMX_NPI_SIZE_INPUTX(1)
#define CVMX_NPI_SIZE_INPUT2 CVMX_NPI_SIZE_INPUTX(2)
#define CVMX_NPI_SIZE_INPUT3 CVMX_NPI_SIZE_INPUTX(3)
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
static inline uint64_t CVMX_NPI_SIZE_INPUTX(unsigned long offset)
{
	if (!(
	      (OCTEON_IS_MODEL(OCTEON_CN30XX) && ((offset == 0))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN31XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN38XX) && ((offset <= 3))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN50XX) && ((offset <= 1))) ||
	      (OCTEON_IS_MODEL(OCTEON_CN58XX) && ((offset <= 3)))))
		cvmx_warn("CVMX_NPI_SIZE_INPUTX(%lu) is invalid on this chip\n", offset);
	return CVMX_ADD_IO_SEG(0x00011F0000000078ull) + ((offset) & 3) * 16;
}
#else
#define CVMX_NPI_SIZE_INPUTX(offset) (CVMX_ADD_IO_SEG(0x00011F0000000078ull) + ((offset) & 3) * 16)
#endif
#if CVMX_ENABLE_CSR_ADDRESS_CHECKING
#define CVMX_NPI_WIN_READ_TO CVMX_NPI_WIN_READ_TO_FUNC()
static inline uint64_t CVMX_NPI_WIN_READ_TO_FUNC(void)
{
	if (!(OCTEON_IS_MODEL(OCTEON_CN3XXX) || OCTEON_IS_MODEL(OCTEON_CN50XX) || OCTEON_IS_MODEL(OCTEON_CN58XX)))
		cvmx_warn("CVMX_NPI_WIN_READ_TO not supported on this chip\n");
	return CVMX_ADD_IO_SEG(0x00011F00000001E0ull);
}
#else
#define CVMX_NPI_WIN_READ_TO (CVMX_ADD_IO_SEG(0x00011F00000001E0ull))
#endif

/**
 * cvmx_npi_base_addr_input#
 *
 * NPI_BASE_ADDR_INPUT0 = NPI's Base Address Input 0 Register
 *
 * The address to start reading Instructions from for Input-0.
 */
union cvmx_npi_base_addr_inputx
{
	uint64_t u64;
	struct cvmx_npi_base_addr_inputx_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t baddr                        : 61; /**< The address to read Instruction from for output 0.
                                                         This address is 8-byte aligned, for this reason
                                                         address bits [2:0] will always be zero. */
	uint64_t reserved_0_2                 : 3;
#else
	uint64_t reserved_0_2                 : 3;
	uint64_t baddr                        : 61;
#endif
	} s;
	struct cvmx_npi_base_addr_inputx_s    cn30xx;
	struct cvmx_npi_base_addr_inputx_s    cn31xx;
	struct cvmx_npi_base_addr_inputx_s    cn38xx;
	struct cvmx_npi_base_addr_inputx_s    cn38xxp2;
	struct cvmx_npi_base_addr_inputx_s    cn50xx;
	struct cvmx_npi_base_addr_inputx_s    cn58xx;
	struct cvmx_npi_base_addr_inputx_s    cn58xxp1;
};
typedef union cvmx_npi_base_addr_inputx cvmx_npi_base_addr_inputx_t;

/**
 * cvmx_npi_base_addr_output#
 *
 * NPI_BASE_ADDR_OUTPUT0 = NPI's Base Address Output 0 Register
 *
 * The address to start reading Instructions from for Output-0.
 */
union cvmx_npi_base_addr_outputx
{
	uint64_t u64;
	struct cvmx_npi_base_addr_outputx_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t baddr                        : 61; /**< The address to read Instruction from for output 0.
                                                         This address is 8-byte aligned, for this reason
                                                         address bits [2:0] will always be zero. */
	uint64_t reserved_0_2                 : 3;
#else
	uint64_t reserved_0_2                 : 3;
	uint64_t baddr                        : 61;
#endif
	} s;
	struct cvmx_npi_base_addr_outputx_s   cn30xx;
	struct cvmx_npi_base_addr_outputx_s   cn31xx;
	struct cvmx_npi_base_addr_outputx_s   cn38xx;
	struct cvmx_npi_base_addr_outputx_s   cn38xxp2;
	struct cvmx_npi_base_addr_outputx_s   cn50xx;
	struct cvmx_npi_base_addr_outputx_s   cn58xx;
	struct cvmx_npi_base_addr_outputx_s   cn58xxp1;
};
typedef union cvmx_npi_base_addr_outputx cvmx_npi_base_addr_outputx_t;

/**
 * cvmx_npi_bist_status
 *
 * NPI_BIST_STATUS = NPI's BIST Status Register
 *
 * Results from BIST runs of NPI's memories.
 */
union cvmx_npi_bist_status
{
	uint64_t u64;
	struct cvmx_npi_bist_status_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_20_63               : 44;
	uint64_t csr_bs                       : 1;  /**< BIST Status for the csr_fifo */
	uint64_t dif_bs                       : 1;  /**< BIST Status for the dif_fifo */
	uint64_t rdp_bs                       : 1;  /**< BIST Status for the rdp_fifo */
	uint64_t pcnc_bs                      : 1;  /**< BIST Status for the pcn_cnt_fifo */
	uint64_t pcn_bs                       : 1;  /**< BIST Status for the pcn_fifo */
	uint64_t rdn_bs                       : 1;  /**< BIST Status for the rdn_fifo */
	uint64_t pcac_bs                      : 1;  /**< BIST Status for the pca_cmd_fifo */
	uint64_t pcad_bs                      : 1;  /**< BIST Status for the pca_data_fifo */
	uint64_t rdnl_bs                      : 1;  /**< BIST Status for the rdn_length_fifo */
	uint64_t pgf_bs                       : 1;  /**< BIST Status for the pgf_fifo */
	uint64_t pig_bs                       : 1;  /**< BIST Status for the pig_fifo */
	uint64_t pof0_bs                      : 1;  /**< BIST Status for the pof0_fifo */
	uint64_t pof1_bs                      : 1;  /**< BIST Status for the pof1_fifo */
	uint64_t pof2_bs                      : 1;  /**< BIST Status for the pof2_fifo */
	uint64_t pof3_bs                      : 1;  /**< BIST Status for the pof3_fifo */
	uint64_t pos_bs                       : 1;  /**< BIST Status for the pos_fifo */
	uint64_t nus_bs                       : 1;  /**< BIST Status for the nus_fifo */
	uint64_t dob_bs                       : 1;  /**< BIST Status for the dob_fifo */
	uint64_t pdf_bs                       : 1;  /**< BIST Status for the pdf_fifo */
	uint64_t dpi_bs                       : 1;  /**< BIST Status for the dpi_fifo */
#else
	uint64_t dpi_bs                       : 1;
	uint64_t pdf_bs                       : 1;
	uint64_t dob_bs                       : 1;
	uint64_t nus_bs                       : 1;
	uint64_t pos_bs                       : 1;
	uint64_t pof3_bs                      : 1;
	uint64_t pof2_bs                      : 1;
	uint64_t pof1_bs                      : 1;
	uint64_t pof0_bs                      : 1;
	uint64_t pig_bs                       : 1;
	uint64_t pgf_bs                       : 1;
	uint64_t rdnl_bs                      : 1;
	uint64_t pcad_bs                      : 1;
	uint64_t pcac_bs                      : 1;
	uint64_t rdn_bs                       : 1;
	uint64_t pcn_bs                       : 1;
	uint64_t pcnc_bs                      : 1;
	uint64_t rdp_bs                       : 1;
	uint64_t dif_bs                       : 1;
	uint64_t csr_bs                       : 1;
	uint64_t reserved_20_63               : 44;
#endif
	} s;
	struct cvmx_npi_bist_status_cn30xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_20_63               : 44;
	uint64_t csr_bs                       : 1;  /**< BIST Status for the csr_fifo */
	uint64_t dif_bs                       : 1;  /**< BIST Status for the dif_fifo */
	uint64_t rdp_bs                       : 1;  /**< BIST Status for the rdp_fifo */
	uint64_t pcnc_bs                      : 1;  /**< BIST Status for the pcn_cnt_fifo */
	uint64_t pcn_bs                       : 1;  /**< BIST Status for the pcn_fifo */
	uint64_t rdn_bs                       : 1;  /**< BIST Status for the rdn_fifo */
	uint64_t pcac_bs                      : 1;  /**< BIST Status for the pca_cmd_fifo */
	uint64_t pcad_bs                      : 1;  /**< BIST Status for the pca_data_fifo */
	uint64_t rdnl_bs                      : 1;  /**< BIST Status for the rdn_length_fifo */
	uint64_t pgf_bs                       : 1;  /**< BIST Status for the pgf_fifo */
	uint64_t pig_bs                       : 1;  /**< BIST Status for the pig_fifo */
	uint64_t pof0_bs                      : 1;  /**< BIST Status for the pof0_fifo */
	uint64_t reserved_5_7                 : 3;
	uint64_t pos_bs                       : 1;  /**< BIST Status for the pos_fifo */
	uint64_t nus_bs                       : 1;  /**< BIST Status for the nus_fifo */
	uint64_t dob_bs                       : 1;  /**< BIST Status for the dob_fifo */
	uint64_t pdf_bs                       : 1;  /**< BIST Status for the pdf_fifo */
	uint64_t dpi_bs                       : 1;  /**< BIST Status for the dpi_fifo */
#else
	uint64_t dpi_bs                       : 1;
	uint64_t pdf_bs                       : 1;
	uint64_t dob_bs                       : 1;
	uint64_t nus_bs                       : 1;
	uint64_t pos_bs                       : 1;
	uint64_t reserved_5_7                 : 3;
	uint64_t pof0_bs                      : 1;
	uint64_t pig_bs                       : 1;
	uint64_t pgf_bs                       : 1;
	uint64_t rdnl_bs                      : 1;
	uint64_t pcad_bs                      : 1;
	uint64_t pcac_bs                      : 1;
	uint64_t rdn_bs                       : 1;
	uint64_t pcn_bs                       : 1;
	uint64_t pcnc_bs                      : 1;
	uint64_t rdp_bs                       : 1;
	uint64_t dif_bs                       : 1;
	uint64_t csr_bs                       : 1;
	uint64_t reserved_20_63               : 44;
#endif
	} cn30xx;
	struct cvmx_npi_bist_status_s         cn31xx;
	struct cvmx_npi_bist_status_s         cn38xx;
	struct cvmx_npi_bist_status_s         cn38xxp2;
	struct cvmx_npi_bist_status_cn50xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_20_63               : 44;
	uint64_t csr_bs                       : 1;  /**< BIST Status for the csr_fifo */
	uint64_t dif_bs                       : 1;  /**< BIST Status for the dif_fifo */
	uint64_t rdp_bs                       : 1;  /**< BIST Status for the rdp_fifo */
	uint64_t pcnc_bs                      : 1;  /**< BIST Status for the pcn_cnt_fifo */
	uint64_t pcn_bs                       : 1;  /**< BIST Status for the pcn_fifo */
	uint64_t rdn_bs                       : 1;  /**< BIST Status for the rdn_fifo */
	uint64_t pcac_bs                      : 1;  /**< BIST Status for the pca_cmd_fifo */
	uint64_t pcad_bs                      : 1;  /**< BIST Status for the pca_data_fifo */
	uint64_t rdnl_bs                      : 1;  /**< BIST Status for the rdn_length_fifo */
	uint64_t pgf_bs                       : 1;  /**< BIST Status for the pgf_fifo */
	uint64_t pig_bs                       : 1;  /**< BIST Status for the pig_fifo */
	uint64_t pof0_bs                      : 1;  /**< BIST Status for the pof0_fifo */
	uint64_t pof1_bs                      : 1;  /**< BIST Status for the pof1_fifo */
	uint64_t reserved_5_6                 : 2;
	uint64_t pos_bs                       : 1;  /**< BIST Status for the pos_fifo */
	uint64_t nus_bs                       : 1;  /**< BIST Status for the nus_fifo */
	uint64_t dob_bs                       : 1;  /**< BIST Status for the dob_fifo */
	uint64_t pdf_bs                       : 1;  /**< BIST Status for the pdf_fifo */
	uint64_t dpi_bs                       : 1;  /**< BIST Status for the dpi_fifo */
#else
	uint64_t dpi_bs                       : 1;
	uint64_t pdf_bs                       : 1;
	uint64_t dob_bs                       : 1;
	uint64_t nus_bs                       : 1;
	uint64_t pos_bs                       : 1;
	uint64_t reserved_5_6                 : 2;
	uint64_t pof1_bs                      : 1;
	uint64_t pof0_bs                      : 1;
	uint64_t pig_bs                       : 1;
	uint64_t pgf_bs                       : 1;
	uint64_t rdnl_bs                      : 1;
	uint64_t pcad_bs                      : 1;
	uint64_t pcac_bs                      : 1;
	uint64_t rdn_bs                       : 1;
	uint64_t pcn_bs                       : 1;
	uint64_t pcnc_bs                      : 1;
	uint64_t rdp_bs                       : 1;
	uint64_t dif_bs                       : 1;
	uint64_t csr_bs                       : 1;
	uint64_t reserved_20_63               : 44;
#endif
	} cn50xx;
	struct cvmx_npi_bist_status_s         cn58xx;
	struct cvmx_npi_bist_status_s         cn58xxp1;
};
typedef union cvmx_npi_bist_status cvmx_npi_bist_status_t;

/**
 * cvmx_npi_buff_size_output#
 *
 * NPI_BUFF_SIZE_OUTPUT0 = NPI's D/I Buffer Sizes For Output 0
 *
 * The size in bytes of the Data Bufffer and Information Buffer for output 0.
 */
union cvmx_npi_buff_size_outputx
{
	uint64_t u64;
	struct cvmx_npi_buff_size_outputx_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_23_63               : 41;
	uint64_t isize                        : 7;  /**< The number of bytes to move to the Info-Pointer
                                                         from the front of the packet.
                                                         Legal values are 0-120. */
	uint64_t bsize                        : 16; /**< The size in bytes of the area pointed to by
                                                         buffer pointer for output packet data. */
#else
	uint64_t bsize                        : 16;
	uint64_t isize                        : 7;
	uint64_t reserved_23_63               : 41;
#endif
	} s;
	struct cvmx_npi_buff_size_outputx_s   cn30xx;
	struct cvmx_npi_buff_size_outputx_s   cn31xx;
	struct cvmx_npi_buff_size_outputx_s   cn38xx;
	struct cvmx_npi_buff_size_outputx_s   cn38xxp2;
	struct cvmx_npi_buff_size_outputx_s   cn50xx;
	struct cvmx_npi_buff_size_outputx_s   cn58xx;
	struct cvmx_npi_buff_size_outputx_s   cn58xxp1;
};
typedef union cvmx_npi_buff_size_outputx cvmx_npi_buff_size_outputx_t;

/**
 * cvmx_npi_comp_ctl
 *
 * NPI_COMP_CTL = PCI Compensation Control
 *
 * PCI Compensation Control
 */
union cvmx_npi_comp_ctl
{
	uint64_t u64;
	struct cvmx_npi_comp_ctl_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_10_63               : 54;
	uint64_t pctl                         : 5;  /**< Bypass value for PCTL */
	uint64_t nctl                         : 5;  /**< Bypass value for NCTL */
#else
	uint64_t nctl                         : 5;
	uint64_t pctl                         : 5;
	uint64_t reserved_10_63               : 54;
#endif
	} s;
	struct cvmx_npi_comp_ctl_s            cn50xx;
	struct cvmx_npi_comp_ctl_s            cn58xx;
	struct cvmx_npi_comp_ctl_s            cn58xxp1;
};
typedef union cvmx_npi_comp_ctl cvmx_npi_comp_ctl_t;

/**
 * cvmx_npi_ctl_status
 *
 * NPI_CTL_STATUS = NPI's Control Status Register
 *
 * Contains control ans status for NPI.
 * Writes to this register are not ordered with writes/reads to the PCI Memory space.
 * To ensure that a write has completed the user must read the register before
 * making an access(i.e. PCI memory space) that requires the value of this register to be updated.
 */
union cvmx_npi_ctl_status
{
	uint64_t u64;
	struct cvmx_npi_ctl_status_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_63_63               : 1;
	uint64_t chip_rev                     : 8;  /**< The revision of the N3. */
	uint64_t dis_pniw                     : 1;  /**< When asserted '1' access from the PNI Window
                                                         Registers are disabled. */
	uint64_t out3_enb                     : 1;  /**< When asserted '1' the output3 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t out2_enb                     : 1;  /**< When asserted '1' the output2 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t out1_enb                     : 1;  /**< When asserted '1' the output1 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t out0_enb                     : 1;  /**< When asserted '1' the output0 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t ins3_enb                     : 1;  /**< When asserted '1' the gather3 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t ins2_enb                     : 1;  /**< When asserted '1' the gather2 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t ins1_enb                     : 1;  /**< When asserted '1' the gather1 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t ins0_enb                     : 1;  /**< When asserted '1' the gather0 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t ins3_64b                     : 1;  /**< When asserted '1' the instructions read by the
                                                         gather3 engine are 64-Byte instructions, when
                                                         de-asserted '0' instructions are 32-byte. */
	uint64_t ins2_64b                     : 1;  /**< When asserted '1' the instructions read by the
                                                         gather2 engine are 64-Byte instructions, when
                                                         de-asserted '0' instructions are 32-byte. */
	uint64_t ins1_64b                     : 1;  /**< When asserted '1' the instructions read by the
                                                         gather1 engine are 64-Byte instructions, when
                                                         de-asserted '0' instructions are 32-byte. */
	uint64_t ins0_64b                     : 1;  /**< When asserted '1' the instructions read by the
                                                         gather0 engine are 64-Byte instructions, when
                                                         de-asserted '0' instructions are 32-byte. */
	uint64_t pci_wdis                     : 1;  /**< When set '1' disables access to registers in
                                                         PNI address range 0x1000 - 0x17FF from the PCI. */
	uint64_t wait_com                     : 1;  /**< When set '1' casues the NPI to wait for a commit
                                                         from the L2C before sending additional access to
                                                         the L2C from the PCI. */
	uint64_t reserved_37_39               : 3;
	uint64_t max_word                     : 5;  /**< The maximum number of words to merge into a single
                                                         write operation from the PPs to the PCI. Legal
                                                         values are 1 to 32, where a '0' is treated as 32. */
	uint64_t reserved_10_31               : 22;
	uint64_t timer                        : 10; /**< When the NPI starts a PP to PCI write it will wait
                                                         no longer than the value of TIMER in eclks to
                                                         merge additional writes from the PPs into 1
                                                         large write. The values for this field is 1 to
                                                         1024 where a value of '0' is treated as 1024. */
#else
	uint64_t timer                        : 10;
	uint64_t reserved_10_31               : 22;
	uint64_t max_word                     : 5;
	uint64_t reserved_37_39               : 3;
	uint64_t wait_com                     : 1;
	uint64_t pci_wdis                     : 1;
	uint64_t ins0_64b                     : 1;
	uint64_t ins1_64b                     : 1;
	uint64_t ins2_64b                     : 1;
	uint64_t ins3_64b                     : 1;
	uint64_t ins0_enb                     : 1;
	uint64_t ins1_enb                     : 1;
	uint64_t ins2_enb                     : 1;
	uint64_t ins3_enb                     : 1;
	uint64_t out0_enb                     : 1;
	uint64_t out1_enb                     : 1;
	uint64_t out2_enb                     : 1;
	uint64_t out3_enb                     : 1;
	uint64_t dis_pniw                     : 1;
	uint64_t chip_rev                     : 8;
	uint64_t reserved_63_63               : 1;
#endif
	} s;
	struct cvmx_npi_ctl_status_cn30xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_63_63               : 1;
	uint64_t chip_rev                     : 8;  /**< The revision of the N3. */
	uint64_t dis_pniw                     : 1;  /**< When asserted '1' access from the PNI Window
                                                         Registers are disabled. */
	uint64_t reserved_51_53               : 3;
	uint64_t out0_enb                     : 1;  /**< When asserted '1' the output0 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t reserved_47_49               : 3;
	uint64_t ins0_enb                     : 1;  /**< When asserted '1' the gather0 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t reserved_43_45               : 3;
	uint64_t ins0_64b                     : 1;  /**< When asserted '1' the instructions read by the
                                                         gather0 engine are 64-Byte instructions, when
                                                         de-asserted '0' instructions are 32-byte. */
	uint64_t pci_wdis                     : 1;  /**< When set '1' disables access to registers in
                                                         PNI address range 0x1000 - 0x17FF from the PCI. */
	uint64_t wait_com                     : 1;  /**< When set '1' casues the NPI to wait for a commit
                                                         from the L2C before sending additional access to
                                                         the L2C from the PCI. */
	uint64_t reserved_37_39               : 3;
	uint64_t max_word                     : 5;  /**< The maximum number of words to merge into a single
                                                         write operation from the PPs to the PCI. Legal
                                                         values are 1 to 32, where a '0' is treated as 32. */
	uint64_t reserved_10_31               : 22;
	uint64_t timer                        : 10; /**< When the NPI starts a PP to PCI write it will wait
                                                         no longer than the value of TIMER in eclks to
                                                         merge additional writes from the PPs into 1
                                                         large write. The values for this field is 1 to
                                                         1024 where a value of '0' is treated as 1024. */
#else
	uint64_t timer                        : 10;
	uint64_t reserved_10_31               : 22;
	uint64_t max_word                     : 5;
	uint64_t reserved_37_39               : 3;
	uint64_t wait_com                     : 1;
	uint64_t pci_wdis                     : 1;
	uint64_t ins0_64b                     : 1;
	uint64_t reserved_43_45               : 3;
	uint64_t ins0_enb                     : 1;
	uint64_t reserved_47_49               : 3;
	uint64_t out0_enb                     : 1;
	uint64_t reserved_51_53               : 3;
	uint64_t dis_pniw                     : 1;
	uint64_t chip_rev                     : 8;
	uint64_t reserved_63_63               : 1;
#endif
	} cn30xx;
	struct cvmx_npi_ctl_status_cn31xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_63_63               : 1;
	uint64_t chip_rev                     : 8;  /**< The revision of the N3.
                                                         0 => pass1.x, 1 => 2.0 */
	uint64_t dis_pniw                     : 1;  /**< When asserted '1' access from the PNI Window
                                                         Registers are disabled. */
	uint64_t reserved_52_53               : 2;
	uint64_t out1_enb                     : 1;  /**< When asserted '1' the output1 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t out0_enb                     : 1;  /**< When asserted '1' the output0 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t reserved_48_49               : 2;
	uint64_t ins1_enb                     : 1;  /**< When asserted '1' the gather1 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t ins0_enb                     : 1;  /**< When asserted '1' the gather0 engine is enabled.
                                                         After enabling the values of the associated
                                                         Address and Size Register should not be changed. */
	uint64_t reserved_44_45               : 2;
	uint64_t ins1_64b                     : 1;  /**< When asserted '1' the instructions read by the
                                                         gather1 engine are 64-Byte instructions, when
                                                         de-asserted '0' instructions are 32-byte. */
	uint64_t ins0_64b                     : 1;  /**< When asserted '1' the instructions read by the
                                                         gather0 engine are 64-Byte instructions, when
                                                         de-asserted '0' instructions are 32-byte. */
	uint64_t pci_wdis                     : 1;  /**< When set '1' disables access to registers in
                                                         PNI address range 0x1000 - 0x17FF from the PCI. */
	uint64_t wait_com                     : 1;  /**< When set '1' casues the NPI to wait for a commit
                                                         from the L2C before sending additional access to
                                                         the L2C from the PCI. */
	uint64_t reserved_37_39               : 3;
	uint64_t max_word                     : 5;  /**< The maximum number of words to merge into a single
                                                         write operation from the PPs to the PCI. Legal
                                                         values are 1 to 32, where a '0' is treated as 32. */
	uint64_t reserved_10_31               : 22;
	uint64_t timer                        : 10; /**< When the NPI starts a PP to PCI write it will wait
                                                         no longer than the value of TIMER in eclks to
                                                         merge additional writes from the PPs into 1
                                                         large write. The values for this field is 1 to
                                                         1024 where a value of '0' is treated as 1024. */
#else
	uint64_t timer                        : 10;
	uint64_t reserved_10_31               : 22;
	uint64_t max_word                     : 5;
	uint64_t reserved_37_39               : 3;
	uint64_t wait_com                     : 1;
	uint64_t pci_wdis                     : 1;
	uint64_t ins0_64b                     : 1;
	uint64_t ins1_64b                     : 1;
	uint64_t reserved_44_45               : 2;
	uint64_t ins0_enb                     : 1;
	uint64_t ins1_enb                     : 1;
	uint64_t reserved_48_49               : 2;
	uint64_t out0_enb                     : 1;
	uint64_t out1_enb                     : 1;
	uint64_t reserved_52_53               : 2;
	uint64_t dis_pniw                     : 1;
	uint64_t chip_rev                     : 8;
	uint64_t reserved_63_63               : 1;
#endif
	} cn31xx;
	struct cvmx_npi_ctl_status_s          cn38xx;
	struct cvmx_npi_ctl_status_s          cn38xxp2;
	struct cvmx_npi_ctl_status_cn31xx     cn50xx;
	struct cvmx_npi_ctl_status_s          cn58xx;
	struct cvmx_npi_ctl_status_s          cn58xxp1;
};
typedef union cvmx_npi_ctl_status cvmx_npi_ctl_status_t;

/**
 * cvmx_npi_dbg_select
 *
 * NPI_DBG_SELECT = Debug Select Register
 *
 * Contains the debug select value in last written to the RSLs.
 */
union cvmx_npi_dbg_select
{
	uint64_t u64;
	struct cvmx_npi_dbg_select_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_16_63               : 48;
	uint64_t dbg_sel                      : 16; /**< When this register is written its value is sent to
                                                         all RSLs. */
#else
	uint64_t dbg_sel                      : 16;
	uint64_t reserved_16_63               : 48;
#endif
	} s;
	struct cvmx_npi_dbg_select_s          cn30xx;
	struct cvmx_npi_dbg_select_s          cn31xx;
	struct cvmx_npi_dbg_select_s          cn38xx;
	struct cvmx_npi_dbg_select_s          cn38xxp2;
	struct cvmx_npi_dbg_select_s          cn50xx;
	struct cvmx_npi_dbg_select_s          cn58xx;
	struct cvmx_npi_dbg_select_s          cn58xxp1;
};
typedef union cvmx_npi_dbg_select cvmx_npi_dbg_select_t;

/**
 * cvmx_npi_dma_control
 *
 * NPI_DMA_CONTROL = DMA Control Register
 *
 * Controls operation of the DMA IN/OUT of the NPI.
 */
union cvmx_npi_dma_control
{
	uint64_t u64;
	struct cvmx_npi_dma_control_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_36_63               : 28;
	uint64_t b0_lend                      : 1;  /**< When set '1' and the NPI is in the mode to write
                                                         0 to L2C memory when a DMA is done, the address
                                                         to be written to will be treated as a Little
                                                         Endian address. This field is new to PASS-2. */
	uint64_t dwb_denb                     : 1;  /**< When set '1' the NPI will send a value in the DWB
                                                         field for a free page operation for the memory
                                                         that contained the data in N3. */
	uint64_t dwb_ichk                     : 9;  /**< When Instruction Chunks for DMA operations are freed
                                                         this value is used for the DWB field of the
                                                         operation. */
	uint64_t fpa_que                      : 3;  /**< The FPA queue that the instruction-chunk page will
                                                         be returned to when used. */
	uint64_t o_add1                       : 1;  /**< When set '1' 1 will be added to the DMA counters,
                                                         if '0' then the number of bytes in the dma transfer
                                                         will be added to the count register. */
	uint64_t o_ro                         : 1;  /**< Relaxed Ordering Mode for DMA. */
	uint64_t o_ns                         : 1;  /**< Nosnoop For DMA. */
	uint64_t o_es                         : 2;  /**< Endian Swap Mode for DMA. */
	uint64_t o_mode                       : 1;  /**< Select PCI_POINTER MODE to be used.
                                                         '1' use pointer values for address and register
                                                         values for RO, ES, and NS, '0' use register
                                                         values for address and pointer values for
                                                         RO, ES, and NS. */
	uint64_t hp_enb                       : 1;  /**< Enables the High Priority DMA.
                                                         While this bit is disabled '0' then the value
                                                         in the NPI_HIGHP_IBUFF_SADDR is re-loaded to the
                                                         starting address of the High Priority DMA engine.
                                                         CSIZE field will be reloaded, for the High Priority
                                                         DMA Engine. */
	uint64_t lp_enb                       : 1;  /**< Enables the Low Priority DMA.
                                                         While this bit is disabled '0' then the value
                                                         in the NPI_LOWP_IBUFF_SADDR is re-loaded to the
                                                         starting address of the Low Priority DMA engine.
                                                         PASS-2: When this bit is '0' the value in the
                                                         CSIZE field will be reloaded, for the Low Priority
                                                         DMA Engine. */
	uint64_t csize                        : 14; /**< The size in words of the DMA Instruction Chunk.
                                                         This value should only be written once. After
                                                         writing this value a new value will not be
                                                         recognized until the end of the DMA I-Chunk is
                                                         reached. */
#else
	uint64_t csize                        : 14;
	uint64_t lp_enb                       : 1;
	uint64_t hp_enb                       : 1;
	uint64_t o_mode                       : 1;
	uint64_t o_es                         : 2;
	uint64_t o_ns                         : 1;
	uint64_t o_ro                         : 1;
	uint64_t o_add1                       : 1;
	uint64_t fpa_que                      : 3;
	uint64_t dwb_ichk                     : 9;
	uint64_t dwb_denb                     : 1;
	uint64_t b0_lend                      : 1;
	uint64_t reserved_36_63               : 28;
#endif
	} s;
	struct cvmx_npi_dma_control_s         cn30xx;
	struct cvmx_npi_dma_control_s         cn31xx;
	struct cvmx_npi_dma_control_s         cn38xx;
	struct cvmx_npi_dma_control_s         cn38xxp2;
	struct cvmx_npi_dma_control_s         cn50xx;
	struct cvmx_npi_dma_control_s         cn58xx;
	struct cvmx_npi_dma_control_s         cn58xxp1;
};
typedef union cvmx_npi_dma_control cvmx_npi_dma_control_t;

/**
 * cvmx_npi_dma_highp_counts
 *
 * NPI_DMA_HIGHP_COUNTS = NPI's High Priority DMA Counts
 *
 * Values for determing the number of instructions for High Priority DMA in the NPI.
 */
union cvmx_npi_dma_highp_counts
{
	uint64_t u64;
	struct cvmx_npi_dma_highp_counts_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_39_63               : 25;
	uint64_t fcnt                         : 7;  /**< Number of words in the Instruction FIFO. */
	uint64_t dbell                        : 32; /**< Number of available words of Instructions to read. */
#else
	uint64_t dbell                        : 32;
	uint64_t fcnt                         : 7;
	uint64_t reserved_39_63               : 25;
#endif
	} s;
	struct cvmx_npi_dma_highp_counts_s    cn30xx;
	struct cvmx_npi_dma_highp_counts_s    cn31xx;
	struct cvmx_npi_dma_highp_counts_s    cn38xx;
	struct cvmx_npi_dma_highp_counts_s    cn38xxp2;
	struct cvmx_npi_dma_highp_counts_s    cn50xx;
	struct cvmx_npi_dma_highp_counts_s    cn58xx;
	struct cvmx_npi_dma_highp_counts_s    cn58xxp1;
};
typedef union cvmx_npi_dma_highp_counts cvmx_npi_dma_highp_counts_t;

/**
 * cvmx_npi_dma_highp_naddr
 *
 * NPI_DMA_HIGHP_NADDR = NPI's High Priority DMA Next Ichunk Address
 *
 * Place NPI will read the next Ichunk data from. This is valid when state is 0
 */
union cvmx_npi_dma_highp_naddr
{
	uint64_t u64;
	struct cvmx_npi_dma_highp_naddr_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_40_63               : 24;
	uint64_t state                        : 4;  /**< The DMA instruction engine state vector.
                                                         Typical value is 0 (IDLE). */
	uint64_t addr                         : 36; /**< The next L2C address to read DMA instructions
                                                         from for the High Priority DMA engine. */
#else
	uint64_t addr                         : 36;
	uint64_t state                        : 4;
	uint64_t reserved_40_63               : 24;
#endif
	} s;
	struct cvmx_npi_dma_highp_naddr_s     cn30xx;
	struct cvmx_npi_dma_highp_naddr_s     cn31xx;
	struct cvmx_npi_dma_highp_naddr_s     cn38xx;
	struct cvmx_npi_dma_highp_naddr_s     cn38xxp2;
	struct cvmx_npi_dma_highp_naddr_s     cn50xx;
	struct cvmx_npi_dma_highp_naddr_s     cn58xx;
	struct cvmx_npi_dma_highp_naddr_s     cn58xxp1;
};
typedef union cvmx_npi_dma_highp_naddr cvmx_npi_dma_highp_naddr_t;

/**
 * cvmx_npi_dma_lowp_counts
 *
 * NPI_DMA_LOWP_COUNTS = NPI's Low Priority DMA Counts
 *
 * Values for determing the number of instructions for Low Priority DMA in the NPI.
 */
union cvmx_npi_dma_lowp_counts
{
	uint64_t u64;
	struct cvmx_npi_dma_lowp_counts_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_39_63               : 25;
	uint64_t fcnt                         : 7;  /**< Number of words in the Instruction FIFO. */
	uint64_t dbell                        : 32; /**< Number of available words of Instructions to read. */
#else
	uint64_t dbell                        : 32;
	uint64_t fcnt                         : 7;
	uint64_t reserved_39_63               : 25;
#endif
	} s;
	struct cvmx_npi_dma_lowp_counts_s     cn30xx;
	struct cvmx_npi_dma_lowp_counts_s     cn31xx;
	struct cvmx_npi_dma_lowp_counts_s     cn38xx;
	struct cvmx_npi_dma_lowp_counts_s     cn38xxp2;
	struct cvmx_npi_dma_lowp_counts_s     cn50xx;
	struct cvmx_npi_dma_lowp_counts_s     cn58xx;
	struct cvmx_npi_dma_lowp_counts_s     cn58xxp1;
};
typedef union cvmx_npi_dma_lowp_counts cvmx_npi_dma_lowp_counts_t;

/**
 * cvmx_npi_dma_lowp_naddr
 *
 * NPI_DMA_LOWP_NADDR = NPI's Low Priority DMA Next Ichunk Address
 *
 * Place NPI will read the next Ichunk data from. This is valid when state is 0
 */
union cvmx_npi_dma_lowp_naddr
{
	uint64_t u64;
	struct cvmx_npi_dma_lowp_naddr_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_40_63               : 24;
	uint64_t state                        : 4;  /**< The DMA instruction engine state vector.
                                                         Typical value is 0 (IDLE). */
	uint64_t addr                         : 36; /**< The next L2C address to read DMA instructions
                                                         from for the Low Priority DMA engine. */
#else
	uint64_t addr                         : 36;
	uint64_t state                        : 4;
	uint64_t reserved_40_63               : 24;
#endif
	} s;
	struct cvmx_npi_dma_lowp_naddr_s      cn30xx;
	struct cvmx_npi_dma_lowp_naddr_s      cn31xx;
	struct cvmx_npi_dma_lowp_naddr_s      cn38xx;
	struct cvmx_npi_dma_lowp_naddr_s      cn38xxp2;
	struct cvmx_npi_dma_lowp_naddr_s      cn50xx;
	struct cvmx_npi_dma_lowp_naddr_s      cn58xx;
	struct cvmx_npi_dma_lowp_naddr_s      cn58xxp1;
};
typedef union cvmx_npi_dma_lowp_naddr cvmx_npi_dma_lowp_naddr_t;

/**
 * cvmx_npi_highp_dbell
 *
 * NPI_HIGHP_DBELL = High Priority Door Bell
 *
 * The door bell register for the high priority DMA queue.
 */
union cvmx_npi_highp_dbell
{
	uint64_t u64;
	struct cvmx_npi_highp_dbell_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_16_63               : 48;
	uint64_t dbell                        : 16; /**< The value written to this register is added to the
                                                         number of 8byte words to be read and processes for
                                                         the high priority dma queue. */
#else
	uint64_t dbell                        : 16;
	uint64_t reserved_16_63               : 48;
#endif
	} s;
	struct cvmx_npi_highp_dbell_s         cn30xx;
	struct cvmx_npi_highp_dbell_s         cn31xx;
	struct cvmx_npi_highp_dbell_s         cn38xx;
	struct cvmx_npi_highp_dbell_s         cn38xxp2;
	struct cvmx_npi_highp_dbell_s         cn50xx;
	struct cvmx_npi_highp_dbell_s         cn58xx;
	struct cvmx_npi_highp_dbell_s         cn58xxp1;
};
typedef union cvmx_npi_highp_dbell cvmx_npi_highp_dbell_t;

/**
 * cvmx_npi_highp_ibuff_saddr
 *
 * NPI_HIGHP_IBUFF_SADDR = DMA High Priority Instruction Buffer Starting Address
 *
 * The address to start reading Instructions from for HIGHP.
 */
union cvmx_npi_highp_ibuff_saddr
{
	uint64_t u64;
	struct cvmx_npi_highp_ibuff_saddr_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_36_63               : 28;
	uint64_t saddr                        : 36; /**< The starting address to read the first instruction. */
#else
	uint64_t saddr                        : 36;
	uint64_t reserved_36_63               : 28;
#endif
	} s;
	struct cvmx_npi_highp_ibuff_saddr_s   cn30xx;
	struct cvmx_npi_highp_ibuff_saddr_s   cn31xx;
	struct cvmx_npi_highp_ibuff_saddr_s   cn38xx;
	struct cvmx_npi_highp_ibuff_saddr_s   cn38xxp2;
	struct cvmx_npi_highp_ibuff_saddr_s   cn50xx;
	struct cvmx_npi_highp_ibuff_saddr_s   cn58xx;
	struct cvmx_npi_highp_ibuff_saddr_s   cn58xxp1;
};
typedef union cvmx_npi_highp_ibuff_saddr cvmx_npi_highp_ibuff_saddr_t;

/**
 * cvmx_npi_input_control
 *
 * NPI_INPUT_CONTROL = NPI's Input Control Register
 *
 * Control for reads for gather list and instructions.
 */
union cvmx_npi_input_control
{
	uint64_t u64;
	struct cvmx_npi_input_control_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_23_63               : 41;
	uint64_t pkt_rr                       : 1;  /**< When set '1' the input packet selection will be
                                                         made with a Round Robin arbitration. When '0'
                                                         the input packet port is fixed in priority,
                                                         where the lower port number has higher priority.
                                                         PASS3 Field */
	uint64_t pbp_dhi                      : 13; /**< Field when in [PBP] is set to be used in
                                                         calculating a DPTR. */
	uint64_t d_nsr                        : 1;  /**< Enables '1' NoSnoop for reading of
                                                         gather data. */
	uint64_t d_esr                        : 2;  /**< The Endian-Swap-Mode for reading of
                                                         gather data. */
	uint64_t d_ror                        : 1;  /**< Enables '1' Relaxed Ordering for reading of
                                                         gather data. */
	uint64_t use_csr                      : 1;  /**< When set '1' the csr value will be used for
                                                         ROR, ESR, and NSR. When clear '0' the value in
                                                         DPTR will be used. In turn the bits not used for
                                                         ROR, ESR, and NSR, will be used for bits [63:60]
                                                         of the address used to fetch packet data. */
	uint64_t nsr                          : 1;  /**< Enables '1' NoSnoop for reading of
                                                         gather list and gather instruction. */
	uint64_t esr                          : 2;  /**< The Endian-Swap-Mode for reading of
                                                         gather list and gather instruction. */
	uint64_t ror                          : 1;  /**< Enables '1' Relaxed Ordering for reading of
                                                         gather list and gather instruction. */
#else
	uint64_t ror                          : 1;
	uint64_t esr                          : 2;
	uint64_t nsr                          : 1;
	uint64_t use_csr                      : 1;
	uint64_t d_ror                        : 1;
	uint64_t d_esr                        : 2;
	uint64_t d_nsr                        : 1;
	uint64_t pbp_dhi                      : 13;
	uint64_t pkt_rr                       : 1;
	uint64_t reserved_23_63               : 41;
#endif
	} s;
	struct cvmx_npi_input_control_cn30xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_22_63               : 42;
	uint64_t pbp_dhi                      : 13; /**< Field when in [PBP] is set to be used in
                                                         calculating a DPTR. */
	uint64_t d_nsr                        : 1;  /**< Enables '1' NoSnoop for reading of
                                                         gather data. */
	uint64_t d_esr                        : 2;  /**< The Endian-Swap-Mode for reading of
                                                         gather data. */
	uint64_t d_ror                        : 1;  /**< Enables '1' Relaxed Ordering for reading of
                                                         gather data. */
	uint64_t use_csr                      : 1;  /**< When set '1' the csr value will be used for
                                                         ROR, ESR, and NSR. When clear '0' the value in
                                                         DPTR will be used. In turn the bits not used for
                                                         ROR, ESR, and NSR, will be used for bits [63:60]
                                                         of the address used to fetch packet data. */
	uint64_t nsr                          : 1;  /**< Enables '1' NoSnoop for reading of
                                                         gather list and gather instruction. */
	uint64_t esr                          : 2;  /**< The Endian-Swap-Mode for reading of
                                                         gather list and gather instruction. */
	uint64_t ror                          : 1;  /**< Enables '1' Relaxed Ordering for reading of
                                                         gather list and gather instruction. */
#else
	uint64_t ror                          : 1;
	uint64_t esr                          : 2;
	uint64_t nsr                          : 1;
	uint64_t use_csr                      : 1;
	uint64_t d_ror                        : 1;
	uint64_t d_esr                        : 2;
	uint64_t d_nsr                        : 1;
	uint64_t pbp_dhi                      : 13;
	uint64_t reserved_22_63               : 42;
#endif
	} cn30xx;
	struct cvmx_npi_input_control_cn30xx  cn31xx;
	struct cvmx_npi_input_control_s       cn38xx;
	struct cvmx_npi_input_control_cn30xx  cn38xxp2;
	struct cvmx_npi_input_control_s       cn50xx;
	struct cvmx_npi_input_control_s       cn58xx;
	struct cvmx_npi_input_control_s       cn58xxp1;
};
typedef union cvmx_npi_input_control cvmx_npi_input_control_t;

/**
 * cvmx_npi_int_enb
 *
 * NPI_INTERRUPT_ENB = NPI's Interrupt Enable Register
 *
 * Used to enable the various interrupting conditions of NPI
 */
union cvmx_npi_int_enb
{
	uint64_t u64;
	struct cvmx_npi_int_enb_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_62_63               : 2;
	uint64_t q1_a_f                       : 1;  /**< Enables NPI_INT_SUM[Q1_A_F] to generate an
                                                         interrupt. */
	uint64_t q1_s_e                       : 1;  /**< Enables NPI_INT_SUM[Q1_S_E] to generate an
                                                         interrupt. */
	uint64_t pdf_p_f                      : 1;  /**< Enables NPI_INT_SUM[PDF_P_F] to generate an
                                                         interrupt. */
	uint64_t pdf_p_e                      : 1;  /**< Enables NPI_INT_SUM[PDF_P_E] to generate an
                                                         interrupt. */
	uint64_t pcf_p_f                      : 1;  /**< Enables NPI_INT_SUM[PCF_P_F] to generate an
                                                         interrupt. */
	uint64_t pcf_p_e                      : 1;  /**< Enables NPI_INT_SUM[PCF_P_E] to generate an
                                                         interrupt. */
	uint64_t rdx_s_e                      : 1;  /**< Enables NPI_INT_SUM[RDX_S_E] to generate an
                                                         interrupt. */
	uint64_t rwx_s_e                      : 1;  /**< Enables NPI_INT_SUM[RWX_S_E] to generate an
                                                         interrupt. */
	uint64_t pnc_a_f                      : 1;  /**< Enables NPI_INT_SUM[PNC_A_F] to generate an
                                                         interrupt. */
	uint64_t pnc_s_e                      : 1;  /**< Enables NPI_INT_SUM[PNC_S_E] to generate an
                                                         interrupt. */
	uint64_t com_a_f                      : 1;  /**< Enables NPI_INT_SUM[COM_A_F] to generate an
                                                         interrupt. */
	uint64_t com_s_e                      : 1;  /**< Enables NPI_INT_SUM[COM_S_E] to generate an
                                                         interrupt. */
	uint64_t q3_a_f                       : 1;  /**< Enables NPI_INT_SUM[Q3_A_F] to generate an
                                                         interrupt. */
	uint64_t q3_s_e                       : 1;  /**< Enables NPI_INT_SUM[Q3_S_E] to generate an
                                                         interrupt. */
	uint64_t q2_a_f                       : 1;  /**< Enables NPI_INT_SUM[Q2_A_F] to generate an
                                                         interrupt. */
	uint64_t q2_s_e                       : 1;  /**< Enables NPI_INT_SUM[Q2_S_E] to generate an
                                                         interrupt. */
	uint64_t pcr_a_f                      : 1;  /**< Enables NPI_INT_SUM[PCR_A_F] to generate an
                                                         interrupt. */
	uint64_t pcr_s_e                      : 1;  /**< Enables NPI_INT_SUM[PCR_S_E] to generate an
                                                         interrupt. */
	uint64_t fcr_a_f                      : 1;  /**< Enables NPI_INT_SUM[FCR_A_F] to generate an
                                                         interrupt. */
	uint64_t fcr_s_e                      : 1;  /**< Enables NPI_INT_SUM[FCR_S_E] to generate an
                                                         interrupt. */
	uint64_t iobdma                       : 1;  /**< Enables NPI_INT_SUM[IOBDMA] to generate an
                                                         interrupt. */
	uint64_t p_dperr                      : 1;  /**< Enables NPI_INT_SUM[P_DPERR] to generate an
                                                         interrupt. */
	uint64_t win_rto                      : 1;  /**< Enables NPI_INT_SUM[WIN_RTO] to generate an
                                                         interrupt. */
	uint64_t i3_pperr                     : 1;  /**< Enables NPI_INT_SUM[I3_PPERR] to generate an
                                                         interrupt. */
	uint64_t i2_pperr                     : 1;  /**< Enables NPI_INT_SUM[I2_PPERR] to generate an
                                                         interrupt. */
	uint64_t i1_pperr                     : 1;  /**< Enables NPI_INT_SUM[I1_PPERR] to generate an
                                                         interrupt. */
	uint64_t i0_pperr                     : 1;  /**< Enables NPI_INT_SUM[I0_PPERR] to generate an
                                                         interrupt. */
	uint64_t p3_ptout                     : 1;  /**< Enables NPI_INT_SUM[P3_PTOUT] to generate an
                                                         interrupt. */
	uint64_t p2_ptout                     : 1;  /**< Enables NPI_INT_SUM[P2_PTOUT] to generate an
                                                         interrupt. */
	uint64_t p1_ptout                     : 1;  /**< Enables NPI_INT_SUM[P1_PTOUT] to generate an
                                                         interrupt. */
	uint64_t p0_ptout                     : 1;  /**< Enables NPI_INT_SUM[P0_PTOUT] to generate an
                                                         interrupt. */
	uint64_t p3_pperr                     : 1;  /**< Enables NPI_INT_SUM[P3_PPERR] to generate an
                                                         interrupt. */
	uint64_t p2_pperr                     : 1;  /**< Enables NPI_INT_SUM[P2_PPERR] to generate an
                                                         interrupt. */
	uint64_t p1_pperr                     : 1;  /**< Enables NPI_INT_SUM[P1_PPERR] to generate an
                                                         interrupt. */
	uint64_t p0_pperr                     : 1;  /**< Enables NPI_INT_SUM[P0_PPERR] to generate an
                                                         interrupt. */
	uint64_t g3_rtout                     : 1;  /**< Enables NPI_INT_SUM[G3_RTOUT] to generate an
                                                         interrupt. */
	uint64_t g2_rtout                     : 1;  /**< Enables NPI_INT_SUM[G2_RTOUT] to generate an
                                                         interrupt. */
	uint64_t g1_rtout                     : 1;  /**< Enables NPI_INT_SUM[G1_RTOUT] to generate an
                                                         interrupt. */
	uint64_t g0_rtout                     : 1;  /**< Enables NPI_INT_SUM[G0_RTOUT] to generate an
                                                         interrupt. */
	uint64_t p3_perr                      : 1;  /**< Enables NPI_INT_SUM[P3_PERR] to generate an
                                                         interrupt. */
	uint64_t p2_perr                      : 1;  /**< Enables NPI_INT_SUM[P2_PERR] to generate an
                                                         interrupt. */
	uint64_t p1_perr                      : 1;  /**< Enables NPI_INT_SUM[P1_PERR] to generate an
                                                         interrupt. */
	uint64_t p0_perr                      : 1;  /**< Enables NPI_INT_SUM[P0_PERR] to generate an
                                                         interrupt. */
	uint64_t p3_rtout                     : 1;  /**< Enables NPI_INT_SUM[P3_RTOUT] to generate an
                                                         interrupt. */
	uint64_t p2_rtout                     : 1;  /**< Enables NPI_INT_SUM[P2_RTOUT] to generate an
                                                         interrupt. */
	uint64_t p1_rtout                     : 1;  /**< Enables NPI_INT_SUM[P1_RTOUT] to generate an
                                                         interrupt. */
	uint64_t p0_rtout                     : 1;  /**< Enables NPI_INT_SUM[P0_RTOUT] to generate an
                                                         interrupt. */
	uint64_t i3_overf                     : 1;  /**< Enables NPI_INT_SUM[I3_OVERF] to generate an
                                                         interrupt. */
	uint64_t i2_overf                     : 1;  /**< Enables NPI_INT_SUM[I2_OVERF] to generate an
                                                         interrupt. */
	uint64_t i1_overf                     : 1;  /**< Enables NPI_INT_SUM[I1_OVERF] to generate an
                                                         interrupt. */
	uint64_t i0_overf                     : 1;  /**< Enables NPI_INT_SUM[I0_OVERF] to generate an
                                                         interrupt. */
	uint64_t i3_rtout                     : 1;  /**< Enables NPI_INT_SUM[I3_RTOUT] to generate an
                                                         interrupt. */
	uint64_t i2_rtout                     : 1;  /**< Enables NPI_INT_SUM[I2_RTOUT] to generate an
                                                         interrupt. */
	uint64_t i1_rtout                     : 1;  /**< Enables NPI_INT_SUM[I1_RTOUT] to generate an
                                                         interrupt. */
	uint64_t i0_rtout                     : 1;  /**< Enables NPI_INT_SUM[I0_RTOUT] to generate an
                                                         interrupt. */
	uint64_t po3_2sml                     : 1;  /**< Enables NPI_INT_SUM[PO3_2SML] to generate an
                                                         interrupt. */
	uint64_t po2_2sml                     : 1;  /**< Enables NPI_INT_SUM[PO2_2SML] to generate an
                                                         interrupt. */
	uint64_t po1_2sml                     : 1;  /**< Enables NPI_INT_SUM[PO1_2SML] to generate an
                                                         interrupt. */
	uint64_t po0_2sml                     : 1;  /**< Enables NPI_INT_SUM[PO0_2SML] to generate an
                                                         interrupt. */
	uint64_t pci_rsl                      : 1;  /**< Enables NPI_INT_SUM[PCI_RSL] to generate an
                                                         interrupt. */
	uint64_t rml_wto                      : 1;  /**< Enables NPI_INT_SUM[RML_WTO] to generate an
                                                         interrupt. */
	uint64_t rml_rto                      : 1;  /**< Enables NPI_INT_SUM[RML_RTO] to generate an
                                                         interrupt. */
#else
	uint64_t rml_rto                      : 1;
	uint64_t rml_wto                      : 1;
	uint64_t pci_rsl                      : 1;
	uint64_t po0_2sml                     : 1;
	uint64_t po1_2sml                     : 1;
	uint64_t po2_2sml                     : 1;
	uint64_t po3_2sml                     : 1;
	uint64_t i0_rtout                     : 1;
	uint64_t i1_rtout                     : 1;
	uint64_t i2_rtout                     : 1;
	uint64_t i3_rtout                     : 1;
	uint64_t i0_overf                     : 1;
	uint64_t i1_overf                     : 1;
	uint64_t i2_overf                     : 1;
	uint64_t i3_overf                     : 1;
	uint64_t p0_rtout                     : 1;
	uint64_t p1_rtout                     : 1;
	uint64_t p2_rtout                     : 1;
	uint64_t p3_rtout                     : 1;
	uint64_t p0_perr                      : 1;
	uint64_t p1_perr                      : 1;
	uint64_t p2_perr                      : 1;
	uint64_t p3_perr                      : 1;
	uint64_t g0_rtout                     : 1;
	uint64_t g1_rtout                     : 1;
	uint64_t g2_rtout                     : 1;
	uint64_t g3_rtout                     : 1;
	uint64_t p0_pperr                     : 1;
	uint64_t p1_pperr                     : 1;
	uint64_t p2_pperr                     : 1;
	uint64_t p3_pperr                     : 1;
	uint64_t p0_ptout                     : 1;
	uint64_t p1_ptout                     : 1;
	uint64_t p2_ptout                     : 1;
	uint64_t p3_ptout                     : 1;
	uint64_t i0_pperr                     : 1;
	uint64_t i1_pperr                     : 1;
	uint64_t i2_pperr                     : 1;
	uint64_t i3_pperr                     : 1;
	uint64_t win_rto                      : 1;
	uint64_t p_dperr                      : 1;
	uint64_t iobdma                       : 1;
	uint64_t fcr_s_e                      : 1;
	uint64_t fcr_a_f                      : 1;
	uint64_t pcr_s_e                      : 1;
	uint64_t pcr_a_f                      : 1;
	uint64_t q2_s_e                       : 1;
	uint64_t q2_a_f                       : 1;
	uint64_t q3_s_e                       : 1;
	uint64_t q3_a_f                       : 1;
	uint64_t com_s_e                      : 1;
	uint64_t com_a_f                      : 1;
	uint64_t pnc_s_e                      : 1;
	uint64_t pnc_a_f                      : 1;
	uint64_t rwx_s_e                      : 1;
	uint64_t rdx_s_e                      : 1;
	uint64_t pcf_p_e                      : 1;
	uint64_t pcf_p_f                      : 1;
	uint64_t pdf_p_e                      : 1;
	uint64_t pdf_p_f                      : 1;
	uint64_t q1_s_e                       : 1;
	uint64_t q1_a_f                       : 1;
	uint64_t reserved_62_63               : 2;
#endif
	} s;
	struct cvmx_npi_int_enb_cn30xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_62_63               : 2;
	uint64_t q1_a_f                       : 1;  /**< Enables NPI_INT_SUM[Q1_A_F] to generate an
                                                         interrupt. */
	uint64_t q1_s_e                       : 1;  /**< Enables NPI_INT_SUM[Q1_S_E] to generate an
                                                         interrupt. */
	uint64_t pdf_p_f                      : 1;  /**< Enables NPI_INT_SUM[PDF_P_F] to generate an
                                                         interrupt. */
	uint64_t pdf_p_e                      : 1;  /**< Enables NPI_INT_SUM[PDF_P_E] to generate an
                                                         interrupt. */
	uint64_t pcf_p_f                      : 1;  /**< Enables NPI_INT_SUM[PCF_P_F] to generate an
                                                         interrupt. */
	uint64_t pcf_p_e                      : 1;  /**< Enables NPI_INT_SUM[PCF_P_E] to generate an
                                                         interrupt. */
	uint64_t rdx_s_e                      : 1;  /**< Enables NPI_INT_SUM[RDX_S_E] to generate an
                                                         interrupt. */
	uint64_t rwx_s_e                      : 1;  /**< Enables NPI_INT_SUM[RWX_S_E] to generate an
                                                         interrupt. */
	uint64_t pnc_a_f                      : 1;  /**< Enables NPI_INT_SUM[PNC_A_F] to generate an
                                                         interrupt. */
	uint64_t pnc_s_e                      : 1;  /**< Enables NPI_INT_SUM[PNC_S_E] to generate an
                                                         interrupt. */
	uint64_t com_a_f                      : 1;  /**< Enables NPI_INT_SUM[COM_A_F] to generate an
                                                         interrupt. */
	uint64_t com_s_e                      : 1;  /**< Enables NPI_INT_SUM[COM_S_E] to generate an
                                                         interrupt. */
	uint64_t q3_a_f                       : 1;  /**< Enables NPI_INT_SUM[Q3_A_F] to generate an
                                                         interrupt. */
	uint64_t q3_s_e                       : 1;  /**< Enables NPI_INT_SUM[Q3_S_E] to generate an
                                                         interrupt. */
	uint64_t q2_a_f                       : 1;  /**< Enables NPI_INT_SUM[Q2_A_F] to generate an
                                                         interrupt. */
	uint64_t q2_s_e                       : 1;  /**< Enables NPI_INT_SUM[Q2_S_E] to generate an
                                                         interrupt. */
	uint64_t pcr_a_f                      : 1;  /**< Enables NPI_INT_SUM[PCR_A_F] to generate an
                                                         interrupt. */
	uint64_t pcr_s_e                      : 1;  /**< Enables NPI_INT_SUM[PCR_S_E] to generate an
                                                         interrupt. */
	uint64_t fcr_a_f                      : 1;  /**< Enables NPI_INT_SUM[FCR_A_F] to generate an
                                                         interrupt. */
	uint64_t fcr_s_e                      : 1;  /**< Enables NPI_INT_SUM[FCR_S_E] to generate an
                                                         interrupt. */
	uint64_t iobdma                       : 1;  /**< Enables NPI_INT_SUM[IOBDMA] to generate an
                                                         interrupt. */
	uint64_t p_dperr                      : 1;  /**< Enables NPI_INT_SUM[P_DPERR] to generate an
                                                         interrupt. */
	uint64_t win_rto                      : 1;  /**< Enables NPI_INT_SUM[WIN_RTO] to generate an
                                                         interrupt. */
	uint64_t reserved_36_38               : 3;
	uint64_t i0_pperr                     : 1;  /**< Enables NPI_INT_SUM[I0_PPERR] to generate an
                                                         interrupt. */
	uint64_t reserved_32_34               : 3;
	uint64_t p0_ptout                     : 1;  /**< Enables NPI_INT_SUM[P0_PTOUT] to generate an
                                                         interrupt. */
	uint64_t reserved_28_30               : 3;
	uint64_t p0_pperr                     : 1;  /**< Enables NPI_INT_SUM[P0_PPERR] to generate an
                                                         interrupt. */
	uint64_t reserved_24_26               : 3;
	uint64_t g0_rtout                     : 1;  /**< Enables NPI_INT_SUM[G0_RTOUT] to generate an
                                                         interrupt. */
	uint64_t reserved_20_22               : 3;
	uint64_t p0_perr                      : 1;  /**< Enables NPI_INT_SUM[P0_PERR] to generate an
                                                         interrupt. */
	uint64_t reserved_16_18               : 3;
	uint64_t p0_rtout                     : 1;  /**< Enables NPI_INT_SUM[P0_RTOUT] to generate an
                                                         interrupt. */
	uint64_t reserved_12_14               : 3;
	uint64_t i0_overf                     : 1;  /**< Enables NPI_INT_SUM[I0_OVERF] to generate an
                                                         interrupt. */
	uint64_t reserved_8_10                : 3;
	uint64_t i0_rtout                     : 1;  /**< Enables NPI_INT_SUM[I0_RTOUT] to generate an
                                                         interrupt. */
	uint64_t reserved_4_6                 : 3;
	uint64_t po0_2sml                     : 1;  /**< Enables NPI_INT_SUM[PO0_2SML] to generate an
                                                         interrupt. */
	uint64_t pci_rsl                      : 1;  /**< Enables NPI_INT_SUM[PCI_RSL] to generate an
                                                         interrupt. */
	uint64_t rml_wto                      : 1;  /**< Enables NPI_INT_SUM[RML_WTO] to generate an
                                                         interrupt. */
	uint64_t rml_rto                      : 1;  /**< Enables NPI_INT_SUM[RML_RTO] to generate an
                                                         interrupt. */
#else
	uint64_t rml_rto                      : 1;
	uint64_t rml_wto                      : 1;
	uint64_t pci_rsl                      : 1;
	uint64_t po0_2sml                     : 1;
	uint64_t reserved_4_6                 : 3;
	uint64_t i0_rtout                     : 1;
	uint64_t reserved_8_10                : 3;
	uint64_t i0_overf                     : 1;
	uint64_t reserved_12_14               : 3;
	uint64_t p0_rtout                     : 1;
	uint64_t reserved_16_18               : 3;
	uint64_t p0_perr                      : 1;
	uint64_t reserved_20_22               : 3;
	uint64_t g0_rtout                     : 1;
	uint64_t reserved_24_26               : 3;
	uint64_t p0_pperr                     : 1;
	uint64_t reserved_28_30               : 3;
	uint64_t p0_ptout                     : 1;
	uint64_t reserved_32_34               : 3;
	uint64_t i0_pperr                     : 1;
	uint64_t reserved_36_38               : 3;
	uint64_t win_rto                      : 1;
	uint64_t p_dperr                      : 1;
	uint64_t iobdma                       : 1;
	uint64_t fcr_s_e                      : 1;
	uint64_t fcr_a_f                      : 1;
	uint64_t pcr_s_e                      : 1;
	uint64_t pcr_a_f                      : 1;
	uint64_t q2_s_e                       : 1;
	uint64_t q2_a_f                       : 1;
	uint64_t q3_s_e                       : 1;
	uint64_t q3_a_f                       : 1;
	uint64_t com_s_e                      : 1;
	uint64_t com_a_f                      : 1;
	uint64_t pnc_s_e                      : 1;
	uint64_t pnc_a_f                      : 1;
	uint64_t rwx_s_e                      : 1;
	uint64_t rdx_s_e                      : 1;
	uint64_t pcf_p_e                      : 1;
	uint64_t pcf_p_f                      : 1;
	uint64_t pdf_p_e                      : 1;
	uint64_t pdf_p_f                      : 1;
	uint64_t q1_s_e                       : 1;
	uint64_t q1_a_f                       : 1;
	uint64_t reserved_62_63               : 2;
#endif
	} cn30xx;
	struct cvmx_npi_int_enb_cn31xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_62_63               : 2;
	uint64_t q1_a_f                       : 1;  /**< Enables NPI_INT_SUM[Q1_A_F] to generate an
                                                         interrupt. */
	uint64_t q1_s_e                       : 1;  /**< Enables NPI_INT_SUM[Q1_S_E] to generate an
                                                         interrupt. */
	uint64_t pdf_p_f                      : 1;  /**< Enables NPI_INT_SUM[PDF_P_F] to generate an
                                                         interrupt. */
	uint64_t pdf_p_e                      : 1;  /**< Enables NPI_INT_SUM[PDF_P_E] to generate an
                                                         interrupt. */
	uint64_t pcf_p_f                      : 1;  /**< Enables NPI_INT_SUM[PCF_P_F] to generate an
                                                         interrupt. */
	uint64_t pcf_p_e                      : 1;  /**< Enables NPI_INT_SUM[PCF_P_E] to generate an
                                                         interrupt. */
	uint64_t rdx_s_e                      : 1;  /**< Enables NPI_INT_SUM[RDX_S_E] to generate an
                                                         interrupt. */
	uint64_t rwx_s_e                      : 1;  /**< Enables NPI_INT_SUM[RWX_S_E] to generate an
                                                         interrupt. */
	uint64_t pnc_a_f                      : 1;  /**< Enables NPI_INT_SUM[PNC_A_F] to generate an
                                                         interrupt. */
	uint64_t pnc_s_e                      : 1;  /**< Enables NPI_INT_SUM[PNC_S_E] to generate an
                                                         interrupt. */
	uint64_t com_a_f                      : 1;  /**< Enables NPI_INT_SUM[COM_A_F] to generate an
                                                         interrupt. */
	uint64_t com_s_e                      : 1;  /**< Enables NPI_INT_SUM[COM_S_E] to generate an
                                                         interrupt. */
	uint64_t q3_a_f                       : 1;  /**< Enables NPI_INT_SUM[Q3_A_F] to generate an
                                                         interrupt. */
	uint64_t q3_s_e                       : 1;  /**< Enables NPI_INT_SUM[Q3_S_E] to generate an
                                                         interrupt. */
	uint64_t q2_a_f                       : 1;  /**< Enables NPI_INT_SUM[Q2_A_F] to generate an
                                                         interrupt. */
	uint64_t q2_s_e                       : 1;  /**< Enables NPI_INT_SUM[Q2_S_E] to generate an
                                                         interrupt. */
	uint64_t pcr_a_f                      : 1;  /**< Enables NPI_INT_SUM[PCR_A_F] to generate an
                                                         interrupt. */
	uint64_t pcr_s_e                      : 1;  /**< Enables NPI_INT_SUM[PCR_S_E] to generate an
                                                         interrupt. */
	uint64_t fcr_a_f                      : 1;  /**< Enables NPI_INT_SUM[FCR_A_F] to generate an
                                                         interrupt. */
	uint64_t fcr_s_e                      : 1;  /**< Enables NPI_INT_SUM[FCR_S_E] to generate an
                                                         interrupt. */
	uint64_t iobdma                       : 1;  /**< Enables NPI_INT_SUM[IOBDMA] to generate an
                                                         interrupt. */
	uint64_t p_dperr                      : 1;  /**< Enables NPI_INT_SUM[P_DPERR] to generate an
                                                         interrupt. */
	uint64_t win_rto                      : 1;  /**< Enables NPI_INT_SUM[WIN_RTO] to generate an
                                                         interrupt. */
	uint64_t reserved_37_38               : 2;
	uint64_t i1_pperr                     : 1;  /**< Enables NPI_INT_SUM[I1_PPERR] to generate an
                                                         interrupt. */
	uint64_t i0_pperr                     : 1;  /**< Enables NPI_INT_SUM[I0_PPERR] to generate an
                                                         interrupt. */
	uint64_t reserved_33_34               : 2;
	uint64_t p1_ptout                     : 1;  /**< Enables NPI_INT_SUM[P1_PTOUT] to generate an
                                                         interrupt. */
	uint64_t p0_ptout                     : 1;  /**< Enables NPI_INT_SUM[P0_PTOUT] to generate an
                                                         interrupt. */
	uint64_t reserved_29_30               : 2;
	uint64_t p1_pperr                     : 1;  /**< Enables NPI_INT_SUM[P1_PPERR] to generate an
                                                         interrupt. */
	uint64_t p0_pperr                     : 1;  /**< Enables NPI_INT_SUM[P0_PPERR] to generate an
                                                         interrupt. */
	uint64_t reserved_25_26               : 2;
	uint64_t g1_rtout                     : 1;  /**< Enables NPI_INT_SUM[G1_RTOUT] to generate an
                                                         interrupt. */
	uint64_t g0_rtout                     : 1;  /**< Enables NPI_INT_SUM[G0_RTOUT] to generate an
                                                         interrupt. */
	uint64_t reserved_21_22               : 2;
	uint64_t p1_perr                      : 1;  /**< Enables NPI_INT_SUM[P1_PERR] to generate an
                                                         interrupt. */
	uint64_t p0_perr                      : 1;  /**< Enables NPI_INT_SUM[P0_PERR] to generate an
                                                         interrupt. */
	uint64_t reserved_17_18               : 2;
	uint64_t p1_rtout                     : 1;  /**< Enables NPI_INT_SUM[P1_RTOUT] to generate an
                                                         interrupt. */
	uint64_t p0_rtout                     : 1;  /**< Enables NPI_INT_SUM[P0_RTOUT] to generate an
                                                         interrupt. */
	uint64_t reserved_13_14               : 2;
	uint64_t i1_overf                     : 1;  /**< Enables NPI_INT_SUM[I1_OVERF] to generate an
                                                         interrupt. */
	uint64_t i0_overf                     : 1;  /**< Enables NPI_INT_SUM[I0_OVERF] to generate an
                                                         interrupt. */
	uint64_t reserved_9_10                : 2;
	uint64_t i1_rtout                     : 1;  /**< Enables NPI_INT_SUM[I1_RTOUT] to generate an
                                                         interrupt. */
	uint64_t i0_rtout                     : 1;  /**< Enables NPI_INT_SUM[I0_RTOUT] to generate an
                                                         interrupt. */
	uint64_t reserved_5_6                 : 2;
	uint64_t po1_2sml                     : 1;  /**< Enables NPI_INT_SUM[PO1_2SML] to generate an
                                                         interrupt. */
	uint64_t po0_2sml                     : 1;  /**< Enables NPI_INT_SUM[PO0_2SML] to generate an
                                                         interrupt. */
	uint64_t pci_rsl                      : 1;  /**< Enables NPI_INT_SUM[PCI_RSL] to generate an
                                                         interrupt. */
	uint64_t rml_wto                      : 1;  /**< Enables NPI_INT_SUM[RML_WTO] to generate an
                                                         interrupt. */
	uint64_t rml_rto                      : 1;  /**< Enables NPI_INT_SUM[RML_RTO] to generate an
                                                         interrupt. */
#else
	uint64_t rml_rto                      : 1;
	uint64_t rml_wto                      : 1;
	uint64_t pci_rsl                      : 1;
	uint64_t po0_2sml                     : 1;
	uint64_t po1_2sml                     : 1;
	uint64_t reserved_5_6                 : 2;
	uint64_t i0_rtout                     : 1;
	uint64_t i1_rtout                     : 1;
	uint64_t reserved_9_10                : 2;
	uint64_t i0_overf                     : 1;
	uint64_t i1_overf                     : 1;
	uint64_t reserved_13_14               : 2;
	uint64_t p0_rtout                     : 1;
	uint64_t p1_rtout                     : 1;
	uint64_t reserved_17_18               : 2;
	uint64_t p0_perr                      : 1;
	uint64_t p1_perr                      : 1;
	uint64_t reserved_21_22               : 2;
	uint64_t g0_rtout                     : 1;
	uint64_t g1_rtout                     : 1;
	uint64_t reserved_25_26               : 2;
	uint64_t p0_pperr                     : 1;
	uint64_t p1_pperr                     : 1;
	uint64_t reserved_29_30               : 2;
	uint64_t p0_ptout                     : 1;
	uint64_t p1_ptout                     : 1;
	uint64_t reserved_33_34               : 2;
	uint64_t i0_pperr                     : 1;
	uint64_t i1_pperr                     : 1;
	uint64_t reserved_37_38               : 2;
	uint64_t win_rto                      : 1;
	uint64_t p_dperr                      : 1;
	uint64_t iobdma                       : 1;
	uint64_t fcr_s_e                      : 1;
	uint64_t fcr_a_f                      : 1;
	uint64_t pcr_s_e                      : 1;
	uint64_t pcr_a_f                      : 1;
	uint64_t q2_s_e                       : 1;
	uint64_t q2_a_f                       : 1;
	uint64_t q3_s_e                       : 1;
	uint64_t q3_a_f                       : 1;
	uint64_t com_s_e                      : 1;
	uint64_t com_a_f                      : 1;
	uint64_t pnc_s_e                      : 1;
	uint64_t pnc_a_f                      : 1;
	uint64_t rwx_s_e                      : 1;
	uint64_t rdx_s_e                      : 1;
	uint64_t pcf_p_e                      : 1;
	uint64_t pcf_p_f                      : 1;
	uint64_t pdf_p_e                      : 1;
	uint64_t pdf_p_f                      : 1;
	uint64_t q1_s_e                       : 1;
	uint64_t q1_a_f                       : 1;
	uint64_t reserved_62_63               : 2;
#endif
	} cn31xx;
	struct cvmx_npi_int_enb_s             cn38xx;
	struct cvmx_npi_int_enb_cn38xxp2
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_42_63               : 22;
	uint64_t iobdma                       : 1;  /**< Enables NPI_INT_SUM[IOBDMA] to generate an
                                                         interrupt. */
	uint64_t p_dperr                      : 1;  /**< Enables NPI_INT_SUM[P_DPERR] to generate an
                                                         interrupt. */
	uint64_t win_rto                      : 1;  /**< Enables NPI_INT_SUM[WIN_RTO] to generate an
                                                         interrupt. */
	uint64_t i3_pperr                     : 1;  /**< Enables NPI_INT_SUM[I3_PPERR] to generate an
                                                         interrupt. */
	uint64_t i2_pperr                     : 1;  /**< Enables NPI_INT_SUM[I2_PPERR] to generate an
                                                         interrupt. */
	uint64_t i1_pperr                     : 1;  /**< Enables NPI_INT_SUM[I1_PPERR] to generate an
                                                         interrupt. */
	uint64_t i0_pperr                     : 1;  /**< Enables NPI_INT_SUM[I0_PPERR] to generate an
                                                         interrupt. */
	uint64_t p3_ptout                     : 1;  /**< Enables NPI_INT_SUM[P3_PTOUT] to generate an
                                                         interrupt. */
	uint64_t p2_ptout                     : 1;  /**< Enables NPI_INT_SUM[P2_PTOUT] to generate an
                                                         interrupt. */
	uint64_t p1_ptout                     : 1;  /**< Enables NPI_INT_SUM[P1_PTOUT] to generate an
                                                         interrupt. */
	uint64_t p0_ptout                     : 1;  /**< Enables NPI_INT_SUM[P0_PTOUT] to generate an
                                                         interrupt. */
	uint64_t p3_pperr                     : 1;  /**< Enables NPI_INT_SUM[P3_PPERR] to generate an
                                                         interrupt. */
	uint64_t p2_pperr                     : 1;  /**< Enables NPI_INT_SUM[P2_PPERR] to generate an
                                                         interrupt. */
	uint64_t p1_pperr                     : 1;  /**< Enables NPI_INT_SUM[P1_PPERR] to generate an
                                                         interrupt. */
	uint64_t p0_pperr                     : 1;  /**< Enables NPI_INT_SUM[P0_PPERR] to generate an
                                                         interrupt. */
	uint64_t g3_rtout                     : 1;  /**< Enables NPI_INT_SUM[G3_RTOUT] to generate an
                                                         interrupt. */
	uint64_t g2_rtout                     : 1;  /**< Enables NPI_INT_SUM[G2_RTOUT] to generate an
                                                         interrupt. */
	uint64_t g1_rtout                     : 1;  /**< Enables NPI_INT_SUM[G1_RTOUT] to generate an
                                                         interrupt. */
	uint64_t g0_rtout                     : 1;  /**< Enables NPI_INT_SUM[G0_RTOUT] to generate an
                                                         interrupt. */
	uint64_t p3_perr                      : 1;  /**< Enables NPI_INT_SUM[P3_PERR] to generate an
                                                         interrupt. */
	uint64_t p2_perr                      : 1;  /**< Enables NPI_INT_SUM[P2_PERR] to generate an
                                                         interrupt. */
	uint64_t p1_perr                      : 1;  /**< Enables NPI_INT_SUM[P1_PERR] to generate an
                                                         interrupt. */
	uint64_t p0_perr                      : 1;  /**< Enables NPI_INT_SUM[P0_PERR] to generate an
                                                         interrupt. */
	uint64_t p3_rtout                     : 1;  /**< Enables NPI_INT_SUM[P3_RTOUT] to generate an
                                                         interrupt. */
	uint64_t p2_rtout                     : 1;  /**< Enables NPI_INT_SUM[P2_RTOUT] to generate an
                                                         interrupt. */
	uint64_t p1_rtout                     : 1;  /**< Enables NPI_INT_SUM[P1_RTOUT] to generate an
                                                         interrupt. */
	uint64_t p0_rtout                     : 1;  /**< Enables NPI_INT_SUM[P0_RTOUT] to generate an
                                                         interrupt. */
	uint64_t i3_overf                     : 1;  /**< Enables NPI_INT_SUM[I3_OVERF] to generate an
                                                         interrupt. */
	uint64_t i2_overf                     : 1;  /**< Enables NPI_INT_SUM[I2_OVERF] to generate an
                                                         interrupt. */
	uint64_t i1_overf                     : 1;  /**< Enables NPI_INT_SUM[I1_OVERF] to generate an
                                                         interrupt. */
	uint64_t i0_overf                     : 1;  /**< Enables NPI_INT_SUM[I0_OVERF] to generate an
                                                         interrupt. */
	uint64_t i3_rtout                     : 1;  /**< Enables NPI_INT_SUM[I3_RTOUT] to generate an
                                                         interrupt. */
	uint64_t i2_rtout                     : 1;  /**< Enables NPI_INT_SUM[I2_RTOUT] to generate an
                                                         interrupt. */
	uint64_t i1_rtout                     : 1;  /**< Enables NPI_INT_SUM[I1_RTOUT] to generate an
                                                         interrupt. */
	uint64_t i0_rtout                     : 1;  /**< Enables NPI_INT_SUM[I0_RTOUT] to generate an
                                                         interrupt. */
	uint64_t po3_2sml                     : 1;  /**< Enables NPI_INT_SUM[PO3_2SML] to generate an
                                                         interrupt. */
	uint64_t po2_2sml                     : 1;  /**< Enables NPI_INT_SUM[PO2_2SML] to generate an
                                                         interrupt. */
	uint64_t po1_2sml                     : 1;  /**< Enables NPI_INT_SUM[PO1_2SML] to generate an
                                                         interrupt. */
	uint64_t po0_2sml                     : 1;  /**< Enables NPI_INT_SUM[PO0_2SML] to generate an
                                                         interrupt. */
	uint64_t pci_rsl                      : 1;  /**< Enables NPI_INT_SUM[PCI_RSL] to generate an
                                                         interrupt. */
	uint64_t rml_wto                      : 1;  /**< Enables NPI_INT_SUM[RML_WTO] to generate an
                                                         interrupt. */
	uint64_t rml_rto                      : 1;  /**< Enables NPI_INT_SUM[RML_RTO] to generate an
                                                         interrupt. */
#else
	uint64_t rml_rto                      : 1;
	uint64_t rml_wto                      : 1;
	uint64_t pci_rsl                      : 1;
	uint64_t po0_2sml                     : 1;
	uint64_t po1_2sml                     : 1;
	uint64_t po2_2sml                     : 1;
	uint64_t po3_2sml                     : 1;
	uint64_t i0_rtout                     : 1;
	uint64_t i1_rtout                     : 1;
	uint64_t i2_rtout                     : 1;
	uint64_t i3_rtout                     : 1;
	uint64_t i0_overf                     : 1;
	uint64_t i1_overf                     : 1;
	uint64_t i2_overf                     : 1;
	uint64_t i3_overf                     : 1;
	uint64_t p0_rtout                     : 1;
	uint64_t p1_rtout                     : 1;
	uint64_t p2_rtout                     : 1;
	uint64_t p3_rtout                     : 1;
	uint64_t p0_perr                      : 1;
	uint64_t p1_perr                      : 1;
	uint64_t p2_perr                      : 1;
	uint64_t p3_perr                      : 1;
	uint64_t g0_rtout                     : 1;
	uint64_t g1_rtout                     : 1;
	uint64_t g2_rtout                     : 1;
	uint64_t g3_rtout                     : 1;
	uint64_t p0_pperr                     : 1;
	uint64_t p1_pperr                     : 1;
	uint64_t p2_pperr                     : 1;
	uint64_t p3_pperr                     : 1;
	uint64_t p0_ptout                     : 1;
	uint64_t p1_ptout                     : 1;
	uint64_t p2_ptout                     : 1;
	uint64_t p3_ptout                     : 1;
	uint64_t i0_pperr                     : 1;
	uint64_t i1_pperr                     : 1;
	uint64_t i2_pperr                     : 1;
	uint64_t i3_pperr                     : 1;
	uint64_t win_rto                      : 1;
	uint64_t p_dperr                      : 1;
	uint64_t iobdma                       : 1;
	uint64_t reserved_42_63               : 22;
#endif
	} cn38xxp2;
	struct cvmx_npi_int_enb_cn31xx        cn50xx;
	struct cvmx_npi_int_enb_s             cn58xx;
	struct cvmx_npi_int_enb_s             cn58xxp1;
};
typedef union cvmx_npi_int_enb cvmx_npi_int_enb_t;

/**
 * cvmx_npi_int_sum
 *
 * NPI_INTERRUPT_SUM = NPI Interrupt Summary Register
 *
 * Set when an interrupt condition occurs, write '1' to clear.
 */
union cvmx_npi_int_sum
{
	uint64_t u64;
	struct cvmx_npi_int_sum_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_62_63               : 2;
	uint64_t q1_a_f                       : 1;  /**< Attempted to add when Queue-1 FIFO is full.
                                                         PASS3 Field. */
	uint64_t q1_s_e                       : 1;  /**< Attempted to subtract when Queue-1 FIFO is empty.
                                                         PASS3 Field. */
	uint64_t pdf_p_f                      : 1;  /**< Attempted to push a full PCN-DATA-FIFO.
                                                         PASS3 Field. */
	uint64_t pdf_p_e                      : 1;  /**< Attempted to pop an empty PCN-DATA-FIFO.
                                                         PASS3 Field. */
	uint64_t pcf_p_f                      : 1;  /**< Attempted to push a full PCN-CNT-FIFO.
                                                         PASS3 Field. */
	uint64_t pcf_p_e                      : 1;  /**< Attempted to pop an empty PCN-CNT-FIFO.
                                                         PASS3 Field. */
	uint64_t rdx_s_e                      : 1;  /**< Attempted to subtract when DPI-XFR-Wait count is 0.
                                                         PASS3 Field. */
	uint64_t rwx_s_e                      : 1;  /**< Attempted to subtract when RDN-XFR-Wait count is 0.
                                                         PASS3 Field. */
	uint64_t pnc_a_f                      : 1;  /**< Attempted to add when PNI-NPI Credits are max.
                                                         PASS3 Field. */
	uint64_t pnc_s_e                      : 1;  /**< Attempted to subtract when PNI-NPI Credits are 0.
                                                         PASS3 Field. */
	uint64_t com_a_f                      : 1;  /**< Attempted to add when PCN-Commit Counter is max.
                                                         PASS3 Field. */
	uint64_t com_s_e                      : 1;  /**< Attempted to subtract when PCN-Commit Counter is 0.
                                                         PASS3 Field. */
	uint64_t q3_a_f                       : 1;  /**< Attempted to add when Queue-3 FIFO is full.
                                                         PASS3 Field. */
	uint64_t q3_s_e                       : 1;  /**< Attempted to subtract when Queue-3 FIFO is empty.
                                                         PASS3 Field. */
	uint64_t q2_a_f                       : 1;  /**< Attempted to add when Queue-2 FIFO is full.
                                                         PASS3 Field. */
	uint64_t q2_s_e                       : 1;  /**< Attempted to subtract when Queue-2 FIFO is empty.
                                                         PASS3 Field. */
	uint64_t pcr_a_f                      : 1;  /**< Attempted to add when POW Credits is full.
                                                         PASS3 Field. */
	uint64_t pcr_s_e                      : 1;  /**< Attempted to subtract when POW Credits is empty.
                                                         PASS3 Field. */
	uint64_t fcr_a_f                      : 1;  /**< Attempted to add when FPA Credits is full.
                                                         PASS3 Field. */
	uint64_t fcr_s_e                      : 1;  /**< Attempted to subtract when FPA Credits is empty.
                                                         PASS3 Field. */
	uint64_t iobdma                       : 1;  /**< Requested IOBDMA read size exceeded 128 words. */
	uint64_t p_dperr                      : 1;  /**< If a parity error occured on data written to L2C
                                                         from the PCI this bit may be set. */
	uint64_t win_rto                      : 1;  /**< Windowed Load Timed Out. */
	uint64_t i3_pperr                     : 1;  /**< If a parity error occured on the port's instruction
                                                         this bit may be set. */
	uint64_t i2_pperr                     : 1;  /**< If a parity error occured on the port's instruction
                                                         this bit may be set. */
	uint64_t i1_pperr                     : 1;  /**< If a parity error occured on the port's instruction
                                                         this bit may be set. */
	uint64_t i0_pperr                     : 1;  /**< If a parity error occured on the port's instruction
                                                         this bit may be set. */
	uint64_t p3_ptout                     : 1;  /**< Port-3 output had a read timeout on a DATA/INFO
                                                         pair. */
	uint64_t p2_ptout                     : 1;  /**< Port-2 output had a read timeout on a DATA/INFO
                                                         pair. */
	uint64_t p1_ptout                     : 1;  /**< Port-1 output had a read timeout on a DATA/INFO
                                                         pair. */
	uint64_t p0_ptout                     : 1;  /**< Port-0 output had a read timeout on a DATA/INFO
                                                         pair. */
	uint64_t p3_pperr                     : 1;  /**< If a parity error occured on the port DATA/INFO
                                                         pointer-pair, this bit may be set. */
	uint64_t p2_pperr                     : 1;  /**< If a parity error occured on the port DATA/INFO
                                                         pointer-pair, this bit may be set. */
	uint64_t p1_pperr                     : 1;  /**< If a parity error occured on the port DATA/INFO
                                                         pointer-pair, this bit may be set. */
	uint64_t p0_pperr                     : 1;  /**< If a parity error occured on the port DATA/INFO
                                                         pointer-pair, this bit may be set. */
	uint64_t g3_rtout                     : 1;  /**< Port-3 had a read timeout while attempting to
                                                         read a gather list. */
	uint64_t g2_rtout                     : 1;  /**< Port-2 had a read timeout while attempting to
                                                         read a gather list. */
	uint64_t g1_rtout                     : 1;  /**< Port-1 had a read timeout while attempting to
                                                         read a gather list. */
	uint64_t g0_rtout                     : 1;  /**< Port-0 had a read timeout while attempting to
                                                         read a gather list. */
	uint64_t p3_perr                      : 1;  /**< If a parity error occured on the port's packet
                                                         data this bit may be set. */
	uint64_t p2_perr                      : 1;  /**< If a parity error occured on the port's packet
                                                         data this bit may be set. */
	uint64_t p1_perr                      : 1;  /**< If a parity error occured on the port's packet
                                                         data this bit may be set. */
	uint64_t p0_perr                      : 1;  /**< If a parity error occured on the port's packet
                                                         data this bit may be set. */
	uint64_t p3_rtout                     : 1;  /**< Port-3 had a read timeout while attempting to
                                                         read packet data. */
	uint64_t p2_rtout                     : 1;  /**< Port-2 had a read timeout while attempting to
                                                         read packet data. */
	uint64_t p1_rtout                     : 1;  /**< Port-1 had a read timeout while attempting to
                                                         read packet data. */
	uint64_t p0_rtout                     : 1;  /**< Port-0 had a read timeout while attempting to
                                                         read packet data. */
	uint64_t i3_overf                     : 1;  /**< Port-3 had a doorbell overflow. Bit[31] of the
                                                         doorbell count was set. */
	uint64_t i2_overf                     : 1;  /**< Port-2 had a doorbell overflow. Bit[31] of the
                                                         doorbell count was set. */
	uint64_t i1_overf                     : 1;  /**< Port-1 had a doorbell overflow. Bit[31] of the
                                                         doorbell count was set. */
	uint64_t i0_overf                     : 1;  /**< Port-0 had a doorbell overflow. Bit[31] of the
                                                         doorbell count was set. */
	uint64_t i3_rtout                     : 1;  /**< Port-3 had a read timeout while attempting to
                                                         read instructions. */
	uint64_t i2_rtout                     : 1;  /**< Port-2 had a read timeout while attempting to
                                                         read instructions. */
	uint64_t i1_rtout                     : 1;  /**< Port-1 had a read timeout while attempting to
                                                         read instructions. */
	uint64_t i0_rtout                     : 1;  /**< Port-0 had a read timeout while attempting to
                                                         read instructions. */
	uint64_t po3_2sml                     : 1;  /**< The packet being sent out on Port3 is smaller
                                                         than the NPI_BUFF_SIZE_OUTPUT3[ISIZE] field. */
	uint64_t po2_2sml                     : 1;  /**< The packet being sent out on Port2 is smaller
                                                         than the NPI_BUFF_SIZE_OUTPUT2[ISIZE] field. */
	uint64_t po1_2sml                     : 1;  /**< The packet being sent out on Port1 is smaller
                                                         than the NPI_BUFF_SIZE_OUTPUT1[ISIZE] field. */
	uint64_t po0_2sml                     : 1;  /**< The packet being sent out on Port0 is smaller
                                                         than the NPI_BUFF_SIZE_OUTPUT0[ISIZE] field. */
	uint64_t pci_rsl                      : 1;  /**< This '1' when a bit in PCI_INT_SUM2 is SET and the
                                                         corresponding bit in the PCI_INT_ENB2 is SET. */
	uint64_t rml_wto                      : 1;  /**< Set '1' when the RML does not receive a commit
                                                         back from a RSL after sending a write command to
                                                         a RSL. */
	uint64_t rml_rto                      : 1;  /**< Set '1' when the RML does not receive read data
                                                         back from a RSL after sending a read command to
                                                         a RSL. */
#else
	uint64_t rml_rto                      : 1;
	uint64_t rml_wto                      : 1;
	uint64_t pci_rsl                      : 1;
	uint64_t po0_2sml                     : 1;
	uint64_t po1_2sml                     : 1;
	uint64_t po2_2sml                     : 1;
	uint64_t po3_2sml                     : 1;
	uint64_t i0_rtout                     : 1;
	uint64_t i1_rtout                     : 1;
	uint64_t i2_rtout                     : 1;
	uint64_t i3_rtout                     : 1;
	uint64_t i0_overf                     : 1;
	uint64_t i1_overf                     : 1;
	uint64_t i2_overf                     : 1;
	uint64_t i3_overf                     : 1;
	uint64_t p0_rtout                     : 1;
	uint64_t p1_rtout                     : 1;
	uint64_t p2_rtout                     : 1;
	uint64_t p3_rtout                     : 1;
	uint64_t p0_perr                      : 1;
	uint64_t p1_perr                      : 1;
	uint64_t p2_perr                      : 1;
	uint64_t p3_perr                      : 1;
	uint64_t g0_rtout                     : 1;
	uint64_t g1_rtout                     : 1;
	uint64_t g2_rtout                     : 1;
	uint64_t g3_rtout                     : 1;
	uint64_t p0_pperr                     : 1;
	uint64_t p1_pperr                     : 1;
	uint64_t p2_pperr                     : 1;
	uint64_t p3_pperr                     : 1;
	uint64_t p0_ptout                     : 1;
	uint64_t p1_ptout                     : 1;
	uint64_t p2_ptout                     : 1;
	uint64_t p3_ptout                     : 1;
	uint64_t i0_pperr                     : 1;
	uint64_t i1_pperr                     : 1;
	uint64_t i2_pperr                     : 1;
	uint64_t i3_pperr                     : 1;
	uint64_t win_rto                      : 1;
	uint64_t p_dperr                      : 1;
	uint64_t iobdma                       : 1;
	uint64_t fcr_s_e                      : 1;
	uint64_t fcr_a_f                      : 1;
	uint64_t pcr_s_e                      : 1;
	uint64_t pcr_a_f                      : 1;
	uint64_t q2_s_e                       : 1;
	uint64_t q2_a_f                       : 1;
	uint64_t q3_s_e                       : 1;
	uint64_t q3_a_f                       : 1;
	uint64_t com_s_e                      : 1;
	uint64_t com_a_f                      : 1;
	uint64_t pnc_s_e                      : 1;
	uint64_t pnc_a_f                      : 1;
	uint64_t rwx_s_e                      : 1;
	uint64_t rdx_s_e                      : 1;
	uint64_t pcf_p_e                      : 1;
	uint64_t pcf_p_f                      : 1;
	uint64_t pdf_p_e                      : 1;
	uint64_t pdf_p_f                      : 1;
	uint64_t q1_s_e                       : 1;
	uint64_t q1_a_f                       : 1;
	uint64_t reserved_62_63               : 2;
#endif
	} s;
	struct cvmx_npi_int_sum_cn30xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_62_63               : 2;
	uint64_t q1_a_f                       : 1;  /**< Attempted to add when Queue-1 FIFO is full. */
	uint64_t q1_s_e                       : 1;  /**< Attempted to subtract when Queue-1 FIFO is empty. */
	uint64_t pdf_p_f                      : 1;  /**< Attempted to push a full PCN-DATA-FIFO. */
	uint64_t pdf_p_e                      : 1;  /**< Attempted to pop an empty PCN-DATA-FIFO. */
	uint64_t pcf_p_f                      : 1;  /**< Attempted to push a full PCN-CNT-FIFO. */
	uint64_t pcf_p_e                      : 1;  /**< Attempted to pop an empty PCN-CNT-FIFO. */
	uint64_t rdx_s_e                      : 1;  /**< Attempted to subtract when DPI-XFR-Wait count is 0. */
	uint64_t rwx_s_e                      : 1;  /**< Attempted to subtract when RDN-XFR-Wait count is 0. */
	uint64_t pnc_a_f                      : 1;  /**< Attempted to add when PNI-NPI Credits are max. */
	uint64_t pnc_s_e                      : 1;  /**< Attempted to subtract when PNI-NPI Credits are 0. */
	uint64_t com_a_f                      : 1;  /**< Attempted to add when PCN-Commit Counter is max. */
	uint64_t com_s_e                      : 1;  /**< Attempted to subtract when PCN-Commit Counter is 0. */
	uint64_t q3_a_f                       : 1;  /**< Attempted to add when Queue-3 FIFO is full. */
	uint64_t q3_s_e                       : 1;  /**< Attempted to subtract when Queue-3 FIFO is empty. */
	uint64_t q2_a_f                       : 1;  /**< Attempted to add when Queue-2 FIFO is full. */
	uint64_t q2_s_e                       : 1;  /**< Attempted to subtract when Queue-2 FIFO is empty. */
	uint64_t pcr_a_f                      : 1;  /**< Attempted to add when POW Credits is full. */
	uint64_t pcr_s_e                      : 1;  /**< Attempted to subtract when POW Credits is empty. */
	uint64_t fcr_a_f                      : 1;  /**< Attempted to add when FPA Credits is full. */
	uint64_t fcr_s_e                      : 1;  /**< Attempted to subtract when FPA Credits is empty. */
	uint64_t iobdma                       : 1;  /**< Requested IOBDMA read size exceeded 128 words. */
	uint64_t p_dperr                      : 1;  /**< If a parity error occured on data written to L2C
                                                         from the PCI this bit may be set. */
	uint64_t win_rto                      : 1;  /**< Windowed Load Timed Out. */
	uint64_t reserved_36_38               : 3;
	uint64_t i0_pperr                     : 1;  /**< If a parity error occured on the port's instruction
                                                         this bit may be set. */
	uint64_t reserved_32_34               : 3;
	uint64_t p0_ptout                     : 1;  /**< Port-0 output had a read timeout on a DATA/INFO
                                                         pair. */
	uint64_t reserved_28_30               : 3;
	uint64_t p0_pperr                     : 1;  /**< If a parity error occured on the port DATA/INFO
                                                         pointer-pair, this bit may be set. */
	uint64_t reserved_24_26               : 3;
	uint64_t g0_rtout                     : 1;  /**< Port-0 had a read timeout while attempting to
                                                         read a gather list. */
	uint64_t reserved_20_22               : 3;
	uint64_t p0_perr                      : 1;  /**< If a parity error occured on the port's packet
                                                         data this bit may be set. */
	uint64_t reserved_16_18               : 3;
	uint64_t p0_rtout                     : 1;  /**< Port-0 had a read timeout while attempting to
                                                         read packet data. */
	uint64_t reserved_12_14               : 3;
	uint64_t i0_overf                     : 1;  /**< Port-0 had a doorbell overflow. Bit[31] of the
                                                         doorbell count was set. */
	uint64_t reserved_8_10                : 3;
	uint64_t i0_rtout                     : 1;  /**< Port-0 had a read timeout while attempting to
                                                         read instructions. */
	uint64_t reserved_4_6                 : 3;
	uint64_t po0_2sml                     : 1;  /**< The packet being sent out on Port0 is smaller
                                                         than the NPI_BUFF_SIZE_OUTPUT0[ISIZE] field. */
	uint64_t pci_rsl                      : 1;  /**< This '1' when a bit in PCI_INT_SUM2 is SET and the
                                                         corresponding bit in the PCI_INT_ENB2 is SET. */
	uint64_t rml_wto                      : 1;  /**< Set '1' when the RML does not receive a commit
                                                         back from a RSL after sending a write command to
                                                         a RSL. */
	uint64_t rml_rto                      : 1;  /**< Set '1' when the RML does not receive read data
                                                         back from a RSL after sending a read command to
                                                         a RSL. */
#else
	uint64_t rml_rto                      : 1;
	uint64_t rml_wto                      : 1;
	uint64_t pci_rsl                      : 1;
	uint64_t po0_2sml                     : 1;
	uint64_t reserved_4_6                 : 3;
	uint64_t i0_rtout                     : 1;
	uint64_t reserved_8_10                : 3;
	uint64_t i0_overf                     : 1;
	uint64_t reserved_12_14               : 3;
	uint64_t p0_rtout                     : 1;
	uint64_t reserved_16_18               : 3;
	uint64_t p0_perr                      : 1;
	uint64_t reserved_20_22               : 3;
	uint64_t g0_rtout                     : 1;
	uint64_t reserved_24_26               : 3;
	uint64_t p0_pperr                     : 1;
	uint64_t reserved_28_30               : 3;
	uint64_t p0_ptout                     : 1;
	uint64_t reserved_32_34               : 3;
	uint64_t i0_pperr                     : 1;
	uint64_t reserved_36_38               : 3;
	uint64_t win_rto                      : 1;
	uint64_t p_dperr                      : 1;
	uint64_t iobdma                       : 1;
	uint64_t fcr_s_e                      : 1;
	uint64_t fcr_a_f                      : 1;
	uint64_t pcr_s_e                      : 1;
	uint64_t pcr_a_f                      : 1;
	uint64_t q2_s_e                       : 1;
	uint64_t q2_a_f                       : 1;
	uint64_t q3_s_e                       : 1;
	uint64_t q3_a_f                       : 1;
	uint64_t com_s_e                      : 1;
	uint64_t com_a_f                      : 1;
	uint64_t pnc_s_e                      : 1;
	uint64_t pnc_a_f                      : 1;
	uint64_t rwx_s_e                      : 1;
	uint64_t rdx_s_e                      : 1;
	uint64_t pcf_p_e                      : 1;
	uint64_t pcf_p_f                      : 1;
	uint64_t pdf_p_e                      : 1;
	uint64_t pdf_p_f                      : 1;
	uint64_t q1_s_e                       : 1;
	uint64_t q1_a_f                       : 1;
	uint64_t reserved_62_63               : 2;
#endif
	} cn30xx;
	struct cvmx_npi_int_sum_cn31xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_62_63               : 2;
	uint64_t q1_a_f                       : 1;  /**< Attempted to add when Queue-1 FIFO is full. */
	uint64_t q1_s_e                       : 1;  /**< Attempted to subtract when Queue-1 FIFO is empty. */
	uint64_t pdf_p_f                      : 1;  /**< Attempted to push a full PCN-DATA-FIFO. */
	uint64_t pdf_p_e                      : 1;  /**< Attempted to pop an empty PCN-DATA-FIFO. */
	uint64_t pcf_p_f                      : 1;  /**< Attempted to push a full PCN-CNT-FIFO. */
	uint64_t pcf_p_e                      : 1;  /**< Attempted to pop an empty PCN-CNT-FIFO. */
	uint64_t rdx_s_e                      : 1;  /**< Attempted to subtract when DPI-XFR-Wait count is 0. */
	uint64_t rwx_s_e                      : 1;  /**< Attempted to subtract when RDN-XFR-Wait count is 0. */
	uint64_t pnc_a_f                      : 1;  /**< Attempted to add when PNI-NPI Credits are max. */
	uint64_t pnc_s_e                      : 1;  /**< Attempted to subtract when PNI-NPI Credits are 0. */
	uint64_t com_a_f                      : 1;  /**< Attempted to add when PCN-Commit Counter is max. */
	uint64_t com_s_e                      : 1;  /**< Attempted to subtract when PCN-Commit Counter is 0. */
	uint64_t q3_a_f                       : 1;  /**< Attempted to add when Queue-3 FIFO is full. */
	uint64_t q3_s_e                       : 1;  /**< Attempted to subtract when Queue-3 FIFO is empty. */
	uint64_t q2_a_f                       : 1;  /**< Attempted to add when Queue-2 FIFO is full. */
	uint64_t q2_s_e                       : 1;  /**< Attempted to subtract when Queue-2 FIFO is empty. */
	uint64_t pcr_a_f                      : 1;  /**< Attempted to add when POW Credits is full. */
	uint64_t pcr_s_e                      : 1;  /**< Attempted to subtract when POW Credits is empty. */
	uint64_t fcr_a_f                      : 1;  /**< Attempted to add when FPA Credits is full. */
	uint64_t fcr_s_e                      : 1;  /**< Attempted to subtract when FPA Credits is empty. */
	uint64_t iobdma                       : 1;  /**< Requested IOBDMA read size exceeded 128 words. */
	uint64_t p_dperr                      : 1;  /**< If a parity error occured on data written to L2C
                                                         from the PCI this bit may be set. */
	uint64_t win_rto                      : 1;  /**< Windowed Load Timed Out. */
	uint64_t reserved_37_38               : 2;
	uint64_t i1_pperr                     : 1;  /**< If a parity error occured on the port's instruction
                                                         this bit may be set. */
	uint64_t i0_pperr                     : 1;  /**< If a parity error occured on the port's instruction
                                                         this bit may be set. */
	uint64_t reserved_33_34               : 2;
	uint64_t p1_ptout                     : 1;  /**< Port-1 output had a read timeout on a DATA/INFO
                                                         pair. */
	uint64_t p0_ptout                     : 1;  /**< Port-0 output had a read timeout on a DATA/INFO
                                                         pair. */
	uint64_t reserved_29_30               : 2;
	uint64_t p1_pperr                     : 1;  /**< If a parity error occured on the port DATA/INFO
                                                         pointer-pair, this bit may be set. */
	uint64_t p0_pperr                     : 1;  /**< If a parity error occured on the port DATA/INFO
                                                         pointer-pair, this bit may be set. */
	uint64_t reserved_25_26               : 2;
	uint64_t g1_rtout                     : 1;  /**< Port-1 had a read timeout while attempting to
                                                         read a gather list. */
	uint64_t g0_rtout                     : 1;  /**< Port-0 had a read timeout while attempting to
                                                         read a gather list. */
	uint64_t reserved_21_22               : 2;
	uint64_t p1_perr                      : 1;  /**< If a parity error occured on the port's packet
                                                         data this bit may be set. */
	uint64_t p0_perr                      : 1;  /**< If a parity error occured on the port's packet
                                                         data this bit may be set. */
	uint64_t reserved_17_18               : 2;
	uint64_t p1_rtout                     : 1;  /**< Port-1 had a read timeout while attempting to
                                                         read packet data. */
	uint64_t p0_rtout                     : 1;  /**< Port-0 had a read timeout while attempting to
                                                         read packet data. */
	uint64_t reserved_13_14               : 2;
	uint64_t i1_overf                     : 1;  /**< Port-1 had a doorbell overflow. Bit[31] of the
                                                         doorbell count was set. */
	uint64_t i0_overf                     : 1;  /**< Port-0 had a doorbell overflow. Bit[31] of the
                                                         doorbell count was set. */
	uint64_t reserved_9_10                : 2;
	uint64_t i1_rtout                     : 1;  /**< Port-1 had a read timeout while attempting to
                                                         read instructions. */
	uint64_t i0_rtout                     : 1;  /**< Port-0 had a read timeout while attempting to
                                                         read instructions. */
	uint64_t reserved_5_6                 : 2;
	uint64_t po1_2sml                     : 1;  /**< The packet being sent out on Port1 is smaller
                                                         than the NPI_BUFF_SIZE_OUTPUT1[ISIZE] field. */
	uint64_t po0_2sml                     : 1;  /**< The packet being sent out on Port0 is smaller
                                                         than the NPI_BUFF_SIZE_OUTPUT0[ISIZE] field. */
	uint64_t pci_rsl                      : 1;  /**< This '1' when a bit in PCI_INT_SUM2 is SET and the
                                                         corresponding bit in the PCI_INT_ENB2 is SET. */
	uint64_t rml_wto                      : 1;  /**< Set '1' when the RML does not receive a commit
                                                         back from a RSL after sending a write command to
                                                         a RSL. */
	uint64_t rml_rto                      : 1;  /**< Set '1' when the RML does not receive read data
                                                         back from a RSL after sending a read command to
                                                         a RSL. */
#else
	uint64_t rml_rto                      : 1;
	uint64_t rml_wto                      : 1;
	uint64_t pci_rsl                      : 1;
	uint64_t po0_2sml                     : 1;
	uint64_t po1_2sml                     : 1;
	uint64_t reserved_5_6                 : 2;
	uint64_t i0_rtout                     : 1;
	uint64_t i1_rtout                     : 1;
	uint64_t reserved_9_10                : 2;
	uint64_t i0_overf                     : 1;
	uint64_t i1_overf                     : 1;
	uint64_t reserved_13_14               : 2;
	uint64_t p0_rtout                     : 1;
	uint64_t p1_rtout                     : 1;
	uint64_t reserved_17_18               : 2;
	uint64_t p0_perr                      : 1;
	uint64_t p1_perr                      : 1;
	uint64_t reserved_21_22               : 2;
	uint64_t g0_rtout                     : 1;
	uint64_t g1_rtout                     : 1;
	uint64_t reserved_25_26               : 2;
	uint64_t p0_pperr                     : 1;
	uint64_t p1_pperr                     : 1;
	uint64_t reserved_29_30               : 2;
	uint64_t p0_ptout                     : 1;
	uint64_t p1_ptout                     : 1;
	uint64_t reserved_33_34               : 2;
	uint64_t i0_pperr                     : 1;
	uint64_t i1_pperr                     : 1;
	uint64_t reserved_37_38               : 2;
	uint64_t win_rto                      : 1;
	uint64_t p_dperr                      : 1;
	uint64_t iobdma                       : 1;
	uint64_t fcr_s_e                      : 1;
	uint64_t fcr_a_f                      : 1;
	uint64_t pcr_s_e                      : 1;
	uint64_t pcr_a_f                      : 1;
	uint64_t q2_s_e                       : 1;
	uint64_t q2_a_f                       : 1;
	uint64_t q3_s_e                       : 1;
	uint64_t q3_a_f                       : 1;
	uint64_t com_s_e                      : 1;
	uint64_t com_a_f                      : 1;
	uint64_t pnc_s_e                      : 1;
	uint64_t pnc_a_f                      : 1;
	uint64_t rwx_s_e                      : 1;
	uint64_t rdx_s_e                      : 1;
	uint64_t pcf_p_e                      : 1;
	uint64_t pcf_p_f                      : 1;
	uint64_t pdf_p_e                      : 1;
	uint64_t pdf_p_f                      : 1;
	uint64_t q1_s_e                       : 1;
	uint64_t q1_a_f                       : 1;
	uint64_t reserved_62_63               : 2;
#endif
	} cn31xx;
	struct cvmx_npi_int_sum_s             cn38xx;
	struct cvmx_npi_int_sum_cn38xxp2
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_42_63               : 22;
	uint64_t iobdma                       : 1;  /**< Requested IOBDMA read size exceeded 128 words. */
	uint64_t p_dperr                      : 1;  /**< If a parity error occured on data written to L2C
                                                         from the PCI this bit may be set. */
	uint64_t win_rto                      : 1;  /**< Windowed Load Timed Out. */
	uint64_t i3_pperr                     : 1;  /**< If a parity error occured on the port's instruction
                                                         this bit may be set. */
	uint64_t i2_pperr                     : 1;  /**< If a parity error occured on the port's instruction
                                                         this bit may be set. */
	uint64_t i1_pperr                     : 1;  /**< If a parity error occured on the port's instruction
                                                         this bit may be set. */
	uint64_t i0_pperr                     : 1;  /**< If a parity error occured on the port's instruction
                                                         this bit may be set. */
	uint64_t p3_ptout                     : 1;  /**< Port-3 output had a read timeout on a DATA/INFO
                                                         pair. */
	uint64_t p2_ptout                     : 1;  /**< Port-2 output had a read timeout on a DATA/INFO
                                                         pair. */
	uint64_t p1_ptout                     : 1;  /**< Port-1 output had a read timeout on a DATA/INFO
                                                         pair. */
	uint64_t p0_ptout                     : 1;  /**< Port-0 output had a read timeout on a DATA/INFO
                                                         pair. */
	uint64_t p3_pperr                     : 1;  /**< If a parity error occured on the port DATA/INFO
                                                         pointer-pair, this bit may be set. */
	uint64_t p2_pperr                     : 1;  /**< If a parity error occured on the port DATA/INFO
                                                         pointer-pair, this bit may be set. */
	uint64_t p1_pperr                     : 1;  /**< If a parity error occured on the port DATA/INFO
                                                         pointer-pair, this bit may be set. */
	uint64_t p0_pperr                     : 1;  /**< If a parity error occured on the port DATA/INFO
                                                         pointer-pair, this bit may be set. */
	uint64_t g3_rtout                     : 1;  /**< Port-3 had a read timeout while attempting to
                                                         read a gather list. */
	uint64_t g2_rtout                     : 1;  /**< Port-2 had a read timeout while attempting to
                                                         read a gather list. */
	uint64_t g1_rtout                     : 1;  /**< Port-1 had a read timeout while attempting to
                                                         read a gather list. */
	uint64_t g0_rtout                     : 1;  /**< Port-0 had a read timeout while attempting to
                                                         read a gather list. */
	uint64_t p3_perr                      : 1;  /**< If a parity error occured on the port's packet
                                                         data this bit may be set. */
	uint64_t p2_perr                      : 1;  /**< If a parity error occured on the port's packet
                                                         data this bit may be set. */
	uint64_t p1_perr                      : 1;  /**< If a parity error occured on the port's packet
                                                         data this bit may be set. */
	uint64_t p0_perr                      : 1;  /**< If a parity error occured on the port's packet
                                                         data this bit may be set. */
	uint64_t p3_rtout                     : 1;  /**< Port-3 had a read timeout while attempting to
                                                         read packet data. */
	uint64_t p2_rtout                     : 1;  /**< Port-2 had a read timeout while attempting to
                                                         read packet data. */
	uint64_t p1_rtout                     : 1;  /**< Port-1 had a read timeout while attempting to
                                                         read packet data. */
	uint64_t p0_rtout                     : 1;  /**< Port-0 had a read timeout while attempting to
                                                         read packet data. */
	uint64_t i3_overf                     : 1;  /**< Port-3 had a doorbell overflow. Bit[31] of the
                                                         doorbell count was set. */
	uint64_t i2_overf                     : 1;  /**< Port-2 had a doorbell overflow. Bit[31] of the
                                                         doorbell count was set. */
	uint64_t i1_overf                     : 1;  /**< Port-1 had a doorbell overflow. Bit[31] of the
                                                         doorbell count was set. */
	uint64_t i0_overf                     : 1;  /**< Port-0 had a doorbell overflow. Bit[31] of the
                                                         doorbell count was set. */
	uint64_t i3_rtout                     : 1;  /**< Port-3 had a read timeout while attempting to
                                                         read instructions. */
	uint64_t i2_rtout                     : 1;  /**< Port-2 had a read timeout while attempting to
                                                         read instructions. */
	uint64_t i1_rtout                     : 1;  /**< Port-1 had a read timeout while attempting to
                                                         read instructions. */
	uint64_t i0_rtout                     : 1;  /**< Port-0 had a read timeout while attempting to
                                                         read instructions. */
	uint64_t po3_2sml                     : 1;  /**< The packet being sent out on Port3 is smaller
                                                         than the NPI_BUFF_SIZE_OUTPUT3[ISIZE] field. */
	uint64_t po2_2sml                     : 1;  /**< The packet being sent out on Port2 is smaller
                                                         than the NPI_BUFF_SIZE_OUTPUT2[ISIZE] field. */
	uint64_t po1_2sml                     : 1;  /**< The packet being sent out on Port1 is smaller
                                                         than the NPI_BUFF_SIZE_OUTPUT1[ISIZE] field. */
	uint64_t po0_2sml                     : 1;  /**< The packet being sent out on Port0 is smaller
                                                         than the NPI_BUFF_SIZE_OUTPUT0[ISIZE] field. */
	uint64_t pci_rsl                      : 1;  /**< This '1' when a bit in PCI_INT_SUM2 is SET and the
                                                         corresponding bit in the PCI_INT_ENB2 is SET. */
	uint64_t rml_wto                      : 1;  /**< Set '1' when the RML does not receive a commit
                                                         back from a RSL after sending a write command to
                                                         a RSL. */
	uint64_t rml_rto                      : 1;  /**< Set '1' when the RML does not receive read data
                                                         back from a RSL after sending a read command to
                                                         a RSL. */
#else
	uint64_t rml_rto                      : 1;
	uint64_t rml_wto                      : 1;
	uint64_t pci_rsl                      : 1;
	uint64_t po0_2sml                     : 1;
	uint64_t po1_2sml                     : 1;
	uint64_t po2_2sml                     : 1;
	uint64_t po3_2sml                     : 1;
	uint64_t i0_rtout                     : 1;
	uint64_t i1_rtout                     : 1;
	uint64_t i2_rtout                     : 1;
	uint64_t i3_rtout                     : 1;
	uint64_t i0_overf                     : 1;
	uint64_t i1_overf                     : 1;
	uint64_t i2_overf                     : 1;
	uint64_t i3_overf                     : 1;
	uint64_t p0_rtout                     : 1;
	uint64_t p1_rtout                     : 1;
	uint64_t p2_rtout                     : 1;
	uint64_t p3_rtout                     : 1;
	uint64_t p0_perr                      : 1;
	uint64_t p1_perr                      : 1;
	uint64_t p2_perr                      : 1;
	uint64_t p3_perr                      : 1;
	uint64_t g0_rtout                     : 1;
	uint64_t g1_rtout                     : 1;
	uint64_t g2_rtout                     : 1;
	uint64_t g3_rtout                     : 1;
	uint64_t p0_pperr                     : 1;
	uint64_t p1_pperr                     : 1;
	uint64_t p2_pperr                     : 1;
	uint64_t p3_pperr                     : 1;
	uint64_t p0_ptout                     : 1;
	uint64_t p1_ptout                     : 1;
	uint64_t p2_ptout                     : 1;
	uint64_t p3_ptout                     : 1;
	uint64_t i0_pperr                     : 1;
	uint64_t i1_pperr                     : 1;
	uint64_t i2_pperr                     : 1;
	uint64_t i3_pperr                     : 1;
	uint64_t win_rto                      : 1;
	uint64_t p_dperr                      : 1;
	uint64_t iobdma                       : 1;
	uint64_t reserved_42_63               : 22;
#endif
	} cn38xxp2;
	struct cvmx_npi_int_sum_cn31xx        cn50xx;
	struct cvmx_npi_int_sum_s             cn58xx;
	struct cvmx_npi_int_sum_s             cn58xxp1;
};
typedef union cvmx_npi_int_sum cvmx_npi_int_sum_t;

/**
 * cvmx_npi_lowp_dbell
 *
 * NPI_LOWP_DBELL = Low Priority Door Bell
 *
 * The door bell register for the low priority DMA queue.
 */
union cvmx_npi_lowp_dbell
{
	uint64_t u64;
	struct cvmx_npi_lowp_dbell_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_16_63               : 48;
	uint64_t dbell                        : 16; /**< The value written to this register is added to the
                                                         number of 8byte words to be read and processes for
                                                         the low priority dma queue. */
#else
	uint64_t dbell                        : 16;
	uint64_t reserved_16_63               : 48;
#endif
	} s;
	struct cvmx_npi_lowp_dbell_s          cn30xx;
	struct cvmx_npi_lowp_dbell_s          cn31xx;
	struct cvmx_npi_lowp_dbell_s          cn38xx;
	struct cvmx_npi_lowp_dbell_s          cn38xxp2;
	struct cvmx_npi_lowp_dbell_s          cn50xx;
	struct cvmx_npi_lowp_dbell_s          cn58xx;
	struct cvmx_npi_lowp_dbell_s          cn58xxp1;
};
typedef union cvmx_npi_lowp_dbell cvmx_npi_lowp_dbell_t;

/**
 * cvmx_npi_lowp_ibuff_saddr
 *
 * NPI_LOWP_IBUFF_SADDR = DMA Low Priority's Instruction Buffer Starting Address
 *
 * The address to start reading Instructions from for LOWP.
 */
union cvmx_npi_lowp_ibuff_saddr
{
	uint64_t u64;
	struct cvmx_npi_lowp_ibuff_saddr_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_36_63               : 28;
	uint64_t saddr                        : 36; /**< The starting address to read the first instruction. */
#else
	uint64_t saddr                        : 36;
	uint64_t reserved_36_63               : 28;
#endif
	} s;
	struct cvmx_npi_lowp_ibuff_saddr_s    cn30xx;
	struct cvmx_npi_lowp_ibuff_saddr_s    cn31xx;
	struct cvmx_npi_lowp_ibuff_saddr_s    cn38xx;
	struct cvmx_npi_lowp_ibuff_saddr_s    cn38xxp2;
	struct cvmx_npi_lowp_ibuff_saddr_s    cn50xx;
	struct cvmx_npi_lowp_ibuff_saddr_s    cn58xx;
	struct cvmx_npi_lowp_ibuff_saddr_s    cn58xxp1;
};
typedef union cvmx_npi_lowp_ibuff_saddr cvmx_npi_lowp_ibuff_saddr_t;

/**
 * cvmx_npi_mem_access_subid#
 *
 * NPI_MEM_ACCESS_SUBID3 = Memory Access SubId 3Register
 *
 * Carries Read/Write parameters for PP access to PCI memory that use NPI SubId3.
 * Writes to this register are not ordered with writes/reads to the PCI Memory space.
 * To ensure that a write has completed the user must read the register before
 * making an access(i.e. PCI memory space) that requires the value of this register to be updated.
 */
union cvmx_npi_mem_access_subidx
{
	uint64_t u64;
	struct cvmx_npi_mem_access_subidx_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_38_63               : 26;
	uint64_t shortl                       : 1;  /**< Generate CMD-6 on PCI(x) when '1'.
                                                         Loads from the cores to the corresponding subid
                                                         that are 32-bits or smaller:
                                                         - Will generate the PCI-X "Memory Read DWORD"
                                                           command in PCI-X mode. (Note that "Memory
                                                           Read DWORD" appears much like an IO read on
                                                           the PCI-X bus.)
                                                         - Will generate the PCI "Memory Read" command
                                                           in PCI-X mode, irrespective of the
                                                           NPI_PCI_READ_CMD[CMD_SIZE] value.
                                                         NOT IN PASS 1 NOR PASS 2 */
	uint64_t nmerge                       : 1;  /**< No Merge. (NOT IN PASS 1 NOR PASS 2) */
	uint64_t esr                          : 2;  /**< Endian-Swap on read. */
	uint64_t esw                          : 2;  /**< Endian-Swap on write. */
	uint64_t nsr                          : 1;  /**< No-Snoop on read. */
	uint64_t nsw                          : 1;  /**< No-Snoop on write. */
	uint64_t ror                          : 1;  /**< Relax Read on read. */
	uint64_t row                          : 1;  /**< Relax Order on write. */
	uint64_t ba                           : 28; /**< PCI Address bits [63:36]. */
#else
	uint64_t ba                           : 28;
	uint64_t row                          : 1;
	uint64_t ror                          : 1;
	uint64_t nsw                          : 1;
	uint64_t nsr                          : 1;
	uint64_t esw                          : 2;
	uint64_t esr                          : 2;
	uint64_t nmerge                       : 1;
	uint64_t shortl                       : 1;
	uint64_t reserved_38_63               : 26;
#endif
	} s;
	struct cvmx_npi_mem_access_subidx_s   cn30xx;
	struct cvmx_npi_mem_access_subidx_cn31xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_36_63               : 28;
	uint64_t esr                          : 2;  /**< Endian-Swap on read. */
	uint64_t esw                          : 2;  /**< Endian-Swap on write. */
	uint64_t nsr                          : 1;  /**< No-Snoop on read. */
	uint64_t nsw                          : 1;  /**< No-Snoop on write. */
	uint64_t ror                          : 1;  /**< Relax Read on read. */
	uint64_t row                          : 1;  /**< Relax Order on write. */
	uint64_t ba                           : 28; /**< PCI Address bits [63:36]. */
#else
	uint64_t ba                           : 28;
	uint64_t row                          : 1;
	uint64_t ror                          : 1;
	uint64_t nsw                          : 1;
	uint64_t nsr                          : 1;
	uint64_t esw                          : 2;
	uint64_t esr                          : 2;
	uint64_t reserved_36_63               : 28;
#endif
	} cn31xx;
	struct cvmx_npi_mem_access_subidx_s   cn38xx;
	struct cvmx_npi_mem_access_subidx_cn31xx cn38xxp2;
	struct cvmx_npi_mem_access_subidx_s   cn50xx;
	struct cvmx_npi_mem_access_subidx_s   cn58xx;
	struct cvmx_npi_mem_access_subidx_s   cn58xxp1;
};
typedef union cvmx_npi_mem_access_subidx cvmx_npi_mem_access_subidx_t;

/**
 * cvmx_npi_msi_rcv
 *
 * NPI_MSI_RCV = NPI MSI Receive Vector Register
 *
 * A bit is set in this register relative to the vector received during a MSI. And cleared by a W1 to the register.
 */
union cvmx_npi_msi_rcv
{
	uint64_t u64;
	struct cvmx_npi_msi_rcv_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t int_vec                      : 64; /**< Refer to PCI_MSI_RCV */
#else
	uint64_t int_vec                      : 64;
#endif
	} s;
	struct cvmx_npi_msi_rcv_s             cn30xx;
	struct cvmx_npi_msi_rcv_s             cn31xx;
	struct cvmx_npi_msi_rcv_s             cn38xx;
	struct cvmx_npi_msi_rcv_s             cn38xxp2;
	struct cvmx_npi_msi_rcv_s             cn50xx;
	struct cvmx_npi_msi_rcv_s             cn58xx;
	struct cvmx_npi_msi_rcv_s             cn58xxp1;
};
typedef union cvmx_npi_msi_rcv cvmx_npi_msi_rcv_t;

/**
 * cvmx_npi_num_desc_output#
 *
 * NUM_DESC_OUTPUT0 = Number Of Descriptors Available For Output 0
 *
 * The size of the Buffer/Info Pointer Pair ring for Output-0.
 */
union cvmx_npi_num_desc_outputx
{
	uint64_t u64;
	struct cvmx_npi_num_desc_outputx_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_32_63               : 32;
	uint64_t size                         : 32; /**< The size of the Buffer/Info Pointer Pair ring. */
#else
	uint64_t size                         : 32;
	uint64_t reserved_32_63               : 32;
#endif
	} s;
	struct cvmx_npi_num_desc_outputx_s    cn30xx;
	struct cvmx_npi_num_desc_outputx_s    cn31xx;
	struct cvmx_npi_num_desc_outputx_s    cn38xx;
	struct cvmx_npi_num_desc_outputx_s    cn38xxp2;
	struct cvmx_npi_num_desc_outputx_s    cn50xx;
	struct cvmx_npi_num_desc_outputx_s    cn58xx;
	struct cvmx_npi_num_desc_outputx_s    cn58xxp1;
};
typedef union cvmx_npi_num_desc_outputx cvmx_npi_num_desc_outputx_t;

/**
 * cvmx_npi_output_control
 *
 * NPI_OUTPUT_CONTROL = NPI's Output Control Register
 *
 * The address to start reading Instructions from for Output-3.
 */
union cvmx_npi_output_control
{
	uint64_t u64;
	struct cvmx_npi_output_control_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_49_63               : 15;
	uint64_t pkt_rr                       : 1;  /**< When set '1' the output packet selection will be
                                                         made with a Round Robin arbitration. When '0'
                                                         the output packet port is fixed in priority,
                                                         where the lower port number has higher priority.
                                                         PASS3 Field */
	uint64_t p3_bmode                     : 1;  /**< When set '1' PCI_PKTS_SENT3 register will be
                                                         updated with the number of bytes in the packet
                                                         sent, when '0' the register will have a value
                                                         of '1' added. */
	uint64_t p2_bmode                     : 1;  /**< When set '1' PCI_PKTS_SENT2 register will be
                                                         updated with the number of bytes in the packet
                                                         sent, when '0' the register will have a value
                                                         of '1' added. */
	uint64_t p1_bmode                     : 1;  /**< When set '1' PCI_PKTS_SENT1 register will be
                                                         updated with the number of bytes in the packet
                                                         sent, when '0' the register will have a value
                                                         of '1' added. */
	uint64_t p0_bmode                     : 1;  /**< When set '1' PCI_PKTS_SENT0 register will be
                                                         updated with the number of bytes in the packet
                                                         sent, when '0' the register will have a value
                                                         of '1' added. */
	uint64_t o3_es                        : 2;  /**< Endian Swap for Output3 Data. */
	uint64_t o3_ns                        : 1;  /**< NoSnoop Enable for Output3 Data. */
	uint64_t o3_ro                        : 1;  /**< Relaxed Ordering Enable for Output3 Data. */
	uint64_t o2_es                        : 2;  /**< Endian Swap for Output2 Data. */
	uint64_t o2_ns                        : 1;  /**< NoSnoop Enable for Output2 Data. */
	uint64_t o2_ro                        : 1;  /**< Relaxed Ordering Enable for Output2 Data. */
	uint64_t o1_es                        : 2;  /**< Endian Swap for Output1 Data. */
	uint64_t o1_ns                        : 1;  /**< NoSnoop Enable for Output1 Data. */
	uint64_t o1_ro                        : 1;  /**< Relaxed Ordering Enable for Output1 Data. */
	uint64_t o0_es                        : 2;  /**< Endian Swap for Output0 Data. */
	uint64_t o0_ns                        : 1;  /**< NoSnoop Enable for Output0 Data. */
	uint64_t o0_ro                        : 1;  /**< Relaxed Ordering Enable for Output0 Data. */
	uint64_t o3_csrm                      : 1;  /**< When '1' the address[63:60] to write packet data,
                                                         comes from the DPTR[63:60] in the scatter-list pair,
                                                         and the RO, NS, ES values come from the O3_ES,
                                                         O3_NS, O3_RO. When '0' the RO == DPTR[60],
                                                         NS == DPTR[61], ES == DPTR[63:62], the address the
                                                         packet will be written to is ADDR[63:60] ==
                                                         O3_ES[1:0], O3_NS, O3_RO. For Output Port-3. */
	uint64_t o2_csrm                      : 1;  /**< When '1' the address[63:60] to write packet data,
                                                         comes from the DPTR[63:60] in the scatter-list pair,
                                                         and the RO, NS, ES values come from the O2_ES,
                                                         O2_NS, O2_RO. When '0' the RO == DPTR[60],
                                                         NS == DPTR[61], ES == DPTR[63:62], the address the
                                                         packet will be written to is ADDR[63:60] ==
                                                         O2_ES[1:0], O2_NS, O2_RO. For Output Port-2. */
	uint64_t o1_csrm                      : 1;  /**< When '1' the address[63:60] to write packet data,
                                                         comes from the DPTR[63:60] in the scatter-list pair,
                                                         and the RO, NS, ES values come from the O1_ES,
                                                         O1_NS, O1_RO. When '0' the RO == DPTR[60],
                                                         NS == DPTR[61], ES == DPTR[63:62], the address the
                                                         packet will be written to is ADDR[63:60] ==
                                                         O1_ES[1:0], O1_NS, O1_RO. For Output Port-1. */
	uint64_t o0_csrm                      : 1;  /**< When '1' the address[63:60] to write packet data,
                                                         comes from the DPTR[63:60] in the scatter-list pair,
                                                         and the RO, NS, ES values come from the O0_ES,
                                                         O0_NS, O0_RO. When '0' the RO == DPTR[60],
                                                         NS == DPTR[61], ES == DPTR[63:62], the address the
                                                         packet will be written to is ADDR[63:60] ==
                                                         O0_ES[1:0], O0_NS, O0_RO. For Output Port-0. */
	uint64_t reserved_20_23               : 4;
	uint64_t iptr_o3                      : 1;  /**< Uses the Info-Pointer to store length and data
                                                         for output-3. */
	uint64_t iptr_o2                      : 1;  /**< Uses the Info-Pointer to store length and data
                                                         for output-2. */
	uint64_t iptr_o1                      : 1;  /**< Uses the Info-Pointer to store length and data
                                                         for output-1. */
	uint64_t iptr_o0                      : 1;  /**< Uses the Info-Pointer to store length and data
                                                         for output-0. */
	uint64_t esr_sl3                      : 2;  /**< The Endian-Swap-Mode for Slist3 reads. */
	uint64_t nsr_sl3                      : 1;  /**< Enables '1' NoSnoop for Slist3 reads. */
	uint64_t ror_sl3                      : 1;  /**< Enables '1' Relaxed Ordering for Slist3 reads. */
	uint64_t esr_sl2                      : 2;  /**< The Endian-Swap-Mode for Slist2 reads. */
	uint64_t nsr_sl2                      : 1;  /**< Enables '1' NoSnoop for Slist2 reads. */
	uint64_t ror_sl2                      : 1;  /**< Enables '1' Relaxed Ordering for Slist2 reads. */
	uint64_t esr_sl1                      : 2;  /**< The Endian-Swap-Mode for Slist1 reads. */
	uint64_t nsr_sl1                      : 1;  /**< Enables '1' NoSnoop for Slist1 reads. */
	uint64_t ror_sl1                      : 1;  /**< Enables '1' Relaxed Ordering for Slist1 reads. */
	uint64_t esr_sl0                      : 2;  /**< The Endian-Swap-Mode for Slist0 reads. */
	uint64_t nsr_sl0                      : 1;  /**< Enables '1' NoSnoop for Slist0 reads. */
	uint64_t ror_sl0                      : 1;  /**< Enables '1' Relaxed Ordering for Slist0 reads. */
#else
	uint64_t ror_sl0                      : 1;
	uint64_t nsr_sl0                      : 1;
	uint64_t esr_sl0                      : 2;
	uint64_t ror_sl1                      : 1;
	uint64_t nsr_sl1                      : 1;
	uint64_t esr_sl1                      : 2;
	uint64_t ror_sl2                      : 1;
	uint64_t nsr_sl2                      : 1;
	uint64_t esr_sl2                      : 2;
	uint64_t ror_sl3                      : 1;
	uint64_t nsr_sl3                      : 1;
	uint64_t esr_sl3                      : 2;
	uint64_t iptr_o0                      : 1;
	uint64_t iptr_o1                      : 1;
	uint64_t iptr_o2                      : 1;
	uint64_t iptr_o3                      : 1;
	uint64_t reserved_20_23               : 4;
	uint64_t o0_csrm                      : 1;
	uint64_t o1_csrm                      : 1;
	uint64_t o2_csrm                      : 1;
	uint64_t o3_csrm                      : 1;
	uint64_t o0_ro                        : 1;
	uint64_t o0_ns                        : 1;
	uint64_t o0_es                        : 2;
	uint64_t o1_ro                        : 1;
	uint64_t o1_ns                        : 1;
	uint64_t o1_es                        : 2;
	uint64_t o2_ro                        : 1;
	uint64_t o2_ns                        : 1;
	uint64_t o2_es                        : 2;
	uint64_t o3_ro                        : 1;
	uint64_t o3_ns                        : 1;
	uint64_t o3_es                        : 2;
	uint64_t p0_bmode                     : 1;
	uint64_t p1_bmode                     : 1;
	uint64_t p2_bmode                     : 1;
	uint64_t p3_bmode                     : 1;
	uint64_t pkt_rr                       : 1;
	uint64_t reserved_49_63               : 15;
#endif
	} s;
	struct cvmx_npi_output_control_cn30xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_45_63               : 19;
	uint64_t p0_bmode                     : 1;  /**< When set '1' PCI_PKTS_SENT0 register will be
                                                         updated with the number of bytes in the packet
                                                         sent, when '0' the register will have a value
                                                         of '1' added. */
	uint64_t reserved_32_43               : 12;
	uint64_t o0_es                        : 2;  /**< Endian Swap for Output0 Data. */
	uint64_t o0_ns                        : 1;  /**< NoSnoop Enable for Output0 Data. */
	uint64_t o0_ro                        : 1;  /**< Relaxed Ordering Enable for Output0 Data. */
	uint64_t reserved_25_27               : 3;
	uint64_t o0_csrm                      : 1;  /**< When '1' the address[63:60] to write packet data,
                                                         comes from the DPTR[63:60] in the scatter-list pair,
                                                         and the RO, NS, ES values come from the O0_ES,
                                                         O0_NS, O0_RO. When '0' the RO == DPTR[60],
                                                         NS == DPTR[61], ES == DPTR[63:62], the address the
                                                         packet will be written to is ADDR[63:60] ==
                                                         O0_ES[1:0], O0_NS, O0_RO. For Output Port-0. */
	uint64_t reserved_17_23               : 7;
	uint64_t iptr_o0                      : 1;  /**< Uses the Info-Pointer to store length and data
                                                         for output-0. */
	uint64_t reserved_4_15                : 12;
	uint64_t esr_sl0                      : 2;  /**< The Endian-Swap-Mode for Slist0 reads. */
	uint64_t nsr_sl0                      : 1;  /**< Enables '1' NoSnoop for Slist0 reads. */
	uint64_t ror_sl0                      : 1;  /**< Enables '1' Relaxed Ordering for Slist0 reads. */
#else
	uint64_t ror_sl0                      : 1;
	uint64_t nsr_sl0                      : 1;
	uint64_t esr_sl0                      : 2;
	uint64_t reserved_4_15                : 12;
	uint64_t iptr_o0                      : 1;
	uint64_t reserved_17_23               : 7;
	uint64_t o0_csrm                      : 1;
	uint64_t reserved_25_27               : 3;
	uint64_t o0_ro                        : 1;
	uint64_t o0_ns                        : 1;
	uint64_t o0_es                        : 2;
	uint64_t reserved_32_43               : 12;
	uint64_t p0_bmode                     : 1;
	uint64_t reserved_45_63               : 19;
#endif
	} cn30xx;
	struct cvmx_npi_output_control_cn31xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_46_63               : 18;
	uint64_t p1_bmode                     : 1;  /**< When set '1' PCI_PKTS_SENT1 register will be
                                                         updated with the number of bytes in the packet
                                                         sent, when '0' the register will have a value
                                                         of '1' added. */
	uint64_t p0_bmode                     : 1;  /**< When set '1' PCI_PKTS_SENT0 register will be
                                                         updated with the number of bytes in the packet
                                                         sent, when '0' the register will have a value
                                                         of '1' added. */
	uint64_t reserved_36_43               : 8;
	uint64_t o1_es                        : 2;  /**< Endian Swap for Output1 Data. */
	uint64_t o1_ns                        : 1;  /**< NoSnoop Enable for Output1 Data. */
	uint64_t o1_ro                        : 1;  /**< Relaxed Ordering Enable for Output1 Data. */
	uint64_t o0_es                        : 2;  /**< Endian Swap for Output0 Data. */
	uint64_t o0_ns                        : 1;  /**< NoSnoop Enable for Output0 Data. */
	uint64_t o0_ro                        : 1;  /**< Relaxed Ordering Enable for Output0 Data. */
	uint64_t reserved_26_27               : 2;
	uint64_t o1_csrm                      : 1;  /**< When '1' the address[63:60] to write packet data,
                                                         comes from the DPTR[63:60] in the scatter-list pair,
                                                         and the RO, NS, ES values come from the O1_ES,
                                                         O1_NS, O1_RO. When '0' the RO == DPTR[60],
                                                         NS == DPTR[61], ES == DPTR[63:62], the address the
                                                         packet will be written to is ADDR[63:60] ==
                                                         O1_ES[1:0], O1_NS, O1_RO. For Output Port-1. */
	uint64_t o0_csrm                      : 1;  /**< When '1' the address[63:60] to write packet data,
                                                         comes from the DPTR[63:60] in the scatter-list pair,
                                                         and the RO, NS, ES values come from the O0_ES,
                                                         O0_NS, O0_RO. When '0' the RO == DPTR[60],
                                                         NS == DPTR[61], ES == DPTR[63:62], the address the
                                                         packet will be written to is ADDR[63:60] ==
                                                         O0_ES[1:0], O0_NS, O0_RO. For Output Port-0. */
	uint64_t reserved_18_23               : 6;
	uint64_t iptr_o1                      : 1;  /**< Uses the Info-Pointer to store length and data
                                                         for output-1. */
	uint64_t iptr_o0                      : 1;  /**< Uses the Info-Pointer to store length and data
                                                         for output-0. */
	uint64_t reserved_8_15                : 8;
	uint64_t esr_sl1                      : 2;  /**< The Endian-Swap-Mode for Slist1 reads. */
	uint64_t nsr_sl1                      : 1;  /**< Enables '1' NoSnoop for Slist1 reads. */
	uint64_t ror_sl1                      : 1;  /**< Enables '1' Relaxed Ordering for Slist1 reads. */
	uint64_t esr_sl0                      : 2;  /**< The Endian-Swap-Mode for Slist0 reads. */
	uint64_t nsr_sl0                      : 1;  /**< Enables '1' NoSnoop for Slist0 reads. */
	uint64_t ror_sl0                      : 1;  /**< Enables '1' Relaxed Ordering for Slist0 reads. */
#else
	uint64_t ror_sl0                      : 1;
	uint64_t nsr_sl0                      : 1;
	uint64_t esr_sl0                      : 2;
	uint64_t ror_sl1                      : 1;
	uint64_t nsr_sl1                      : 1;
	uint64_t esr_sl1                      : 2;
	uint64_t reserved_8_15                : 8;
	uint64_t iptr_o0                      : 1;
	uint64_t iptr_o1                      : 1;
	uint64_t reserved_18_23               : 6;
	uint64_t o0_csrm                      : 1;
	uint64_t o1_csrm                      : 1;
	uint64_t reserved_26_27               : 2;
	uint64_t o0_ro                        : 1;
	uint64_t o0_ns                        : 1;
	uint64_t o0_es                        : 2;
	uint64_t o1_ro                        : 1;
	uint64_t o1_ns                        : 1;
	uint64_t o1_es                        : 2;
	uint64_t reserved_36_43               : 8;
	uint64_t p0_bmode                     : 1;
	uint64_t p1_bmode                     : 1;
	uint64_t reserved_46_63               : 18;
#endif
	} cn31xx;
	struct cvmx_npi_output_control_s      cn38xx;
	struct cvmx_npi_output_control_cn38xxp2
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_48_63               : 16;
	uint64_t p3_bmode                     : 1;  /**< When set '1' PCI_PKTS_SENT3 register will be
                                                         updated with the number of bytes in the packet
                                                         sent, when '0' the register will have a value
                                                         of '1' added. */
	uint64_t p2_bmode                     : 1;  /**< When set '1' PCI_PKTS_SENT2 register will be
                                                         updated with the number of bytes in the packet
                                                         sent, when '0' the register will have a value
                                                         of '1' added. */
	uint64_t p1_bmode                     : 1;  /**< When set '1' PCI_PKTS_SENT1 register will be
                                                         updated with the number of bytes in the packet
                                                         sent, when '0' the register will have a value
                                                         of '1' added. */
	uint64_t p0_bmode                     : 1;  /**< When set '1' PCI_PKTS_SENT0 register will be
                                                         updated with the number of bytes in the packet
                                                         sent, when '0' the register will have a value
                                                         of '1' added. */
	uint64_t o3_es                        : 2;  /**< Endian Swap for Output3 Data. */
	uint64_t o3_ns                        : 1;  /**< NoSnoop Enable for Output3 Data. */
	uint64_t o3_ro                        : 1;  /**< Relaxed Ordering Enable for Output3 Data. */
	uint64_t o2_es                        : 2;  /**< Endian Swap for Output2 Data. */
	uint64_t o2_ns                        : 1;  /**< NoSnoop Enable for Output2 Data. */
	uint64_t o2_ro                        : 1;  /**< Relaxed Ordering Enable for Output2 Data. */
	uint64_t o1_es                        : 2;  /**< Endian Swap for Output1 Data. */
	uint64_t o1_ns                        : 1;  /**< NoSnoop Enable for Output1 Data. */
	uint64_t o1_ro                        : 1;  /**< Relaxed Ordering Enable for Output1 Data. */
	uint64_t o0_es                        : 2;  /**< Endian Swap for Output0 Data. */
	uint64_t o0_ns                        : 1;  /**< NoSnoop Enable for Output0 Data. */
	uint64_t o0_ro                        : 1;  /**< Relaxed Ordering Enable for Output0 Data. */
	uint64_t o3_csrm                      : 1;  /**< When '1' the address[63:60] to write packet data,
                                                         comes from the DPTR[63:60] in the scatter-list pair,
                                                         and the RO, NS, ES values come from the O3_ES,
                                                         O3_NS, O3_RO. When '0' the RO == DPTR[60],
                                                         NS == DPTR[61], ES == DPTR[63:62], the address the
                                                         packet will be written to is ADDR[63:60] ==
                                                         O3_ES[1:0], O3_NS, O3_RO. For Output Port-3. */
	uint64_t o2_csrm                      : 1;  /**< When '1' the address[63:60] to write packet data,
                                                         comes from the DPTR[63:60] in the scatter-list pair,
                                                         and the RO, NS, ES values come from the O2_ES,
                                                         O2_NS, O2_RO. When '0' the RO == DPTR[60],
                                                         NS == DPTR[61], ES == DPTR[63:62], the address the
                                                         packet will be written to is ADDR[63:60] ==
                                                         O2_ES[1:0], O2_NS, O2_RO. For Output Port-2. */
	uint64_t o1_csrm                      : 1;  /**< When '1' the address[63:60] to write packet data,
                                                         comes from the DPTR[63:60] in the scatter-list pair,
                                                         and the RO, NS, ES values come from the O1_ES,
                                                         O1_NS, O1_RO. When '0' the RO == DPTR[60],
                                                         NS == DPTR[61], ES == DPTR[63:62], the address the
                                                         packet will be written to is ADDR[63:60] ==
                                                         O1_ES[1:0], O1_NS, O1_RO. For Output Port-1. */
	uint64_t o0_csrm                      : 1;  /**< When '1' the address[63:60] to write packet data,
                                                         comes from the DPTR[63:60] in the scatter-list pair,
                                                         and the RO, NS, ES values come from the O0_ES,
                                                         O0_NS, O0_RO. When '0' the RO == DPTR[60],
                                                         NS == DPTR[61], ES == DPTR[63:62], the address the
                                                         packet will be written to is ADDR[63:60] ==
                                                         O0_ES[1:0], O0_NS, O0_RO. For Output Port-0. */
	uint64_t reserved_20_23               : 4;
	uint64_t iptr_o3                      : 1;  /**< Uses the Info-Pointer to store length and data
                                                         for output-3. */
	uint64_t iptr_o2                      : 1;  /**< Uses the Info-Pointer to store length and data
                                                         for output-2. */
	uint64_t iptr_o1                      : 1;  /**< Uses the Info-Pointer to store length and data
                                                         for output-1. */
	uint64_t iptr_o0                      : 1;  /**< Uses the Info-Pointer to store length and data
                                                         for output-0. */
	uint64_t esr_sl3                      : 2;  /**< The Endian-Swap-Mode for Slist3 reads. */
	uint64_t nsr_sl3                      : 1;  /**< Enables '1' NoSnoop for Slist3 reads. */
	uint64_t ror_sl3                      : 1;  /**< Enables '1' Relaxed Ordering for Slist3 reads. */
	uint64_t esr_sl2                      : 2;  /**< The Endian-Swap-Mode for Slist2 reads. */
	uint64_t nsr_sl2                      : 1;  /**< Enables '1' NoSnoop for Slist2 reads. */
	uint64_t ror_sl2                      : 1;  /**< Enables '1' Relaxed Ordering for Slist2 reads. */
	uint64_t esr_sl1                      : 2;  /**< The Endian-Swap-Mode for Slist1 reads. */
	uint64_t nsr_sl1                      : 1;  /**< Enables '1' NoSnoop for Slist1 reads. */
	uint64_t ror_sl1                      : 1;  /**< Enables '1' Relaxed Ordering for Slist1 reads. */
	uint64_t esr_sl0                      : 2;  /**< The Endian-Swap-Mode for Slist0 reads. */
	uint64_t nsr_sl0                      : 1;  /**< Enables '1' NoSnoop for Slist0 reads. */
	uint64_t ror_sl0                      : 1;  /**< Enables '1' Relaxed Ordering for Slist0 reads. */
#else
	uint64_t ror_sl0                      : 1;
	uint64_t nsr_sl0                      : 1;
	uint64_t esr_sl0                      : 2;
	uint64_t ror_sl1                      : 1;
	uint64_t nsr_sl1                      : 1;
	uint64_t esr_sl1                      : 2;
	uint64_t ror_sl2                      : 1;
	uint64_t nsr_sl2                      : 1;
	uint64_t esr_sl2                      : 2;
	uint64_t ror_sl3                      : 1;
	uint64_t nsr_sl3                      : 1;
	uint64_t esr_sl3                      : 2;
	uint64_t iptr_o0                      : 1;
	uint64_t iptr_o1                      : 1;
	uint64_t iptr_o2                      : 1;
	uint64_t iptr_o3                      : 1;
	uint64_t reserved_20_23               : 4;
	uint64_t o0_csrm                      : 1;
	uint64_t o1_csrm                      : 1;
	uint64_t o2_csrm                      : 1;
	uint64_t o3_csrm                      : 1;
	uint64_t o0_ro                        : 1;
	uint64_t o0_ns                        : 1;
	uint64_t o0_es                        : 2;
	uint64_t o1_ro                        : 1;
	uint64_t o1_ns                        : 1;
	uint64_t o1_es                        : 2;
	uint64_t o2_ro                        : 1;
	uint64_t o2_ns                        : 1;
	uint64_t o2_es                        : 2;
	uint64_t o3_ro                        : 1;
	uint64_t o3_ns                        : 1;
	uint64_t o3_es                        : 2;
	uint64_t p0_bmode                     : 1;
	uint64_t p1_bmode                     : 1;
	uint64_t p2_bmode                     : 1;
	uint64_t p3_bmode                     : 1;
	uint64_t reserved_48_63               : 16;
#endif
	} cn38xxp2;
	struct cvmx_npi_output_control_cn50xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_49_63               : 15;
	uint64_t pkt_rr                       : 1;  /**< When set '1' the output packet selection will be
                                                         made with a Round Robin arbitration. When '0'
                                                         the output packet port is fixed in priority,
                                                         where the lower port number has higher priority.
                                                         PASS2 Field */
	uint64_t reserved_46_47               : 2;
	uint64_t p1_bmode                     : 1;  /**< When set '1' PCI_PKTS_SENT1 register will be
                                                         updated with the number of bytes in the packet
                                                         sent, when '0' the register will have a value
                                                         of '1' added. */
	uint64_t p0_bmode                     : 1;  /**< When set '1' PCI_PKTS_SENT0 register will be
                                                         updated with the number of bytes in the packet
                                                         sent, when '0' the register will have a value
                                                         of '1' added. */
	uint64_t reserved_36_43               : 8;
	uint64_t o1_es                        : 2;  /**< Endian Swap for Output1 Data. */
	uint64_t o1_ns                        : 1;  /**< NoSnoop Enable for Output1 Data. */
	uint64_t o1_ro                        : 1;  /**< Relaxed Ordering Enable for Output1 Data. */
	uint64_t o0_es                        : 2;  /**< Endian Swap for Output0 Data. */
	uint64_t o0_ns                        : 1;  /**< NoSnoop Enable for Output0 Data. */
	uint64_t o0_ro                        : 1;  /**< Relaxed Ordering Enable for Output0 Data. */
	uint64_t reserved_26_27               : 2;
	uint64_t o1_csrm                      : 1;  /**< When '1' the address[63:60] to write packet data,
                                                         comes from the DPTR[63:60] in the scatter-list pair,
                                                         and the RO, NS, ES values come from the O1_ES,
                                                         O1_NS, O1_RO. When '0' the RO == DPTR[60],
                                                         NS == DPTR[61], ES == DPTR[63:62], the address the
                                                         packet will be written to is ADDR[63:60] ==
                                                         O1_ES[1:0], O1_NS, O1_RO. For Output Port-1. */
	uint64_t o0_csrm                      : 1;  /**< When '1' the address[63:60] to write packet data,
                                                         comes from the DPTR[63:60] in the scatter-list pair,
                                                         and the RO, NS, ES values come from the O0_ES,
                                                         O0_NS, O0_RO. When '0' the RO == DPTR[60],
                                                         NS == DPTR[61], ES == DPTR[63:62], the address the
                                                         packet will be written to is ADDR[63:60] ==
                                                         O0_ES[1:0], O0_NS, O0_RO. For Output Port-0. */
	uint64_t reserved_18_23               : 6;
	uint64_t iptr_o1                      : 1;  /**< Uses the Info-Pointer to store length and data
                                                         for output-1. */
	uint64_t iptr_o0                      : 1;  /**< Uses the Info-Pointer to store length and data
                                                         for output-0. */
	uint64_t reserved_8_15                : 8;
	uint64_t esr_sl1                      : 2;  /**< The Endian-Swap-Mode for Slist1 reads. */
	uint64_t nsr_sl1                      : 1;  /**< Enables '1' NoSnoop for Slist1 reads. */
	uint64_t ror_sl1                      : 1;  /**< Enables '1' Relaxed Ordering for Slist1 reads. */
	uint64_t esr_sl0                      : 2;  /**< The Endian-Swap-Mode for Slist0 reads. */
	uint64_t nsr_sl0                      : 1;  /**< Enables '1' NoSnoop for Slist0 reads. */
	uint64_t ror_sl0                      : 1;  /**< Enables '1' Relaxed Ordering for Slist0 reads. */
#else
	uint64_t ror_sl0                      : 1;
	uint64_t nsr_sl0                      : 1;
	uint64_t esr_sl0                      : 2;
	uint64_t ror_sl1                      : 1;
	uint64_t nsr_sl1                      : 1;
	uint64_t esr_sl1                      : 2;
	uint64_t reserved_8_15                : 8;
	uint64_t iptr_o0                      : 1;
	uint64_t iptr_o1                      : 1;
	uint64_t reserved_18_23               : 6;
	uint64_t o0_csrm                      : 1;
	uint64_t o1_csrm                      : 1;
	uint64_t reserved_26_27               : 2;
	uint64_t o0_ro                        : 1;
	uint64_t o0_ns                        : 1;
	uint64_t o0_es                        : 2;
	uint64_t o1_ro                        : 1;
	uint64_t o1_ns                        : 1;
	uint64_t o1_es                        : 2;
	uint64_t reserved_36_43               : 8;
	uint64_t p0_bmode                     : 1;
	uint64_t p1_bmode                     : 1;
	uint64_t reserved_46_47               : 2;
	uint64_t pkt_rr                       : 1;
	uint64_t reserved_49_63               : 15;
#endif
	} cn50xx;
	struct cvmx_npi_output_control_s      cn58xx;
	struct cvmx_npi_output_control_s      cn58xxp1;
};
typedef union cvmx_npi_output_control cvmx_npi_output_control_t;

/**
 * cvmx_npi_p#_dbpair_addr
 *
 * NPI_P0_DBPAIR_ADDR = NPI's Port-0 DATA-BUFFER Pair Next Read Address.
 *
 * Contains the next address to read for Port's-0 Data/Buffer Pair.
 */
union cvmx_npi_px_dbpair_addr
{
	uint64_t u64;
	struct cvmx_npi_px_dbpair_addr_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_63_63               : 1;
	uint64_t state                        : 2;  /**< POS state machine vector. Used to tell when NADDR
                                                         is valid (when STATE == 0). */
	uint64_t naddr                        : 61; /**< Bits [63:3] of the next Data-Info Pair to read.
                                                         Value is only valid when STATE == 0. */
#else
	uint64_t naddr                        : 61;
	uint64_t state                        : 2;
	uint64_t reserved_63_63               : 1;
#endif
	} s;
	struct cvmx_npi_px_dbpair_addr_s      cn30xx;
	struct cvmx_npi_px_dbpair_addr_s      cn31xx;
	struct cvmx_npi_px_dbpair_addr_s      cn38xx;
	struct cvmx_npi_px_dbpair_addr_s      cn38xxp2;
	struct cvmx_npi_px_dbpair_addr_s      cn50xx;
	struct cvmx_npi_px_dbpair_addr_s      cn58xx;
	struct cvmx_npi_px_dbpair_addr_s      cn58xxp1;
};
typedef union cvmx_npi_px_dbpair_addr cvmx_npi_px_dbpair_addr_t;

/**
 * cvmx_npi_p#_instr_addr
 *
 * NPI_P0_INSTR_ADDR = NPI's Port-0 Instruction Next Read Address.
 *
 * Contains the next address to read for Port's-0 Instructions.
 */
union cvmx_npi_px_instr_addr
{
	uint64_t u64;
	struct cvmx_npi_px_instr_addr_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t state                        : 3;  /**< Gather engine state vector. Used to tell when
                                                         NADDR is valid (when STATE == 0). */
	uint64_t naddr                        : 61; /**< Bits [63:3] of the next Instruction to read.
                                                         Value is only valid when STATE == 0. */
#else
	uint64_t naddr                        : 61;
	uint64_t state                        : 3;
#endif
	} s;
	struct cvmx_npi_px_instr_addr_s       cn30xx;
	struct cvmx_npi_px_instr_addr_s       cn31xx;
	struct cvmx_npi_px_instr_addr_s       cn38xx;
	struct cvmx_npi_px_instr_addr_s       cn38xxp2;
	struct cvmx_npi_px_instr_addr_s       cn50xx;
	struct cvmx_npi_px_instr_addr_s       cn58xx;
	struct cvmx_npi_px_instr_addr_s       cn58xxp1;
};
typedef union cvmx_npi_px_instr_addr cvmx_npi_px_instr_addr_t;

/**
 * cvmx_npi_p#_instr_cnts
 *
 * NPI_P0_INSTR_CNTS = NPI's Port-0 Instruction Counts For Packets In.
 *
 * Used to determine the number of instruction in the NPI and to be fetched for Input-Packets.
 */
union cvmx_npi_px_instr_cnts
{
	uint64_t u64;
	struct cvmx_npi_px_instr_cnts_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_38_63               : 26;
	uint64_t fcnt                         : 6;  /**< Number entries in the Instruction FIFO. */
	uint64_t avail                        : 32; /**< Doorbell count to be read. */
#else
	uint64_t avail                        : 32;
	uint64_t fcnt                         : 6;
	uint64_t reserved_38_63               : 26;
#endif
	} s;
	struct cvmx_npi_px_instr_cnts_s       cn30xx;
	struct cvmx_npi_px_instr_cnts_s       cn31xx;
	struct cvmx_npi_px_instr_cnts_s       cn38xx;
	struct cvmx_npi_px_instr_cnts_s       cn38xxp2;
	struct cvmx_npi_px_instr_cnts_s       cn50xx;
	struct cvmx_npi_px_instr_cnts_s       cn58xx;
	struct cvmx_npi_px_instr_cnts_s       cn58xxp1;
};
typedef union cvmx_npi_px_instr_cnts cvmx_npi_px_instr_cnts_t;

/**
 * cvmx_npi_p#_pair_cnts
 *
 * NPI_P0_PAIR_CNTS = NPI's Port-0 Instruction Counts For Packets Out.
 *
 * Used to determine the number of instruction in the NPI and to be fetched for Output-Packets.
 */
union cvmx_npi_px_pair_cnts
{
	uint64_t u64;
	struct cvmx_npi_px_pair_cnts_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_37_63               : 27;
	uint64_t fcnt                         : 5;  /**< 16 - number entries in the D/I Pair FIFO. */
	uint64_t avail                        : 32; /**< Doorbell count to be read. */
#else
	uint64_t avail                        : 32;
	uint64_t fcnt                         : 5;
	uint64_t reserved_37_63               : 27;
#endif
	} s;
	struct cvmx_npi_px_pair_cnts_s        cn30xx;
	struct cvmx_npi_px_pair_cnts_s        cn31xx;
	struct cvmx_npi_px_pair_cnts_s        cn38xx;
	struct cvmx_npi_px_pair_cnts_s        cn38xxp2;
	struct cvmx_npi_px_pair_cnts_s        cn50xx;
	struct cvmx_npi_px_pair_cnts_s        cn58xx;
	struct cvmx_npi_px_pair_cnts_s        cn58xxp1;
};
typedef union cvmx_npi_px_pair_cnts cvmx_npi_px_pair_cnts_t;

/**
 * cvmx_npi_pci_burst_size
 *
 * NPI_PCI_BURST_SIZE = NPI PCI Burst Size Register
 *
 * Control the number of words the NPI will attempt to read / write to/from the PCI.
 */
union cvmx_npi_pci_burst_size
{
	uint64_t u64;
	struct cvmx_npi_pci_burst_size_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_14_63               : 50;
	uint64_t wr_brst                      : 7;  /**< The number of 8B words to write to PCI in any one
                                                         write operation. A zero is equal to 128. This
                                                         value is used the packet reads and is clamped at
                                                         a max of 112 for dma writes. */
	uint64_t rd_brst                      : 7;  /**< Number of 8B words to read from PCI in any one
                                                         read operation. Legal values are 1 to 127, where
                                                         a 0 will be treated as a 1.
                                                         "For reading of packet data value is limited to 64
                                                         in PASS-2."
                                                         This value does not control the size of a read
                                                         caused by an IOBDMA from a PP. */
#else
	uint64_t rd_brst                      : 7;
	uint64_t wr_brst                      : 7;
	uint64_t reserved_14_63               : 50;
#endif
	} s;
	struct cvmx_npi_pci_burst_size_s      cn30xx;
	struct cvmx_npi_pci_burst_size_s      cn31xx;
	struct cvmx_npi_pci_burst_size_s      cn38xx;
	struct cvmx_npi_pci_burst_size_s      cn38xxp2;
	struct cvmx_npi_pci_burst_size_s      cn50xx;
	struct cvmx_npi_pci_burst_size_s      cn58xx;
	struct cvmx_npi_pci_burst_size_s      cn58xxp1;
};
typedef union cvmx_npi_pci_burst_size cvmx_npi_pci_burst_size_t;

/**
 * cvmx_npi_pci_int_arb_cfg
 *
 * NPI_PCI_INT_ARB_CFG = Configuration For PCI Arbiter
 *
 * Controls operation of the Internal PCI Arbiter.  This register should
 * only be written when PRST# is asserted.  NPI_PCI_INT_ARB_CFG[EN] should
 * only be set when Octane is a host.
 */
union cvmx_npi_pci_int_arb_cfg
{
	uint64_t u64;
	struct cvmx_npi_pci_int_arb_cfg_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_13_63               : 51;
	uint64_t hostmode                     : 1;  /**< PCI Host Mode Pin (sampled for use by software).
                                                         This bit reflects the sampled PCI_HOSTMODE pin.
                                                         In HOST Mode, OCTEON drives the PCI_CLK_OUT and
                                                         PCI initialization pattern during PCI_RST_N deassertion). */
	uint64_t pci_ovr                      : 4;  /**< PCI Host Mode Bus Speed/Type Override
                                                          When in Host Mode(PCI_HOSTMODE pin =1), OCTEON acting
                                                          as the PCI Central Agent, samples the PCI_PCI100,
                                                          PCI_M66EN and PCI_PCIXCAP pins to determine the
                                                          'sampled' PCI Bus speed and Bus Type (PCI or PCIX).
                                                          (see: PCI_CNT_REG[HM_SPEED,HM_PCIX])
                                                          However, in some cases, SW may want to override the
                                                          the 'sampled' PCI Bus Type/Speed, and use some
                                                          SLOWER Bus frequency.
                                                          The PCI_OVR field encoding represents the 'override'
                                                          PCI Bus Type/Speed which will be used to generate the
                                                          PCI_CLK_OUT and determines the PCI initialization pattern
                                                          driven during PCI_RST_N deassertion.
                                                              PCI_OVR[3]: OVERRIDE (0:DISABLE/1:ENABLE)
                                                              PCI_OVR[2]: BUS TYPE(0:PCI/1:PCIX)
                                                              PCI_OVR[1:0]: BUS SPEED(0:33/1:66/2:100/3:133)
                                                         OVERRIDE TYPE SPEED |  Override Configuration
                                                            [3]   [2]  [1:0] | TYPE       SPEED
                                                           ------------------+-------------------------------
                                                             0     x      xx | No override(uses 'sampled'
                                                                             | Bus Speed(HM_SPEED) and Bus Type(HM_PCIX)
                                                             1     0      00 | PCI Mode    33MHz
                                                             1     0      01 | PCI Mode    66MHz
                                                             1     0      10 | RESERVED (DO NOT USE)
                                                             1     0      11 | RESERVED (DO NOT USE)
                                                             1     1      00 | RESERVED (DO NOT USE)
                                                             1     1      01 | PCIX Mode   66MHz
                                                             1     1      10 | PCIX Mode  100MHz
                                                             1     1      11 | PCIX Mode  133MHz
                                                          NOTES:
                                                          - NPI_PCI_INT_ARB_CFG[PCI_OVR] has NO EFFECT on
                                                            PCI_CNT_REG[HM_SPEED,HM_PCIX] (ie: the sampled PCI Bus
                                                            Type/Speed), but WILL EFFECT PCI_CTL_STATUS_2[AP_PCIX]
                                                            which reflects the actual PCI Bus Type(0:PCI/1:PCIX).
                                                          - Software should never 'up' configure the recommended values.
                                                            In other words, if the 'sampled' Bus Type=PCI(HM_PCIX=0),
                                                            then SW should NOT attempt to set TYPE[2]=1 for PCIX Mode.
                                                            Likewise, if the sampled Bus Speed=66MHz(HM_SPEED=01),
                                                            then SW should NOT attempt to 'speed up' the bus [ie:
                                                            SPEED[1:0]=10(100MHz)].
                                                          - If PCI_OVR<3> is set prior to PCI reset de-assertion
                                                            in host mode, NPI_PCI_INT_ARB_CFG[PCI_OVR]
                                                            indicates the Bus Type/Speed that OCTEON drove on the
                                                            DEVSEL/STOP/TRDY pins during reset de-assertion. (user
                                                            should then ignore the 'sampled' Bus Type/Speed
                                                            contained in the PCI_CNT_REG[HM_PCIX, HM_SPEED]) fields.
                                                          - If PCI_OVR<3> is clear prior to PCI reset de-assertion
                                                            in host mode, PCI_CNT_REG[HM_PCIX,HM_SPEED])
                                                            indicates the Bus Type/Speed that OCTEON drove on the
                                                            DEVSEL/STOP/TRDY pins during reset de-assertion. */
	uint64_t reserved_5_7                 : 3;
	uint64_t en                           : 1;  /**< Internal arbiter enable. */
	uint64_t park_mod                     : 1;  /**< Bus park mode. 0=park on last, 1=park on device. */
	uint64_t park_dev                     : 3;  /**< Bus park device. 0-3 External device, 4 = Octane. */
#else
	uint64_t park_dev                     : 3;
	uint64_t park_mod                     : 1;
	uint64_t en                           : 1;
	uint64_t reserved_5_7                 : 3;
	uint64_t pci_ovr                      : 4;
	uint64_t hostmode                     : 1;
	uint64_t reserved_13_63               : 51;
#endif
	} s;
	struct cvmx_npi_pci_int_arb_cfg_cn30xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_5_63                : 59;
	uint64_t en                           : 1;  /**< Internal arbiter enable. */
	uint64_t park_mod                     : 1;  /**< Bus park mode. 0=park on last, 1=park on device. */
	uint64_t park_dev                     : 3;  /**< Bus park device. 0-3 External device, 4 = Octane. */
#else
	uint64_t park_dev                     : 3;
	uint64_t park_mod                     : 1;
	uint64_t en                           : 1;
	uint64_t reserved_5_63                : 59;
#endif
	} cn30xx;
	struct cvmx_npi_pci_int_arb_cfg_cn30xx cn31xx;
	struct cvmx_npi_pci_int_arb_cfg_cn30xx cn38xx;
	struct cvmx_npi_pci_int_arb_cfg_cn30xx cn38xxp2;
	struct cvmx_npi_pci_int_arb_cfg_s     cn50xx;
	struct cvmx_npi_pci_int_arb_cfg_s     cn58xx;
	struct cvmx_npi_pci_int_arb_cfg_s     cn58xxp1;
};
typedef union cvmx_npi_pci_int_arb_cfg cvmx_npi_pci_int_arb_cfg_t;

/**
 * cvmx_npi_pci_read_cmd
 *
 * NPI_PCI_READ_CMD = NPI PCI Read Command Register
 *
 * Controls the type of read command sent.
 * Writes to this register are not ordered with writes/reads to the PCI Memory space.
 * To ensure that a write has completed the user must read the register before
 * making an access(i.e. PCI memory space) that requires the value of this register to be updated.
 * Also any previously issued reads/writes to PCI memory space, still stored in the outbound
 * FIFO will use the value of this register after it has been updated.
 */
union cvmx_npi_pci_read_cmd
{
	uint64_t u64;
	struct cvmx_npi_pci_read_cmd_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_11_63               : 53;
	uint64_t cmd_size                     : 11; /**< Number bytes to be read is equal to or exceeds this
                                                         size will cause the PCI in PCI mode to use a
                                                         Memory-Read-Multiple. This register has a value
                                                         from 8 to 2048. A value of 0-7 will be treated as
                                                         a value of 2048. */
#else
	uint64_t cmd_size                     : 11;
	uint64_t reserved_11_63               : 53;
#endif
	} s;
	struct cvmx_npi_pci_read_cmd_s        cn30xx;
	struct cvmx_npi_pci_read_cmd_s        cn31xx;
	struct cvmx_npi_pci_read_cmd_s        cn38xx;
	struct cvmx_npi_pci_read_cmd_s        cn38xxp2;
	struct cvmx_npi_pci_read_cmd_s        cn50xx;
	struct cvmx_npi_pci_read_cmd_s        cn58xx;
	struct cvmx_npi_pci_read_cmd_s        cn58xxp1;
};
typedef union cvmx_npi_pci_read_cmd cvmx_npi_pci_read_cmd_t;

/**
 * cvmx_npi_port32_instr_hdr
 *
 * NPI_PORT32_INSTR_HDR = NPI Port 32 Instruction Header
 *
 * Contains bits [62:42] of the Instruction Header for port 32.
 */
union cvmx_npi_port32_instr_hdr
{
	uint64_t u64;
	struct cvmx_npi_port32_instr_hdr_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_44_63               : 20;
	uint64_t pbp                          : 1;  /**< Enable Packet-by-packet mode. */
	uint64_t rsv_f                        : 5;  /**< Reserved */
	uint64_t rparmode                     : 2;  /**< Parse Mode. Used when packet is raw and PBP==0. */
	uint64_t rsv_e                        : 1;  /**< Reserved */
	uint64_t rskp_len                     : 7;  /**< Skip Length. Used when packet is raw and PBP==0. */
	uint64_t rsv_d                        : 6;  /**< Reserved */
	uint64_t use_ihdr                     : 1;  /**< When set '1' the instruction header will be sent
                                                         as part of the packet data, regardless of the
                                                         value of bit [63] of the instruction header.
                                                         USE_IHDR must be set whenever PBP is set. */
	uint64_t rsv_c                        : 5;  /**< Reserved */
	uint64_t par_mode                     : 2;  /**< Parse Mode. Used when USE_IHDR is set and packet
                                                         is not raw and PBP is not set. */
	uint64_t rsv_b                        : 1;  /**< Reserved
                                                         instruction header sent to IPD. */
	uint64_t skp_len                      : 7;  /**< Skip Length. Used when USE_IHDR is set and packet
                                                         is not raw and PBP is not set. */
	uint64_t rsv_a                        : 6;  /**< Reserved */
#else
	uint64_t rsv_a                        : 6;
	uint64_t skp_len                      : 7;
	uint64_t rsv_b                        : 1;
	uint64_t par_mode                     : 2;
	uint64_t rsv_c                        : 5;
	uint64_t use_ihdr                     : 1;
	uint64_t rsv_d                        : 6;
	uint64_t rskp_len                     : 7;
	uint64_t rsv_e                        : 1;
	uint64_t rparmode                     : 2;
	uint64_t rsv_f                        : 5;
	uint64_t pbp                          : 1;
	uint64_t reserved_44_63               : 20;
#endif
	} s;
	struct cvmx_npi_port32_instr_hdr_s    cn30xx;
	struct cvmx_npi_port32_instr_hdr_s    cn31xx;
	struct cvmx_npi_port32_instr_hdr_s    cn38xx;
	struct cvmx_npi_port32_instr_hdr_s    cn38xxp2;
	struct cvmx_npi_port32_instr_hdr_s    cn50xx;
	struct cvmx_npi_port32_instr_hdr_s    cn58xx;
	struct cvmx_npi_port32_instr_hdr_s    cn58xxp1;
};
typedef union cvmx_npi_port32_instr_hdr cvmx_npi_port32_instr_hdr_t;

/**
 * cvmx_npi_port33_instr_hdr
 *
 * NPI_PORT33_INSTR_HDR = NPI Port 33 Instruction Header
 *
 * Contains bits [62:42] of the Instruction Header for port 33.
 */
union cvmx_npi_port33_instr_hdr
{
	uint64_t u64;
	struct cvmx_npi_port33_instr_hdr_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_44_63               : 20;
	uint64_t pbp                          : 1;  /**< Enable Packet-by-packet mode. */
	uint64_t rsv_f                        : 5;  /**< Reserved */
	uint64_t rparmode                     : 2;  /**< Parse Mode. Used when packet is raw and PBP==0. */
	uint64_t rsv_e                        : 1;  /**< Reserved */
	uint64_t rskp_len                     : 7;  /**< Skip Length. Used when packet is raw and PBP==0. */
	uint64_t rsv_d                        : 6;  /**< Reserved */
	uint64_t use_ihdr                     : 1;  /**< When set '1' the instruction header will be sent
                                                         as part of the packet data, regardless of the
                                                         value of bit [63] of the instruction header.
                                                         USE_IHDR must be set whenever PBP is set. */
	uint64_t rsv_c                        : 5;  /**< Reserved */
	uint64_t par_mode                     : 2;  /**< Parse Mode. Used when USE_IHDR is set and packet
                                                         is not raw and PBP is not set. */
	uint64_t rsv_b                        : 1;  /**< Reserved
                                                         instruction header sent to IPD. */
	uint64_t skp_len                      : 7;  /**< Skip Length. Used when USE_IHDR is set and packet
                                                         is not raw and PBP is not set. */
	uint64_t rsv_a                        : 6;  /**< Reserved */
#else
	uint64_t rsv_a                        : 6;
	uint64_t skp_len                      : 7;
	uint64_t rsv_b                        : 1;
	uint64_t par_mode                     : 2;
	uint64_t rsv_c                        : 5;
	uint64_t use_ihdr                     : 1;
	uint64_t rsv_d                        : 6;
	uint64_t rskp_len                     : 7;
	uint64_t rsv_e                        : 1;
	uint64_t rparmode                     : 2;
	uint64_t rsv_f                        : 5;
	uint64_t pbp                          : 1;
	uint64_t reserved_44_63               : 20;
#endif
	} s;
	struct cvmx_npi_port33_instr_hdr_s    cn31xx;
	struct cvmx_npi_port33_instr_hdr_s    cn38xx;
	struct cvmx_npi_port33_instr_hdr_s    cn38xxp2;
	struct cvmx_npi_port33_instr_hdr_s    cn50xx;
	struct cvmx_npi_port33_instr_hdr_s    cn58xx;
	struct cvmx_npi_port33_instr_hdr_s    cn58xxp1;
};
typedef union cvmx_npi_port33_instr_hdr cvmx_npi_port33_instr_hdr_t;

/**
 * cvmx_npi_port34_instr_hdr
 *
 * NPI_PORT34_INSTR_HDR = NPI Port 34 Instruction Header
 *
 * Contains bits [62:42] of the Instruction Header for port 34. Added for PASS-2.
 */
union cvmx_npi_port34_instr_hdr
{
	uint64_t u64;
	struct cvmx_npi_port34_instr_hdr_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_44_63               : 20;
	uint64_t pbp                          : 1;  /**< Enable Packet-by-packet mode. */
	uint64_t rsv_f                        : 5;  /**< Reserved */
	uint64_t rparmode                     : 2;  /**< Parse Mode. Used when packet is raw and PBP==0. */
	uint64_t rsv_e                        : 1;  /**< Reserved */
	uint64_t rskp_len                     : 7;  /**< Skip Length. Used when packet is raw and PBP==0. */
	uint64_t rsv_d                        : 6;  /**< Reserved */
	uint64_t use_ihdr                     : 1;  /**< When set '1' the instruction header will be sent
                                                         as part of the packet data, regardless of the
                                                         value of bit [63] of the instruction header.
                                                         USE_IHDR must be set whenever PBP is set. */
	uint64_t rsv_c                        : 5;  /**< Reserved */
	uint64_t par_mode                     : 2;  /**< Parse Mode. Used when USE_IHDR is set and packet
                                                         is not raw and PBP is not set. */
	uint64_t rsv_b                        : 1;  /**< Reserved
                                                         instruction header sent to IPD. */
	uint64_t skp_len                      : 7;  /**< Skip Length. Used when USE_IHDR is set and packet
                                                         is not raw and PBP is not set. */
	uint64_t rsv_a                        : 6;  /**< Reserved */
#else
	uint64_t rsv_a                        : 6;
	uint64_t skp_len                      : 7;
	uint64_t rsv_b                        : 1;
	uint64_t par_mode                     : 2;
	uint64_t rsv_c                        : 5;
	uint64_t use_ihdr                     : 1;
	uint64_t rsv_d                        : 6;
	uint64_t rskp_len                     : 7;
	uint64_t rsv_e                        : 1;
	uint64_t rparmode                     : 2;
	uint64_t rsv_f                        : 5;
	uint64_t pbp                          : 1;
	uint64_t reserved_44_63               : 20;
#endif
	} s;
	struct cvmx_npi_port34_instr_hdr_s    cn38xx;
	struct cvmx_npi_port34_instr_hdr_s    cn38xxp2;
	struct cvmx_npi_port34_instr_hdr_s    cn58xx;
	struct cvmx_npi_port34_instr_hdr_s    cn58xxp1;
};
typedef union cvmx_npi_port34_instr_hdr cvmx_npi_port34_instr_hdr_t;

/**
 * cvmx_npi_port35_instr_hdr
 *
 * NPI_PORT35_INSTR_HDR = NPI Port 35 Instruction Header
 *
 * Contains bits [62:42] of the Instruction Header for port 35. Added for PASS-2.
 */
union cvmx_npi_port35_instr_hdr
{
	uint64_t u64;
	struct cvmx_npi_port35_instr_hdr_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_44_63               : 20;
	uint64_t pbp                          : 1;  /**< Enable Packet-by-packet mode. */
	uint64_t rsv_f                        : 5;  /**< Reserved */
	uint64_t rparmode                     : 2;  /**< Parse Mode. Used when packet is raw and PBP==0. */
	uint64_t rsv_e                        : 1;  /**< Reserved */
	uint64_t rskp_len                     : 7;  /**< Skip Length. Used when packet is raw and PBP==0. */
	uint64_t rsv_d                        : 6;  /**< Reserved */
	uint64_t use_ihdr                     : 1;  /**< When set '1' the instruction header will be sent
                                                         as part of the packet data, regardless of the
                                                         value of bit [63] of the instruction header.
                                                         USE_IHDR must be set whenever PBP is set. */
	uint64_t rsv_c                        : 5;  /**< Reserved */
	uint64_t par_mode                     : 2;  /**< Parse Mode. Used when USE_IHDR is set and packet
                                                         is not raw and PBP is not set. */
	uint64_t rsv_b                        : 1;  /**< Reserved
                                                         instruction header sent to IPD. */
	uint64_t skp_len                      : 7;  /**< Skip Length. Used when USE_IHDR is set and packet
                                                         is not raw and PBP is not set. */
	uint64_t rsv_a                        : 6;  /**< Reserved */
#else
	uint64_t rsv_a                        : 6;
	uint64_t skp_len                      : 7;
	uint64_t rsv_b                        : 1;
	uint64_t par_mode                     : 2;
	uint64_t rsv_c                        : 5;
	uint64_t use_ihdr                     : 1;
	uint64_t rsv_d                        : 6;
	uint64_t rskp_len                     : 7;
	uint64_t rsv_e                        : 1;
	uint64_t rparmode                     : 2;
	uint64_t rsv_f                        : 5;
	uint64_t pbp                          : 1;
	uint64_t reserved_44_63               : 20;
#endif
	} s;
	struct cvmx_npi_port35_instr_hdr_s    cn38xx;
	struct cvmx_npi_port35_instr_hdr_s    cn38xxp2;
	struct cvmx_npi_port35_instr_hdr_s    cn58xx;
	struct cvmx_npi_port35_instr_hdr_s    cn58xxp1;
};
typedef union cvmx_npi_port35_instr_hdr cvmx_npi_port35_instr_hdr_t;

/**
 * cvmx_npi_port_bp_control
 *
 * NPI_PORT_BP_CONTROL = Port Backpressure Control
 *
 * Enables Port Level Backpressure
 */
union cvmx_npi_port_bp_control
{
	uint64_t u64;
	struct cvmx_npi_port_bp_control_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_8_63                : 56;
	uint64_t bp_on                        : 4;  /**< Port 35-32 port level backpressure applied. */
	uint64_t enb                          : 4;  /**< Enables port level backpressure from the IPD. */
#else
	uint64_t enb                          : 4;
	uint64_t bp_on                        : 4;
	uint64_t reserved_8_63                : 56;
#endif
	} s;
	struct cvmx_npi_port_bp_control_s     cn30xx;
	struct cvmx_npi_port_bp_control_s     cn31xx;
	struct cvmx_npi_port_bp_control_s     cn38xx;
	struct cvmx_npi_port_bp_control_s     cn38xxp2;
	struct cvmx_npi_port_bp_control_s     cn50xx;
	struct cvmx_npi_port_bp_control_s     cn58xx;
	struct cvmx_npi_port_bp_control_s     cn58xxp1;
};
typedef union cvmx_npi_port_bp_control cvmx_npi_port_bp_control_t;

/**
 * cvmx_npi_rsl_int_blocks
 *
 * RSL_INT_BLOCKS = RSL Interrupt Blocks Register
 *
 * Reading this register will return a vector with a bit set '1' for a corresponding RSL block
 * that presently has an interrupt pending. The Field Description below supplies the name of the
 * register that software should read to find out why that intterupt bit is set.
 */
union cvmx_npi_rsl_int_blocks
{
	uint64_t u64;
	struct cvmx_npi_rsl_int_blocks_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_32_63               : 32;
	uint64_t rint_31                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t iob                          : 1;  /**< IOB_INT_SUM */
	uint64_t reserved_28_29               : 2;
	uint64_t rint_27                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_26                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_25                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_24                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t asx1                         : 1;  /**< ASX1_INT_REG */
	uint64_t asx0                         : 1;  /**< ASX0_INT_REG */
	uint64_t rint_21                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t pip                          : 1;  /**< PIP_INT_REG. */
	uint64_t spx1                         : 1;  /**< SPX1_INT_REG & STX1_INT_REG */
	uint64_t spx0                         : 1;  /**< SPX0_INT_REG & STX0_INT_REG */
	uint64_t lmc                          : 1;  /**< LMC_MEM_CFG0 */
	uint64_t l2c                          : 1;  /**< L2T_ERR & L2D_ERR */
	uint64_t rint_15                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t reserved_13_14               : 2;
	uint64_t pow                          : 1;  /**< POW_ECC_ERR */
	uint64_t tim                          : 1;  /**< TIM_REG_ERROR */
	uint64_t pko                          : 1;  /**< PKO_REG_ERROR */
	uint64_t ipd                          : 1;  /**< IPD_INT_SUM */
	uint64_t rint_8                       : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t zip                          : 1;  /**< ZIP_ERROR */
	uint64_t dfa                          : 1;  /**< DFA_ERR */
	uint64_t fpa                          : 1;  /**< FPA_INT_SUM */
	uint64_t key                          : 1;  /**< KEY_INT_SUM */
	uint64_t npi                          : 1;  /**< NPI_INT_SUM */
	uint64_t gmx1                         : 1;  /**< GMX1_RX*_INT_REG & GMX1_TX_INT_REG */
	uint64_t gmx0                         : 1;  /**< GMX0_RX*_INT_REG & GMX0_TX_INT_REG */
	uint64_t mio                          : 1;  /**< MIO_BOOT_ERR */
#else
	uint64_t mio                          : 1;
	uint64_t gmx0                         : 1;
	uint64_t gmx1                         : 1;
	uint64_t npi                          : 1;
	uint64_t key                          : 1;
	uint64_t fpa                          : 1;
	uint64_t dfa                          : 1;
	uint64_t zip                          : 1;
	uint64_t rint_8                       : 1;
	uint64_t ipd                          : 1;
	uint64_t pko                          : 1;
	uint64_t tim                          : 1;
	uint64_t pow                          : 1;
	uint64_t reserved_13_14               : 2;
	uint64_t rint_15                      : 1;
	uint64_t l2c                          : 1;
	uint64_t lmc                          : 1;
	uint64_t spx0                         : 1;
	uint64_t spx1                         : 1;
	uint64_t pip                          : 1;
	uint64_t rint_21                      : 1;
	uint64_t asx0                         : 1;
	uint64_t asx1                         : 1;
	uint64_t rint_24                      : 1;
	uint64_t rint_25                      : 1;
	uint64_t rint_26                      : 1;
	uint64_t rint_27                      : 1;
	uint64_t reserved_28_29               : 2;
	uint64_t iob                          : 1;
	uint64_t rint_31                      : 1;
	uint64_t reserved_32_63               : 32;
#endif
	} s;
	struct cvmx_npi_rsl_int_blocks_cn30xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_32_63               : 32;
	uint64_t rint_31                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t iob                          : 1;  /**< IOB_INT_SUM */
	uint64_t rint_29                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_28                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_27                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_26                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_25                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_24                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t asx1                         : 1;  /**< ASX1_INT_REG */
	uint64_t asx0                         : 1;  /**< ASX0_INT_REG */
	uint64_t rint_21                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t pip                          : 1;  /**< PIP_INT_REG. */
	uint64_t spx1                         : 1;  /**< SPX1_INT_REG & STX1_INT_REG */
	uint64_t spx0                         : 1;  /**< SPX0_INT_REG & STX0_INT_REG */
	uint64_t lmc                          : 1;  /**< LMC_MEM_CFG0 */
	uint64_t l2c                          : 1;  /**< L2T_ERR & L2D_ERR */
	uint64_t rint_15                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_14                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t usb                          : 1;  /**< USBN_INT_SUM */
	uint64_t pow                          : 1;  /**< POW_ECC_ERR */
	uint64_t tim                          : 1;  /**< TIM_REG_ERROR */
	uint64_t pko                          : 1;  /**< PKO_REG_ERROR */
	uint64_t ipd                          : 1;  /**< IPD_INT_SUM */
	uint64_t rint_8                       : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t zip                          : 1;  /**< ZIP_ERROR */
	uint64_t dfa                          : 1;  /**< DFA_ERR */
	uint64_t fpa                          : 1;  /**< FPA_INT_SUM */
	uint64_t key                          : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t npi                          : 1;  /**< NPI_INT_SUM */
	uint64_t gmx1                         : 1;  /**< GMX1_RX*_INT_REG & GMX1_TX_INT_REG */
	uint64_t gmx0                         : 1;  /**< GMX0_RX*_INT_REG & GMX0_TX_INT_REG */
	uint64_t mio                          : 1;  /**< MIO_BOOT_ERR */
#else
	uint64_t mio                          : 1;
	uint64_t gmx0                         : 1;
	uint64_t gmx1                         : 1;
	uint64_t npi                          : 1;
	uint64_t key                          : 1;
	uint64_t fpa                          : 1;
	uint64_t dfa                          : 1;
	uint64_t zip                          : 1;
	uint64_t rint_8                       : 1;
	uint64_t ipd                          : 1;
	uint64_t pko                          : 1;
	uint64_t tim                          : 1;
	uint64_t pow                          : 1;
	uint64_t usb                          : 1;
	uint64_t rint_14                      : 1;
	uint64_t rint_15                      : 1;
	uint64_t l2c                          : 1;
	uint64_t lmc                          : 1;
	uint64_t spx0                         : 1;
	uint64_t spx1                         : 1;
	uint64_t pip                          : 1;
	uint64_t rint_21                      : 1;
	uint64_t asx0                         : 1;
	uint64_t asx1                         : 1;
	uint64_t rint_24                      : 1;
	uint64_t rint_25                      : 1;
	uint64_t rint_26                      : 1;
	uint64_t rint_27                      : 1;
	uint64_t rint_28                      : 1;
	uint64_t rint_29                      : 1;
	uint64_t iob                          : 1;
	uint64_t rint_31                      : 1;
	uint64_t reserved_32_63               : 32;
#endif
	} cn30xx;
	struct cvmx_npi_rsl_int_blocks_cn30xx cn31xx;
	struct cvmx_npi_rsl_int_blocks_cn38xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_32_63               : 32;
	uint64_t rint_31                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t iob                          : 1;  /**< IOB_INT_SUM */
	uint64_t rint_29                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_28                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_27                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_26                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_25                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_24                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t asx1                         : 1;  /**< ASX1_INT_REG */
	uint64_t asx0                         : 1;  /**< ASX0_INT_REG */
	uint64_t rint_21                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t pip                          : 1;  /**< PIP_INT_REG. */
	uint64_t spx1                         : 1;  /**< SPX1_INT_REG & STX1_INT_REG */
	uint64_t spx0                         : 1;  /**< SPX0_INT_REG & STX0_INT_REG */
	uint64_t lmc                          : 1;  /**< LMC_MEM_CFG0 */
	uint64_t l2c                          : 1;  /**< L2T_ERR & L2D_ERR */
	uint64_t rint_15                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_14                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t rint_13                      : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t pow                          : 1;  /**< POW_ECC_ERR */
	uint64_t tim                          : 1;  /**< TIM_REG_ERROR */
	uint64_t pko                          : 1;  /**< PKO_REG_ERROR */
	uint64_t ipd                          : 1;  /**< IPD_INT_SUM */
	uint64_t rint_8                       : 1;  /**< Set '1' when RSL bLock has an interrupt. */
	uint64_t zip                          : 1;  /**< ZIP_ERROR */
	uint64_t dfa                          : 1;  /**< DFA_ERR */
	uint64_t fpa                          : 1;  /**< FPA_INT_SUM */
	uint64_t key                          : 1;  /**< KEY_INT_SUM */
	uint64_t npi                          : 1;  /**< NPI_INT_SUM */
	uint64_t gmx1                         : 1;  /**< GMX1_RX*_INT_REG & GMX1_TX_INT_REG */
	uint64_t gmx0                         : 1;  /**< GMX0_RX*_INT_REG & GMX0_TX_INT_REG */
	uint64_t mio                          : 1;  /**< MIO_BOOT_ERR */
#else
	uint64_t mio                          : 1;
	uint64_t gmx0                         : 1;
	uint64_t gmx1                         : 1;
	uint64_t npi                          : 1;
	uint64_t key                          : 1;
	uint64_t fpa                          : 1;
	uint64_t dfa                          : 1;
	uint64_t zip                          : 1;
	uint64_t rint_8                       : 1;
	uint64_t ipd                          : 1;
	uint64_t pko                          : 1;
	uint64_t tim                          : 1;
	uint64_t pow                          : 1;
	uint64_t rint_13                      : 1;
	uint64_t rint_14                      : 1;
	uint64_t rint_15                      : 1;
	uint64_t l2c                          : 1;
	uint64_t lmc                          : 1;
	uint64_t spx0                         : 1;
	uint64_t spx1                         : 1;
	uint64_t pip                          : 1;
	uint64_t rint_21                      : 1;
	uint64_t asx0                         : 1;
	uint64_t asx1                         : 1;
	uint64_t rint_24                      : 1;
	uint64_t rint_25                      : 1;
	uint64_t rint_26                      : 1;
	uint64_t rint_27                      : 1;
	uint64_t rint_28                      : 1;
	uint64_t rint_29                      : 1;
	uint64_t iob                          : 1;
	uint64_t rint_31                      : 1;
	uint64_t reserved_32_63               : 32;
#endif
	} cn38xx;
	struct cvmx_npi_rsl_int_blocks_cn38xx cn38xxp2;
	struct cvmx_npi_rsl_int_blocks_cn50xx
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_31_63               : 33;
	uint64_t iob                          : 1;  /**< IOB_INT_SUM */
	uint64_t lmc1                         : 1;  /**< Always reads as zero */
	uint64_t agl                          : 1;  /**< Always reads as zero */
	uint64_t reserved_24_27               : 4;
	uint64_t asx1                         : 1;  /**< Always reads as zero */
	uint64_t asx0                         : 1;  /**< ASX0_INT_REG */
	uint64_t reserved_21_21               : 1;
	uint64_t pip                          : 1;  /**< PIP_INT_REG. */
	uint64_t spx1                         : 1;  /**< Always reads as zero */
	uint64_t spx0                         : 1;  /**< Always reads as zero */
	uint64_t lmc                          : 1;  /**< LMC_MEM_CFG0 */
	uint64_t l2c                          : 1;  /**< L2T_ERR & L2D_ERR */
	uint64_t reserved_15_15               : 1;
	uint64_t rad                          : 1;  /**< Always reads as zero */
	uint64_t usb                          : 1;  /**< USBN_INT_SUM */
	uint64_t pow                          : 1;  /**< POW_ECC_ERR */
	uint64_t tim                          : 1;  /**< TIM_REG_ERROR */
	uint64_t pko                          : 1;  /**< PKO_REG_ERROR */
	uint64_t ipd                          : 1;  /**< IPD_INT_SUM */
	uint64_t reserved_8_8                 : 1;
	uint64_t zip                          : 1;  /**< Always reads as zero */
	uint64_t dfa                          : 1;  /**< Always reads as zero */
	uint64_t fpa                          : 1;  /**< FPA_INT_SUM */
	uint64_t key                          : 1;  /**< Always reads as zero */
	uint64_t npi                          : 1;  /**< NPI_INT_SUM */
	uint64_t gmx1                         : 1;  /**< Always reads as zero */
	uint64_t gmx0                         : 1;  /**< GMX0_RX*_INT_REG & GMX0_TX_INT_REG */
	uint64_t mio                          : 1;  /**< MIO_BOOT_ERR */
#else
	uint64_t mio                          : 1;
	uint64_t gmx0                         : 1;
	uint64_t gmx1                         : 1;
	uint64_t npi                          : 1;
	uint64_t key                          : 1;
	uint64_t fpa                          : 1;
	uint64_t dfa                          : 1;
	uint64_t zip                          : 1;
	uint64_t reserved_8_8                 : 1;
	uint64_t ipd                          : 1;
	uint64_t pko                          : 1;
	uint64_t tim                          : 1;
	uint64_t pow                          : 1;
	uint64_t usb                          : 1;
	uint64_t rad                          : 1;
	uint64_t reserved_15_15               : 1;
	uint64_t l2c                          : 1;
	uint64_t lmc                          : 1;
	uint64_t spx0                         : 1;
	uint64_t spx1                         : 1;
	uint64_t pip                          : 1;
	uint64_t reserved_21_21               : 1;
	uint64_t asx0                         : 1;
	uint64_t asx1                         : 1;
	uint64_t reserved_24_27               : 4;
	uint64_t agl                          : 1;
	uint64_t lmc1                         : 1;
	uint64_t iob                          : 1;
	uint64_t reserved_31_63               : 33;
#endif
	} cn50xx;
	struct cvmx_npi_rsl_int_blocks_cn38xx cn58xx;
	struct cvmx_npi_rsl_int_blocks_cn38xx cn58xxp1;
};
typedef union cvmx_npi_rsl_int_blocks cvmx_npi_rsl_int_blocks_t;

/**
 * cvmx_npi_size_input#
 *
 * NPI_SIZE_INPUT0 = NPI's Size for Input 0 Register
 *
 * The size (in instructions) of Instruction Queue-0.
 */
union cvmx_npi_size_inputx
{
	uint64_t u64;
	struct cvmx_npi_size_inputx_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_32_63               : 32;
	uint64_t size                         : 32; /**< The size of the Instruction Queue used by Octane.
                                                         The value [SIZE] is in Instructions.
                                                         A value of 0 in this field is illegal. */
#else
	uint64_t size                         : 32;
	uint64_t reserved_32_63               : 32;
#endif
	} s;
	struct cvmx_npi_size_inputx_s         cn30xx;
	struct cvmx_npi_size_inputx_s         cn31xx;
	struct cvmx_npi_size_inputx_s         cn38xx;
	struct cvmx_npi_size_inputx_s         cn38xxp2;
	struct cvmx_npi_size_inputx_s         cn50xx;
	struct cvmx_npi_size_inputx_s         cn58xx;
	struct cvmx_npi_size_inputx_s         cn58xxp1;
};
typedef union cvmx_npi_size_inputx cvmx_npi_size_inputx_t;

/**
 * cvmx_npi_win_read_to
 *
 * NPI_WIN_READ_TO = NPI WINDOW READ Timeout Register
 *
 * Number of core clocks to wait before timing out on a WINDOW-READ to the NCB.
 */
union cvmx_npi_win_read_to
{
	uint64_t u64;
	struct cvmx_npi_win_read_to_s
	{
#if __BYTE_ORDER == __BIG_ENDIAN
	uint64_t reserved_32_63               : 32;
	uint64_t time                         : 32; /**< Time to wait in core clocks. A value of 0 will
                                                         cause no timeouts. */
#else
	uint64_t time                         : 32;
	uint64_t reserved_32_63               : 32;
#endif
	} s;
	struct cvmx_npi_win_read_to_s         cn30xx;
	struct cvmx_npi_win_read_to_s         cn31xx;
	struct cvmx_npi_win_read_to_s         cn38xx;
	struct cvmx_npi_win_read_to_s         cn38xxp2;
	struct cvmx_npi_win_read_to_s         cn50xx;
	struct cvmx_npi_win_read_to_s         cn58xx;
	struct cvmx_npi_win_read_to_s         cn58xxp1;
};
typedef union cvmx_npi_win_read_to cvmx_npi_win_read_to_t;

#endif
