#!/bin/sh
# $FreeBSD: stable/4/sys/i386/acpica/genwakecode.sh 119325 2003-08-22 20:49:21Z jhb $
#
echo 'static char wakecode[] = {';
hexdump -Cv acpi_wakecode.bin | \
    sed -e 's/^[0-9a-f][0-9a-f]*//' -e 's/\|.*$//' | \
    while read line
    do
	for code in ${line}
	do
	    echo -n "0x${code},";
	done
    done
echo '};'

nm -n acpi_wakecode.o | while read offset dummy what
do
    echo "#define ${what}	0x${offset}"
done

exit 0
