.ig
roff.man

Last update: 3 Apr 2003

This file is part of groff, the GNU roff type-setting system.

Copyright (C) 2000, 2001, 2002, 2003 Free Software Foundation, Inc.
written by Bernd Warken <bwarken@mayn.de>
maintained by Werner Lemberg <wl@gnu.org>

Permission is granted to copy, distribute and/or modify this document
under the terms of the GNU Free Documentation License, Version 1.1 or
any later version published by the Free Software Foundation; with the
Invariant Sections being this .ig-section and AUTHORS, with no
Front-Cover Texts, and with no Back-Cover Texts.

A copy of the Free Documentation License is included as a file called
FDL in the main directory of the groff source package.
..
.
.\" --------------------------------------------------------------------
.\" Setup
.\" --------------------------------------------------------------------
.
.mso www.tmac
.
.if n \{\
.  mso tty-char.tmac
.  ftr CR R
.  ftr CI I
.  ftr CB B
.\}
.
.if '\*[.T]'dvi' \{\
.  ftr CB CW
.\}
.
.
.\" --------------------------------------------------------------------
.\" String definitions
.
.\" Final `\""' comments are used to make Emacs happy, sic \""
.
.\" The `-' sign for options.
.ie t \{\
.  ds @- \-\"
.  ds @-- \-\-\"
.\}
.el \{\
.  ds @- -\"
.  ds @-- --\"
.\}
.
.ds Comment \.\[rs]\[dq]\"
.ds Ellipsis \.\|.\|.\&\"
.
.
.\" --------------------------------------------------------------------
.\" Begin of macro definitions
.
.de c
.\" this is like a comment request when escape mechanism is off
..
.
.eo
.
.c ---------------------------------------------------------------------
.
.de Text
.  nop \)\$*
..
.
.de CodeSkip
.  ie t \
.    sp 0.2v
.  el \
.    sp
..
.
.de Esc
.  ds @1 \$1\"
.  shift
.  Text \f[B]\[rs]\*[@1]\f[]\$*
.  rm @1
..
.
.de QuotedChar
.  ds @1 \$1
.  shift
.  nop `\f[B]\*[@1]\f[]'\$*
.  rm @1
..
.
.c --------------------------------------------------------------------
.
.c a shell command line
.de ShellCommand
.  br
.  ad l
.  nh
.  Text \f[I]sh#\h'1m'\f[]\f[CR]\$*\f[]\&\"
.  ft R
.  ft P
.  hy
.  ad
..
.
.c --------------------------------------------------------------------
.
.c ShortOpt ([c [punct]])
.c
.c `-c' somewhere in the text.
.c The second argument is some trailing punctuation.
.c
.de ShortOpt
.  ds @1 \$1\"
.  shift
.  nh
.  Text \f[CB]\*[@-]\f[]\f[B]\*[@1]\f[]\/\$*
.  hy
.  rm @1
..
.
.de TP+
.  br
.  ns
.  TP \$1
..
.
.c --------------------------------------------------------------------
.
.c Topic
.c
.de Topic
.  TP 2m
.  Text \[bu]
..
.
.ec
.\" End of macro definitions
.
.
.\" --------------------------------------------------------------------
.\" Title
.\" --------------------------------------------------------------------
.
.TH ROFF @MAN7EXT@ "@MDATE@" "Groff Version @VERSION@"
.SH NAME
roff \- concepts and history of roff typesetting
.
.
.\" --------------------------------------------------------------------
.SH DESCRIPTION
.\" --------------------------------------------------------------------
.
.I roff
is the general name for a set of type-setting programs, known under
names like
.IR troff ,
.IR nroff ,
.IR ditroff ,
.IR groff ,
etc.
.
A roff type-setting system consists of an extensible text formatting
language and a set of programs for printing and converting to other
text formats.
.
Traditionally, it is the main text processing system of Unix; every
Unix-like operating system still distributes a roff system as a core
package.
.
.P
The most common roff system today is the free software implementation
.IR "GNU roff",
.BR groff (@MAN1EXT@).
.
The pre-groff implementations are referred to as
.I classical
(dating back as long as 1973).
.
.I groff
implements the look-and-feel and functionality of its classical
ancestors, but has many extensions.
.
As
.I groff
is the only roff system that is available for every (or almost every)
computer system it is the de-facto roff standard today.
.
.P
In some ancient Unix systems, there was a binary called
.B roff
that implemented the even more ancient
.B runoff
of the
.I Multics
operating system, cf. section
.BR HISTORY .
The functionality of this program was very restricted even in
comparison to ancient troff; it is not supported any longer.
.
Consequently, in this document, the term
.I roff
always refers to the general meaning of
.IR "roff system" ,
not to the ancient roff binary.
.
.P
In spite of its age, roff is in wide use today, for example, the manual
pages on UNIX systems
.RI ( man\~pages\/ ),
many software books, system documentation, standards, and corporate
documents are written in roff.
.
The roff output for text devices is still unmatched, and its graphical
output has the same quality as other free type-setting programs and is
better than some of the commercial systems.
.
.P
The most popular application of roff is the concept of
.I manual pages
or shortly
.IR "man pages" ;
this is the standard documentation system on many operating systems.
.
.P
This document describes the historical facts around the development
of the
.IR "roff system" ;
some usage aspects common to all roff versions, details on the roff
pipeline, which is usually hidden behind front-ends like
.BR groff (@MAN1EXT@);
an general overview of the formatting language; some tips for editing
roff files; and many pointers to further readings.
.
.
.\" --------------------------------------------------------------------
.SH "HISTORY"
.\" --------------------------------------------------------------------
.
The
.I roff
text processing system has a very long history, dating back to the
1960s.
.
The roff system itself is intimately connected to the Unix operating
system, but its roots go back to the earlier operating systems CTSS
and Multics.
.
.
.\" --------------------------------------------------------------------
.SS "The Predecessor runoff"
.\" --------------------------------------------------------------------
.
.P
The evolution of
.I roff
is intimately related to the history of the operating systems.
.
Its predecessor
.B runoff
was written by
.I Jerry Saltzer
on the
.I CTSS
operating system
.RI ( "Compatible Time Sharing System" )
as early as 1961.
.
When CTSS was further developed into the operating system
.URL http://\:www.multicians.org "Multics" ,
the famous predecessor of Unix from 1963,
.I runoff
became the main format for documentation and text processing.
.
Both operating systems could only be run on very expensive computers
at that time, so they were mostly used in research and for official
and military tasks.
.
.P
The possibilities of the
.I runoff
language were quite limited as compared to modern roff.
.
Only text output was possible in the 1960s.
.
This could be implemented by a set of requests of length\~2, many of
which are still identically used in roff.
.
The language was modelled according to the habits of typesetting in
the pre-computer age, where lines starting with a dot were used in
manuscripts to denote formatting requests to the person who would
perform the typesetting manually later on.
.
.P
The runoff program was written in the
.I PL/1
language first, later on in
.IR BCPL ,
the grandmother of the
.IR C \~\c
programming language.
.
In the Multics operating system, the help system was handled by
runoff, similar to roff's task to manage the Unix manual pages.
.
There are still documents written in the runoff language; for examples
see Saltzer's home page, cf. section
.BR "SEE ALSO" .
.
.
.\" --------------------------------------------------------------------
.SS "The Classical nroff/troff System"
.\" --------------------------------------------------------------------
.
In the 1970s, the Multics off-spring
.I Unix
became more and more popular because it could be run on affordable
machines and was easily available for universities at that time.
.
At MIT (the Massachusetts Institute of Technology), there was a need to
drive the Wang
.I Graphic Systems CAT
typesetter, a graphical output device from a PDP-11 computer running
Unix.
.
As runoff was too limited for this task it was further developed into
a more powerful text formatting system by
.IR "Josef F. Osanna" ,
a main developer of the Multics operating system and programmer of
several runoff ports.
.
.P
The name
.I runoff
was shortened to
.IR roff .
The greatly enlarged language of Osanna's concept included already all
elements of a full
.IR "roff system" .
.
All modern roff systems try to implement compatibility to this system.
.
So Joe Osanna can be called the father of all roff systems.
.
.P
This first
.I roff system
had three formatter programs.
.
.TP
.B troff
.RI ( "typesetter roff\/" )
generated a graphical output for the
.I CAT
typesetter as its only device.
.
.TP
.B nroff
produced text output suitable for terminals and line printers.
.
.TP
.B roff
was the reimplementation of the former runoff program with its limited
features; this program was abandoned in later versions.
.
Today, the name
.I roff
is used to refer to a troff/\:nroff sytem as a whole.
.
.P
Osanna first version was written in the PDP-11 assembly language and
released in 1973.
.
.I Brian Kernighan
joined the
.I roff
development by rewriting it in the C\~programming language.
.
The C\~version was released in 1975.
.
.P
The syntax of the formatting language of the
.BR nroff / troff
programs was documented in the famous
.IR "Troff User's Manual [CSTR\~#54]" ,
first published in 1976, with further revisions up to 1992 by Brian
Kernighan.
.
This document is the specification of the
.IR "classical troff" .
All later
.I roff
systems tried to establish compatibility with this specification.
.
.P
After Osanna had died in 1977 by a heart-attack at the age of about\~50,
Kernighan went on with developing troff.
.
The next milestone was to equip troff with a general interface to
support more devices, the intermediate output format and the
postprocessor system.
.
This completed the structure of a
.I "roff system"
as it is still in use today; see section
.BR "USING ROFF" .
.
In 1979, these novelties were described in the paper
.IR "[CSTR\~#97]" .
This new troff version is the basis for all existing newer troff
systems, including
.IR groff .
.
On some systems, this
.I device independent troff
got a binary of its own, called
.BR ditroff (@MAN7EXT@).
.
All modern
.B troff
programs already provide the full ditroff capabilities automatically.
.
.
.\" --------------------------------------------------------------------
.SS "Commercialization"
.\" --------------------------------------------------------------------
.
A major degradation occurred when the easily available Unix\~7
operating system was commercialized.
.
A whole bunch of divergent operating systems emerged, fighting each
other with incompatibilities in their extensions.
.
Luckily, the incompatibilities did not fight the original troff.
.
All of the different commercial roff systems made heavy use of
Osanna/\:Kernighan's open source code and documentation, but sold them
as \[lq]their\[rq] system \[em] with only minor additions.
.
.P
The source code of both the ancient Unix and classical troff weren't
available for two decades.
.
Fortunately, Caldera bought SCO UNIX in 2001.
.
In the following, Caldera made the ancient source code accessible
on-line for non-commercial use, cf. section
.BR "SEE ALSO" .
.
.
.\" --------------------------------------------------------------------
.SS "Free roff"
.\" --------------------------------------------------------------------
.
None of the commercial roff systems could attain the status of a
successor for the general roff development.
.
Everyone was only interested in their own stuff.
.
This led to a steep downfall of the once excellent
Unix operating system during the 1980s.
.
.P
As a counter-measure to the galopping commercialization, AT&T Bell
Labs tried to launch a rescue project with their
.I Plan\~9
operating system.
.
It is freely available for non-commercial use, even the source code,
but has a proprietary license that empedes the free development.
.
This concept is outdated, so Plan\~9 was not accepted as a platform to
bundle the main-stream development.
.
.P
The only remedy came from the emerging free operatings systems
(386BSD, GNU/\:Linux, etc.) and software projects during the 1980s and
1990s.
.
These implemented the ancient Unix features and many extensions, such
that the old experience is not lost.
.
In the 21st century, Unix-like systems are again a major factor in
computer industry \[em] thanks to free software.
.
.P
The most important free roff project was the GNU port of troff,
created by James Clark and put under the
.URL http://\:www.gnu.org/\:copyleft "GNU Public License" .
.
It was called
.I groff
.RI ( "GNU roff" ).
See
.BR groff (@MAN1EXT@)
for an overview.
.
.P
The groff system is still actively developed.
.
It is compatible to the classical troff, but many extensions were
added.
.
It is the first roff system that is available on almost all operating
systems \[em] and it is free.
.
This makes groff the de-facto roff standard today.
.
.
.\" --------------------------------------------------------------------
.SH "USING ROFF"
.\" --------------------------------------------------------------------
.
Most people won't even notice that they are actually using roff.
.
When you read a system manual page (man page) roff is working in the
background.
.
Roff documents can be viewed with a native viewer called
.BR xditview (1x),
a standard program of the X window distribution, see
.BR X (7x).
.
But using roff explicitly isn't difficult either.
.
.P
Some roff implementations provide wrapper programs that make it easy
to use the roff system on the shell command line.
.
For example, the GNU roff implementation
.BR groff (@MAN1EXT@)
provides command line options to avoid the long command pipes of
classical troff; a program
.BR grog (@MAN1EXT@)
tries to guess from the document which arguments should be used for a
run of groff; people who do not like specifying command line options
should try the
.BR groffer (@MAN1EXT@)
program for graphically displaying groff files and man pages.
.
.
.\" --------------------------------------------------------------------
.SS "The roff Pipe"
.\" --------------------------------------------------------------------
.
Each roff system consists of preprocessors, roff formatter programs,
and a set of device postprocessors.
.
This concept makes heavy use of the
.I piping
mechanism, that is, a series of programs is called one after the other,
where the output of each program in the queue is taken as the input
for the next program.
.
.CodeSkip
.
.ds @1 "cat \f[I]file\f[P] |\""
.ds @2 "\*[Ellipsis] | \f[I]preproc\f[P] | \*[Ellipsis] |\""
.ds @3 "troff \f[I]options\f[P] | \f[I]postproc\f[P]\""
.
.ShellCommand "\*[@1] \*[@2] \*[@3]"
.
.rm @1
.rm @2
.rm @3
.P
The preprocessors generate roff code that is fed into a roff formatter
(e.g. troff), which in turn generates
.I intermediate output
that is fed into a device postprocessor program for printing or final
output.
.
.P
All of these parts use programming languages of their own; each
language is totally unrelated to the other parts.
.
Moreover, roff macro packages that were tailored for special purposes
can be included.
.
.P
Most roff documents use the macros of some package, intermixed with
code for one or more preprocessors, spiced with some elements from the
plain roff language.
.
The full power of the roff formatting language is seldom needed by
users; only programmers of macro packages need to know about the gory
details.
.
.
.
.\" --------------------------------------------------------------------
.SS "Preprocessors"
.\" --------------------------------------------------------------------
.
A roff preprocessor is any program that generates output that
syntactically obeys the rules of the roff formatting language.
.
Each preprocessor defines a language of its own that is translated
into roff code when run through the preprocessor program.
.
Parts written in these languages may be included within a roff
document; they are identified by special roff requests or macros.
.
Each document that is enhanced by preprocessor code must be run
through all corresponding preprocessors before it is fed into the
actual roff formatter program, for the formatter just ignores all
alien code.
.
The preprocessor programs extract and transform only the document
parts that are determined for them.
.
.P
There are a lot of free and commercial roff preprocessors.
.
Some of them aren't available on each system, but there is a small
set of preprocessors that are considered as an integral part of each
roff system.
.
The classical preprocessors are
.

.de @TP
.\" local indent for .TP
.TP \\w'\\f[B]soelim\\f[P]'u+2n
..
.P
.RS
.PD 0
.@TP
.B tbl
for tables
.@TP
.B eqn
for mathematical formul\[ae]
.@TP
.B pic
for drawing diagrams
.@TP
.B refer
for bibliographic references
.@TP
.B soelim
for including macro files from standard locations
.PD
.RE
.
.P
Other known preprocessors that are not available on all systems
include
.
.P
.RS
.PD 0
.@TP
.B chem
for drawing chemical formul\[ae].
.@TP
.B grap
for constructing graphical elements.
.@TP
.B grn
for including
.BR gremlin (1)
pictures.
.PD
.RE
.
.rm @TP
.
.\" --------------------------------------------------------------------
.SS "Formatter Programs"
.\" --------------------------------------------------------------------
.
A
.I roff formatter
is a program that parses documents written in the roff formatting
language or uses some of the roff macro packages.
.
It generates
.IR "intermediate output" ,
which is intended to be fed into a single device postprocessor that
must be specified by a command-line option to the formatter program.
.
The documents must have been run through all necessary preprocessors
before.
.
.P
The output produced by a roff formatter is represented in yet another
language, the
.IR "intermediate output format"
or
.IR "troff output" .
This language was first specified in
.IR "[CSTR\~#97]" ;
its GNU extension is documented in
.BR groff_out (@MAN5EXT@).
.
The intermediate output language is a kind of assembly language
compared to the high-level roff language.
.
The generated intermediate output is optimized for a special device,
but the language is the same for every device.
.
.P
The roff formatter is the heart of the roff system.
.
The traditional roff had two formatters,
.B nroff
for text devices and
.B troff
for graphical devices.
.
.P
Often, the name
.I troff
is used as a general term to refer to both formatters.
.
.
.\" --------------------------------------------------------------------
.SS "Devices and Postprocessors"
.\" --------------------------------------------------------------------
.
Devices are hardware interfaces like printers, text or graphical
terminals, etc., or software interfaces such as a conversion into a
different text or graphical format.
.
.P
A roff postprocessor is a program that transforms troff output into a
form suitable for a special device.
.
The roff postprocessors are like device drivers for the output target.
.
.P
For each device there is a postprocessor program that fits the device
optimally.
.
The postprocessor parses the generated intermediate output and
generates device-specific code that is sent directly to the device.
.
.P
The names of the devices and the postprocessor programs are not fixed
because they greatly depend on the software and hardware abilities of
the actual computer.
.
For example, the classical devices mentioned in
.I [CSTR\~#54]
have greatly changed since the classical times.
.
The old hardware doesn't exist any longer and the old graphical
conversions were quite imprecise when compared to their modern
counterparts.
.
.P
For example, the Postscript device
.I post
in classical troff had a resolution
of 720, while groff's
.I ps
device has 72000, a refinement of factor 100.
.
.P
Today the operating systems provide device drivers for most
printer-like hardware, so it isn't necessary to write a special
hardware postprocessor for each printer.
.
.
.\" --------------------------------------------------------------------
.SH "ROFF PROGRAMMING"
.\" --------------------------------------------------------------------
.
Documents using roff are normal text files decorated by roff
formatting elements.
.
The roff formatting language is quite powerful; it is almost a full
programming language and provides elements to enlarge the language.
.
With these, it became possible to develop macro packages that are
tailored for special applications.
.
Such macro packages are much handier than plain roff.
.
So most people will choose a macro package without worrying about the
internals of the roff language.
.
.
.\" --------------------------------------------------------------------
.SS "Macro Packages"
.\" --------------------------------------------------------------------
.
Macro packages are collections of macros that are suitable to format a
special kind of documents in a convenient way.
.
This greatly eases the usage of roff.
.
The macro definitions of a package are kept in a file called
.IB name .tmac
(classically
.BI tmac. name\c
).
.
All tmac files are stored in one or more directories at standardized
positions.
.
Details on the naming of macro packages and their placement is found
in
.BR groff_tmac (@MAN5EXT@).
.
.P
A macro package that is to be used in a document can be announced to
the formatter by the command line option
.ShortOpt m ,
see
.BR troff (@MAN1EXT@),
or it can be specified within a document using the file inclusion
requests of the roff language, see
.BR groff (@MAN7EXT@).
.
.P
Famous classical macro packages are
.I man
for traditional man pages,
.I mdoc
for BSD-style manual pages;
the macro sets for books, articles, and letters are
.I me
(probably from the first name of its creator
.I Eric
Allman),
.I ms
(from
.IR "Manuscript Macros\/" ),
and
.I mm
(from
.IR "Memorandum Macros\/" ).
.
.
.\" --------------------------------------------------------------------
.SS "The roff Formatting Language"
.\" --------------------------------------------------------------------
.
The classical roff formatting language is documented in the
.I Troff User's Manual
.IR "[CSTR\~#54]" .
.
The roff language is a full programming language providing requests,
definition of macros, escape sequences, string variables, number or
size registers, and flow controls.
.
.P
.I Requests
are the predefined basic formatting commands similar to the commands
at the shell prompt.
.
The user can define request-like elements using predefined roff
elements.
.
These are then called
.IR macros .
.
A document writer will not note any difference in usage for requests
or macros; both are written on a line on their own starting with a dot.
.
.P
.I Escape sequences
are roff elements starting with a backslash
.QuotedChar \[rs] .
They can be inserted anywhere, also in the midst of text in a line.
.
They are used to implement various features, including the insertion of
non-ASCII characters with
.Esc ( ,
font changes with
.Esc f ,
in-line comments with
.Esc \[dq] ,
the escaping of special control characters like
.Esc \[rs] ,
and many other features.
.
.P
.I Strings
are variables that can store a string.
.
A string is stored by the
.B .ds
request.
.
The stored string can be retrieved later by the
.B \[rs]*
escape sequence.
.
.P
.I Registers
store numbers and sizes.
.
A register can be set with the request
.B .nr
and its value can be retrieved by the escape sequence
.BR "\[rs]n" .
.
.
.\" --------------------------------------------------------------------
.SH "FILE NAME EXTENSIONS"
.\" --------------------------------------------------------------------
.
Manual pages (man pages) take the section number as a file name
extension, e.g., the filename for this document is
.IR roff.7 ,
i.e., it is kept in section\~7
of the man pages.
.
.P
The classical macro packages take the package name as an extension, e.g.
.IB file. me
for a document using the
.I me
macro package,
.IB file. mm
for
.IR mm ,
.IB file. ms
for
.IR ms ,
.IB file. pic
for
.I pic
files,
etc.
.
.P
But there is no general naming scheme for roff documents, though
.IB file. tr
for
.I troff file
is seen now and then.
.
Maybe there should be a standardization for the filename extensions of
roff files.
.
.P
File name extensions can be very handy in conjunction with the
.BR less (1)
pager.
.
It provides the possibility to feed all input into a command-line pipe
that is specified in the shell environment variable
.BR LESSOPEN .
This process is not well documented, so here an example:
.
.CodeSkip
.ShellCommand LESSOPEN='|lesspipe %s'
.CodeSkip
.
where
.B lesspipe
is either a system supplied command or a shell script of your own.
.
.
.\" --------------------------------------------------------------------
.SH "EDITING ROFF"
.\" --------------------------------------------------------------------
.
The best program for editing a roff document is Emacs (or Xemacs), see
.BR emacs (1).
It provides an
.I nroff
mode that is suitable for all kinds of roff dialects.
.
This mode can be activated by the following methods.
.
.P
When editing a file within Emacs the mode can be changed by typing
.RI ` "M-x nroff-mode" ',
where
.B M-x
means to hold down the
.B Meta
key (or
.BR Alt )
and hitting the
.BR x\~ key
at the same time.
.
.P
But it is also possible to have the mode automatically selected when
the file is loaded into the editor.
.
.Topic
The most general method is to include the following 3 comment lines at
the end of the file.
.
.CodeSkip
.nf
.B \*[Comment] Local Variables:
.B \*[Comment] mode: nroff
.B \*[Comment] End:
.fi
.
.Topic
There is a set of file name extensions, e.g. the man pages that
trigger the automatic activation of the nroff mode.
.
.Topic
Theoretically, it is possible to write the sequence
.CodeSkip
.B \*[Comment] \%-*-\ nroff\ -*-
.CodeSkip
as the first line of a file to have it started in nroff mode when
loaded.
.
Unfortunately, some applications such as the
.B man
program are confused by this; so this is deprecated.
.
.P
All roff formatters provide automated line breaks and horizontal and
vertical spacing.
.
In order to not disturb this, the following tips can be helpful.
.
.Topic
Never include empty or blank lines in a roff document.
.
Instead, use the empty request (a line consisting of a dot only) or a
line comment
.B \*[Comment]
if a structuring element is needed.
.
.Topic
Never start a line with whitespace because this can lead to
unexpected behavior.
.
Indented paragraphs can be constructed in a controlled way by roff
requests.
.
.Topic
Start each sentence on a line of its own, for the spacing after a dot
is handled differently depending on whether it terminates an
abbreviation or a sentence.
.
To distinguish both cases, do a line break after each sentence.
.
.Topic
To additionally use the auto-fill mode in Emacs, it is best to insert
an empty roff request (a line consisting of a dot only) after each
sentence.
.
.P
The following example shows how optimal roff editing could look.
.
.IP
.nf
This is an example for a roff document.
.Text .
This is the next sentence in the same paragraph.
.Text .
This is a longer sentence stretching over several
lines; abbreviations like `cf.' are easily
identified because the dot is not followed by a
line break.
.Text .
In the output, this will still go to the same
paragraph.
.fi
.
.P
Besides Emacs, some other editors provide nroff style files too, e.g.\&
.BR vim (1),
an extension of the
.BR vi (1)
program.
.
.
.\" --------------------------------------------------------------------
.SH BUGS
.\" --------------------------------------------------------------------
.
.I UNIX\[rg]
is a registered trademark of the Open Group.
.
But things have improved considerably after Caldera had bought SCO
UNIX in 2001.
.
.
.\" --------------------------------------------------------------------
.SH "SEE ALSO"
.\" --------------------------------------------------------------------
.
There is a lot of documentation on roff.
.
The original papers on classical troff are still available, and all
aspects of groff are documented in great detail.
.
.
.\" --------------------------------------------------------------------
.SS "Internet sites"
.\" --------------------------------------------------------------------
.
.TP
troff.org
.URL http://\:www.troff.org "The historical troff site"
provides an overview and pointers to all historical aspects of roff.
.
.TP
Multics
.URL http://\:www.multicians.org "The Multics site"
contains a lot of information on the MIT projects, CTSS, Multics,
early Unix, including
.IR  runoff ;
especially useful are a glossary and the many links to ancient
documents.
.
.TP
Unix Archive
.URL http://\:www.tuhs.org/\:Archive/ \
     "The Ancient Unixes Archive"
.
provides the source code and some binaries of the ancient Unixes
(including the source code of troff and its documentation) that were
made public by Caldera since 2001, e.g. of the famous Unix version\~7
for PDP-11 at the
.URL http://\:www.tuhs.org/\:Archive/\:PDP-11/\:Trees/\:V7 \
     "Unix V7 site" .
.
.TP
Developers at AT&T Bell Labs
.URL http://\:cm.bell-labs.com/\:cm/\:index.html \
     "Bell Labs Computing and Mathematical Sciences Research"
.
provides a search facility for tracking information on the early
developers.
.
.TP
Plan 9
.URL http://\:plan9.bell-labs.com "The Plan\~9 operating system"
.
by AT&T Bell Labs.
.
.TP
runoff
.URL http://web.mit.edu/\:Saltzer/\:www/\:publications/\:pubs.html \
"Jerry Saltzer's home page"
.
stores some documents using the ancient runoff formatting language.
.
.TP
CSTR Papers
.URL http://\:cm.bell-labs.com/\:cm/\:cs/\:cstr.html \
     "The Bell Labs CSTR site"
.
stores the original troff manuals (CSTR #54, #97, #114, #116, #122)
and famous historical documents on programming.
.
.TP
GNU roff
.URL http://\:www.gnu.org/\:software/\:groff "The groff web site"
provides the free roff implementation groff, the actual standard roff.
.
.
.\" --------------------------------------------------------------------
.SS "Historical roff Documentation"
.\" --------------------------------------------------------------------
.
Many classical
.troff
documents are still available on-line.
.
The two main manuals of the troff language are
.
.TP
[CSTR\~#54]
J. F. Osanna,
.URL http://\:cm.bell-labs.com/\:cm/\:cs/\:54.ps \
     "\fINroff/\:Troff User's Manual\fP" ;
.
Bell Labs, 1976; revised by Brian Kernighan, 1992.

.
.TP
[CSTR\~#97]
Brian Kernighan,
.URL http://\:cm.bell-labs.com/\:cm/\:cs/\:97.ps \
     "\fIA Typesetter-independent TROFF\fP" ,
.
Bell Labs, 1981, revised March 1982.
.
.P
The "little language" roff papers are
.
.TP
[CSTR\~#114]
Jon L. Bentley and Brian W. Kernighan,
.URL http://\:cm.bell-labs.com/\:cm/\:cs/\:114.ps \
     "\fIGRAP \(em A Language for Typesetting Graphs\fP" ;
.
Bell Labs, August 1984.
.
.TP
[CSTR\~#116]
Brian W. Kernighan,
.URL http://\:cm.bell-labs.com/\:cm/\:cs/\:116.ps \
     "\fIPIC -- A Graphics Language for Typesetting\fP" ;
.
Bell Labs, December 1984.
.
.TP
[CSTR\~#122]
J. L. Bentley, L. W. Jelinski, and B. W. Kernighan,
.URL http://\:cm.bell-labs.com/\:cm/\:cs/\:122.ps \
"\fICHEM \(em A Program for Typesetting Chemical Structure Diagrams, \
Computers and Chemistry\fP" ;
.
Bell Labs, April 1986.
.
.
.\" --------------------------------------------------------------------
.SS "Manual Pages"
.\" --------------------------------------------------------------------
.
Due to its complex structure, a full roff system has many man pages,
each describing a single aspect of roff.
.
Unfortunately, there is no general naming scheme for the
documentation among the different roff implementations.
.
.P
In
.IR groff ,
the man page
.BR groff (@MAN1EXT@)
contains a survey of all documentation available in groff.
.
.P
On other systems, you are on your own, but
.BR troff (1)
might be a good starting point.
.
.
.\" --------------------------------------------------------------------
.SH AUTHORS
.\" --------------------------------------------------------------------
.
Copyright (C) 2000, 2001, 2002 Free Software Foundation, Inc.
.
.P
This document is distributed under the terms of the FDL (GNU Free
Documentation License) version 1.1 or later.
.
You should have received a copy of the FDL on your system, it is also
available on-line at the
.URL http://\:www.gnu.org/\:copyleft/\:fdl.html "GNU copyleft site" .
.
.P
This document is part of
.IR groff ,
the GNU roff distribution.
.
It was written by
.MTO bwarken@mayn.de "Bernd Warken" ;
it is maintained by
.MTO wl@gnu.org "Werner Lemberg".
.
.
.\" --------------------------------------------------------------------
.\" Emacs setup
.\" --------------------------------------------------------------------
.
.\" Local Variables:
.\" mode: nroff
.\" End:
