/* $FreeBSD: stable/11/tests/sys/geom/class/eli/testvect.h 327856 2018-01-12 00:31:07Z asomers $ */
/* Test Vectors for PBKDF2-SHA512 */
	/* salt, saltlen, passwd, itr, hmacout, hmacoutlen */
	{ "\331}\035\215\000\272\350\261", 8, "\323\303\210\231\260\225\217\035", 100, "J\257\275\352n\371\300!tp\367\257\347c'\000\243F\246\376\274H\263\312m\336\304\3515P\222Cb\037-\313W\0067\232\024%\235\252\322\035\225k\025\2248\251r\312]v\316\021j\231\224\2556\350", 64 },
	{ "\321\213\277\330\210E\207x", 8, "(C\371\344\354\356\232\212\346\014\335M(\234g\226", 100, "\035MoB\245\001\000\315\332\235\356?alD\231I[%A\372\367\027\267,\303\022\324\004\302a\302t\257\306S\251\250;-pa\246Z\200\003*+\026\305_\250\214n\321\340.\032a3\371\346\025\042", 64 },
	{ "\344\353\215\257\020\315\245\367", 8, "/pj@N\344\271\243^\352\236gu\352\344os\366FR\362\001\347\301", 100, "\223eS:\015\311\023\317\230O\012\347\014\32070\321\337p\353\305\361\223\323\333&\011'\360?\022\374P\336\337\031\266,~@!\037\000\320v\360!\225\221@C\266|k\370@\305\202\235+\314\247\305&", 64 },
	{ "\364\275\222\376\0064\240g", 8, "_\2000 A\233#\372\351\332\247\010\313\274\334\255\362J\356\333\302\345\317\305*\357 \366Aj\344\346", 100, "\223\015X\340\024\244\2767\027\253\261\232\360(?\350H7\326K\322\246\341\222\202:@\254\3218\016T\275\212^\005\344\202\230\220s\311\201\025\233~K6\241*b\244\203\273\355\270\277\242\300V3\037\224\311", 64 },
	{ "\272\207\326\030\010\374\263f", 8, "\323\230\233\317\337\001\241]G\312\347\320K\3374\247\016\343\246\353\300\373\267\335\314h\216\245$\373\210\214\014b\340\377\256\0202E", 100, "a\274S.\032\246\330\321\322\207\004\241n\303\363\361\361\215\367Xi\250\275\246\037\355\255\342\004\253\250\243&\032\357\250\204\207K\2612\0318\3353\253\335Z\351\337\253v\345\322r\030\0066\230jp\345\373\203", 64 },
	{ "j\276\230\215\031$\326v", 8, "gy\264\354\363\322(w\262\272\203\306{\356\031\376\277+\276L\337\270G\345!>29\010\204m\240!\326\255\326\321\272(\325T\033B\262[\267]\272", 100, "\2563\024\201\310\372\017\373\270\232\277\265:j\231\365\032zS\3723\012\341i\302V\233l\247\030:\355\262]\337\361JUe:\350|#D\262\335)\260\333\273\221\252\005\226\322'\371+a\270a\302\276p", 64 },
	{ ",;\270P\012\035\262\235", 8, "\375 \232J\304\271_\272\033\027\363\021\227\260\323\310\304k\004.\327\354\217,\357\353]I0\332We\245\257\371,\260\360\325\224\026q[VuS\217\004\262\376T\353\262\321\241\024", 100, "\313\246&~\374Zq(0\000\002\332\356\355M\353Z?\310~\234\327\011\242\370\032GK\250\020\203sJ\234I,\271\012\230\204g\323\345\343\343\350\231\227\015\350b\256\012\367Q\255v\365\210\247\2614\210\365", 64 },
	{ "\021\325\267u\203$\352\274", 8, "\232\032\225'\021*'a\042\023{\250\361r\262\365\370\032\347\336\363Re28\033J\3763^\311I\322:\036\204\320\033\245\200\262\225\341\377\334\241p\314\334\005O,\374\225\234\014\266\365\030i6\210a\205", 100, "\220\006\216\2420-8m\2766\353(6\212\306\261C@\252\2104\005\205\274\204\365\226\373\016\345\332\207\361A\244\023W\3051:\277\2705Z\253\262\371M\024L\215\224\340p\336\355\250\030*8\300\017\254f", 64 },
	{ "[\353e\224\2423\270m", 8, "\1776\374\302o0\007\307w\032\307\266\376\320\042/\266\352\233\224\316\3616\314!`\015d\316\370L{\201B\245\317\366@V\036\227\273I\205\251\306GW\200*\340P\267\202#\354\330\266O\347\254(\203\270\366w\274\375\272\016\240\313", 100, "?j\005\340=\022\012NM\024\231\220_u\023@\042\214\014b\375\251\023\244y3m\330\377\341\271~V0\263\223\274\325Rmug\026Dt!\347%\270\244\371@\177\350\250N\320\246\034\320\013|\276\027", 64 },
	{ "\262\304(\244\326\272\262\311", 8, "\210C(\273\376\013/\034", 200, "6+\233\201\350\374\2053\013\377SA\007\037\303\027RyrC\361\303\321\031\225d\215\314\213\210\006\031\217\035L)\377'\016\263\310\206\326\372\362\230\226.F\134\277\367\35357(\214\262\036\310@\363#\020", 64 },
	{ "\246<\216\226^F\004\036", 8, "\344].\210\212\236\252f\256n\006\250\2615\325\371", 200, "\213J\234\270\227$St\265\035\323\001&\025\027T>\015F\205\325\361_\003l\245|\213S\232@\254o\227\235l$\355\037\214\220\032\213\320\265lM\334\320\313+\205.\355\310\201K\370^\025\134\346[K", 64 },
	{ "9s72\020\270\251\350", 8, "\323\370:k\323o\271Y\335\306\375#\333\222\246?C\313\023\202>\005\025\216", 200, "\371\373\341\202(\231\010\325_\335\205\253\216\371\227\354\352Os2\356e\033L\236znr;\337a'\025\335n\032f\304\177u\001n{\236`\261\346N\2748R\017\243\226[\256@<\021m\202r\363g", 64 },
	{ "\032\216\254\215\022l\001H", 8, "\027J\232\302\240lTSU\215y\262\360\017\346\3253\276r\276\211\306>\3740\263\264\002\333J;\262", 200, "\3206K,\267r<\302r\207y\373\3625]2Y\3710\343\272\211\202\3465g\340jG\001`\341\352\313\203\250x\221K\254iV\350w\2220\257Yc\360Z\263\237\255\042\325\341\307\330\232s@?\210", 64 },
	{ "D\302g\023\316\224l\271", 8, "\262t\301{\366\345Bv\271!\213\303\244O8\314\336\363\325|\206x\034d$#\001<Z\233\272\014J=\2079?\134\015(", 200, "\334\222G\300~'\042LS\0218\006,\261\207]\277\245GH\007\246\357f\205\325-\3044\337\347\007\373\304\261\317\212\224\276pl\302?\271\321\010\375Q\202\236M\3105\251\310\234\032g~\301_\007\244R", 64 },
	{ "\316@&\224\241\245\211{", 8, "\276\217\365\352O\212\377\257\177\350f\276\330\3035\204\215\327f\256\300\364\212\271\306q\242?-\307\324\317y^\201t\272\371\331M;c\210\202\201\221\363\030", 200, "\340\001\331YS\230\231|\356\024D8\243f\223\335\207\361\2241=\264\0366\030\230Z0\340\226K\352\241C\355\260\236b\1346\035\030\3059\022\335n#\311\025\351L\334\001\366\003\042\302\265\275\347\134]\204", 64 },
	{ "\234^\035\320rt-B", 8, "\357\274\204\366N9\273:\216\331,D\300t\320\361\324F\313\220E\250u\203\307\003\221\365X\303O\230\312~\342\336\007R\232\244M\305U\320\367\272\367\366?\267c\253\354\301\221X", 200, "\017m\031\004\022\364(\016\310U\3621\301\316}k\362\306\227:\233+\000\230\334:,\005\307q\204\332L[\236\223\225\204y\037\037\262o\257]\012\365t\036\351(>x9\012\241\256W\241\334\307\240\207F", 64 },
	{ "\037\346\010\241]\004x\204", 8, "T\334\371\316I\33656Q\027\277\203\033\303\240\371\231\352\214\3701@\002\015?2\264\002\257R\205\250\264}\021\012\326\366wF\311\267\271\0042C:/\341\031\242\337\237.\021V\034\263`W\306Y\3533", 200, "V\370Nt\341W\226|\367\226\200\033|\006Kii\263\304\307\347\301#L\371\335l|O\304\300v\361d\255h^\322\026\332U\224\270\255\227\022\226G\326\363\303\244\234\235\016/<\331\247\307\242\355\226\307", 64 },
	{ "\364\303X\325\327\256\342f", 8, "\227E\237\320\214GB\332\005\0333\250=\020c(\345\007?\032)\2643\243\202\371\200\030\002\225\011/\030\030\003Q\354\344\361B\214\333.\015\336`\376.\360\243$\017\367K\207\212\347L\356S\230\346\034*\307\207\203\233a\310\370\255", 200, "L(\217#(\300jA\343\037\251rR\312G\024\016dj:\212|\024\373\275\134\375\374\247\266FpF\275:\373_\314\134\244\016\373\203k\265\225\243\212t\240\310\347\226\262%\233\213\332w\042WL\302\331", 64 },
	{ "c\027\266\220\010\031\241\313", 8, "F#\323\2367\260\323\273", 300, "@\200\033\254\020\246\206L$\203\026.T\223\205\364\362@\204*\316\232u\033\321\212;l\202\313s\205\333<1~\211\267\213\336Z\276\233W\322\366!\3629l\343@O\216+[!\262I\350\262\312\022\357", 64 },
	{ "\001\277`\003x\301n\313", 8, "\257'\372i.M$\356\230\032\252yq\302\004c", 300, "?\037\327=m\335R\367?\242q\002\023V\203\017q8\252\325?6\213\241\274\275\356\344*\312/p~.<\305\346]\377\242\361\025\311\375\303\247\305\345@U\230\364F\275\211n\250Ay\352\026+\253V", 64 },
	{ "\203\020{)\016R\324\350", 8, "\261\200\031:\346l\242u\352\300\014_\320\221y\213e\214\352\042c\371\257\361", 300, "\001\2111R\305R'b.L\007$\042\267\346\304(|+2\240\260\021\042\243J\344\237\006\236\203A\032\363\356\251\015.\321\336\03431X\002\355\221\313]\264\310\315o\316aw\246|\312bT:\325\300", 64 },
	{ "\002X\311\253\033h\036'", 8, "P\206\257!\305E\377\275\310\005\364Bn\005\342>!w\017@}\245\350\177\305\312\323\361,\301y\022", 300, "\360\301\033\007\367,\374\242\177\3153D\251*_>{\005\272NQ\021\024:0\036\357\333c\254/\001\035\202\341\330\005\0245\265b}\261\232\273\0318\225\227\252\210\361\300\016\357\323\204\202\246\376\277@\225w", 64 },
	{ ">+\207\003k\311\225\276", 8, "((\260Eak\253\305\3243Q\332*N\276\323\325_48\317\264&\340\005\323N\224p\003\331Fl\215\317 w\034u?", 300, "\276\317.\310Gj \217\3502.za\021\230\322C6\255\301\354-\263\247\002\352\377\267]\243\201n\245\213D\240\010D|\324\336\251\326\342e\231\350*\300\315\007\234\236\002}\372\013\364\257\232\262:\207e", 64 },
	{ "\265G\357\330S\302?8", 8, "7S-\203\036\340\015\356\027\253\302\376\222\037\2276\0141|p\255\313\325\211\206\265\230\333\027\343\231\007\335\366\356\011 $ \312`\333y\267K4\317\277", 300, "\004\264\241\262\204\361YL%#v\373\013@E/\335\353 l\365\242u\215\301p\360O\030{\0236\033\206$\340\263\202bC\032\014\252\365\323\325\350u\210\234\020\037\015\275\000{h\363a\244\024\177\356\236", 64 },
	{ "I\257\321\376\365\317\267I", 8, "\200!XxW\233B\374,\362\027,\343\022\204\220\373\231=\376\343\362\246\224 \001\233\015\0338\337\224#%\320\037\342\276\314X{h\036\210w\377\011@=\021\034\3429!\211\350", 300, "`\277s c\215t\251,\306:L\267`u%D\244\021\340\036C\304\032\014u\042\134Mzo\313\225\3641\017\037\271q*\321\023\227\253\215\330\351\373\202\220\274`P\267\277\373\007\366\370\031\350\015\214\245", 64 },
	{ "\324\366\347;\363R\300!", 8, "y\262~C\031\252 \004\215a\033\355l9\024C\237b/\032Kk\316q\257K\017\017\036\316\003\246\005\225(\0168\264\032pT\030\250\334\341\020\012X K\325\002\254mh\265\134N*?\233\007Zn", 300, "\202\252\261h$8%\335rv\260\0005\313Lj\244\262\342\202\352\277\005 \2418\2740Y\333\036\014[\015\030'O\351\377|D\0114O\344\203\177\360\337\3610\315\323\2528\247\307\3535R\366)\033\236", 64 },
	{ "\301\357\263\261\347O\344,", 8, "\216\376\312\271K}\224Pt\022\2572\230lR\177\340m\224\271\305\237Z\374\252\204\313M\307&\330]^W[\001\317\207\264\305\017\224\331\245\361\301Z\371r\264\223\202\201\353\252k\223Bk\361\323c\307\255(\010:x%\257\3352", 300, "\312\240!.\3606\236]\235\315\2409\042?\027\015\271\030\352l>\272s\345\340\231\317\263\306W6[\342\360\307\305 !\357\003|g][\275j=ptx\344\265\271~\036_\361\004\246\261\313\241D)", 64 },
	{ "\257\000;+\233Q\214b", 8, "eoq{\270\246ua", 400, "\251B\370\245m\000>\134\007\256\373\001\251\262,\310\367\376\323\334{K\202\177\235\376x\365D(+\367\361\373\031\376\254H\243\305/N\267\205\2108\301*\025@\030\311\012.\261\237\377\015\205h\261\042\372\034", 64 },
	{ "hU\325\246:obb", 8, "?/\352\332\327c\027\331\305N'\321\355\337\316\241", 400, "\177\312\2275\203 \026aNXF\010\377\336=\240\025\312\252r\01363\234\351\2754[y7E\334CQ\371\243F\010l\2545\253\214\341\323\300u\202\225\236\250\356\007Q\000Q\302\207M@g\350m:", 64 },
	{ "p(\256-\313\020{\300", 8, "\334\310\227\225J\356\360\307!\353\023\332|\214\306\036\026\253|-\267\341\321\223", 400, "\267\250\271J-\265\303\247\337ib\237l>\352\344\302\3321\3006\240\233\232N\2661\236\022s+\300\1342\375%\251Yl\032kK}\227T`\364\233v0|/\217\026\032\261\020\225\335k@`\021\227", 64 },
	{ ",\032\034\337\304,\340\334", 8, "\011F\350\213N\0058\212}N\267\007\007E\276\203C\315\332\013\030`\372\030\370\001\240\030\354@9\327", 400, "\206A\034\355\042\030\025\220\000\251\025`\356\372Fr\313\246L\307\255@;\366\354\346\362\206h\023>A\271\273r\036\224\325Q\246\2527 ^\014!\240:|\335G\322\333\032\005ok~\371\372\255oD\257", 64 },
	{ "H\322\305\000\020\341\365\243", 8, "\330\313R\037\276\004\355\327\363QH\327\364r\305}\014\370\007B\252xS\345\003\346\202\366\250\375\237\315 \205\355\214Rj\037\365", 400, "u\346\0049k\347\134\211\023\330\015\360o`\217\266\234\012\007\003\270\025A}\373^\366d:n\344\000PqM\314\200\213<\204:N\0279\323z\337\271\031\337x\0007\352\220\032b \303\346`\201\2729", 64 },
	{ "\236\271\202\214\310\003r\323", 8, "\020>\356\364\222*\307l\337\312\351\343R\273pxL6|\305\324\362\273>\332\245t\3267\212\276\231\310\343\243\034X\360,\224il\313\374\217\2407\134", 400, "\224?^QsO\227|\332iTx\204=g\360\033\352\240`\330L\212\276(\201Dx\017\216\016\231\307^\204K%^\327\360\257\236\005j\010\233\371H\203n`zx\230cH\320,M\315\344%\215\024", 64 },
	{ "\353h~\2307\320gN", 8, "\235H\252\037+\014\003\265\235*v\020I\376\207\331\222\266\274\0270tb\341\276.\306w^\331\270\263k\341%\270\200\232\321b/\244\310\016\361\316\362:\375/\371\255B\307./", 400, "\221Y)\236*\214\226e\360\324\257\367\230R\014_\314\214\236\027O\004\305\370\317w\257\260\001w\245\003P\371\335Y\240\227\365\243bh\254\372\247\375\301)k\255\245&\262\036\374_\026\224\326D\220\336\246\351", 64 },
	{ "\362\023\013 \331\240-M", 8, "\353~\003\260'd@\026_<\301\360]EU\332i\336\177g\347\313\232\337\3562\010\250\345c\235\265\236\343;\322\302~\317\371\002~\027\012\332\301r\014#\322\004\353\261\275g\263\017(W>{`\322P", 400, "SA\003b\271\034\227\224gN\023\203\207 mW\365\257Nz\267wn\016\221\017g%(n\256/\330\311\377+\335\261\343CA\015A\272\352-\345`\245\370W6\020Y\215\2212\000\272\001\022$*\376", 64 },
	{ "\250c`\236vN\302\210", 8, "\257(\256\0171z\243\023\042\134\363\223\252}GzB\307\261\220\301\270\027\327\326\353\253>\313\276\006UAd\355}\276\320)\375`E\353*-\370\226\370\021\004\203\374e\016e\275\202\313\227AP/?5\260\225\217\243\276Ag\377", 400, "\203\022\352c\27522Z\265mo\224\016G\376/C\026\000{\0201\015(\224\005!fV\262\204N\265\206\202\336\255\362\036\015\330\241!5\247\035rVG\346v\301W\306\204\335HS\371Tlq\207\334", 64 },
	{ "\327\002\265\344\005\337@O", 8, "\233\317\326\221:\2409Y", 500, "\134\021\253\352\370\313yg<\015\200\022b\317Vq\262\220\257fL\315\302\201\266\036lxQ\371\021 J\337)(2\346\017V2\310\217\030\274I\357\215\2115\277p\351\236\012\272\346V:\317\003\326\2062", 64 },
	{ "\320u\027+-\245\0217", 8, "\216\257\376\3147\035d\300\366\365\315\320w\304\236$", 500, "\001_\134H\237\352\244\340\034\274\366\034H\321\311\216\255R_U\263\221\206J\301\2641\304J~\274oH\007\340\246a\313\204>\216\330\311x*<\334T\216\251S\322at\360\234\243w3\033\2061PL", 64 },
	{ "#@\256\000\333y\350\327", 8, "Rb\213R\263\262W\317\333\354\261\340\246\26119H\334\277U\253\266C\247", 500, "\343\224\023a\337\367\347\276\245\310-(\363\021\271\221_\360\245\233\356S\236\363\027\212\0046*\244\376\3032\352\007\023Fs-\332\203#+\355\244\33654\205a\200\302w\314\335\0157\212S\227\271l\202*", 64 },
	{ "\350e\303Y\257\366M\223", 8, "d\311\323\036\030%\266j\372\006\016\024;\344\350\256\234\026\341el\325\270\236\226\020\312b[\212\353\343", 500, "F\026H&\347}\264@\307\246ap\356W\272P\023\254\204/-\006\337u\230K\221\204\312h\337Q\021\037p9\222U\032\262k~\013e\017X\134/\243\264>j\251=DBu_*\350Z\260\010z", 64 },
	{ "\277\212\2413\001K\016_", 8, "\005<<y\266oky\302\237\177\024\352Z\342]\033\340d\200|\243\204\211\253\017\001\212\237\134KR\0069\202\3539\365\375\372", 500, " :\341\020\036\347\334\222\354\253\226E`;\355k\016\2340\337\023\303x\230\204\234\222\316W\002h5\251\256\264)\302\347\007\034f]\015\217k\263@\236\004W\366]7\352E\033\345\201\311\204Y\353\2310", 64 },
	{ "\366@\217\206\246\210\347\233", 8, "T\203Q\310Z\350\354Y\231\213n\276c\134\3137\035+;\306\254j\247>#\022(`\277\021/J4~\363\354x\207\271\211Ft\233\026\252\326:\236", 500, "\220\344\307\355\203\332\013\207\2504\364\207\303\026\316\251\026X\367\373sN\225\2540\243\006\233/l\224\370\310\346\352\227}K\267\223E,\010G{e\270>})\274\312\001\3350\311\261\367?7\251|i\243", 64 },
	{ "\271\035\035\334\321\366u\304", 8, "\325L\272\252\211;\134\014}^\270\007<\316[68S\361\3264lA\240}\025l\032\265\036\247\227!\035x\354C\262<?\375oQ\205\377\201\026%#\211\037\274\345\020\347\301", 500, "\246\035\300\203\200@\345TZt\032\374\337\024!\350\023\221P\017;\257\025\376J}\317\305P/\013\312\375G\014\245\001\211\212H\015R\006#\274ca\360\255nf\276<s\220T\373#\271\345\305\211\015\304", 64 },
	{ "\241\322Q\333\203\362\233\316", 8, "\214\375\234\011\345\017\211/\020\021\006\026\257KLP\346\263\042\242]\346\216d\251\177v\301\375\332Ys\321@\217\3775\355\216\313\271\351\336\253\326tA^\242\307)^\022\371\342\217D\030\042\206\346\134\025\361", 500, "ET\245\031\000Z8\234\203\270\363\325\033`\220j\205\134J\343\020@K\030|[\370\362Px\037m\215\300F\216\220\305\134\035dQ\2661\315\300\250\366\022\303\012\257,.\026%\344g\267oy\271\307a", 64 },
	{ "\230l#\3474V\000k", 8, "\277\2702U\260\313\030\303\001\210c\206o\374B7\033\363\230\257\333\372\244\214\362&\377\037H3u\012\204\222\221N\042\327\235\301Z~\361\356\273\304\365\310\033\350\024\034\264\013\361\242h\305N\327d\001\252\357\027\322B\263\337\322\262\034", 500, "\034:\344l\216\335U\036\314\346Z{\215\377\233G\271\351\307J\273l\370b\007\203\036=\024g\207J\007!\015\327\335\333\000\214\306\307.?`\240\241J\236g`\305\264\342\327M!\262\3735\235\236\016\243", 64 },
	{ "\350b\311\324\315c\012h", 8, "(\007\243m\002r\024\360", 600, "bO\231yF\305\225K\256\036\277\234)\134\263&\030P\352B\010<A\025\376\306\331?\213\276i\016\021.\265\310\335\346\323\354x\367\301V\014/\207\317\231L\201g8zM\017\323\212\221\021\367g$p", 64 },
	{ "4\252\245\207\245\212^\274", 8, "Q\376\241\252\2757\010\225\006 \227\200c\015\253\262", 600, "t\345\035\277Ok\031\022\275>[\177\320\324\305%\333{\317*V\220\027\367\322_\234\017\253]\024\347dDB#>\373\003\216\347\333r\220Z\334\301\346\356']\323 \375t7cQh\010\004v\2253", 64 },
	{ "\275\303\226\316\005\315-\300", 8, "\223\241?\356\014`\255l\337ad\241k\345\355\226\334\266@\217C\221\237\005", 600, "\312\375\227\367e\311\261\367\012\304\303\372K:\226\326\010E\235\355A\225\331j\026n\3264\303\301\324\214YnM\261\310\020\002bi\324\311\247\011\237{;\013\216C<> \017-xk\370\265\303\333\311\014", 64 },
	{ "J\242\213\023\026l\3506", 8, "\303\020\346\376\230\303\347=_\355#\0015\363\345+\233\216\203l\347rSa\272Q9\336>\034\257\233", 600, "\3331\377\232\361\326D\362V#\2124l\237\327\215\231\375%|)aM\037\201\030\027\341OxFU<\306\302\355fO\326\325\242\177A\254\316H\247V\227\342\032\377\002\256VY\220\303\363\206[j\222\226", 64 },
	{ "\222\360%qi`\034\316", 8, "\370Hx\232\025]yH\337ys\310\032f\317g\371\315-zT\225c4\033Uy\021\314\013\337\260\247G_4s%\261\004", 600, "\336lk\337\003M\223\020y\344p\356\250\000\301z\337\263.WN),\335!\375\227\210\367d\263Z\214Y\330\333\264\030\004\326\011W\005\323\3448\354(^T'\200\255\301\320\012\355F\240\271\203\012\353\313", 64 },
	{ "0\015\376\022\354\343\255/", 8, "\304\347\345\335\327g\331\204\343\025\246\030\247y\365-\266\264\361\212\366\211\035\216\276+\235<\371\321\226[\250\336\346tn<}\247\2076%\231\373\227o\351", 600, "\201\306eLu\262\032\355\246H`2\246\247-\007\217H;\017\370\277\237)\275='\001HG$\134\223N\000\335n\304y\272\205N\2265\310\305o\250# \235r\312\236\217W\324\360\323\007\351\215\232+", 64 },
	{ "\030\253\370\026\377\013s\252", 8, "\337\202p\313\334&[ql\346\042\350\016\272+\322|\004S5d\223]9}\250\253EW\357+\215\315\255\246\023\352>\274\001\027\231x\225#\261:n\342\012l\253\005\036\134\327", 600, "\223\241\274\227M\2322t\205\027\016\377\267\015\350\012Y \321\217\000\305\305Y\322\301\260\316\230\200\003rQ\235\245\177\003\305\342\022Iu\375\323>1W\002\013\321k\264\334?\225:!\377\014\331\206\270\371'", 64 },
	{ "a\033o\014\314\261\004\243", 8, "y\340j\235ZH+4\023}\372=4\262\303\213\134|\220\252\255\0014\021\262\355\224\212\312\341\277 l^\021t\261S^j\007\313N\005\277\340\224\345\320\346\226eH\042\313q\271i\317\023U]B\331", 600, "\355=1\261\000\236>\260t@\241\370\305\323\2139\016\316vb\352\2533\336L\015\371\321\265\211_\273\177c\311UAa8P\263\017\272\037\217<\201\327\205\002IV\227\034\273\002\002\3312#\243\225\327b", 64 },
	{ "[$\035\042a\220:c", 8, "j\312\316\373\207\241\335\304\0327\033\263\274[\305\234\371\224\253\012\266x\340\224V\230\335\374l3\320L\252\306qA\344\3069C&H\265\211\306X\347\311:\376\223It,\251\300!h\24791\371V\007\375\233J\032\330.\236U", 600, "`l\213nT\353\237\304\251I\256 >C\231\000X\377\332\206\204K\262Z\353\327\022\265}\245y\232\3368WI\332/\213\316\042\371\200\033\0378\322U4J\363\360\357\350\361*\367.>\363\377\334\0232", 64 },
	{ "\354\304\015\017\355\240\021\276", 8, "\247\274\225<\353\357\376c", 700, "\374\221\245\277Y\007w\274\375\266'l\316\243\333\312\223\257\301\270\303K\337q_\331\354\347\376\012\223\275\344\001t\373F`\235\302\3108W\332\205Q\223d\004\207\223aki\277\307\313}\326\254\234v\042\341", 64 },
	{ "IZ\367\257\273\377\332k", 8, "i\027\226\010\004~\257w\273?\222\224\212\274 C", 700, "\253\034\346./iA\3661T32Zw\312\266.\357\034\032\202\213\332\320\356\356\327\275\217\251\326\356\042\377^\270\362\346W\367\353\237\331B[\021\034\310& Me]|\355\274\207\325\372=\373iR\177", 64 },
	{ "G\334S\242\304\334Y<", 8, "\330x<\264\323\016\237-\300\231\260\364\210B\314bW\255/\235\014\277\3450", 700, ";U\042\252\241\200\357\247\366\020?gb\0358\231W\354\331\377MS\273 F\3361<U<Z\330\257\327\036\273Vrw\017\241\310\221\332\200\221 _up\365,\346\030\231\206c:,t\227*\276\335", 64 },
	{ "}\276z\315\217\015\352\372", 8, "/K/$\233}sC_\300SM\357\361\355\006\376\303\177S\207\317\322\200\300\2030|\272*\357\201", 700, "\012s\226x\326\261\376\341\276\240Yf\256p\027\235\363\0332#/\275\005\372@\241\202\362\237\256>\313\377\344\361\004edjn\276\261[\0221\225\017\3731\203`\350a\301a\005\036wwQ\034m\323\226", 64 },
	{ "T\236\334\030&\300sl", 8, "\006\377L|^\220T\213\307-f\214\024\215\251\366\224\240\250L\364\346=\224\001m\206D\335\375i\371.\261\3026\364\270\225\320", 700, "|i\376\031T\307y\012)\250\211\242c\200\244\370\232\212\206\316$-\031~\274\264\302IJ\243\356\367\232C\314c\013U\037\236\305\313\264\207\322}\273VHX\300\321\002Yi\237\261\345e\031\005{L|", 64 },
	{ "A\313\345\257\373[@]", 8, ")\227\310\042\306\361\235\256\363y\337\341\265\3144\344\012\342\3540\260>\343\246\214id\013\254c:\203>\020\365\267x\243\013B7w4\235\267\015\330,", 700, "\0428\377Wc\042\366\266\227\254\030_w\263g\202\376\326\267\253\336\265\353\026\200t\017\354l\227\352\314[;\364\263\361\203\215\220\374.\272\042:.@m\033\250\274}\3646\000\330b^\363\364\327(A\015", 64 },
	{ "\210\332a\312\367\024()", 8, "]\215\337\017p\215\251/\2747[\206\312\314Zk\267'\324\223c4\265Z%\315\210&\014\021&\262\270U\274@\374\221\0262\2720\3360?\274\214\330\302\373\240G\205RwQ", 700, "0\3646)\364\337\3250\333!\010\356\306D\241]wn\353\303\265:\374\315~6C%\250\346\234\231\367\330\367\220\221\324\255\221\375\344mc\271+R\324\374z\027\237H?k\343\211\022\014\375\134J\256\014", 64 },
	{ "\305\354v] \232v\253", 8, "9\230\361c\001XS\355\303\361*\366\267z\363\226\237\331E\336\222#\305\037\326\005v\336\375_+=\277\212_\0269!A=\235\007h\254\370Z7K\346\277\246\360*\015Kb6\303\022\224\322\026M\313", 700, "\253\232\256))\226\212\353\237S+\307u<>$\3440\367\363v\222\250\321k:\323^\234P\351\236f\205?\003F\326\016\355\311\244\023\346\321\243|\256!\273\2243y\226P\026\323m\250\306\360Q\267p", 64 },
	{ "\001\363\342\257~\177S\275", 8, "B\012\033\376\003<9&\264 \214\003\212\001j\004;/\321@\231r\267\024\302\270\344c\0306\262\215\205@\263_\360\033j\3177Z\220\042E#\206\231X_}j\012\340\365\325\336\376D[\273g\366O\377\300\265\373\256\203\2779", 700, "\013\331\003N\240.\215\336\022\230\317\271\042\376lv\311\036\305[f4\351\314\237f\323e2u2\272g\225\261b1\027\246>\251\235\261\326$\243\201\342\250CG\224MY\3737\225\312o\355TU\032\275", 64 },
	{ "\017\327\331x\230\001\363\353", 8, ".\331\317\373;\330h_", 800, "\265udMk\214\004v\236Q\366c\336\020\010/\243\236\262\020\320\004\016\241\371\242\232i |)\240\305=\266\316\201\350UAY$J\243\230\267P\377\011\000o\033+\211\236\020r\356|\261\317\033\355u", 64 },
	{ "\032\276\352\212\347\313\231;", 8, "\311\365\134;\311+\024N\037\134\0020\362\354\324x", 800, "\276\004-\013\036\334\372\350\311\270\306T3\014\230\351\015\230^@\330\342\304\324\034F\264e\367\013\273\355\251\260\271O4\257\020x\362*\354il)\363\201\017\232\032\344:\312\037\005\341\325\3720\326\366\002b", 64 },
	{ "]]Yk\304T\222f", 8, "H\031\273\324T\210$\267\222\324\027\270_\2514\214\347\317o\177C\272\313\012", 800, "\325\007\134%\256\3015\242\203%;\261\350\324!\262\367\002H\177\355\247Mk\042m\373\263\306#\301\3472\354\344\353\031\346\246\017\202\342\306V\005D\266giX\205\012\016H3\231\344bn:;v\225,", 64 },
	{ "\346\320\306\0348\265\356\000", 8, "\376S\210\356d\366\033O0\352\265\314ZV\263\3701p\023\262f\227\356\025\361\002EV\204\337\304\206", 800, "Z\2104\306`\244\211\342\010\204%\343\240\207VL\375_T\342\360\031\017\257_\207\345\327\014\347Fn?\331QY\310\375\334b\244\337\241\003\370\202\0356!\305\326z\330@\201\0241\244\332:v\371/\264", 64 },
	{ "r\206Tl\304\226\231\356", 8, "g_B@\2277\267\027l\314\247W\306\346\221\226\223\201\013\263R\245A<\024\177\007\230\222|\216\331~\233{\350n\244\341\362", 800, "f8ma\263y|\237\2600q\021'\276I\3642\276\344\255\345\032\270\273\032\262\365\026\004\364j\211x:\330_\207\250\336\311\016g\376\261\366\307\345\223\204k\362\355\252l!\357X\211\003\035L`]\341", 64 },
	{ "\016\320!\037;\311\210\213", 8, "\347\042\302\3575\315\031\013\267\340\377)\031DY\177`G\316D\251\025\327o\311\233We3\236\022L\017\354\314\342d\207\343\017\345\235\010H\210\225E\345", 800, "4V\003\007\215ht\377\262zSoW\277\3314\316L\376oAw\367\015\224\304\201\2176\277\375}9r\042\304hZU\374\306\202\205\354\2167M!(\371]\313\357]\233\005\345\256N\252]\177Q#", 64 },
	{ "\347\274e\2157\327\016 ", 8, "\272xp\134\303\305\032\372\217\330\225\227\354\372?D\027\354\212\376\311\236\260?H\362\257\006\261\003\350|p\266\331R\363\036{\332\335t\021\327\213.\253\202Ss \335\252#*%", 800, "\1346\322\026\247m\011\012,\203\263\2449,\344\250\235\360|t>\225\277.Z\215\037\226)5\356\345JV\334\234\211\357c\024=\2534\257\026\225\005\023\221\330\275\010\246\011^\374\034A\246Pd\212\234\317", 64 },
	{ "Z\207\036\243J\207\322D", 8, "\323\326\355\204\245}\341\034\322\331\364\234\240\241\260\2203,X\355\362\335O9^V\212\373;\214\342\334\020\316\234\214\324H\317wH_\313S\257\335\240e\007n\372\036](\317\024\331\231`\031\023\002\243\033", 800, "\224\343\262\023\213\042XE\317\300\260\327\316\217{{\322\307\234yqc\011BMd\312\373\375M\323]@X\3400\012\2175k\235_X\307a\134\023\376\035\323Z\312\011\376?\346\006C\356x \332\323\227", 64 },
	{ "4\324\256]z\277\006\304", 8, "Os\324\324\223\211\353X\217\245\344\317\334w C\265\024\371e5\007\235\230\364CH*\036\243\251\222,|/\270+\31386ywY\202.ByB J\245p\237(\315\024l\362\240SC\352\261D\24176\026\024D\023u", 800, "\014\217}\334\346\012\202\320\323x\317\341\363\307y\261\134\355\0259|\237\224\200Q\002q#\232t\336\215\303\355\020\263\221\0257\205)\374-\316\271sj(\000\332h\303&\003\323%\3052x\035\230\3673\267", 64 },
	{ "\2311\362\360(*\314c", 8, "\226\205\332a\235\200\177\002", 900, "\266N>\311\351\345\223>\327\365/\202\006\211\317\345\265z\001\276\340'\355\303QyH\367\311\042\032\350\331\012\034\261\327po\323\275E\317\000D\234\355\032\241\242\332]e\276Pk\264\000\211ia0q5", 64 },
	{ "\020\277\212\360H>\226S", 8, "\333\342rh\323\302\366\223vK\376\004\340\213\316;", 900, "\344\254\354@\367\243\012\310\303\042\263\330\230\230\307\266-\011\134\024\221[\371\320\324\244\375^S\314u\303\335:<Q\220\026 o\356G\134\363\015\256\313\250,\0069\302eFSC9\211\000#\372x2d", 64 },
	{ "\302\324)\317\203\362C>", 8, "\035)\304;g\254m\313n\232Rn\276\022\264\317.\210WB\272\026M~", 900, "[i{\304\237n\213\314\375\2223w\134T\257\027\265\307\015\264\016\022\245~\250\031\257\342w\211Q\242{\012\370&\003P\016\311\032+\235,F\260\362\327&2wxw\030\277D#\365'c\216\303A\356", 64 },
	{ "\324\210\245\303\375jc\134", 8, "\003\042\006\004.8\256\321\013\216'\227\210\353\226.\364\037\300\351e\206\357JY\201\254x\015\352\023\212", 900, "\2727$\177\202\237\0142`&\034\321\224P\3620\013\367pg\371h\315 \134\227\306\241\257\3333uS\025\206\030\2704n\013\354^\032\034\266]\024\254\000\256\356\2356\331nz\263\310Q\2178\201\310\320", 64 },
	{ "\322;F\214L\230wH", 8, "\330%\316\307\264\310\375q;+\256*\315h\300\274\215yZ\320\360\203)\353|\310!\016u\260\350\222\323\177\303\226\212o\3255", 900, "m\267\007?\353\220\220$\231\316;f\201\253X\312\320\006{\307\014\334s\3257\277[^\0055\2567\134\270yr9A\342\273N\217i\374\314\364\301\312\335G\036\014R\341|w\323ei\226\014I\034C", 64 },
	{ "\345\342>\335\2457/,", 8, "\355\262\340\201\134\012o\2011F\234^\321\211\216w\207\022[\361\310\004\236\256`x`j^\263v*\2250\336=*\340\017\317R|\00164\353<\244", 900, "\004\240\005\275jv\352M\360\350\036U\306l\237[\031C\224\205C0iT\370\242\011K\042\030\333\375\302^\255B\301\354\310\240*\323\257\310\222\240\354\233\221\346h\311;\214\321\240\341]\363\326\335\022\216\224", 64 },
	{ ".\245\313\031\277\374\042l", 8, "-]\026q\347=q\004<\002@^\242\277\355\212\334\337M\304B\351\015:p\323!lA\357\204\206\364*N\317\363\016\016\230D6\227\337\347*t\243\177\021]Y|\240\035\006", 900, "p\006\336\010\351\337\304\260\372\210\267\013\231 t\265\231\274{%DScF\3726\320\205\275 \011h'\251B\363\323L\014V\260\362#z'\233\322H_\306t\273\027\353\272\021f0Q\222\244\0316\225", 64 },
	{ "\014Y>\242\331\270\367G", 8, "\222\344 \364|\347CP.9\372Tu\341n\014\333\321\034\204k4y\312\314\363\323(\221\365\023\032\342Y!\010n\273\213ot\346\310h\304\220y./\235\342Pg\214\037\217\352\316\374\276\3740\256e", 900, "\211\042{m\201\233_\3020\350\237<\315\272\256\200\010\323)\210\210*\042\200~\266\343\177ic\212\300\363L\215\271\022\2609_\361eWbF8\203\271\363\214t\272\275X5\011\355<\2233[T]P", 64 },
	{ "\334\023\304\233\305\200\206\272", 8, "\314\332|aD\003\341\033_\3733\374\263\042L&9\014g\336\253\355Ir`\004\014\377\306\2031\212nX)uG\236I\021\031\337\336u0m;\3126u\332\025Q\370u\303$2*YH\211\343Z\3628\237\274\2061sw", 900, "\005Zx\257\262D\357n\005b\014(\012\277O<\313\361M\331\373mB8\031\215\035/\247\005B\343\346\305\337o\024\275\357|Y\235@\221}\202M1\0325\306\325A\253\250\241JY\326\255\032\272\314c", 64 },
	{ "Z\270\301ED\237U|", 8, "\0272-\237\010\275\377\042", 1000, "\360\355\220\212\252\371b9P\343K\301,\024$\227|\305\346\327$>\215R\243\214Vs\273W{\306\234x\347Jlb\211\355\321\310\015\002\267\352[\210\335Zl\341\023\236u{\225\264\027\370Wc\343&", 64 },
	{ "\262\3435,q\037^\014", 8, "G\330\246\256\356\260\201)P|\336R\254\301\265m", 1000, "\314\320h\267\227\350\034\216p\334\250\372\230\300\273\220s\352K\341\347\253\317\321\362\042R\311fN\177S[\376b\354@R\320\010\251W\374\256]\243\262NO\000\206\347\005\306`\215u4/!\365\025T\026", 64 },
	{ "\033\341\202Z\263\274s\025", 8, "\317\320\367\371\200\035\361Z\240oE~t\347\300\227\330V]g\337r\316@", 1000, "\234\313t+9d;3\226!\325\256\242\211`\323\030\352\336\377\306\215rZ\263#{\306\037{7\307\203\325M\032\031Q^\260[8$a\272\215\337?p\022A\335n%u\214\232\303^\352\241\251~\247", 64 },
	{ "uc\214\232\3031l\300", 8, "\013(7Vl\341\013JA\276\222u\345\271\363\015\134\317\340R\214\335\312\245\264z\324\326\366L\344\250", 1000, "'\352\216\246\314\215\365\333%\334\202\342\334\352\347\211%\312\215(R\312k\246\330\207\223\004LhVFw\374\322\331\275\265\334k7\343\013\312\010_\264\362b[\254\366\226\224hvgG\307\200\347\216\033\036", 64 },
	{ "cD\020\266.C`u", 8, "\247&^M\360@\266Y\365\322'\367\262l\376\250\042KU\360\237nOl\207\346\2520\203\0428\003\332o\344\0046`\226a", 1000, "\241u\001\027W\202YT\341\275\204.Y\242_U\016t\003\025\001\340\304\213\364L\264)\023\346\031(d\234\256\313\204\260\262x\220N\017\274\340\315\000\276q\017\001;x\375v\004\025\300\276U9\336\260\375", 64 },
	{ "a\0162\201\011\221d\017", 8, "\256aW\215\327\374\235\334;\303\032\021\037wg\306K@\001d\213L\244>\343Z\234u\336\313\024b\344`\233\271\234\333\365\305Z\306\0218\310UK\306", 1000, "\304\023e\243|\032k\320ni\270\002\252\306\036tZ\015j\373\340\331\207\245\347\032\261L\354kh\012\356\363e7\015\334\352\206\036;\320~\331\260\330\003\257\310\244\364\244\370\305\233:J\363\367\324\362\025[", 64 },
	{ "\324\304\265\306\270\217\276\015", 8, "\276\027jRk0X\215\227lG\236\240RpJ\220N\005\250b\345tQ\221h\321\354P\371\035\244$\256l\023HZ[\031\255- O\236\222:\267t\254d\313's\317\024", 1000, "\250\316\327\215\271\374\206\207\220\351D\263\306Q\362\366c|\273VQ\241\016\377\004n\314f\215\253\305\321\350\236.ZjX\037|!\314m\331\3775\011\034n_\263x\267\345\241\322j\230l^G\334\256L", 64 },
	{ "\030\302&\234\200)\230\305", 8, "+L\221:5T\274h\237\256q\323\353m\333fh\201}Q\351*\351\240\267\276\327\007\254\316\214J\342\350\351\367\367\266\301\010\3775\015\014\351\337\3264\355K\027\355\327m\300\241@?#\232\225\263\037\007", 1000, "\201\355F\216\035\037@\350_\232\325Mx5\353\004*\372\250\370%X\247)\315\324\314\256\315\242}?\373L3\346a\331\302\134\334=\237n\275 \330_OZ]VW\007q\312\254\244\276\024\034K,C", 64 },
	{ "?\362\015\253q\331|\250", 8, "}\020\020\337\215V\263\334p\346\003G\363\301A\333\134\177\222w\271\262\306>m\2774\343\006#P\260\306mS#Gs\250\363u\230\227\377\015\361\235\336\273V\230\316\214\276l\201\272\241}\361\260\357Aw\015\263\246/\366\026\375\037", 1000, "u'\305L\233\270\032\326\225\2422\323\347\335g\374\270\023\352E\305\332\240\231\244\035\343\226\322z\264\346\354M\036\211ye:A1\257K\236\215\333B#BV!\333\245\336|\217\317P\257>\257\265\252\003", 64 },
	{ "(\134\324\014\245*\260?", 8, "\263nO\374\320BL\042", 2000, "\354`\262\357X\301\351\240\333\374\3536\307\367A\273gVR\366B\1775\217_]\214\016\2641j$kE\201g\270,\276$\213\205\250\237\005\211D$\351\241\334\222\337\326\360\372\277P\002k\224\235\2137", 64 },
	{ "VC\260\247\227+K\325", 8, "\214y\202\334\330\323;\206\274k\026\333#X\247H", 2000, "\005\366 t\203\277\030z|\241z+\222\344\134C\306XV\367\042\032Y\2074j\211\034g~\013\263Z}\354d\342\246\005\011\250\230\244\222\336(\224\320\320\221\237lj\227\003\345c\311P\023t\000\243<", 64 },
	{ "\226\264\332\250Q\332\033?", 8, "6\177z\010St\034J\240\224\003\367\252I\322/\034ZS\243\322\307\374\311", 2000, "\225\325\364`R\004\354\021\306\2123\337\341M\273\023xsu\030\210\267U\375\011\223{\002!3a\031\254\247\200\302\265\016\277\301\235\024\014Vj\363\022\367H\224\372\205\337\302G\035\351\257~\316\371\252D\342", 64 },
	{ "\347\016\225\220\026\324\301Y", 8, "\351\314\237M\230\305o\321\374\374\253H\236(*=1\364\203\007\210\344\001\245\2736\022\340C\314\265\224", 2000, "kN3z\003R\340\020D\033\221{\234\352\211\201\315\356\017\234\370\270\214\035J\335KM\255\200I\010=:\3512\030\260(+\257\276\275\001\361\263j\030\002\224\352\372\031$q_\023\330\333\021\233\240\222x", 64 },
	{ "\340r\267}u]\377\350", 8, "\242\360\243\361\363\020jX_g\376\016X\352dF\022;'+\306\213\375\036\224\214A\242L\022\334\025\231\015\267\305\001:\032\270", 2000, "\230D8\251\010\031,p\016\330\310\233\241O\031#\310[\324u\261\207\2042\361u\310;\366\342[9\201\005\037\20261\316\351;&\273\325\263\305\325@\251\027\343Ak\225\270\014K\342\037\015\305\247e\231", 64 },
	{ "\013n\007\254\357\255\217\340", 8, "\334\015\217\312\237\315sW\026\357{W\321,\031\034\374\023\2720y\251\235q\030\2170\357\251\366\370\364\312E\205.w\273r\242`\246\005}>,\231\250", 2000, "w\210\363\2605\020\134\374\231\024\327\314\205\310\325\247\033%\322T\226\271@\302\004\266q\304\345\326\275\347\260\322\361\2435\344\010\356\300%g\307\217K\0423!`R,\005\327\201\0037U\266\2705\275\343r", 64 },
	{ "\202\361W\024^\252\307\235", 8, "\356\247\020\315\037(p\361\006\223 \261\035\332b\222m\236\027\367n\020dw\323\247\3017:8\034\256\302\363\263|\273\134TF\260M_D\3418h\237\365\260\262\257\007\344\231\351", 2000, "\327G\376I\211\335s\3060\367\277\200\015\270\327\351\023\3539\245\203\356\244\367Y\244\340\277\207\235\360\027\347\352\343.\301\3570\347\330\324\352\353S\242>\324w\213\271\262\013\211\250\035\261a\011\271\370\034\3633", 64 },
	{ "\207-J\204\243\334\335\016", 8, "\261\134\241\340\024\3441\306'\32061\256\202\267\232\370\2327\257\357\342R\202\326\345\300\362Cp\315!;\320\305\240\013Zm\234\343\217\373f)#\223\343s7\320R\342d\224\027\212,+\304\262k\243l", 2000, "\271\317r\177#\201M\306\320\314\317e\236\042k\031\032\242W\364\321\255\026YkJ\371zp`\337\264\212\253x\034Ef\2003\214-\370o\277\305\3671\355\013\320C\247d\214nA\273!C\375\025\2218", 64 },
	{ "\300H\213\371\272>\337\241", 8, "\001qO\241\310Gs\274\036\375\272\362\033\014\256\327v^\037\321\246\277e\224\300\235\231U\367\316'\014\327\232\265Z\033*s\302\252}xo\374(a\231\355\301\0350\021\231\024F\177\276\341\221N\316\025f\320\324\134\247\376\335\274c", 2000, "\301\360\262PJf1\243rl\320\364\320\017\312@~\240\031\206\211\261\330\035?\314\356\253\263>\016\252wt\341\213\001!\014.N\264\350\377]\243\234\245\354\325Au\353\227\236;L\333\332k\340\343\352z", 64 },
	{ "z\015\256n_HF\264", 8, "IO\305\325\253\232\001\022", 3000, "\021\032\252P\005v\354\234q:\204\326\203U\2162\246\371\343\340b\327+\037\330\360\241_\215\134H\214c\373Ix\364j>\036L\016\355i\226\034Q\370\320'\320'\014i\336A\210Z|D\200\006\006\202", 64 },
	{ "\027\035\353\321\372\222%>", 8, "\375\3772\334\316\222?\333\300\325\265\005\360\361\347F", 3000, "\231\0011>Jk\031l\324q\271\2308\316\025B\362/JA\010\370\021\377C[3\016G\260/l~\042\350_8\252%\373Q\275-\263}>\356\330\337&\005\265L\353\377\021\324~\255\371\346\316R\204", 64 },
	{ "'\331\374\255\355\315\206^", 8, "~Wx\355\211\365/\372@\022c3\337\311\233\253\007\215j\356\264\254\321\032", 3000, "}\344w\013/\000n<Z\343TQOIyz\327\340,o\367\240}\006\023\233\010\0006\313z\311\343\007\0073\036\011i,Jp\006\210\201\246\225\221\230\033\205\037\361B\247L\001F\373\011\347\366#1", 64 },
	{ "\207\214\016^\012\327\344\220", 8, "\335\222\345{\030\333\011\253\244V\255\206[\304u\202\265\202\312\275\232\314)\303\252I\375J>\371<7", 3000, "f8\205}\321\371=\330\3410\034\030\354\323\033\270\333\227\320vUS\336\305\010\332`\306q8\351\027\034n\372\356\363$u\376@\017\244\3467Ft6H{\264\345\275k\302G \334\202\275\257\375\242r", 64 },
	{ "\241\364\000\231\250^_\277", 8, "R4\332\217\332\374?\341\030\277\345\025~Q\364#l\307\273\331\357\0352\361\373\246\320M\220\250\265EP\225\221(\236\026\332\272", 3000, "\177\243\277\322\005\134\016\015E\251\300\205\250\352\366e_~\377\251+\223\011\021\326\042\033\277\267\206\037\224\231g\260\031_V\341.\300{\243-x\025Q>\177u8\223\177\032\201T3\360\033\336\201\255\234\024", 64 },
	{ "\020\011\277\006(\215\353j", 8, "\215\341\262\207s/M\323\274\341\223\322q\215t\177\225\246\367?\326\245Y\330\026\221:\370`u1\305\377\261\215p\311[D\0229\200(\205\216\341\247\230", 3000, "\236\022O\372{|'\313\011\216[d\364\210\030\36249\2122\266\221\022xD\266\363\207'z\215t\2448\007Be{\272\244\207\251\352\365_\353t\333u\355\317\327\327\205\222\250\003\330\201B\023\004#5", 64 },
	{ "C\251\361u\026\34102", 8, "5\343\200wqFK\2739\260#\224\301\256\323$\247\033\272\322\346_\227k\274\250Wzt\3062\134VI\202\234\325fv\013*m\003\355=R\366\214\233\305O\333|\200\376b", 3000, "\030\177WT\007\014.\134XcB\245\202\004\363\021\313E\344M\216\332<\330W\360N\314\134\341\255\030%\031\323\024\035\312O\370\213\017\263\034*\261\344\031\356\237\271Oi\213.\276\315\314\367\222\212\027\024W", 64 },
	{ "\311\254\331ZS\226@L", 8, "\013\320= \345\032S\317t\255\2550\245<G\371\373\277\254\243\377\332e\356\235\335\006k\224\012>\3062\232\316\241\002\235\333\015$Lx\376\026\334K\010\360=\237*;\007\134\3506O\352,\037\322\342\013", 3000, "\344\202\347\365^\026e&\200\260\214A\324\264\022\313\225\351\033\254\254o\357\255(\215^z\034\200\220\312K\301\240\227MO\030\231\366\020\031=\203\012\224=\024\004>\316W2:\363D\365\231hy\366\365j", 64 },
	{ "\134#\216 D[\241\223", 8, "\017P\274\200^(R\220\266g;\211Z\265\036\345\337\360\2310y\031\330\206rF\253\254\375\271dr\321\367iT\304\2003fV\367\333\264\247\2370S:\377&\216\360yfs\202h>\327\347C\261\345\274\357q\037\331^\305\134", 3000, "\177\373nj\013\324\202\021\035]!)\370\370%\005\353\016~W\330\265\217\362\337\301Z\275\321V\000g71\335\377v\013R\335K\315\241\225\216qE\312\272@.\020\315b\247l\3359:\242\265\000)\310", 64 },
	{ "\304\326\303\344\272\260A?", 8, "`f\262P\027'\211\217", 4000, "\012^\363\365\134\265*$\014\270]F\274|\375>p\341\003dT\242\337u{\314\205\307\260\360\322\025\214\007E\307y\365\352\310\240\372\134Fji\370\241\017\305\336\262\351\332\002{\026\270\376\363\266\134\274;", 64 },
	{ "1\2004\011\006-\032R", 8, "\353\371\330A\261\263)\213u\007\233-\354\230!\202", 4000, "{o\014.\322\016\323\244\021\037&W4*\362\300)mGv\014\016\306\307\237/6G[\267\033\213u\313\266J'\276GtN!\000\216\363^7Y\037\370\021\014\333\250\374\332\274\235l\230\263\220\347\222", 64 },
	{ "\354n\227\202\363\306j8", 8, "T\334\212\366\246\020\042\264\342r\271\317a\0047\322\317\354O\031\202\342\370o", 4000, "\312~\260\260\027\266G\247\236\312`n\335\342\262Ec\247\272x\001\003\252y=\002\362\362\004\326\350\007\0252!\263\312\360H\344\246\016\207vEO\022\205\212\306\276\251O\325;Gz\307O\266}\020\322\376", 64 },
	{ "\360\263\275l\234\244zO", 8, "\335\375\273\001\261%\233,\007\350\255\247\342\235\310-\032\035\314\246\252\027+a\233f\204\274M5W\262", 4000, "\317\365.\214hyP\313\205\356(4Y\251\224W\367\263\361\027\262\324\277\255M\010z\263\314?0\025\003\367\332\236.\004\331\302\232\011R\332D8;]Dz`v\000\246\242a\247b\033M\031\270\011?", 64 },
	{ "v\327\346&\035C\320\322", 8, "\260 ^\376\355\375\2567_\272\252\255Wb\376v\0057M\226\346\031\272a#Up\264#\015\311\342+\2128`(\224\224V", 4000, "`s7\365\307p\250\356x\310^7\320f\2442mm\242\0207\023\360\300\264\336\252.\266\244\202\134\042\311\023F\374\206\225'\371|\327R\371\277\357\307\304\250\352E\016\253\010N@-/9\257'\0235", 64 },
	{ "\252\317\025\232\012l\372\275", 8, "\216\020\363\015\245F\277y5\254}\016'\272\204Rf\226\340\341E\230L\024\352\205\312\306\340\042\241\017\263\375\337\355\013\020KJ\273\342\3572^\313\312U", 4000, "\222\010Cw\275\317./j@\012\032LH^\222s\205\240\335\011\026\310\275i\246\264\347\305\302\365\302\336\221}R\016]\231\006#G\321\222\255\215E\262\272\013\202\260%~\027\350U\031\220(U\210\221\314", 64 },
	{ "\035dQ9@Z\267$", 8, "\204]\013SSO\332\324\322\327\216\362D\203\253\241/\262\21093\374Z\213\001t\376>\207\024e\273\371.\037|\036\334p\005}\353\277'/\346\014#NP\362\2504w6/", 4000, "\252BW%6\265\317\000\271\024C\010C\202nYZ\027\006@\334\321\365g\371z\017\3469J\374\262\366\242G\200\017\363\313\223=\251s\213`\343\362\007\000~_CV\336\207\240\352F*\313#x\212P", 64 },
	{ "\344\263\246\321\357 \003\347", 8, "aT\363\245-\012\023\032\333\253\3049D\372\033\332I\370\005o\267\177\340\226\211&\356T(\210\017\355\372\003\207\277F\012\010\221\213\274s\314\200xLST\260\375\217\013\331wG\240\343\344\347\347\301\324\302", 4000, "\324\336\003\003\337\337\215\354\327z\217\0319E\000\020\353\011\366\347\001\035x\3660D\332\014\276\374\2363\3635\026\227\031f0G#=\015\213\275\210\237\032\207\342s\002\263\2438h'\301)M\351\213\200\274", 64 },
	{ "fJ\325L\311M\364\333", 8, "\2640\311\202\3471\2310\011\271\345\002\265\225\257>\220\277\205\311f_I3\247|l\351\222\341\353j\240|2G\035(\353\203\250\031Jl]\317\226\223\343\205]Z\324\356\245,\264v\030\333~t\035\220*f\027k\207\364Yr", 4000, "42\335%\022\372\310&W\2374\335bp\217\247m#\210\006\207\021\371\134N\306\335a]S\274\350y\247oZ\024\272j%\326\213;\324\273\347w\300E]\347%'Z\261\206w\2350(\265\205\301\302", 64 },
	{ "\363\237$\002\006\023\357\001", 8, "f\327\370v\0061\026\200", 5000, "\331\303\025\301\344\370\222\004z\275\364\374h\253Y9i\027md\032\020<\042\017\250\261\317%#ne\303Z\324!\354\300\006\235\374[Y\341\036`\373a0\357\357\015\246\3464\352*'\241\272-\317\325M", 64 },
	{ "\332|{6Q\346v\313", 8, "\134!gL\026\024\376\2430~\306\2743\232c\206", 5000, "3\325\201\34598\202\330\263Y\005\244\321}}w+\245:\274\177\255\365\265\000e7\375\312gc\261'OG\266hPp\365\250\364\042\333\373\323|\205m\005\2572\021\027\271]\233\360\216-;\210\371\274", 64 },
	{ "\333\220G-\240N<G", 8, "c\353\354]\365w\033\206\365\244\366\247>\205\232\303\177 \012\324\374rl\034", 5000, "U\342\2200*K\262\010\177\273\024\2455|\367\336\2311\225\366/\005b\305\345{\233\301k\030\023?e\250Cf\007\134\036:\377\213\027)\353%\323R\322:b\255Rqr\007!\020r6\305a)F", 64 },
	{ "\234\004/\345\032\000v\220", 8, "ar\031\272\305\245\232*\007\247\025HL\274\010\336E+\311\336\2557\266\300\263%\3031\337F\227<", 5000, "\320\254\3477Do\003\227NL\334\355\217)\317\302\221\344\300\320\356\204\266\350\305\223\275\273&r\327\014\261\352\324@\356\032\325\221\330C\346\202\233\013\007\304\031#h\202\244L\207\236p\351\371\335\213O\341^", 64 },
	{ "k\317u\332\217\324\322\216", 8, "\177Te\253\271\260\255\276\353o\223D\324\001s\317L\033V\242\247,\2566\233\206\313\315\014\332b\317\312\134\322\216\314d\344\344", 5000, "\316\021\033\027\375R\207\327\021\341\340\253Y\230\016\257\355\024\027B\226\322\346\025\017\2429.\336\2262\352\324\375\225\356\367\353\235\012X\011\361$Q,s\240\033\372\254p\202>\343\034^\303<\211\242\273AA", 64 },
	{ "`\226\222T\332\377\223\015", 8, "\351\350a \311\352J/ <U\222Hk\374\355l\264\236\357\307\205aH\004)\377\340\277\355\272\274\252\351\360\364\331\310:\236\032q{\211\331\036\016\007", 5000, "\240_\025\006Q\261\013\276\237G4\304.\260\203V\320\372\010@\334\233::\330@z\227sz1H\0061N\202\365\341W\244\273\357\360\222\333>\015\270I~3\360\2378\265kP\302\371q\202\3006\000", 64 },
	{ "\303\327\253eb|\362\227", 8, "\30630\364^\006>\227\224\315o\217]aL\236*\256DZ\270<^N.\326\014y!!Ng\375\325P-v\220\341\206\315'>\314X\315\364\276\014L\324\212\374\354e\230", 5000, "\267\272\262\235\213^\042E\255\330\372\010&\012p\354nBG\344\246\266#t\300\237a\271)\275\010x\356b\274a7^\327\303S9s\343\203\236!=\332n06\241\312\254s\335\265\334\356\324\367\177\375", 64 },
	{ "Z\3378}!\257\020\301", 8, "\301.\2642Q\250\277$\271\334M\307\250jz\364\354\361+K\322\275\343\242\322\021Z\2747\333\213\241\224\011\0320j\267\011\337O\023~{7/y\350\012_\202\331\216L\206\003\006\026iQ^\310\036\360", 5000, "\216\202S\222}\336pr\331?\232X\323M!\202<\372\263%\353\264\334\035\370_\323<V\336H\234\254]f\315\335\357\255H\313\245\270\343\205\232\262\201\246\261\310\315\333}\266\340\204\363B\256:\300\006\365", 64 },
	{ "\344\342_\244\230\227\337x", 8, "7\255\0124\272=\224\246\241\357E\2452?<c!\223\037l\252\222\316\362J\034\204UL\324v\015\234\252\366I\351\212[\267\312\003_\275\364X\312\204\006=\3528\253\252~!\202\225B\203\3253\333\005/\270\222b\332\342\001\020", 5000, "\342o\255kBZ2\361e\364\203\035\013\343\323!\276\331\271\207WE\207\375\304\222 mI\365\377\332\270\042\344\032\033\225oe\317\247w\336\305\345\3711\321\226.\277\2514\327\031\324:\347\255\227\006 \323", 64 },
	{ "\344f\014\337\306\314\200:", 8, "\274\251\230\012(\271\313_", 6000, "\317,\335\301(<M\214r-\333\206$\325\241\214\304\274\343\037J\015\305\245\026\314\373\270\317\271\314\3022|\232\271\214\020\200\036|7\271`Ag\2151S\036\266\234|\333+\376\200\261!\315\26021\243", 64 },
	{ "\212>\363\217\322\014\301\177", 8, "\344\303W\177\317\032+u\032B\353\375\317,\225r", 6000, "\212\205\266\373(\344\246\213'\247\262\257\030vZ\355L)\242\375\353p\227\3250h\022Xg\356\310\350=\353\247=/k%\021\364\030\223\013\272-\177\277iX\005?\000\200\325\310\245\0137\247\365\034\234\007", 64 },
	{ "\235z\200\0425D\206\326", 8, "ZC\014\243\032t3g\336&\0058\016`U\317\210K$\205\236\264\274\224", 6000, "\233__\371\276\213\263L\005\211\250jO\042\364m,B\020S9\014\332\263~`R\334\236\020\224d\374\037\201\311\327\262:l\221\315&\277\351A\251\262\000\012\200R\203\360\011\371.\373\323b\000\316\277\275", 64 },
	{ "\013\216\203\231;\177\030\022", 8, ";\250\2605\215\314[\2478\314\343\342gM\352\211\020:\336\3271E\260\042\3444\274\305\234:\226\221", 6000, "k\255\012\344\344\350\306;fm\253<\277T\017\020?\234\215\216A\373\303\3375l\325\333\027P\301\006\214\221\202\375\342\240\213\012\307g3`\377@*F\3518\000?\010\002\021\005\023\227+E\177\363\022\236", 64 },
	{ "\211\354\257\301\023\201\377\374", 8, "t\235\202\224\274\013\350\134Cnm77\352w\200B>\250\213\211l\275\357\234/\004\342\311\216)\260a\016B\216o\253&\317", 6000, "\304\225\214\273\016\374\375V\215\207G\264?/\273*\276\257\343\012\234/\025&/\017\331\211\355\016\351+\301bS\004x\017\326\252\032&\205\030\222\347\272\002\036\231\261\033\200\276\330\367\007\252\376\005#\217~\212", 64 },
	{ "{\355d\364\020MGs", 8, "\324\301)\225SI\220\322\320\333\263[\375\2154\006X\303\014\275x\300a\313O:E]\011\236\134\203\344\220wj\231\320\300\015\222\321\324\177\341\320\237\372", 6000, "]\005'\026\210\036\250\037{}hs7\254d\327\243$Ch\000.\011E|\213_\347\3579d\342\321E\212\334\251~\231\221o9\006\323\317\013L9L\312\206\357\372\007Hv\234Q\311'+\001\276\034", 64 },
	{ "DR\0073?q\272\374", 8, "\250l\002\017#4\320=p\032\202\257s\207\352\347I\373\244z\377jD\227<I8\210\213\306\372,\204\324]']\271\346\347`$Rw\261\224\037\006\242\216\245 \027%f\351", 6000, "\005T\364\022\034\357\242\240\243\2461D\0034\313\322\232\340\363s\335\233\245\003Bb\230\037\033[$L\276\013DJ\024\234\306\217\246\013\353\270\262\3364\245\324)\342\352S\253`\027\312k%/e\373}\261", 64 },
	{ "s\355\341\224\375?7$", 8, "y$u\342\341\261\215\244P\211!6\034u0Z\251\335$\354r\306o\3605qd\237\344B.\274\234\231f\036\260\032!\267O6(\366<\250~\252\276\250\332\037;\205vo<\353\376y}3\211k", 6000, "\310d\310\246\367\305\310\013\003\330\037\365>\214IG\364\206\004\322\261-\217\305\301\214.\314\206\373p\341 TSu\323\377L\373Bu{\032\247\370\270Q\260\307PZ\337\203\304\235\004\254\354\322\363\260\001\004", 64 },
	{ "PB\323`z9_2", 8, "\373\317\015\021\275\311\335\315\323\231\212}\307j\336::\201\343Y\210\042P+M\263Gh\031d1\034jz&\134\366\363\012\374\274\212\244\315j|\207\331 \345\312\027x\026\261f\016\311\035Mt\370x\243\323\3550A\014R\033h", 6000, "\134L\334\310\334X\035\356S\015v\243\242|\002\037\305\022\375\372qK]\020\300\226\001\334\310P\357\376s\203\225 \037\305\373o\261\020\303\264\370\256\262\337\237\251\273>:E\335e\260\316\246U`c}\016", 64 },
	{ "\027\223!\256N\260<\200", 8, "\020\374\203\034\005b\230\201", 7000, "\302I|/\305\025\001\003\233\244@\332R<&1\333\030B<\010\3315\267\213\317\231U\225\303\336S\217\037\337\212C\202\022p\270\207o\205D\177!}j\221\215\027)\306~s\004h\323\342\336Z\252\377", 64 },
	{ "\201\016\210\273m\345&W", 8, "\253\363\011\215\2646\222:gr\001:h{\012Y", 7000, "\244*>\204\042@\302A*b\010\024j\270\220P!\2114\327\031\237\304\231Lb\303\336J\325\321K\263d0\200\327\005l\320\344\336\353\323\012y}N\251!h\275\363\376\320\225\341f\246RE\310\2418", 64 },
	{ "\276\257\256+\244\247\211\226", 8, "?\235\347\030\024\362ng\234\254\017@\033\321\331TO_\255\277!\042\233t", 7000, "\216I\365\206\200\134\002\353\213I$\327$U\275\240(\351\352\2738{\313H\202\275F/\322\013h(8\263\205\326\303\042\2621\032\204M\264hT\221\205\310\263\214\273\262\313\221\267\206m|)G\324\241\025", 64 },
	{ "\2020\274j\042\224\231\221", 8, "\334\260p\216\333[3\014\301-\223\026&\315G|\231\207\205{\310\336@H\246\3257M\020\031\362-", 7000, "x\213\321\215\223\332\313\016\323\012\310\330?o\300\277\177j\312\220\255H\247&\366\232BX\232\352\362N0\225=\373\010\260\027'\271v\376\220\324\263\225~\354\035\277r\222f\221\260R\253\215m\203|$\334", 64 },
	{ "\372+1\367\246\333\271w", 8, "`\220^\277$Y\341q?\315!\014J\221\210\242\232ySd'\354\361z\306\301\016\252\274\342\267sso_TZ\200fe", 7000, "d\224\227\252\306\204\012g\201\237\314i~\216\214QV(1C\271\320\233K\341\351\313\005\342\343>\361\341\377\030\204b7N\340\356\274Ma\023\212\314\222\240\211\033\013\211-\356\264\267\027\262\005\313\270[\204", 64 },
	{ "e/\227\361\021\350\237E", 8, "-NQ\342\360?\267#\011s\303\241\227\353\232\227\010f\003f\012;[\022\217iu\317\024g,caX\370.\214\321\273\035|\337EB\014\2636\235", 7000, "\247_\330\233!\237~,D\351\274\202\265Z\026G\224a}\277q1\250?\023!\276\011j\254e\233\255\374\246b\024\275ss\200\031\036\312\322\257i\357\367\371\022\324\213W\014\246<}_\003G\317\204\247", 64 },
	{ "\230\373\305\254hVc5", 8, "\362\306\303B\214\210\020QR\316\205\356\241\373>W\307q\237\261\227\355\251R\334\332j\303\231\202Y\356~\213C$l\353f\017\031US\334\324\016\034D:\374\345\252\235D\303\214", 7000, "\331[#\367\002\331}\306\266\3258\246n\226\357M\204u\226\320\306\323n\015$\320\247\305;\265~\2478\025V\364\222\366s\240f\270\314\034\250\277\347d\275\351\326\310]\213\244d\264v\303\317\371p\235\263", 64 },
	{ "j\332\311\021\016q~\273", 8, "G\026\002J\024d]\255~\231\271\322d\335T1\203\371(\350\331b\013\302n\244\004pi\231\210\205\332\327oE\205\345\011\300\216df>F@\323\020\240I)\026\335\362\345ndx\321b|a\304U", 7000, "\371?q\263\265\2344%\200;\333\251G\020E\316\333\331RD`\275\260\006\261\356\332b\027Tv\251\243\001S(p\361\313\011(g\327^\241\0030\376\365\3425\376\363\307\216\234\316\216\377b{\310\347\003", 64 },
	{ "oS\366\311V \247u", 8, "\217\350\316\355\003>f\334\306W\026\213\307? \304a\245\370\333\364[\236\0256\267\320g\360xn{\037\015\356H\271\010\255\360\265\3136\025\266\342\324\246\204\211\311k\244\322\342\231\307\204o\2376\361cy3w\314\347/\246@\022", 7000, "\211\314\257hDW;\257\3702\271\243\322\314\3131\352\250e\313\006\364/\001\207\327J\350\214\350\232U\353\216\024\344\177(\325\366K\031Rt\220\201L\265\263{\366\305\305\215]\373x\177\373\020K\224\346\350", 64 },
	{ "\2713\267\214\012\302\311g", 8, "bo\2109\255\305P\036", 8000, "\236bG>\215\363\021\012\242\265P8\373\332\017,\367o\217}\210\320\035\320\255\316}1\005\021m'\205\214B\236y\232\377\300\262&\240pJRXQ9\226\011\212\316\346E3\302\252!l\266\304\134\017", 64 },
	{ "l\364\370\012\341\025\344z", 8, "\201\004\012\261\355\255N]*\324i\346\002z\300O", 8000, "\024\220\237\352h\017\263\237Vk7\015\250\007\000\253\203\305\255\220\337|\306\233\240\023\361\226d\304\315g!GGY\363g\331\005\376\354\243\371\207Q\212\246Ez\030|\341\315;h?Pe\351\256\004\364\373", 64 },
	{ "\302\241:W\337\336\036\342", 8, "\273\233\362\231\357\212^\310 $n\370\314\324a\225\235\004L|\322\015\357\256", 8000, "\357\333\324\221\253\207\002\244\006\352S#\326\352Y\201\034\307\301e\22120\252\036\333\2151\010\134*~\235T\322\007\200\020x\221phGw4p\221d\251\262\355\013=\236I_Vm\241\003CN\245]", 64 },
	{ "\250\275\025\013\365\363\227\210", 8, "\030\02582\351Z8\344\017\0252\203\305sTM6\322\336\214\037\303\223!H\306\276R3\235\323D", 8000, "\337/\303\204\376H\020/\366\036\3336O\234\237b\012Q,=9z*4VZ<\320\214\270\341\277\262gjEu,I\224\242\316c\217h\042\211\005\300+\033&\336\024\254&\227&\301\324\004\362\377r", 64 },
	{ "\366\345\301\371\301\220\3759", 8, "\315\012\003\227M\042[2[ \036\264dB\022a\326\372\203%\223\005\330&\007\304\012\300n\347\233\012\263o\330)\177DC\323", 8000, "\023\006\222\026\010\342gH\220\370\372\277Z\327/?\240P\244\244-\326\333e\234g8p\323\263OG2K_\272S=\276\012\011\314\217G\027{\215\246\360 \024\224\244\352\363\003\307\371o\305\212\341\3706", 64 },
	{ "\272\010\025[\365PR<", 8, "\270\205:\014\2338\264k\246~\025\245z3\345\001?\005Nk\006\202\357\220:|\251\2522\276Z\243\232<~8\341i\326IQq\265\355\013$c\241", 8000, "\031\240\307X\344 m0\221(p%\247>\215B\244\325\211#\036\355\215\356\231\247\263=B\232G\264E\260\222\214`\006v\315L\011\355\025F\235\352\347\365Pm\230\211\273\255N\0023\021\202\362\370\004\340", 64 },
	{ "\031\322*2\357\375S\022", 8, "\366\252\324S\223=\016\205>\011\374\2703\234\226\316\004\327\231\1774K\236\030T\232_\315AS'\374H\326\226E\037\225\263.s\004g\332\360\372\0147\200\364Z\003\262\225GJ", 8000, "Y$ \014\261L\304\307\264F\212M\362\364\272\375f5\223\016\275&3z|\227\021]mvP-\024\225!+\361\371\250\335\375\377\310\035\017=\233\347\225\235\042\335\241\300\264\260E*\327\034\220E\204\325", 64 },
	{ "\031\220H$e\221aZ", 8, "\366\331\016o\241W!J\177\212U\230\316F\042\345xO@\324\314cQfu\315\261\312j\252\005{\001\035\362/`i|\361\237\367GmJ\303\356\035\366sV<\031\346\2736\266t\302\024x\001\360t", 8000, "IB\042P\213'\260\225\275a\244\255\225\361\346a%\321tT\251t?gbp\344@x\016\002A\025\242\264\177\224\256'~;\256\216\277\301Nc\302a\216\325\220~\213\240\245\252\260E2\371\216w\134", 64 },
	{ "\004\341juF>\010\303", 8, "\012\374\210H\310\034\235\215\205\261\207r\3443\224\300<G:\272 \230>\027\275\304\271\366\021\300\034\024b\256\337\0164\007w\335\243$T\300m\010O\202]%\306h\205\311\260B\206c\236\011\233m\305\305V\042\020\274\001[zM", 8000, "e\327,[\030\205\3270?\251o\320\177\305\134\272`\256\332~\363\017\200(\035s=\343\300\244A\231\243\267\247\032\353\325\275\256k\221\364\230\301\301\2658\260D\035\244\207>\211\354\035\220\202$:\012\345\177", 64 },
	{ "\244\276\254\240~1|k", 8, "\251>\326\357\223\360I\224", 9000, "\202\327C\273\265\315pa&\261\02517B\232V\007\200q\302i\240\265\250\302FH\230\002]\357\216\204\245\351\221\223\335\250[\0274\265\307\214\362\347_\213\003]\244\360\344\014\011\003t\226\031\016\354\034L", 64 },
	{ "v\015\177M_\312\0052", 8, "\366;\234/9\024b`\042Np7\3674\335\254", 9000, "\363{J[\233\031\001=k\307d\011w?\300 `\320\005\253\303\373\134\004Q\212\334\344} \355v\221\370\315a\314\205\236\343\363H=\357/\026\2531\024\316ZC\200D\345\212\3025\011\333!`:q", 64 },
	{ "\272\021\314kDz,\250", 8, "\1774.\331\031\134\003wT\204\366\216@\2057N\223\237m<\341\307Z\307", 9000, "\323`\024\332+\270\220\374#eZ\314\217\274\015\275\234>X\342\363\240l\202\321\3030\245n44\267\007\377\042\334\225\323>t\310\316\301\333\213\215\205N\330\274+\214\323(\342\012\336\255\233\233T\220\345\352", 64 },
	{ "\346G\354\015KEg9", 8, "\320i\372\224\255\204t\310p\216(.\260j\241\215\217\245\350o\362=\024d\323\350\364\212\010\300\351\265", 9000, "\237\006\200\214I\354\024/O\134\026\322\201i\203\031vjkO\024\234\311\351M\020\202\350\016vO\331}^\333\223\247\006\366\251\260\3661()\027\322\361\350v\310F\005n\337\277'\361\327\220\330\031\374\037", 64 },
	{ "\350V\321\365\262\311q\250", 8, "\343m\037\250\273\367\033\260\306+\343\236\021\337\216;&\366\361\237\301\244\224\035\017m\033\241T\206\011\006\030\220\240\222(\226=%", 9000, "\215,\364\267-?M\243\134l\345\312s\270\224lu\363@\337\360Gz\357 =0\374\320\027E~\206t\347\031\222\371\211H\333\242\210p\371H\023E\262u\004\042@\250\341.\316IYA%\364\010o", 64 },
	{ "\134\012\274\273\331\3564\247", 8, "o\2669\261\335\134\307M'\373{\361\367\325\253\331\243qy\316^\031\315\223>\024\007\177\375L\216\001\272Y\235\246\340\341$rG\352<\203s\255%#", 9000, "-\017\003\263@\273\011\274\3138Fx\036\312\320/3y\26458\035V\222\376\004\312\330]\263\317*\265q\324\340a%\016\214\241\255v\033U4j\006\002n\346\014\326\011\211\201\237I4\330\034\0002\335", 64 },
	{ "\276Z\205\372\215/E^", 8, "\260X\264\010\316\224\021_\014\005\246\0046\005I\377j\356N\365\013\253}\007\250BlGu\224\027\37541\352\316\3704\305\024\343%\037\342\265\236YA\200\005j\352\203\254\315\237", 9000, "\266t\3301\355\364\233_\353*\333\220Z\007\360\343t\343&\260\036\334\201\254\335R\373&b\237\027\221\343]U\304\212+\0367\307\375w\250\227\233\042U\227\215\324\017`_\254\3125.E\002D\321\200;", 64 },
	{ "\226\005\201\252\315+\266a", 8, "\377\315Y\201\220\361\037\222\262r \237\226*r\005\236\225\036\323\313(n\257b\011\330\357H:# \321\271\344\202,\231Q\016\013\034\222\003\364\205|m\335\232\0172V\355\275*vH\262\177\205\307\210D", 9000, "\234GS\240:\220\213\346l\004u\204\234\243\351I\370\260\375\010\201\035\223_E\354\271v\036\250\266h\227[\243=\337\315?\220\3253\300\366\346\024[\307w<v;\233\235P$m\005B\022sp\326'", 64 },
	{ "8\260\371\214PU|Y", 8, "q\301\012\024AGM\017\210k=\134\332hh\227\354[\332\273\220\213`\303~\344\250\232\231\312#\227\236\335\244\276\202\223E\350J&Y\253\342\262\254\334\215$\306\003\3649\202IF\251\224\205\230\010/>\325\313y&l\027\010-", 9000, "\307\367\342\016j\337\217Jr\210\226)\242A\315v6U\313S\042\025`\335\346\002\240'U\312\342\210]=|DZU\253\237\320\235\264\311p\200\221EP\311z*\207\267\305J\273P\033Utu\254\300", 64 },
	{ "\347H\205\004\340w\177\321\313\337\042G\204\274\033\334", 16, "h}o\344Iv:b", 100, "\037 \023\347\332\024\007\042\036e\253\276\016\270RM\224\223w\012i\223\305\2474]_=\257\303.\331\025EqB}\214\204s\253sD\037\317b\034\000\376e\012\340V\220\224\00532+\024f\206\032a", 64 },
	{ "S>\007\330\027\271yp\211\357\017\246\200q\302\376", 16, "\266\042\300\276\377Z\362X\241\271\005\257\355l\232\235", 100, "\320\302\134\002$F\034\315\343\211\010\256\264\222\021\363\177\003T\030\225\027\333\376\213\256\357\202\324\272\350\201\3161\233\277\327\04293 \332>?\327A\377\361\265b\274\202\246\3123\236\366\001g\211u\223\354\354", 64 },
	{ "B\031~Q\003^\310\367\210K\014\256\245\202\316j", 16, "\015-L\002\032\352\005\215\322f\024\344\3559\360\273\222\336\347\221\356_c\320", 100, "\177\207_s#\007\301m\206\013\2300!\365\000\2125o\261\376\343\365x\220\313\356\264p\304\013\033\306\354\246}\304\004Z\311l]\002b\362yd\013\234c\007\340\262Bh\001\013\314\364\021l=T\344~", 64 },
	{ "\245\360\247\005\370r{\215\303#0\353\344>\002d", 16, "_k\016jF9i\254\253\026,\251e\003\315\3136\016\023\213\337/\331q\343\356n_\355\242\200\231", 100, "\303\207[\317\226\277\341}\225.\324<\006jL\035\372\247\245\332j\334V\015\266\012\366\273\213;\213\275\021\020\341\271\325W\277\303oy\260\215\021U1<sqH\325\365w\267\330\012Tq\007Z\212u\355", 64 },
	{ "dC\335\234s\307\200N\275\374+<\344\034{\377", 16, "\265\260\003\355\317\205\027(\201\346`~\235p\222\253d\337\356\202B\315\257x\225j\242\365(/\2146\203c\3558X\035o\004", 100, "\373er\245\374_{\365\002zgBZ\361]<\020%\255\215Teg\011\371&K\304\355\307C\203\377}\375\022\325\237\274O\200F\177\015\322\347\264\0151\034\360M\206\264\235pc\177\345\005r\012\2779", 64 },
	{ "\225\204\264\2129\205\026$q\227\006\221\250\330-<", 16, "\006?E\232\340\334Y\3517\213{\017\315zQ\274v\3122;\237\031C\012\210! \364m\361\331\015\267c\014\207\236A\271\002\317\260\036\231&x\202\253", 100, "\240\034\354\377\037_;\322\013\3704j\021 8\217qT1[\014\031\227\213\350\377vg\370:\032LR\260\336\023.\212\023\2658q\244\232o\256\014\374\002C\341\342\017x\364\0322y D\315\042\332\230", 64 },
	{ "\204\307\332m\134va\332\276\322\307Q~\2166\274", 16, "~f\344^m\013\033\337\034\014\225\035I\244\260|\002EsJ3\005G\333\2734\377\362\327\375\010\271\201\227(\376\325\352\346?\024\354F\236<?\300\035.\357\354\226\035?\344\242", 100, "Y\376\307y\275\304\3730\355J\022\305t\242\272;\007\313\370m\251`}\341\261\266\205\321\203\262^\256b\346\362\010\371;\241al3\177D\016\014X\026K\363\235H\373\216f\022\134\325)\026@8\272\374", 64 },
	{ "A\003*\333\311\305\365L\134\232\373\332O\371\312\275", 16, "\372\011\216Z\3042P/\277#\253\315\177\261\300\026\2136\222\310ekk\263\032k\033qQ\231\222\030\134\341\377\241<\277\024\032!\014V\357e\276ck\020\307\327\373K\217J]R\017-LB\022\253\202", 100, "D\244_!\201\266\242\014.\305L\262\363B\210\251q\246\236~\205\361\177\332JaZ}\006L2Wp\333\234\345\301\351\236\234Y\273\034\300t\203\002\2024\264\355\246\036\206\014\035\251\342q-\237%\204\241", 64 },
	{ "%\343yf\223~F\304<\227j\221\342\233\327f", 16, "\2639\134\317\005n\321q\237\270@\327\264\255\201\016u\304V\134\250TtuI\245N\266\334:t{V\327\022\302@\260!\362\016\2506\367\007\223Gx\023h\341\266c\336B\376\260\001\242\007\235\273s\370\266\261\242\326~\354\245r", 100, "M%S\014\270\306\265\253@\253\036(j\216\223\233\316\325\341\324\020c3\324A7\352D\215\313\035\333p\030\310\370\034\276\023\376\026\345\357U\3515\355\375L\005\002\304\333#q;\262\244\367\207\235\2635\363", 64 },
	{ "\3161r!\203\342m2G\011~\365A\246\331\270", 16, "1\257\201\240\223\217W{", 200, "S`\203\030\240\261\241\304w\301\302\276%\035.U\225\224Vjts\352\005a\230yiJ\355\217D>\333\205D-`-[<\335E$V\253\014\213mg\267\355k\262\211(7(\016\003\036\231$\257", 64 },
	{ "\3746\000\2150\247\037#\313\331\351l\012\333\247A", 16, "\234y\004\241[\363vH\207.\227X3\234\366G", 200, "\314z=\265I\243\201;\010\234\015.\042\377\265`\220\223M \006\234\276\035\036\2571\322\237+~C\241qv\223\006\223I\034\225qT'Q\232q7\3102\336\371\271\237~F(~\350\317W\236D\000", 64 },
	{ "\305\363\361\241\301\257\317\177\3327\134\252\316f \307", 16, "\324)\212\012\226\034\330\315\313\323n\361&s(,\205\322\034\211a\236\335\375", 200, "&\3403J!17\345\026 \211\235C\025R\212\177\374\273\343\027\3772\026}\232\347\016\362U\352\025|-\373V\300Q\221\003\317,\037x\334Dq\230j\277\206(iW\037.\336vJ\230W=\013\376", 64 },
	{ "\342\015\026\337\254d\021\237\010\216O\314\271\015\202>", 16, "\272\010\351vz\243\205y\234\345\354\262[\353^z\346G\324\177@\217\357\252z\254\354\240\241Yb0", 200, "_\235S\033v\365x\3567c\255\216L\267\200\307\204\006\365\271\276>H#\260\015\335\025d\000\230H4\255\365\264\370& \204[\345w\035ne\301\254\312\246$\213\345\362\261\256s;,\321\304\371o\333", 64 },
	{ "P\220Zg>x\313,\234\260\240\262\260\351\177{", 16, "\3762s\2309\276B\215}-\215&\363Z\374\305\233\325\203\254\367\212\250\266H\222\002\256\362~m\374mr\354\305\317\330\215\214", 200, "B\2700\007hU\301p|\227\275\342e\005%\374\023D\242x\311l\0344\211\256k(\264%\011\362\266:a\305\330\252\320\303\365uh6\240\0033\271\236c\220M:}\365|\210\010\305g\000\364\027\347", 64 },
	{ "\032\222\254\003\000n\311\010x\225ny~\226p\016", 16, "\303\3346\310>\2656\271\251L\272\243\007\315\221OZ\300\212q\335\367\246t\234`\213\214\347\332U\340\352\275\265\134\354\203\333( ?\256\304\035D\012?", 200, "t\301\031U\330\0141Jw\010\027\212\334q,\306\307\313\354\177L^h\376&\033\310-\231\220\273=\277?n\201>~\0263\216\012M\341\224\037\034\244\036:\325\017\2024\230\342\006i=$\3546*\243", 64 },
	{ "z\012!\011\346\202\316+8\217e\255\023>\350\221", 16, "\177\015\264RK\134=\005j\210\255\202\373z\327\304\377\027\267g\254\3139\333\354\215\273\177\0112\237\327\343D\205>\213\231j#\235\355\363,\237\315t\021\335Q\300t.\346v\210", 200, "\233c\377\253\202\010\203\256\372\357<\200\231\334\3074\207\371\232\243\206\023\212zj\272\273\216\217\210f\200`\031\202Z\337/\2467?\177\226\321\215\300\216\260\222t\320i\361\012oT\017\302\340\353=\302\240z", 64 },
	{ "8\346\2320\027\300\302e_\224V5\347!\037<", 16, "\247b\235u\341\201tX7\372$\260M\312R\344\275\241i\233\255\253\030\206\256u!\334\201\275\202\042\036_\237\335=\031,\015\230\372\303\224\312\334\220V\035\323\226\340;\177\250v\375{k\344\331\255\214$", 200, "\216\323\264\300\362\373?\027\346\000\323\275\267q\001\222 y\303D\366{@f\034\226O\234\341\216\230/\226\324\034{\001\264\042\326\357\015\360\037<Q\210%\374\261\022c!LDvL\335G1+\005A\332", 64 },
	{ "\207\216&\025\344\223`\034;\343\303r/j\007\313", 16, "\204\266\035\374\206\335<=^\3426:.\200\320\024\031\320\303\351-Z\265\253\212?`\036u\215\220\334\031\327i\267\261o1\134\274uo\002f\212\365;gb\344\302i\2514Ys\246~\0047\022\201_,P\272\221?\276f\323", 200, "U\012\365]\223\021\2637)\033\005\011\374\134\3653\207s\276\134i\351\3359\241e\033\344\370\3560\225x6>\362\2602\306\277.s\244\001t\346V\333\016\3111\015r0\316\005b\330s\204\317uxc", 64 },
	{ "`\204\233i\237g%EA\265\241\220\240\311\271\277", 16, "\007{\3171vCb\215", 300, "\231\365\3613x\302\240\021\024\331\3726O\333\340E\304 OVy^\0121\360\353\237\210PM\261P\011\325\311\307{ -\307\016\204R\300+\003\324M\312h\003\304+\251\214\005\205&\002\252\022\240\3702", 64 },
	{ "t\271\276\220\376\026\002Q\320(\350\3108\032\234\227", 16, "\275'o.\375\363f\266\245\373IN`\331\016]", 300, "\234\203\367\265\303\221\335\243F\363!\225\007..\177v\266\321oe\227\013_/3\032\330\225d3\233*\252\042A\323gR\303}A\374\300A\353s*~\205LdO\305\002[\201\204\033>\244\207\330\030", 64 },
	{ "\200|\315\327\367T6\016E/+~\016\267\042\366", 16, "hR\302J\352\242*>\306R\202R\354\214^\317\216\270\277\014\316\322P*", 300, "\215.\042\007PDE\315\3073\355\007^\2619\323ET\250\004\334|\364lQ8\020/f|\206\344Q\010p')\013\220\277\231\362\272\00462\344r\211%i\273U\012y\346\322<\005s\204\017\200\274", 64 },
	{ "\302\354a`\2242\277\372\213\134P\021lU\200u", 16, "\320\311\272#\313\335\306\264\251J\255lR}\002\273G\3006\371\205h\235Ah-X\001\312\3341\027", 300, "\022\220u_\275S\011\301u+\222\351\307~q\226\007\233d\231\276\026e\251x\3123(\243B\227\021\215\277\031\315\226\315Y<\360\213$h\203\017\266\335\024\247cSC\350<\340\303\343\237\241*\200}\265", 64 },
	{ "/\342EJ\341\2354E\202N)\376\311\231S\231", 16, "\266\012\010\366\027c\3434\364\272\373\260 \263\207\262\344<U\207\134\236\275\014\331\313\3632X\310\306\217%C\202\240\224T\025\272", 300, "\010o\235\266\302 P\020_p\277\341-Go\371\362\324\202H@\231\2337CqY\367\356\355\311\026\343e\022]\372n\221\234\277\2640{+kO?;2\335M\275\315\377\217q\234\337\335cr\263\314", 64 },
	{ "\224\327G\362\204r\233\256\261Gnu\317O\267\307", 16, "\365\332\350D\026)y\270\241n\252\364\375\371\006ke\306\342\255|3\220/\017\231\256\330\355\211sj\247\274\016\365\243\213\037\206\010\221\273@Z\224Fo", 300, "\347\2317\346\344\255\016\300\025\002g\226U1\252\233,\335K\134\347\336\336hw\202\250\270\204\204\013|a\020O\226\341F\307-t\362\342P\322\370:\376\272jRm\005\255\200\236\315\320\346\334#\212\321\011", 64 },
	{ "\014cTy\324$\201z\331\244\337\372\020\206\004\004", 16, "\265\367\261\204v5\371W\332r/\007\310-\010\204\264\022\317~O\361\316a*\2773$$2\021\321\240\372\316B\267c\323J\354\042\022l\242P\203U\243\371\216\2674\221\266\212", 300, "_\346\213N~n\353\034E!\216\2141j\031\0171\344\303\222p\301t\356\254G\373O\240\260P\215\034\345\211m\350\342\332\210\034\313d=\317p\215\247\302\027\212\324}|3\245C\242v\000\242\333\326\027", 64 },
	{ "\030T\270\036\224\037\265\023f\255\242\2064)\376\366", 16, "\035\370\211.;\345\356(\223zz\376\376\371\323\267\2034\326]\271\245\252\244\345\304\352\347{\250\030\267?\275\011\255\224\223\353\010\236Sy\2256\004h\3632\036\255\003\353\247\337:$\375\303\273~\351\260\260", 300, "aNdOT\0026\300D\377W\256\322\200wZa\276\235W\262\313Z\342\220\307\321\377\223\276\2735\311\253\353\307j\343\257-hv\200`\345_\371I\232\372\250\006n\335R\331/;\210\002\027\367\355U", 64 },
	{ "\255\021\324~\275N\274g\255\042\242/\312:\177\367", 16, "\200w\215\352\253\031\350\310$4u\376\363Z-\315\231\375\331\320Gp;s\231)\251\024x\261\354\021\353\177\024i\314\370Q*\206\345\275r\353\255\246\305\275\257\336\316\035\335\024\356\323Ya\022\301\247\202H\350f\235<\177\026\200\352", 300, "\010\360'C\342\355\042\307\216\356\335~c\037t\001\273q\357\253MK\217/\353\337\317\031\333\333X\025T\276c\252\226V9@\277\344S\360\347\261&P\036x%d\260\375'\364h\250\037\320\267\211\336b", 64 },
	{ "\032\230)\010U\321\363\256<\2418\352\364?sT", 16, "K\245\210\270<\375$\305", 400, "R\276R\016\305\241\307(PiZ\036d\234?2\255m;O\027\242\277K\006\021\315\221y\023)\003\276\341T\254\236\323!\370(\242|\261Ah\216$\303bE\365\222\020\357dH\247-_\313\013?\207", 64 },
	{ "\361\206Y\022\331\265\007\326\022E\366{\321\334\202`", 16, "^\357\274\264\322\277bu\351\034\213\220-\370\275%", 400, "\352.\227\274pWs\177O\260 \351\000G\3132n\223\231\213+\042n\245^\216D\313P\267\323\031V\236\035\225\005\365\304\273\254\227?\202\221L@\377\204\236\372\322\310;\317\267\244\356\302\337\311\326($", 64 },
	{ "\333$\332\236\256\323\210\250\276f\2306\256!\373\245", 16, "p\025g\221|\037`E\215\363\204,6o\263Rt\346\304\351\032\240\205\377", 400, "\316)\361\005\357\302\270\277=\224J\301\271G\260\373L.c\011o5\331%\222\202\324r\012\216\327\222C\214\340\354x\273A*\364\316F\351!\315\343\267\351K\005\252\223,e\346t\216\237\236ZHt\363", 64 },
	{ "\022\021\361\351Er\243I\231\314\334\325\303\352\335L", 16, "\303Vj\271t\253T\272\372\317\0070\351\013\230\031\306\023\240\255<S2\310y5\306\322\2468\022.", 400, "~\255\277\277$\336\252\037\237\347\253\277\200]\014\377\242\001J\232\304\351j\037X\307xJ\307\024\035\265\177\364\223\346\345c\3726M\344\257\255\305\210\370\361T\316\254\271\325A.\031\375[\270\027\326\313LQ", 64 },
	{ "\026\360z\243\245\346\356n\337\340G\366@\271\332\356", 16, "-\017t\0314st\365.\234\352\357\251\203X\252\134Bk}\331\231G\212n,\363\263\271\247\321YY\274\3376\373`\325\014", 400, "\316\024o\372\015\253\331\202\3058\300\201N\375!\325\034\036\377\272z\017\2072v\24190\031\344GA\241\216\213\262p\361$xl\011dJ\306Y\304\224\276V\376\273\0375%=\340\213\373\261=\200qN", 64 },
	{ "\275;#\207\242t\304G\340\257\302/\377\304\210.", 16, "\370\3540\232\367\017\205\322+\275C\024\372cY\237\023\245\257h\200;\310u+;\232u.8\300\373\225+\033\254\346{\360T\204\012\215\231\357\010\372\252", 400, "l#n\313q\010\223\025c\351\347\335\340\207\042\005<\042(\321\376\365\224\365\360D\210\010\235\134y\267\034?-\271\304\007E\364\350\351AN\214\220\231\235\374T\241:\203\0372?{\202\3554\251[\377W", 64 },
	{ "\376g\244>\237\350\271Y\245+\011  \341\344\277", 16, "\326&\352]\243\333[\211\035t!\366\204\204.\351\005\036:\260F<\210?\343m\226\035_\134\255@\016\260\017\347\033\256\377\361Cd,\343@\007\264e\177L\275f\216\346rP", 400, "\300\042\035WU\336\316\023i\201\215\215KSU\215aH=\010\332C\207\276\207\254}\373\331\325\312\013)%<)WM\330r+ \014\214\217\012c\266\023\364\330\356t\264\042(\031\312\271\312\351\3356J", 64 },
	{ "\260\354\027\023%\230\372\345'\315\035rq\356<\327", 16, "\300#\263\231\336\337J9\346\354\007\273\351\244z\013\247C\342\337\042cF\221\022\221\203z\200\244\323H\015\366p\364*1\2271\134\326\377>\002{\260:\242\224\323\035\211\002\277\347\246\227\237\223\315\315\361=", 400, "/\015\317\021n>l.\252\256A\340'/\327vM\233\262C*\241\361\036\353\203sjK\003\007\331\361][\204\3643\237$\234\353\205_\206\226\337\275\375\025\255\314\263\250\311\244.\362P\336w8_\344", 64 },
	{ "\366\317\345\225\251\365g\205\211\324*\313\001E\314R", 16, "{-\027(\230\231a\371\302\271rc\302\204\32402\204\312\005f\227\336R@f+%\250\372%\023\340\002!\203\037\237!\1346\012\355\345\246\020\346\263\204\204\222\356\221\2334=\3333\364)bs\242\314w\001g\214\212\020Gq", 400, "\212K\270\302:\017\317\343\266*H-\373\241\321\200\021\204y\276\272\252\347#\333V\025sI&\325@\337\015t\312JR\312\222\243le-\204\354WAi\364d\353\364+\023\376\363\210}\261\236\242\262\222", 64 },
	{ "'\225\026<J\233\370j\177\376\303\004t\245e\022", 16, "\323$\345\255\0226\340\213", 500, "\207\004\3713\226'\232\001B\245\206d\217\341\347 Y!\202\231\271a'T\235\207\332j\275\276\325\345\352_~\362\233)d~\343\222e\257gc\024\254\007AS\227\304\265\244E\211,A\256\355\341\314\276", 64 },
	{ "\347\0059\307Jj\001\214W\314\346\300\014A*\227", 16, "\030D\250+\305\240t\201\316=\314\036C\373\356>", 500, "\341\213,\254\202dg\312T3&z\363\354#\350\301\204b\302\357\253~\315a\342\235Z\206J\002\341\042\004\342h+\274Z\305\350.8^\377C\241c'\231+UI\216`a\002\203>>H\276q\330", 64 },
	{ "\355\2508\036\235/\211\331\356\0223S\2121`\224", 16, "Zk\3217\020B\320\302u\222N\357<B\030\230+\232\373\236\336\134\231\264", 500, "\001\247\340{\214\204N\310\016\217\020\307\007\246\214\327\017\226\200.\277Z\001\314\020\011s \033s\340Qu\304\346\320\032\254F\221\326\311\255+\274\320H\013\013U!\315\2352cI\233\205\260\333 \211\334\332", 64 },
	{ "\031\234.\215%6\373A\206\272\274\042!\317\217f", 16, "\203\177'z[V\001\351s6(\367\212\325\3164s\361\322\310\372\371Q\220\322\255\257\262$6;\335", 500, "`\377\010'\332J_ra6\325[~\314c\333j\243\377FA\225\376\327\037\274\327\365\002\017\006\026sa\352AI\246o\227i\341}Cq\226A<0_E\271L\346\334J\272dz\240<\235oG", 64 },
	{ "\303-i\022C|@\340\327\022\203(H\212\244\226", 16, "\231\266$)L ]d\015\036\027#\214J*\247rY\216\341\016\031\205\177\232DC\267\236C\001z\2371\035\323ssq\243", 500, "\273\316\217\230&jG,\325\217\215\346\002\367\221s\021#\321}\316\034R6U\345\255\2170\340\2165,\361O\177K\230n\0052s\036\260r!\223\303\027\022\222\225@\213\015\275\351\311}\252\343\237c\321", 64 },
	{ "\275\363\307\201\216\362\240]\211\024\371\235\235\213\011s", 16, "f\233\330\275\352\231X\307\247\341\276\021\325M\352YD\255\273\001\230\255\026u\212C\200,j3\267h+\316a\377\030\215\211\002\002\213\247j\011}q\336", 500, "~6\341PS\357\366\303\206C\341\272f\272\250k\364\340z\366\317!\134\002o\320\245#\301vrE\331rMX\026\334,\350\323}k\267z\177\217\367\210\011\260KX\224I:\370-\247i\263\337\236\220", 64 },
	{ "\237U\344h\375\271R\302\302\204\203\331\253\234\252/", 16, "\207\254\042\210|\022\345l\012\364FJ\255\331a\0066\206\257>UBC\364\221M<\344\210Rq\254\327[v\266\347\251Y\022\367E\376m\303<AR$,\253\357\3070-\010", 500, "b\0106\220\000\252\277^\365*\214\346m\265\326?H%\311r4?\234\030\033M!\031\213c(\246)c\367R\020\010\241\002\331Sl\274\313\241\3309\366\007\322\325\300\344\013#\020\213\360E_\016{O", 64 },
	{ "C%\004\016%\275\272D&JRYE\310\023w", 16, "\314\337\034\217\005\224]\007\340=1B\302\010 \254\032\325\320E\254\014m\017s:\276\247B\024elC\227n\134\177%\345\317u\023[\337\266-\367\304\242\020\275\243h\260\016h\0057\335\325p\307t8", 500, "g7\263\346\134\244\212\267\377\264\312\244#\244\367\213\263-\315k\231\210\243hw\247mF\321V\334R\322\311\253\376c\214\320\360\351\253\373{\0300\260\021j\254\307\267\220\232\006\367v\026\020\042\246\314\252\230", 64 },
	{ "\042\244+\354\317u\022\256xC{z\200\365t\203", 16, "4\260be\177!A\327X\275\207\035\252{Yy\267X\274\216\245\322*\317\335\236\346\216a\311\201\215\310\042\007g+\273\033gm%\365\012\245\255w\206t\353\216\303\032\342\300\266\216\223\017\354dzH\347\356\321m|xh7\264", 500, "\272\266f\004\021c\344\271&\275\332\340owE\221\0426\230\213\236z\337F\246\215s\327\036\042]\314\276e\021\372\267KY\223}'\203^U%\216\340\377<\376\341\272jhn\340\217\314V\343\201Y\367", 64 },
	{ "G\372r\346\225\177\025\000\241\347\316a\303l\340\260", 16, "\273\360'=o\001\332\206", 600, "kX\276\343~\243\351\324\017\035\024x\004>\332\134\270\020\332\333\026\224\204\367\254\362U\011 \324\276m\330 \032\222^W\2304\345F\005fw\364\277\322VXJ\345\0167KM\213\022fv'~\032k", 64 },
	{ "\134\244y5\2355\245\326E\016:R\206\032\334\202", 16, "\233\364\201H8\215y\376\014\277\016\334\013\337Jm", 600, "8\337\036\337\322h\016\272\377\261\302jZ\271\312!F\372\364\327>XPTg\232\226F\021\362\024%~\371@\314\226;\026\244\2356\312\134\134\236K\217\243\341\0052J\304\014\354n\205\321\365\256\214t\337", 64 },
	{ "Q\361\217DR\030\023l0f\316\321\317\370\000\270", 16, "\210\323\252\322\0060{\223\006\022On0fm\202\011\315\357a\031\373*\317", 600, "\300\241\266\226\264\202\202\216m\0166|\321<:^\367\256B\327\211\036d\030\002i\207\311\322RSC\252\303G*xD\203\213\003\343\252=D\261b6\033?\351\257Y\251\261)\254j6I\203e<\333", 64 },
	{ "W\240\211i \373\342$O\315\042y\243\371o\203", 16, "m\225\254MJ\265\037\231)\021\336\371\254\253\256\317.\204\210N\300\226\320w\354\021G>\014\256\310\034", 600, "\373\356\000o\004\330\262\234\262\250\346f\212ap\337e\220,\007f\333\202\270\253_ms\351\013\373\234\251j\204\360\033\257e\344\360\200A\324S\320\251\235)\015\013m\202\206$eE\370\243\001\014\221\300\275", 64 },
	{ "\305\337\271 *\214\274\272\356\013\307u\215/<'", 16, "\323>\273\2563S\220)\265\367\346\246\002l),\025\177\027f\332\223\014\004\260}A%R0 #Z\357h\340e\261\025>", 600, "\333\224\212N\256t\331\335\002\315\266\324W\214\017\016\273\250\303\021\326\340\016fC\015&\305\213\266Pi\261\344D\325A\367z\251\326n\321\305\2120L\324v\006\262r\320\211[\023\253\301\330\376\017\245w\000", 64 },
	{ "\227\317\337v\243\316\223\362\003=\022\307\243\250o\216", 16, "\247\270\205\312\252b\325\344\227\372q6\3660\004\035i&r\212 \253\177\211\365\034\207`\213\310&\005\307zo\332\363\344R`\217\267\270l<\275\321\317", 600, "\312\021O\242AA,?\251\335\207\244\357\274\2753\020\006\321\240\362\262\304\253\210\370\231>\323v}\335C\000r\362<d\2412\254\241\200\255MC\372jgIc\271\347\362'\274(7\004\254\330\327\376\214", 64 },
	{ "\356\036|j\017iK\004\321 \025u\242\327\244\316", 16, "\230M\377Z\240zp\210\2750\342K\023\200\005\337\264&\224~\002\340\202\222\267\206\235\267\262j\254\3448\272<I\200\307J\013N\216\277\262\203\305\200c\312\035s\246/]S\210", 600, "\276\207\371\037\244\344R\327\312\330\344\316G/\345\341\042\304\026\246F\376\022\375\236\005d\211K!\320:\037S\346;\231\220\353\275\235\256y\300\326\356\312\343\342wp5\346\260\374\233\003P\364\322\025\323\042$", 64 },
	{ "3]\266l\353\305\337\311\016\344o&\357\017\317\017", 16, "zt\201\022)\365\233\245\216\024\031\213\254\265\015Ws,J\333Q\337 \027\347+Y8\375\347\326\242\306\204$}\363\351Ru\256\234\220\212\373\3738bjg\365_\022\211\201\364_\307\267qi.\021[", 600, "\333\371\263/\027\334\204\362M\300L\374\032~)\270D\256Oc\321\370<\225\346g\327\264\031\340\347\253\225\330\226\015\016\017\250\200\200\364<miJ\036\316lR\254\211\221\303\366\016\312\206\326\357fg?\017", 64 },
	{ "0\206\034\374\010\323=jw'\222\226\216\022\313M", 16, "-\231\206v9\237\214\223\304\006\237I\322\361\314\354%\234\204\217\223.D`\341|SU\226\007\327\342\2041\3539\310<2J\332\212V6m\301\313\322:12+7m\225 U\2731\245\333\305\262n\225\320\237\242\223\035Ax", 600, "\334A\033H\030\334\327k)\024\377\340\202~\016\336\223u\257:A\253\360\012\033j\202\351\245\023!\236\231%b \335\035\214V]\023J\272rr\240\030\324\027\360\305$\335? t\203\017\351\323\210\225\356", 64 },
	{ "3a,\340\2156\013\030\034r3\375\351c@\327", 16, "\345\306cH\353\360\246\345", 700, "\270P\206\031\330\027\3040\266\342\302\362\324\241E\352\030}\221x\251\030\356\037\350\030\326T\377\353\026\271\217\024%9\026Q!=/\362\263|\243\353E\010\250\375bB\262\322\032\356m\277}\251E\3261\300", 64 },
	{ "/\257xg\230\231n\356rG\376\2620v\241\273", 16, "\373\236\277.U\233e`\204z<\200\015\303+!", 700, "KF\216z\177a,rjH\312\003\232\227\300Q\021\266\3301\315\221w\007\021\270\271B^_]\300:0\263\002\300\351\215\373\265\302\231t\177\220\324\223\375\252\214\321\261\207\007\337\036\347\306\245|{\227\373", 64 },
	{ "\202P\001\305L\343@\203\372\017k\254nS\370P", 16, "P\322\260\346j\204\250\374\341Q\234p\226\200s\034\334\351\315]\356\224G\266", 700, "-\332)\326k\210r\373U\207p4\014\030\205$C\260\206\344n1\200\227\241D\357U\363\224\321\350\025g\022\317\255\001\343\204\276\260\0251\022\270\211W\247^\343:\374\263I\355%\024\002\257{\250'#", 64 },
	{ "Y\352\246\230v.\224^\2668\252\316\337\366\3338", 16, "3_~\337c-\311\010l\313\373I_\213\035\253\311(\313|\223\264\237X\327NZ$K\335\014T", 700, "\020\275\314M\357\326\251M\022\325\023.\332Se\364\200c\0177>|f\273\246\225\314\354\244\272\260\330o\221e\233\005ea'7\336\232\232:\221S\031\334r`\316\2015\257\377\203:j\221\264d@\342", 64 },
	{ "\255\377\250\342\216\0156\217\331\352\220r\302\236\376w", 16, "\377I\023\011\206\313\214=\006\344\0217\037\034\312Q\013\303;#v\275,\276b\036\023\375r\332\302G\335\307\333B\325\374\347\271", 700, "0\2629)\037Z\226\272\312\021\215\345\266_\036\373\277\012\023\364\271%\271\272\366\353\205\322\243\220\1342<\233\372\311M\232\027,\215<\334Z\357N6F\207O#\031n\215\235<\256\333\304k\223\323\240]", 64 },
	{ "\243<+\014\304\027\016\025\023\373@\377rt@\336", 16, "\316\023W\361\200\325\241\255_\347\247V\0324U\031.\377u1F=\234\206\365\342\256\210\243\346\217\317m\3334\267\242\263|.\015H9\212\313\360\331,", 700, "B\322\302\014Tt\014A\243K\347\353K\031\364_)\340Q\356\216\006\367\275\355\246\035\362k)\322$\242jn\3077\255@\036d#\266\267\274\267\343ti\211\376\032\200x\313[\306\267\247n\222\222\347\021", 64 },
	{ "\371)r\237\3421+4\356s\277\234\343\330\212\313", 16, "\262\017\333\260\372\305\253\325SWj\350\233\231\222\372s\277\032\272[p;5\204T\014\243\017A\345\314\217\210\323&9\222!y\247U\3673'\351\266W\216N\215\265\0331\331\373", 700, "r\016\300\215\261\246E\350\234\360\035\340\025\033\206C`\206b.\326\223\367sV\320\232\006\374\227\234N\027\222\376\273\264\356\206\340\317\337>\237\266r\207\206\224zp\343\335b\333\237k\240\306\204I9qF", 64 },
	{ "\351\236t\270\232A\203a}#a\340\217\314\235\246", 16, "\345a\00716#31\263\314\220\255\005<\306\277\3574;\025\004\341\323\215\023\210l\373|\226\234\251O\242\2334\311\336g\260\033<\261\236\237\271\357\230\035\273\016c\212\200\3406\361g\022\263\030\311E\277", 700, "\300\270 \346\234{<\357^\225\303\255u\351\042\254\267A6\032?\023\251\226\320\361AToOc\201\220\335\241\276\363.\277\227G\042i\300x^`\230\253\247S\205\231\2700\370]\304\343y-\134\262\274", 64 },
	{ "\326\315\030\330\327m\324g`\357\314\374,m\313\027", 16, "\222\231=\273\242\212\226\031\325\251e5\213\256\244i\036\370\247\361\2530\377\372E\244\265\367\346\251\312\300<\304\221\035\201<nh\3467\037\326;\016\007:\002\2045m!\042\277q\361P;\337\026'n\3731\177\2606\316\216\205X", 700, "@\315\352\037#l\270<\236\354\360\376\001\335#/l`\305\375\013\027\021\334m\221^\377\220\222\202\226\314RWq\3007}w-\035\025}\243J\345$=4<\302\272/\351\356\006X\3256\025\0113\000", 64 },
	{ "\206{K\024`\326\224\214U\327Z\207\266\012jO", 16, "\340N\030\355<(1\034", 800, "\270\207o\260\013\311UX\253\004!\317\203\251<\350ke=\300FyfU\346\253(\3346!,j\266\002\251)]\207\232\312\232%\323\310j*4\342\213\243\246H/\012\002\207\030\316\240{c\245\213W", 64 },
	{ "#\010-`\240\273\343zl\372\213r\261\371-h", 16, "\231\006\305\205;Qm\210\275Q\263\331\336\020\324,", 800, "\267j\314\261\015\207\272\237#+4\205M\254\237L\352\2248\337\026\303\004\220\262\232\323\004\212^$Wy\042\266\313T\345\374\305\376/\227\334\341\315\317\364\370\134$\247\270EC\237\365K@\356]\002t\024", 64 },
	{ "\034_M(\213\033\010`\253=Da\352\231\014\026", 16, "\356\204lV\262b\024\340P\306\373\273&\204\203a\251\004\316\371\253l-5", 800, "\205ek/~/_d\023q@e\205\327\240\226\215J\232K\345'\377\256\334P\226^(\220O\255*\227\257@Pt\323pP\375\010\234\177h\264\032\254\031\356%}.\257\2040\251\331\334\226\262\202O", 64 },
	{ "k\264\374\363\246\260\027[\226\207\201C\327\200=\342", 16, "\343\360\005w3'\253\362\353\030#\346\254\254\227=R\274\230\001\177_-\004d\320\317\263\223g\027\013", 800, "/\007\331v\327\007\365\277\237\361\200\2643\235)9\247\320\371vm\216d\236\266X\262 \3254\300\005RSI6\260B\277m\032@L=\207l\256\036jw\365\236\215\216\365i\305\001\037\213\262\236f\237", 64 },
	{ "\3144\231\023\012\010\377\351]5\341!\252\026m7", 16, "\332u\261q_\015\003\347\370\330\274?\202\316\336'\223L\346w-\024\346\236Y\363j\3019\211e8\304\006\241I/V\247\277", 800, "\016\262\272\311\010\201\270c\006Le\301D\362sR\274\010\356\231\275\002\260\267\374~\233M\134\217\204\233~\360\246\042\305\015\230'\233\005 D\371K\231NT\323M\362\206!\0100\316\247\202\333\233\2570N", 64 },
	{ "\264M0\374\215\246O\340h\022?\042\326x?\254", 16, "\330=\266\357\362\233\013aM\377\273j\317\366#\342\240I\267\323\203\264\233\362\341]\261\011\206\035\345\234\372\247\015\322\205\2212\2123\363Y\274\226!\270$", 800, "g\350\315-uW\360\247T/_AH\336R\251\355\374Q\274\361\257\353;;-\303\341\252\006j\3071\334P\271b\374\306\272=\301\274\317!r+\322\342nAO\223\260h\254\270A\217\360\221C\020\375", 64 },
	{ "\262\234\242\024\023\246;\320?Rm\313\203\134\257\253", 16, "\011-L\245\210\020\275\003\265.\006\325d\005Q\012j\325{\357\312\007\036~\324\011c\203A{\363\010\244@I\276v4\330a\316\234$lL\351\227Ml\033\245\016\035\350\230:", 800, "\362~\243\251j\037Ef\332\032Tf\002\003D\254_\361\220|8\325\177\304\021')K!\230\226\006n/.+\354\236\007\264\0053\3451o57\211x\217\033h=\360&\255+\265\242\217;6U\302", 64 },
	{ "\244\034\321}s\264x7\325\015\366j\037\3222\011", 16, "\345\345X\367~\021\235\341#\225_\305+\326\310%\346\200w\004\340{\226\226\021\014M\2509\013\242Q\012\206\035\234+\2672\214\210,\306u\004;\345\303\002\221\231\320\037\310w\300B\327G[\357#?\231", 800, "l\017\322\2302z:bu\331X\333\236~\227\337\255\330\345\364\335\016\305\3370\243\275n`FnB\346H\134(\025\022\231WJ\037\253\212\245\210U\354`\0269\354\246\243\213\275Nqn\352`\2649\004", 64 },
	{ "H\235\224~X\271\344\241\303\035`\265\0324\2460", 16, "n'\340=s\250u\025a\267\361\030n\326o\357\255\021\313\2600g\200\222\277zL\370E\223\277\357 \340\030G\207\031\007\277\227\302\233\254\320\375F\370\262O\303\030\262-\216\214\042P\323o\2002\337\220\334R\314\372\223\007\373\207", 800, "[\316\226 \270\134\257\204\241\336^\273\236\332G\333\214\343<\2759\037\202)j|\233\310\032)\214w\207\264&\335\366\214\352\370\030\343\353\2047\327\353\255\027\362\351\361m\264\226\227\207 \270\260]\373|\027", 64 },
	{ "!\206i\223\011X\356\016B\030\270\305\207\375-I", 16, "\027\240;R3\271|\332", 900, "\360*\314r\326\366\254l\023\203P\222\026\371'7G\375O\250\016\245b\267\277\233\320s\256=%'\254\316\353\023g\177\235\210f\206\351U\336\3409\312E\221\205\321\335cD\350,\325>\277\342\304\015@", 64 },
	{ "o}J\242\212Q\201\317\222\006\331dI:\362T", 16, "\227\363\374\030\2151\324W\373\366>QP\367\032\315", 900, "\374\010\253\244u\317\244|\366\2348h\341\373\322\350\234,{x>V\036\006\266m\042\374\335,\351Vl\376\341\026\000\233\302\021\013u\274\246\363#F\321\234\226A[J\323\253\371\201\344\306\312\222\300\232!", 64 },
	{ "fW`\315\042.\323\234/\024e/\235.\367{", 16, "\377\001Rk\017\237\367\371WR4q\271\242\200\034\374\224\224\026\371\3056\305", 900, "\314e3\234\224\216\231\334\257\005\354\223\241\322\363t\134 T\343l\246q\237[\300n.\014F\207I6 Hp21\271l\244b\023\352\214\356\331+\331\006'\321\215\301}\223!\3318Mp7\005\330", 64 },
	{ "\365\016\371I\230s\357\307\245\037\373\023N\2579\236", 16, "+\214\007\212\252%\034\006\337Z\013\267\134l\211\030\302\271\267\376W\014!\370 \354\272k\013 \265\035", 900, "\026\345\251\321>\361;\226\251\251\277\3261$\233\224tk\373\011h\030\256N\030\314e\352M\2200\273\341\351\350\302\257\03796Lc\3615\215\033J\326q\347\364T\0232B<\015\202\251b\021\352\271\224", 64 },
	{ "\357\305\300\016h4\217\213\205|\365\275\2402M\212", 16, "\232{\261\235\227\366}\037?xZ\217{\271\352\3539\3628\370T\207\370\222\334\221PJ6\237`\235\343\020n\323\370}+\025", 900, "\006An\011@\267Z\023\026aW\274\002\263\316S\006\374\372\362%\003\357C\355\307\202\023\266YN\245\361\324:\311\201/Pa\342e4\2122\203\255\312T\201\243l\357\337}\361\302\347\034}\315l\007\301", 64 },
	{ "\254\373N\035\251\017\360\304\005\333`\256\301\240\351\020", 16, "\257\231q%\353\262\257\37167\260\364e\222*\0135\242\214-\263;\011\232e\237\221\202\026\352\334\034=\326\346\246\016\353\375hH\020\2666;\276\254\254", 900, "{1\200C\304@\350\255\323d\266\042|\2019\262\264\177/T\362\020\346V=\032\360\226WC\234\260u\244X/6\326\202\363\025[\327Y1\240\243\030\373m$Yp8\220\272v\321]\361\343\305?\226", 64 },
	{ "\200\323\244\005\342\327}\330\0329D\266v\037\332\234", 16, "\305sYC\035z\357\246\025\315'\376\305Do\345\022\320\016L\321\236rW)\0128>;\042\215\2640\244\370\245\271\312\220\222\211j\247\323\252\324\252\316G\014\307\303\220\026>\241", 900, ":\015\356\340\031MC[\210\244\201QVg/u5\331\215\134Q\277J\322E\306\222\372\346X0\210N^\207'\300I\345\011\020\366R\014\177\213\037\3425&\252>\264H\316\335\235W\264\265\256\3774\002", 64 },
	{ "\033t\350)6\260R\333\031\346'3\021x\014)", 16, "\317\036\207|'\372vD9\324\306m\004B96\364<o\007\317f\274e\355ty\341;\311#\031\311\203\321\341\034\201\373\315\352\353\302\267\361\034A\206=\353&\346\367\260G\220\013\244\013\030\334\254\257l", 900, "t\261\230\3379L\220\244)\266t\031\022tW\027\314x\205\017@\345 \027d\006\211\266g{k\255a\031C0\253nVA\025\215\257\027P\376Pc\316J\341x\273\272\241\332\315I\360\2035T\264,", 64 },
	{ "\320RQ\307\356\3355\246\351\031\230\013o)C\227", 16, "\273\250 {\345\241\252\366\333o\345\2065>3\007/\337\212\015\042\015\317\022\375\3434\3669\266\243\234+\336\261\234!@P\204\377\220d\236\370\254\370vx\312\134\017\204\3509\225+\034\351\024\267aH}p\364fW\006+;=", 900, "\023\234\016G\310\260[R\353\236BW\207\317\016H\245'\203'\3209L\0148\230(x\027\337\025\256\355&O\2170\024\177\312\200\005\320\365Z\353c\365\207\333\134\264?\321j\0170\312\263\366\350\2733\030", 64 },
	{ "}\026\215\320q$\364\307\271\035\234s\210bw\265", 16, "\260d\255\307\300\313\321\370", 1000, "ko~\027fI:q\276\226\305\216\270\317\010\340)d\020\353l\010\274H\013-\306\331\014\277\252\254}\007~\371\327{\352\216\255\211<\366\221\201\311\001\340\267JV\227+\347\253.\222\200U\317F_\276", 64 },
	{ "\302\316l\266\270\312\0316W\200lJD\344\263\264", 16, "\353L\235\037:<\341\377\357z\035R\322\221b\010", 1000, "\357\261'\225|\274\201H\253\332.\240:\2151\3776\250\032Sa\351\3659\223\366\240H\200\2439\007\223\240\300k?,\004\203$\200\220M\236\202\314\032\321/\231;\210\312\013\214=U\0129\246\247\347\324", 64 },
	{ "\351%\241\263p\261\200\362S\377%\206e\350\237p", 16, "\347x\025h\232\331\240\015\006\035\273\353\233\001@\004\177>\254We\361\353\215", 1000, "\302\000\266c\330\375\3350W\022\272\3446\345EY+\311~\244\0162\006=\353N\212\343\257/-B\271\270\343!\030Q\210\242F\307r\276342\261F[\342\337\277\321\217\360v\015\215\301\005\367\232C", 64 },
	{ "\224U\367\245\357\276\004zv\004\017`\350\315\220^", 16, "\230G\361u\016\305\221\367\253\334\344Dg&x0\314\301/j\042\211~\320\207\207y\217r\237p\354", 1000, "{8\226FL\023\270\334N,\247>\033\032B\032\354k\010\001\373\222;t\023X\304\371\276\244\203\316Vw\352\214\310yI\010x\025\215\250}\301\027\205 .\042P`\306Xrx\322\257\235\340J;\277", 64 },
	{ "\225t\353\356\367\376\013\326RX\246\016\134D\243\336", 16, "D\006}S\362\262u\220p\364\313\365&{\346n\277\322Jv\2202xdk\230g\327\341C1\220\374\322>;C\263\254W", 1000, "\026.X\262\251\361\032\206=\326\251\214\2721.!5n:\266-\267\015\213\216\313\335vP\013\305\034*\301\177\226\010\345\030\322\213C\313\233\251n\245p*\207tO\021\022\221\020)\006\212\237\014\223\020\256", 64 },
	{ ")\035\350\023\325\370\321\370\243\005\263dm\3147\252", 16, "\015m$\343M\220\3573\304\200,C\032m\237}\256\366=A@\200\223\177z|~\263a\321\320\344=z\0229\244\200\222\253\013\224\021\265\224\023Hf", 1000, "x\351\246kB\345\355\201\134K M\003\321V\307\024\257\246\251\031\224>\244\021e]\014\262\272\004\206>\251\270D\372\226\206\352\225\273\010\036!\364_\327\244\001\353\012\250\232\227W(\034\231p\301\031\203\325", 64 },
	{ "\246\337^`\273\277pp\204\370\235\023\256\026&Z", 16, "\327 h\205i7+eN\362\265T\320\321\237\214s\036,\326\021\357:7S\302\212\253\016e+\251\253\334z]\022\256]c\007\310`\223\364\022\206\245\217O\036\251\366\214\242\370", 1000, "\346\364s\202y\026\347\275\220gk\304\232\326\234\025\257Rg\254\233\216\344a\306\225\366N\216?\276\367\032pn\364-\322\331\367y\002*\276\322x\340Q\016\354:\341\216\320b\216w:\267_\227>\274\235", 64 },
	{ ";\355],\232J\026\265\200\333\220Di\271\362\325", 16, "\217p\015\025\3636\334\234\011:\304\3378\203T\247\207\350qA\370\365\307\021\230\250\312:\214l\311~\274\220\303\225S\250\230\343hc\261\374\343gI\374JO\013\325N\271\255A\264\032\215\013>>\262\021", 1000, "Tm\271\346\333\031\034\261o\233\342G\006\277\264\2759\015$\351\352\331\214\200BL\375\356\322\376\340\337)f\356%\346Tm@\277F\027\012\315>\327\276\001\302\2576\313\244\315\276H3\346A\266\226\312T", 64 },
	{ "1\317C\247\340O\362+\332\245\006\261\2069\252\342", 16, "l\31548\373\321n\375\007\337\320\277WV\334\205Q\230:\021\010*g?\3702\004\005\306\305\324\025\256 \203\351^\276\347H\306\345=k\310\247G}\326\020\347\363\350\016\215{\023\374\357\335\2669\315\353\336\250\224\303W\370\246\221", 1000, "E66r;h\253\215\200\205\375d\261\331\275\264\330\3146o\011W\210\217NI\343w\256;\226\351\351\000h\346\340wi\221\275\302C}l{\336\272\030\177\273o[6zV3j6\007<z\301\012", 64 },
	{ "\374v\346\261\317NF\250\231\373\033\2245\2710e", 16, "&\323\263\377\023\341\277\134", 2000, "[\223\375&G\271K\011\025\134\370\0106\031C\004\026\342S~\322o\341\255\022\005C\010&a\035\2518\363\042\344*=\023@\033\366\340w.n\354\200\360\365hp\377y\245\337:\251\006\245\355]\240\257", 64 },
	{ "\004\3662\363\223\211\214!8R\001\342\222@\240\007", 16, "s\134\376\266\373 \303\003v\371\241\351\333$.\030", 2000, "{w\276SN\361\322\134'B\322\251\020\355T\370\313\030cT\330\320\223%P\013\363\241K\257\000\257G\312-=\244\213\276%r/I\367\013*\241,\303\376R\217\330\000\250C\311\371\134\042=\260g\214", 64 },
	{ "\326\177\361\022NR\032\230\371\324L\276\245\201\013^", 16, "\205w1\025*\032d\307J\134\335-\314s\313cb\227Np\367J?\200", 2000, "\347S8\233X\213Z\345\247v\342\237\354\302\025\237`\315\204\221A\253\245\260\327\275\244\300\0167\216\307F1o=\012\341\207\307\305u\220\340_D]5~JC[$\254\034\005O\336\036\232\223\253O\007", 64 },
	{ "\032[1B\237\025C\314\315,y\242c\361\363\201", 16, "$\344\215n\370\134\225tJm4\011\012U\004\201w#\034\273)^\236\202\334\266l\232\205*F\333", 2000, "\0323i\231\017)\341A\202c\335\200H}\017v;\037\226\036P.\270\205\035\000\372)\257\023y\340M\277\232b\000\037\341\266>)L\244T\025\256\353\2726\023\241\3501\221Qz\342\001S*^\327x", 64 },
	{ "^u\024=)!f\324L\251Z\200\377#\134\362", 16, "\224v\363\204\345\353\263&e\242g\310\227\323\231\370\320\350u(3>\346\013?\3316\360n\316\2560\032\264n\003\177\352b\360", 2000, "u64\012\241KEM\001(>Z\237\042\027\240\361|\252\216\357\214\017-\302\002\365\224\355\277\351\033\011\030\324\363\034\320q\340&F4uCc\235{\347\013l\2671zB\025\236\3174\215k\361IJ", 64 },
	{ "\256\002\200\356\321\334\300\0423Y\021fv\323iD", 16, "\224\307\134\316\002\320\273^[g\332G\320U\0139\004\022\220\010\372\200'iw\376\236\012\034\304\017\035\334a%/\322\277\3206o\262*8\014<\004\202", 2000, "4\274\031mr\012\340\305s\042/\217\205y3\374`\224\223\311\377\222\301\202\214\351\337\010\015\315m\213\263\334g\314oT\372\330\246(\333\306X\321\376X2\206\026\230\333\361\325z=\277n98\334\377@", 64 },
	{ "\250\346\251\243\207\200\303\011\307\231z\220\332\004\367\021", 16, "F\251%7\247?A\003\200\015@A\260\042\247\310\356\004/`#\222\244\201\317\375>\134B\023\024\007\032\251z\330\371\3456\006Be\207\343\354CR<\261O\352\362J\361\377\367", 2000, "\276\207\365,\306\033P\0200\231\2013c\351-\301\032\207\212#\301\3233D\374b\027\206\357\335\341\321\205TO<\316\225\011\271\013Ca\235\315>\214\325\222R$\003a\224\005v\253\226\243s$\375\345\240", 64 },
	{ "\222\324\307\304'\000\210\255 [),\322\357l\332", 16, "\007\345\242+\012\357t\231\202\266\324\250iv\277\257n\315\354r\025\004\356\233\317n\256\042\202\372\251\223\230\226c\203=\334\331\230\237\034\2129\215\365\317\006\250\010\361\335\226\261\367u[zT63|\365!", 2000, "\371\270dr\215\025\035\212\004\012q>\263\267*L\201\373g<\333+\215@\334\260E\253,\302\261>\222\201)Y\006\316,{?\303H\240\253\326\362b\134\374\177\013c\351\237h\025\2350\313\3422\313\272", 64 },
	{ "\325\351\200@r/\240=\323\331\372\023\244H\013\236", 16, "\326\307\360\340u/\260\312d\314E\240r\134\025h\272\202\230\177\364\346\134-L\345\362\260Y$\207\027fv\257(\336a\307\215\341!X{\024\0317\345\257\240\263q\332\032Y\230k\026\254\037-t\031\244'\353\324\344\3014pD", 2000, "sf\252}\216![5`hs\210\324T5H\346\037v\314\344\346\330c\240\373\021\023-s\350\356kj\224M~i\206\325\246\325b\347\335\252\303+\277n\003\307lgw\217\245\025R\205\301\257gb", 64 },
	{ "\244 \262P\000\300\360\311\042\251hn\226\023A\270", 16, "R{\337\244\226\014\276w", 3000, "b\254\205l3\271@=Y`\251\226<\316\334\013$\321\357[\357\324P\201\246!\355W;\362{\367h\2072\270\247\353 \271\357\233_\330C\322\231\341\251\315\010xm\270\350\260\352\304\035\304\204K$m", 64 },
	{ "\015}\205\262\251\331\300M\312\216\024H;\313O\030", 16, "@\225\032!\031\231W`\325%\332\334+\345L\257", 3000, "S\042\245F\263\330\001\203\365\020Q(Q\032O\302\236\311jA[Yq$\000\210\266\026BIFj\255\263\362L\357^\304I\266\222\223\001~\321N2\202\206\301Ml?.R\321\215h\327*\347\317\324", 64 },
	{ "\270\257g\226\273\231t\256;\025\270\267mL\177y", 16, "\224\2678\3320\274\306\365\254a\260\307\276\377\012Y\231\372-\3652\026\225\026", 3000, "5\3706\342[/{PT\265sHl\345\275\215\273W\300\354\341\342 \334\011\013T\003l\225Q\333\277B\240s\211\231s\360\353\301A4yj&`\024\005_\307\216\325E3\235R\032>\213\034[4", 64 },
	{ "\312\207\223Gfp\250\306\342\002|\233\1349U\004", 16, "4\321\374\364\375ycx\020g\345\224\352\0424\313\011c*p\267\376\232_\370|\240\010.\3227\033", 3000, "\341.\134\262?0\256n\334\263\356\273\3141m*\352\344\237\302\300\364>\347Kq,mu<\327\010\267.lg\002\232\226\350\354\010\263\215+\032\014\230\262\375R\264\032\204\334\351/\314q\361w\246D\274", 64 },
	{ "\2645\264\241X\321\351\352\342\015\253\257\241\354xn", 16, "\214Ihf0\343\371\323=X6\244\327\237l%\340\300\021\006\271Q\340\002\267\331\234\0100\231#j\005\342[\367\012\042J\237", 3000, "A?@\303a\325\243\015\200\206\256\025m\2471\254|\252\203j$Y(\013'\346\336\011\217\355I\346m.\001\337\033V\022\342\2177\216\264\211\000\253\330\007\315\323s\365o\371\330t\361\235:\0231\266#", 64 },
	{ "\250b\326\230\271\352\346\357\305\245\303:\3236\036\300", 16, "Fe\247\220E?\206\201p\303G\006\357\027\204xD\264\237\247t\042\357N\335\351\351B6\177Q\301\307\334\012H>\2572\275.'tu#\014\371\260", 3000, "\3270\222r\024-Gf*\352\204\271\305\315l\234\370\364\313\304\250N\267\321i_=5\370R-\302Oi\251\305\236\244\376\005\033\270\265\031\007\242\234\301\02166q\243\042\035\326j\224w\035\232J#m", 64 },
	{ "\226 \316\360\363n\302\012\207I\3022\252\232\271\221", 16, "\213\316\027t\212l\242\354\014\304\376\344\377\352o\207\330\376\037?t/\214\316\017\027\363Y\010\017\027N\326\007\003\263\274\042\177\230z\264x\340\017\204\005\203\200}w8R\304|g", 3000, "x\330\300Nq\0371t=\326=O'i\0176\314k\351\301\335\134\372s\200\331\010\322\226e3N\016\341\251\3670QT\322\200\346\217\300\202w\010\253\242\342\272\024&|i\307\270[H\357\306Vu\004", 64 },
	{ "ng,\206\357\313\353!`\263a\237\375\256\224s", 16, "\334\370\260\331\016\0355\342]/\207\227K\2323\256\003\004\314\256\020\020Wc\241\367!s\366\223\025\254\245\227`\335\226-<\375\367\010_p\2151*\204\2501\263\242r\324y\231>Ej\324\374\265\247+", 3000, "\233\241\316\316\335\307~\260\336\332\273\337\263yqH^\202\037\265\375\032\353\364\277\241\241\2456\325\3558\364\360ft\316\031F\350\300\026\026\264;\345{Ru\002~\027\340U\316\313\231\205\205p\3167\256*", 64 },
	{ "]\340\304\315\250W\316\336J\263\231\002\216\251\364\242", 16, "\201\376\003\177\021\346\237\211\320\262\334k\320Hu\220r\357\237%\222\357\013\350\330\042{\210t\227\376\372\016\3707\340\230f\200\360\300u\312\034\220\376]ct\225\311\275\005z1\243l\373-\234\2154\317zZ\0306\312\2435\032C", 3000, "V\373\262\256p\232H\0424\034\215\015\273)\217\366\237\253\323R\226\256A\257\334\355\035\376\331=\251.T)OVJd0\005q#\356\346\012\223,\017\015S\227\007\034\010\026\370\271\233\267\030\010\357*\244", 64 },
	{ "\021\225f`U!\334\331P\355\312\351-\032E)", 16, "+d'\210\235<\262\204", 4000, "'\276\227\331e\015\206\231\234\323\2578\306/\0338\007U8\354}%\310\265\335%O%\255\377\376Lo\303\350n0\353Zi\355\277\315l\010\252\366'G\272\263f\341\310N2V\346\334\257\214\333\002G", 64 },
	{ "^\314\361\023\376q\261\003\245N\240\353\031\300\031I", 16, "\355^\377\321#:\253X@7\201\251\215\257&\310", 4000, "\266=p\000\366\231n\365r\310\011\266\315\357\242\011\333\237o\030k\364\341T\042E\332\313\255\227\246\251.^\372\012\317\222\355\244\2066\034\336\000\250\277x\000\315\002\373\263]\037b\350S\036\303\341X\002\335", 64 },
	{ "\300&m\242\343a\326$\210e\200x\012\335\036Z", 16, "SG\363E\013\273\017VO\360a#J\220,\263\375\322\202\227\242;Pr", 4000, "\242\351.\17783>g\001<\034\004\030\002\312\345\270\021k\342\375\243/\342-\346\240\017\260bj\342e\206\225\134\367x\330\020/\363v\214\241\025\205lg\347$\275\300\315\205\021u-1\246SH\205$", 64 },
	{ "\235QV\311\015\001\301Sd\204*\270o\026\177A", 16, "w\020\211E\315W\014\015\342\344j\251X\341\2528\354\371\336\214\260B\367)\264r\345r~\221k\255", 4000, "\3260\375\203\347\030\375\023\351t]\015=\301\267\303\035\204\2345cJ\2565\243\266G\211\333\024\311\320\2556\031\302\310\257\273{\340\274A\011\305\206\272\232\264\336\217\012)\375\036~q]\241\267\220[\203\330", 64 },
	{ "\303g\3655f\271\332\250\306${\317S'\270U", 16, "\300RV\321<\333\2779\031\216\346/\305Dv\021\333a\374\344\303\355\370\0367\201\315\346]\242\375)\323=e\023\013\201\306 ", 4000, "@\253ur\230\326\344l!\004\026\352D\222,\021l\0316S\205-,\035\374#E\023q\034\312\0003?\234\000bs\334\011\011\204w\2558\356v\343\255y\260\023\320\305T\314\300K\232\000\013\352\305:", 64 },
	{ "\366\307\305\200i\370k\246sc\035zh#`\035", 16, "\341@\032\010\373\0114'\275\204P\256\314\324>\030\266\343 \034jB\372\0124\255^\234\207\274\322\227\357\244VJ\273wq\326\224\373x\360\327k\3508", 4000, "\323u\002\267\022\271\274t\002\305B\017\015\366y`\256\201{w\017\240/\225p\356\036yj\277\277\242\243)$\244\333\272j\367\024\223>\021o\370Aq\343nV\237\031\234\350z\226\201\300\024\256\006Gh", 64 },
	{ "\365\236\311\322\134\327\033F\230F\370_\217\221H\315", 16, "\214\207u\217\253\234Y\236\377\343qB\374\035\231b\267\266\314\226V\207T\367\352V\001jY<\337~q\203\345\265\230zB\2110\346U0\231\205\246\254\013\213\011\134\236\351YO", 4000, "\315\360d\246\273\364\265\217\210\306dnuA\004\347\022w\200\375\267\341\336\340\226jlc\354\205\310\316\251G\373\347\237Cee]O\351\237UN\236`\305\244W6al;#\336\377n\335(\337qO", 64 },
	{ "\341\325\003\214aV\254\361\365\314\333y}\005\036p", 16, "\274\271\3200UV\327\273\263H\022\362@\322\300\362)SMQ\335'6}\017\255\332e\341=\377v}\024\012\316\233\324xJ\367\011\016\260[\260N\322\257\011\005h\273\237L\010C\263\3300\321C\365H", 4000, "\336=?\327\210\002\245G\275:Q\371\271\233\300\273v\274@\002\363\340A\305\372\272%\355\365\343\012\000a\204\276\243$|\237\223\221\240*\351\311\262\327\367U\000\316$G\224q\036\033\327\224\247\371rzY", 64 },
	{ "E\352\312,\222$\365\267\303\016\331\276\345f\305\134", 16, "\01152\236\032\242H}L\263\334qk-9\013\006\356\357\251\372\026Tb\304\256\226#Ad\216\3024\333\264\240S\217:S\257\024\347\030\321\026\223\024f\301\261]\301\002\272\350\023M<\254\255A\270]Yh\251g\2235\206*", 4000, "\352\317\323\300\357w\365m\200D*\277\024\330\246H\207\347\257\211^\240\362\005\001D\237\310\332@T\243pB\247\025\236\204V\377\346u\242\203q\324\307\320\314\207\372\376\222\206m\134\037\365[\307,\240\377c", 64 },
	{ "ho\014\234\352\310\134-\224\021\301\134\015d\356\351", 16, "'\256\217k~\376y\335", 5000, "_\341\264f\012\003\275\012It\363\322\301\032\342\337\331j$'\006\014!3\3029\313\200n\266\003\254@\236[\011\214XK\372\020\210\335\031\134\303\011\042-\004\365\003sn5\235NK\375\013`\022\336\025", 64 },
	{ "4\020\304\323y$t\014\202P\251H\371\235|\035", 16, "\303\370Y \366f\325\317\352\030^\245\234\366\010u", 5000, "#W\033\270\241m\245%\357\270\243\340\211\271\263y*\341-\002\277I\332\227\042\271x\321\344\246\030x\252\233\326-s\302\334\327G:(!\315\220c\346\240\375\012@F8@\205\271Vx\321\202\024!}", 64 },
	{ "\034.{\0068\255D\335\340\303m\273\356\223x\204", 16, "\247z\325\244A\337\245'5\373\351\336X\330\003\2576\243H\020s\226\266p", 5000, "\353\206?\351#+\346\206\330\225;ua\020\263\312p\024\2229\213h\015\336q\254\216P\256 \004}\001\355\230\214emU\323E\371g--\237\303\022'\016\033\355\274\267\271\351T\0327\300\306\253\031v", 64 },
	{ "\015\363\324\364\323\220\323f\177rR&v\375\027U", 16, "C\020\362\262F\351H\240l\271\245_G\134\034mC}\277\354\017\377_Ab,l\322_6[v", 5000, "\370\357\015*{\001\221\310\244\235\134\214k\335\310%\274\226\3203o6\223\361\243\356\200\000\340\240\330~\225\266\004\224\254\211\276\270\202^\251P4\237\350^\036\3671MV\317\214\227\022\211\344\022\321\001\257}", 64 },
	{ "\312\272\240\233x{\372:;\253\370\330\334#\267A", 16, "\323&\213|\016\3346>\224\345\032;R\233\0056\316:\037\315V?\221!h\0308\231\333\207\221k\035\222\252\014I\2215K", 5000, "\004\012\245\017y\316\355)\320\007\331\236c\324+\3771\247\257|\336C\332\331\317\037\007KG\321\334\235\237\265\301\360\315Im\212\260\012d\033DIb\042\260\025\304\311I6\2158\3527n[\032\347x\371", 64 },
	{ "\215R\005M\032\350\240=\023x\0165\246\231$.", 16, "\021\272d\364Y\217\317\346\026\0161\327\214\001\357\335D\030\364OE\264\266\012\270\350c\276\340\327\254(\2638\361O\253\254!Lb\021\014S\234Z8Y", 5000, "_\3748\356H\220\264;\253\233\323\376\2548\235\004\357)\002\277#Gz\253\363j\026\015^\335\024#\211\002\354\207\373E\364\2513\344(f`\214\227\3319\031SIh\260\234\202\301\375\204\315 \002\347\376", 64 },
	{ "\245\313\007\234\303h\224\215\356\243\352O\206,e\266", 16, "\031\033p\375\350W\006\004\213\313]3\214\257v\333\0357\016\375\364\021\344\305\323,;_\330E\224\351&N\244\026\275J\354\024\340\310'/(\012V\217\253P\361\236\273PMl", 5000, "v\276{&\342:\355Rm1\362\320E\344J?\015\023\323l\315\331\252\031\245\206\231\014\303\340\022\231\241\332qe\036\226qF\213\254\037^\220\042\324L\204\011q\277\233T\303\350o\217k[\327x2\346", 64 },
	{ "\273E~\201\327n\340\231\001G\001\367l\206\021\030", 16, "<0=\371\010\317Aa\375\340\261\234F\275\251\236\024\310d\003\265^\345|\372-\223\305\235\272\344\350\271\3669-Q\264\312S\323 \236\343\352x\304)\341\334\355>j\024\251\377\252-\356\241.QW\256", 5000, "\307\241^1\271\302UOY$\250\372pd\343l\031\205\353\272s\004\311\002R\276\006\232I?\327\020\237[\363\012\2656-\361Z\177\025\210V\204ZF\351w|\206RqU\042T\205+\222Op\235\376", 64 },
	{ "[\034\223\310a\210w\351\020J\351\263\240z\034\261", 16, "<\217A\265\347 \264\242\024\324:\011\370b\263\345R\012'\271.\005\350d\027\314\017\034\361W\316Tj\225n\1778Y\356'\012ie\307\342cF\266?M\300. \271\247`\042\344\272\371\013\273s\316\357X\207\304\357\013\322\315", 5000, "\241\224\024\317\303\227\241\317\332\351\301\3567j\326\320w)\275\223\234m\241{B\356\274P\274,\012|\235\367.E\345c ^Z\321\031\352I\042\005\365\264\360\245\357K;\306\202h\350\206fV1\000\325", 64 },
	{ "5\265\376M\262\3518<\353of\232AA \374", 16, "WSKsW#\354W", 6000, "o\027\243%Q.\3759\331k\011R\363\367jK\234\357o\363\317\220|'\245\233l\250\001N\203\322\002Q\026\027H\267\253v.\351\242\220\257e=}\010/v!9\346\352\3749\2014q-\340N\376", 64 },
	{ "\350\203\337\210]\367\213\335\270\213\232\026\221|,\370", 16, "\346\327\263\312\213\345\005\011'~\221\027\355\241J\231", 6000, "*\022\205kO\256\322\231(\361\367\342\277\266\220\000nj\330xh\340\215O\356d\210\225\303\2373\340\2130;\005\254S\3115R\257g\344\233\023\347\205\237\274M\307\367\327\364-W\246W\203\275\373\237\272", 64 },
	{ "m\326\335]k)2U\200G\347\000\311\010\311\302", 16, "\340\250^(]nb\003\212\354b\177\344\011y\300P\016cl/0\016\213", 6000, "\273\333\252\306\015\232\306\321\251_]Y\006\042\345\350r\222\010\372\026\205Mg\373\347\267\014\234\032\016d\210i@n*aP\316s\366\206\200\004\015\017\034\325g\334OS\177\214\374\230\211eP\213rNp", 64 },
	{ "f\323\354%,\247\330/\027\373\267@~\345\352\256", 16, "=\354\324\017\336\012\214\370\014Pd\217\317f\364\301a\207\032+\227\2247\201\317\215\333\020\276B&0", 6000, "\245+\223Y\302\363Wl\312\0344J\245)\347\217\027l\027\321\0121\341\365/\263\374t\330\262\210\220\250\354\240q\020^\033M\274\261\350Sp\325\254_\262\304\357U\031*\262$\363\371\030\036ay\200\242", 64 },
	{ "|\035\377\326\376\2752^\335\207\230\271\341\326z*", 16, "P\271\315\034\230[z$j\377\266\015\205\3064h_\316\254\271\353\342\301*\366\366\350iV\004\351f}\260wr\257\236\025\241", 6000, "\301\354S\253]c\332 \277\205!Y\356v%\225\367c`gB\006\024\247t\314\300Q\323\225\020d\036\024A\353d\335\007\025\014\245?\252\246W\222w'\301\263\003M\014\300.\014\2420\011\355\342XA", 64 },
	{ "\364;\377\002H\026A\016P\352\331g\2407[\261", 16, "p\271\243\3110\372w{O\317\315Q\035\371\221\016\236\215\002\222\317Z{\372\375X\316 8\226\270\024\344\373^>\235\274\320\337\313\366\223\246\336\250\134K", 6000, "\340Lv+w\360\311\322\355_\036@Hd\246\275\324\033\235\274\013RJr&zD\230\345\033\216\234\213\255\237[\217U\367\300\356\331\372\237\021)x\362\216\306/\351\374\314\210\2341h\227|\230,\336D", 64 },
	{ "\134.\271\033\351\232P\020\356k\321X\351q\331\004", 16, "\277\207!\216\312\324\347\223\234\202\360\220}m\3773\210\232pe\020\254\371\334\266(\227\254?\305\017T5\020\210\223\006O\223\375\357!+\363\003\245.\325\255vF\350\3565s\221", 6000, "\352*\003U\323P\225\256\254\374\001\337\312\377[\134>\2306\270\001\217V\033\006<\243\265\012\355+\024&\374\313\031\254|\302\006\216\216\250wD\352\320\3128zf\000\205[P\323\013E{\025\353\276\316\034", 64 },
	{ "\015\372\205\371:m\005T\000n\3255\366\220\2653", 16, "\266\234\036\134e\020:],5\005\201\331`S\305\224\017kW=@.\025\376\017\353\022\210\007#|M6\354\210\3121N\356\331\033\223\230\344\305sR\241\232p*t\217\366\243\352E\255\332\004\270\365\361", 6000, "qq\245\012\237#\004\316%\345a6\322\340\353\0344\265\013LH`\237A\232\337\357]\363\023[\353\2631\000\277\013\317\336\371\3125\312y\305`\236*]]\204\236\302\344e#L\270F\232\372\267\232\250", 64 },
	{ "F\256\277\366N\234\235\316\042\230\263\256\025Q\320'", 16, "\200\254Yq.\205\373\373\0056\331\214\376C\235\277\323\350\261Rc<\177.<\326\237B\353\373\360\313\257\333^\212\303\023>\223\004\327Q\333\271\011I\303\230N\325N\0172vT\011\214\330a\260\216n\017\207xd\264\327\272f\276", 6000, "9\343\311g\224\222\221\275\256Mb\206nD\361\232L\327s\222P\005;\255\027\240\261R-M\231\347\315\3164\264\314F\347\245\372\247\247\303Q\341\241\271\003\035\207\303\304\335,\012\360?Y\320Y\227\376q", 64 },
	{ "#\256)c\376QG\273\245\222Y\010\357x\221;", 16, "\315Ysi\036\266I\332", 7000, "Z\213\027\2367\231\205\005\224\300'\224>u*\372\031\003U\205\242e\223\274Q6F\362;?\022\327_\343!\214\276\262\247L\260MLX\247N*Y+\331\361\215\220l\331\213\361\335c\314\203.\330~", 64 },
	{ "\360\343\200\367\344\250O\260\215`\247Z\341\274\346\270", 16, "\310\2524/j\334(\344\303\017Bs-\201\264\312", 7000, "\037$}\362F\213\254\306\345R\345i\326Z&\262Q\017\304\210\026\216\336#\220:A]\210[W\246\272\005\011z\337\036g\366\206)\245\201\214K\335#\212\205\350B\376h\034!\235\006M\272\256\225\257\220", 64 },
	{ "<\230\261\363\334\357\217\022\276\000R\306\240\210Dg", 16, "FQ\263I\223\375\335\2135\006\374-1/\227\207S\341\202!\372\206\253\236", 7000, "\266|\263\374\266\265}\000\261eB\307;\233\241V\253C\014\224\230\012\326q\276\242>M\214[wt \361\361\205\303\311\320\355dV\245\242A\237MAt\237\340\242K\3133\355\357\034\303\200\0277\267U", 64 },
	{ "\213.\310\205\014W\307\364sd\223u\363\035M\260", 16, "\331\007K\015\367D\224\016Q@\243a\264\342\346\216t\2161\030p\345{\227\245]\245\274\235{\322\245", 7000, "nX\013K/^l\377\237\3044\010\277\367\134.\222\215/\3471\023&:]!^\261\177g\272\011\177\374#2\177\326v\251\003\005\374\232z\030\274@\311\321n\323\227*\024H\225PA\241y(\276\361", 64 },
	{ "`k\271x\304Cf\230\313;O\277\236\2448\207", 16, "r(\245\265\003\237kT\204@\321\252\202j\242\352\365\366FZZ:\366\272#\323\017\2666U\240v\252\236S\332\011\001\361p", 7000, "W\200\361\034j\376\022\254\325\205\257|\232\255w/0\373\267n~\355u_\331\007\242jXi\034E\254\032S\205\034/\023i\356\310\250\226\3517\201\311\360\237\201\221O\267w\355`\366\217\257\006z\357\321", 64 },
	{ "bg\316Zg(\330\371\016:\011^\202\000\235f", 16, "_\177\346\022\375\256%\310\347m\336p`_J\333\334\003\312k\254X,Z\361\372\303#\305q;\343&XT\316`\006\036\215\306\207\327\311\255(\203/", 7000, "\313\000\3670T+\346TF\365[6\223rBb\241\267_\035\321y\315o\255\321\035\361\230\371\230\015\264\347y\364'\376-\240yL\036\260\265\234\265n.\217\312\261a\234\032\227\257\207a\331\354\010\263X", 64 },
	{ "\350\026px{\014~\0317\015\314\231h\336\237\217", 16, "\347A\307^u\267Qc\027\235j\323\012\315\311\031\234\2003R'\015\221\370\030\227\003)h\214\236\012Qok\210`\320\227\307\354\303\305\317\314~|\014Z\012WA\036M\322I", 7000, "\227|\356\271\333<f0\014\3640u\2273Vq\3353\2653\134JW20\020\016\023\335\243\023jm8\316Co\245\204\273\304B7H7G|\302)x\342!.\252\244\216\3137\253\365\202\256 \263", 64 },
	{ "%\020@8\324O\311\316\032\222\200J>\257\235G", 16, "\311\372\032x.?\3452L\331*\235\356\356\261sY\313\266\260\014\202\333\016\006\322j\3516\007U\377\215p\177s\267&\010\352\010A\361\315\357<z\241\213\202L\302\314\334\316\244\202\234g.\361\202\326D", 7000, "`<\340.\017\300\273\033\250>\0103k\220\311\042\250\267\022\312\030\034>\343\250\320\300\002\0123i\361\025~V\037\273\277\322\272sI\375m\375\337(\345*\220\362w\231\373\315y\230\273l3\017\226\260`", 64 },
	{ ",<\361\027\343\375\355\265O\264\234[w5\261\340", 16, "dS:\242\350\2612,\314\224}\367\361kW\335+Gj\357Q\355\251i@\326r\024K\346\034B\340\360\242\356\016\272\216m\232u\220\300\236\333\312\363\036\241(\322&\244\211=\275\376\006.\377\013\034\220\020\306\353\274\374\042[\300", 7000, "\277\364m'[]\305CMd`\345G\237\352\371\225\215\373j>V\362\241!\364l\033<\236\364O\023\276?n\231\207\3735\201r\270\305\337\177'b\031\014\251\213\217mZ\320\266O\211\364&\0304x", 64 },
	{ "\225\306\272{\341v\275 [\231\230\317\371\363Je", 16, "\343\036pA\252Q\264\242", 8000, "sJ\331\240\3206G\226\015\2441\370e\317\012u\356\372V>}\251l\1340\033U\177\215\316\317\037v\226\016\272O\275Z\341\307\370\317q\311\010\332\304\012a\375\343y\336ZT\377-2\361\203 \042\336", 64 },
	{ "\320\231-\337g\034\212\004\342\037QU:X\277\316", 16, "\216k\037\361.T\244\366\003\010E\323U\233v\240", 8000, "\021\375\214G\326\017\316\350\013*\236-\013\026S\223\310,d\036L\311\032CM\006\0352\241\232\000\342\224\025x:\215S\2146wvh\205\306-[p2\003\322M\224\353\237\263/\216\134`Z8\273_", 64 },
	{ "*/E\206\367\224\243\334\243\262r\326\360\231*H", 16, "\345\315t\032\021\207@\026\330=HF\320\204\304\330!\232Om\322\246\0260", 8000, "\200\306R\350\230V\334N\020\001Ol\242\024yN:\350\241\332\214\262\016\2629V\264(\2059\220\326b\340\303\020h\232gb\202ZCiR\275z\347+\326\267\027+A\246!\345\206k6\344\255\264*", 64 },
	{ "S\345P\373\311\016\352\202\352`)Ecl\336\361", 16, "\376\007\354p2\333q\006\237q%\037\220/,\007\264\366\006-\335\273\235\377\036\345\035:\351\042k<", 8000, "\204\256G\244\332\302{GC\274\335x\200\216\001\232\211>\263\211\360\032\031\267\236\317\257\211\273\031u?.M\022\014\220!\202\225\310_VC)L\001\323\362\014\231\341\244\350\222\022\243\361t\364\357\316G\257", 64 },
	{ "F\042a\201rU \373\374e\273\351=\364w\222", 16, "\212\030=]!}o\373VP\036\303\376/\373\322\025\222n\234\300Rl\264\010\2311(Y\275\232\3137\013i>\327\233)\207", 8000, "\233\276*\331\257\377\012\270|\212\272\2466cAh\225\024\334\2332\026\177\330'\006\210\210V\277\323\251\211\230\212\363W\2258y\224\236=9\337(]\010\3171N<k\242\015Yy|\341\352\347\207~\207", 64 },
	{ "\034\341\200H\203<\277\020\2368\307 }A\340\347", 16, "vZE-\014t\314D\300\2448\266\177\005{\025K \307\307\004W\262\005g\336\017\227i\217Z\203\351^\337MQ\314\253\311\246|O\334\377~v\042", 8000, "\364\037\206\254\004m&7\332$\036\012)\267M \241\332\245\241\262\201\032V\010\134e\323N\2445\351L=\231\316\306\233GS\234R\236,\257}-\0130(<\035\032;\212o{\312A\331\011(\350@", 64 },
	{ "p\256\034\024\365\010\220\260\312\026\350\042PO5\347", 16, "\006h(k\243\227\366\276-a\363\360\134[\034b\022Oj\264\351\2013]\271\366\307s\342\361P\306\243\323\006\020\230L\374\347vy\226?\235\300\230\255 2\362\261y\341%\256", 8000, "\332\253\037X\211\234`\315\340\253\202\275?\356\366 [\357\275up$\275\317\204\267\301\255\372Y \235\350\031\000H0\306\372\330\030!\2324\304\035]\220\033\336\014}Bj\2449\242yq\341\330\014S\343", 64 },
	{ "\343\333\355\3028:j\326\017\246J\255a\340\371\202", 16, "\217=\347\210g\256\017\252\3509\244zE\010\237<\311\271\342\3100\223\350\037\324Zf\245\356<\357,\005\323\351\261e\3544]l\313\215\341\020\355\316&O\231\255N\036\330\337!\307\370!\265\030\023\206Z", 8000, "v\245\254(/P\3105\353\335G4\277\250\243c.\260\355\343\376\021\017eK\224\007\036\331./=\134\220\234\026\337$\261Q\006\022\201\305@\277\036\267-\360\240ds9e\221\303s\3768\216\344R8", 64 },
	{ "\246\214g#qw!]\335\300\024\276\231$\245F", 16, " \331\012\010\316,\374\312\371\0232'%0\3142\016a\356\307\266\233%\270\007\034e\306\232\327R\240\231mj\262\037H]\275\2011\217\246\343O\206\237\003/\2128I\222_\373n{\377\210\220x\217\224\375\327:\317\374\001\353j", 8000, "\334\020\265\311is\344\340\002|\352\365\362\252\257\347?\001WPB(9Y7O\353\313\343\244\276\217\257\217\302v\260s>\342\016.Cjm\322Y\356\26574\207\332\355^\351f\0258\343\267w\361B", 64 },
	{ "\305?\017\233\177\271m4\354\221@\216j\376%_", 16, "_,H\223\264<\314\342", 9000, "\236\314\367\273Z6(]M\214\215U\254\264\325Gb\24793\042l66\014g\317\342a\236\317\251\254CaS\326![\210\303\323\202\032f\014M\247\034w\225a\220\303\332\024L\317M\324\022\023\206\316", 64 },
	{ "?0`\205\22034\220\217B\361\242\217+'\022", 16, "\177\315\237t\250\213S\313\337\265\337\371]l8\026", 9000, "\377n\327S\215\306\365\346\375Gj\247\245e\2004\343\202\221^_\275}\323\2345\302\007\333\337p\353\265\222\350t\227g\356\032\272G't\242r3V\276\362Lf\222\016\244Ez\200\315\247\370B|\372", 64 },
	{ "\306$\211\276,\353}W.\355\274\330\215Ay\346", 16, "\330\362\015\255\012+e\264\241.\036#\377\327\001\011\205\254i;[P\223\363", 9000, "\204\003\342\235\365\213\361\303\3248_\324\346\330RpT4\235J\0106j\263\032\2113bjHj\233\332\365oA\222\247s;\250\247\017\377U\354-f\005\277p\377\345\345&ILO05\232R\325\311", 64 },
	{ "\257\364\250\253\267\304/\330\357ch\230xu]1", 16, "\247\336\344\240\322\251G\223\222\225P\370\322\311/\204f}\253\222\252\363y\214\346\016x\262&N_\002", 9000, "\262\003\321\0362H\220\310\344\306\265\020\373\300T3\2652+\252g\275\225\224\036\357\2050B?\375E\273\232\344\024\310\344Zh\004(%@e)\264\202\2022iAZ\030\210\033r\346\211\332x\363\023\032", 64 },
	{ "\340\000\323\220e,\371U\242\254f\245\272\337\001\357", 16, "\215\306\001}9&\307\2221d\253\212q\236\3316G\005|\015\042\012\361+\005w\270\367\211\332N\026\331\037\250\014\212d\330\246", 9000, "\260\342\217\247s\321\350A\016\221\371\222W\304&<`\312c#\366\002\225\241fJ\033\211F\252\300\251Z\313\225q\202\036w\253\264\277+\361\256\235\354\300\203g\334qz\310[\022\326\212\223\314H\247Wg", 64 },
	{ "\025[\275\212\134\0013L[|\034k\356Q\321\267", 16, "#YZ\033(t\272\257\363\262\134\225y\206zF\234rB\266\221\254\367\310\042\264\270\236\026\372#v\354\213\265\372\221\304-i\020\042\0107\344\253\3678", 9000, "E\267\177\372_&\305\201\215\351\335\007irx\302U\037\252\012q4\201U\356%\366m\245\202\373bqh\244;\271z\372l\2516u\267\004\013\246z\274F\021\312E\177\2159|\037\033C\340\351\332\353", 64 },
	{ "\312\016\206\247\361E\252\245\001\033\031\234\227\246L\332", 16, "^S8\353\353\0307\031}\012\247}o\352@\027\217\200s\220\206c\320`D\270\232\275#\361\223\210ur\361%\003\034\3607\255E\016\271p\336\274\260Q\027\0136r\246\025\263", 9000, "\202d\317\362\315$\311J\377+\037\244V\342.\336\363Mx^\347\202\206Vm:\363[\3353\324\316\3403\012\357\351\364\221TN\340\275ALC\033mC\224\225\274\000{n>i\327\006\221p\360:\020", 64 },
	{ "I-\350\031\2302\352\226OO\234*?me\030", 16, "\004'\254\034\206\216\214\277\213/\235\237\007\312K\347\034\361?\376\327C64w\313\300\004Z\226\207\303\363\0066\377\375=\341\371\207Aq\247V\237\024T\246\200X\342]\005\356\337\273\023tq\226\032\021\202", 9000, "\367\317\013/\030\210_\377\013k\366C\234s\237\011\212\330!.\016\263@\353\017\007\034\345B\212s\204\371q\336;\334\032\313E\324>\326e\344\304v\205\004\342\000\343v\025\346ZO\2243Y\264\366Z{", 64 },
	{ "\237\234O\246\003\264m\356\326\201\266\313\345\227j\324", 16, "\027\016\205\250\331\027\275\260Q\032'\204\373j<\233N\251v\234\346T\250\270n\017\244\225\275\340\354\346LJ\376\2779\2311\311\312P\335\036\323\202h\255\254\376\261\350kO\3324\277\266\223\207Q\263\373\351&\0030\247\330lL9", 9000, "r\036\301q\371B\034\017/H\010>\242\326\247F\353\014\333:)9\353\261c\003\177\223\3277\250Sm\263\306\316\261\341\321\321\134\232b\312\235\014@\336l\330\3356\001nw>\363\015\210O!*{Z", 64 },
	{ "\227\346\344\330,\020\250\376\033v\253F\236\207\374\245C\230\255&\277\300\310M", 24, "\333\256\034\031\307s\315'", 100, "\267@0\237\025s\217\307\3646\231O\246za\000\340\233Q\254$\277/=)M\250\213i\245\275t\333\322U\256S\025\030<\200fFkO\2528Y\272\243:\033\315\304\313\237\017\356\255\274\357m\323\215", 64 },
	{ "\3410\3103\201\025\037\366'2\340N\277\256q\345Gc\020\036kH\373w", 24, "\302\330?\225\200d\3510\335\346\211\317\324\365\366*", 100, "FN\014\374\031a\240\212\202H\314\016\371|{\025\267\243\353r\257\365{35\134q\252\205\357]\317,Y\350G\206\365Tuf9\356\267\365S\371\332+\245f\332\213\371\320\215\215\300\242\243\216F\361-", 64 },
	{ "\265\001\263W\336\011\274\204=\356p6\210\000\216k\216k\203\365>W\275k", 24, "\270\342\331\242\013|j\306\324$X\035R\365\326\242\307\036Z\321\303\357hi", 100, "\005\301\361qhJ\263\253\2069O\003\242E\333Z\014\003\274\336f\322De(\376\024T\336\250\2111T\270\320>\366\266\311P\177\234\264(\015Vd\260+ De[\0301}gzZ/\263\263ma", 64 },
	{ "C\347\306\033\005#\201X+OL\177\310\360:\207'L\316B\325\264\324\264", 24, "\021\357\353jzG\377\235V\012u\262'\256\354:\007\343A-'{Z\204\204\226\321GbTP\270", 100, "\200GB\211ui\244\352\343Sj\207|\250\213\035\010[\335\312\345k)&a\035\363\213\371\217\212\317\364\031{]\355\315E\222@n\026\375k\357\004\3505\025\226w<\134\226\324\326\254\345$\322l\302\247", 64 },
	{ "\236\030\042\231=f\332wq\260\342\364o\372S\374t^\343\027\374\006\002\024", 24, "\344\273\215\371\325wt\273n\225\221\020\263\214~\226\266\237\226\323w\026\313\327\377\201\022\226\356.7`C\362jR\217,\362.", 100, "\235\361\025\375f\302\004\271\274\003\354w\027\001f\034\246\323HME~<%\303I\037 \266\042\335PY\306\134<]\364\377\026\254d^a\327\275\012\134\223\027\265\277\177\035W\3347,d\362\250`\006\342", 64 },
	{ "\035x\237%7I1\271N\370\236\340\214p\331\367@\355o\134\256\032\355\243", 24, "3w\231\014p'd\220\317\366[Kz\241\271\010\200u\225.E\277\313q\262\341\313\031\271\205\016\024\3616\021\345\030\254\367\314\312] \026\211\273fs", 100, "-\300\221\205rc1\013\374\370_xC\315\013Y\21477\320\202m(\345(%:\260\232\304\004\263\303\275\304\317D\376\245\331K\310\027\343\322\221q\200.Kp\206\311\231\306!a\240\203\324^)%\026", 64 },
	{ "\023\366\263t\006\015l\264\316Gq\271\3468j\220\271\232\361\223tW\224\020", 24, "\365\367`yT7jO\360\247/;-K\241\031\227\034\211\251[\236S\015\035P\304\256\342E!q\205WJ\207\373\016\006\355`\235\367[~\300\264'\232\200u\241\234\210io", 100, "\271\034\330\262\216K\312\224\375\206\243\341{\372}\232\210R2H\032n\264\377J\021*\263\022\240\277i\242\356GS\302\243b\230@\034<\261\276\025\016\340EIt$;\347\221\024W\311\275R\254\272A\037", 64 },
	{ "\373Oc{\307\313=\3414>\340\016\245\217jar]\035\307\252\010\031\025", 24, "kk\262\256\340\255Z\310\235\020\320_\032\345\260\243\352\202\321\301\246s\300)\3314FJ\267\361b\237\034*BrjY=z\336\300\344\370\371\035\227\334[5*\325\3152\233Z\022\302\3733Wr\012\005", 100, "\246\372\3420\204\346\034\314$wZT/\240\376d\252\354?\331y\225\037\252\374Ah.\304\3737\242\013K\351\035tH(\255\353\240\214\304\350\245s\273\326\265\340\300\253,\022/\311\223\024\3369\002{V", 64 },
	{ "\201\012\000\332_\206`\206GD\336\346Gm\227j>\301Y\333\2658\354\001", 24, "\361\321\374qZ\346\016\307Xm(a\256\301\002\245\352\216\244/ca\247,\315V\017+H\004\355wmR\225Upz\373\217\333\206\337>\257\313\275\307\260\342PS\013\260\356\377\322\267e\027\250\030\262B\012\346Q\260\025C\311\317", 100, "\254\012\230\016\257A\017\210\264Z&\234\320\375BRb?\266\012\2509\222\355UgM\322Y^\321b\225\243\353\374\374\224\2545$q\030\030\370\332M\302\350\014F\023p\033\201\316\004\000\270b\016!)$", 64 },
	{ "n( \210$O\004\366\207T\3158\361!\212\3606\317<\330G\250\260\272", 24, "\204+\330\321\244\030h\275", 200, "\353Ko\207&\357t\224\036\266ob\222)Cz\360#p\020E\357k\320\370\007R\375\311'\347\007\364p\340\341\275\220\341\260\032\316]-Rthu\206\202\255QY\251.\214\245\330\007\312\354@\375\204", 64 },
	{ "'\273`n\012l\345{r4\347\264\223\376LW\311\363P_h\302\001C", 24, "\324\200pH\263\220\2615\305\341\371Gp:\323\322", 200, "\205-\343\243<\333\375na\337\314\271J\354S\300D7\011J\364\023?\2222\360\267\221\010Fr\256\366{\366\235\255\331K 1\370\307V\373\020o\363\367\036\226\004\246G\331o\321%\314\220\254\234\317\033", 64 },
	{ "\345/\334G\221\360\212(\211i\247\012\215\223h(P\366\215\371\300w\336\274", 24, "o\341\236\363w\371x\217Y)\013\331\006\034\222\007\221oA\022\037\332\252-", 200, "os\235_H\326N\300\244\310\361o0\202j4\334YO \345#:/\227\042=$@\363h\212\365\376\277\34220\301\371\373\250\327\201\374\012!)_\001\346Y\2061\220\302e\323\004E\364\025\334Q", 64 },
	{ "|fm*#\220r\246\343f\364\364\241\370P\313\315}\216x\303,\335w", 24, "\342\177\034\326\226\223Oo\035\214\227\361\305\316\314\307\323\223\353\271\303_\213^\337\017\204C\316\037t\345", 200, "\2571!\373\364\361]\225\332K\267\042\317\314\030\2360.\257\037H\215E\276I,\356\033\13411\267\335>;\226\254g\2532\024\323t\024\237\275\014\021\267\251\004\004\331o\305\036\256\221\234\242\210[\273\271", 64 },
	{ "\315\3742x\230\331D\375G\256R\363g\316 \024Q\034\317C\271X\240K", 24, "<3~d\026V9\2178\224\202\324U\335\006%\270=\225^\001l\212\212UC\277\270\233r\211lR\300\275\223\275\300\346J", 200, "`[\366\233Zk==\042\033\211\322-r\354e6D\210\302\275\247\274\374\0266\203d\234\315\331\244\2671\226\014\336\243\350\216^\206\255\242\023ueK\017%CN\002t\300N\244\272?/s\243\200\327", 64 },
	{ "v\313\001I\364\011(l\005=7\330\0012\000C@w\317\206\230\306\363\000", 24, " \300\300\271\3443iMC\254\301*%S\325\211\212Rw\350\3027N\233\237\334\3134\204\332\031HS\374\3749\214 \3503FN\367\002\030\312\351D", 200, "S\007a\011\031\231\366\371g\003@\3407\024\016\376yl\373M ksH\327=6\210Y\225Q\325(\2348\334\362E/w#\375\354qY5\324\356F\212\232:\033\231\306\235\302\321\330y\226\005\260X", 64 },
	{ "\335\002\277\030F@\273\340E\000\300\304\372\322n\230\262\354\032\250/*\351\230", 24, "\270\207\0010\377\337\347\375\213\331q\315\033\371\253\012n\275\262D\267\226G\367\371P\213*xA!\364!J\342\2113\242\321:\205\203hF\015\315D\026\313\353[`\213`\374j", 200, "3\301\365]\214s%u\230\234\215e\331<.\347<\320T/\254\351\243huF\003dA\341\342\372\206\243\005\277\257\033\364\042[\200Y\326\017@\015\271R\225\035\330z\37523*\313\3347\027\226\325\355", 64 },
	{ "C\325RQ/\246$:h\177\362\331\223\261\312\006\237%\326zY\375\033\341", 24, "\002d\2740-\177h\221\356\310\211B\036K/H\335\336X\326\324\3304\251D\365\377\234\220\375\325,`\003O?\340\276=1\246+\231\336\233\211\272\265\257K\036\316\333\204\223g\035\336s\347h\230\270f", 200, "[\037\344w\257\272\235\230\032\270\263xh\361\014\273\350:\273\201Z[\314W\254\224\222\364;z\303\372D:\022a\366\266\364U\3467\314\337\357\246su\014FO\240\030:\325\362ZA\363`\362\005q!", 64 },
	{ "=e\0029fU\375,?\262\327\273+f\013\263\201\021\027N\026y\341\340", 24, "\312\204\344\332=f\0336\341\017\264#j\216\206\236k\022Z`B\242\355'Y\016\267h?F\270\213B0\245;\367f\363\246J\012\200\330y\230\200}\347$\243\343\216\032\037\006\271\214\322X\255\256\032\276\021%\263aM\264\252G", 200, "H)\352\343\007'}5\333\013:e\354\225zG\271\032\340~\262\351\261\177\004\227~\333I\363\301u\210S\252\231\340+R\271\336\317\027\354\351\364<\276\220\042a\373\320en\370\001\301\305\356\344\244\236,", 64 },
	{ "\376\374`\300n\003\362\372\017\2253-\307\232\264a\351F\247\002\011\270\336\311", 24, "\023\265B\220\374\244\304\323", 300, "{\346'N\227\254\343\334b\323\220\316&\335\375\227\013\314K\214~E\374$n.Mi\337\223\326L\361\342\237\242\257D\207'#\237\373.\2729\363\005\003O\216\011\005$\261O\214\343\275(X\336]\317", 64 },
	{ "\177\337\370\037J\313\252R\367\027-\303\274\322?(]\370\017_?\010\360a", 24, "~hCg\251\003\302}\372\2644,v\264q\251", 300, "\003\253\302X\215\255\034\206\337\272\327Z}\206\000\333\311\026\377T\336\347\315\341>\210gsS*\276@3(T\340\263#\325\327\335\027~\310\201;C\2723?\042\341R\346\247\273\355\344\002\300\341\314\245\345", 64 },
	{ "mD\363\333\332\276\206\023\340y\331\010\326\322\331vHX\265:\277\042\350_", 24, "w\011\263\376{\016R3\025\013<\033\261\320\024\017\356)\371\235c\021\353\262", 300, "\304\010\302K\273#u\237\227\3135^\134\2743z\326F\265=}0#m\240@\303\020\356\373\042Xl\223^)\242\031\374\215\031T\316\020\203\255\273$\024\034h1\370\270;\276\277P\250k\252\352\232\371", 64 },
	{ "Z\2556U\206\026\34258E\247BT\276%L\367\0119r\032\233L\272", 24, "8@\034\305j[D\015A\317!\227jgy\313D\315ZIu\367\266{@]\335\311}\351dC", 300, "\022\23418\340\022\235\005\024\016\010m\217\370\271\262\307z\325\003\237:a\216\255w\023y=#fx\323k\346\215\331\275\206YGw_\261\353\007<e\201\376\200L\030Af\352T\314\310\010I\266\333>", 64 },
	{ "\247\005\202\025\315\206zP\360\241\134\036C<-\006\327\363\201q\251\002`\267", 24, "\271]\336\352\244%\215\020\330\3458\377\225\350\302\237\253\033\202\367\265\373\331\261o\250\031Q\374q\217\254\233o\230\375\236\327\333f", 300, " ~\303\251\370\211U\337,\237Ln}E\320.k\245\246i\234\202r\314\324MU\365\377v\3177\266nXT\002%\346<;\350\3354\262\330\275\303W\242\014\024UN\274Hd\210 W\244\222Fv", 64 },
	{ "%\312/\275\212\305\002\376\340\362\311b\224\3203\012\317R\370]\336\204\260>", 24, "\343';\334\363\247E\332\354\203kj\3654>+_E\310\353~xO\202n\234\217\227\360\371\261\343\314E\331-\210\203\032]\177;)$~\333\367\313", 300, "\2553\037\301\022E\356\010\274\241\216\332\333\037!9X\374z\314\306T\345\274'Z\256\375\036\355HL\337Dw\276\235D\225\213\304\214\350\250\031\316\200B\317\320:\0253\233\233\025n\264\016Y\271\242\035\316", 64 },
	{ "\273o\033\015`\0168\005\343\233[\262$q\314\315\246\011\036(\233\203\211'", 24, "Qsa\3029\213*\321F\261}\270\357\330\030\200\335\375'\261cT$\2101\303\035\253\024\267\240\246\377&\316\357\331\221\361nl\0327B\015[\332h\333\376\351\0258\232\203\321", 300, "\260<4h\346\217Q\237=\376N\213\261R\257\374@!&\300\311\027\263\346'\230\377\224\134\225\237\002vQu\006\033y\036D\357T\362\316\311.\321\271\207r8\304\035T\226\233\326\345,\327\361W\217\364", 64 },
	{ "-\207,\240\261txU\001\360Q\213R3\332\236\037_7\016H\261d,", 24, ",U^\351\036\003\300?0&+'`\363\252j\202\270V\375\007\355DR^\032\011\237}B\304\031\267.[\266J\273]\325y\335\327\2555\201m\233\254\352A\315\214\337\022Q\270\330\367?\363A\021f", 300, "\220\326\330u\2268\305\223\255\2359\332\203\273F\203I~\012\232g\001\355jb\224\212\226\032\277\036z\326\0361\265\025[N\226\261$f\216\311\236X:.\366\036_\020:\247\004d\276_\276\237`\323=", 64 },
	{ "\276\035\274eI\033\356\262M3\021I\315\006j\241T\025\216\342\246\223\035}", 24, "1\316\345\252\312\377\027_\302v+.\276[\002j\006\266\233\037\265UR\023\255\244o\263\333\276+\264s\336\304f'\250\377\003\300\006\320\006B\375\205\300\332\341p\241\223\254\024j\274\231\024:\003\276\233\232\006\011\201\220\356\257\257\361", 300, "\271\353O+ C\226\325Qu\362\201Cb\304)\014\367\001\376\243\027\360U\273\356Y\235\234\357\243\002a\210\324\017`\304F\317;\022\014\021Y\375?\356\343\253\306\371\006\330fdD\333O6\042\203\214\354", 64 },
	{ "\342$\336\336[\306\001\033/\216\277\201\367\014\257\362\331\320\374\036\034\361\371N", 24, "\220F\317Y\0232\2022", 400, "\351\321\325*\035\023\026\377\273d.\016s\225\276\321.\330u\014V+\331Z\223\365\034\371\377\236^\203\213\240\375\220/\313P\024WS\331\034\251\347\220ux\231[$\334:x\014|\344\010\233U)\276\344", 64 },
	{ "D\255;\367\374\305_\373\372\020$\201\275\3735p`S\330\333\246\271\316)", 24, "\300M\273:\024\362\017\002\247j\376#8\321\260\346", 400, "rW\235\326[\326(\001\223\221\340\316\006z Z$\217\321\372\3722\277\024\334\025I\252\374\134\232\342!\2111\351\323}^\324\217L\032\350n1\372>\311\001\323\3239\321\345i\262\323\013\014\262j \336", 64 },
	{ "\200q\243(\134z\361\042cG\335'v\231\025X:\016\316\0170\342hH", 24, "!8\347\001?\220\313\251\3042\306\201\004l\012\356.\177\367~e\305\3269", 400, "\371\230\253b7m\177\266\325\344\350\375>!<gIL\313I\276\357\327\375\031\016\227v\272\216fO\250\226\3245T4\1774[\221\246\205\306rU\245\010:\314?k7&\337\337\010\274\003\031\305\210{", 64 },
	{ "\376mL\306W\276\307I\220\0377\307~=\224(\177_i\025\016KW\021", 24, "uM\345\215\317o9o\020\220@\034\0078_\301\376\251\001\244\271\023rt\357\237U|\277I\370F", 400, "\222C\346\307\233\311\251)5%\273}j\207\312\356a\254-\207\276V\010=v:L\210\372$\257lxO\331X\265\320a\177Y\005W\210n?\366aI\032DX8\010\372\231\360\222\241\260\301\353\342\042", 64 },
	{ "\365\016\366\0250 \037\313M\265\367\354\327Q\021\011\276c\0155\026\340\037)", 24, "\255^@\2710\375\217|\031\241\022\250#\347\217\201/\031\377.M\274$\206`D3\274F\213\253q\250|\302\203\221\300\344\301", 400, "\330\000\3218Hl\224\367\226\324B;N\337'\223.\2572\023\372N\277\310\210'HY\321L\206x\331\177\301s\373\226Eh@\360+\234bXu\327\037N \011\037aR_+\343\350A\020-_\222", 64 },
	{ "\031\367P\265S\025\224\354\273G\203\211L\3560\234:\134\026\315\250\304?\217", 24, "\322[\307,\212(e\3775=\2660\252\346(bQ\212\307Fs\234L;\177I\010\313\272\227\256\042WpF\362V\024\357\225F\355M\201C\340x\211", 400, "y\001\326\022\223\014',D\302F\247nk\3156?\342\230\014\003|\331\024I\216!\237\366}\237\351fMhM\035\015\225\362gk\246Z\334s\020\221'\035\027\002fU\234\324q;\260\240\350\245\220\000", 64 },
	{ "\361\232\331\355\367{X\357\033\346K \204\003\215\215\322\305re\241\245\342s", 24, "_\323\217h\017`\236\2053\017$mx\027{\241j\367\333\233\262\234d\042i=\006\222\210\334\313\253k\276\206\350\031&\2064\2421.~\306\261\015\042U\331vE\237\034\206u", 400, "[\273{\337%\242\275P\227\273\352x\267#\012\370`\305\372\261\270v\202\317\024c\372\274$\262\016h\3420\250\244\223\210\3579\335\230_\252\177Y7\276\371\313x\307\304\341n\201k\312\361\3505=\230(", 64 },
	{ "\042\230l\031lO\001\333k\036\327]\342:\314x\265\035\2663>D\246b", 24, "\314\354\361@\255\027O\232\037\322w\032\316\356i\023\333\331\342n-\301Q\002\244\2328z\026\304$\372\366\260cc\310_S\236\241\237\304\212[\022'\365\226e\016_X\303\323\005'\374\010}O\336\242\321", 400, "\273\265\023\023\343\261\201\026t\300\270#E\336\012I8\300\271\011\016`\234\326\2417\015\311t\012\322\341\355T\335\254\217L\243\253\211\364\234d\222-\344\203\027o\342y1\305\266\261$\316\376\364\220\317I\267", 64 },
	{ "\275\272\371\314\250`\370\331\324d(\227\364e\203!\014\322m\254kH\012\354", 24, "\2617\007\347\243\255u9\320\226\035d\341\311\344L\272\352\023\256\361\332\364\2700\014\247\331s]\234\223\223\210/\273V\364\335\015\032\267\357_\001q\310\367\260E\374!E\335\200\337\316sQ\205\023\240M\355\267\250\020{\207\254\231i", 400, "R\300\302\270\242\312\331\300\376P\201\353\0128\370\241o\233\316\260\030\222\303\322)\376\017>\007\011\005\222JPb\361\233\340)\036\352\242\035*>\373R\020\203\355\340\000\0212K8\311\240\266\134\347\351\216\326", 64 },
	{ "\330\2011\262\366s\232\025\317~\260\312\237+J\202\020t?\134l\207\310\304", 24, "cE\245\266X\315\3545", 500, "\315\247\030\277\337=T\214\254\331&\364\374\030\246\000]\220\345\274\373k\243O\0234\006\210\2606\031\360y\205\226\221\212I\341\006\216M\206K\211\342\314s\343\327\316\353A]}z@b\0053\202\212R[", 64 },
	{ "\250+>b\307\310\001\233\331\261o\360>\206\2733Dp\340y\017\372V\023", 24, "E\241\134\345\365\327\016\336D,\217\032\022E\233\262", 500, "O5\263\352\317g89k\247\351\020/\037\3033\370T7\304\256o\216\337\227\321\225\254hH\211G\316\224j^c\271?\340\036\003\177\001\205Y\303a3\376f \021\211\344q\362\255Q\341\264\244u\321", 64 },
	{ "\2153$\257\243\042\257\230\3443\276Y\275\000\354^\363\317\342#\343\272~?", 24, ")\246LD\006}w(\243\307w\260\336\241\024w{O\237/\236\004\230\016", 500, "\304\373j\036\0062\302._\327q\002\302 \023~\367\007.TC,\206\177DX\275Y]\224\366\232\212\001U\207z\305\233\317\320\203\3543\353s\374\012\272q`]\333W\305\250E\336VG\223\343I\257", 64 },
	{ "\224\302\305\230\315\313\231\243pxO_\014\374\342\256\237\231\356\330\215:\260S", 24, "\310D\2217\341\363\362\243&@$\221\340\320\266\213\236`LOy:'\300\244\314\212\302^Q\373\376", 500, "i\311\241\337\357s\333\356P+\023'\330\310\273\205D\354\233\343\310\306;\037\213N6\230\006\273\261H\272X\243\367\341t\234\035\263\2034{\203p\034\371gY\265^_\010\267\321~\272\34364\227\322\027", 64 },
	{ "m#\277k\323P\307\256\351\316\020\370d\202\377\023P~l\024\201p\033\015", 24, "\366g\225\335\215\223\322\241\007\333\007Y\275\343\330\267\346\003\006\306q\332\317\355\355\377\373}\303i\3322\262\322\221\226\217\305\027\354", 500, "\351\011\202M\306\035&\257KE\357\361\3644\243^\272\346\024\375\267gK4\010y\013\021\361o\253\025\2719\267yk\374\261 [\010\036\360yP\311\351v\0252\236\270i\217\356\022\006\214\224k@L\343", 64 },
	{ "\264\276S\014\276;\012]s|\330\273\223+\222\230\004j-\035u\260\336\364", 24, "\177\010jO\370\237\274\370J\333u\240\013\255\374\3621\342\013\240H\374l\372\225\016\266Vy\315\371\030*\024\231\302pLl\234\336\255\271T\001V\254\263", 500, "\225$\317\031\226?\314Cy\201\035-<S\2020g\215\037\202\327\001a=\372\225-\211\275\323K\262\271\244\243\317\244~\301\367\364T\260\204YC\030\304L>@<\030\252\205\014\245\231\277\271\013\317\375\260", 64 },
	{ ".\373qW\226\272\303\354\235\374\302\320h\345\357\034\014\250\344\266\244\325\244\270", 24, "\240/%\223\314\333\316\363\361\034q\245\312\134]\254\263\267\255f\225\217\313\313!ax\035\273\264\272_\027\037\323c\253\271\372\246\013\361\305\364\014\016@-\310\361\233Tc(\015\014", 500, "\010\250\337\244J\255\022/\001\035M\334\2426i\327\255\012i\333\217Y4\250uG\007D\225:\276\344|\027(\311\302\307\321!!A\003\343y\202\247\267\253R\032\312Y\243\134\007\252\321\236\251\364\307\342\366", 64 },
	{ "3\244\330\322\257\350\201\244$\032V\270\032\236T:YU\211U\265\327\262\355", 24, "\227o]\354 ;iq\224\345\203Z\231L9+\374\316\265\226\226{\375\377\204\007\223\274\273RH\244\134\243\224A\337W-k\362\372\317'\207\023\272\361\347\015\3371\344\334\226\277\215\277\237\351O\307\362}", 500, "I^J\373\327{\005\200L\373\304\022M\022\250J\253Iu`\345;/\023\325\362\001\032\367{B\017\366_\034a\257x\000\025}tA\347\332]#_\260\023\211{\301\310/@.&\272-\005\323\262\355", 64 },
	{ "\343~<_Kd\253{\262\357W95\256\337n\325\336\357\257\260-\227\011", 24, "\251\014\025\254\015\257!\326\256@1\225Ay\027\311\313\204'#\230\306\254\036\324p\221e>\230{\373ZP\236\025\025\3610\001\313\002\275\315\204\263\332\315\342\003-\326\356\216[+\270g\255p%\224O\306\365\241H\262\001q\231\346", 500, "\307\204\357\347\320l\0328\015\373G\336\271\322h\326\034\245\301,G\215Jf\031\177\355fhtW\034g\266\316V\034\222\042\346U\253Ac\036\304g$1\004\244\245VP=41\313\200\272FJe\374", 64 },
	{ ".\246\322\250\363\276\370\266\342\207\226\210p\366P\025FM\371\232\203*\036\303", 24, "m\221\370\307\016\020\374\317", 600, "\252D\266\320\035\2649\007=\003\326\355p\332;\021\277\360\200\255\033\313w\366}\201a\325\377A\033\365\321\320S\357G\241e\344\375)\0303E;\256\017 \031'\223\204\2630\027\253\225\354\305T\366\360\005", 64 },
	{ "\277\010D\025\241\325\032%\235\032y2<s\011<Y\377\225\352\244\330\000L", 24, "\370i\352\334*\266\264\012\3658l\372*\306\372\357", 600, "\364\254\356\215\306\033\275\312B\255\314\214\267F\307-\025-tv\3412\251\361W\370t\240\316S\302 Iv\224\246\004\375nyqJ1fS\204\016\000\272\302W\244+\377a(\2510\003l\366\002\202\374", 64 },
	{ "\364@\374/\361\272\034(p\366L\357\303\342\237\265q\200=\335m\346HZ", 24, "\311\2429I\020y\324\235$\345\013\260\300\323\230K\317\250O\017#\364\264\303", 600, "\324;$\316\314\300! L\200\337\003\301\276\346\032\204\212T\346x\027tn\206\252A\316\001\243\177\362j\033Xj,\214\301\025\024\004\017\315V}I\355]\314\250K\276@\027L\362e\2667\373\215\324\344", 64 },
	{ "8\343\210K\202+\330o&\213\367s\237\275\202\330k\262\020\217\272\254u\247", 24, "\347U'\014#\363\233\207\301\241\317*gUE\230\346\313\362J\037E\0357\226\273\037\225\226\265\026\321", 600, "K\213\220\325y=\007\255\361\203\376\376\354\303v\215+\244\360\272m\020\273\212BV\300\261\334\250\214N\304\333\034r)\3515\357\025\377\334\231[\351\013JE\222\332\322\250>A;H\020\214\333\306\356j$", 64 },
	{ "\002\261>m$`\016\02494\263\307\353\263\252r\006\356x\223\215\321\236\037", 24, ".\222M\266\201\371\370\375\214\134\223)\242\011\371\225\365Y\203*\365\275\252\037\262\315\024;\032\256SuK\275hn\231\233HN", 600, "q\223\223]O\3412\371D\304\246Z\277P\267\307\247\327\213\036$\223\234Q\021e\332u\004\240\254\316_\012\036!\230\213\233~=\233Ay/\313\010\204\207\220\312j*\016\324\347\042=\017\217Qn4\302", 64 },
	{ "\216i\036Z\247\365\202\373\255\243\035o\301\221\013\3434*r\347\214\002\342T", 24, "F-\311\364o3?M\260\205\340:)\302.>#\203O\340\245@6\375\356\313X\267\302c0\014\325\261{\013\267\253\277\027W\254\004a\353\350\255b", 600, "Uq\242\257\354/\372\365\027\376\020\267#S\277\237\300\314t\021\234\370\034\320\206-\357T\272\370\204r\002ZAsX\356j}\012\2259\247\231\211<6-\372\027V8ZM]\200\2344\227\276q\033\322", 64 },
	{ "g,R\261\255\355\242\315\344\302\207\312\216\326$&\246\352\351\004\230\372\357\342", 24, "\011\237\227\033\026b\224\320Z\340\2019r\220\367\304m\256%&&\3424zt!CY F\014\347\345v\255\230Se\372\021\242\203YH\277\262\213\301\327\267\314\036\205\0020$", 600, "\020*\217~@\030\030z\241\300Cf\230\362\037\343r\203\344A\304Z\223\2310\331X\377\365k\237\245'l\223\024\012`\345*\324?\310L\344!\270\340>\001 aL\220\001\221KD\235n9\333\362\227", 64 },
	{ "-^[\305D\215\276\210\007\255\365\315\023\340\343\011\212_\340?\215(\221|", 24, "'(\221\177\261K\003\247;*\201=\251?\240\345\026U\225\252\355lg\342\310\021-\006\004\270-\256\340&\007e\304\042;]K\306b ;h\222d\353\277\030\332}\355\030\001\347o\375a:#\207\232", 600, "\213{K\321\232\301\253\312\037\324\340\2454\262\376J\335\210J\235\252\220\370-\004\042\134C\316\025\275Te\250\333\212\227\324\035\006\244c\273\004Mq2\276\373\005w'\212f\266u\010\320(\361\332\217W\000", 64 },
	{ "E\223\025>\255\312\337\310X\234\377\032\243\275\366\347~QmZ\027\013\257l", 24, "\202\021:\372K\001\252\250\363`\260Lk\255\042^|m\312\370\200,Gv'\255\024\022<\357\346\002\016b\252\315,\303\374\247\326\324\352\254\322\250L\306;\315\311\374\264\042z\354\256\304\021BD\231%\236s\321n\236\251\022\006\262", 600, "T\024\252$\261\307\0362\033@Y92dA\366\341\204\33236\265\357\205\232\266\027oI\245J\272\233O\215\317\302\246\374Ko\204\270z\356\236\042\315\360\312l\231{\274\026\225\221\345\377\343MG\321\320", 64 },
	{ "ew\357\210D\321\347\2421\315\323\264_\036\253\332^\253\325\271I\211\212\250", 24, "h5\202`\361F\354\312", 700, "o\325\241\254!\217\211\331~e\346{\211Z5\371+\353\334\134\034\207\213\243\270I\334\317S\312X\344\326y\217f\261\021\243\223\251\015h\022C\303\026\036\222E,\203\366G\362Sy`\3241\3205\262\265", 64 },
	{ "\275\247\376Y\223o+\2440\255\024e\351\324_\203\206\326t\333\134\332J7", 24, "trXoC\241\333\350\3415x\210\356\307]\243", 700, "gyBJl\234\206\356:\023K\310gd\312\200\346\320\2479V\272\340\000\024J\316\362PI\271\263\202\022Yhs\302L1\234\037\267\200\312\3641\0171\265\217\215\205S6\243\222\300d5x9\306\275", 64 },
	{ "\001\024\003\337\276\355UDd\202\271\302\262m\021\205b\021\234\3108\220\226\343", 24, "<\015&\212c@\264\015n4z\261\252>\355\025\231\363C\224\311n\313-", 700, "g\2301\253WQM\014\240kG#\037t\014gaF\007\234\317:\261|C=\344+\252)~*Pr_\037\376\013y,\377\376\344\2419\266J\227\260\2123\225s\344s\224(\204\024\344@\001c\255", 64 },
	{ ">\030*\353\341\240\203\312r\031t\260\265\012\345\331\354\016\014}\306SI\351", 24, "Z\020\013K\254\006\0164\347J\264)O0^a\025T_(\243\025p\261\210j\203\260\233\026\263\360", 700, "\223\3078V\010{G\373\301\030Ea\340\335\315\251\237\257W&B@\022+yHu\2165Y\377p2\344\003\340\341\326f\134\262\267\253\037\300d\312\030t\030\324\211\032Y\255\257T\237K\332\220\310\307P", 64 },
	{ "\374\310\024\302\321W\213\250C\252\275\336\024\341i''\022\373xg\007\247x", 24, "\3404>\007'\303\215\331\2719\357\362\010\2146Nf,\272\304Hd\226%\251\2659\252\336\224@\355\357W\024\322\265\341\355\226", 700, "\273\207\247\374n\350\247\030\2469m\313-'\204\200h\022\356\320\341\302\001%ON\343\244\316\227W\212\3252\317\234\366\275,\033\261}\325\350\341\207\203\306y\010\034{%z]r\350\206\201{\017\330|\031", 64 },
	{ "\240+\274h}\2040K(f\267\320\015\265CC\337\226\200\335\032E2[", 24, "\240\266\274n\2077\260C\005\223\036\004\011]\322q^*3\276\235\226\320\027=\344$M^\227N\370\022\234\313\007Wk\366.\205\016\365\350\200\020\217E", 700, "\212\232\234:U\323\302L(\362\221\016[\270\266\001v3\253\225\340t{\016\226|EC2Jx\377\264hn6\331\266\014W\245\233\277m\020\353\245\023\221\016H\000|c\307\362P\027)5\323\0230\344", 64 },
	{ "\030\307\267{\345\270MM\201\325\330:O\224f\313\005\311\325\310\210t<C", 24, "\240\201]i\274A\034i\352:}\134\024\367'\300T8\256\217\377cm\027H\3617\250\210\276\013\364\031E\240}\252\004\034\222[\330\373\013\021\003\025\036%\011@\362\030\232\342\250", 700, "\374:\213\373\257\356B\374\274\021+\352i\022I\206\346\205[A\376\275\322?\245\212s\030\262,\301\015*\370\350\326\024\227Bdv\362[\177!\016\261\276L\322\226\265\0337\016\207\325\321\260`J\277\363\270", 64 },
	{ "\325\272g\264\270iVI\230\366IkD\347sy~\232\272\200\347\337\337u", 24, "\134\247r\3219\313\346\200\227]\377\235\304d\214\310u\317\014\243\261\345\267O\256\010\013D\035K\245\226\375\217\3611\001\013\307\220k:T\025\226\304*\225&\255e:\207\246\375\317\224\304\251\275Z\206;q", 700, "\262\323\010\0153-\007\321\273]\337\032\205\230;c\210\310\343\034D\214\003\234\003\355\274j6.\326s\037\315\216\237\000\371\350\213\347\365\351\340\010\356\260\366\201\227\340\3711\262\3773j\306\042]\273\211\332\032", 64 },
	{ "\357\334>Ja\022\002\010\374\335S/\247\253\270\010-\205f\257?\330\234\032", 24, "\335I!\203\271D\364\336OF\220\225]! \362\013%Bsp\326\341\343\360K\267\267\367L\354\370@\371\035\227\225\360Z\205mx\276\371F\247P\344.\223\264\221x}\322\225!\346\350\256\2742\253\265C\367\377\022\036;\017P", 700, "(\036gv\030n\0139/\250P\272\313\230\351\226\211\363\237\312Y\037\272\311\265=\351\343\305\374_\246\235A\264YD\304\334\202K>\037\274\336)\301%\366\242\246D\324\134A\303\2414\276*\031Y\376\357", 64 },
	{ "#\0427\244K\257\006l\005*\256m~8+\317\373\325x`\224.\320\221", 24, "\261f\203\226F\362\245\334", 800, "\267c\357A}cz\243\206\233+\230\256=\203\034H\007[\32169\375\366\322J=hG\336o60\336{\244\037\2775\326\243\213\320)\337\003\370\323Q\232\242A\306ZRT\016\242\242\350\372\015\220\260", 64 },
	{ "\347\377\324\375\314\303n\375%,\010\336{\375\3320\227\344\2662\0024\325\365", 24, "\361\311\366\227\314\275\335}\213\1773o\371\231\357K", 800, "\273\267\010\210e`\307P\264k\012\345K\247\362\367\033\310=\000\225\035V\220\312\213X\314\341\273|9\325\275\304\241m\012EI\271\302\2747\331A~\177\032#\233\376\353]N\301\365^Mh\272.+\260", 64 },
	{ "\357\2528\231\262a\032ZJm\3157\260\331<[\232\27441\372\310\267\036", 24, "l\001\255\324\355\0220\246E\206G-~-\333\004\331Y\026\363\303R\010\324", 800, "\246\354\213\206<\223h\204\367\333W\021!2G\376\014:\373\013\327m\225\227\336\250\342\221\310\321\363\253z\354\022uk\342\177\302\213F\3758\021\341mgESmN\257\356\014\276\344ju\372\332\361\014\011", 64 },
	{ "u\267\0421[S\023km]\353\002\364\331~J\3503\376Ay\335L\012", 24, "\352\204\321\301fO\005\370g\003m\307\304\344\354:\030\244\216\215\026\331\262\2267\223\3655qX\252x", 800, "\011\254b\343o*\216\240Dp\215<U\244\235\272\372_\042k\233\034ia\244|=\215\206t\363\333|\276HB0\311\233\023\257@\004\2428\017\251\234\237J\003\207\333\335\263(\370\243Yo\206\244\031\235", 64 },
	{ "\233\342\010\335\331\134\3669g\031\337\033K\261\267\0421\177\332&E\340.\337", 24, "i\367\302\236\300d\014\025ch\323\320\376\231\211w\223%a\372\365\257\237\337\243\277}]\322\177u\375A>\015A!.E0", 800, "\375\240\241\236\314\214\274}\266\250\225p\024zo\012\354\220\377#_\210\001\301\343KG2\362\312B\335\331\304L\224\205\267o\320E\305\233G\021\031\2726iE\267\257E\217\310\313\247\312\232\200p`\266\375", 64 },
	{ "\255\032\237A_\223m\000!7E\226\354wSZ \375\207\316\2177d\031", 24, "\324\234\005\333;6(\316k9\134\271r_\035p%\350Rm6\2418\025\204vv\212b$\321\027\314\250_\3478\233y\303\301\370\016\200\301IZ\316", 800, "\316\312\267%f\212!y0\237 \243\207\371\274\321\134\274!\327\362\004\014\210D\250\232\307PbslaL:\252\262\201#\315<\220\232\275\273\246G\311\333/\032p;D\253\235\2401b\016\224\215\134\341", 64 },
	{ "z\006\205PE\271u\361w$g\362u'\134\013\240U\303\0055\305!U", 24, "\0279\275\233\304 \031Fb\231\224\204\276\203\021\011kM@\341\223\236+ \262q\337\212\376\222\3471\243\3615\333\247\340`7\004\3137'\263\231\302\327\3253\353\326VP[\263", 800, "\011\253 \313\264\371\333\363\017o3(F\001\234\207\243\263\376G)Y>x\271\332`\270!\250I\375V\300$\000C\206}v\345{\247\257\314\276\017*\365%\332\374\242\242\343\271\243\210D\200{+\254;", 64 },
	{ "\367\212\237\347\371`\021\024\317\363m\366\226P\240\271~\353l\015\204[\350\306", 24, "B\343\221\021\345\275\004\353ZB\274\223t7\313:\233\255\233\363\361\351\014\315\314\325\343^\370\301S\012\212\317>%\022\023\210\352<2(\224\311\312\027\232\327:\227\214\230\363\023\037\337.\024\010\372\317h\023", 800, "\327\304K\020\214\277B\366\002\330C:n\353t\334fXe\351P\033\032\311M+`\320/r\265!\301B\231\350`\001\013\311c?\220\333\326\202\216\243\365\245^\245j\377\372\210\307\272\303\342\216\370\210\355", 64 },
	{ "\212\264Q\307\376[/\236\013n\346\243\030\322\026\321\205\216\324\214\360=\370}", 24, "\202e\341xV\033\272\236\340\342\216:\016\2516y2G\267D\211\375!\247I\342\021\277b\031P*\207\035P\205\244\235\311\310_2\346\023\354T\004\304\327.\332TR\312\346\034\212\302\251\134\005\310\016\004\200\257L|\205c\303\205", 800, "\220\242\272\200\024,\341E\312\361`\270\304\345\016\037\273\273\341\301\134\224\316\032\003\324$(\316\234o<\250\263?6\351\024\312\042d\373\366\320\036Pa\015'nX\213\033:\313N{i\134/s$=@", 64 },
	{ "\274\322\370Z\025\306%\003\310\201(b\362P\000g\264\011\212\340{3\244\236", 24, "\256e\007,5\002=\262", 900, "\005\001w|\222\320\330\021\015P\305/k\244+(\002\366\277\207\243a\302\350\301\227;Mdc\250\024\370\006\311\007\226\302\037o\367Wg\377q?k\005\223u\021\036\375U\321@\363\232\317\363\225\177\3303", 64 },
	{ "f\247\021,n\027\321:\311Y\243M\345.\204Qe\302\206\301(\205\031\235", 24, "\037^\213\344\352\177&\134\004\203\203{%&\027i", 900, "\253m\201\326M\344} \345K\2152,\245a\255\306'\265\353\216\011\217\004\207Y\271b\234\222\230m\016mu\340\231\035\235\215\3413:\004\332\015\310yR\260\023b\206\000\230\007\314\214\370 8\011\210\313", 64 },
	{ "U\257m1\225~y\202\247\245\346\262\261&\252\253\261\375\022\303\247<j\344", 24, "\317nW\220k.\354<\216,\361BpOg\344,\361\243\364\006c\205\372", 900, "\304|\026z\316?\247\327\240\300,\306\315,q\333uV$\364\3113a\301\222\362\266E\345\303\3540Ck\254q/\204mB&\234\311\234\320m\353\261\225\355R\355\214\001\215\362$\346\336\304\214I\243u", 64 },
	{ "r\322o\336\354\307\264\377Z\343\001b\007Z\274c\305\275\214\265<A\372\201", 24, "\264\025-\211\214\371.\260\356\334\002f\277\134\265jd\341d\277\234pN\210'\361\353\377\220\350R\200", 900, "gH\223-MD\365\211\322^\211.\251\200\346\004\336\252\221+\265\304\026v\234\026\305.\305\270:dU\365L-\276\042j\241\264BX\376\260\313\032\367\026\317\342$\244\210F\010\234\335\377\334\027b?\030", 64 },
	{ "\357\253B\361\221\317\276\014\001\344\310\024\3269k\233\324\252.\351\374.3\372", 24, "r\252oh-\222)c\226\012\0159Em\303N\240\313\336\313P\267oWX\277\2155\032V\367\324[\006\320tl%\007\305", 900, "-\035\234&\233\305\302]h\300\343\351\370\274\217\2001\346\312\276r\300SL\025wJ\257\251x\205\311\367T\332\262\233\221\367\256\003\234\316`\273\226\262\312\205&'\2449\375\260\206\216\267zD\010b\024\266", 64 },
	{ "\021teT\012\013\023\355\233\377\036\003t\344D\333\251\336\034\211\332\344\375q", 24, "\271\376\324\336\2374\201\300\303:c\0305\010W=\302\327e\375:\305}\244\275\210\317\246\255\005$\204\215Ft\225\031v\034\2326\273w\012)\317\302\253", 900, "\372yMd6\017\2368\014uJJ\271\0174\363\271\205V\274J\206\365\250\026#PB\214\201,\021d\0264\221k\030\255\222*\317\315\234\032\235`\274i\364\231A\017\042\013\325\375\220ySb\246_\023", 64 },
	{ "\317`T\2038\305\247\261O\235n\021Nf\255\014b\237\316\226hK)8", 24, "\274\346,z\027d\020\274'z\350fUh\247\364\375\324\015v&\327\237A6<}b\337\033\375E\205<K\017\032\213\001\307\3357\312d\274\312k\245Ku\030\035U\267Zd", 900, "\327\352\362\257\276\005\015\355\134T\201C8&\030\220\213{e\014i2!s\207\346\327\316\262\352e>e\351\342\321\260\237\275L\220^)\3519\017\261\013\364\243\037\030\277\375MkIo\275y\004_j\241", 64 },
	{ "\367B\325\214\226\364F9!\304<\320{\342kg\315I\315\023\316\372A\336", 24, "\240a\265\361\241\204\221O\347\345\026K2\336a\357\304\037F\311\341\276\216\343\360A\334\014E\317\265\203Ik\346]\317\031\272~\365\267ft\241\015\350GX\235\021\037;\024\033\354\2124J\337\377\304\203\250", 900, "\202\242\3013\2208U:\340\237\377\261,\312\016\251^\260\271l\324\213\034\311j4\011\236\254\360\251\341\347\310{H\017\320 }\232\274Jg{\217\324\257\363o\357\344\026\026G\277\310\004\242\235\263\357-\222", 64 },
	{ "\016\270E&%\327f4\252\212>4r\344d\252\234\271'\254S\324\352\350", 24, "\375\306\361\014e1\036\264\033W\024j\367\214\265\027*\201\337\333\233\275y?\027\270~F\274\346dC\364w\211`L@\364PCo\257)#\346\343?)m(_k\252K\375\275\003\3456\376\2240\036\360\222\373C\265\217\322\251", 900, "\302\205\312\343Gl\252\336J7\013\234\355z\377E\3711U\311\204\213\332X07Z\222\333\017s\351k3\333\370\273\352\361nvB,w\315\202\214\327\367\351W\3560\350\377\016\2111\323\315Rd\360\241", 64 },
	{ "X\241g:\042LD\026\033\305\2103\347%\313\222M%IxT\3311[", 24, "\354*\024\334zTk&", 1000, "TW\205I\026\261\327\304\271\241.\340\134\260\241U\257\312\000L\177\012\002\020c\266\333W\352q\331P\336\027\357\363j\356P\3036y\357\306.\361C\232\134\245[\366\203\213\307}r\255\350\324~\330J@", 64 },
	{ "P\273\256\313\320\002{\007\246Q\235\261\314\225\325f+\265c\221f3\037|", 24, "\3772#\270\014I\036\251\274<S\330N\376\215m", 1000, "\347\3452\211_k\005\334\023\365\360}\245\213\242\367\300\315HLN\212R\230\037\224QL\241\220\374;\334\023\332\306\255\017^X\234\374ak\370 \247\001`\345o\255O\315\275\3052L\012P\340\307\014\305", 64 },
	{ "J\242`\033\017\337\255\360\324\326\225\221}7\335\307\357\376\315\360\211\273\246d", 24, "\275j\034\275\221T\245\036+e*\225`\301\342\0125\2330\330V\212jt", 1000, "\016J&\254\205\215\330\2111\350\013\034\372c\273\363=|u\0377t\025S\025\0177\302\332\213m\326\0169d\263\271\037X\263\251\334\035V\2564`\260\033N\356\237\245\344\322\323-\022\356\203YB\337\314", 64 },
	{ "\001Q]=\016v\371)=sJ\245\042\233\335\322c`\000\303i\265|i", 24, "\226*l\351\350\326\021\027\201\3548\223=\376\250|\226}\234\352\316\224\327R\324\027^\235)\232\230u", 1000, "\244\257\326\351lw\257J\300:\373\206\027G\326\217\014}mB\243\340\361T-\030p\236\034\367\265\350\234\326\270\300\265\274\211\213\215\303\365\341\257\227-\363]\245 \351\006\364\275\037>\343\270*\254r\244S", 64 },
	{ "~\021+\245uZ\362\213\366\200\022\206\215\334\351NYt\355\377{\353m\027", 24, "\2447u\244\364\217\330\177\207zVy\210\026|h\302\255\343\012l\034W\235\214w\263\270\256\236\255\312\134j\272Z\350\134v\357", 1000, "\323\021P\223\322\235O\310\243\376\254\014W\021\250#\357\307'\305\362)z\177Y\177\354w\265\015qzf\333>\020G}\011\355\350O]\253<\221\251A\013\315:\023\201\267\010\210\372\277B6\241\244*\314", 64 },
	{ "`\216\220\304\345\323\032\361\230\006\373k\0015w\247j2xL\303\242\021\301", 24, "\354\314=\001]\034\307\013\035\250P\231Pi&\031\205\203\027Y?\360\215nEQ\021\336\373\215\332O}h\264\207\253Ah\377\376a\264u\251\002z\252", 1000, "\321=R\262\037DS\377\205\222t\316\371\353\206\267\315\313\246\364\3673\010%\224\351\307z2\230\360\273\220\311aGp\2636\015l9\300\345\003\326r\356m\203Q\235\232O\227 \352\341\021{\267M;E", 64 },
	{ "\354\004\006\232\301c\330+\321\346{\032\251+\226\274\273r\2126K\000\000\320", 24, "\244\371\011l\010r\042\231\366N\007\354\251\304\237\021\200\314\321d\330P\027Jgm\022NQ\015u\354\016\023s\363\0059\003x\243\366\361'\375s\330\266\310\334]\350\201\037\330\177", 1000, "\262\340\313\343-\0366\257\034\321\223hwX\317D\305h_\036\012\323\303\360(\016\014\351\244\256|;\031\316\355\317&\244\221\374Do\370\351\372\233\344\027\237x\225\212\032\026\321>\203\335{\263\343h\254\245", 64 },
	{ "\306\321\026\304\337ii\326\313\346\326Vw\314&B=\233:\237?\221\201\353", 24, ")\344\304\012\2374O\241\033;\035\3024u\021\243\347\201\314\277u\304\210h\252\022\241\237y\031In&\3374\356\315b\214\004\277\370;\330~\237\335\262\275[\373\3121t\005',\211\201=I\321\216\334", 1000, "\376L\243\307O\223 ;d\203\232\017\217\324\246\260*=>\377\373z8\226\237\255\341\320\342Z\301\015m\363\005\201X\026\202\221\017\351\301\003M\366J\031\263\035\001{:\307R\026\356\367Ww\226\2106N", 64 },
	{ "a\201~E\177k^\377\225\372\322\254\303%\007\300\327\315\250\025\257VA0", 24, "\270SB\012l\322\243\037q\035\317;\324\307\324\351\347\030]\245\265\366X\2650e\322e=P\205R4\344\245\227\221F\272\356\034&\323&\022m`z2\275\303\266:\207\212\213U:,\035\227I\275\347\257\023\211\206\211\324\377\364", 1000, "\224F\035\020\272\0235\366!5\234\200\355y^\042+\321\275nk\247\366\034#b\235o\214\277\020\375\344q\374\035\261\263\222\246TI\221 \240u\232[\214\346HB\221\322\003\377r\371wG\025\035y\345", 64 },
	{ "(A\2328\302\034m\303m\265$2&\227\250\016Q\3779\275,\313\013h", 24, "\250\337%\227r\334&S", 2000, "\241}n\035\312\202l\273\322\352\272\252\212)\335\230\226\325\012\362eE\004\315\357\177\245'\022\0052\244\024\014\225\227\007\243As\277\251\351-\262\246u4\312Z\214\274\202O\376\324\262m\035\201\360*\343\006", 64 },
	{ "\224\227\346\024\316\015\012\374\275#\026\307#\012\262Nr\313\353+ \216\372\032", 24, "t[\215\345V\325<\254\367\361\255\343\245\023\017C", 2000, "u-\242\357\275\260\2226\270\312\037\230\275\372rS\327\216l9\316Q\356\210\323\210E5@\217\347\036\032C\202)\033\230f<\227\023\256'o\233\247\006c\320j\244\341\020\134\177\313\177A\214\336\215\230\322", 64 },
	{ "b\247o\224K\245\234t/\302\265\264>\310\225\024\015#\255\227>\225\022@", 24, "\211e\230C\273\3177\2211j\365\030\320\203H\255\017^\256\324S\212\266\372", 2000, "\302\004\0071\000\034\042\360R\205>\020.\016\334\042W\230c\250\222zs\337-\377\373r\333c\001\371\272z\363\0003'\362\202raS\244V\354\377\344\336$\201\336\322\372Uqy`>{B\021\234\030", 64 },
	{ "\002,v\342\377\027yk\360b6]\032eS\242\353\011\353\204T\307\207\022", 24, "\236\177\303M\345\365\027T\017\323:\360\225z\271\361\220\265\017\300\273\030\223\2531U\316T\020)\225\375", 2000, "\340\214P\252yt\0126\301i\3054U\217\267\024\364\035\306\003\376!/\345\374?9\250\207,S\031K\276\223\257\364\346\367\241 &\256\271\314-:\272+n\367\023\272\311Y\346\004\225\315\016\236\205\306\350", 64 },
	{ "\004\000\227\245\266\231UzT\033sW\240t\234\004\356\320xazQZ\033", 24, "\257\341\327r\023?z\022Y\205t\302{\252\341\027\341\333\260_d\030\206\354\367\026\302*M2\225\347\336N\253\251&Ad\276", 2000, "\353\364R\036\042\354w$=(^!\317\207\266\342\212\215\263\250+\307H#P\011\3448'\212'\030m\037V\021\212\375\3601\311B\233\361!9\036\2135\034\337\264T\331\346-k\222z6I;\303\360", 64 },
	{ "\015\213l\014\376\305F\340\317\356[<8l\000\235L\361\327\3623\251,\032", 24, "\356~\011\332\242\011\203:\271\222\204xV\274#\0064\016\237\364[\377\231|j\031\336\272Q\007\331\371$\010\361\231\346\205\337\340U%\230\241\221\202f\267", 2000, "*\230O\020\204]\354H\245&VSOk\247\352Jd>\243\322\351(kX\302c\177UhS]\001hq\245K\320oB\201;\335 %\3164\256\024`\233\273\256\304\324\247\321\345|\023$?cJ", 64 },
	{ "\203\371\026\261\020\021\004\370\246\244o\321\365\355j\004\200\367V\304>)\355\300", 24, "\260\347Jg9\373\303\270u\270\253\343C\300\336\010\307?\016bu\366<\334!\312\337v\240w\177[j\227\224AU'\037{\032\245\347n\343\011\370\342o)\214\354\265\236\234B", 2000, "G\345\0377\201\012\226\231\207F\224\006\035\236p9\303\365\3250\223\226>,\313\330d\317\237\312\3238BN.\257\0155h\377\034\236\331\223\037\307\3416\317]\203\302\252\356\234\230^\027\220\375|\0341\006", 64 },
	{ "!\323\234\201\027.\265K1\243\334w\375W\367s\264\232]^\011\243'k", 24, "`C\241\225\020\3131\226V\311\257\355\361\313\326\304\003K\206\266\311L:\327'\370@\317U\300\027\207\012[\246h\247\004d Re\027\247\222\323\212\225\324\020v\252_\252\255\361\367\303\020(b\015\346\336", 2000, "\332\363\361a\364\375z\356\215\366N\256\330L\022H\2644\134I\362\373\310\212\213\262\326%\366\351`)\315\014\356a\266\037\352\262\236\365\326z)uU\374\364cq\307=\331\013\316\243\335\033{\273\244'c", 64 },
	{ "\263\266<g\264\006\270t@\246\036\020\370ng\270q\2354\326<8g\322", 24, "\011\354\243T\342\245\336\376\205\342}\200\240\246\245\342jwQ\026\334fj\214\217 \343\324\233\036\0135\303\353O\337z\326y\300\354\273\016\364I\222\363B\321\023\234\200\221\032\010\255p\213\222r\241d\247\360=\032\252\031\276Q\344P", 2000, "\275q\253 \305[\023\277\357y\331)\360c\277\256q-\272_:\020\301\026H!V\247$\341\250\304#+\352Y\263\0176a<\276\202\271\010\235\322\317\001\003\007S\300\326\311\254\024\271jp!d\226V", 64 },
	{ ";|\254\203Z\375\011\366\211:\027\033\373s\035\020\3351\034\214\036\240/\371", 24, "\352z.\3715\305\236\346", 3000, "\021\327 \326\306\266\022}\355\375\217\206\205\224\220&\035\301Yz<)5D\177\264&,/S\362\374\336ey\216{\320\241t\354p\207\025\360\301\355K\272\276\300\356\221\025jq\232\371\251\343k\253\215\307", 64 },
	{ "\227\017>\230s\247\032\243\235\271\203y\245\243\012\276\015\230C\230\262\213T\346", 24, "4GO\256\202.5\272\256\313\017\307\220\252\234E", 3000, "\223\021;\244\350D\254W\275\346\222\261N:\235\364\316N`V\307\134\004\037\005m\332\222J\324H\020^\325=\233\356\350'!\035^\245\025\263\022.\272\004\254\342\243?\010\011k\224\331\331\2322\336R\242", 64 },
	{ "\237V\216}VW3\357\037qC\305\317\207\302\220\351\331\037\375L:\022 ", 24, "\336\277\323o\333\220q\304\274\313h\237|a\327\323\230\261(\371~\020\327d", 3000, "\211\017E*\360`\315\036-Q\374A^B\343\020\200y\034\177U7\340\260\371?U\221\323}\321\212\261\255\3411L\246\315\334\004%K\01749\207\341\027\313X\230v\300\032=\304\340\307\240\005cu\036", 64 },
	{ "\277^\326\265S(\042\033\000\346Y\234M\000\310\025\344\3171\343\230\017s:", 24, "j\301\025\325\364\345h6p,\377h\322\372[\215\262\261\235{\355\352ae3:\042\337o^\270\226", 3000, "\367\314\334~\313\305\216R\375\313\317( W\2524\237\367t\006V\356l\270\305\025b\351\372\016\205\274\032yn\321\366B,Z\300\245\310\364\202\374\336y\325\015\221\342\343\223\254)\340GH\354\021\235u\354", 64 },
	{ "oP\0024\027P6\376C\272\232\025\207\225\3616\361\26629\313\004\375$", 24, "\031r\357\216B\274\223?U\2367\002<&\2615Lj\012\276\303\327~\373\314\373\3762\010N\177\231\324\036n\334`\317\013\200", 3000, "&\322\212\306\227\365|H\226f\313\2425.p\030V\261j\350|\352\205:|L\316[\023\305\222`W\264\246-\232DO*+\343:\241\251\320\233\354\377\203\246\235S\027\341\250\316\327C<\226~\346o", 64 },
	{ "O7\204\017\015\252\361\327R\030\367$\314\307\217\207\252\323\333\270\213\207]0", 24, "'\234\271/\326l\237\264-\337%\332\012n\372\276H\262\134\263\336\213\337\021M\234\321Q\227\333r\266\304XS\343\211\256T\322\303\234\211\260\241[\037\271", 3000, "_\203,Z\033\317!\350W\356\335\2426T\015IE\012s\331~\301D\012\374\306\235V\321p\340$\353\263\331\237(76I+\000P\342/\001N\345\313\241\214\377\333\377\360Z9}\3544\236\201\370\351", 64 },
	{ "\244\350\3759f9f\300\002\015\214P\344\022\200\351[\134RvR\363\225~", 24, "\204\253i\244\217\223s=\217_\313\242\024<\252\241\3530\215,\212^\335S\257j\331\003DNLn\2414\035\017,p{\364\360\342U\032\254\007\021\036\256\345t\253\316M\021\254", 3000, "F\264\340\263\355%\367\007CHC\304!5o\030K^=\305\204P\305gIJ\274\177s\232?\341\000\364\014>\214n\236\004\363\250\323\324\211g\025\371\004Y\357c\351\033(O%\312\267\214\313\001\003\274", 64 },
	{ " \373\314\232\000\2625\230_\303\350zD\210\252*\034\305\005\017\355\356\227\270", 24, "R)\032\244p\363 !9\274-\205\343'\231)X\346\025E\323r\032\357\024\020Fr@\013K\221M\376a\336$\024q1\310zU\031\271\274\325(\352\265\017\042\210\016\276\271]\330\252#\244X\261O", 3000, "\241\362\014\177\002\312\211G\001\312\001z5_3\207\232\300\227\245\201J\255\376n/\177(\371x<\303f$\353\210\014\232\232[\244\277h\353\341\022\320\325\002TF\352\037\264Tf\2676\370\271\321\363!\307", 64 },
	{ "\333\025O\227@h\274\2608\237\300\004\377\223\022\320\341\312e\202`xN\263", 24, "a\042V\324\255~rU\355\206\366\202\005\354\002}w\033\215\266\010` \215\226-@\231\246\376\340\010\023\015\216)z\221\365\327\372\262\203\035j=5\265\243\242E\035n\036\014\0177\367\205\237\363\031\346\264!K\357Y\350d\375\373", 3000, "\003\242\243\204\364\011Z\213&\276\020\270\364\204\275&v\013\015?/d\352XM\302\306\371\242l\360\033/\247=\277c\331:\021OUK\262^l\270]qh\242\257b\213TJ4L1\364\366\253\201r", 64 },
	{ "(n\026\312\205\343\005\033\363+;\013\305ww\340`ET\312*\2063\371", 24, "\327\336n\263\257uk\336", 4000, "Fj?_\352\260\304u^\354\210\205e\025_K\026\277\346Vrq(\224n\204\371\024\221\021dc\360\030z\270eu*\203\365\336p\32321\305w\347\245\265\337\212}S\302\247LR\377{\002\203\235", 64 },
	{ "\275\277G\270\316\265\317Y\033\321\261\3341^\036)\235\253\253\274\014\227\327\374", 24, ":\311\227\357\355\353V\261iP\265L\354xr\262", 4000, "\021\332D\300\265\336P\356\226\215\014[=\000\234\027\224eX\022\260P\220\207\315\274~\030(e'\314\134\256KX\015\022\361`\315N7\021$\005\213\027\327\230\300\212\246\267\010UF\322}\260\276\006[\273", 64 },
	{ "e\3241\366\225:\037\220p\032\242\346\364\341\237s\332\235+\033<xe\027", 24, "\305\270~\333\313s9K\307i\247\303f\313\270\243[E\266\334\344\335;\007", 4000, "\240\277\036$\372\225\232Q\003\3203\373\367\343\370\025\225\305x\307d]\011\374\335aq\022\034\022C\355\011\340\341\366\301P\332\3016q\021\343\247F\245\321\273\224\327\323(\250@S\2052\255\2013$1\334", 64 },
	{ "\306T\011\2261\274\303\245\340@\300\374>`\007\333\260$\241\007p\013j\007", 24, "q\326\233\230 \340\376\340\330\241\255\270}Qb\037\331L\363\243\021Fe\012\204\210\220 \246'e\323", 4000, "\233A\343!1\343\230\230\201Xu\272V\314L\330\204\217\301\265\376Ph\035s\321\253_\303\224\201\262M\350\365\375\302\325\217&D\234\314\320D\210S\370L\3674\217B\311\251\313\237\243\202)\030\022\307\336", 64 },
	{ "\266\015\355@-\222\245\034\2232\353\327a\326[\223H>\212BBP\212\221", 24, "\207Q\350>\367*\313\020LH\353Ap\025/e\240\033\230\221=\367\325\243\326Bp\037KHzi\302\017\247\254\306\375@\346", 4000, "Ii\225\355?a\327\357\035d\007@`A\307M\214\027\304\205\376\343\2641.\325^\336\030g\275u\351\333_\205@Q2v\255\263\353O\243\006Q\243\303\031\252\252\036_\020\3739\202\307\177C\314{\271", 64 },
	{ "\362\272&\200\012\014\365\001\341\023T\232,j\201\202\324\0042\256h\377L\250", 24, "=\013\254\322\351\270\307\341\322\310Y\262\211%\357\356\273\233\346'\265\277\350\313\342\263\244\017\361\005?\033\352\374+\305\244e\270\232$bB\375/k\355\316", 4000, "\222a\254\336Z1\3035)c\302\226\031v\216\345qr\234\247\211\134\004O\010\033\205\221YR\313\365\034`\244\276m8\204\255\217}\333\013p\017\307,\245\270\344~\037.\027@\243\3008\226\346\364\004^", 64 },
	{ "g\027\243\247\030\210\246\017\355\022\306\212\347\226pup\007v\374H\261\006b", 24, "s\006v\241m\353\271\320{X]\346V\027\345\331\360\017\302\210\010\213\243\134\361`\235\306\265\036U\025\264\373T\373\324n\033\226\037\252\031\340s_xtA\310\335a|A\252\274", 4000, "l\247\361\333NE h\255\336\021\374\356\327}\347\314\347lZ\336\335\377\341\354\342\206\317\310\036\302G\2039-\374\005\027\204\313\304\340\334\032\032z{S\273\330\1772Q\220a\201\260\264\312\222\003\317\034U", 64 },
	{ ":\243\340\307\302'<pH\011\377\3357RG8e`\273\361 \0344\310", 24, ")N\346\003\210\316\011a\015\241Q\361\013\214\202\346\362\033gK\224600\360\336C\213\351u\024\343\306\001\312\037D\250PH\211\374Zg\361\377\232eT\300\323O*&A\236\316L\356\261\2314\320.", 4000, "\271D\336\350\333\027\332\363.\371\351\321q&T\032W\225c\031\203\373\361\340\372\216Y\245\027y\362[\257l\233\212\211\243\370\012\013_3Ww\236\221q\201\370\330\224\310\313:\214\345\263\033d\224i\205\233", 64 },
	{ "\214\037\033\217\010-\262\005S\033\374\344\304\226\266\221]jN\317R8#a", 24, "\377\260D \264\301\200\271\361\026\227B(\210\336\004\315\343\3651\306u\357\271\271b\251;Jm\261\234\327\273\344+\003\261hF\321eP'9\363C\021\305\203\004\200Dj\313\205\005`$&'\134\276\037\367\033\205\006\330\365\207!", 4000, "\340\310\353\232\220:\034\301\332\357\226\332\377\365\306\025\2256\325\357\017/(\134\351CE\241\032\261\207\265POQ\303S\323\274\013CM\257\256\364\327\2351S\022\211C\211\225E\233\177yl\027\232\274%8", 64 },
	{ "\205\247]\253`\230\036\334\353\377\005\303\314\331\376\030\322\340g-\004\235\027\032", 24, "#\002\015\020uG\356\206", 5000, "\3705\320lm?\250B\023\0274\267\022x\005\220:=\333\234M.l\347\263\323o\251NI\330\260\325\377\031\004\327\251\354\300\301\246\037C\241_A\274@\3306\365\274\207K\234/L\305\276hB(\177", 64 },
	{ "!B=J\001\350-\300:\2314\241\256(;\273\271\330\305\267.C\351H", 24, "t\0022\334\212\342\356\356\033\254\256Cd\303\212C", 5000, "DB\037\011\037}\330b\230\342\2150\224\211\244\220\231\2744L\042d\342\042V\024+\004\224\330GCZ\312\340i\004&5\204\017\320$\013\015\262\226\035\300\222\215\201\345q\022B\0132\206CI*:\310", 64 },
	{ "5C\225w7\027IS\023\304\217n6\032\320,\217\235\300*\351\277@\272", 24, "\234\247\326I\214\006\274\036]u=u\255>\256\134\326\301W\356]\307\3327", 5000, "\205\254\255LW\275\210\264\205a\214\001\323\312\254\251\233%O\222!0\037\177\274:\212\357\354`\005\335W\254\265[\275>S\243s\225\032\341\313\214\321D\177*\246\001\366\005S\234\230\010\300\301\024\337\3777", 64 },
	{ "i\347u\243(?];\2174p\027|w\252\232\374\252\031\360\013<\244\313", 24, "U\204\031A\265u\316;\325\340\215C\340\026\245\366\027V#\3607\320\223\315\352\364\316\240\020\276\034\342", 5000, "p\216\236P/^Q\034\303A/:C\012-V\363\242J\370\310\265\333b4\2267\177!pX:e\306\242(c\325\033\306\315\312B{\311\026\250k\026\257\207\217E\306\013\246>:@%\203\272\001A", 64 },
	{ "#E2\2447&#\202\264\042-e\346\315\327\212S`\354\357T\373\374\356", 24, "}+\227\036\352<\035B\325jB\225\343w\237\034\206\255\235\260\233\336\204Sx\216\317\202\001\261\242wb\035\352\304\235D\221\267", 5000, "\242\246\366\007v\255\267\332>O\332\005\024)K>f\350\031\325)\224\236\277/j9\373w\375\224\207\327B\321\354\265!f\373\013\375\024o\3768\345c\351\202\305~\366\221\301\237\3504}\215\313\306aK", 64 },
	{ "n\342f\266\256\206\242}}3\011Iw\350\264de\356\210\365.A\357I", 24, "\313\366\372-\305\017\251\134\366\265\2732\304\203\300\275\224\300\314ZKR\016\260\363\273\014\255\344\304kW\217\275\021\357\334*\342\022\243\312\303\265\016OM1", 5000, "9H\012\364@\023gk\224\324\007\340\017\215U\013\247(\006\007\305\335\006xAp\372\343\267\322\355\250\344#385;D\342\310Q\030\214\271b\275\265S\246A\020\247\030%\233,$C\267\334\036I\020", 64 },
	{ "p\224\002t\321\207- x\331MZn\352\042*\220Cv\230\303\244u\233", 24, "DE.\236\2209#`\026\303\274.\352\300\310\230\216\032\216\214\307\254\024\253\317U\033b\327\3532\033\231\370\344<\376\013-\330\0032\260\264L\012\305\020\254\356N\375c\333\010\236", 5000, "\324\235\2268\20247\200[\222\042\315\006\244\002\207\367h\31422p\371\205\206Y\202\331\307V\227\210\024@\002q\226\225\345\305`iwI\274\334\373\310\345\330\271\226N\331\242\371g{\231\266\035F\330\263", 64 },
	{ "I\2423\320\015(\222H\242\017\252\211\353\375Ja8\033\340\3765\314\322u", 24, "\346M\375k'| \307\351{\221\376\304T\026\0058)!\025\306\022\271\227\032G\254\200+\201\033\021e\032\334\002\301\317\201V\3658$\042\266\362\216i\217\266\021Y\312\017r-\354j9R\022\037\321)", 5000, "\224I\371i\265\005\262\257\262\253\373zV\250\240<\311\201\257\362\222UH\340\367\200Q\212\017\335\251J\020\002\341PB\202\030\022\017\277\032fT\256\013\266\355\227=\224!D\371\225\240J\215w\002\255>\300", 64 },
	{ "\205\027X\235\021\3344\2458U\361\222k\375\353\370\226z\3140\321v\353\026", 24, "\254\365t\304\343\317\275\254\0273g\241\003\320C\326\264\034Ep\360\267\273\2332\210B'\222\210\303W\202\021\364\246\302\320\236\256#\3074\324\313\216V\231\242c*\003\2345l\0365\353n\347\276c^\366>\257\215\227\215-R\207", 5000, "\337F\336\013{\253\267\314\001wC\321\201G\344<AZ0\204\371I?\376\376\035\255\362\306q\315_\0041\274\271j\037\2603\021\213\313\242S`\334\262!\217\264\220\344\006\366\251\233x\375\134y\177\215\362", 64 },
	{ "O\311\352s\262i8`u\374q\212\026Y0\262\361\211\344\3648\343/\342", 24, "\367\033\267\204E\231y\270", 6000, "\357\355\000\253&\257a\257W\134.o' j\236#+\326\003i\207\205O\0016\274\364\305p\006^WG\351\214\233\255\240x\2511\303!\370\203\253\030\312ZC\275~\373\220\024\010\345yio\032\310\344", 64 },
	{ "|\242P\225\031<B\246\003\270\007f\361n\364$*e!s\305\233\266\274", 24, ";\276\370\217l\336{\273j\331F8\037\205\223\335", 6000, "8\304\347\235\034\311'\334N|*Z\200\347L~\257\251w\321\363b\362,-\370\273l\0065\004\332 p\301\224\212\274'\275\3045\224m\036\214\004z\001\260 1\236\344R7\0216\377\300\243\311\311\030", 64 },
	{ "\024\334SfoW\372\005\016{e\017\307?\320\351\275\340!\007_\264\250\016", 24, "|N\264\010\2442\254\356\210\226\375 )\021\0102\202\343\244]\375\256c\324", 6000, "8j\333\364\246d\320\244\264T\374L\352\204\014\037\217\025\006\032\333pX\220B@\333\317\332d\333\354\304\352\037\236\253\306\250\201\340@X\215\316=\335-\2502\315o\255\016\372,Z\301a\232T\230\251\226", 64 },
	{ "\236\357$\340/T3\376\3370E\134\303\265+\232\244\230I\301\315\271\265\232", 24, "\244\027:r\356 `u\207\211\305W\261\336\350\005\201\035\2720\335\306g\305\222\177\302\361\036i4\367", 6000, "I\316\212\361~\310+\254H[\262\016{?\321\353\374\334\327\324\347\250\266\373s\022\315\236\371\232\276\027\217\337+@\245\210\220\271\260b\270\312\265\207\272\004\345\324\206\246\254\024\351Q\367!V\311\355HB\037", 64 },
	{ "\031t\203\3355\251\001F|'\261\335\224a\244\324<\206L\315\206Oh\306", 24, "\243\341z\234\361'\337~\204\247\376!\261\036K\254N\027\360\024,\264_l\216`\360T\223\251\327\323f\016\267\304P@j`", 6000, "`-?\220!\256\364\036\215\002\014g\201\261\237\252\354\313\266\330\033\004f\016\335\020O}!c\357\314\326\326\271=\375\331B4\200\311|\213\247\036hH\254i,\3004\020\210\332\204\210\014{\2136q-", 64 },
	{ "-\002U\017^\036K\372\367h#\0059^\2679\261\232\243\360\343EKL", 24, "\177\330B\025(\220\227b\320\243\213\042\255\327-c&\231\204\205\255@\300F\042^\362\020\277\2773\231b2W\256\274\032\134\265\217\305\367\022\276\342e>", 6000, "\226\341q(.\361\024R\272\037\201Z\202\300\271\002\216AM[g\263=\0039\034m\250pb\235_\205\3468A\007\213\276\366oK\273]\277k\010\011#\255\264V.)m\032_|\372x\230mnv", 64 },
	{ ";\346\354\013\230\227\031F\357Nz\350\262\002\025\305\013\337\377\332\350\256\014\030", 24, "\222G\375\327\177$\353\274\353\357@\007\026\356\266\303\240\370\271\241h\241\003f\233\0061=U\264\177\320\311\312\334\036\031\025\275'\324\341QQ`\277A\347J|\012\3315\243\230\217", 6000, "\332\363q\304\333D\240\347\241\032i\333P\231b\271\344\317\024\355\314\301\267\316\021\237\321<l\361h?\345r\000t\324\030\231\217\305\334\235\012\343\236\261\211\2728\352Mi\002\226\270\205\2675\177\363\321\011\250", 64 },
	{ "\373\253'*\353\374\273\310L\000\244J\362\244\36404\023M\361e\212\001\353", 24, "\217\252\271@\215R\277\205\340\235\300GJ\340\033)\320Q\322A\276\330\017\334\233\363\240\322\014\027\210g.\003\3302\027R\361\305X\256^\321\325\304\005\231^\332\034\226R\377uu%\3745\346\352\023\244-", 6000, "\023%\374\376\017\226\316]4N#\370\230N\001\356 \212F\312cRw<*\376@W\271W\332\254`\324\317K15*\223\272\316T\006Y==5v\352\033\334\302\204c9h+\357\337\360\217\034c", 64 },
	{ "\235D\371t\022@\313\322\301\303\367\177\362\355\210\035\017\347T\253\376\354\214x", 24, "\016\352\350&o\250\006D\321H\272\361,\312\375\263\0228+oE\015\216\337\306o\363\261x\3618\255\005\273\226\350\265NE\234\302\375\334k\333\331\251\204\204\222\003\234\342\313Wj#\226)+W1S\207\273i\246yA8X;", 6000, " \230\212\310\275x\361\313\246\032\207\364}s\2368r\301~\257^\313Y\0215(#?\271X\335\245y*\377\353\330\202^k\376Lad\311\000\350q\222\241\205\004\277%\306wS\311\3762+\326\227\334", 64 },
	{ "?;\330*\023p\010B\134\023?2\350\023\004\355._r\215\354l\353D", 24, "\363\377\344\232\235\373\265\341", 7000, "\355\245w\013\015vz\277p\223j\225`<\037U\264\3475\257\304\246D\245#y\355\232\012\302\037)\332\315\221z\003Y\242\362\017*\365\031\261\014\267\012\341\203\354L\260\316\343\213N\362\233\000\272F\344\306", 64 },
	{ "k9\317\360E3\264\030\032\316\253Oq\247\232\220\010\376\354\244\243,m\012", 24, "\266t\031\337)\034\306\036\212\036M,i\002\355C", 7000, ",\236\266v\336\331o\322\226~\253>`\013\215\202l\365\330\311g\235\247\232\361\336\257\206,\321\317\330\006\253\233\302$T\357\324\035\241\0316\030\036(\204\251\331\376M^\2559.\225@\0110[j\201\350", 64 },
	{ "7Y\231\310\325x\221\333\3057~t\254\265\325\335\247\326\227\363:\134\355\201", 24, "\340\341y\031.\267\217\264\012\020M\250\347\274l\311_\255\361o\232\260I\342", 7000, "\202\267\254}\0042\357\253\273\261\022\024H\020\203\013\032to}\347m\337\376\371$\250\255\321r\016\006\274\367\311\323\243^wsG\237Vw\004p]\325\261\365\027\356b\230\205\322L]\021\203\371\2709d", 64 },
	{ "\177\335\200\3270AM\247Y\322\010*\234\035A\261C\366n\036>r`l", 24, "\214\014\337\257?\303=\024\240\307\343\00255#\326\0235\267\327K>\354\375\211\321b\021[i6>", 7000, "K\000\352K\222\245\260\275\361\361o\365\326\364\036\2770\207\331 \312LL\350c\006\226\247\014\217\217\261/;AP2N\327\343\013\246d@f\250-\364\304\013\002\314T\032\025\247\017\217c\366\003\305\037\362", 64 },
	{ "\200s3/\021\217F\036\305x\321\206\215\004mk\314<\000\300\226(*\244", 24, "\247\250\3112z~\236L\327\215\003\367\022\244\217\201\373f\010$HE\221\026%w\326>\033\017\226\020\207G\367\352iL\322/", 7000, "\311\374\230\374<ac\322]\333S\011$`\320V\351\034\012\225t\241\301\361\0110\272\2529|\357\205\264\235\326\322WTM\223\374\240/\007\230\007\334\252?H\306`\006\345k\267\333\275\252y\314\263Gf", 64 },
	{ "m\252\243^\355E4f\270w>$\026\042\360\254\307\307\252\207ZP\232\364", 24, "\207tG[%\035\246\377\337\325\331N\022~\365\236/\304\201\374\021@U\372] \226\375\037E8\007\254\354\370}5vZ\031\206`\366!\322\366\342^", 7000, "\245\210\355\305?\007\012\026-\377\272\025\2700\270\375T\332iM?\216$tT\216.}\356\005ExPe\005\262?\223\226,O'\365\000k\246E\202\021\213\324\035qRg'c\024'\200X\026\240o", 64 },
	{ "\021\300\216*\364\017\360\1340\321\362\221`G\234W\363\333h\324\216b\217\307", 24, "+E\251\013\223\005\246S3R\255\016G`\212\214\246\352\012t\353\324\237\230\242\241c\227\021\374\316#\260\351\317\0252\243\007\002\346\026\237\023\216\3117\344S}.9\274\203h\371", 7000, "\362\315\306z\261\307\255\373<zn\003\252\001\014\310$\213\365\351\007\006\364\307F\303\036\336\323\366\236Z?3\3569=\202\134\215\205{\355\366~p4\011\326@\215u\265\337L\300\011\317\300t\243%\012\336", 64 },
	{ "]-\377\321\373\264'r\036\250\350R\036{\374\332\015\267J<\257\243\237\362", 24, "`\366\021\261\372\032\353:\005w\271A\215@\323u\353\342v\022\254 Z\0015\265b\314~\245\374^\036\230m\255\274]\356 \325t\002\246g\376>\276u6\243\021\347\234C\370\206\306Bv\257\211\347\242", 7000, "\033\256\213\370\341\215jM\215\216\262\324d\007\316\365\227\371\2034\134\272\012\206h8\212\253Z\027\314\305\017z\371\010\216s\343\313\277{A\262>\312k\376`*d\300\360\2516\241:%aj\215\242\275\375", 64 },
	{ "2\214\342\377V\332?\2433\233\177\347:\352\242\364\337\340\331X\237\257}6", 24, "\320\326\244\261\006:\026\037p\252$B\205\265\036`\362\327%w\241\271\317\367\004\026\215\364\260\023F\3245\220\276\367\347\260G&g$,\2219\015\177a\224\211\313\016\346\027+ \011\354\017`\026#>a\327\022\372\177|_\023\231", 7000, "\332\3414\351\013\042V\243\371\033\321o\023\023m7T^\220X\343\300H\010\306a\307+9\326\315\323\226\032\205\030\024b\371\365j\220n\014\312\024\003p\345X\017\341=\321\304\205\340Q\300\362`\307\314\365", 64 },
	{ "55v.A\333M\011\253\244\245\331H\317t\353\235\243\306\200\307\241\330d", 24, "\301\032\244\327Z\351#\344", 8000, ">\334a\343\370\316\221c\363\253\306\042\325\007\310UU\351g\340|&\203l\034Q*\36754\206\134\264<\341q\342\332bg\014\000\301}yR:pI\342\301\343\250x\232p.\373\211\033o\016\015\300", 64 },
	{ "u\034\247\2249\312\031?K\134\367\227\373\015w\005\303v\375\311\227Y\264P", 24, "\347\374w\031d0O\321\342+\036q\026\015+L", 8000, "\000\307\323\245\336\306|\361i\245\221\003\013Mn\233\211\227\230=\272\211Ybv.\007\256\244u\364\350\201k\274RA\022\327\212\325\234Or\0137gx\340$\365`\355\255\3310r\205CF\246\3554\003", 64 },
	{ ">\372\324z\264\3456\210u\275\205\315\302%$\323\023\204.\245\305O\266\215", 24, "\210\036\242\335\310\002\367\363\365\034\003\030\207\017\007\022m\0369Z\322\032\272\213", 8000, "wO\311(\236\027@\354\006YJ\353\207~\360\237`Y\316\242\247\307uz)\307\023\267\262\340\007\307u\2256\0220\347\1774\274\042\271M\335\026D\342`\356\004\255\2702\21587\0270\346\310\231\303\215", 64 },
	{ "\205\015pw\204\330\315l\327UI\003\134\005\033j!\202\007M9\030\017\257", 24, "\243\006_`Ge\333\270\232\361\256\305\266\204\351\231\232\310k\230}\035\225oh,F \177\213\3508", 8000, "|\206d\356K\204\337\023\357\324\325\377U\314\343\001\177Q{m\277Y\3232\347Z\264\343\032b\367\337\204\347\237\340\220\000\005\240\015\256\207\240\266\020{#p\216Kd\031\245\266\237\366\327\003\352\20096\270", 64 },
	{ "\234\317\267X\261\316p\305\317\270\037\223\364s`)\266\360\255\372Cx\034\344", 24, "\037*ZQG\262z\310\302\331\247\036\355\331S\227\271\245\240=K\342\360}\015o\376\275\353\370v\326\011\352\366\011\035\346t\315", 8000, "X\246h\312\331\270l\217;7\371z\357\213}\021\200`\035\335\277S\211#\024\257\253\367\270$\306\334\346\236e\030r\031\356Z\314\340_\237\242\025\134\314z\360\216\020\337\205\272z\314\036L\216Y\217G>", 64 },
	{ "\216\336\334\260\010\376\034\330\025Ilx\217\376+\341?A\303\320\212)\242[", 24, "\002\257\245\0163\344\244v\375\344\023\272\244;\353\242\371|\010H\337(\200ut\252\252W\260\256\355\251\244|\013H\257\350P\003\210\330Ji\026\361\230\313", 8000, "H\320\325\372\034/\365\265\000Z\356\250\353{\205\202\247\006\313|I\032\013+F\373\270\134S\015\036\3443\240\376\334\3018\3343h^\344\200\243\312Nk\264,\302K\365\267\315\346y\030!\020\313\373\241\272", 64 },
	{ "\364[\025a\015\244\351\226\361\277\362RnY\016Vg\011\004\032\0243V\334", 24, "\303\035t\266\010\251('\331\304\035\276E2\030\216\305\330\026\3153\271\227szf\361\307Jg\217\003\200.\031\034ga{\247\042\021VG\262\216\264t\015\006\014\232\236\300\335\360", 8000, "\373Ng\266cw\232\023\340\345\134(\241\223\330\251P*.\251p\023I\216\222\016s\274\2610\2719-QX\017s'\364\367\203[z;\321\275\367N]\016\205\216\032\246\351\013\014\230u:a!\340\344", 64 },
	{ "\036-\324\033\321\251\200\377\035C\2173\352\252);\211\025\316\215\375\214w\215", 24, "\300\007\353\005\230\026\313\261\017\376~\245\312\375R\275\336UpX\223\261R\321\012\257\305\361\354\305y\016[P\026\302\367\203\210\222\320\267\341A\374\323Lk\237\360\277\303\226v\214\362\372\303\363\2325\032Y\216", 8000, "G\277\034+\204mQ\037Jh\3735M\226yb\271T\333\216\320\233+\3414.\010\243\335\030vR\223r*\272O\263\222\310\204\366\266)\037\012o\344\333#\027\260\037\300F\010f\336\236\236\367\203\213\222", 64 },
	{ "\266c\307\213\340;\202\254\364tO\370\023\221\332\006w3Q\352d\224\000a", 24, "p\035\261\247\274*,[\341\236\263\237,\272\361\301\232\301w\203\023\024}\265]\313E\203g\364\247o\005\134Az_\007G\007\010\220;\326RR\216\262\025\200\255\262>\330\321\276\316\331\356\310\334(\241e\345D\263\330Gx\324\325", 8000, "\253h\230\377\267\373 \214\322-\273\273~\336\356\177\024\205\277\240\277[\227\023\332\316\315\374\000\272\351\357Z\011\021\300\377\371\376o\223\336\235\312\021U\330\257mz\250N\206\210jB\134m%\276/o\357\354", 64 },
	{ "\245\221f\320]\012k\303\031\336Wr\336'kl%\250\3559=\266P\274", 24, "\243 \351Hp\230\003\351", 9000, "Z0\012\276\353\351\232\246\223\035\333\243S\367\365\272\376;\035\314\004HG\030\213\275yU\355\005'\341\134\002O\014\310\134\21217\020\011\317\311\032\031\317\355/=h\201N\305\243\232\300\354\342\005\206\216\200", 64 },
	{ "K\213x;{\306\322N-=\201\352v\366\255\013\005\012\221\2142\336\014\300", 24, "\200>\242~\026\241\226\204\221\351\213\303\223\237*\345", 9000, "\273\325T\251\032q\370\2077\310\220FF9e\204\342\226\374\247BP\370_\273\024%\314r/Y\270\231\343\323\353A{r\334\013$\315\224-\226\272\276\244x\337\220d*H\021G\307\271\347\251\304\360a", 64 },
	{ "X8\022-Z\303\263\357\3236\371-\322\352\212}\226xVF\200KH\271", 24, "\352\321\241\333\217\016\012\344\245\240\216\017-\367\340\324\260i/\320\377{$Z", 9000, "\363\313A;\203\243u\267\276\002\327\036\2234\323\217o(k\372\333\023\240\221\300\254\2677\234\2040\300\350uv\327\371\262\215\272x'\213\274\010\021\034|\352\3338\353\273\027\272\265\376n\134\210r\300\006\247", 64 },
	{ "\335y\005\355Q\326\204\360\222$g\356s\374o\200W\011\220\001\247\025'u", 24, "\035*\242\310`G,\244Q\372\256\301\305p\034\271)t4bW\2076\225\177y\335\322\317\245\256&", 9000, "f\326\017\227\016\302R\363\324\314\010\271\320U\341Y\222\370\265\277z\370\313\303TA\334b\371\226\254\264pq\336^D\330\134Q/n\324\320,`ay8\203-\035\223\351\301%3\032\355\217<\233\256\236", 64 },
	{ " \250t\357\202 ;\3730`p\201\373k+r]\354;\370\244\030p?", 24, "\363\217\315\313~\351\231+$\215\216\362W\26569\223\027\300<\252\336=?\320\015t\333\004\265\316$'Z\010\337\032\300\356o", 9000, "\013\263\374\335\225\200S$\237\251\312#@\227@iE\373\364tpE_\342\203\204\364q\350\333\215\237\345\262n\217X\023\020`\257\327\257\236a\273\007\271\020\213`9\363:\011\240\014\257u\013B\302\365Z", 64 },
	{ "\037\211\342J\233OL\256\313,\272\317E\355__\006\211\354\343)a\326\366", 24, "\3069v\303-\210\007`\270\242\024-\010\203d\242\210\250\347g\031\343\265}\035\317WY\2600n\342\263\317\300\010\007A\023\313\311\320\361Y\266\206\326\256", 9000, "\037\232\322\324l|\277\265I9\377\203-F\026`\202\206;f\256-6\312\374b\0152\016@p\017\374*\250\213\255i|\274.\326\364y\336}@\252\012\377D\202:LL\274'\010\222\304\265\360\324V", 64 },
	{ ";I\027SS_\355\250\257M\025\034\252\332C*}=A{S\012\267\020", 24, "h\324z\036\2161^\373N\027iO\210.\344\361\370\213\300\274\204!q6\277rja\216tk\243\371#\353\201\272t\312j\206+L\005*fh\033?B\323K\213\300u\310", 9000, "\323\004\241\010\242'?&\207\347n\2659\262c\327\356\373Af{\363k\244u\315\271\257\215\002&#\350\244\253\345\004\362\245\341!\370\367\235L\324t\325V\232i\261\177\3241\010~\310\347z:\263\177\211", 64 },
	{ "\331\363[@JRZ\206\223\334\330\027\234\035\3774\273l\316\322]\310\212`", 24, "\250\0109m\246\376;\177\2612T<\274\327\2363\344\324U\343\343\340\206%;\347()\364\322}?\376\214?\246\361\005#\273\020r\200\260\3608\335\217\017\202\212F7\202\325\353\323\367\305\034M\033\303{", 9000, "\205\373\010\365Z\241;\3701a\253D\025\351\374\254eX\244\037?u\372f\346\231g-t\274\325h\030\365X\363\322N\011@\270#\027\212\271\307\221\302\275(\033{\221\270^\264ku\017H\367H\201\002", 64 },
	{ ".\354\201\342\256\244\227\276\215j(\026Va\3359\206l\377\020\253\376vu", 24, "\014\346\240i\217\206\263\300Aq\336\242;,,\240\035-\253\3070\367B\352\325\042\366\351\013\200\134\372\245\227u\233B\212\016\244.\021\362!\214\221\016%\224A\231\004f/\346\343|\007\3014K\334\015\2660\302\332\243\330\331\277\225", 9000, "?\341\377#\006\027\300O\217\020\267]\3708K\301b\177Flug\301\212T{\304\255>\260\357\266\2368\336^\134\326\335\0268\357\214\230R&&\372\223\315\212\374\341\320\234\224\203\017\310f\254\017\365\371", 64 },
	{ "\035Uw\245\207fy\341\213Cf\313\250\356\333#\365\330\025\214V\365V\315C\301\312A;\265\324\333", 32, "\237\306\371M\211\275\020}", 100, "\277\325\220\301\016\372\256@NS\004\207\201\3778`\215_\211w%.\337\374\353\367\220Z\272\373\326]\275\224,^\036\311a\206\211\260\005\317U\0154\001\237\273\305\316\033uu\251Q\213z\351x\036\243\265", 64 },
	{ "I\333\366\014@\0225Jgoz\373\270\002\020\037(\012\177V$\232\250(\264;\320\371!\324p\235", 32, "p\340\214\234\324\205\224\324\020h\221\357Ej\330J", 100, "\317]\000c\226\304\271\261\023h\365\3636ZV\016\353\356\222y4 \340\013\223\223\301\356<\004\234+\300\201V\230\370\375z(\177m\364\306\351\231s\254\360\227T\351ebLA\316\207\011\273\353n\323c", 64 },
	{ "\342\206\301N\363g\353|\226Wd\356\240\3630,z\343\225\024\031\252a\275Jg\337\361\000\224_\273", 32, "F\342{{\365w\331/Pi,}$\303\260\344\265,\032\134r\362s?", 100, "A_o\223\300\360\016\264Z\223&\300D\2500\310\316U\347\004/\226\364\336\353\034\217\011](\237r\356hd\245\205k\037\252\042/n\241'eZ\316\310K\233\017{\247\234\303/\205,J\373l\362.", 64 },
	{ "k\007z\262\2607\030\372\326\240\273\317\332\2406\031\203\014\211KOT\330H\001\356@\360:6\310\336", 32, "\301\261#\301\224\212~\323\326\237\037\202\036N\342\034\323\034\332\245s\002&n\035\265)kU\314+\244", 100, ":\276\200\342\261\1345\243N\265\304\334\375\364\323\371\304\213KB\336\372i$5\205\344\313\012.X\273\021\306n\222\025\224\207\321\365\265\333\304\363\225C\256Yf$\235\340d\026\027\207\216\267\006\361\030\353@", 64 },
	{ "\212nj\377V\332\013\370O\246\366+\370\264\321V\252\246\341\232\000\250t\341\241y\217\2764\213\234\203", 32, "\210\370\011\356\265\343X\235\3101\255m],h\253[\347{\134B\360x\215\222\324\275=\212}\363\247\326\004m\034\003C\241t", 100, "pc\205\224\356\344\247b\310\251\222\224\357\315\277]\000\272/\303T'\371\336\221u\370\355*\264\226~L\357\004\237\345\215\236\224\310n\032n\345\357\347\204\231\2543\020\234\032\042'\014\361,o\134\305\2233", 64 },
	{ "\227\222\262P\202\346\315\316\216#\250\032\346\007U\375-\317j\020<\220F\344\215X\234\004\374uM#", 32, "\215\215\254\311\351\001\253\313\331\364\304\315\032\276r6(\261\325\224\346 d\357\257\013\240T%\314\305\270\200\350\204\343\276\371\021\011\206\221(\310!+\034)", 100, "1W\302\356\244\310\375,&oW\334\355\230ipU/\026\236\352\250X\010p\335c$\032V=\375\316\037T&ja1{\225\262\177\313M\360Q\313\220\177M\307/.6\206\333\256@<[\331x\212", 64 },
	{ "\016j\376}|\201\341\346\214\014}\023\353||\360K`\336\205\261\336\015J\243MP\341-Z\016\224", 32, "\013\350b=%\356\202\247\222\201\3362\222gr\331Lf\201\340=\365\002?>\011h\246\306C\361\274\306mK\002\005Z\230\267\372\0364\342\254<\032'\215FR\231\210re\035", 100, "Fr\342\330}\351*D4\314\003G\366\270z\016\345\233\241\331\225j\262\324\362o\016\306\205\272\333J\255\350G\001\365\225\2548c\202\036\275\353\375-\031\032\023m\220u\337\236\265f\357\033O\341\332\235\246", 64 },
	{ "\037h\035C\201\200\227\347\245\205a\334g\343\330F\330\267\276\254\350\234=\317$\220e_?7\014\020", 32, "\363\34664\0316\003!\264\262\016C\225\026-\230(\363\007(R\347\013\014\012\304\244S\032\367\203\336x\251^\365\200\004G\354Vv\236\277S_2\363\260MU+\240\263p[\274\357\343\227\264TN\244", 100, "=\304\257c\200^\221\207\253\275\301\300\245\370\303\326Lt\026\235\337\334K\026B/&\0273\352q\024Pf\377\305\326\015\353\217~:\223bxyC\036/\021\134@\324,\337@O\024\356\252\352\314\001w", 64 },
	{ "<ck\222`\012f$\315\356\376\035O3\007\231*\320\3771\321\367\265\277f\026\235]\212\346p\265", 32, "\200\2359\362\263\334\216\034\256\314aK_\026R#\204M=Z\317\042\245?7\321\243\270\004\253#\227z\207+\236\236u\031e\235\242}(\342B\332\316\013\276\2202V\344\351\240\371\3477;\356I\345\265\024\202%\214\001x\317Z", 100, ";\323\242\262\007t\327f\312\341,)\203'4\316s\215\367\234u26\257=\344\364G_\314\026v\266\211@\303\374\253\363]c\177.\322)\372\264\267\300\277\011\270\233\134\243\207\221\034Y\255[!\227\243", 64 },
	{ "\247C\355@\333R\261b=\000\350\037f\035=\316Y\036\001wPf\235`\276\212\2444|%i\355", 32, "&\223g:#\333D\303", 200, "\012gG7\364~|\311\306\274\255\333}\234H\031\200\377\023BQ\276y\366\134\317\366\277\332U\253\277o\300R1\332\276\200\036\365\332:\033-\203W\006\362.\002\267\360.)`\354agA\235\260\263\347", 64 },
	{ "\215j\251\011\356\335\233\360\027\313J\233k\222\335\311\263Tl#\376J\2344\220\265'\220\037T\314\253", 32, "\370\034\005\326VK-\357s}\236dX\264\024c", 200, "v\356E\210\252B\031\264\265\202\247H\252>\350B\315\204\370D;A\224\200\004{,\202\302Ba\310=\214\012U\002\007\265h\007\262ou\251f\372\337\227\012\310\357\277\346\321\351\236?\310\303.\263\377`", 64 },
	{ "\372\252\370u<\365\355\222\214g\324\027\302\020\214\357\013;\334A\042\331\227\267c\3001\035\215^\245\316", 32, "8Kt_\242\015\235\007d\013\376\241ml\211Bf\225k\357\226\031\042m", 200, "\214\323$\343\001&.\301\226\220\260R\263\253\207\226\321.\276E\233\267\351BW\230\365sc\273\034\005\342\006\033\2051\227*1\017\216\221\024\276Db\222\212Y\032\017X\333\320\210\177\356U\366\321\256\002\216", 64 },
	{ "\203\000$\374>\2270*\334\000*\254(8\020o\311\213!\000\253q\333`r<\201IS\020\217\246", 32, "d\315\226\314\202\321\343\360\351\203\033\343\312\315\245\024x\351\274&\032\034\364m\241}\376}T\253]d", 200, "}1)\202\266\331\2179l!M\277\251\265=\3449\310\220\346\310w\330\210\026\305\251\375*\207\233\276s\277\273\202o\326wes\224\023\3222\223\365\304\375\371K\274\344t+S\314M\217d\320\221I'", 64 },
	{ "\2519\015GJ\241\362a*\252\307\253B+\226\204\226\320\276TlW]xHr\244L\354<1\363", 32, "1\207\307\303\232\276\322\277\037}b\023\256\211A\371\333\220\217\342\216\304\011`\3450\270\207\343\365\277\311\301\351p\002\223\011\372\362", 200, "\354\034\351Z\226\347\033\212*\253\011X\355\254\336s\363\365\257]/\202\256c\305\203X>\251\027A\233\357s5\337\022wW\240A2\351\271v'D\376\205[\246\313\361\375\301\251\307c\202\365tf\000\305", 64 },
	{ "+we\241*9\342\353\272\365\313\366\241\031\272\231R=\310#\372'\322s\014\253y\372ym\314\260", 32, "\230\327\217\225\203D\015\036\364D'2\042,\001&W\310\326*\375n\255\2530*\323\210~\203\361\234m\375\215\2151\342`\360\353\224\224\2510cW\260", 200, "\017\317\2567\134\357G\343 f\3122\011\377\334R<\365j\230\021_N\230\235\006\245\035\274\037-P\012P\225D\024\021Zy\256o\223\242\030\032Y\024\213z\265\012\374c\325\342\2735\370+\274\360&\020", 64 },
	{ "\234T\251\237\350\325\232\3613\253\322p\252\327Y\212\213,\374\326\203\235\037\274\203\2665kO\025\356\012", 32, "\263Bg\330\260$a\243\027$\303M\2553\2347Qm^8\2041\011`\216@\013\011}\302%\352\360\316\352\370\003\220?\321F,\236\360\362F\327\350R@\327\247d\325\272I", 200, "\244\015\341\362\031\363\032!/\221\207\204\325\303\254xl=\267\373\336\357-\322\304o#\314\027Q\015G~\012\211l\314\265\3305T\005\247\324\000\2406vp\372t\352\204u\374O\347\032\010h\277[8\257", 64 },
	{ "\257\330\002\330n\015\300\364\026\251V\016\3308\231\221\207m\003\024CL\271\251\364\324r\036\313[u&", 32, "\240\032\225W\314\311S\204\0351\027\177\361\367eO\224\260\214\274\266Yj\275#V\265\32533\244\00139m\356\256\363\312\221\015u\334\036r\205q\300\024\264\002\311\277Z\271\333\006a\326\206M\357\253B", 200, "\270\367\357\237\004\177T\024\266\332\342 g\261\336\024 \035\243\255a\336\2006Uq\217-\362\372\037S\301\314\314\327+n\252\235c\004\042\020f\311\337\177\211S\266]\346\033\210\244\254\377\333\305\314\007\355\311", 64 },
	{ "\224!/\213\360\357\220!5,h\322LnTY\025{\334XqV\236qY\026A'`\021\364/", 32, "\247\213\203\223K\362\366\255\020\217\2265\222%\030T\265\313:SW\237Y\346\256\324\012\2358\235\257J\276\034\031a`\337\202\317\352Z\017\323\303 \264\042\016\015\012\253\004\264$i:F+\003\301\266)\270Im\234@\271\014\026\312", 200, "\207\261\336J\2314\262\330\025I\012\316}\354|\357\033t\006\361\326\333\232\031\325y\003K\277\3518\334\301\357\365\234\301.w\230K\256\201\266\350@~\340\222\310\014\376\355Fk\257x\242D\374\037gxU", 64 },
	{ "_\005\231\003\225\334q\370mQ\321\252X\031\265=I\224{\343u)\217\201\370J?\364\013\315D\177", 32, "Q,\356e\355p<b", 300, "G\004\232 C\216\210\013!\042\243O\204(B\302\252\030\254;\030\2248\267U\364\304<\006\302\323P\006w\311\364\261\354I\302\036\370jnL\313\2700\273M\306\311\005T\255n\363+\355Wz\270\275\355", 64 },
	{ "\374`\241\254\336\034\021\310z\030\203\033\352|\027\301\242\216&E_D\224\373-\0137\314i\023\377\245", 32, "\020\334$L\013D\217\205?\230\230\264\364@\324\363", 300, "\256\342+/\370e\321\252\275\015\2036\020\307\266\213\026\300\034\353\255\263B\334\305\367\323\276\246\336\346E\000\030\010\246)\2521\267\321\342\330nuVb\214\355\311a,\334\033\267\274Z\033@\012\326#\001F", 64 },
	{ "|\341\014\005(\367\003\373\213\017\321\0056|\006w{t\2053Y\224\202y\230\006\221\017^\330\333\021", 32, "\315cD\364\265\351I\036\0256Y\035\243A=b\360\025\251\357r=C\027", 300, "!D\236+\010\242\301\363\225\3330z\332\347\277\367\201m\355\225\004\013 B\346\376\340\350\255^\326e]\254\367\246\264\2143\260!\030\363]\341l\247)\252\327Z\205Xp\2570Y\233\325\303MB\200\235", 64 },
	{ "\2568\003\323g\134\242o\362\201\313i\372w\372\003LYKt\032\203\3145\257\001Sc% e\277", 32, "\322\325-\363E\042t{I.\033\016\210zJ(\310\264\245uT1\2043W\331\315\352<\356\261\271", 300, "A\200\233\372\306\134\034\2735\352\317D\244\234\307\015\014\212.n\312Q\231I\031\240Y\265z)\236I\374+r\2048\316\263\364\320\205\202\342Fi=\244\205\032\037\007n\211\302\005\017(\261v\042\007\361\257", 64 },
	{ "JU\366K\332-\204l\206\252M\3202c0\344\035\226XM\327\331\032sMmp6\232m\212\355", 32, "\205\300\243}\267\302\364\034\210\246\012\177\342\015\345\337\262\362e\021\224j\370\032z\241.\042\037\013\245\015I\037\326\272\134\335~@", 300, "\214\355e\010dE\015\265`\2106\023[\322\361\366\1341!|w\007\024\235\217\036\005r=\313\3310o\345\134~\327l\255>\312\232\311\270O\333\024g\301vY\364\032\351\352Nw\320\247!\241\367\003\006", 64 },
	{ "92\200 \224\243\3026Vp\376\270X,\300V\315\265\270$H`\262\324\271\337\320\253\367P\2525", 32, "\360\371\017\302\303~\016~\334\013(|S\017\315\2465\264\227\3060\334\014w6\235C\256I\346\022Z\012O\023\221\262\252\355\237\346\323F\3111>L.", 300, "\274\0251\006\345\321\275[id\316<\370{\026\210\350KjB\324,lS:\345O\263\301\355J\364\346\271/\3262\223j\347\231\245\234\022\241\254h\002\265\234J\275\2521V\325Xg)\215\300VFN", 64 },
	{ "\224-3\372E\373y\366q6\375r\201\250\276\235\212\276R\275\347\317\331I\2572\031{k\354Sm", 32, "\335\213\324\011\243y'\302X`\317 \300nj\240\002\355\177\322\003\350\004\250\3265\333L\210\134\354\260\327Qty\007\033\337\350\234\216\340)\230/\321!|\361\2669\246\335\266\360", 300, "\240\270\256\340\027\016\010W\030L\305\234~\362\011C\234\022\267g\207\301\246p\216`\234>\245`0n\231\326\303\032\2464.\215\310\347\236\237i\220 \336i/\275q\315\205\034$Y\307\2310\326\276\252\224", 64 },
	{ "\347w?8\316\356\356u\030FA\011cQ0\032\301{\322z\364\007\344\244P\003\312t\271\370\022g", 32, "\270\003\340}\246\274jA\267\033\366Z\275\177\227\331\205%v\323\260-\012\340\015?t\2752'i\302z\212\300\332\317\231\234\220\015\241\035\3523g\025\263\244\042y\340\274\322a\252\005\251\336:\275B\020E", 300, "v7\377au\016Z%\270\215\300\011\237\324S\021\207\014\357<\335-p\306\034\224\362Dn\331cK@Ji\354\217\324p\324\212\310\313Ho.\224\340\031/H\373*\335\033\357\253\037\222\204\234\265\037-", 64 },
	{ "\255\002vG\234h\247N\257\033\370\323\353\003Z\352.\361\373!\003\304Z\374R\012\265\255K\273\223\005", 32, "\335'+\321\275\250\200\315\216I\235\253\307\266\310\357G\004\372\301\311\031\352y\004\247\252\277\325$-,\340\352j3\331\042\360S:}>\276\313:%N*\226\273\311\264\363W\217yBLK\225?\343W\020\360\261\347?\267\344\203", 300, "\212\336y\264\270\212\272\345y\231nX\323\343t\236|\334\370\346<\347\322[\013Z\036\200\267\333t\014\3361\347O\210\357\206\031?\314Q!\275\310)%_\325T9\376\204\260\241\223\003\363\334{K\360f", 64 },
	{ "\257\324S\205\231\324\023n\317*\321\373\341\307p\302\300A\251\304\014\325\276&p=\307#\341\220\274\000", 32, "\203%ft\036\202Iv", 400, "5\213\375C\213\233\346\347\003\243\243\304\255\035\213xV\007\275\042\013\265\015\231\267\322\021~rZ\271\227~\010 T\277rS^\326\211\305\032]4\023G\224K%x\005\312\3131No\177\230O#\0423", 64 },
	{ "\234$\001\017m\223\035\315\265X\360u&\202D&\321\020\216\334\261\236QA\302\004D\367R\302\255\341", 32, "\247\334\314\177\366|5\235\231h\323\217\332\364O\016", 400, ";\015\000\340\014\206\252\307\206\376\314v$\224x/\033g\027S\003\262\270\273bT\036\020\001!\261\003h\314u\003T\014\030\037V\202\005\327\216\324\213\336\020\303Le\3237B\012\374B\310\035\322\320\006\324", 64 },
	{ "!B\007Pw^\277\024m\232\342jH\2722\376\326+?\3568\217WT\037\273\037\311\352\240\007\273", 32, "\374Vhd\263\246\255W\226\015\276h\241\253.\274*\012o\003D1\360\021", 400, "\0119\322\250\350\027\226G\260\203 \316\245\027[lV\313\005d6K/\217}L\353\337\273*\250]J~\223\320\266\331\225\222p\262\027\007\227DV\223\340\332\305|\211\303~N\211~\353U\340\324\261\042", 64 },
	{ "`m\302\221<\360\306\306)\220)\2751sl\022\216\363\233*\257\000\251^m\006\261\367k\007\355?", 32, "\300_\016\250\265\234\3131\241\030\033L\253F\003B|\272\250\021\242z\235\011c\013\231ty\277M\027", 400, "Rb\332\252\340\0128\177\311\030p\330\0265\337\206\212\217\213\322c\240\370\200\016\370hC\012\026HB\275W\255l\316\354}\225\354M\310A(\307\372_\254\260mY\277\032\375F[{\323P\030\273\321.", 64 },
	{ "\020\301r\264\274\330C\264`DH\360>V\370\005\234\013\270\273\223\234\02137\345\275{\042\326\236X", 32, "\274(\277C\310%D\305\035zk\212\360\020\324\324\223\212\234+\312$Y\221\250\006\357\325F>9\212\313n\250\2323\314\343 ", 400, "\276\012\347\225\301\271\344\223V\3001\004\212\033y\001\351\313vU\331\021C\036\360\343!\324\321%\222sh\221\232\313lo\3063\2471\354\335s\256\237.\241\267\323\247\261\340=\272\370c\276\336\134\214>\204", 64 },
	{ "H\325\277\243\331\206\273\317R\005\324\030^,\370t\276j\0003\230~\370i\346\363!\223\273\244d\333", 32, "\367\241s\025\264\023%I\355:^XHr\003\230\177\331\245\347\025\372\234i\325\350-_\177\375\323\370#\320\332\320\311\241nED;\134\370:\012\026=", 400, "5\325\243\265{\033-\344\370u\020\1342B\017r\301\277\134+4\016\001+_T\367\354\012\325\311\257\023\200s \262[7jy,@\205\254\364\350\033\212\223\275\236\332o\031\350\026c\366%\377\272\333,", 64 },
	{ "\012rD\010t\322\202\251\355\253W<\201J\363\312\206\323\337dN\244V\025zG\324\375\361\207RK", 32, "\207\227\350\201v\263\376\206\215\360\221\3046\022\217\002+\022[0\216G\225bQ)s\204\321,\225\352\256`!\250\333\216\364\217\30602i\017\262\013\352\326\301\250\022\244iLf", 400, "\034\033\242g\257\230{\316\363{U\253\0049\000\257\265\264\030\264\011E\320J1<\274)\201[c\252\323\266\353\222\022Jy\366\301\024\252\024m\272\261\307=\2047\371Ril\222/\230eL\003\325c\276", 64 },
	{ "\207xrV%\324mBu\004\356\222\302;`T\347\0040\302\356\324\012\335\015#\324\330\214\335\221\205", 32, "\346)|\356\355q\266\340?\377\220\364\361\022\004\274eTvh>@\231\205\003\3354\234\001\337\260\031\225\3546C0i-\377\3657\021\340\354\225\352@\314\313\336\035\313\014\347\327\320\250\314\276\247#\356`", 400, "\341\017\177\253\177\265\002.\322\235\224\177\244$k\307H\245&fLi\354|u\241^^\0231#\300\317<\316\230\254\0302\264\134\011\016\275\356)\307\374\365\313\324\311\267\246\236\371Sl\366\327\254\333c!", 64 },
	{ "\024\201\3045\325ty\362\270\271\253!\260hE4\220W\255\240\277\377\326\320\202\206t\264I\324\215\204", 32, "_\271\352z\017\375Q\326\256`\372g=\274\261c\367\033#\275\356\0242\315<\220[#\023\371\2636\3131\360:\324\375\242 mC\227\315\220\302\006#\204\273\011\252\245\002\026\030&_\241:T\215(\002\372\213\252\331lX\017\370", 400, "\242\304\265c@\230\004N\354\001\252\263\211\037\201\276-]\015g\365\204\323\252\355\272\3165iB\364\357HS\345\253\303+\006\251g]\370\323\204\267\346\031[#`\225\343\272\201\253Rxn\347l-\3050", 64 },
	{ "A\316\347I\012\032\011\224\206\310LF}\377\212\035q.\031\206\241Tt\346\252\220(o\223\272\325\257", 32, "\011\025\200\201\221V\177\373", 500, "C\275\213\366A\324\330s\323\322\231\342\353\355F\226Z\253T| f\331\134\377\337K\325 ^[#\275\012\231\325\032\362S\371\027\312\223*\356\222\364\226\042\311\006\260s\360\236\034\253\310\357\365\265h\374\236", 64 },
	{ "663\230\3430\362\027D#\210\010\013P\017\224>\020\005\216\272m\006\035\225\355Zly\221\005\223", 32, "\335\374\334\026Y\254Z\211\272\353\306L\354)\251\002", 500, "\022e\035\371\012\311q\335%W\011\312B\377\263=\376\214'\275}K\254\221R\205\321\212'X\221\354\337_e\327\362\372\323\320\311\300b\263\253\273\020\305\302\251\002\266\005|F\245g_?<\361\314P\201", 64 },
	{ "\031\236|\263)\012v8?A\033\332\003\363\2020sLS\230&\353B\031\242\010\245=\027\217\037p", 32, "\012]\202\012\2107`\233\373\265r\217\234\273\213|M|\315\357Yue\327", 500, "g,v\236\024\021\267gL{\262\341\213\346\356B\250a\361\354\276\267-\313\201d\211[\001bu\314`T\036\134\212\022\330o\366_\254\3731\354\024Z\300\272\250>%Y&Y\354v\271K<\316\246H", 64 },
	{ "\301\031\014\272\325+ \361B\361\360\204\343A\230\220l\221\017\337\250\316\134T\351\211\037eO\305.x", 32, "J\244-\214\267\363s8\302\242\237\204\351\274q\204\3478\227z\263\311u\312~\336\317\250\241\341\206q", 500, "\316\205\233\374\320\350\232\001\355\277E\227\230:\372q\230\024\373y\356\264\306F3\2551\320\246\275\025\036\206{\323\264\272f\276\330\1778\262?\235\204\363\363\261w\030\251\242\347}\002\305\223|)\340{\264\257", 64 },
	{ "\364wG\247F\300\250\203\364rB\337\311\272Td\221\207\034\251\303\265\217\014\273P\034\377\342\254\363\037", 32, "\361\134\360\257\305\010\030w\345\030Y\244\236\002ge\324\326\340\276\022\362\335\353\366\362\205\307\020A\232\274\034\240\366\274\310C\242v", 500, "\260\311x\272\213L,\223\333U\363\022\355\366?\231Fr\227\025\253\321\203\025\013M(\033\300\302\226\256\272\344\370\217\034\256o\376\325[\004\035\007\004M\220\005\334y\234O\367\334wp\2750'\032y\306T", 64 },
	{ "t\246\251p\322\247`B\337\225i\007\362\317\201\023\010\263H]\373\344\226\005\304^@z\226\210>\250", 32, "\315\310T\325\200ys9\324G\3320\034J\376\024\366\365\310\351\350\221\362\251u\372\334xiUD\205Q\247\206\276\232\204\015\2034\264\347x\303\270\375[", 500, ">F\372\306+\2150\024\263\031\340\226\215d\350\373!\237\272\263\340\362aBZ\354\263N\377!r\351\307\223\257\215\224\322\305\253j\016\201W\303\3706\177%\262$\212\334P\015uwj#\267\037(\254\204", 64 },
	{ "\351\275\340\351\264\341\017\033f|\233\331pOK\277)\013\354\312\356\211\344@(\320\321\322,\367Z\212", 32, "\360\340\021bp\367\336\246\352\231\244.\232\370M\257\204\033/v\236\226I\215\033\243}#e\362\030>g\361\242'\334\220\177\003t\353<\370\023f\034\354\177\017\267\013\335\315\350\355", 500, "\001\266i\240c\265i\314\204Y\252!\335\042\373\211\332U\303(\273\304m\261\020l!\360\300\006\376j8\2547E\037+\242yO8\002\377]\256\245Q\032}R\343\311\344H\353/\227\3566\270V\263D", 64 },
	{ "\217\025\363\021\024\006\013\355\005N2/\250-+\3704\354M\001t\245\000\233\361j\324:\340\266D\036", 32, "\177\226\351\134a]/i\247`\370\346\243\006Q8\302\211r\021gQb\006\244s\350\273\303\202\220\236\341:\372\026\335_\247f\203\254\303\010\231\035gG\252e\375 \326H\3469\270\014d\215\273{yw", 500, "\270\334>\273H\035}\215\322\350,\353r\212\020\362Hd\033\214\021g}\366\352\346\2725K\022K\217\220z\221n;M5\024\012\310\225Uv\377.\203\260\026W\351\000\263\003\266\017\202\324x\313~/\302", 64 },
	{ "\214k\277\217\215\031\022\204\207\011_E\321BRrkE\020\015\375\223\367\346\370\013f2\306R\217\356", 32, "\307\337r\321\366\245\307A\013\015t\352\362\006?\245 \333\334\264f\260N\250\225\341\030J\334`#\263j\275\231WU8\366\203K\223\365X,\266?n(_v\347\303\305|\316\207\013\042\251\233\232\011\324\3714g\010#C\241\336", 500, "\007YI\203\310+\236\336\020\221YU\351\376\232\266DF@Y\006\226\242\256\270r\303eO'\366?+\323\032\225\345\320\015\227rsge\317\260\342jp\231\372\306nG\350Mx/\337f\2757\0121", 64 },
	{ "\134\355\220\225k\203\013\271o\037N\364\237\343\352c\336:\335n0\213\247\365K\204A\253\005\205\211=", 32, "u\267\316\322\344I\327a", 600, "\263OO\366\217\232\213i\216se\234\231\2740!\311#\256~2\267\134\025\367\310\020\3541-T\223\227\025\010\276\212c~\265Sf1\200\017MO\002\006\352\374\316}\313\032\317\221\007\322]S\224jl", 64 },
	{ "\014\274\263\346f\231?\005\223\3336\036u\301z\361\324\277\351\013\320\244\247_\365\315n\222\345s\023\134", 32, "\336I\3260\310g\341\234\3012\376\205\002\301f\311", 600, "\362\246 u\364\216c\037\232*\037\253\031\335\347\022[\007\256j\303O\225\270\204/\031E\244\253FdC\272\305\233i\343\357\327b\273\241j\243\261\321\255\345\304\365\363\337\277\222(&hL\325\361\011J\266", 64 },
	{ "YC\314\276\211\370\003\272\320\325\232?v\203\001\274\2738qt\256\330\365\276Ad)\256$5\353v", 32, "g\346W\016*\233\311\344_\267D\346\261\322>\031\274J\300A:\355\232\330", 600, "\304\2457j\205\3131Z\021oA\234FI\254(O\026\334N\017\324\206\033_C\375\231$\314\270\212\245aV\035+\220GC\264\035@\241\231\0124\235\014<\334j\257d9\355\301(\236\226\210$\235\230", 64 },
	{ "\207j\363\010\013\313\273v\326\270\265e\260\033\313\3237\211*tQ\366\215\216J\212\235\324 W\035\033", 32, "\303\374\023\372y\363\307\320(w\236\200H]\371\262\010\006\020\361M\030\346\222\361\216S!bc\3612", 600, "Y\301\037?z\341Y\350_\374@\210\324\274\014f\377\317\023\303lOh\032\253\035\332\217|\375.m\203\031\361^\320v\323^ s\031\347\215Z\012Zj\335\206\363\024:F\310\035\211\255\216\301\203\251M", 64 },
	{ "\216PY\256\343yt=H\205\303\011\353\232\340\2630^\021\365\266\004r\001\307wV\251a3k\370", 32, "I\256\322\255a<l\3439N\224\314\377\232J\032\350\351n\356tKV\267=;\304\353\3357P\216n\024\233\342\031#\234\225", 600, "\357\177\2642\031G!\365r\307\365\342\013YA\347$\250\315\324N\263EI\262\250\266\006\305n\241\347\202\036Q-\134M\2663hh\327\201k46\345\373\362\256\333\314\322\236e\340\325\337\322\002x\021j", 64 },
	{ "\316\332=j\346D\326Ma\303\263\332\341\337\005\243\3549f%}\366\323%\351\261\312K\234\234t\362", 32, "\042z\332/\2006}\3233tJ\021\377\266\214\306\314T*\252\342v\316Ru\036\240\341\236\034M\022YY\226\0212@\243_\374\346\004f\262z\311C", 600, "\245\305,%L\261C\022\251\134\323/=\231R\024\350D\233\202\351\235\247\243V\031FL\033\277\246\003\037Y0\375\276\314\233\224\323\350d\210\211\201\254\341 \343\352\276\267,4\335\210'\223\207R)l_", 64 },
	{ "\242\231\024'\371J\340\326\256\221\320\223\177\234\306\245,\035\201\261\361m\344\360\001\276t\254\363\247\260\002", 32, "\305\014\300v\224\372\353d\240P\006uq\230\354\031\245\335\317\022h64\332$\021\350\367sz4\326n\315\257\370r\275\374\334%\011{\305\376\201t\256\023\376\025B\222\266\206\134", 600, "Y\264|\001\365\341\327\351:\014/ftNl\243\365NC\345\032\256\042\343E\227Y\253\177\223*l\331\340h\257\377\206\035\261\134\310c\021\246\363\000\250OQ\211\011\233\007\300\375\207\312\212\351\226\205\312*", 64 },
	{ "L)\226\364\250lr\252\205d\356\000\333\3306\004\323\034\022A\375\033\337\306\345\327B\373\232\306jJ", 32, "_\134\277<e}4\373W\363=\010[\237\011\323~\304\201K\237:k\321\315\004\347\377@dY\270\015F r\007tQ\335\023\377\016\360PR\240\306\0210 \357\234\357\0243\011\222|\037&\344(\323", 600, "\375\134}\265=n\252h\020\275\246B\346z\012\203o\226io\037\202\234\371\022l\352\350\356\216\017+\225z\350\315\244\323\224\314\241\006\275\344\031\273\373\365\303\330\005\362)y\213Wx\265\351\211&\354\267<", 64 },
	{ "\303\217\343`\352]\360\222\315\247\371\372\345\263XT\3216,j\220\240\225*\257\031\225\205[,Y\246", 32, "\314\325\324\200\024\204y\312\373M\244_\255J\322\217\244@\223\306\350)Z\021{v\352!g\273B\360h\357^I\236\343\305,<mB\273\011Xp\267\247\311\312\347$*XM7k*\201\324\230|\336e\300\214\350<\225\006\367", 600, "\236\037\004M\014+2\027@k\240\336;S\303\366\011\024\363 \325\301``\301,o\177x\346c\306\263\354\364\177\352\024*_oHB\007\275\223\036\231\005\231\216&kz\354\255\007\356\237\337\014V\245\213", 64 },
	{ "|\227`~\012\236[\232\253\2406\326\003\213\215\313\255\222>tb\305@\004Z\352H\032\205\212\254\215", 32, "vU\273'/j`\351", 700, "\360\255\227x\024|z\360JY\364\273B\240\037+\027\376\346\207?\030A`K\216Ba\366\241^A\030n\027\363\225\301z]Y_e\012\273*0\222\274\242\313Q\003\201\336\034\210T\361\2268E\243\303", 64 },
	{ "\352J\265\255z\256\252C\363\273\332\3044\351\214\311\012\2516~\226\355\225/\347T\264\260A\330\377\355", 32, "dv\016\032\340<\207.\260\037\354\234Csm\337", 700, "\360|\337\257\240\016)LW\230]\035T\016\001\256\252Ew\222\016\003{yE\025^A\274\377\346\265\370W\361\336`\352\0118~\241\356BW\272\315\260P\240\273\273v\322.P\322\301\177\033`\317\244\346", 64 },
	{ "Q\026o\230\010\276b\336kNrzjJ\021D\302\364'\353'1\202\345\207\203\207\201\034\203\000\257", 32, "lwS\255\204\030M\357jIx\363\301\271q\304!r\215s\356\322\340$", 700, "Fx\263\350\210|\223Thrl\326\215A\366u\2168z\225U\255\314_v\020\017\314\025U\304S\023}N\021\363a\314\267G\2444\205C\200\011^Q\253{\216}[zfQG<\232\242r\314\334", 64 },
	{ "Y+b\271\212\342\325\025\343\277\012\223\0121\243d\004\240\342<\205\013f0k\307\254\335\014e\364\261", 32, "\343j4%\254\352o \0116ksr)-\341\366\366P)\021\362\305\305\003T\204\302\317\312\313f", 700, "\016r\343>\207\376\003\177dw\037AN\262\334\017Y\236\374L\253<,\226\027d\317;\250`\216\326\334d\251\355\300i3eV\241Iy\220\001\356\035\364[\303\220:\242|eN\313\354\3039\3309\272", 64 },
	{ "\354\261t\321\217\227\3512\321}N\214E\257\251~\006\014\372\200R\017\261\007\021\220\371\370@@P\222", 32, "\277\301+;*+3M\352\373\365\246\304\356\250nf\320-\241\325\244\306\357kXYX\325R/u\326*\277\265<\200\360\270", 700, "\265%\225}\007\257W\255.\306\000\201U>\271\330F*\253DD\317\021aj\374\223`3\367f;\026\010\342f\0150o\232\303\015\377\017\205\357%\277]\277\216m&\236\344\366\313?\373P\214\223\000\324", 64 },
	{ "\310F\324\335\367\301A4\252\337\342\331\016\000\241V\341>\237\034C\204\301\276\255e\276q\341\3778\301", 32, "\214\222\134\343\224:\336\012B\323z\310\262\021\205\225\216<\313|\227L\267\024^s\316\257\014\2259\261\371tB\242\373\366\232\374\353\336[\343\026k\307\256", 700, "u:_q\370\012\235@\315X|\367\377C\217\353(\3051a\251\001\003\226\205\342\227\212\306\337$\274\201\212P\315\017\221\347\006\021\230\354\266\200.v\213\361'\320\227\331Wi\034\374\346)\332\273O\372\225", 64 },
	{ "o\210\323\375q@\013U\011)\020\252TE\206\233\306\2058\324\371\354P\374?\212\235e;r\207\261", 32, "U[{7\230\215\213\276\344\336\223\322,P\214\360\205\007\202\276e\005\025H\2048\212\247Vq\232q\303\272r\273\001=\201\261\265I\311\266\323\206\203\207J\212\323\200A\375!\276", 700, "\211B\011\227\272\0275k\016\015\266\202B\0301\223\226@\037\005\377H#\302~B\020|\002\226\015\242C\342\273T\306\245\376\307\320I\301f\021f\316[_Q\356\210M!\271m\011p\027\361x\316\353]", 64 },
	{ "\033\310\253\302A\013u\205\252\020.\233;\372vs\243\275\351 \015G\220l);\265\245\362c0[", 32, "\306\233y\253,\303\222I\343\335\211\242\243\026\320\253\177\211x\215\033\234\177*\333\343~\215\364\333t\326\005\240\256\300\362\015\022\344\212+)\237\277k\354;FFL\323\373\2342\022\001\254S\353\265\253\323\363", 700, "(#\342K\312\320\243\035\234y\366\000\333\023\256\305\042\361u\035\026\201?\252}Y\015=\203\332\235;&\344\027\235f\353\252\235\257Z\042k\377:\346\365l\236\335\035\274X\237WL\342\237U.y\003H", 64 },
	{ "\003!:\341;,\031hr\233W\265|O\015!eO\352\272\355\210\304\360\3318q\004pw)\364", 32, "\317\243\314\370\315\317\025\017\002\273\020\344\354\222^\007\217\245\336\362\002\307c\207\376\236[\373`\257\226\332\025\202\246\010\230>\311|#\273\134\322A\364y\354V\021*=\344\326jb_:Z\221\214\203\011\277h\042v\212\211\241\303r", 700, "\252'\212\362^\0326\2114\216J#\367z\024KZIf{~\375\345C\302\307\236\030\002\262\346\012\033\317\272\230\244\320\220\272\242*\021\327\240>k`\222\263DT\231\204';\301i\027.\302\223\320\236", 64 },
	{ "\321\334^\2313\347D\003\200\003RyA\002\241\321b\264d\337k]\005\260\265\226\001\017\3361$\341", 32, "6\327\246\342\376\260\013\303", 800, "\304\350\334c\025Q\240R\263\243M\320\011D\351\230\375\257Q\134\346V\303\267i\362\221\277?\323\363\207?`Qx\023\356H*wm\032\343F\017\304\033\327\204\242\2064^\214\204n3\000oqF3\347", 64 },
	{ "<\204\330om\325\200\322\261\262\343\010\364z\017\317\223\366\313\311'\263\344V\270\134\2008\005'\267K", 32, "\015<\014\200\270\270\134\036\277\352\025\350Gk,\301", 800, "\331[p+\273\317\247\205\026\353\262\311\226D0Q\273U\014\366Rc\371\346>\255\206Z\253\260\267\226\200\321\357\134\3309\002X\014\015\241Wu2Y2$\331\265M\267\377\262\255r\252-\021d\201\341\217", 64 },
	{ "\206\362\247\200tY~\344\264,\2113{Myk\366\370\3025\310_\343g6 \261nK ~\310", 32, "\323\372Uv{\243\026\035\350\261\323(B\257.\334v\024K\016\334\227\034\266", 800, "]\275\033\351\007\357\036\375\264\375$\360\322{\213Jaxg\027\21729\251\357\274\246\222\267K\271\351\237\321o\2451\035\310\2423\267|\272~\254\222\030\356c\003\240\337\373\231\033\270\340\277\240\3505V`", 64 },
	{ "y\207\206\361\236\374\200\304St\364<fC\306\355 \306\234\022\223:\3310\342\030\214\234\275<\356\000", 32, "i\236X\220\025\3665\010J\230#\007\227\017Z;H\2152c\246$9\347\222\215\200y0\015P.", 800, "\234P\243\025Z-\322\006\333\226r\260\336\323\231\374\204Z\012o\320\335W83\020\205Z\344H\207\332\331\331\215;\322\031H\267j>l\263z\244\375\270!\355\334\370\205\372(\027#\320!xij\313\314", 64 },
	{ "\200\364\370;\271\323\015f\203%k\217\262E?*\305\243\211S\370\010fV\255\271IA\312sL\303", 32, "P'\305'\353+.\324[\364\241]\231\231_\215\357\004\345\322\2315\250F\335I\3471u\026\325{\204\241l\235\365\233\357x", 800, "\226v\235\300y\206\023\337\027\266B+1\377\312\214/\027\343m~\036\361\222R\024}\337S$\003\001\330\317cW\200iKJ\362sy\227\307\2670S\341;\252dE\343\217\375\270\206\373,1\020\352\312", 64 },
	{ "ZN\344\3253\000'\217\224\223\206\257\3662\321\235j\204K\236\264'\312\030\327\276*\363\001q\272\223", 32, "\246\017~\226\231#gE\374\224\224E\374d\367\301\027\336XL\242+-\247\227\020F\215e\354\020i\272\214\271F>v\030\230t\007n\263\301\275\231\214", 800, "\332\003m>\274\2375.p0[\0234\037\245\256\227\2617%2\374u/\201,\316\324\200\323\225a\242\023c\332\233\211\342\254\011\230\032AV\235`\246PC\222\301\222/\342\354\261\251;\3505\357ey", 64 },
	{ "\371\374\236\365\2432\210\021\205\300A[\365\017\207\2611\252\236`\015\031\205\326E\324\010\253\037\312\267\304", 32, "e\316\2516%\025\333\014\300QA\220O\343\366\001J5\251\353\300\262\262A\2748-R\025\027\263\227z\231E}Z\207\017\250\365\030\001\344\231\376\002j!\375\317\206 \347\3046", 800, "S]:v\220\373\206M\244y$\240\260>\030q\335+\206\205\305\361\251\326\0039<X\246f\272\026\304\346\373X2\321;\013\252\233\360\351\242r6Iy\230x\010L\336-Y\211\234\306$\346\344\241\300", 64 },
	{ "\311\245\037\240\343\023\324LW\311\013\250\035\275\332\230G\317\255\267\0206\374m\275\375\336\005!\342Q\241", 32, "\361\016\341\005\310\206e\336E\256\223\266N\236L\033\035\3649\261\260h\202\303\2130\024\250L\036M\266\257Y_\203\211\311F\233\306\272\304\327\022!\267w\037\003\357\277\356\377NP\237\263\367\313\233\371Y\236", 800, ">\332.\034X\250x\004O\016\221\022\027\001\022\221,r\377F\262M\307=\033\042\341\312\014/\024v\224\265\200R\363\223|\360\235\200qp\225$o\201\020\2500\375\024^\217d\347*\355\257\211L \007", 64 },
	{ "\206\307\0424\261\034\255\242\033\233\205VS*\003W8\226n\302\042\263\366YL\343\033\256'R\007\331", 32, "\035\241\217\002\364\341\305\313Cu\347@)\020\376\336\372\375\257Y3\202\237\266\365)J\270\351\265\310\212v$\201\207_@u\013\301\177j94\202\304k\345W_\324\310z\215_\304\2554U\236\245\314\330\313r\271\001\335\0075\322", 800, "\237\225\217\301\200\264\242I\240Z}\303\365n\227ps\365\302\013U3\373\311\273`KQ\354\360\335\212p\227\245h\332\225\374\375\374\300\261#[\240\246y\212\013\332/\342\212ns\243'\243\036\023\375\002[", 64 },
	{ "d\375\042\033\372\337\277O4\004\270\037G|\234oY\032\214\211|6\374\374\207\221\205\261Z\034h\362", 32, "\332jcz)%\345\206", 900, "\312\233\266M|)\265Y\277UY\323MYj\034\203\011\353\215\361\247:(/o\270\321\362\034&\302$\2402\277\260\262\371\231\030\204\373\230;\276\371\000\323\302\025\314\027\205\035\2404\257]Kyl\363\203", 64 },
	{ "\272\211\350\227\343N9\013\232\254RC\003\362)-M\324)\211\002\343l\331\300\177`\255\373\017r[", 32, "O[\2002X\323wW\374\204vg\355\270\003t", 900, "\243FM\260\206\333G\331\341\347\337\336\001;rr\306\343\211\360\272'g\207>'\224\334\2664nLA\311\221\321\030\024\015\036\246[\224\364P\270\223q\221QN\254\272+]\246G\337z@\211FQ~", 64 },
	{ "x\357\024\247\310&1j\252\035r\024\301\217\241\012\336\300[\342\201\312\335<\307y(\273\321Wp\323", 32, "u#j\303\340\326h\242\367\023&\377\334M\201\202Y\342F\205\241\357\220\036", 900, "1\343\316\341e\365\233Z\355\313\013\021\302@\027\274\223\342\331\367\343z\353R\276r [\273\344\332~\015\311\255\324\325\014i\266dH\357s\3040\304\002\355\257\274\022\212\346\27511\300\272\215\210m\042|", 64 },
	{ "Y}\011\134e\265|\3432\274gZi\334\340\320\011E\360\353\033\374\373\004\023n\025Z\325j\036\003", 32, "~\034V#\3239\346\017\020m\212/\203\370\372'\341\005\021\246\304\341v\352\275\224\036M\313S\211\257", 900, "\377\374\030KE\325Clh$K|\350#Ns\267X\3442\031%\270\012\024\17744_P\317Y\244\316s[\240\312\347F\305Q\322\021\013D\350\022V\014\2677\017q\306\361\222\260\306\037\257\236\010\263", 64 },
	{ "\301\271z:r\325\332&s\200|W\361\220\270V\327\337\376\266Q\343/Z\224\245\021\226f\012\227\321", 32, "\1342m}<\220\234r\367W?\235p\234k\216.Z\260Q\304\212u\006\323\317\3103\300&@\257\354\276\245\311_9\004\252", 900, "\351\010\311ad_\347\271\204\243\007\377\311\236C\027,\215e\200\030\024=:B\253fp,1C\221\311d\214l \317T\027\376\030\320\204o:\362\235h\270\366\353\001eJu\004\202\300`\215%\355\201", 64 },
	{ "\241\371#\267\251}\342\250k\275/\364dhP\000\340rX\010\006f\241\371\377>>\032\370\265h\253", 32, "\333/\273\006\213P\330\305\304\357\357\324.A!\002\250\210brD\302{\026n\007\350}\327,\371\260\240\322\253Q\243\266\254\037\001fm\233\257Z\315-", 900, "\030{p\375!\357\134*\353\017C%\217C+\225m\005_\206+\004 J:N\370\367\2041o7\241\236\222\261 \313\222\177\340\134\376r;l\224cC\035v?\022\316\321D \372K\214\317\216A>", 64 },
	{ "\014b\217 (,\360\311\026\343\360yQ\215\363?\030\3467f\352\251%4\361Pt\037\261\371\014b", 32, "\032\257\353]'\003&l`\315\012\274\356L\346\001\255\303\3150{?/K\270\305\346\2311$O\244C--\351\004\206n\327S\217[\134\274c\372P}\243\355A\354\266\207\006", 900, "\007t\223\367\034\352H\312\205\030\314|\272\240\360\362\006\002(@\261\224\004\225\204Q,{qhp\240\271S\340B\015C\376f/\370B&Gf\024\022\312M\262O\316\177 \325i>\274\377E&\220\220", 64 },
	{ "=`\230\314\234r\206\304\134\367\363!\023\2774\301\323\026\011\366\265\265/(\343!\007\335\242\214P\012", 32, "e\024\351\002y\227a\260\331\026\213Y\267\251\310*\230\030W\214p\255\230u\001j\3704\315\375MSX\030c\336\306w\325\346\262\2640\255\2465\253\3334\337Nex\234\334\216\316\314|-\257\017\022(", 900, "t\221\347C\244\016:\216QD[$r\347\227\325\256\343P\203.\012\277\3216N\241\351!\037\211\322U\017h\021\042\352\030\221=\317r\306 \367G\372\270\214\004\000\207n1\3646\344\034\371R\215K\305", 64 },
	{ "\355\361\227|\310\247\256\014p\026\017\037?\364\277\355\314\030\236\306\032\306\240\321%\262\256\265\244Y\216\252", 32, "\263\354<\350\215\312\311\366\242xX'\234\312}f$>Ez\327\023x\320\355\331'\372uF\231\257\251^\034\364d\230\022\304\245\322\261>\325,\273\357\303\311N\3374~\323Q\014\342b\342\025\226y\307\245\026\231Q\266dm\215", 900, "\325\361\300\010\312\311\037\017Mh\310]\254@NC\324\205+Y6\027\362'b`x\353\007\211\035\264b\005\225|&\321AH+W\007z\377#\361\274\265:\371=\257\225\361ec]\315\203Jv\203R", 64 },
	{ "\242\341U\355j\004k\356\204\330\351ufb\327\337\357A\223\341\233\3668\220\352\134\247\202\373\006\310\323", 32, "]\331\327\016\205\272\246\206", 1000, "?\230\007\216(\272\307M\015J\344W\242_\233\230\2201\243iM\254\362+\254\333\3658I'\335\241\377\2061\013d\212T<\327\201\257*U=\014\226\321\251\227y\370y\016\216=C\363$j\272\241\365", 64 },
	{ "\017\376\364^4\254p\016=\353\344\366\352\006\227)\030\357\004\263R\373\177#\211 \335V*[\344\257", 32, "\3722\017\275\232\262\323fcgiW\232\224\262f", 1000, "\373P\274\357\005\026n\3021wkI\355\325\026\376\021<E\344\0372\020\277\014\351\314\011\312J\317\3756\321\216:\353\270\271+\003k\020\275\022\370j\3327\3621g%\362D4V\205\255\326\311\214\246^", 64 },
	{ "9\243\362\223\261\241\356\331\2720`\272\252?\334nJ\263\210`\347\203s)\023\315\005\354\340\232+\307", 32, "JFS\355;\213\234\354\267\337U\326\012\231H\355}s\316Mc\371\335h", 1000, "\343k?& \367a{\302\031\024T \034\223m\134\217\245\015\250\037_!\134\317\346Tr9\025\206\250\032\366\274yg\243j6\243\370\236X\365\0050\376\357\302\224\006B\026\034Sa\200\262jg\224\246", 64 },
	{ "m\363\264.\272\327\200\261,h\203\315\002\005\017\205\201\217\252\020\2113\363$\262\177%\360n\326\030\010", 32, "\025\271-\275,\260h\337}\257Z\021\213\330m\354\220\370\216\211J\335\206KY]\027T\226\2063\363", 1000, "\215psKGX\266\370\313\377\372\340Q\013\2700\034\273U$\033\022v\326r\015D\315\365\340\331\2533n~\010\342Jj\356d\351?\011Xr\306\277\374\002r\350\325\234m\322\223\275\042^\042]\022>", 64 },
	{ "\042t\014\315\227K\273\323\237\220!\270\0172O?\2645\030\265J\325F\343!\241\344\323\301\241\024\272", 32, "\316\027A>\233\225\212m0\037Z\277d-f\017\200\303z\334Y@\261\230\254XT\227P\301\260\014\242\266\244\262f\334\365\324", 1000, "q2\353W\236\364\266\204\340G2\337\224;\220\223/|\2132\202%\215+\362\023\340>\210\360]\217n\374'\353-\010\217\000\212U\335,\012*_\325\001\370\037\322\007uCu\037\331\242\212eb\343\035", 64 },
	{ "|{v\001\223\245`d\005\263$\321\225f\344\340\010,\305\273\025$\370\275<\315\373j\304\226\350\233", 32, "\224\263<\367\330\351A*\260\300\235\337))y\221\367\306\373G\324\266\227\372\027g\013OH\321f\326\025\333\334|\013\002e\005\025\205\004j\212\206\244\216", 1000, "\341\371\031\340\344\313\002M\255\020I\333\324\265\242ra\371mhr\017\214\366\274\337\200l\336R\305\276F\024\264\035:'Hg\231\245\217\350\306\251\376\032\310\010\311\250\013\354Tr\017c\367\241\300\031h\211", 64 },
	{ "\303\341\317.\250\305\257\235F\324\011OjZ2\312s\224st\2041KS\233H\022gm\354\276<", 32, "%\264\212\004p\266<\314:\376\324\250\341\3151\251 F~\223\267\032\252\245\370\001[\257~v\363\242\253\240g\042j\306\233\336\312\042\345\257:\266Rc?\011$\344\313\267t|", 1000, ">a>\272\354,h\337\205\232\204Z\212\230\257e\307D\322\263\2539,\264\271!\034Rg=\201\334~\201\252@etE\326\241Q3f\205\314cc\237\216\373\272>,\0112\010\273 \307\332z\223\274", 64 },
	{ "\211\211\354\215f\332\255Z\340\337P\031\217G\266c\200J\323\042\361\250[\210\022\007R\341A\017xD", 32, "\256\303\241\352Ij\317\253XL\262\221\031\375S\343\275\225\301\033\356\264\332'\014\004\326\230\036\275\002\325\260\301-2\223\247\0041m\251\210a\356\251\274\324\204\361AP,\312\025\247^\363t[\350\223WY", 1000, "\311\035\334V-zy\017\370\244\203\300W_f\2177\002\237T;\301\261\221G[S.\037\2030`1\321\010\300(b~\371\217\034\301\276\250\023\2462\342\374\332`\372\204x\035\247\012\237ju\275\224\362", 64 },
	{ " \313\304\230\206\234\222pk\244\005\2711u \340 \223\322\345\002w\275\020\324\316\224\325\036r\223;", 32, "\372\344\357\324a\333\254c\215i\177\320\300\242\020\025[\005\3252;b\277&@I\270\015}F.;\242\304!\177\343\012=U\253\253o[qR\371\201n\357\361\330\277\253\346\177^\332\042\322$\201\377\340.IOk\273\363\005w", 1000, "\310\012_\254\372k\220\263\272\361\134l,\345/\371\371\357\237\301>\205\237\237m\036\272~^L\355\0210X\221x\331\0256LD\264(1f\357\014#?w\034\023'\210&\355\261\235\361^\004\277\313\014", 64 },
	{ "\373\253'\357\233\227]\260\212\305\037\273`\364\001\032H\177\203\342\012\022\225\2572o`\240\277|\275M", 32, "U7%\340\031!\012%", 2000, "\024\2525\230j}\315\267\244\345e6oY\226\027\347\017\336\134\316\355*\252F,\034\247\267\270'\017\245\201I\2735\205^\205!\205\312\221\352\216\270\274\222\276\011 |-E\301#\240ifGA\375\210", 64 },
	{ "\207K/>\226\027\221N{?\037s\003\323&S\243\355$R\361\254Q\026R9\2540\231Zx\374", 32, "\314\260\226\231\312\037\245u\230\345]T&\037>\375", 2000, "\010\267\374\351\370\303s,\323\030N\244\353\252e\275\205\253\206TL\340\3205E\004\253\204f\220\362\330\231\037?\204'D\274+\367\363\316\340\340x:\230\254\313U\016\347\023|G?\363\017\037M\177l\321", 64 },
	{ "\215\3425\215\223\0224\311Y\251\213\337\240nw\233\343\320\335\244U!\300\023\023\347\012w1\222\011\263", 32, "\010uJ\261\030JR\357vV\257Wd\012\004i\257\351\360\266\303\200/\256", 2000, "\211\243QK\231\376\321\212\322\350\321*\245~\311+6S\013E$\351\217\227\224\217B\006\230\212\251L\264\245.ZJ\350$!u\000Q]\021}`\022\370U\364\224\215\274%\353\333Ys\177*\265#\314", 64 },
	{ "O\2649\000z2\177w\372mk@\345\277\270$\231\330\246\001\334\350\271-\264\343\307\342Nw\231\221", 32, "\201VZ\223\246\217\224\263\241AO\325\367\251\031\322\221\200g\354BM\2600\340x\276\307\246zIT", 2000, "\316\341$\022\261\303\322yZh\227\205\310(\347\233\326g\031\220>\011\226.\352J\242\311\274\247\211\010\355\336\220\214,\2440\214\311\241\253I\042^\257\361\336\241\360\177UB\356G^\325\203A\3040,\042", 64 },
	{ "\177\016\252\362g\010?|\0168\364*!(\042\343\015]m\253>\012\012/\3471\205\015\321\014jh", 32, "%$\263U\023\275\273\230SxJ\363o\373\241JK\234\252<)\207\026\302\267\215\016C\357\014V(\021J\336pq%\360\214", 2000, "\301\365\314\263\264K\025\305[161\030\015\211\207\0358h\020\231\042\351\031\323\253wC\320\330\351\205Nm\216\024\033\201e\324\037\354\006Z\331\305O\335\272\333\233\243\262\271b\023/\342\320l\177\311L\000", 64 },
	{ "L\027CQ\252\262\232\343\237\205\245\344C\014F4\134\210\345\213G\256.~;\240\252<\332\202(\032", 32, "\313\376\250X\267T\235\320\236T\242[\255'\0117\207\332 \2130\242kz\246}\336\321\022_\316\377\323}\340_H.\001\337\327\205\372q\022\355\013m", 2000, "\302\002\343\242\245\365L\016\366\205WD\242\015\330\375\300\357\357\020\206\344j\237\022\002\036\247\265>\350\036\212\027\242\325\2135a\320\312\344\330O\366\335=h\253\330b\216\221\017\031\026\027\233 \260\254\204\345#", 64 },
	{ "\013\207\005\265\235\252\020\354d\367\342\006\341\2004\311\021l\000\256\246\241\342v\342\026B\225\333&\214L", 32, "xW\265\230\242\345\002d\230\216\315\347!\232\272\3751J7\3271\011;-\3309:\207\374\204\244\203\244\333\026\011\344\366\134\364j\324\004y4\347^\005\313\202)_\030\217\236\355", 2000, "F<\236\376\203\266\204\306\361\367/\001:\220\350a\366\035\326\374\332\244\304`\202\367oA\335\331\013\330\204\361\353$\347\206\345\231\005\231l\215\013L\351\302\267]\244\006\335\374G\342\311)\245q\301B_I", 64 },
	{ "\241\021vc\346\211\270V\212A\302t8\233G\232&c\001_\263\211k\232~\241\001</\001\362\022", 32, "\246_\022\207>\305z;}\204\371F<\200\350\260%E\036\374\013Nu\200\242>\321\234\316Y\232\375\220\036\243C\250)N\375\341\3775\336\357@O\232\304\225gH\351\270\316\003V\364\003\206;\352.\320", 2000, "\360\350\222\354\320\364\042y\245\343W\2413\024\250\221\377\245\325GH\277ZAu\274\026\265\275\231\304\2722.\010np\217\302f#\346Z\347]@\216a\302\177F\233k?\326\337x\301}\230ek\300\332", 64 },
	{ "\030\344U\2107\244N\237\230d\255\376\324\213\343l\224\201\325\027Xb\201sH\200\245\263\244\035\005\300", 32, "]\371\274\014\217\177([--\347Z{\021\350\330\301\134\255n/&@N/\177?\2006\2026\360\241'\3025\215\362\253\322\027\034\201mA\353>3\247\366d\327\007g\335Z\367|L\026\234\301\340\016\325\204\261\244i\036\016*", 2000, "\225q\223-\325\221\257:\351t\266\032n\250\357\002\350\003:\020\242\302\236\311\245zi(\333\010B.\311\256>\265Uue7B\030-\243((%\332\362\303D\325\242\314\243\321g\264\201\331\001@\207{", 64 },
	{ ".\356\217\343\212\004\001a\027\213\207[,\042\231Xj\221\315\276HB\037F+\372B\251|\265t\026", 32, "\330R]2\031E\351U", 3000, "Z\271\372U\365\246\007\342\272\236\251\271%V\347\027Q\303\237\356\304\242\220\231\026GJ\011\031R>\252Y\223\014\017]\311\365\265>8\370\211\323\014\2027\225\304\030\273\000[Jj\204\015\025c\211\302\361\331", 64 },
	{ "\333?\003\246\275\035\007?\027Y\354w\012\344f$\3309\030Rf\263\366\306\350]\332\002\221\346/t", 32, "\361A\234}\315\361C\366\227\177h\325\235'\001\205", 3000, "f\367\374\346\006B\013x%\010]\371I]\256F\042\264\334\233#'\013\271|\347\355I?#7\266\257\253\353\027\217\025\276/G\334\020'\271\004>A\033\233WM\237\377S)\347}\2357\252=\277\313", 64 },
	{ "\334\276\227$\003\200y\2567l0kC1\3330\310*x>V\273\021\015\305\246=\250\353\361Y\221", 32, "\364\023\034&\371R\363\231\003\342\350\236\0131\333u\266\314\327\266-8\243\374", 3000, "(\004s\333p/\003\201\333\376F\024K\313\004\374\371\310W{\037\313\377J!\304[\303:\3329\340\200E\204\177\212p\235^\221pu~\270\361Jvl\267;W\225\034\311Lm\371Yl\301Q\032f", 64 },
	{ "\221\326\310\317\321-OH\334\006\007P\374uz\213\300\226h\231G\2220E\237\235\323\030\235=\316\267", 32, "ZO\241\0178\261\034\025\311\353E=t\353\331\003\364\243}\005\343\364\006\340\024t\341w\310\303\235\035", 3000, "\363Nm\010\373\315G\216_\354\021\200I\242]\014y\026u\301\346?\273/\304\213z\264\231e\322\304\010\217\205\303\204\277.\234\371\22699L\242\342\313\027\210\316\026z\252\215\235\307\347\361\002\306\037D\302", 64 },
	{ "\032\370|S\365\270uTK\326O\353r\255\271\034#\327\307\370\242\262\374\266\312\263#\277J\215\251\362", 32, "\301\225\303\340w\312\303}~\011+\261z\216\320\220c\237\250\037\011\253\300%\267\011q\224\266z\271\025m\266\361|\341\374\301\007", 3000, "\364\037VE\343\326\327v\222\042\300\250\272Mr\036\023\270~o\316\314?Z\321\232c\261\374Rq\020~\032\344\333\134\272\223)\035\005Di\205\345\012;\3076\227\205Y/Z\350\016\236\317J\253\323`=", 64 },
	{ "\245\223u0\342\000R\223\240\033e\340**\244\254K\302\031\363\177`M\240$\247\361\317Y\220\227\344", 32, "\372U\371\002\134:\304\002\023\314\037x\372\231\375\241\210\360\224_}r\334\302+\372t\2741I6\035\232\226\036\336\012\211\316\260\205\220\3374\316\256m\343", 3000, "\273\361\376/\034`\322Sy\031\333*\033\134U~$b\362\363\236\361$\313H\022\243\203\306\352\314\375\204\347\223S\246\314\230jB,%\241\000\335\237\364I\000\215\266\300DR\211`\322\271\306\026.\215\341", 64 },
	{ "\273G\256e\220\336\234\0325]\177\324\012\204\230\031\322\023<\020~;\347J\355\027\244\032\342\304\340t", 32, "A\350>\021x_\311\275\017\322!\315\376\357\177t\236\001~\355\315Tg\344_\012\002j\2454\002 \233\012&\212g\224\221m\242\315\353\250e\322o\004L\005<)\220 \177R", 3000, "S:z\324\320\361s\320>bW\326\0118\026b\316[\021\265\375\273\021\343\031\205u7-.\307+\360W\237\321\236 z_\347H\256q\255\022\242%\2746\032\251B\224\2446^\266\261\177|\272\010\246", 64 },
	{ "\367>aQ\260\374\262\260\020\201%\260[M\244G3\337H\200\025g:\002\275@\373H\364Q\030x", 32, "\321~\273\020-L\224;2\342G\223\025\235i {\256\342 =\316e\376\014\215\221\034\252\235\25762\007\210\3158\257(\235\277i\350\272\011\016\231fb\007\243)\307\376\2409\234\011\034\207\262\307\026\230", 3000, "\307\312QT\215\034\320`\314\352\251]\210w&\203\004\2716\352\251\311\311\261\001\220\276\224\301Y\020\241\245\364L\305\335NP#$]\251\023}z\304\351\304?\214\000\354r\323\000\300\220\003\343@Q4\366", 64 },
	{ "1\211\332\336\2713\223\3103\310\247]\376\015\275K\036\233\266\036\275\362\211\343\013\312\134b\306v\227\272", 32, "\134\253eO\347\267\226\220n\360+a\374\362a\314\202\304\221oy\275\020\367\201}:Eu\214\303\2002[\2270jFO\245\237<\241\323N\032\200>\314\330\261V\342\364\361S\243\215.H\012gTu\345\212M\026\024q\236\337", 3000, "m\324)\245\253\323\022\134HK\340v\314\270\315)~Y5y\270,T\3453\366\376\360 @\234\362\006\012\216\210\216.\360G\233.\326\363\253\006\031\277q\303&\215O\203\257\214\002\037\223\365\023\022\303\361", 64 },
	{ "v\352_\013\314\201C\025V\042\015h\374\375\272=\361\320\337\302i<\264\275H\002\2622\321\3266\265", 32, "\361H\3748\322\242\2249", 4000, "\025\332a\365\371\230\207\270h\260\011d5`\307%\235\311\354\337r\012P\323\005\214\330\202aT\356\202\225(Z1'\237\246\177:I_]@\327\317\332\266E\241\233h$\312q\217\325\256\230L>\353k", 64 },
	{ ")2\223N,\364T\011\236\322\2671\214\240\220\306m,Xt\322\025\241\013\276'/\027\022A}\367", 32, "Pv\327\262\275\253WCP\010\004\341,\227\242\263", 4000, "\206\345\207oIg\320\275\200\246~\243\233S\303\330a(\301\367;wh\212\016\243\335/\034\202\201yN\352\200A\261;\226\277\222\230\256\243\342\021\340#\006T7=\324=\013\231\376\255\216\025\251C\224!", 64 },
	{ "A\375*|\023?\215\251\2717\204\366\2310\356\004%\206\331\326]\022-\234\372q\243\371\231\314\207W", 32, "\031\003f\276o\314\232\2038@\307#z\312\222\376\007\376\351\346[g\005i", 4000, "\252e\003QJl\010#\235*5+8\210)A\251\250\032<6\003\215\221\364k\211\233\312\225\356\026f\220\254\303H0k\201\2565Adv\236\247Dt\3735](\3508\2602\315\035V\240\247\013\266", 64 },
	{ "_\026N\013=\247\000\330\377\233a0!\007H\0054\021\337\027\242\315\361\004\373\360t\216\203\240qa", 32, "<\252\210&-\264*1\312\334\235q\316\011\024-Cm2bX&\356\033\233\207\001&\277t\311\325", 4000, "\002R\002W\3036\276\213w8\007Y\362\377y~#\347\207+\216\225\2272\271Jh9\354*\016\361\2554\233\263\025\353\267\015\026K\016Y\340\340\377\304\015=iz\341-\275q\315Ed2n:~4", 64 },
	{ "\217\243/\333S*\205\365\302\330HZ\235\347C\007\003m\364\015,\316\032$\036\274\225\317\010,\244\213", 32, ":\226<BnxW\025\357\300\377\342}s\014\2531\030\337\275\034\324lj\373\242\134\011\331\212\003hxeX\267\332\372\267P", 4000, ";\005\007\365\022.\212\307GD1\023|),\226\325\225b\256\3054\247\235F\232\033\233::k H1\001\340k\213\3640m2\274\361\0317v\002\215jkv\330\001D\312\322\345\025*\245C\321h", 64 },
	{ "\213\25132\207OJ0!'\2722\341r\340x\314\332\330\365g8\254\260\270M\334\302\311\3033\364", 32, "u\204\234\237r#\231\267\314>\370{n\035?\032\006(\257\302\366\036\301\275HI\342\230\303 \230\301\230\226k_2Ur\210=O\3602\253\277s\205", 4000, "\266x72y\026W\037Yu\222\207\244(0K\340\305\233\310s\021\011\275\022\004\213|\210D\002\240S\276\207\000\207v'\206w\271\320\362\302{q\231\355ff\361\374B\022\363\272;\223\316|[\301\217", 64 },
	{ "Yf\027I8L\371^\314Y\006*BK\36582A\221\252\030\322\352D_\266ux\377\035\367\023", 32, "\362d\335&o`\242r@\363\2426n}\234\004t\275\213\254\236\020\341\021\304.\042\321\361'o.\002\223[\266\224\233?%\004\337\240\340<\323\267\3039\220u\334\330\242\3239", 4000, "d\315\310\234\260\364\012\230\023\235\2756I\352\305\247_F\260\3602\350\324\2067\353\341-\232\020?\247\302\014\232\253\006S\016\241\320\251\000\022!DA\022\011P\356\372qL\277\263o\303\242\007\347\225\370\331", 64 },
	{ "@>\004\006\352\316\314\230\032\255\237\021\276h\037i\032/=^<}}R\313\265\001\270n\267\274\340", 32, "3\245B\276\234\220I\261\336\323\014\353\325?6\360_O/I#\270S\362\331\270\200\360\242Mp\213\361\356;2\316\304\251\227\003\352\327\027\003\271\026\275\230\237\233'\316\003\332j\260\032\014\323\243SO\006", 4000, "_\347Q\374R\016[\274\365~\217(\266\016\364\253\306\365~W\335\223:`Q\301L>\033\344(\253\027\211\372\352.\355\251\233\005\036\225\134\220\034\357'<\031\227\223f\253\240[>\031\344\300+\025\243\365", 64 },
	{ "\017\024\253{G\272\276x`\224}\324\216\324W\363\357o\266{Z\347\200\342*s;\3159\036\320]", 32, "/\203\306Y\243\30672\2236\257\335\233\352,W\351R2\004\237n\325y*\3525\371!^r\222\364A\217\311\370\301\3677A#9\212\030q\220r\042\321\031\303\036\003\235\274F\252\134\327XKI\344\370\215\266\316\013\3704\352", 4000, "\216o\275\201\220\001\2209\010\241\307\260\352\274\220\020\004\352`'\3552\372T\204{M\221\202oy\226\223lhIe%\260\325\303\314BX\347\331\316TN\311\332\177\251;W12\006X\376\307\235^\227", 64 },
	{ "\375\367\261\310P\032\253\300s\271\362\034Q\000\267\231wh\274[\367N\031\272\313\333Lg\016\233\032\246", 32, "w4\376Oe\334\337(", 5000, "\265\320\254NT0=/r<\341)\226*\376\345\364\004\134\201\024m\020\375Z\216t\212l\313G-\232%\321\272\256\336W$\371\310]m\335\334\242\306\241\367\220\263}F0\216\267\364\341D^\212\251\341", 64 },
	{ "\341\3615\215\010Wr\235\353\224\272`%vA\336\2122KT\237t\233\321(\213\316$\340\206\237\001", 32, "\337\362\246Z\225\307J\215c\244\007W\221/m\027", 5000, "z\033/\267\300\001z\320\334\020\034\255m\3321\364d\227\012\247\032\017\370C\031\340$\307TCn\004Y$\017\220\371\274/\350\306\303\002\012,]T\034\301\017\3459\365\252\032\321\316j\231\245\341\322%)", 64 },
	{ "\355p\310\241\334\272\230LP\241\235\324\302\312\202\002bm#\375\324\314\266L\212\016\340x\0370\333\304", 32, "\031\3057\204`\205\372\200;\320i\264\027I\007\027\267*-\365K\134\243Y", 5000, "mB\302\302\253l\313x;_y\012{\273N\340\303ohA\210TQ\310\321[lK\015lWL/\252\134iB\224a\265\207+[\016\241\330\005DRam\250\335}\356wZ\006\015\256\226a\216h", 64 },
	{ "\240\367\032Y\306a\312*U\314\322\335\022\016\377\213jMmr\244\042\274\257)\267\220\3307\221\033A", 32, "\027\277\033\343S\023\203\300\354nzy\226\254a\307\2146\215\033 p\256\342 \016B1\015C\027\266", 5000, "j=:\035`\342S/}\343\240\311\033N\227\377\327\270|\215\353\241\310\206\042\265\367\206\243\222\315\023a\303\274G\037\245\345\323H`\010\231\344\342\351X\001^r\353\314 &\234\024\002\242\317\021\254\340.", 64 },
	{ "\250\277w^\361\217\026b\210\177\306\3461%\252=\266\234A\211\002q\264\357e\232\3257;\036-\362", 32, "\261\363r\305^\275\322\224\3328\261\352\242\275\201O\317\275{\020\263{YD\241%2;\340\352?\366t\300\272h\351W\303+", 5000, "d\364y\350\264o\356\017\320\011\2317\326\027\254\033V\326/\200\276\374\360d\321\265\015\212_x\017\246bE\003\256\337F\265\260X!N\354\031o\216\335O\3278\202\027\222\266\262\356\311]Ok5=m", 64 },
	{ "\374;\134\361\232\355\314\370sC\252\275N\372\2732\335\213*\232*\310\352\0312\0047\3758\230\022\010", 32, "\332\205i\265\023\022\002\372\234S\253,W*\303^o\204\316\360\332\353\237[x\030\210\2003eBX\342u\224\363\232Q\262\220\212`$\026l\207\330\302", 5000, "d\021\307\254\221XR\257$\322]9\306}\306aqr\333\224\337M\266\245-\001\2148\203\346\002\032\031ax2\336\230\024W8p\346\310\300!\213\203\241\306|\222\206i.\272\251\026\022O\007\207\262?", 64 },
	{ "\204K\335O\134`\227I\204P\241\370G\324\350\313\305\346X\221\312\313S:\371t\341\011\275\327\301W", 32, ";h\002\331bk\375\014\232b:\334\367\341\361h\261\005\266\265\316!$N/i\201\002\272\005\351\212\031<\332Y3A\243\036\303\254\255\317\317\0356\020LD\210\337aU\007\023", 5000, "\002\036\314;\347rW\266\310(9\304\223\015\220\367\334~\3175W\354\233(\372\177n\304)\270\221\352\233\256[\370\320\222\042\202!\265\201\251\262\214m\234N\352\371\314\2724\201\001\272\3643\347\265/d\205", 64 },
	{ "I\304\026\242\014M\013\255)\257wq\205\273\337\252\256\2626\233faR\365\262\257\010\010\333@~\322", 32, "\377\235?i\251n\222\2608\250N\304r\353\331\313Byx\236u\212\340\322\243\376y=fv\367\244\303\232A\214\244*p\253\333\134\335\250X\223\320\325R\311\243G\2524\337\344\134I\340E=\253\300\301", 5000, "\335\011\020j[V\242\266q\257^\2139\027XpWl\367G+\224\210\371\320\002\2170\007\223\361s\271\033\374\134\301A\320\234N\357\252:\343\275\025'\012\035]\311/H\341\315\310\303\310}Q\021\375r", 64 },
	{ "Dml\351(\305\351#\355\004||\231$h\227j\361\3136\210l\375T\213\315\375\234~dF.", 32, "n\353',\204G\017\242\020\255N\026Io\221\224v$\324I(\246\016\036\035\374[\343\260]\326\021\013ne\371\356\301D\350\030k+\357nGJ\270E\262\035\351R\303\010f\233\246>\326\355|:\2552\003\021\234>dr\313", 5000, "\220\243\001\307\364\032\262\304\372\017\266%r\204;\301!\374\042[+,Z\321\373\020S\014\243s\305\335r\331\350\370\216\277\267\224GT\035\301\030\261\237kge\006\017|z\220\224\274\033\215\201\301\026uJ", 64 },
	{ "\270\0170\011\344\012A%\357\323\236(t.v\263l\231\00450?bA\325*?<\251j\256\230", 32, ";\354h\272\035\251\026\346", 6000, "<\220\344\337G\206\302WjF\342\302\323\276\371\3105d\240\376QF\003 VL\024\357\217%\237\331\360g\326\362\224p\322\032\204Y\254\230\227A\2048\201\023AaN\363\264h\347F\222'\232\352\356\042", 64 },
	{ "+\2547\326e\016\371\243\360E\373\0228\222sO\203\374\322\204\247\240\320f\227\201\364\371\223\323\216-", 32, "\215L\237\227\342\276aw\036\025\374\246\201\030\010\352", 6000, "oT:^\276\374\027\266\300\375v`Yz\330\206\325[~/\134\364o*hW\371\213\375w&\275\006\011\361\037!j\370\317\337\301\346\234\341\354\225\321\264\305\346iz\313&\324|O\305\317\2629?\022", 64 },
	{ "\354\332\023}\256\222\332\241 \362\302\351MG\3479\276\332\334\023\362\271\253\211u\275\200\334/\246\013\244", 32, "\266\243\134H\272\356\332/\011\305Q\357n\371\354\001\020\307\177\333\037\362\315\242", 6000, "\306\231\246\333A\300/\22328l\017\305+\010\037\256\341\202\313pq9'X\264(Z\246m\177\300.\352 \372\20368*\274p\305\033\2251ar\211.\2624,\326B\031\134\335o\033\310\037\2469", 64 },
	{ "\327'\333\2626\365\015l\373\244\377\016\314T\205\023\255T\244\217\346\304s\275\370\134o\226\241\000\3653", 32, "\204\340\237\333\347B Zh\352@\2206\262\303\002|\312\203\327\333<\372o\200\035\276G\210S\134Z", 6000, "\334B\327\177g\003$\351\375\134F\266\375\211\212\241\366y\323\375\373_\267\215l[\203\305\370\216\202$p>\241\264\377\032\022\211I\257,:&\317f\245\242w\364*q\037.\347\276\277\275\244\205?\034\317", 64 },
	{ "\234>s\026\201USYC\367\314\261\324w\355\264\037\377\236\274\021\3211\006\372\354\201\250o\20011", 32, "'&A<4\356\331\213\213y\222#=_(\361\346\226\350\3564\177\261\024\350\3528 \331\235g?\007\361rYB\003\220}", 6000, "\304\232K\203\301\022\0351\220\354\260\350\311\321\337\023\264\354\256\365\333\215\373\325\201\274\204\216\310=\252y\006I7\250Y\210\204\226N]\036h<\016@\231$\234\134\271\357\307\225\273\331\245\272\2650\357q\203", 64 },
	{ "\351\000z&j\354\276\2739+7\300\022\264\327\244\275\345\003\365>\204;\276\217\307)`XP:\345", 32, "\234\365\001{\277}\042\367\222\230\030\327\264\201\016>\241\001\037\336\340z%>\324\032#\352\204\351\212eC\304\027i\205\362\215Sn\226i\215\313\374\210\354", 6000, "?A\017\245L]\214\344\373i?\212\306\252\013Lg\277\015\256\260\001\306C\375\354D\025L\134\337\263\363\025V\336\227\013\237\353>F]_\035\314D\240ES\253\357\210\344\014r\220!\222\220\010\374-\265", 64 },
	{ "T\217D\316|\373{}\037\354\234\177S\327\270\016-\231\316RE2\376E\030\245't\005)<\200", 32, "2\316\204\337k\213\260o\273\020-\351q,\220\202]e+\376ci\312\367L'\331\237\035\024\025,|\323\220z\332\211B\314\226\261E:.\002\0238\376\315\320\274.&\233\036", 6000, "\312X.<\3273\237\320\2349\267Rg'\337\230\326~\223\323}\204\010\005\352\035\221\223\244\374\262D;O\2356i0\311\333\360W\203%\321m\037\3220\267\0162\254w\0161\342\320\031u\206\032\370\271", 64 },
	{ "D\243\026\222\253]\312\252\020% ^w\024\024\377\312~Q\221\334t\215\377\365#\353\305\340\273\341\364", 32, "r\012Vc\246\013\020\364\221>\227\273DJc\233\2373F\235\001\307G\223\210\260\033\236\361\365J\037K$\372\245\270\370\2402x|\360\033,\002b\307#\305\026\345\2572\325\241\321Sk#\364\035\342\363", 6000, "\342\3053\272\022\221\021F\344AvW~\350\355\314\342|\303\324\315\002U\311\236\315#\2776)\3219\033.T?0\035\264\207\350d\247\247\042w\365\371\262\217\2051\001E}\201\301\034\025\177\016\314\246\312", 64 },
	{ ";\370<_m\217w\363\0054hx\333\347:\247\033\337\364\363n\370\042\244\303\014\306G\322\027\323U", 32, "4\331\020,\014\345\314\367~DR7\345\013\2001P\261\273\333\257\306\373\300\033\361\257\256\271\362\302\134\342<\320\301\224\034\034g\033\206\022\005\220N\260\014\207\347\265|\206'Q\323\214\276\305\357\356O\355Gr>\237\204Z\371\354\375", 6000, "\027\304\207\017\213\207_\0117\262Yu\004\012J.\274\307xu\273\372V\004z\243P\007n\363n\222:A\311\351\031\212\2748f\352@\217\347;[@\177:\023nq\260\221n\244\014\246*\361\033\212\042", 64 },
	{ "~_\236f\256=\004\026S\320\325Tz\237U\327d2#w\202)Ir\003%\220>$u4\215", 32, "\372v\342\354;>9\312", 7000, "\134\017I=\243`|\314\225\014\263\254K\014r\372l4R\015<\3138'3Pw\214\3051 J!^G\364l\334\037\314\177m\220\247\321\001\307P\317B;\316\037BC\246\310@\250\250\367V\031\223", 64 },
	{ "\371\311\302+J{\330+%\236\312\021P\377\377I\235\356\2664\000[\270Q\042\022\357\235\374\307.=", 32, "r\244\035~\327Y\310\266#\364\324D\203hd\266", 7000, "\272\304O|Wj\3136{g_+\347\355j\265/\300!lR+\341\231\2032\322:\032\272\350\331J\347Q\203DQc'4\335@i\347\334}))a\004(\313\255\3220\206\000\346\014\206\206\365\012", 64 },
	{ "4\203\215\242\377.\236%\324\260\315@\275i\310C\241U\350\363\3107\337\371\2607\223\036\015:tQ", 32, "y;\315-J\314\274\357\264\210\020\222\007\240\272N\015\331\370\037\334Y\267\016", 7000, "\351\334\341R\305\301\022\273C8\001\000\270i\226\343\304\016z\322d\370_Q\377\2671\215Zu\376nS\245\030Za\374\353\255\305H\024\202\024\0110\037i9\003\363\337\377\304\214\331\207\366\226W\012\307\376", 64 },
	{ "l?\242\3334\336\353R\233b\216|C!\013\000\022\274^$xfn\231\237!\037\357k\351\345\374", 32, "\005\276\347\3550\023\213\226w\2313\312\351\253PuJ+\027\003!\255\322\340\006\334__\017\317!\341", 7000, "=\015\237\267?\333$u\274\201\353e\204.Zls}H\344O\020!W\036@\222\362Qp\013\212\225T\274\265\256\024\2221#v\245\254\203K\202\020\355\0118\262\001\333\346\364\332\240\347\017\3227>\245", 64 },
	{ "\027\344\376D\230{\335\276\012\027xc\247h\300\221\253\2004\231N\337XVPH\350\177\202\324\336(", 32, "\014;\3008\375\017N\372G\354\331\201\031\263A\027a\351\315\256\344rE\326P\247G\375\2502\262\375\353\344NA\035\317i\212", 7000, "Y\222\200\251;I<\227Q]\356\335\317\263\351\231\042Q\322s\313n\006-P'RKDZ\330\237q\213\332\374c\266\022\352,y6\231\226\001\233\354\027\245k22\312\331^i\026\2764\244\353\306\251", 64 },
	{ "\267\366\277\006\327\363\330(~,Wd\275\303A\203\315\016\230\333\327X=*\326yB\364\213v&%", 32, "\274M\257\261N\266.k\356\343p \331wdX\324>\366a\031\362\207\3732\323\302\255\013\212r\003\321:d\220\200PI\010\0029HA\011\003\326\220", 7000, "i\364Q(V\223\200\223\340\007\374\330&H\342E\032\215\2515\3556X\022\215O\365\363\264\247Vwu>\371\320\332j\305\354\267R\323\022\274\232\216\262\361\301\225\3124\004\215=\236\237\341\347\365z(/", 64 },
	{ ";~ \241\225\021\325\357\016\232\310=\214\261\3451\270\316\233-\303g\361\216\033Nxz\377\361.\236", 32, "\272x^\233\036p\375\304\204\200\034\306\224\352\307g\361\310\003K\224\276\211%\202\336\346;c\207\240A\021\005\206\255\006%6\312\233G\017,3\230\310\301\202\226A% \0341\353", 7000, "\331\326\014\373X\343aJI\247Cn-?\201B\223\271R\230\015\346\204\350\350w\012Y\373\240\265\020\274\232\000\366\207s\263\360\323\0254S\226i\007\371]\354\314\015aV>\337\303\260f\030\275\214\233\372", 64 },
	{ "zt\362W\316\317\032\273\343zzZ\207)ZLm\224\345=\350_\361:\033X\324`\305\306\202-", 32, "\010\306xU:i\204\2235\375\346w6Q?\036\010M\267\275\265\240\223[p\022\255\213K-iKnR\263oP\263\002\036\331\200J\363\365\314\214\036\026\343\304\316\352=a\211\274*I\340.\266\015\265", 7000, "\337\242\214[V\263\350\233\377\006\301\201\275G-\365;\260\241\030\035\355\010\242k\361,\271\344\377bB<\304\242h\357\015\225\313\203\266b\031\322\270\235\376\365\351h\212b\2250\317\2567\254\033\223PLq", 64 },
	{ "\004\221\352\003\252\354\313\377UT\030\207\205\362+\004\033\015\2140\004\261Yr\001\340jA2\241\2625", 32, "\256\300\3735\301\013\223\035\221Hl\304mj\340\375\215\254\337\0332\3472\274\254g(.\323\322g\0122\177\347\377\343\353\271t\010R\024\215\331\033\0027e\237\305{U\034k\357\220S\240v ;R\266\177\344p|Tw,\230", 7000, "\335\227U\002aP\016>\270\376g\266\312\211+\305&\013\273\312\262\364\365*\002\227\256/tg\007\341\3777 \351\323\337\031\246\025\227\301!\330\221\032;tX\007\030\004\353\004oX\277j\250\257\323J\230", 64 },
	{ "\347\324\310U\204\323j\341\215\317&\325zo\327\025D\024&\352'gZ+>w5\256x\3500\353", 32, "\311b;\237!Zc\350", 8000, "\032\210\262\273W\324\134P\216\315\300\312\325\270\346\032^\031\022\260\372u\313\336\234\315h\005\264\2010\373$4u/\271\311VX\226V\304\261\042B\241A\227}\265jR@O\3651\364!\012w\246\335\200", 64 },
	{ "Dn\207\341\204X\030\206\355vO@\340B\275\354\000\023\311\265\225T\237m\013\364\034\247\353\217\316w", 32, "\372\366\303\033\331\272uy\262\371j\302\256\356\334\257", 8000, "\250KJ\204a\031\225\204\016\325x\310?\230\013\2070\322\302\263\231r\264\001\240VR\237\270F#\330\353!\337\330V\256\223\357\262\030\2421\205\037x\272\305L\350Z\031\245W|\360\325\305w\223\020oc", 64 },
	{ "\355\015e\250>p\225X\225*\011\316{\311\244f\364g\372\300\336\351=\216-W\324\257\316\373i\376", 32, "\226l\330`I\331\035r\203A\354~\251\373^yQK\322\343.Z E", 8000, "70`<\225^\221|\350*\017|\244\004`\317\221\134\376\352}%\245\324\360\216IY\042\311l|\201\350\230\210{\346\034\271\264R,&#\001\337\261[I\357kBl\336\335\213T\352;\015\024\301\033", 64 },
	{ "\317|uV\275\303X\214t\250w\274\335\0028z\376\025\223^2\326F\250i\006\024\006Jm\303\017", 32, "\012\375\360\206\245\022J<\212H\177\267\247\370gr\326\322\251\011\324\331\010B^_IC\317JP\327", 8000, "`n\314\361\221\2161\263%w}y\006-\323\010S\354\240\332\026l)\325\266\023\013\036.\273\000u\247'\273Y\316j,ap\345\206*\264\324inn\022\203tj\260pb\023\210c\306R\234-\320", 64 },
	{ "\231\230\221\276\330\2648\017\330v\311\346E\364\272<\037\243'\355\356\252*\210f\006\036\206Z\346[I", 32, "/Ws\213\262\202\020\005n\351i\334\233\303\375~\374\341\251]\227\247aeU\246H\263\031\035\015[\250\316\205\031{\222\016\205", 8000, "T(\016UCC$\370\236\251|\013s\237\023\325G\014\327\376Q\013\306\244*\233E;\014\264sZ\2449\242!m\200\243\264\342M\257\0350\370\357\224\373\262\201K\023\204\334\320\340\016y\272P\311A\217", 64 },
	{ "\372\310Z\030\0367\234\257\361J\306F\267\310\216\2069+\013\224\275T/S\257\3554e\177P\243\134", 32, "p\237\036hc\362\305I\350\222\316\022\310v\240\240rE\200\277\241\212\245\330\260\035y_i\374\332\240\304\031w-QX\357\022Q\025\343n\371\273D\201", 8000, "c&\346\353\305F\004P\307\212\3268\356\255\252\225vy\214\213%\340Zz\242\252\301\263R\344qUhOG\334\363\177\203\030\014m\241\306\313\366m<\322\241\254{\334A\007\371\035\0210\211\320\357\042\014", 64 },
	{ "\274\023\233g\226\220\266b~\011M\215\240\304:\345\216)\2338O\031\205c2nj\364\332\245\252\275", 32, "\023x\251\256\246*\363\004nr\336\240\357\031\011\315J\210\243:\023f\263\202H\333u0s\323\345\2516i\212\012>d\344\004\231:\217\371%P3\004\333\225M\037\321\036'z", 8000, "\305\373\334\202\333DvE\007\302L\246\273O1\312\006\327\203m 1\227\322\262\275\262$}\343n\377\275\325\034\323c\242\337e\352\247\217\264\200\276l\203\207*MG\245wI`4\261\200\025w\277\374\273", 64 },
	{ "\310M\231/BX\015\3022,D\221\343\336{AB\373\305\232\223~\332\001$p%\236\311?\307\255", 32, "\346\237C\3322L\307\240\003+\342@\244\356\210\3652@\231uyajh\3672)\3133k\015\247\011\221\360\256$}G\232\326\344sB9\266\326a\273\276\273t\134\330Q)\2555O\212\204\207K\251", 8000, "Fg\027\253\252e\334-\306!7\300\374\277\235\274\261\350\005D\327\262\302\037\025\016\306|p3+\031\230\216\224\362\370&34\314\240LA\326\010\307b\371\177Pw\310\2605\210\275\305q$YPw\024", 64 },
	{ "\243%\302\344P\210:6\271\3316\330|\234\377\325x\317\255\356u\266\204_\264\232\306\221H\235\323\233", 32, "\203\355\374\337L8\346\314\340\310\310)iB\261\313\303`\254\263\356\011\360LVf[\240\372\033\263\031 \237\361\263\264\007\257\323\224\205\207\366)\344\220\270H\216\005K\310\200\256~\341w\352\365m\305\316\231\315!\354\232\270\030\327\027", 8000, "/p\266KV\336\250\270\214\3752\255>\253\011\261\353Lu\022y\313+\300v\201\005^\333\310\370\016\375x\023N\340v&\222\042\353W'\277\014\226ss\240\314T/\020\347\2303\225i\337\255\217\275\310", 64 },
	{ "\020\352\211\2704\337\355MK\251\237\315\207w=\345M\253j\013Q\312A\323v\256\212\273\346\314\206Z", 32, "\356\327\312\324\304XV\042", 9000, "<\252\305rA1WHK\030\310K\220\312\214/\225\222#\211\020y5J.\373.\375\250\246\344=U\326_\322\205\303\357\316\212*2\252\1347yP)/y\330\030q(;\275\222\316B\345N/'", 64 },
	{ "\246\200\343|\000\363\320\004c1/\252 \230\027f\221\010\300L8<\315\333\014\000~\013=\224m`", 32, "\344h\347\244\325\331\22483=Nft\360\302\261", 9000, "\330Y+Q\337\302\005\230&\257\271\201\020\266\346rXi\310\342\234l\365\374}\242\365&\377\214Fn\240\315\272\026\322\326\2318\332\325\001\362\007G\316\346T\001\225\273\377\042\345?\377\330\302\361:\354Q\270", 64 },
	{ "\300^\277,{\327^\347;\023\366\331\344\214@\224\226/\231\304z\212\024\264\343\305u\353Y\301\305\031", 32, "e0H}\001o\0238|<\317\200\275\255I\300\2211SZ\350\024\010x", 9000, "\346\352\302\366Gt<\261;\010((\022\360\232w\323\024~\3107\323\001\003\331X\006\245\235\364V\302\000\233~9\370\225\340\312\2120\011\362\274W\036\272\270\3168\311d\366\361\270\254E\363Zg\001\326\227", 64 },
	{ "\302\3170F\365\303\367\304\340\000\332\3223F|\363\231o\336\315\010\334\000\327\225,\300\205\214\301\272)", 32, "\017\015*/]\217\334\262S\312\317\235r\371m\225\273\013\215N\360\016\324\003 \257\222\315\371\014\326t", 9000, "Q\213LROW\365\360C\375\251\233\235\237\273f\370\333&Qv\035\231bj|\2621\134\365\213\254\264\221\377N\321\305\036\272\236I\331K\375 \276\212\177R(T\370\030\376\322\201!a\230\014g2\330", 64 },
	{ "VW\226?\011\206\237\332\316^\201\211F\363\242#\2414\260\034f\253F\020\015\356\022\026\030wy\207", 32, "\134X>oO\341\2221p\023\236\217\357\355\213qc\222\237$q\311\271\224\317\005\354\243\010'\365\246Q\371)N_\226\353m", 9000, "\310Z1\202\257\017\276\0118bF\322\213U\222~\243\033\323[\324\371\365(\344R\363\347\313\342\255\033\320\316\374]\207\371\004\353e\311+\316`%p\236\327\326o\017\235yu\234=+\216\303\3420\246\333", 64 },
	{ "\265\321\227\226\355\037\225\225f\000`\331\364x_h\261\236\302F\356\277\305\203\337n\324\242XlX\276", 32, "\353\325\230[\314*\371$\233U\335d\302\356+M+\217K\255:\305i\217\315U5dmm1r\034`^\033\200\311\366\323\244\254\134\354*.C\261", 9000, "\203\205\206;\334K\261)~\005a\365\232$.\246\250\333\351\036\237\227T\326\007\266\277\337\267\012i\252\277<v\304j\372=\202\312\335\262\355\200z\004\215\216\037_$\334d\020\323\2272\316j>f/\367", 64 },
	{ "g\342u\261\360\205W\253\3757\224>\2007\261$\321\326[A\030Nl>\300\255\270\310j\230\000\317", 32, "\205R\344\134\355S;_$R9\207\216\351\035\355\344\246\230\347\305\225y\365'\264\273\273\002\3004\3074\321%j\237\246\352\345Y(\224\334\371\274\012WL\232$z\246\331m\020", 9000, "\042\307\336\011n\273.\027\006Z\200\335\244N)\210\325\177M\000\270U\2167\007\331\217\002u\262\030\257\223\325]\371WI\207\226\211\331s\007.\224P\3330\023E\273\3256\324\2250|h\332\134\306M}", 64 },
	{ "\205\222\255d0\015\236\365\024\002w\355:\025Q\206(\000\014\315*`6\343\233\217\377\036\227\231\001\310", 32, "\031\345\002\252\206*\014\226\235[\012\333\340K\207$\010\010\332s8*\346|\245\323h}^\202`\233\200\2460\304H9\031H\2321x\013\033\363\322=B\223\224\321\2335\204\262#%\245#N\236\205\360", 9000, "\376\304\247X\265W\252\204.\025\177:\360\227\0259$\005h\205\364\030o\324p\023\206\006\325\302B:\311\252\240\015\253\000\370\313\007\002\276:\037/\001\240-T\241\221\007\247`Z\012|M\027\316\2303\004", 64 },
	{ "\262\332x\2240\1348{\351ow\377\220.\005\010\351\313\365w\310\006\042\312O\234\256\254I\225P\236", 32, "\003\262\327\213\033E\352\255k\031x_V1\330\217\232\333TCjCG\257\222\207\302aA_&\303\022\242T2V\301l\230U=\204\255\013?9\212W\217R\254\246\264J\310\243\340\215\276\324\264\211\371H~d\334V\0048\210", 9000, "\2428\360\032\336\004$\015\303\304\203\271/\302\252\361\204\366\314\201\231\324\323\340\031E\355\205\372\201?JX\264\256\177\242L\362\001oc\310\134{pO\232\234\200x03\270\364@\346\134\214\330\202\010\254\350", 64 },
	{ "`\210\003\226\023\271\363\251\376u\032@4R\227A\233\177\204+\331D\302jJ\035I~\033Va\334\306\134\337\3708\3159\374", 40, "g:\354\200:\353\237\314", 100, "\247\204y~\264\003\374\263YbJ1\265\256\370b\020\377?\034\240{\014\275Z\011\347\213\206\356\037Q\010^\306\207Q9\021\374q\270\242DI\034-\232o=\212\202\134\037+\305pB\2152CI\275[", 64 },
	{ "\330\3067\035\364 \2267\266\226]\315\242\015X{\270Vn9\260\277\277\375a\014\251k2P\003f{Z\037[t|o=", 40, "\375\276EL5\306\235A\371\032\272\364\014\340\014\374", 100, "8\255\030MN[\002\3162\250\340\323\262\011O\0374\012V'\303a\010\026\372\337\022p\002\321*\032\255\205\217\377`\264\015\255\217\005\300`\352\261\313\370`\217en.\252\205V_\331b\261\302g\333\273", 64 },
	{ "\247\3113>'\341Z\226\015E\235\221\200}d\217\021\263\134r\205NX\241\366\014\257\243\261y\212r\263D\272\243\021\207\235\216", 40, "(\213\353B\221\216\0302\003R}\310}\331\006\343\001\333\326\236\017x3\005", 100, "\261\201\255\301\037\027-\004\242}\361\027\264\250\210r\231\274=d\010\371\2662\357\017\233d\224\230\0300\356\273\264\245\212A*%\333 \326(c#\273X\026\312\226\317\031X\257,\353\213\307\254\304\337C\326", 64 },
	{ "\024B\327M\362\134\210]Iu3\223\322\277\361\3646\276H\263\030\2348XC\271\206d5\242\231\263*\334w\317\015\376\002\014", 40, "\321\357!\351~\005{\304\267\313\205\027\005\307\232a\367\212r\302\306\032\231\26567\246\356\227!R2", 100, "`\236%\333\327{\331~X\022m\274\337\203\257\326\012\247\021\326\270l\3271W\244A:T\261\250\252n\230\327\231\305v\024\245\371\377\346\007\305\204\360\215\252\267G\007\005_E\0221\223\340\3714\243\220\303", 64 },
	{ "\002\325\230\270\245\022\320|\042<\274\236\243{IF\255\2123~1\324NX\343\212\002\230+,\321\253\320\334\246\273\264\265\215\350", 40, "M\361.*\033\362\022\226*k\333\225B\320\377\266\011\307\034w4s\274\316\217\034\221W\373\003\256\244\210e\260\242)\206\254\223", 100, "\371d\211g\2024\010\257M\023f\177\247\376\000e\036\353\372\375%l4\272\370\026\343\330\240\022L\214y\025\235\360\0213\014\375B\326\331\300G\336\212}\342*,\254~\001B\204\370\200d\254 \303E\367", 64 },
	{ "\243\035i\361t\264\370\31688\017\261Ph\267\224\271\357Y4\035gZ\2631\021\253\236\364\311\031E\364K\240\313xi\253o", 40, "\313h\035\345a9\260^n\335\014\337v'\371\330D\215`\332|1\357\023\253\215\213X,\215h\306X\244C\232\236h\256\372\247\020N\275\020d\360\005", 100, "{\320\345i\277g\336.\253(|\256\347\302\022\260\330\315\247j3\217\257\236\260\302\024\204\000,+}I\202Ow\321\205\013\315\324\001\332\331\003\367E%C\205\354\345\366E\314\351\032\340\314\2568\233=#", 64 },
	{ "R.\220Q\306\005\331\013_\274\263\364\305\363\253ut\215T\042\354}\011\014\256\254J\245c\353f/R3s\342$<\205\366", 40, "\042L;\375\240\241\376\322\232GY\375\004PV\261\331}\305#d=\210T\261\233\246\322\377\365\350\365\304\202\256\264\003WX\021=\273\247;\007\215\377Y\360\212\004\324\2525\260\223", 100, "]\370(3IL\232v\357\336\347\350j\3428=\337\205g\331\211=w\023\373\311q\321fM\372\134\037o\312\270\207E\232$\246\224\0069q\245;_U\256\207\246\224~\265lfX\217+\241\177\012\000", 64 },
	{ "\005F\364\361\037\250}\236\013\315z\330\022B\011U\222\372\236Z\033ZH|G\313j\247\263\363\222\350\362\243~;8\203\276Y", 40, "'\006e\223)\331-D/\272>1\236\236\202\360\034\015\253\305\312\036\202;\306\254\036\313)\235\011\217\270y\235 9'\355cs5\311\300I\042\235ls}\202\364\002\303S\223L\3528\262\305\001\203\011", 100, "NY\261\274\311\225i^\034\326=\353\301\204\312\357y\263r\031\234\240O<%\253\221\022\321\264\015rH\311\327\302\201yi\304\360\3748z\036\022\205\236W\026\023\006\256B\227mJ\234\231\263\253\3368\202", 64 },
	{ "\006\336\254*o{\322\024\361\337\007S\353\357\243\370\244\033\261\024`\3159\311\001\027:\342h\275)R#_S\030\217V\336\024", 40, "\001/Wmb8\260\026\246\270#\346W\360\277/\347\177\233\322t%|\226\334\261~\001tJE\326+\204X\304\324&\036\134\252\004\362\020Y\347V\245\015\023\332EQ\345U\002F\321\202T\012\356\313\235f\206h\356]+\314\324", 100, "I\177\227\177z\320<g\030\252m\320\377\232\350U\255\333\271-\033\377\001?\302\021\012\016\377\317\342H\337X\0059\312r\346!<\362\023\264\275~\313]l\373\333\231\000Q\373i`8\016\017\255!\001\312", 64 },
	{ "\271\341\030C\026\343P\310\2118\241\324\361X'\023\251h\2657\300\276t\032'\034m\210\014\350\217\345\227\275B\177\035u\255\214", 40, "\263\305_\247\272\021A\323", 200, "\247\225P5\302)JX\034\322\3619\251u\325\245\224\23119X\365\364K\037\321Z]\363O*\227\034\350<\020\036\331B\327\346\345\310\0214d\325T/\233\351B\134\371\304\210\362\236 \327z\321\301\014", 64 },
	{ "\350\221\234\275\355Q\240\246I\234\215\374\264#\204\352(abs\220?\017\221\331\340\277\243vt%\366\334\233~n\30314\321", 40, "?\223\034\316]\373\026TS\035\231\031\220\323E\375", 200, ">\023\255\352\036\233\272\216\032\231\236\236\220\034\304\263\006x\212\004\340~\371a\034\375R\254T\321\237,\351>\367Be\335\020d\343\363\216\271\011!\344\345\271\325u\006Jdv\004\350\277\301g\007\211_\336", 64 },
	{ "\011d*\215\352[\313\3051?\362\360c\277?7\1771\306\221\271\022\275\205Y1E\240M\214T\225R\363\010\3130!*y", 40, "\310l3\2262\346\215Z\223\005\236\302\241\025~\276'\334r<\030Ou\273", 200, "\022\251\266\330\274\244\022\001\042g?\014Q\334^\032\320\203\004\023\231VI\236\351\032\234\200\220\272}/\255\356\322C\342\315\340mR/\024\003WvC\362}0\204\274x\315u\216\014\203\337\353\0350\216\241", 64 },
	{ "N{\366HE\323\251BA2\337\035lQ9y\377\206_\354\217\210\210\237\301\277Tm\234\001\033\237\200\261:\314$\007Ro", 40, "\226L\252\227\244 P\217\303\022\353\351\357u|\367X\206\134h\354]\006\257\247b\277ug\266\371\305", 200, "\331\343\322@\363\303\324CF\204on\225pD1\260\342\250h\337\376<\376oqrOrC\260,\014\330\234@ \363\236v\206\201;\335\020+\253#\232x\267-\035\035P\010G\277\322\200d\241d\337", 64 },
	{ "RjMU\235u\300\005\020s\3026\244C \010T\277\204\025}6\221\260t\030\347\262y\246\004\004\022nP\003E\224B\275", 40, "\361|Oc\337\006\334\314}y\037}5'L\363\3776(W\331\015+\005y\211\036X\006\33121\012Y\017\011c\016\353\025", 200, "<V\312\266\223u5\270\312\347H\210\237^\213q\031\042!J\257\320pXe\326f}~\035\322I\247\313\012\307 \0022\215\224)j_\365\336\245\214S\244+p\345[\322\231\236\277\345\272\034X\350'", 64 },
	{ ".\316\012\350\042\022\257=/.\310\354\276\336K\326A\233\223k\213!fb\242\371\230\312\276\026\316\016\361\361\134\246\206}\234(", 40, "\235\225\015\206\365)\227E}\330P\262\013\322,\010Px\034\020`5@\325\373\316\266X\010\200\177\307\367\260sK\316\352\226\363\003\300\253Y\200\363\253t", 200, "\255\273_\317K\352/\277\221\035\005\010\365L\216\031\246\206\253\251\23277\36755\200E\367\311z.1F\244\374Z~do\335%\312\217\272oVa\273\301\323\000\376\251\037\326f\306\243\134 \225\212a", 64 },
	{ "Y\244\247|\340\205\376\355\004&H\253\342C\372\257\252\025\376\260\225-\320\264\257I\316\256G\327\231a\271\361\022\324o\257V\257", 40, "G=BUR/\221e\200\374\316\371\350\027\0341|\363\134\241\254\213%\003\042\321\253\370m\243V:\024\262\011\270\347\026\331\321\375R\271\222\025u9[)\364\357\357X\227\210\305", 200, "$E\233\337\202\243\311\237\356\201U\332\222\364Z\240\337n2\374\250K\202~&s\306\332\011}b\303\340\353!\250\313\311\254\324\350\230Q\273o-`6\333\207l\035\261}7\331G\365\237KT2o\033", 64 },
	{ "..m\365n\264\333\204p\263\221?\362\372O\301~D\227U;\234^\036\300m\363uZ\361~\201\363\344\030\251l\337J\361", 40, "\217)\332X\242\356+\313*\202\256\021\353\232`\314\310\277\267jk\255\274\350\275\267E:\313\255\274\347\177 \033#\205\235c,\216\223\241\377r\262\336\366n\247\375\024N\322$a`\304\022wk\200\020\303", 200, "\035\363\013AGy7\304H<?I\036c\254\026\334fMb\276\304 X\210\267\2552fS\223\244i\210\242\356w\364\015\211W\042K\232H0\001aH\336.\370\003\251\001\225\212\376O\314u:\254V", 64 },
	{ "\347+$\314\2676\026\335\340\275j\342*\246\313\245=\323\226\320}\367[\335)\226a\336q\365G\350\337MI\274\223l`Q", 40, "N0\357I\034\2230\216U\320\267\013`\013\277\216!\032:5\261\024\004\370U\260&\202jDN\233l\271\337\022\217\350\327\272\263[\272\351\004\313\304G\267Q\366\202\275\350\332\372\022\357^\265F\227\272\332\337o\021\205\231\261?#", 200, "mEe\243\363\344R?R\035\316\212C\033*\351\322\221\210\037\177\221/r\204\022\313}\273ju\227\275\310\304\362\206\263\011\233\234\012\227\300\225\330\331\322\317N\244=\217\134\201\004Uf\042\002\233\352;\032", 64 },
	{ "C\267\015\266Lr.!\374\322\330<)\373\221i\226\253\033\272\267C\027\034\005H\350\247\204\020,\264.<\364\211'\015\310\274", 40, "\323LJm\012t\260\336", 300, "2\257x\276`\036_k\257Lf{\232UyO\312=\306\310\036n-\235\321\335\330\037\334\202\376@Z\200p\236\037\251\253\021\031k*\201\373\205\3369\321\0278\234\371g\357\216\350&D\325\012\373=\022", 64 },
	{ "6\362\372EM\003q\252w\004\001\335\303\002\0256\271\030\306\3062\324\020\373\026~\010|\264\2616\263\013\240\036\270\304\030@&", 40, "\036\023\276\377\200\3138Eq,\226#>\037^\036", 300, "^b\177X\310\203*\016\340f\343R\233\025\025\222\017l|R\203\227F\217\311@\261\207\325\013\273\042\375\260\256b\333\036\221\220\026\377\223X\336\243\217\235h\006\3110\231R\314\247\3401q\365>dA\010", 64 },
	{ "\350$\307\023\016\225\330\3677\315F]9\3447F\306\036?w\000w\266\266\214\244|w\354\204*9~\331y\262x4\237E", 40, "\023*\200k:\322 \321O\214W\374R\223>\232G\202\230\223u\231.\266", 300, "z\223\217\302\200\321_U\300\304W\241/a~\367X\24385\244\207\224M/\255,\232\252\366C\377>5\312\210\273k\001\377\353>g\204\032>\017\303\207#1\021\373\257\031(M*\014 h\334P\370", 64 },
	{ "\341\320\235C\357(E\316\332\224\353$\002\330\352{m\215\310l%\255\247\035>fQN\270\217\001\211\355\265@\2036W\263\210", 40, "\232\001\020\307\220Q\244C\312\213%\0206bK~y\272Bh\302\323D8OE\205\323\356\003\235\300", 300, "\227\366^\335\033\330\023e+w\242!B*~t\226\326\322\201\020\251\025O\336 \302\354\355b=\3732,\304\311\025\005y\032\376\005y\347I\031\260\336\360puq/\340\235\325(\337\023\344y\225Hs", 64 },
	{ "E,\342\3250\250\275N5\307?b\016f\215\200E7\3260\2062z\026X\243R\245A\210R\014\262\240r\305Z\303\211\042", 40, "\213n0gD'Y$\2742\031\330\027\247\253\343Y\345\263Y\335\354\270\0275\205`\015\227\002\3527\336\367\354\337\024\204v0", 300, "\305\042\312\304t\351\241\223H<~\212\257N\201\022\363\032~\231\241\373\300L\344\333\302F\272\233\306\037\231\260\236\243\326\035\370lOM[v6N\214\042\362D\224\001\372\316Z\372\220t\177\301>\020}2", 64 },
	{ "&\3372)\301\232E\222\030&{\236\272\013\210\011\034%1\352s\310\341^\310\251\352\177\257l*\3071}\343\011\317\377\012\221", 40, "\332%\357\310,%\202/Ei\2600\0219\256\305\225}\344F\273*\231\272\317\004@G\334\242\311\270F\0232\240\264\003\234JL\304P\2627\271\234U", 300, "\017\356\256\272\201\031Kf\300\365Z\246\362Z\2765b\346\272c\011\222\241\033\337L\356\323h\034%\001\270\020\016u5\251\030\013u\343%\361%c\005d\242\340p\224L\255\261\370\025\216=9S\225\027X", 64 },
	{ "\023\225\225\225a\205\3544\023J\002\345\037\024\217$\252P\240\347\025-\206\0266wn\353*Jx\327\323\213qo\322~JV", 40, "<\225(\247f\351\21182x\003\036Z\333I\376\347\211\037\340{\241\0017jPQ\037\206N(\365\354$$\001X\253\3713\253?\263.W?]\260\327')\347\200\240%\354", 300, "\362wD\306Q!\204\002\0347J\363\256\214\210\3030\266\007\3170\323\346\375\301n+\300\010\025\345\010\0316\363\344%*\377\360\260#\212Ut\324\347\334;\011\356(&A\207\0332\013\320\3060\367\271\333", 64 },
	{ "\267\244\274\263\273\230jf&\202Y\220\226\354\216\363\010\031\206\326p\363ux\3536%.~<\213\324;vCi\0217\004\311", 40, "\230\250\225\200\265%,\326\017\035?\274\237{D\272\224\303\3037ea\205:\042\022B1\272\017\275G\263\317\344 \306\204\233\244\273\254\235m/1\317\223\344Uf \273\372.\305\306?\005\011[\217\302p", 300, "\360\214I\303\037J\034r\211\204\333\023u\217\274\134\373G\024\327Z\016\331\022\210aOM\014\212\226\240\257N\215nH\266\343\006e?X\244\370&-\313|\252%\353\351{\345\340\004\345\271\004Q\314^0", 64 },
	{ "G.\325\033\317\202j\005\253z1\227\033\207\2061<0\003\311+\3337L9\264\004h&\027@:\030H\331\313/N\270/", 40, "\006\032\324w1\247)\271\337H\335\312\316\2467\214\042\207\245\373\361\250J\207\354c\253f\371\001\276o\343\300h\010A\300\366\331\301NI\255\322\270\350lf\246\020\257\263m\231\311H\3175{>\257\223\313\262Y\245\254hghv", 300, "d8\023\233e\020}\215\007\036\002\367H\003\367\336\010\260\364\255 \360\200\223\265\252\203y\315\322\013\252\376E-gi\000IY\325\367\353)\322\311g\023\301\245\245\134\223n\211\324\245\301coXc.\320", 64 },
	{ "\302\347\272e\366\307\3749\015< ^\330\275\344*\370\033\274_\361\227=-\350d\340[V\025#\225\255\017\252g\325;H9", 40, "\272w\001\242\254\207\370\351", 400, "\304>v\275T\012F\025\366\200\362K'\263v\211\232\267oM$\337\134R~&\262\205IM\300\372\3549\014\177\267H{!\241$\234S=t\355T\247O|?\310\247U\263\326y\000\221\214\2404\266", 64 },
	{ "8\217\216\363!u\361\212Kw?\134\251\346\316\012\000\0055\042g\230\010T\374\365y\312\213\333\307z\022\363\313\330d\354\226\325", 40, "\331\326\007\325[\226\374\225\250\021\225\214\012c\240\310", 400, "\016e\302\330?9\223s=\3620\302X\221\336==v\365\351iF\340\227\223;?b\005;\010\201)\327\262\006\247\0077\345\224\250=\026\341tP\303-+M\025\014[\367\007\022w\013k\374\032\234&", 64 },
	{ "\027\271\230\271\345\254vz%`\006\201P\331\3222-\323\374\222[S!\003\011\323\231\262+\325\224\250=|\277 \201\254\201_", 40, "\010\214t\242\242\352\314\021\304\320\367\322I\3120\314Ry:\334u\354\272\370", 400, "\334\230\272\330r `\333\030E^\250m\023}\302\022\025th\024\364UC7b\001\301\023d\272\265\207.\037\377\371\011\362\344\270o\2101Bk@\340\332\351\253\257yp\361\377\331v\016\3105\020\363\317", 64 },
	{ "B>\351\352\241\021\035\330U73\250J\266\243\374+\340\306\337\263\316\377{U\331\250\304\033jy\0032\216\021\211\345N)d", 40, "\250,\252\367X\257\022\264\331\373\042\223\226Z\021PQ`d\021\371\201\227w\374r\2028\033\3662\377", 400, "\315j\243\042p\000\266\016]BH\350\270\356\257\236\013\214'\347\347\001\010\341v\357\271\355avY<Q]8\337\036\343\017\035\247\2306X\011#\210\315i\036\032\265T\306\320$\226k\276\322\305\262\334\257", 64 },
	{ "`\320>\354\250\367\032\260:dRv\377\134?Abn\262\026\020\010\371\255#\227F\035\326,lx\251+D\372E.\263A", 40, "\350\3618b\270\207+:1\033\366\322`\321,\240\244/TDD\315\362\335\354\231\327\333hI\365~\270\271\244\374EU\237\270", 400, "jY\035\262\337\213\327\204\367\352u\230\024\020\021/\027\261\021\037D\2740\354\276G\035\222~\037\3065\201\002\350\042\371\276ye\020\253^B0\234\237v\363\252\267\221\305\373\336\016\034\351\236\243\215\375\236\305", 64 },
	{ "\270\322\236\314\345\206Gv@\370=\210\267\316\245\215!F\264\211I7\032\231\225\360?\020\375\256\371\0020V\204&\134\273yk", 40, "\265\257\037\360V\302\357\200\373\024R1X\211!\362\327\027\275\134>X\371\334W9jt=1\331r\241\0138\265\344{hWe^?rZ\301\305\375", 400, "o\212\230=\031.r\255\037}3Q\3413\237%\320\323\362\260/\014\377w\312\370!\236\335\371\010\377\240hR\252\254\016\000\030\332\004\243\305G\371\024<\025r\243X\312\371\320p%n\340K\317\346\2710", 64 },
	{ "v\203'\352\031\202O\037i\246\205\355\211^AW\331\251g\257\356vw5\003v\247\304\225\310\232\206\373kqS\360'\252\255", 40, "\252\275\277Tw\316\320$\304s>\372\236\264\330\354\341\314\275\315\034E\240f\001\330=ZK\001\026b\317\333\007\224\230\272\020\366\314\332\027\265\221\033\244\034fA\323\214\032\227\010\225", 400, "\327\262\021>\322}w \177&\302\357\351\356\350\345\217\300\004\24057\0254*\367\365a\200\263\353\000\134h!\226O\243\202\231I+\003\006\244JK\210\005\336\363\032\352\242\206\330\266JQL\013\356\356\307", 64 },
	{ "@\257T\377\244\313W+}\242\241gP_\252\2466u\016U\335\230\344\210S\323\030\01608\237\351`\320\332a\3702t\327", 40, "lB;^\004{\301\301\2000\367\227\226\026\222cQl\322\225\374\221\351\277\134\301\023,\002_c[V\333\010z\271\200tQP\237;\277\213\265C6\3474\361=cs\267\200\247\012h\253\233\017k\025", 400, "b\016\304n\314l\007\256\316\042\300\033\006\033\356\305@\237H\356s\026u\276\013Z\016%g\340\344a\0330W\004\244 \241K\216\255V\345\360;\026+u\340\374\006$\201\371\004X\274\332\360D\233s\011", 64 },
	{ "h\026\013#^#\3608\361\241y\335\311\364\257\251\0033\202s.0\032I\254\256\250\305[L\332x\032\035M\275\373#41", 40, "n\272\237\200{L\204\300\313\253c\332\220c\225\325\024\243\266$$\364s\344\271\327\270i\245\375\002yu\245`\250\042!\341\200\025\017\203w\253\002{9i~Y\337\316\215G\222\273\031\200\005\221)\370\004e\200\313\2531\335*)", 400, "]J\212\037\332v\225s\225A\361\336b\015`X\010\301\352C\225\020\333\215\226\354\264\205/\034\033\345Q\316\310\311\335\025@\323\376L\373\365N\014\207\333\377\373\030c?\263o \270y1\327'\011\275\300", 64 },
	{ "\037$\023\200l\203\315\362\001r:\251Y\265N\006\033\223\177\266\276}\235\042.{\340@(\361\042u\250\364\374/\017\225\203?", 40, "o'P\035\276\332b\015", 500, "\027+\241\256=XP\216\265\203C\372\367\026_g\042W\277\042\017Q\200\260\363\021\031\370\017\354\214H#\247\233\012\244*\277\325fi\261\344\005\026\206\262v->\344\340\332\367C6RpF\273Y(c", 64 },
	{ "i\356+\334\331\004\246\024\364t\321l&\254\240['=B^\351Y\222e\332\267\227++\320,\351\315$\025H4\036\307\305", 40, "\232%\344]\343?\304T\007\016\323\211\341\264\350\003", 500, "\376%\230\250'\221\371L\315\021\017^\256\034\273;\335\337\360p\305k\331\256\370\021\371\230kZk\234\353\026\227\340\313{\203\206r\032\034\034\374J\025\352\015\335 \373V\365\347\024\005\276*\363\021\331\3446", 64 },
	{ "B\276J\227\335\347dq0\204\341\373\352\264v$\311g\306b\314,\252a\030^,\333\202\327\353(\245l\240\313\267B\243s", 40, "]r\312\3217\237OJfZR\274\021\261Q (\244\241\013bm\306\001", 500, "\020\307H\233\2222\307\276\233\134\220Sc\226&\230\273\353\315\265\004*\253\030\222\031\016\203\022`\242\360/}\301z\226\270\231L\203\346\034sh\201\216\030\201 \223j\341Y\337\350\366\256\347\301X\372V?", 64 },
	{ "\367\373\350:\033`v#:q\264G\032\235Y\3419(\211bK\002\012\317\237\217\261\277|\367'F\225\346\322M\262oO\032", 40, "\017q*\266,_U\373\216\351\001\035\3237u\354\251^r\022'X\237\206\230]\331{@%\301\311", 500, "\211\366\134\340\227K~6!L>7(#\032\2176\230\000J\344\321\013\371A6\206#^\350/N\021\341\365V\211\230;\266v\013\327\000\221X\360\025ag]\344\011\002\322\357\363\254\270\324j\333e\232", 64 },
	{ "`r\253B\0145\341=\303\240Yp%\023\256\003\232\354\212!F\246Q\232\207\224\337\347Z\216\261\235\244c\332\242w\206-\337", 40, "Z\216\370\311}==\002\367]w65\340\302\340\221\002\032@\302\210AP\273\215\335\322Q>\011I[\004\231\241\310\246\022\322", 500, "H:DD\322bY\205\003\134,\367\345\265\352\021\331\375\007\261\2251\334{g\336\022bso\015\203\277\312\264)\005\2372(\335RK\225^qM]\2626j\266\324\006\023n\371\321\340\260\354/\357\225", 64 },
	{ "\036;{cq\252\200V\205y\367HY\042\373\323<\235\252F4\31601v\341\235\005%\204x&\177\316.\222\032\214\357>", 40, "\023\321:\305B\361\352\322\345J\042\202\333Q\214c\007-\026MN\352\252\231t\205\012Y\365\340=\212\374\245\275\021\177?g)\006c\0104%6A/", 500, "\250\303\354\237a\347#'\230\270\035^\357\275\231\254\000\001z\315{\312@u\365s\310x\326z=\007S\213\336\026`}/\324\220\275\217\232\323\321\273Z@\027\317|\223\011e,2\023P\021^\325\000b", 64 },
	{ "*z\225F\206\0151/t\213\026\2309~\313\313\374\205\235*\342\026\003\267\347\223\333\034:N\2051\001O\3031\207\375H\265", 40, "/?\0267\245\223\272\370\225Ad\214,H\332\265\376'\377NE\035bP\342\311\030\202\031\311\014\340\276\266 bW]\373\255+W\316\020\211,\277S\035c\020%\365g\350\271", 500, "\031Q\035\3656\223\042s\342\21538\340\235\226v\014\357\260\013\363\201g\241\271\226\213\220\316Zj\000\306\000\220\021V\027\250\230\302\265'\255\235\334N\230\355\251\326&\207\307;4\2550p\377d\315\342\222", 64 },
	{ "\247g\321K\211\224K\024H-}\217\260\373\332\325;L/e.\307e-,\013\263n\255\271\312\213\231\241\266\264\264\010\220\177", 40, "\026\227\357\264\367\222d\234F\311\363\371\316:,\366\007\007\240b\272\361\244\215\007U$PW\007\321jGm\033]M)@\326\234\341K~G\005$\024MU\266f\333\247\374\002_\34273\020\301\036D", 500, "\2177\022\2258\227\032v\042f\134\2542D\314\315\271\320\315\026M<\2708r|@c!\351E%\035@v~j\245m\276a\367\364\311\237\016\370Zy\352k\230\322\315\355a\3212\367\252'8\027\010", 64 },
	{ "1\010\366:\322\246\037\312\007Jc|d\302)\233\366\134\224\351\272\237\3669\305\247T}\245*\3402m\241\214\035\365\341\274U", 40, "\260\042\205\205\337\006\014\3020%\243\020\221J\361\352\337\003\317\352-\006\303\032\353\333\030:y)aP\003\206\376K\313>\332,\340\202\245\331\333\034Hd\342q\315m\002\256M@4\340:99o6\013\3201\253\355\347R;\022", 500, "f_\215\220\321\254\317rr\306_[\007H\267\334\332\271P\270\220\360mbZ?\012\220\322\357\351e\330E\250N\251\256/?z\261J\276\013\226%\224.4\327\367\310.\320\324bk#x\250P\205`", 64 },
	{ "\205\310\260\004\314\016\205\266\337>I\276\336XNQ\371\2057\001oj0|\033\022u\255\233\250\307R#\220_u\021\350\222\317", 40, "\321\234C\254C=\026\005", 600, "\230m\022Q\007v\331W\031'/0\0336\235\241\254g\231v\367\244\013[8\007\016\351\200\371\305b\203\231r\241\324\363/\246\256\222\234\001\223\325\231\267\245\005Pav\241\257\323\265\254\355\134\250\224\033\245", 64 },
	{ "\032G5\256\134!\321-\371\005\331b3\321\321\351'%v\361\316\2378\213\356\032{o\042\220\355\006z\277\351\332\342\304\3146", 40, "\200h\016\361\347\034\302\327\3315\371\344:\203\331W", 600, "X\275\364\247\307\262\230\202f\255^X\225\330\225\254\223\203iL\037Gq\001M\304{&\330\342\354\002\322\252\001\301=\231\313[)\236v\012CT\2719\340S~\371\001=\312\234H\323\217\343\020\022m\237", 64 },
	{ "18\333\277\367\221\366w\230\253K\012\351\2526\234^\270/\247JD\204,\034\361!Y\266\336\274\354\322\226R6\030\207\305\304", 40, "g\241\307h\373\326X\200\134\002s\362C\011\230-\012\277-\011\377\001\274`", 600, "\236\207\032|\264\025\321-\203\236Ug\306\360\366\262L\022\333\370s\207O]\344+\326\334U\266\340\310>=\360re\227\017Nz\026\216\331\204n$\007\365\323\257>\334;M\213\024\320\252_E\010$\042", 64 },
	{ "|\017\325Z\222\240\336\245\247\207\000\326`\221e\2770\360\226\232$\274\375(B\024\264\336t`SwhX\354|D\327Z\236", 40, "\356^\021\042^\200\272j:Z\377\216\247KVH\334\241\263\307\220\223Gi\337r\001Q\246\261 \207", 600, "\323\247\260\306\013&\234n\235\213;{\234\276\241\016\270\012\006\340:6\337g+\234\0264cV\367\307\361\341Iqu\210\307\370\0056\002\343Oy\264w\230X\3239H\024\207\027\377\315\204\333\340\302\220\250", 64 },
	{ "}\017\344\277/u\246\350\315\226\323\033\277\356o\024h\004\234\343\036\005\014s\265\375\023\001\363\206d\265a\266\374\036\344\200*\364", 40, ":\361\031\206\006\321\276\321\206^*\330\027\257:\204i\311\012\233\3404\236\0040Zk\326\007\013\015\310\022\367i\313)m\341\026", 600, "\236\317\231\200E\323\025aM\347\231R\345\020\324\364\254\367{\024F~]c\204\350G\364\364\204\355k'4k\343\221\034W}TL\311B\027T\246\353\311\333|\340\2266\231\017\323\307\254\337A\007\373\333", 64 },
	{ "\247KD\327\323`\024v \344}H4C;\307#J*\323\314\021\362/\214\254ED\201\042:\341\204\313\231U<Y\266W", 40, "\324\336h\314\262\251<Q\007P\374\310\233\224\3674H{O.\022q\221\213\363\347\252\352\2307%\226\326-\003T\365\030\344SLe@\305S\024|\037", 600, "\017Q\207\261\035x^\263F\023\134N\036]rHf\035\334\207\200\262;o\216\365\3141\026\254\350\253\276\226\350\215eM\224Y\273\001\204\345\376\257?\023c'\237\000\363I\231}\313\351qWH\016\022\361", 64 },
	{ "6\012.\223\353\036\330\263\337?\033\315?\016\341\331\360\036\237\134\011s\227\366w_\346Q\355/\254\370.F\237{\372/)\243", 40, "[\015\033 U\365\014z\026A\357\177\013\266K\355|\361Z\302\377{\277\206\0261\022*\266\036\263\314\375\332t\011Sk\354\007\346r\001\201r\256\333\204m\210hf\202\217E\345", 600, "\202\327\336)u\223h\241\021\317\261H\227\225\256\351C)\364{T\013\035\322E\256\300\003EtS\3749\316$\323\027\361O\276\230\255A\231\324 \320&\254\313\027B;C\034Aq\347\023\207\242\340m\334", 64 },
	{ "\331C\247\317\363x\301d\000LXa\313\324\301I\342\010\300N\345*n\332\260\007@\265ZS\026t7MMS\037\277\270+", 40, "7\303e\337\354\025\007@4\274\017V\334\304\353A\343\267\233\313\203\011\010v\204)\341V\246\204\002\352\322\012\326\224(\250)p\256EF3\315+\265\374\224\265,\352YI\277f\261atO\376TH,", 600, "@\215\3746\033\370\2115\003:&\015\3407l\334\377?lH\372E\264X\214\304\177'\320\314\215\214\272\343\244\242\263\273j\360X\022_){\232P\372\005\310\324\323\235\034\357\2550i\004\266\211\346)0", 64 },
	{ "\203A\344a\377W\007z\276F\237(\217\033x\177E%\302\014\277\336\204ggrR\262y\267\314\355\202U\315\2747\205*{", 40, "\221+\350\220N/\347VK3b\0372n\352E\325\361\013\235\010\253@\352?\262\246\265\232\250\222gV[\011\236\331\353\030\330b\021\016\205Po\011\2661)\242\333o\217\025\316c\316\262\036\331\253\202\267\225\337\211\031\256\230\232]", 600, "\002&\314\231R\247\361\236\177\243\250\007\341\257\005{\324\353\221\327\220\206\217\312\375*@h\254\264(\355'<o\224Pi\314}\367\202\017\323\322\303h-\301\013\350\364')\265\270\012H\374(\302\004\233\373", 64 },
	{ "\272{e\323\3454kl\257\2049\003\026\001\362)^\023\226%\327\206\177\317\301i\346$+\373\304\252|\232\227)9\234\222I", 40, "h\347P\235\022\335\355K", 700, "\373\3774\354pl\302{\007\015\347!\226\236G\221|\306\236\004\023A\017a4\345\0151\300\027\276=oA\324W\305\221L\377\257|\374\252v\221\211\273HTc\325\335\010E3u\010\134\354l\032$\337", 64 },
	{ "5\321\353\336\306P\201\015\200\3739#Ae\376h;\213\224\207\257\027\031\231cv\332\261\017Ti\275\000\256h\227\230o\361E", 40, "\372\263\224\037\247g~\373L\273\134\335\006\263\212\263", 700, "CH\344 \327_\261H\217[\211\024D\277\307\243E\037\267\324\211&|\243\317\257\376@%\032\242[\312\222\271!\355\324\015\272\207\275\256\371\036\264!\254\363\000\002\366\315\3555)\014\345\345\250\205f\224\247", 64 },
	{ "C\205I\257]\201\265\013\325[\333\327\003Ow~\315\025\365\027\231\276K\254mJ\262\204\363\321\217\035\277\305\031\343\014\377\253\375", 40, "\351gQ\345\255\300\323\213,o\374\341\353\374\2231\371^\342\017n\326\313\015", 700, "\225\365\267B\337\243x\035\213\034\253\266\316\250\034`?\311\346$\012w\311\032 \202F\013oE\356\216-@\321\276\035R\357\267\315\016=\361{,\307~|\205\315_\236&\034\345\257_\205\214|\331\267\232", 64 },
	{ "$\373\272\306\024\335\367;\275P~\253\307\370\024\233\334ntaS9\036\361\267]v\260\276\042\226\334\376\244\011\344\232\012b\365", 40, "\322e\315\334\202\261\001\255t\245\202\354\270\363\240R\271-\244\366*\371\372\330\361\265\353=\037:Eg", 700, "\263\244\240\304c\2666\007\217\370\313\315/\346o\260}\021M\305\270W\014\024\344\306\036\036\335\360\024\326\313A\377\223\013\371\270\232e9\357F\224sG`\346\300\266\312\204\203\002\321D\343E\377\2241C\036", 64 },
	{ "\027\001\004+[S\204D\251\324\001\365P5\250t<Q\247$\272\0121\024\217$\363f\370%\244\035\253x6\262\270~-\212", 40, "\017\032\304\352\351F\355\032%*d#/OL\030%pjcK\230\215\232:\321{\360\240\310z\204\3463\202V\266\023MG", 700, "\351\033?=\272L\2303_\277C\326\005\316\300\035\212\346\321 \012\302:tB\341\264\325e\373\341<M\034\375V[\010\263_XV\355\242\015\3505\004*Y\322\367t\240\351G\203\250g\267e\001\354\221", 64 },
	{ "E\013c*#?\370\020q\3402\241s\315\262\370\337;6\252\263\232r\024j\346\276\3650d\007\260\005\022O10\367\344\227", 40, "9\314\020d1.8;\376M\272\307\246\310fF\325Y\254\2016w\250\276f+\340\042w\237\335\337\222y\3719\010:\331;\251\244PK5\007w\003", 700, "\334\311\244\277\321\266fr\301\304\353OK\217'\134\210\377}\205\276\027\257\253\0365A\313\370@:1C\254\3006\015vz\215*\2777\003c^4ok;\304\343\216\357\322\241\020\314bW\316\364\012Z", 64 },
	{ "\315\342\314\275'! \250\013\374\300\014_\347\020\326\310\206!\353`\374`\323R\375\314\035\365\222\262gf\307C\004bqR\030", 40, "\033v\004\311\315\205_\211L\340C\356>;\351\362\336\362\024\223^\341L\0328\350\235\247\342\371\254'\257J\357\323\2046\362\363\247\260 V\025w\244\253\246\177&n\275\212.V", 700, "\310\245K\3722\340P\316g\224`\021\2139\225\207\324\277\251{;\036\376\001c\235\342[E\314\007\324\217J\316\331y\216\216\305O\210\374\277\3710\227\276/\033i\205\316\247/\215\256\330\037\271\273\251\310 ", 64 },
	{ "\250\003\231s\236\374(\2562\314\007\365\037&\2730O\376=k\236#mm\035J\315\333\335\022\377\236\2177\304\266\177\037\352\201", 40, "\207\207\017\306y\205G\030\023\012\312-\215g\345\252\016\244Z\215\200b\021\201D\253\306\001|\024\227\363V\313~`\207o\003\263\207^\246\345\025\262\252\036~\262\304\350kvD\365|\377\301\346(\252}D", 700, "\002\345y\325*\313\214\003-7\371d\134\220\017\215j\246\304iH\271Sx)q\275n\016\361L\253\213\362\206\367\022\017\375\272Q\245\220\353.\264\011?\257\311\233\013\3441\005\370]Z\235@\200\010\231h", 64 },
	{ "\266\361)\254\304\357\342\2513\207\262ND\246\022\210\234\262\013m\331tD\036\216\256W\221\337tW\201\245\254\035.\252j\037\246", 40, "\317\036!DOSD\017\215RzN\235\344\266R\320\275,R\030\356\3542\241\217\346\310\002\020\264\260\235A\022\016\037\247\027zb\236\023\323{\301\205\323B\342B[-2\312\363 \217~\216\332\347\317\355vnZ:T6/M", 700, "\254\355\201.s;\233PQ\344\304\255\230\272\016s\332\341\035\014\023C\254\352\2167\010R\037\253\025\325PV\305k\336\364\316\347\370\375\317\247\274\3319\015\375*\265U\222g\00126Y\265\220\331W\026\300", 64 },
	{ "\236\003\332\3109\303\331\310\316\216\276\331\011\305\003\217\316R\343oW\036\362\015\321\205`\224:#cpm8v\202\200z.\316", 40, "\226\1340\320oh\347\016", 800, "N\251K\255\026\242\251J\361\374\033\356\007.\006\205\035\317\006\202\272[&<\255\244D&D\032\017m\307\345 \001\016\272k\024\134\252-$\346Y\330\031\035W\250\031~>,\346</\265d\254\272A\022", 64 },
	{ "\003\307z\220f`Al\264A\241\224\354\237,S\2351\2305\376\241\000\241\274\246'\134Ym\222\355w\250\215\206\263\024\276\203", 40, "h\256\023\227\233\265\305sH\021\306\012\3042\020\325", 800, "\007\235\346g}\177\221\322\004\250\373 \244\336\026\255e\200\007\010\211\0311\243>\260\242\352\001'Iw1\363\365\223\255\3738\276\344\202\325\042C\2714\252\254\273\215\244\250q;\375\344?\201\233a\334\332]", 64 },
	{ "\272\210\031:*\250\216=\324\274\240L\340\220#\351\042s\203zR\2328\367\012\014\265&\372\225p\204S\310vFS\360\221\304", 40, "\244D\351Q\254>(\306\235&\226\314|\306\211\364\010\247\323\361\356\247\224\340", 800, "\360\245`M\036\222\270\011\207\000\377,LH\254<Um8\272\256\252T\321\021\203?<q\013\366\301\012\262\232\265\370!\250\032\344+\207~\245\367(\206\016m\270\271\367\262\011\326\306\212o\276#\332\255\345", 64 },
	{ "H\327\332%K\321OtRX\306\004\201\2110\233\222y\265w\351\317\304-cK\206\017\206/\323\023\2258h\335\321\035I\262", 40, "\206'/\005j\365\334\211\342\215+Jp>\217\034\273\023[\367C^\366<\213\302\352u\035\355\367H", 800, "m\230\007Ou^\233\342\007\326MA\333J\010\256^\336\231mw\3463S\203\035~63\363\222U\201\375\311:\032\3244T\316Z\031\345\021;\356\222\010\245\262\214\204\316\273\320\266\036^\371W\005\372[", 64 },
	{ "\025U\274\365\264D\325M\362\270\031\134\277y\240\201\017\367\011=\234B\206\216\275Z_:\310\022\034\226#\276\311z\356^\006m", 40, "\375\252kc`9\356\355\347\361w<iK\313\220\254\276\371L\272!.\212\214\342\177\346\376wm\223\024]K\340\256\204\2421", 800, "&\355\250\033\263\244\250\314\275Sk\021\306L\370\025b[\202\254\312\357\213}N\223\351[wL\327\207\035\362\354@u\345VG\250\271\364_\243\311\256x\372\234!wF\042\260\177{\214\242A\214\301\357U", 64 },
	{ "k\260/(;\016]&wH\037\213\042\300+VD\313\256l\3041\276\371\002Y\223\003\000\211\347?c'Hu\177u\033\350", 40, "\027\245\352\266M\245\221\263\035\270Z\275\014\210D\261\246\317p\271\331\364,U\235\337\007\201\021 ]\222\334\023\303\314m\321\342\020*\376\3037P$\265\224", 800, "\363\342\216\273\307z\253\373\247\247jh\273\305\007(A=\035X\327Bi-l\233\320\340\032}\312)\216\313\315\277a\224\357\237\216\274R\000p\347s\236\232Jm\345L\227B\022\237F\005*\037-s\344", 64 },
	{ "\206\334\365y\204xn\223\304\375\304\360\234[\226BS\134\364\3620e{}\306\230\030\134\374.\215H\347s\017\217[\327O\025", 40, "\356I\212\244\276\271}/\042rU\350YEiM\337\303 \220\230\230\360\223\352\246\025\256\365\007\002&\274/\342`\362Y1d\222D?\231\336\264\350\346\177Q\264\326\324\326\034\371", 800, "\250\307\350\317 \245\254\016\234%:d\323\367\351`\277\252\007_\224\264\344\374\371\253+r\204\343\311\337\024\326U\3339\351g\202\037\017\204\016\212\223 \337\212\250\033g\030\016e\323>v4~\324\024\324\242", 64 },
	{ "\2277\226\352\341\316T\3078\305\005\370\357\257\3065\270d\027\031\200I\245\016\243JC_\301\332\230p\323\345\274\252U\345\364\374", 40, "\321\257\023dE\264\202\246\274\342\024Y\307\377L~\244N\254\213\202\027\2641>\015\235\205\020\010/\333\275Z\350\030\305\006\3614\266\034\244\251\211X\241\217\212M\315\310K\252\374\351]f\267$X_\266\242", 800, "\303W\001v\301H\013*\303D\267\013\246\003\333Nr\213\363\214\023\231\300\334B\271\240\020A\214+\321\006\250\037\251p\230\373\020\262\333\255\210\251\031\013\206\366\000\246%\005\250\266\006I\274\257\337\031n\250D", 64 },
	{ "v\036\315v\000\305_\303\343^\006?L$\025\304Xr\014\203'\257y\2462\274p\251\351\221,\211\001\313\024\234ua2S", 40, "\004\222\311 d\350\256\035pO'\302\255\260%5\210j\277T6a%\251F\017\013\300|]e\360\317\0245\037B\216\276mMZo\247\340\021\017~\305\326\242=OJu]shHr\212Y\254\304Gl\236\332\2600\042\216", 800, "\323\004MM>\322@<\321\23672O#\360\030\234\335~\352\345;\016\301^\237\304\260T\274\304\010\247\356iT\207kU\207\134\353\235\251 \377\270M\303#\300\274m\3151k\2259\240\327t\275\371d", 64 },
	{ "\272\246\030\303\247i@\262\342\042sn<rR\310\330>\0006\222\247\366\013\002\205\034\363\246b\237\226\032\377\226\244r\243\377\362", 40, "1\324K\006\307I\330R", 900, "\215G|*\014\234\000^>$\313\363p\327\250QD\343\337\232D\042\256\331-\303LE\3602\0019\3137]\337\006\352\017\026 }Q\035\036\325\261\246\320\027+\357\007HP\200+\345\264\300\362\026\374\320", 64 },
	{ "P\255'\277m\2654\026\225\362y\206\002\311\313\032J\213\315.R\201\375\025rP\236\254\333\357*\221,Nk\025\004\014\005\271", 40, "\322\002\261\273*\303\310\2203\375\240s\317\027\206\265", 900, "\311{\342#h\025\214A0\351T\253.\361\350w\200\336\367\331\241\023\006\201\375U\264\376,AL\276\373\360y\266\243\017\253\252'\232\346#\207\223\254\023\002Q);r\223\271\025\322\035\336\266\001*}\314", 64 },
	{ "\375\021:w<-\363\227v\242\220s\343\37651\006\257x\331\004\213\363\336\266w9I\336\323QCN\216\354\215\306>[ ", 40, "Xm?\205\340\010\207\256\003#g\224\331\333XE\251\303\331Gr\025N\217", 900, "\316YO\221\237+`\004\0179 \317\322\220\374<\266rl\377\246\331T~3\235\304\014\023\335.'\273\034W\340\226\235\244 \033~J\222\021\240\014\327rD\007\235lR\022\321u\264~Yd\337\014\200", 64 },
	{ "\035\264\036.]6\335\000\277zG\326\304\363\236\012\215\227\334\226 \375\220\325g\312D^jv\014\011\001>\263\364\330\260\271U", 40, "+\134<\316[s\224\272\360\201\201\031#\233n\261\317\205v\363\230\262^\215\213b\2162\244r\322Q", 900, "\373fya$\300>\001=\340\335\240\200T\321(\317\310\227xM\241q\237\305\351\335\253r\027/s\277vc\212\232w\332\026W\362:\361=\302\377\350\317\227\365+\223\033g\337\347p\344\273\012\366\317\345", 64 },
	{ "\007Z\255E%IM\035\302\343\304d\276\354\312\042\211\015\266>|0Z\377\320m\303\254\334\231\206\266eFw\314\025\2734n", 40, "\354\272\341\373\202=\177\030\134A\224\256\246\217\336,\207\375\230\241D{\035\222q\275\220:o\240\321\375fP\303\375&Ak\205", 900, "7>\250Ar\323b\375\207\336\000\003\257\204\244\203\0137b\213\042\260\134<\372m\333*\3515\200\024\211\313\365y\345\276$\016\276\276\253\032Y\321\237x\367\000u\245\026s\015\014\326+\347\245j\251\221\236", 64 },
	{ "\234\012J\305\000\361\2322b\357\3757\252\2230^Y=\310\353|\002>\013\257eF\230\200s\275V\214X\222\272|_j\215", 40, "\266\305(\042U\226dza\035\006h@\035t\335L\247#\360IqL\260\307\347\2761~_\316\032U7\206\255_\222\205\301\207\324\325<\222y\373\335", 900, "\373q\021\255\334\2365\216.\366\206i\034\217\256\227\210\3675\314\274\3716G\032\360\030$S\270\313Y\314k\022y\2272M\033C\277\003\221\334:h\001x\306\302yx\221\217\016\277;\012N\261%\211\240", 64 },
	{ ">\346'MZ\252D.\350\326\241\240\2335cH\334\261f\371\224\236\032\375e\312b~\0165\324[\012\134\215=<O\243o", 40, "A?a4\221\216\211o`V15\375xM\205\306\134\367gH\331=\034\273o\3366Z\206\216\134&9\216\233i\003\275Q(\31463\033\356\3222\033X\033\245\177>\277$", 900, "\027@\215A\225!\233*\003m\364\006\373+L\031^\007-l\010\242\377\242Y6aa\235\313\265\260\262b4\325\305T4\203\011\315\320\336_>\004\342\264\353O\351\266O\226;\313U\214\353\362RI\277", 64 },
	{ "\223)\222Fg\257\022\2141\375\232Q\356\251\270A\021\237u\213C\010\371\243\250Z\233&\002\334-|\3267\340\026\354\276k\221", 40, "\243\370\024\263dz\312\234+\326\225\267g\254\317\205\346\350\303L\311\026\225\024\042\20679\266RG=\022\273\276\021\342\324\336\314\353\232M,M\334\025T\035\340\210\225\357\316)\374\265l\031\215\222\011\201K", 900, " \321\337\221\312.4*\351\042\242\026\134\221\002f#u\342\266\033\015\007\335\230\205\037E\016\324P\273\013q'\210\002\344AE6\206P\323N\221\260\362%\346\301t\246It\230RY\366\020\220\334K\017", 64 },
	{ "V\215\330\206\025D\027\363\346\134\010\376\201\305\275_\366\034\344i\231\017\236\007\006\330s\351\033\336\011g\325<mk\325#\215\232", 40, "\250\34170\264nk+\035\033L\023\210\015\344:\244\177\275T\356\371\367\377\241\315{G\021:\265\3209}!\2077\2657\322\331E5\0370\273\373dl\320\216\353\371\035\244\201\220\2469\206\231h\034j(j\002\340\232\230\273\017", 900, "X\2529\243\373P7\177\260\350\242\023/\373aE\036(\330\333mw\237\372\014I\200\251\345\341zI\031\207\262\025\315\217l\274u}\335\363\2123$\017\264\265[3\320\266\275\223\205,\345\036\134\305U~", 64 },
	{ "+\377\033\222\206,\265\206\231\274\207\004#\235\344m\025\352\362\332\210^\332B\226\212j[\023_\350y\363\012D\226\134\303\242\347", 40, "\012\325e>\037\3173\023", 1000, "\211\272(\272\325\230{{\033k\220\260\341\026\225m\365\201|\276)\374\355\255\221\223\352;\235M\001\010\006\023tE<\340?o\001\246\226\232\012\343\306\234\001Iq\371\373r9\021\032\016:i\277\351C[", 64 },
	{ "d\211\205{8\004\024\223f\011\313y\323\344\034\326\362\304X\320\241sG\235W\201\352\340u\215$\271\330\320\376\267\237 \324s", 40, "\310\034\021\375\023\330\206\027\323\1773D*N\003\317", 1000, "Pf\365\012\011i[?I\015%\343W\233\027\345\005\345\344\024\271\203\355\311fS\212\012\3022\021k\366\316\200[\250]\377.J\322u{\341\313`\323.i&*\037\327(\325\237\372\377\015)C\3507", 64 },
	{ "\263\011\250\275\025\371Z\0101]\350mf\343\257p(\232p\375\013\350\2748J\327\024W\310-Xo\033.I\213\263\307T\350", 40, "/|\3329\253\374\350\017{\246Y\213\340\232J\226\261|A6\2306\220\267", 1000, "r>\177\026\256\271\343\015\236\212\217l\216R\0140pA\371\321\027:<\005\270,%\364\263#\221\274\344{8(;cR\346\302,<\035jG\247B\242\213\301\310\334\025\257\026B5[\023U\235\231\021", 64 },
	{ "6P\203\023g\301\004\023\216)\306^h}\224-\020u\277\202\005\215\326q&\301\305-\001\313DU\343i8LJ\261%#", 40, "H\373x\252\220\007\246\251\353b\013S\223\314\364\017\305\326\341\347|\003\361\2411\215\363\2177\362}\333", 1000, "\035G\260X5\372\306\321\216\255\336\177\226.\2416j\302\315\220\270\2442\343(\236\017\376t\344\377\355!y\236L;\352\200\2603e\255$f\305\304\025\024\034\320+\000g>\371.)d&\201\225\211\001", 64 },
	{ "\275\267\241\311\255\003A\347la\224=\205\012\312\320\315nNQ`B:8E9\257z\261\210\251#\003\321\007\360b\210\352t", 40, "\326\364~\371\340\012\011\247\221\223\373H\221g16\321\317\335\271\264\263:\217\201\373Cy6\344bG\315J\376?@\353\341?", 1000, "\334g[\011\227?\316|\030~\233Q\030\326\237 \244\376\016\026C~E\032_\022S\214\317\331L\270\3726\030\306\333\344ce\006\016\371\254\251\254m\254\225\305\277\301\000\257\035\363\340\321\350\211\332\000\023\304", 64 },
	{ "\313\260\003\264?r\237\205$\220~n\016n\036\252\311\2724\241_\356}\362G\340K\373m\034\233\362\000\373\2329\204\253?q", 40, "\213\252\265?\016+v\221\020\234\261\012\254\305\200\326\027~a[\252^\024\350<\334\205\253%v\362\277Z\327\356\305/\253\215\010\261\221\276\224\306\355\237\033", 1000, "O\257}r\305\306\214\240p\023N\367u\336\275Q\340\011\005\377}\001\203\231}SE\221\303{\251\310\027\200\326\026\300\204p3\2726\212\224\355\237u\200\233\004\215dNd\243~\254\216\323\361\201\233\220\277", 64 },
	{ "\217\252\036 M-\337\272Pzu\215\221?!\253\134\220\3331\320\352\2520,\232z\372\304\3133X\320\270ba\042\363\222\335", 40, "\331E\026\277\027J\200\301MA\345>\306@*L~\347-X\242\361\035\042\251\230\177\334Q\235\330\371c\322\300\242*c\322\364>|\250[\326\350\022\241\216\303\243\221\267\206\253\225", 1000, "\312G{\134\201\277o\201EE`\260E=~dQ& \212|O!\2507\177\336\274\220\0060G\354\316\006\243o\254lC\231\371\002v\004\013\234\251;\361wZ\210(JFj[\210\360t\263\363t", 64 },
	{ "c\346\307Q\376\034zU\020%+\207\274\361.\222\231W\233\034\024\371\302\335\243\214\034\215\244\0076W\3629\367e\233\031Z\032", 40, "\042\006\220\030}-~\351a~\0349\354\270\336#c\301/\347X\014o\256\265>\357\004~\002\261q\215\012\042\025\370\260Q\236\324\262\356C\207\010\245\376*+\031P\320j\277.\234\231\377~+\003\022\356", 1000, "\233i\253\245\234\027Pe\201\215\321l\262\350\352\271\202\232\307\004\000Aaj\327W\265\372 \210\211 S;\037M\037/p\341\267\246\017\273R%\003\316\313\226\342\365\012\347\000\274\001\331\022z\313\2502\310", 64 },
	{ "'\241\373B\206`\215\306\266\042\273F\242\205\356L\323\370\370N^\332\331\312=|\015B%o\004\337\361\346`\372\001\325\314J", 40, "\273\037G\277\315+\250\305\332`Q}ou\247\2227\357\012\336\255\366\303\027\330\247N\262\212n\277\213\241o\0010\231Z\210+\312\277\021\246\010m\211\377\001\376\325\234\303\033W\3723\222\240\351&\215\005\214\220K\257\3311%g%", 1000, "\276\005n\341E@}\262\034\244t\311O&\246;9s\034a\342\211H\004\275d){G\013\374\207|\271\023\316\303\365\337DdUY\337V\0375_\320\221\337c\202Evx\024\032\266\221\274\213\031\025", 64 },
	{ "m\134\004\204\357\247%}5\327hN\356!\226\021\240\014\006\222\300\202\233H\366\245\235`\263Ua\000\220K\361\222\315\030\030V", 40, "Q\241\243\224|\243\305\211", 2000, "\320DN\260\222\254\336<\304\3538\324(\233\233\242\274S\372\224\216]\267\042\340\251\375S\213\335\217\243\3523\356c\325R\255\011\002\347\022\236fb4\242\363~n\301\226P\255\237P\030\362\324\252$\372\204", 64 },
	{ "\342\007S\226t\2532\237\254u\361MMY\246\177\214i\256\343M\246\362\204\355'\335#\264\276\315[\321\236!!G\134\273\217", 40, "\246 y\253.\353\205\022se\355\015\273\352iI", 2000, "\201\303L9\227\266\301\245\372\243\036\235\016@,\027\370\223a;\331>\271^9\342P(\003\344\227\265=\032\033\022\224\0165\337\002\375>A\316\203<\222mp\016\0243\3068/\353\367\306\270\306%\177H", 64 },
	{ "/\252\340\020\222?k\371?|p\371-\271\012O\002\255O\316\240&\303.\226U\204\347Zp\352\355!X\221\225\034\205\355\331", 40, "\241/\342\261\015ZAZM\217\316\374\357\212c\330+\203$\375\255\2075\341", 2000, "9\213W0\242u\022^\357\327Z[m\023\177\310\237\346J\340#(?4&\031y\310\005\34293\232o$?~\200\277O\255&=\360x\310\336\304\314Y5\214?2\313\034(\312\375\350\012=\334\263", 64 },
	{ "\2058\365\033v\273$a\001\305%}QW\037\376\212\377!\005Z\347\366\375\010\253t\032\240\012P\247TC\267\330Y\335\206z", 40, "N\027>D\017\2778\324\346\012\264?\222w\276\202\207#\367:\206.\0313E\363\330\275.\265x7", 2000, "\254L\354\232\275\274\246|\323\213\236X=9'\332\233uX\333deG\013\217\262y\223\314\007\350\331S\244\356m75\016\015\314\331\334i\350za\010*\360\373\206;\272\003\336|\007\226!L_C\252", 64 },
	{ "H\004\267\271\232\367\366y\362\342,\221$\037/82, \256\014`1\226\215\035\303%#p5\303\015\376\333\362\371\352\342\310", 40, "\022\3154\234\374[\232 \030HA~S\321\207\265\272\330z\236\356\212\360\236\323\215\373\231_\273Gk\220\256\331\264\005\230\267H", 2000, "<\360\033NOuN\014\207)\325@\302\0262\210\355!\367\033\302\253wN\372\370?|\217m\215\234\242e\243\004z\010:\330\032\315/y\326\213\267U1\362\242O5_=\264J\253\377\364\032\035W\375", 64 },
	{ "R\225J\021F\232\376(\260\300\0304y\230%\327\352%\352\204\211\013\362\265\375Jc\0326A\206\0357\042\005G\025\354\253\006", 40, "\232\212\252\221\374`\030(\227%{\023\327~$BM\376\226?\177T\3368\353\214\321\216b\367\353S\366\042\177\330;\341\230\353\214\363\235\324\005s\234E", 2000, "O\021\336_6\247)\246\005CX\031\302\346\241\035\365CQ\310\037\274\265\377\247\235\257&\254J\315\250'\210\356hl>\027\246\013)\350p\004\267'=\025\236;\220\002x'\035Ij0\373\265\013\357\023", 64 },
	{ "\374:\010\203(\0329\201D\346\246`\372\311\221\036C\256\030\024\335?\312\277\340l\344D\307\254\246\342+3;\312\301O\235\303", 40, "\237\233\317JL\336\027\026lj\264A\012)\005\225\210!b\267fn0\264e\2521Ko\235zd8]\031\213@\230T\3726\256\304\213K\211\231s\307\015\031!\237\020\233w", 2000, "S2\030\011\244\331Oq/{\000\330\177v-1X)\207\226}8\020\032H\310\000\215m\214;\011g\215\233\033\000\222\201\317c\237\2358T`:@\234\316\034\007A\337^\235\315lW\256A\214\237l", 64 },
	{ "\270\224\207\301\240\001`\311\327\371\211\2550\254>\220%k\025d\306xg\250\276\322\245;\326N\237\311\276-\372\321l\214\321D", 40, "l+#\215\304\301\264\331\303\363\021\304\237\366gT\333\340\240\302{\200\370\207\221\205F\243\375t\357w\303<\371GM\237\006\352Q\344lg\266q\020\223X\274\023>\302\007\371CI\240e1U&u\223", 2000, "\017\360_\264\037\250\221\031\134\274\315\265\177\377m\355\205\246\202{\016|\214OI/\327\205\270\017\220G\3402n\014\233\236i\017Z{\036b\356\340O\033~\037\362\306\253j\324I'\265L\211wO\000\237", 64 },
	{ "HU\270>(\233{\312\014\211\005\242\206\341\027\033\347\217KY\260\231\255\010\207\340\030s\037\340'\031\003\231\267W\031)\324\270", 40, "\304\232F#\277'\371\351GwI\343\233\374\2569\004Q\336\322z\305'\243n\270\023\377\330h\375\235\365F)\244yq\027\276\223'*\033\311\362h\221\322g\300\356+\241\300\365\301K_\231\363\005?[L\374\227\255j\216H\347", 2000, "\377)\253\322@\211\324\134CI\333\034>>m\374\270\207\375\025\372\367$2\235\337|\331t\251 \244\370\271F\012\341\250$\0221\210\276 \026\134\031\224\360k,8\034\262\013\360\225\260\352\031\240@\303\243", 64 },
	{ "v\014\202\367\330\015\0016v\220\351\311\003u\263\236\205\251\334\260\257\203\020\300\204\332\245\257-\350\3476\303\325\377t#<[%", 40, "\346x\031\351=\212\362\002", 3000, "\236f'\326l\345\210x9\310\206\304Qb\247\335\351\246\310\255\200\007\373\301\272{Z\360h7W\005\355e{n\312\226\203/\357}\332o\314\2270\026'\357\342\012\331\376\000E\337U\374&\256\367\252`", 64 },
	{ "tHN\335\351\026j\345\347\265\303js&\276\000\027`A\251\242\263\016 #\267\313\272\242\275\024\3430\333ah\276\342C.", 40, "\334\020y\342a\350!Y\332p\012a\247\217\223t", 3000, "\343ur\205\201\3444\263\011\373snRl\207\002\211\2332\260\302{\022\250t\210\250\030\177\277\304[\315}Fzi\333\210\303\234\010\337\244\216\360V\007*\305\243\327\371\007[\330J \027\257\1770:\001", 64 },
	{ "\020((\271~1\371\354\134\256\025\362\323\332\010\200\010i]3Fw\003\324\237\250\301\247p\311\240\342G\335\255\006s\265\351\373", 40, "y\365\011\223\001\346\262\360#\245\027\313\026i\213Q\372\031\005\017sr\242\221", 3000, "\042?\357Y\375x\355a\024\200\003Y\245\356A0\267k^\203 \224\232I\260\304UQp\355D\233\253\326T\353\271\022l\377\247\300\307\351c\177\233v\002\266\336>\035\2711\307WM\321\377\000\371\007D", 64 },
	{ "J\236\237\344\246\252\331\360~/\033\032kpw\321\235\036-}\233)\250Z\017\316W\3158\042\334(\216\227\373\324V\374QL", 40, "\216G\344\346]\013\356|g\005\363k\250\360\255E\225\263\327n\332\225\253\033\364\222.4#^-\355", 3000, "\324\224\245<*\230=\324Mf\352\224:\004\024\031\255qI\327\377'\327\223F\007\264v\037\367p7\301\366\253\225\266y\320\025=AZ\373\310\034\326n\311\272\270t%X\253\232\372\357X\270\205\201\376\036", 64 },
	{ "\350\312\011|2E\205K3\036eK\177\355\265M\344\001\255\277(\231\376CG\301'\237\346pN]&\177\273\000R\015\336\353", 40, "Ui\256\334\260\242}$\372\237U*\265\020\023\264\027\247\367T\234\351MN>\0126lLv\360\016\223j\343\220\034\325\374\365", 3000, "#\012 \354\261\226\226=\251\271l{\001\013\301\260\012W\247\020\366\204*\341\352R\371\353\010\036V\375\037\345o\244*,\000\262\013Y\375\311,\033@R\3140\037\264L\031\360\020\354A\210\213\022\201\336M", 64 },
	{ ",\347+3\364\305P\245\223\300<\323C=\213*S\373\0163>T\357\360\304[\202*P\004\004\224\33585\3249\332\032\253", 40, "Gs\271\225\331\274\026?XX\021\254<W\334\015p\261\224=\275\364\245\357\252\2220\042\230\265$\022k\315;\010h\316\027\234\211\316o\011\334`|\312", 3000, ">\205\205Mrn\341s_\217\006\000\134\375:\301\334!\341\322\202\262\002\332\365\257O1B\305\376]\016\021l2\225\277\025I\012U\321\363\221\002\206,y\210\224\217g>\0258\254\261M\340\3714\274\013", 64 },
	{ "\277\313O\320\373~\303\235\255\327\022\212&z\367\015r\270i\332A\222\320q\215\025\263\233\215\371Rc\337\012W\360t>\202\337", 40, "\005\271\372\326x{W\034\256\244\343\013\305\332\342\036R>\205'Im?z\350\014\006W\227\032\022\235S\352\025@O\036^\002\364\333G\373\242\201R\325\214\011W3\325$G\024", 3000, "\033\333ct\032Lr+\011C5\034>k5JL/l\003y$\225\022~3\347I\361fd\321\376\351\366\004'\365if\320\014\362\007\377\204\313\254\347\210]\033\331\025\005\243\255\271\037 \243\2633\254", 64 },
	{ "\022 \253~\327\267\303s\016\037\331T\333zT=\330}-1\364\022\343\360D\307\377<\232\364Z\001\205\360\236\030\376\2163\243", 40, "I\222\331\177\265\220\372\015\351\001\220\213'{\334\362G\365\252s\201&#\263\357&\366D\302\023k\360#\2510bJ\342e\306\220\005T#\323\365`\013aQ%j\223\275\335|\363\200\304]m\212\251\304", 3000, "#U.\217\271\211\346\352y\3342\365DQ\035\374r\207\331\356u\346\211\246\255\347s\011\252/\374'\357\002\227zv{y\211Rz\300\206\254U\225>\207b\011\222f\313\005\374\202\010\272\313\032\242'i", 64 },
	{ "\221\335\035[!\200\342\272\204\016\320H\250x\225\264Y\371rO]{\247I\316\020\314\376\256\267\331\302\311?\300[TGK\302", 40, "\214\217\316\227\270t6\374\010\211\320\217\213\220\023\004\305O\251m\306(\222\361\037\001r\3364\331\376u\203\344\273\342\266\224\201\215%\230=\235\341\331X\255\232\021\304\227\346V\340\331y\272\3321\216lKo\310\233\202\301\200Uk\355", 3000, "\222~6LF\263sIa\313\266\021\262\264 \250\012\2010\247\336\275\011zySN\270~\272\025N\025wT)%\206t\312@\253\352\033;Eby\270\231\025\207\362\363\356\3531\304\244*\364!\361s", 64 },
	{ ";\244\030\035\035\032\256BP)X\202\277\214|]c\002\361r\214\220\367\037hU\347V\241\314\012\250\250\321p \032\254\335\031", 40, "\377\311\272\264\0173\245+", 4000, "\317\333,\233.\220\351\334\236B\341\200\252\021\306\254\001\355u\307\262\022\275_\236h\035\322|\370\346n\004\303\205)\037)\321\253\267\221\236\2446\252\226\250\334\225s\2761\334\244=\323\376\240\364\237\037\206~", 64 },
	{ ".\362\232\346\221\3370e\363\2018S\366n\220\212CM\354K\015L\214\205\271\215\301J\003Q\240=f\001\240\036\027\363\245\210", 40, "\270$\3356\362\262.g\261\204\001\177tH\303\223", 4000, "\365S+K\204p\330\243\342\230\343\225\342\266\277\306\0113\001\027\214\326\2070r\334h\256\361$5O\033ze\336#\242\260W\321\311\211\020\262\342v~G-\223S\267\263\372J\305Kw\247\274\354\233Q", 64 },
	{ "\221^\330\236-6\207\017\240\250:\317\255\035\234\362o_\344:w\334\236i'JH\304V\320`\255;\363\011H^\207J8", 40, "\305OM\233\221\204\0010\314d-}Z\376pSi\022\323\313\023\370\346\024", 4000, "\315\312\356\271\366\301\134=4\222\013qYj\206\352|\015J\312C\206\327t\305D\225X\324f\337v``\035u|\317\206\342\000\367E\233]M\372\351\134\304A\245\271\206~\301\362p#F`|+\206", 64 },
	{ "RL\275F\026S\037q\0277\023\207\253\245s\301\363\002=m\307i\003\337\313\026\336x=\017A\212\343\206tGb\346,^", 40, "\262\215\200|\220`FH\353\321[\022\211\321\357\207\355\352\361LY\3416\032.pv$\202\200\311,", 4000, "\327\303\255\024\231\307\253\007\274%9\207\240SxB\223\037\367\203\246O\316\351\271\260<\312\223\305r\025\366(\214\276\334u\266\274\023}\343)Sr\332\206\224\333\375x\354\020D\243\013Z\374:\263d\355\230", 64 },
	{ "zoK\020E\344\266\327\350\326\301\042ay\277/\027;k\036\210\343[\377\014W\307\277H#%\023d\323\255\373\3728\355\334", 40, "\224{J\344\244\356]\345\376\235\2521|D\210u\376\0337\367\245\343\360\035w\342y\351\340\030]Ys\320\3052H\036\253j", 4000, "kX\307\311\033v\211\230i\303S\020\231\313\334e\251p\010QnHK\261)\001W`\275\261:\347\345N\232\346m^\042\336oI\216\342JB\245\347W\227\234K\264\330\376\373\003\301\277Z\007k\311\003", 64 },
	{ ";\346\033\200\372(h;\347\364\342\013\240\320J\254\311\313\326\332\207\020\012\276SlpS\221\206(\276*\012]2\264\357\353\333", 40, "#\233j\343\021\317\331\033\241\204O\326\207\375!\221\247<\271\237p\343R\253\017&\327\356\221[\255i\251.g\212Q\014\320\276~\244\005\3155k\251\010", 4000, "\276\001\247\265\317\006\331\235\337\310\301\212m\344\013v:K\337\134\360t\024\012\244\023\311u[C\303\324\033\351E\015]\234\363\351>}D7gL\324\364\244\306f\267\235\377\231z(I\214g\346\240\3447", 64 },
	{ "}\251_'\352\042\262{u\213e\353\301&,\023\227\327\006\206\356\215\016\233\255B\015\033\211l\015\360\237\322\225\013zx|t", 40, "F'm\243\321/\261\3521 \366\342n\017\322k\333Q\026\010o\306\004x\254a,C\364\201\027\231\232\215\353\003ZS\227$Xk%\313\201tX\327\216|\275\242\313s\320d", 4000, "\217g3\243_\275\301\025G\345\354\363\253\220/\024lL/\351p\337\302&\263\011\300&\23191\345uu\345\301\230\337\362\042\360\352rZ>\312M:\355]`\360\273\205\223D \002\042\221\003\306tH", 64 },
	{ "\245HR\177'\360\330\340\032[\203\254Z(,\272G\360\223\201\306\364\234'\010u\217\013\273\227\026\037\251\221\007\246 )[\235", 40, "\371\255\347\205\201U;\255\350_(\222q\235\261p\376\325\326&\203\042\224\3215Jy\352:\205\362\211f@l\221\015E\002P\207\252\200\233B\207\3329\202\042\256\001_\334h\023\001\003\374\216\237\353qJ", 4000, "\311\262\026\036\313\3243&UG\006\336\224\261\001\353\210\355\032\2372W\316Sw{\254\267\315\234\263\024\365\256\220\021\220A\231F\001A1\347\255q\224\305\220'[0\315Q\240a\221\236*\221\034\376i\313", 64 },
	{ "j \331\356\021\266\302\373\305\037\234\305y\013\367\372i\222\236#\253E\221\215\222\022\223\007\203\134\207a\300\321\017\346\222?=v", 40, "\336\220\315rU\233\013\342D\314f\016\037\230\372\007'\003\361\037\234Q\221pf\356\017\203\010\264\321\370\211\360\251V\353\236\232l\220@\004\027\334b\366\265\006p\225JW\236\227\251fiN\232\233\200o\234|\274\015\265\317\001\200\012", 4000, "~M\276\371\346\345\324\242\202\212\337\025\277\227\024+\037\371P\263U\015\016\007\362\177T\370Y\346w\025h1I\307F\364\303<\023F\014\350\221\215H\276\353\206J\244kT\031r\330\246\016hj\250x/", 64 },
	{ "\302E\227\301\254y7\247\337\332\015I\243\021\025-\320\361\315\262\377\327Q\277\367Y\203=\011\366u\362\006Ci\374\323\203B\236", 40, "\003V\223D\273\375{V", 5000, "\231\305\276)\251'^7\336\227\212\234\230\350\034\353\304=\215\033\230~\340,\261\351\317\246I.\212\023\217?_\225\012z\002\356\201v\215rA_6o\214/\264\347\006W:\006v\030\212=o\327\226+", 64 },
	{ "4\314(\203E\260'\215c\345\331\341\017V\311\346\006;\013e\312\022\215\021D]Y\251D\227\027\366c_\276V\022\037\340\264", 40, "\2103\375Ru\276NAI\345\254\036/\252w2", 5000, "\214\345$\014\000\333\027\204>\326p\320-\020En\034\371+\207\023\327<\314\266\312\277\010\353H\2049\037J3\220\247\3302=\032'\205-}\005BB\372\355\371X\365\325}A\025&!.\311\252|\236", 64 },
	{ "_[\347\031\345\200`\000t\302\207\327=\366\270/\322\350;\007\221\207A\027\256\250\364\313\355\370T\240\317Xb\224\363e\313b", 40, "\337\303I\267n\336+\240\134\243_\351\3100\317ZF\016\302m\263\220\302_", 5000, "\213\263Za\221\346\370\303+R\024\335\214C\222\372\332u\313\252#\347\353\006\332 \010\324\034\276\310\321\2165\2403\016\342\306\322\026Y\134~&g\367[\346\021t\221X\035\223\317t\270j\212\211\334\003Q", 64 },
	{ "\361m\332Y\307\254=\374\376\312Km\012\013\312\012\206\210B\313j\227:\323&\233>\240\314\211\353\226%\322\035 +\346\305\302", 40, "\211\014jR\233\265\360\224\042\274\034\326y\311\310\200\016\376\356\301\216\205\353+6V\302q\276\247\253\240", 5000, "\201\205\336\014]\323\211\027\312]\276\307\034f\002g\035\310\214)\310d=\376\334\221\252\271L\014\307\202\373\357\226i\0365\210H\0201\260\227\277\2070\222\354\230\277\265\341\251\037\030?\270L\300I\342\030k", 64 },
	{ "\302\265\353\372,\300O\312\032\035\205\376^\333?\330\362ZW\004\004\030\264\036J\255\341^b^\024\177\035_\0129\230\335\206o", 40, "\347/\326gV\324l\210\233\301\013\375\3151\314T%\271J\374\327\331\177!\035\312m:\376\247-\271k$JE\262\243}f", 5000, "\042bQM\317\245\256\010YW\336e_\023\354\372\206v=Y_\033!R\342\2103\331\374\204\034\016k\324H\374o\332\032*\012\014\031d\255k\324\300VI\351\244I\230\027\025\357G\206\300\000\222Mk", 64 },
	{ "u\263\272CY\021`n\345\307\203\030\012\357T)\377\317\357f\025\361\015\337QM\253\215\367\022\217_\275a\244=/\205\360)", 40, "0M\352w 0\255\033\242penz\365\252O\327\002e\241\263_\015%xG\333g\344}\340\243v|\377\240e\011\354\203\316\352\377T\2143-\370", 5000, "49\310^\216\307t%\355\337\227\301\342\365\302\225MG\223\201-e\203\370Q\376\205w]\264\250)\010\002\367\213\303\256\363\265z\364)\201\276f\006\002\366\2458})4F\250\364\233m)\207 R9", 64 },
	{ "6\353u\336\003\275APas\275*\356\210\325\270\274Z\303`N\022\261m\250\235\247\205\344\033\003\343\322o\000;\335R\023\273", 40, "N&{\2130%\355\335\335H\033\2166L\222\371o\374\246\012\033\256\301\235\271\314\345\206V\267?\013~\030\032)k(5\362\267\377#\276xRs\377\205\322\006!\225z\314~", 5000, "\256\213v\006\364ft\342-\254t#\024\244\020\015xM\036\337}\036\267\313C#*N\210\207d\351NG\037s\250\336\257v'\333F\253\244\242\207?\227\317h\337\025\344\2602.G\325:\214\337\373\202", 64 },
	{ "\261q\320\011;tg\211\011\333\365\306pUw\272\271\276Tm4\370\373FXt\201\262\031\270\3704\177\0214J0\234\235\324", 40, "\316\264\004\246\371=\031\371*xZ\010\256\245*\355\022\012\260\231h\026z\214\363\277\372\250\302X>\016`\336\345\007\304/ >\234\217\330[\362Z]\343\275e\341\257t\316\232\235 \320\273\004f\261$5", 5000, "?*\034kY\205\002\241\226\003-\242e\003$\020?\345\005\311y\237>1\241\3324s\363\230\356:\206n\042\257\326\366\276n/\177\360\217\322z\335\016\203\353\356\037\213+iH\374\350\371\346y{\177\304", 64 },
	{ "\027\252\311\265\024\350\347@\042Uh\245\021_\024;\241\265\2175\345hmj\365\325\300\362\000o\205u;x{cX\313\004\351", 40, "?\177\260\340\0031\020n\352t\261\032\361g\275\207`o\246\031\226\020\361$\352)oN\334\330,_S\2148\005E8\016\263\354i\243\322`\032\024w\307\225\011\275^i\312\032Y-,;\333c\375aX\002\214\327w\374\253\240", 5000, "\252\310U\245\245\134N\247\374z\317DEN;+\342h\231n\000h\015\032S;\333\245\244\201\340-\235\015\332\015\277\253\377\200\271\203\223p\204\252\341\264<\231\134\300\224c/\366u\253f9\337j\200\224", 64 },
	{ "\001\257f\007F!\225t\202w\366\277\211\232 \202\246n\204\200pgdp7\365\033#\221\341\023\310\230\216\013\245#\201\365\274", 40, "\372\277\012\266\031\334\375\215", 6000, "\273HFL\315W\015\217\2275\377\356*\225\2074\351p\227\035\365\271\016\312=\373\220\251be\344\345\223\363\261\035e\330\2327\377z\226\355\015\242\314V\326\331Skm\311\323\252Y\3536?.\334\013(", 64 },
	{ "\200\313\010\003\253\353HE\362\346\303J\205\346\232R\2477C\217\312&\023\244{\324A\310\2625\260\370\303o\353\360\262\267\236y", 40, "('z_\337\037M9\2131\036\204r[i1", 6000, "7\134(\341\220\2024\317Zm7\323Jg\267\274\376x7\377\253\016\254\366\213\363\24001\236\245'dr(\303\311#\015\335\223\273\342\323\353;\372\342\252\026\372\023tW\241\240\364\357\306!\3761\201\010", 64 },
	{ "d\345L\034\356D\017-\277,\007n:5\226\014\227\210jN\000e\020\307C?K\267\323\010\011\257\347\277\350\032^\017\227]", 40, "\3435\273ab+KN\264O\201\211\242\325\251\233\311Hi\363\007=U\026", 6000, "\016u\265\242\011RP\313\341\316\345\370\303\365\327+\225\205\352\312\221g\001/\266\027\312\333!\247\361z\277\336\303\000A1\3715\341\262\374\224y{\223\013+'UB\242u\003R\217\311\316\042N\231\265\033", 64 },
	{ "K\264\033\201\243)o'2\253\305C\007\355O\353r\310h\321\256zd>.\221\0330\244j\3349\015\240\225\317\347\344\260\220", 40, "/T!4a/\015v\243}\342\211f\274p\314q\267M\2352v\251\236r\015\327u\211\343\212w", 6000, "\037\211\024g\307|V\037\007O4\006\262\227\335\3174\306\011\015\230\277\022\207\374x\014\234\234_V\026.\352\232\231h,\236\205\035\333\271\227\335]\373\020\320\262\263\216\372\243_lA\244IEK\251}\272", 64 },
	{ "\003\006I\015\227\203\320\264\024k\261\002\261k\375`\001\247\333\260\307\364\351\217\3228\377\342)\243\213\3446\351\266)\355\232\353\271", 40, "\245\033r\214\247\344II\366\256@\036\015\015{\260[\270\227\253\254\350\265\355\024\247&g~E\301\015\027\006D\346`\243\317=", 6000, "J\334\343\350\306\134w\367\333\377\220\004\201\025b\236\245J-\005\370\004\235[:\3718\222G8\027\036\215R\021\317\012\013\321MF+R_\341\004\206#\230\134\346\025\353=\026\200\216\256\203\342@\344\251\244", 64 },
	{ "*\266\352zh\265\215\235\307~\357~&\262\354\232I\235\376\233;\3240\273r\243#^\003\354\0300\267\325\035bB\346\355\274", 40, "\270\274{\245'\246\304\0049\366\304\300\227^\302\024-\2140\261\236\323\273%:O\022\013\250I\354\275\223\372\037\270\177\301\304f4\2508\252\247\005pb", 6000, "\2323\251\356eT\177\244\020\004\264\251\320\327\0007:\037\322\227b\253Z\010z\305\204Z*\303(-v2W\266u\001\256\373\352~\017\215>\316\340&\333\331\206\030W\366\336D\3000\235Ma\270\031\003", 64 },
	{ "\257\247u\250\333z\015\007\221\013\031nz\017\272\216C4I$\361h\310N\324\260D\223|\213\252\237l\007\300\361\2308\033\265", 40, "\300\351\273P\263c\222\222=\356r\337%\037a \226\002\355\330A\207\033\306z\214I\374qc\342\347\251Cp\237\204\322\253\214\010\221\361\324\351\314\030\0330\266\202\002=A\320D", 6000, "A\371[p\255$\364]A\313\177\322\346\354\270\250h\364\347m0 [*\376\213%\211\025L\263!\224\307ZR\263&\202\324n!\223\3475\374:s\2036\225'\347\356\025N\207\375\337r\011b\037\274", 64 },
	{ "\251(R\225\234\026\3011t)IIC\345\235a\345\203\270\201\226\235\000y\024\356\240D\325f\210\200#\332\333\277\266p`\254", 40, "\375\010\333?yf\325\367e\202l70+\257\312\3228CX\2546\235q\203\245\134bk\316/\202O\0152\320D\002\3327\037\013\007>\222\247\351\334\2152\316\310H\304\251\200h\230\360\277Bh#D", 6000, "\030s0\2213\201\230\035\216*s\037\014}d\272{\006\372\177\237\036&\246Ylz\255\345\373s\042\333\034\005\244\235M%_[\026^\361\217\3119[\030\004\311e\205\316\003@\010\322I\017A%\246\370", 64 },
	{ "\012'`d\013B\231\266\374\302\004\336\016\202\214\333\0120\246?\302\270a\242\003\334\343\022\341\241\352q/\273\323;z\012\355\306", 40, ")mKR[\252\253\024\321\034\236\033\306\243\360\320\331\300\261\346W\361_\263\226\310\013\346\010:\037\200\333\3300\313\255g\223l\177<\306&#7S\216\325\346\335\027\244s ~#\256\224#\011\214\342G\350\015\021\315\307\335\214\027", 6000, "\023\220\224\005&\237LK\2207\363\221\020\037dL,\0230(\230\017x\375*\272\344\031\351\247\012|g\364\342\022\220\2566\221H\020\200\350\211\011I2\341\3277\3609\250\3164\332\377\370\241\227'\243\340", 64 },
	{ "\262\362R(~\026\210J(H\232\034\237\314\321\227\376\272\252\242\226\002<Eo\245[\272\201s\312IKt\341\362\277j\372?", 40, "\253FT\2072\260\012\021", 7000, "\361\330\260\377\214\211\335\310\2328\330?_/\030=\365ec\213>7uC\035\042\242R\377Pl\016\220T\242H\030i\320\215$\254`f\333>\024(\322\364H!\0008NK\000quQ>\027\363\013", 64 },
	{ "\230,\310\226\255\024)\207\357`x\314\210l\252\361CC\240|\363t\322X'8Xbz\231\245d\000\003\025]\260;\350\245", 40, "\255\007Y\022Gk\265r\304]\207W\352\027TC", 7000, "\355\353\317\011\342\342f\336v\370\313[a\363\352\234?\371\234\254*\017%=\032}\257\375<\355\000\232q\305I%\327\017\300\032\253md\250\037\032\306\241\320t\211+\231\364\247\375\314[\204'j\322\272\022", 64 },
	{ "B ko\350vU=\244~\353q\233\037@\022\215\273J\313\235\376\001\241\237\341\330\000\310\371J#)\335\262\245\000\207\325\023", 40, "\320\265\271\302]5\246-:J\0011Q\355#\373\271]\236;:l.\244", 7000, "HS\236-\206\233bC-0\327\311'=\206\014-\343gW\021\232P\246L\020:C\226\252(,\134M\240FIa[\260\277\225\015\275\376\000\273X\213\033p\241\371b\212\356\272\316\253\204LuK=", 64 },
	{ "\210\323\042\001Y\3122\230\004\020\236g\001\016)\260\323.\204Xj2\360\320\343\357aW\214n1`:\277\352\264\376\356\367\227", 40, "X\014\020\274\005N\342\004\211j5=\2640\262B[?U9\334\020\277\341\255\234:mzGD\270", 7000, "\035$\354\365k%\310\367W\3049\001f(\207s\242\376\026\361v&\226\042\361\247\201x\322\212\233$\210\227\214\250I\346\236p\370lp\012a\215\351\217\304:\326(1\013\017\257\243\352!d\261j#'", 64 },
	{ "~@<\225p\276\020\313]\245\331^8\017\204>\310\231E)\346\006_\362\236\331\253}x6\316O\237\271\216\000\253\304\371E", 40, "BD\027\320\345\300\267\013H\342\332\216.\227\247G \212\367\207\017i\365\257\212\317\333\351\217<\361b\010Xy|l\037\216^", 7000, ";t\042r\011\377\204\033\036\235%.\271~\235q\355F\264\215\236\250w\022#\255u1\252M\376\267z\337\004\236\346\203.sqh\223\025\002\033BE\204h\317\317x\026K\332;\372\357G\203\362\346\275", 64 },
	{ "\027\231\333\257\306\3570\325\033\266\036\204\206#\030\006nT \255\356\277B\331\201\340A{\212ttQ\177y\374\353\254\025\274`", 40, "\321\005\246\023\042\306\027\177Hv\351W\025\0158\315s'\022KX\036~\367<P\203)d\365\013)Z|\317\321\214h\310\274\005`\345\022\304\262R\372", 7000, "\201nK\001\254\2440\024\271I8\334\331W\224dI\042\207\241c8\326 b\202Uk\353i\300do\205\246bF&\316B\375\341\227P\250\372\324\016h\361_\0304i\271a\231a\366n\000\235\245\217", 64 },
	{ "\366\322\352PF\300b\247:\201\300\264\312b\320\271Dv\240pz\372\2741\236\364\006z\247\012|\004F\357\267O\261\370\3171", 40, "R\207Q\367X)\022\370\037\245\233}\307\007\3326H\322Z\216\333K\373\334\366\220\362\356}\263\002;\302\346\326\331\245!\315S\252\263j\343\323\331\3619\134\3739\017\317/\241^", 7000, "\371K'\333\224E\026\035\020\033@\315\214\02337\2348\03679\355J\247U\005\033\315\026\201R\333X|uM\0343T\257\277\276\215*\247\002\245\372\264jh\030\307M\037\351\355M\226\017\2357\364~", 64 },
	{ "l\272/po\312\302\256\357x\350\335\260T)\224\274@$\263\331\361\275^x\015\256{\007Bf\265+a\257\314\222\261_\313", 40, "H\314\240>/4\247\223\377^z\324_Q\233\206\023\355H\265l0RkB^\241\207\250\366\240\320\340@\376\362\270;\267#\363\277q=%\365I\261\310\3268\201\324x\257\350c\250\256\311\355\2006\366", 7000, "\350\312+\222.\134\265\366+j\362t\042\317\014\307\2450\236\361/\207\324\362\222\360\262Q,I\254s\370\277w\346\203\261s\302\376\300\030\321\224\327\003\371U\016.$\274\256\362\004\016\312A\236O\242i\235", 64 },
	{ "\035\376\031\3777\014\372b\372\316\207\314\334\245\242\374\022\233v\226\227A\303B\245\367\006U\032R\006\032\357\205\345\275Xe\344\001", 40, "v\277\337qw\301\203B\207\372N_\216\332\311p\0101\134\035O\232b\314\331\362z\036\005\327\205R\261\024&dSW\255\252\370\315UY\2716\335-DH\260\222\3627\371o\217\313\236\323\365H\310@\226\032\031\256\347lN\302", 7000, "iz\243\257\217P\205\341\3410t\250\341\244k\351\022\334\311\347I\221\216\244h\352\242y\355\253\374y\323\237g3\235J\232D}\333\310\217p\220\231\304U\026Kf\350\013\365\251\042\275\334\306e9\234e", 64 },
	{ "so|\334\340\356\262\312\334\317@GX{l\234\03104Tw!'\332\237a\270\271\0246\333\31447M)3?\036\357", 40, "\357\2626\371\375L\006Q", 8000, "[\347\034s\255S\2004\012\233*\013c_\343\277\213p\314r\274@\373\230\252):;+\007\232D\276\3402\372\300\330\3713\307\227\303H`\376c<<\306\252\251\0241]u\256u\272U\332@l\330", 64 },
	{ "\222y\345\357\037\366\020t\321\270\236H\262\273]\244@\253o\365\224\376,tN\245?^\216\034{\361\240`\022\001Q\354\362\357", 40, "\356\310w\353\307t\362\346'\204\202.\277\207\310\341", 8000, "\350\247\235\274\265\301\315\232Fj\366\3460\255\225*C\203G\033\320]\311j\273\264B\276\202\370\274&O\303\374\327$\373\023%7kX\0061\212\274\252\3371\332\213\232\313Cn\353\364U\326\215\352\347*", 64 },
	{ "I\221@)\032\264\220^\211\253\025\222\202\236z\335\177\333\225\247\134\321\377\217\321\224\024Ve\304\364\302G3(3Y\266\221\020", 40, "%\242\270\266\326\262\215|\351\353\370B\336\312g\222\343\227\366z\341\036\207=", 8000, "\234D\201\323^\351\320\034\2358\026\360\032fU\357\030\234P\354\247/N\250J\355\011&;\277\134Z\024\343o\262\270\206m\253\254\366\375:<r\020\314\277\277\302\262cQ\202\3358\311D\253\365\342,6", 64 },
	{ "\346\273\005\267\036\367\210\203EO\307\327\260\221\314W\202A\307\042p\230\322\030\025/\235\270k\212\203\245&bl\232\326\274\353y", 40, "\204\002BA5L\033g\373\203\354c\134sb\350\004\264\267\034T\034.\306\005\353\032p\357$A'", 8000, "E\312\203\323\236\305,\225\377\343s^\354\025\325\241~\035\230q\316`C\200\371{\361\240E_\270\206T\231\323\202YXHA\377G\251\230\343\012d\007F\035\230U\014\025&NIa\241\376\005C0%", 64 },
	{ "\373\256X\365\013-\301\314y\357x\002\354\235\366\272n\021d\325\341\026y\346\271*\020\317-\371\337\301\034L\305r\024v\270\331", 40, "\202P\205\367\346\016C\300&\257\346U\357'\274Y\213\310\321Jp\275\242\335W\2311\260\200\233\243v\357T\313\030\355\224\250\261", 8000, "\256q\200&n\301\330\300\200\3450\2610\0228\313\027\363\334\344\317\252\314V9x\232\356/j\034\000\305\236\366\306\307d#\253\240}\023GC\032n\211\277)\242l\022\026g\246\276Jp<\201\323\312\310", 64 },
	{ "\262\211\011\232\006h\205;M\216\327\373\207\327\363\226\342J\264g\256\236\300\014\025\370;\331\222\364\275\272\373\343/\242\264\303\264y", 40, "\016G\014\037\307$v)\231\306\230\231r\213*Q\227<*\351\177\134\334q\321:\351m/\024\241\365*\213\254=7\006:\230\3223\325\326\216\364OY", 8000, "\0362 \353t\315\311\345\034&\016O\365`\026\037s\257\323\345\333\366\352\257M\250,\036\343\017'\323R=\204\021)\240\022sG~\263\335t|\035I@\270xf\003\356\023\340\024\311\211\205s\231\202\024", 64 },
	{ "\227x\225\261F\374\302\015\3003\374\331^a\216^\256\265\235\211pgp*\027gk\360\366\350\326$6\365zv\341\373\377\222", 40, "m\303\220\336\354\350\224\231\023?\036\003K\337\255\265A(}\042OL\255\2240\036a\362\263K[\227m\005\346\232,\330+k\244e\251\134\267ys\271o`\316\211H\011J\352", 8000, "\347'\275\025\366\230\006\302@\225\011\011V\330\035\321\212u\361\356\335;\337\300c\2342\267_:v\005t\325C\343\242\251\271,\315'\312\361\200b\271\352a\370=\001\303\251f\371\016\030x1z\216O&", 64 },
	{ "\213\253\240\373\200\317\021}\006\021)\366\0036\301+\004:btw\240\307\214q\256T\341:\241TS\025\026\343\027_\033J\015", 40, "\214\302^\251(i\006\315\207\265E\011\033+\224K]\013\303F\307\252u\303\015buJ\250\177R\215\034\353\021\334\216\004\332\266\353s\321\334\327\237\200\022}\033\324\215C\222\263\134f\334\253\274\254\306\027\241", 8000, "\363\346tc#\372H\351\342\372\202Q\005\031\372#\260\274p\354Q\206\210\372m\360s\257\223\363@l\337\201\244\371\255\220\017n\262\253kV\315@\324\240\267\301\250\2674\036\334\352'\372\311\211/\340\325<", 64 },
	{ "~\320\005c\367`g+om\315GD\257LX\006L\025\342mD\304\353\333\273*w\207\002\010>\265$\034\321\200\011\261\347", 40, "x\373\357\225\035v\364\3700:\356eB\206\206\266\037L\356ip\301@eI\027\371\253X]]\326$\245D\357\322\007G\214\347\374\350~@h2o\021\001\251\247\224\030\250;}a8\256\247\005$\206\242.\212\261 ^\341\004", 8000, "pQ\266K\355\240CT\242N\326\002\026\241\300w\220\240\026NkK6\201\010N@\177\315\324\276\214\210\333\200\240:iX\216\206\252yy\322\333\330\317_+\235\273\317g\220\134 \203\302D\254$\360N", 64 },
	{ "\207\356hc\332\311\262\221\017!\224L`\234\322g\242;\311\030t\240\371\247\304_\367\262\204xz=\306\351\367\007\3268\002\022", 40, "\024\231\371\007*\236k\272", 9000, "\232\035\200\0108\362\327\310\016\210h\244bi\365}v\342\243\034=\366\313\310Is\364\332\360\216\247\231g\352\322\364~R\360v\370\225\225{\034\007\325\305\231\025%\327O\231\272\3101\011\341\356\357\322\204\243", 64 },
	{ "\347\232\037t\232\325\134\270\246\231:\000\216\341\364\327\243\233\336\374\233\254:f\234;\261\023T\211^\023\274e\277\331\224\254\361\022", 40, "\231\374k\017\264\022Z\310E\224\373\215G0\323l", 9000, "\242]\315\226Pn@\346\220\257~\134\340\031\325w\0057P\354Z\227\213\004w\255\215\244\305&\020\324\220`NY\262\227B\261\357\337\347\035\35701,jH\237\031\0423\262\321\344W\307\242\042\204\370?", 64 },
	{ "\351\222\0071B\005V\022\340\224\323\035\331ry\303\333\214g\374WJ\346\310N\034\027\371H\021K\261b|\212\221k!\227\374", 40, "\235\3570\3671\254\004\034^:g3\274\230\042\314F\310\274\355\226\001\253\315", 9000, "#\335\027Q\374\272[\264x\366?\330\347\372N\366b\336\306[<5\314J\333%\223\321\016\266\333x\251\036W\266\336v\212\332\333\3400\006\302 \334\370{h\015n\374Q\276\026M\244P\026\253\352`\206", 64 },
	{ "A9\335N\304O\264hp\360\036V\277c{\356\037$S\331\272\246\023#\254\341\345\252\372{\213q\005a\022\202 \336G\032", 40, "r\333\017\004\376\276\347\351F\362\241\221\026\211HC\374\032\022\004\0101dU\326(\343*y\2774\370", 9000, "cux \267k\007\254\005\211\304\235G\336\200\207\003tZ\010 WP<\360\3709\037\367\233\377\222\360\210\325Q\351\002/\325\134\234O\275~\363\355:_\267\006\316\362n\012\225\265\210i\2451\355\327Q", 64 },
	{ "~\327n\210\367Y\1346o\001\235@\031\265\026\331\247;\262v\347,=\310\212}d\327A+V\372\246\011\034F\307r\021\236", 40, "=\232\244p\320Q\003B\224,\020}\340\267\270o\2408\321\256\261\360\332\211\346qM\345\276\004lS\270\010\336|\274\215\224\257", 9000, "\255\314\336\220vu\346\367\321\212W5\010+J\134\275\310\202\350\334\214\252,f\205t\2525\252\344\344\023\277G`<\353=1h\257\326U\025SY\027\352 x\340\026\272\363[\016{B\364T\347\337\025", 64 },
	{ "&\007\346\021Eya_^(\217&\372\222\020X\246\367Q\015o,y\240\273\357\352\345\321\005\264p\031\034}e\244\274\003\247", 40, "\341E\304{\336\344\364w\231.Q)\334c\3024\305V\375jvam\004:\235\312\305t{T\205w\313\374\021\345\251\023l\264\036\325u\375\352\3710", 9000, "M\2779\257\330,\023S\354jg\345M\306tTW\036)\015%{\313\032\005\261_\377\370w\220\360N\266\366H\222U;\032`\031\261xzOS\356~\327\232\030\017\321!\334.\216\271\203\205\246\304]", 64 },
	{ "\214e\042X\244P>-7\351\310\252\242\311\223\032PFX\215,\333\313\036N\0322\322\325\3340\366\242\226\366K\345y~\306", 40, "\134\307Ui \271\307\301p\225)\267\024\373\303\363v\214\002\017\270#\300\321\024e\025\371\025\305Y\252w;;\327\357\337\351\2130\244,\252\005\316D2\375\261\034^\367Ar\002", 9000, "_\227\217\237;:(\330\254\277(\202\301\303W>\346\372x\012#8\272\244G\371\134\214S\301\252\010\241\315\313\362\027\035\203\023zUV%\347\337\354,\225\375\345\275e]U\234.\007\023-\320o\272X", 64 },
	{ "\254|F\033\270\264\331\247\266.9\233\013\212\036\3258H\203}\237\003\267O\325\317\336\375XC\220\362n\241d0\256\012E%", 40, "\340$\356g^;\224Y\340\2251\367\212\235\134\264\216\316\023\316;s\3010\272\340\242\313\244\206\310\354J\305\264\021\334\265\216g\331\304E\212r\010\341\224D\252d0\333F\246\212)\220\313\007W\2412\323", 9000, "\207w8\211 T\261\360\276u.\263)\252\303\233\270\317p\352\213G;\021-\025\2572C\250U\260\031\263\025?\343\216bs\042'\341[\007\242\337\342\022\374\207\237L\266\005\3305\305\366\335\231SDx", 64 },
	{ "\212\341\3665{\373\267\340\360b/\234\313\327\235N\242%\334\246\274\216\024\350\304\134\271\321\0316P\013$\332\370\346\010r\351\326", 40, "\372\263P1\315\027\012\301u)\234\334\365\211\333\310g\303\203\240a\312_\276\2755\333\324r\275l\014\2311\356,\017\272\010t\033\354$\010\347`\321\235A\221\311\205\327\276\310\257\305h\262\245\315\204\366\334\013\313\363\027\303\216\202\015", 9000, "\257\316\015\202\024\245\365\303#%\303\351L\327\332L^\317j\370\250\261\337\177\277\276\321\302\246i\275\270\324\311\224\264\252\024\346\262Q9^\001\205\223l\250\343\007+\372\344w\270\350\372\350\326K\015v\346\014", 64 },
	{ "\031tE\340P\214\336\351\311:\226@\254\206?MP\247\224d\271\251\266y_\036\371_\134\275\227\333\311\235Sb\307;\272\024\303\302\373\007M\3414\037", 48, "\021\201\255\007\253>\337z", 100, "\177?Y\235<\025\237c-q\203\035K\253_\276bE\236?L\220\016\237d\317W\376\337C}|\370d\000\004\304\331sJ\264\251\345\322\011\033\352k\341\272\323-\003\313ss\020F\201\021Yy\274\370", 64 },
	{ "\361\225EV\034Lo\324\302\177\265\004\352\340\300\271K\372\263'b=\021\014<\244\035I\231\276\270\273o#\334P\227\317\364\026W\316\267\033\030L;\331", 48, "\347\276C\014\313y\201\013\217\230|\315\356=\256\213", 100, "\373\302\027\231[\013&'\375J2)\3601\356\260\356\226\377q?9\342\027\023\255\346\2219\302\301\256k\004\224\005\361\027\301d\255\322g\375\177\033\302\226V\232Iu\300\000W\364\010'd\033'\002\271\243", 64 },
	{ "\232)\225y\274\233\203\256O[*\212\311\217Cr\005\332\031]I\212H\327\370e\203k;\340G\263>\321x\214s\350\262{\276\042f\370n-\325c", 48, "\317\277C\314B3!\207\217\214Y4m#\202\036\011\264\206\310L,}\225", 100, "U\263q5\313\207\331.v\021z\020I\204g\322\255+\326<\304@d\256d\020\203\205\342m\237!\337\005\261\353\302\216\215)\334\235-t\203\303\324P\3069d\314\253\301u\223\223\303\224yA\325\311\206", 64 },
	{ "gk\0051\366\256\225\374T*:8\016\307\211\042\332\356\020\206?\014\353 UK\256\300)\371\274\356c\374\250\042\311\377\275\242\334\276\247\311\015\001\321g", 48, "K\346\020\021 \322\220\223\362\0178i\341\312b\223\200\241\310\011\027\020bR\343G\305\211\220\340\315\004", 100, "\3516\020\200.\042\206\302\212K\340\037\370\271@x\0013\251\301\012k\272\352wA\216\006y\270%.\343?\341\237\253A\236\232\377\217\240(\002W\345\311.Z\327\224K\304\015\251\200\252C\021\316]X\307", 64 },
	{ "\241\243\332j\033\357\354S\364\247\334i\302\264[>8\351\326;A\030\003F\270\016S\320\014*\013\3555\320\270D\226\371`v\003\357\331\326\306\231\311&", 48, "\026|\301 \027`\301\032\2317\230\246\376\352>R D\250\263!\250^Q]H8\322\217\2377N@\341$\273\341\031\306\357", 100, "\377\025\011\030Ve\223\272K\275\230\002&=V\271\2043\243\013\004\270\016\201\377z1\335\241\005q\035\016\016-\314XR\177\3371N\252RR\206v\351\032q\370\207\321\033*\3410\277yjA\320\236X", 64 },
	{ "\304\2053\034\271~\263W\025\300\311\253\321\265\201\303s\336s\262\230\212-\374\3737\336\331\0256\205\226o sp\264\274B\267\356\034\362\0130B\255R", 48, "\376\306\264\014\224\245\200\022\344\367\353\213s\376J\261U\200Q\371\330!\263\206\360\251\351_\0140\205\004\255\257\205\261\017\243[U\351\372~:\0350\211~", 100, "\272a\373KE\010KD\001\361\134\311\345Z\005\341H\036\035\324.r\233O\037;\217Z>\273\355\267\035=\204\215\017%\270,\256&p\212YI\356\246RL(\025Y\026Yd\237\264p\364\244\134\011\361", 64 },
	{ "\246nj~QCr|u\223\234\331<-\226\320|\356\360\236j\273hr\021R4\254\034\345\032\025\262\037\042S\274\216\236%\375\361\224\006\243\357f\335", 48, "\200\025\363A\033\210\2445\333\263&\244\002R\026\227\221\024\177\236\201\2766^.\250\262\240W:\352\334F\233\210Hf\022\273\305-\273\312\246\274\256\257v\344\361\346\333\233\216\375\033", 100, "\336\007\257\321\234\327\323\354\251\223\244\266\331&\032\352\220\335ZJ\000\002\222y-\022\3648\256'\355\003\256\333\211\276\321fY'u\252\017\202U\353\0123G\012R\002\206\374\023\026\341@\356\202\330\243\357\017", 64 },
	{ "\334^\236\035+\253\251\261\313#*C\273\226\221\266\223W:\322f\340F\234\241\277\031\002\263\340\347\271\017<\025\261\334<AU\315OIv\344:\024\037", 48, "\202+\226\014pS\017\366B\211R'\301n\242}\231GsMa\363Dn\233\001s\230z\037\232\3155\002\317\362nu\341z\375\346\370YV\325\217\306\042\004\2313\0246\225\202d\266\025_\375[&\302", 100, "\3634:\235n\204\257I\263Rg\300\006c\262\350\226\015\004\312\373\326\263G\261\234\265\014_\020\334,\372\243\204\003\017\204>G\313\035\343\042~\342\320\221\2420\042<2ZN\227Z}\221\231\216\134\334\263", 64 },
	{ "\322<\332T\271\207f\242\337\256P\376\331\274\220E\351\251\331b\324{\261\315\353\237~\267\134O0P\244\205\334D@AR\020Q\305!\217}\204'\034", 48, "\134\277\013\215[R+\223V;yS\134\334~\311\351\017\321\246k\0349\207\300\221\332T1\227z7\256\003\371Wh\313]m\037G)4\257\177\031\373I\353\227\355\3219\365g4\010\362\243O\251\333\342\015\300\227\205M-\303\261", 100, "Z\032\013\325z\312$7B\024\241\035?$5\005\374h\300b\267\375Ah\251\311\210l\200\323M\333}\203XIf@\367\222\261\357T\301\256(\004'60\334\304\255\237h\300\361, \336\331(\364\335", 64 },
	{ "\333'(\350\331\304A]*\271\315\031\002\372\361\011\035\211\317'\010\355\320.\376\265\262\343F\222A\006\312\037k\224_\327\003\312\256x\337>\304\205\2778", 48, "\215a\037X\3719K(", 200, "\203\363`'\026\233\226/+\260O%\306s\361\015\257\363w\326\042\212\250V\025\023\271\344\351/73\211\206G\2627\355Y8p\324\224\335\242\213\247DJ&\343\031]\362\343cQ\360D_\031\300A\005", 64 },
	{ "y\042\366\351\206\036<\213\015Y\013Jb\245,\200bcRZ\253\013\034\346\276,\352\221\365{m\215\255(\251\274aA\231Qo\314\220\000\215[\025_", 48, "/\272\034\233d\274\376i\001\316s5,.qf", 200, "\301\322mH\217C4\207\042\375a\020[\315#$\336\264\012-\236\372\247A\323p\016\370e#6\221\224w\305\331l;A\233\374\311\231\030\236\244\022\002\336\313\202\300\333@)\316\325\042\017Wl\010\352\244", 64 },
	{ "\243\034\205\371_\266\334W\037\345\300+@*7\033DN+\025\366\316\235\3720\177\267J\007\004\3030a\356\245!{/Ph8\223\037 %;\320~", 48, "\211\332\202T\321|k\027\207d!\223x\036*O\210U\005\032m\245\306\276", 200, "\214$\026\211\256*\222r|\334\364\000\232\005/I\277\030\015\264\336\344\000q7\235G\327\274AKx\221\257:\004\244:?\030\257^r:\251\312vj\036V\304\231K\317\325\215\015\202?\305\357\225\311\223", 64 },
	{ "BS\204Y\226\027rk\273\322\022uFq2\343\324\373x~?\026\003\350$\370\276\242\314\374\177\325Z'\035uh\2213\204Z\314\340\243\221=g\037", 48, "<\225\331HzR\273\272\323c\203\312Z\302\344\226q\305\0241AE\042\251\336\274r<+_X\244", 200, "k\042\212\314OLc\3329\373a\353\256\316\2749>=\244P\260\134x,w\006\203\000L\004\230\223\025&)\241:\255\226\210\265K~)%\134a^\236\215I\023\3725\346Z\327\204\221\350\032\334\376\355", 64 },
	{ "\025B\316\263\210\305R\004\013\362\2013\345)\237\023\006uR\305a\366\347\310\001\215\246\021|\014\006~\340\274\335\302\017~\350C\310\0151\204&\015_\332", 48, "\243j\023\234O\272\233|\212\264\2748\340\023\240\360j\314,\213H\367\344=\320\205\336\312\333O\314\344\002\230\316\362e\347\033x", 200, "\341u\033\206O\346\300\206_!\331>\002\203\273\352\351i\007\272\371 \2139:\353\231\255\015\223\262\035\355\375W\213\004\237>&f\042xi\242\266\365g,h\350\324\007\271dt\350\323\267\317\232\346G\247", 64 },
	{ "3\303\365\236\271x\021y\227j\002\351\255\225&+{\221\326cUA\331\315\012\325X\035.\014\037\215ng$\370\345gG`\004\353\305\366\226\350\344t", 48, "\366@\247\226\256\020\017\215w\241/F-\033\315\347\204\250\252/\277\336\337\022\211\365\314\036\204z\261\226T\016o2\361}\321A\256\017\270>c\216\010\231", 200, "i\350\326-\342\324\032\205\034>U\346\2228q\207\207Z~\315\375\253\317\222>\373\035\212\021Kiq\316\352\036\3025\037\220\011g7!NHAO\332\257\220\304\206\202\236\246c*\3167\227\024\234U\207", 64 },
	{ "\311\3651R\231\201cT@H_\210\352\224;\273)\3454n\213R\377\022Z\244[\222z!\234\004\3760\3162m\310\333}\022\353J\016Vb\367\245", 48, "\267G\341\021\361\231D\345\301\325\277\376g\305\256\2147\271\202Q\320\341\034M\333\251wz\247'\274\311\373\037\263\250\345\233\004\337\345l\325\321\266\370k\222\017M\030'n\033\210\363", 200, "zq/h\233Q\377\001\007i\020d\371\241\217\354\307\022$h\236\210\210\042\233\370=\246\323\236o\222\337;\316\213+\332\251\343\020\320\006\003g\013\025\230\250p\263\252\367\362+L\304\213\356\222P\317\024:", 64 },
	{ "\030\263\375\013(\031\042\343_\203P#\310\021v\261LD\272\340\025\214\214\257\216\345\030Y\373\011\303ei\005Ni\351\274\301\233&\177\315\327b\2152\234", 48, "a\314:\244\203,G\3300\354O\351\365^}-C\261\323\264D\347T\032\343\306\260`\217\365\377\355\272\031\010+\354#hm\032\030\317\231\311^k\307x\273(b\377\216P<TW$\307\261\237\033\024", 200, "Y\247\035I`\256\255\214\310\241\015\026lS\012\221$\306\301,\236\243\244\267\356R\371\361\252j\232\336v_\134\241\036\347\177\030\232\341m\275\321\004V\302\004\257\313\326\252\213\273\017\022DjThp\310\010", 64 },
	{ "\331\034\367\005\345\315\220R\216\265\011\251M\376\301\344\245\215\3747\243\374\013]\342?6\325\027\222\317\322\364\214^D\351\235\374\205E\246\303\346\235\375z\301", 48, "Gk)\360\264'\264\352\010Bk4\207\214\377,\246is' \336\2467\257?\244\336&OU\324\227\206n\231\205\277x\244@\220\273\017\323\200\026\230\310\177rx\346g?\275\036\255\303\350\010\231\302\306AI\313\177\256Q\225Z", 200, "\302\317\001\330\016\375\277\254\207G\265}y\242.\311\275\323n\344\030)\007\207\222\321\245\013\026Gm\327\301\261\013\350>S~\213(\2049B\331\031\210LR\030\304\017\276\033\231\243\013\005l\213\356\371\250\373", 64 },
	{ "7\203E@\331\362\342v\215H\331TC\026\203\3529\3126%u\000\371\243Y\356\345\012\216r\010U&\255\250\230\374j}w3X\344i\005\375\251\357", 48, ">yI\373BV\344\272", 300, "\320!\237\325\213\376WNEzz\377\263\027\376o3\337\275\021\042{\031\275b_\276\037\255\362r\273\033\333i\032\235\331P1\022\222\366o\002\026J\272\254=<@\325\333\310\314s\206\322\222\217\003\261\253", 64 },
	{ "\243^\316\005Lgw%\224?\224\312\327\213`#t<Ws\267i\355X\350v\335\376\200Q\042)^\303\242l\2570\031s;\323\331T\317\355\204\325", 48, "\354j\360L\225\263z\373\344\214\303\232\025H,\222", 300, "K0o\374\235z\027\311o\303\233)\230s\322\354\0076\334\302\232\002\324E\323\027\354\025E9\363Z\016\340(>\212\016z_\253\334M\004\366-u\001\213\210W\276\351\230\026\356k\214\001d\010\332\000\364", 64 },
	{ "\023\134;\300q\314\030\265\207\212\361\313\372\264\332X\243\264(\256(v\253}o\177\213\311\032\257\255o\323\372\201~\315\211.0\271\302T\340\353\267\235i", 48, "D\212\335qs\015\003\036\222\2433\1777Y\304\203\010\354\344\224\211\225HU", 300, "\026\377.\360\022\037?\020\355S-R\016\007eQ\037\346\240\011\256f\247\220\275\316\322P\235,A\003\203\356\265_\013\263v\001\205\033\240\332T0.KQ#\023<\363\321\365'\214[\3431\021\042=4", 64 },
	{ "i\370\260\321E#\005\300\262\243\307\235l\134\036\300\246\317i\303\357nc\011\026\244]\323\336m0\254\343\222\036\242\316(v\253,1\013\272?\226\316\324", 48, "j\207\261d\374\353\025\324%B\3405\277\242\221vw\362.\371z\231\256\3656\205\235\025\247w\010:", 300, "\202\272\354t-\235\251\270+\342\276\221\177\315'\300\0139\257\362K\010G\350Xq\252.\007\000\277GU`\221}\36154\027\004\330\017\336\350\015\255=\330\274.\340\231\257\002-\005\315c\221\270eo\001", 64 },
	{ "\227a8\244\377H\027\274=\343\334\340\007\366\363\017\202\216F\330\274\351\376`\326\326\301\273\230\217H\2314\242\370tSFKZ\373)5\235\231\360IQ", 48, "\221G\231\014\177\335\260\337>\302c\361z\357(x\252\023\245\026:\242\377\016\036G\020nv\134\305W\010\007\214\201\300\242\370+", 300, "\220\134\335]\016y\345X\015\331\252Rtn\202p\360\370\363T],\265\246J\003\327pw\327d8Z\201u\023\316O\310\034fG\034\273\266S:q3\013 \322$\313\0035\371)\307\320\277\352\3237", 64 },
	{ "\377\223\322V\2421\377\021;\314A\312\013I\002`*\005\206\310`P\212\210r\267\352y\207'\001Le+\177\035\215\362%\227$\023\366\367riop", 48, "\010\213-\360\006\216\252\220\242C\241m\001\005D\017\274\206\220\007\004\134\273\213\303U\274K+\276:\212\011\275\027\024\212\032xet\2322Ml\3006\003", 300, "E\007\311b\314\240\305\203G\221|\007\203x\245u\261\042^\000\237o\205\252\002\272\343\372\376u\360\217iWRTE\0233]\250\267^\036\237\341\255o`\301\177\3269cM\253\235\232N\342g\007\021\032", 64 },
	{ "W(\0051\335}\220:N\267EJ\316{\242\334\006M\0343\347-\217\364=\314@\270\274\035w\242\304h\301*P\177\252\346\310\022m\237\017T\271\376", 48, "\310\204\034\365\366\004\3349\213\306;\215D\255\214<4\317@\274\261\272\343B\343\034Q\374\315?1Q\317\037*\002\306\244)\203~\005`\256\335\375\316l\322R\234B\214\265\370\203", 300, "\035\014\134\361\032l~\346\263\261\204\352\2608\012\261\3559D.\014\342\134\253\335\266\000(\003\300\022\200\003\037L\343{\201\364\242o\342\301F\367\222B\211\325\226\027[n\363(\273\341x\330H\256\346l\307", 64 },
	{ "\273\305O\363\244\251\012RTN[O<\200:x\371\134\252Z-\221\030'\217\032\222\177\253\321M\321\257\226G\365\335\203\347(7\310\005\262\312\366+o", 48, "C+k\220G\014P\262P\347\343w|\262\376\021\241Zp\200}\206I\310\364Ex\343z\255\263\240\267\005\274c \276\236i\031/<\200R\307B9\207zRU\307X\005\251v:H*w\033M\310", 300, "u\315O\345\351-\037:C:\266\343\334P\352\377\020XX\206\343s\306\331\260\215\015\362m\000\233H\035\271{\272\374\232\253\035y\320\270\015\367\240\304\372\277\021\356\237\376\276\355\273\370p\322\304\314N\212\031", 64 },
	{ "\037\377\234r\001=\326\224fV\371b\277dT\313\211\342\022\3301O\023\333\325E+^j*\266w*\016\355\217-\210\315\314\323Io\260\254\200\027f", 48, "\366\1344\335j\302\272\357\030\213\010)Z\200\303\256\252\002\236w\375t\206\272\002X\364\277\214\017g\016\213'\346|em\277\271\303\262\277\236\217\012\220\210\225R\325\363n\042\031]\245\323\355w\002\305:\324u\376\225\332\300\247\300\244", 300, "\310\366\343\314Ew\224/\024\374\010F\315\303\005\266A\346Nh\271h\027\273aL\371\024L\276\035\327\3775\001\361\247?\035\366+\361\331\021\250f\343^\231\015\334\265-\015\207\324\377\213\242\235\225\325\342\202", 64 },
	{ "q\216\352\220\031\240\322?\257\356\011\021A\025\366\2248gI\362\345l\024zM\215h`\360\354\042pW\242\201\177\372\324c6@~vf]m\315\270", 48, "\336\322H\015\245\215L\261", 400, "~5\026|\306\036\242\241X8\335\301_\333\342R\256W\361\337\3755R\0067\014v\203\345r?\350\365$+\365\326\353\241\351\345Q\377\203v\333g\251\260\265\235#\250Zzu\364/\322\342:9\020\312", 64 },
	{ "\254\002\323B\222\254\231\261\351\216\333\242\326`\343\223\134\243\236\217\030\311;q\323\257\337\267U\336\270\255\321\247s\042Ys\326u\324R\344\335\020\241m\256", 48, "\325\331%W\363v\345W\025DJ\267 \364vS", 400, "\235\322\177\312r]1sV{\202',\003\364\230X\005\316\021\301r9\323\214g\223\357\322i\210\355\032\205+Kh\037\247\216\360\247\024 \372\023\263[\266\033\213I\335\234u\030\007\311>\312\004\247\377\242", 64 },
	{ "\265\265e\302\307_\364\373\276.\2365g\272\004q$\030v\017r^\333\333\354<\302\020\343\232\376\215\031\2677a:\213\231\277S\232\261\017\010\042\241\361", 48, "\012\336\215\206T\254~\376\336\370\250_\362\017\336G\370\026Q\214\302\3651~", 400, "\025\0248\217\317\026\016\213\3650\257\203??\206\015\310\034y(5\365\265\277\344\342~w\336\220\004\335>\2166D\002a?\017\341\373\345K\274l\336f\304k!W\344\377\315O\023\217\303\243\366%\200p", 64 },
	{ "\340\263\354\340u\240\277Vg\021\256\236\340\215\342u\323\230\306\225)CE\013\330 v.\005\216\3626\007P\342\134bF5\277\021o\030\020\042\341W\333", 48, "\333\203@\327\021g\014\204\347\341G\300/D\226\363\366,m.\212\204gyyv\224\277\376\3474\224", 400, "\366K\013\224\363[\340\332\217\030\377~\236\344\251\241I\015DV>v\244\2319\254}\316\010\270\375Zob\025\354f\262\240}\231\316\310D\347\216\342\332\266\340\007\246\213\215!\022d\352rC\345w\320\301", 64 },
	{ "n\331\266k\177\321H\344\257\006M\206\270\313\010\035\226\3450z\345\235\213D\010\342,Dk\233\344x\2470y'^\353Y\264\177\012\220^\231\037'\322", 48, "#sr\373\330\006SzghX\015\241\336\340[\246\235\345\273x\303\020<\357\377\347t\222\323L\333\302\354}e\342\2500\232", 400, "#F\335T+\356\202S\240\036\262\301\212\035M\211\303\254\212a\313\270\263m\360\274\325#\225\241\222\333\010\244n\202\334e\353C%\364\3125\340\226\006\336Y0.\272qy\375\202g}\330\300\234\347\333[", 64 },
	{ ",\250f`d\312\224o\3502_\307\205q\231(\032\260\346\356&\274\224\201}\307?8-\241\270?lF\177\230d\313T\3034[-\000\2478J\232", 48, "\304]\024\312\306\300\227\350o}\211g\265Y\375\353\245\026\033S;\350\247n\326{7\340\352\260\366\257\206P\207\204#%\032IA\325\250\210DYAO", 400, "b\273\002\314\350|E\207\361\362C\215{\200\037\315\253\034K\275\201\273\217UQ\364\223\326s\215\330e\014V\241\376?\315k\134a\360\241M\317\266\312F?\032\332\036\347\312\216\341\362\031Wy\234\026d\323", 64 },
	{ "&\334>B\230\255\211J\214\377\011\243\316\006\240J\320l\007\353\335\343\332\3404\031\3302j\330\214(%<i\254\232G\206-~Vw\361*\226x\042", 48, "\256l\314+\350\021\200V\202k^y)\036!I\252\346\317\202\302\252!\232f\2167\316\232\254\272\027c{\265\006HYxl\320,\324ge5\012T\243\305\333\331\034*cf", 400, "i\253!cG\312\257\317\2517\221\337\022>\210wa_\021M\016\363x|\351\264q\252\247\037q\204\260\252\207\363\334\022\305\303(\014\254kh^\3033>1\257\232\267K9\321\252bj\231~\300\363O", 64 },
	{ "]\332?$\004\366\254\016\341:E\226x\306E/\020G\020m\026I\377\276\3517\331,\215\3616G\214\242\004\244\3532@\323\011\366\223\017}\327l\241", 48, "k\306\002\317\350d\233|\226J1\304\207_\012\134p\265/\324X\377c\323\247\315\353\213(y\011k\316R4\002\010~\355B\343\004\233A\361\215\202\360\350\225l\272\237\037\231\370M\014\272\350\376\373\304\016", 400, "F\306+R\313\313\356T]\265Q\302M\033,\302]0N\336\324\247\376\036r\200\000\177XH^\326}\032F\301(\267\322\005\317\210\276\345\360>b\311k#\236\232\230\001\261\334i\324dovY\276\016", 64 },
	{ "\3002\251i\014\011\374s\231\015kG\350\042\210\134\315G\301Y\247\360({\214\233\265?\262\235.f\354\001a\177\025\002\333,\253Fk\246)\033\265\247", 48, "\022\026\023\327;\252\020\230\316\273D 2\2074-\332\305\324H\236-\376\243\023\200h\235[|\245\033\311\025`9iw\356\330`\366\252\305\342\013\202\201\363K\0048\177\274[\013\0050\026\226\353S#\354\016\326y`\273cA\014", 400, "\321\352\231\215\0032\300\237\2400\015\276\334=\241\211\220\025q\201q\375\205!\314\036'\032\215\205\0041\245\032j\220j\274\233\237\177\034~%s%\317\265\037|>\037\247\021$\255\305\244@\304\227iJ\024", 64 },
	{ "\347\261\210\236[\316\372Q\373\250a]\234\250\256`\354\007u3\325\363(w\237\356*\212\012\367S\302\3633\016<\201\267\275C9\355\313\366oT\233F", 48, "(\350\024\322\324\365?V", 500, "\216\260OQ\232\243\336\366\227\227.6\271\255:\375d\272\255:\262<\376P\2549\0140v\276p\355\312\315q>cW\004\256k\177\200\352\373\134\035\230+\275E\242\341Z\331a9\305wnc\033;\341", 64 },
	{ "\332\321\232\255=\252\364\2101\220\275\324\022)\272.,\207\005\354\260\373*Tp\332\213\002\2209\302\225\377UN\371\226\271\347\035\344\016\314$Z\005IB", 48, "h\225/\013\200\311\354\235\201\312\212<\310i8\015", 500, "u/#\332\222d\355\2471*\030bp\331$Q\254[\252\232\223\365b\243\274\216)\302u\244,U\317b\015~\307\343\032\351\333\025\243L\201\256B\223l\013\200\267M\035D\346\203\324\301\037Q\000\007\226", 64 },
	{ "\345\3040\031\263\343t\315q<\316_\202\027\247X\240_\301\275;\203\244\363\257\257\200fm\334\370L\216<5\313?\305\211W\262\001\314\212D\237X\332", 48, "\367\215)\3624\242s0\026R7H\242O\221v9\316\236L\321h\321A", 500, "\246\314\355\264\242\254\245\2515~\235\036jS\276\307\364\204'\272I\310UY\256\300(\276R\313\336\007__\031E\240\300/\355\302\253+<slD\374\134\334\217D\017\277\213\313\012\257\345\264u#\230+", 64 },
	{ ")<\202\025c\336\000\134\314\322\362R]\267\016\315M\024L0A\212`\3066\241\331\332\360Z\346\026[\374\224\322\252\356f\034\275,j>Z\213\244\262", 48, "Ub\241\246\347Ra\255\251\336\265#K\007\226\252\220\300\013\207\037\330\325\347\332U}\377\031|\270\341", 500, "R\2132\007\270\222\307\022\200\364k\005H\305g\371d\243R\215Q\235\024\006\352t\320-\317\356\374?\367kW\353\006\253\355\220Z;\227t\306)\034\134\314=/\376\206\200$\226\211\007`\374\323\215\365X", 64 },
	{ "pJ\004^n@\211\310I\346\177\373 \366+\036w\030\022\211v\316\257E!\344\2632\234\355T\216\003\336\213f\262<,\302J\302\304\363@\224\310\267", 48, "\343%\240\355?TI\033n\020\017\177\317\256\325N\015\251|\011\347z\200<\271\3260\213\260EV\312\327\030\313\357We\033\313", 500, "\342\014o\300\351l\227\010\364\241!v7\252\370\325\202\325\002R\347\264VT\022\361z\303\310\036\203Q[\357\367r\262\375I\245\377.\221\320\023P\336\377W\273c.\3756c\277\273\233:p\330\325\042\226", 64 },
	{ "\210ll\2324T\257k\254\312\330\015\341S\301\377\355\212D\265\014N\260\202v\254\306.\371\264\264\347\270%\313\241\307\030\250\240S\340I\010\261\026+\322", 48, "AU6\242\222QF\265\340\334z~\264\340\232k\011bK\313\377|!\377\355p7\241[\302d\274Gb\032G\266\017O\250\373I\2458\340\012\217\025", 500, "\247\301.V\025C\231\205\373Jnl\326\2618\212\313m\210y,G\020\007\354oQ&|\270i\031B%#\232\311\3333\353_.gQ&[\010\262\2363N\321@\376\034\000\213\023\236\305\000\311\226\042", 64 },
	{ "0\326\250\274~\355\236\276X#\262\307\275K(e/\257\266\344\212\234\325h>\322\321\023 d\0236\203\2079> 3\345 z\343\362\271\335\0155x", 48, "\005\230c\213\230{\007i'\013\361ABj\027h\264o\307+\004\374\233\223\332\025m\134<\250\242\257\267\024\215\243\025\030\210\324\024\030\243\3245\001\021\335\3000\274\211\364\033\3308", 500, "\341\304\000\2766\033v\3629UDS\225wg\213\331\360\244\367\252\372\034L\373\307\273\377IP\207\247V\273AK\324V\234\263_\263\263\036\004 uH\202\340\213b\236\254\336\375\203\017\247\362\016q\220\346", 64 },
	{ "\237V\2613\263e\030*\265P\032\345\337d\301\335\255\030\217|Q?\026\346Tz\012\015\367 Z\312\344\201$\240\235\031\377|5H\345\215\301\015t\327", 48, "\301z|\375\223\324\351Y\177\325\372\031\244#\227v\311\322\316\306?v.F\037\221G\233\346?\377\200\237\224\343\011\353_\362M\042\301yi\030\260\201=\177\351\260\264w\005\250\214v\205\354\336\010\363\365\004", 500, "\362n\263\316\332^\2014\345\205\300\305\365\376BY\376\236\024idk\032\355u\271yaJ\333\351M\347\331v\015\223#\016\375W\237\025t\030bT\005\316\010\270\024uaW\226\247\213\355K\371\241\031\023", 64 },
	{ "Z\324<}Z\312\004\205\034\362\365\225\212^\232\177\257\300(r\267\030\0117\335\270\354\312+4Y\241\042E\315\212\020\033\211]\004&v\306\303\361\277B", 48, "\225h<\331\365\310\362\347oq\354\022\333\021m\232\204a\007(xP;T\302\262q\275\200\206\300\255\206\220\213\354@\333e\033\2401w\241\242\347\264\001.B\042\036}9%Ni\253\205\235\271Z\3507\304U\265\254\3725\236\265", 500, "Z\277\007\350\355e\223\237o\254\371!\243\351\042\350-\016\364\233\247&P3\341\350\205;\247\273O\252Xre\372\362\263\344)SN%\251AF\012\235L\305\222\031nq\017\334HWP\231+\304\036\221", 64 },
	{ "\362+\275\020l\220-\027\255\302\003\212L\352\300\371/\042\321y\361\331\224\037X\325Gbd\042V\262\370\177\271\357\314\251BP*S\262\244\014\351{\334", 48, "W\333\001kC\344\327Z", 600, "\347\012+?\027\303\377<\247Y\200\360m\247\332\272\226\273\256\033\254\001\362\266)N\265pVX\033\241\251oI\333\3353\200\270\035\237\265!\026\353Z\030\364m-up;`H\263F\321\233\321!k-", 64 },
	{ "\314\311#\207T?\270\042x\212\336\253\220\025\372\314\334\237\020_\254?\312\352\344\320.\333p/\273\351[d\250\012O\361\354\035>\343\327y\251)\254\274", 48, "&\315\257\244q\375jM\260\011\013F\216\326\2114", 600, "\015\316\321x\304\314s\252G\345O~\354c\271\254\371j\002B\317\007\357\345\362\273\230\326\230\320,'\203\335\330f\346%\360\372\257q'\005\177)\240?\240\230\200\364j\027\235\200\266(r-\335\027u^", 64 },
	{ "\243V\242\374-\376|\230y\305\314\334\337$\3249bK\360\3320\310\022i)rK\332\206\315a\303\345\011$\261\036\277\001\015$\373n\020\2140\377\351", 48, "Fw\252\245@00\247\345\207\201\236\374\007\267:\260.\202\035\320*\372\234", 600, "q\272\365\007\204%\247\323+\300\214X\374(\236\020\377\277S}\222\304R\016\303\332\033*\2563:f\000\262\215\343G\327\363T:\010\301g\033$\251\307\264\230m\315\226\271\234\343\363\374\010`\012\247\377\263", 64 },
	{ "LB\232)\011\316\200\323\234>\215\367\321E\017V\134,\200&a\236\134\370k,\365\350%B\026\275E\006-\031\360>e{\262\303\365Ta:8\033", 48, "zBr\3266zM\310\350\035\361M3\205\357\300\213\215a\306h\365\250\202g\337\241z\275\364\210\301", 600, "\304uC\301t;\321(/WD\0335d\3120\024f<\312g\372\000\032L\337\234#0f%\230\366(e\271\255\024\335\021\215Y\336\373\340O\034\301\256\032\223\330#\342p\325\222<\244\306>(\2753", 64 },
	{ ")C1;*\260\313J\252\203\034\314F\371\345\214<m\227\372pAl\327\203[\326\014\236\356\371\354'\005W\301\317\310\310\232; \210t\246\370^\223", 48, "\0036\217t\366`]\266\222\267\001(mr\245r\350\037\202Wr\027\266\031l\243\274\332\357\376\273\211\027\213s\3266E\343H", 600, "\303$\034\015\336\257!\303\352Z\200{\305+\305\375;a\331>\330\210\235\317js3\232\207r\320\036/\034\241\260\014\233~#\375\214\013q\327\025\365\001j\213+v\015t\257\303\352\352*H\257K\306\216", 64 },
	{ "\224\321t\031\261\362I\335m.\206\266\227}\223^i\236\276\262\233}\222\306\252\002\206,v\216\257 h\022YL\003\277I\266+p\000P\226\340[A", 48, "(\273\350\346\347k\353\022\022\201\352e\134\317\042\230\031\255\036\317\313?\042g`\231DS \025D\042\350\243\327\210\134\0016\042L\023e=\335\033+!", 600, "\233\23450\212\372m\212\331\233w\270\032\374\373j\002^<\316.\261Ps\247\3500w{\351d^\320\330\254\352\347\233\333\203\364\347\201\260\007\225\274\027\343\311\226T\221\207\265 ;\003\271~\275\237*\260", 64 },
	{ "\247\241R\241\303x\201\231\303\2228\270\210\225h\230S\206\376\017\210\256V\215\371\223\031\226\017e\357+\244h\227\273$7\223G\233\322E!\200tB\221", 48, "\324\341\244\226\271\020\034\217\024\010\352\015$\273X\277\302\375\004\011I}?\001\230@\313 \225u\357\312\022\011_t\036\204\012\252\023\345\244\336%\370\243\376i\3665\015Z\357\134\202", 600, "\036\224U\257a\306\355\351O<\372\250\351\014\302\360\020~\361\242\030%\270\033\301\310\014\256\301#\204\341\004\272*lP\351\340\017\274\004\321=\203\271\363\004V\311.>\322\362\365U4\346`0\321\220\276\343", 64 },
	{ "\342\223\355\255m\206H\340-\134\367\357\363\242Cy\207\362s\033a\367\377$\332g=7%;\321_u\213%\325,oO\334\256?\241\1770\270\005<", 48, "T\221\256#\230\334^\234\246t\301\256\2019\004\260\240n\374{\006<\375u\020-\361\264\303CW\027c%kF\004\316lf\313\222zr\365\025FC\246\343\351I\330\233\001\345\371i\266s\033c\237+", 600, "\225nTZQ\036\2149\344\253\357\027H5.\276\235\365\252\224:C\014W\303q\257\006\315\004w`r\233l\026S\013\230G\247\035\343_\021\134H@I(\303\257m\356\353\361\354L'A\355V4\362", 64 },
	{ "\212\030\031\247\326%\221\3514+@B\027\306\333\274\374\005.oX&e\354\326\255\345\253a\360\232\356\257\343K\374\237\317\023\270\244R(\352\303\034\012@", 48, "\367\231Q\247&y!h\315\323\315Ie\352\330\336\205\332t+t\001c\016c\302pPW\325\313\352Y\007I\320\364\0059x\24245!\0176\275\360\306\276\340\303\011*S\207\275\232\275\006\370\003\300x\313y\301\272\310\364\356\246", 600, "\323\242vD\355X\240\211\213V\235\204oP\327\200\224\365\3275OO\006\232\360\263\273~\255\323\3613\362\365]\255\250r\010\352\366\0308\010\341\310Z\2400\206\242\373V\236\230z\333\241\032\032\303A\234\001", 64 },
	{ "\244\324\240 =\357~\230\377N93\227\276\357\224\031 \366o\371\377G\251d\012\013\346\236\351\375\342\227\271\271\346\373\366w\042W\322\310\235\005]B\241", 48, "1\246T\373\275\002\241\246", 700, "1\030\274\257\036\365<E\251m\356.\206\206\364\333\267\271,\205[\367r`X\365a\230\011\0321.N\025\270\204Tv\250\350\014\246\214\260H\265\264_\253b\134\016\042\360\210\362El)\2119!\003j", 64 },
	{ "\327\023\345\310\322\203\277\0165\330\354\030C\204\241\036?G\016PU^\223\377\372*WR\215V\3168\226\243J\201\250=\210\037\034\345?\264\306\236\322I", 48, "+/\303EY,\264\024\254\332\223|\371\210f\362", 700, "Ds\250\230\265\306\352\303=\314\020\221\203\330\331\230H\300\015\251YD\037\042\353(\001\262\223\333L6<Z\336\242\037\004\311\012\303OJ\371Ht\261\255\355\371Zq\335\022\364I\330\333#f\272\027\233U", 64 },
	{ "\210\036\031\220\267\013=\3369\021\202\220\203R\241a$52\0239\243\365\371\277g\272E\345\241\262\350s\371z\365\364\022\200\322\027\203\345\251\012\232\020F", 48, "\337\345\207>\235S\230\232\301\331\344\261-\205\274\244\257j\007PX\017\037\032", 700, "\360\017\002l\347\336\213\357\000\240t\330\006%\301\341\215f\3521\365i\345\270@\372iT2]\342\345e\311u\3417\274\014\263\261\373\3254\221f\275\343u\321\365\210\365\277y\365]\340\372;\363G|\232", 64 },
	{ "\357\217\262f\233\325\3650r\024\267\274\264\221\023\377i\273MUv\215\236I\345\302<\273\325\316\265\274]1RH\270yM\021\000.\332`\247\207=G", 48, "~\214\270*\361C\037\207|x\267\021\333\027\363\3306I_\376\345\355\0267{\042\375\006ap\227\005", 700, "s,\213\3052}\245\352r\353E;\351~U|\333O\276,k\240\177e+\242\024:;^\012\255K4\245\212\042\376\037\245\033\355\042\236p\207\273\3456\257u\005\227\024q\237\312\232lArBH~", 64 },
	{ "\0018\243Y\355)\330\007|\373bm\266\337CI\333(\346\235\332\177s\201\340\232;WlO\013\353Iy,\270\300\012\356\357\345\264\321_4\330j\357", 48, "\363uu\356\257\354\022\002\327@\005\344\314H`\250\265\134\005b\3403Y\023\364\333\210\264\2741\351\2079\216\225EJ`&\035", 700, "&$\224\203[\324\0071\206R\231K]\245\215\015\256\376o=Z\223}\262\233\370\370\361\020\012n\377\024c\263O\306\030\004Az\242:\320\316\020\263\037E2\234C\227q\220\232\201Og\247?\265\276\244", 64 },
	{ "\217\033d4\231CTki\200\177\035l\364I\370<v\0300\330\334\013\315/^\2334t\315\334\367\247\361\034'\342!\241\006\277\363\252\364E&\335\317", 48, "\260\023\306\245~\274-GK\326\326S\267\212\200\350\260\215\004\310\361\367\212\341\373\035\004\247\212\317X{\211\260\243R\320<\326(\247G\034@\016?\267]", 700, "\200\000\202\325yun\304\207\241\211\237G\340\0352[v\225\042\310d:\345\024[\327t_A\252oi\250\030\376\344}\277\023Ob\013Xiq\226\223\223 Lq\241d\220\323\311\274E\273eL\313c", 64 },
	{ "\205H*\371U\266\223\300\330\251\236\305\214u@/\134\366)&\307\033\017#>\042|\360\030.\343\314\311\316\366D\235\355!\316\020 0}\034\030\267\317", 48, "\004\335P\231\267X\217\216c\347\303-\007u\023{\357^\212\255\231TN'\337\374\264\036i\305\220\327[\372h?\321\331\227\012\200\257zc\340\004\221\211\246)\257/^\243u\301", 700, "h\237\233f\334\277-\365e:I\267\2437p\204\350\331\350i\005\267\272\370\257\232\315,,\332\351\315\360K\177\3314\013\341\334\227Wi\252\333;m|:\012%;\210\230\353\030\305<\215\220F\005\343\234", 64 },
	{ ")\022\305\306\361\300\211\276\342\335^\263\360\257\015\345\322\2214Z^B\211\002P\343\367=\241\217Z}\023\355`3\221\323H\031\214\307\323O\002\374\221U", 48, "\006\025\224\362\004\313\003\032\304\331\345\373/\372\376\0053\377+\356\314nzI\366\307asa\023\353\227\261^\377\212\353\004j:\377\237\264\203n\326\314\362Jy\320O\217@\227\200B3\021\371Q9\267\033", 700, "\212\261\233,\042\243\250\260\355d\326\256f~\343\274<\225E\277\310a\237\267\276v\312\232U\272\257\177\226\2462]\262\037\365\304\355\336\354\203g\035\311\265\035\206\017My}Lk\222\034K\362\362I\222:", 64 },
	{ "\020\240\200\016Q\273\3750\000\0070i&bR*\375`a\224\005v3\030\01362\037\302n7\217\364`\307}[7\352\375\235\134\215\023\333\2273/", 48, "\300\322E\333\374O\2276{!\326/\355\277I{Q\341\031\024`\222\337w.\200\252\003=}\203\315\224\033\034\042\325\311\334Z\215\360\234\221\262D\206\257v<R\331\275\240\215>XN4\360\263\311Nf[x\366\320\205\257\015\201", 700, "k\031\342\357\021U\327\031O\214o\214\265\014|[h{\220S2\275\005j\016\025\230\222\235\002\221\012L\260\234\200`\324\370\134\275V\355}\261\344\306p8\241 \311D\336\341\236\256\243k\312%\225\042Y", 64 },
	{ "B';u\226\317C\307z\011\313\345\012=\3379\372M\200\331G\325o\372\014\367\221\001sf\275\355\201\221\033\042{\247tU\347Nf\025\301U\341\267", 48, "\303\2054\237\224\337+\267", 800, "\300:\200 \244\004l1U*\251\235N\006-\263\037\216\257\277\235\366\214\330\256\134)\373\377\242:{\337>\376!\022\037\232R\333(\221\313\353m\322\371\321\236q\373\272\313d\320\355\213]47\243\243\004", 64 },
	{ "\224\334X\314\371p\0310\2779rv\320JV\271\217\361\014)\367\024\365\345\006\254\224\254W\342\265\223{Q\2174~\372\312@g\003\015\314\365\242~\347", 48, "[\336y+B\026\336\220\304F\220x\357\277`\042", 800, "\306)\375$\247\2557\307\213\245\306I~\020G6+\374\250\231?L\275\030@\245\200\274\245\265T#F\3222?\224h\216Z\334\334\2002|\266\333\363\203R\033\316\243\021\217G\215^\005\356@\230\260\277", 64 },
	{ "\234\214!\015\311\276(\370\327\340\215r\272\251I\025\366\347\373^\240u\274\212|\317(\271\205\217e\277\373\252\243\223\346 \316\347\3356\321*\035\212\332\212", 48, "\261+\374\0333,\372Jz\034\222\345\233=\235G\300\307\257\244\333\253&g", 800, "Ty+\353m6\340\005A\316\257\336{Sd\2755\205\275u<\274\232\356)\333\134\006n\244\357\347\317\226\271\305\237@\347\202\020\316\256\353\247^\373=-\253bQ\001\370\376i\203\216\265\215\375\2636S", 64 },
	{ "\000\315\257\224\310\010\271\202m9\212\034.2\305:\316t\375q\212+\355\260A/\022\032\014\225\350\277\007M\273&\002\3738L\353}\016!\134c\037C", 48, "\333\257kres\311,\263\242\350B\203\361\204\322\216\207j\246d\267\037\342e\235\031\302\320\374c\376", 800, "\211\301\301\237\314\002\205\216\030{\015\274h}D\216/\262\314s\331\206P\275\332F\372\264\300U\216\034O\330\202\362`\3476\000d\337\037\032w\327\365#\233\377Wfo\361\376\244\302\177\361o\370Q\270\354", 64 },
	{ "\222ma\214\201\372YU\315 \371\0023\242\340\235G\361+\3025<\313E\235\276*yi7\277\213\3009\210\265\223\334\355\344s\322\224\240\312\263B\210", 48, "\367f\326\215\006\346%L\022U\305AI\343\307\223G\372[\320\012\017\205>\031\243\313jp\223\250m\213v\251V\177\276~#", 800, "\344\224\222\246h\225\325\010\301W\042\033i[\354'|\366\036\244lc\270J\217%\351\032\257,\177J\031Q\017\007\270@\254&,\336\317\312Z\321}\010\332p\200\237\014\247F\277\042Og\304\247\227\177\367", 64 },
	{ "\305T\312l\0366\032\354\011\006}\324s\203\365#\335 \324\375\305{\340D}\300\247'\254\303`\310s\266\023\003|[\367\371dw\2262F\361uh", 48, "I\225\007Fu-^\010b\363\356\312\306\034\002E\024\262\3241\377V\270MZ\334\270\314^Lm%\011R\3446\244\261\335\355%J\342;\301\353\337\237", 800, "\241\377\320\274$n\333@\2541*\312\320\245\211dJb: \266;\370[\2713\306\253\275_\217Ex\306{\271x\025\236\253c\024\311t*\336~)\355\026\016\014\022\000T\335\340[\360\264z\016|\323", 64 },
	{ "u\217]\362\346\353\367\227:b\317t\237a\344\024\267rn\332'\001\364n\042ar\020\134\357\134\314N:\264-c\306\012\331\342sRH\334\213\242.", 48, "\352\134\314`%\177\025\022\230|\001\026\271\314-\001e\006\360\250i\214\201\261Y\313\325]\354j\3024J\364\327\304\302\340\242\373.\263\246: \026\376)\265\210\031\212\365i\254\201", 800, "\366/U'\255>-\370\322\007\215^\264\321\302\234s\010\275\234\321H\316A\236ES\026\341\361\212\251\214is\367yj\316l\2133D\347\346=p\006\254\007\256\016\021}\367M\013<\374T\210$\357\005", 64 },
	{ "6s3\342\014\013\351\345\270\270\207\354\004l\213aV\227<9\267v\223\260N@\376y\3072\273\333\274\353Ni\231e\372\316\022\031\375b\365\336\042\023", 48, "\367\231as\364\300q\204At\274\235\343:\205`\017#\210fhG\367@\333\007\3350<\303t\377\025[F\036\235\214\246\326\024\312\257\372\003\232\201\013\212\220\354<\377\251\315\314\2205\360\304\020\233Z\215", 800, "\241\341\300\227\005\242I\331\031\003L\263Z\361Bp\262k\134u\330 };\234f\203H\217\033k=\301N`vwY1\017j\331\177$|\360j\014\021]*s\177~\223\237$Oe\037\216T\321y", 64 },
	{ "M|\210\012\365\274\254wp+\240G\372\252TY\020\227j\022\025en\0219)\235\020\314\364`#RV\236\261\342R\211\312\034.\3324P\0170\342", 48, "{\031t\3021\3312grv\026\210\373\311\024\024\271q\246\333'^\307\355\253\207\256\345\351\365\030\377\374\366\355D\332 '[`\177 e\354_4\242\316\221^\0170\315$\336\355#\037\343\215\224\244RL>\245\234\247\244\272\243", 800, "\304\257D\322\243\321\011:2U\022\270D,\375\011\236\265\262\331a0G\230\003L\302\241\220\217P\332\244\364\016\037k\222\375\200\277\321\332\3647\033\360A\261\365\013Q\337\036\355\2522N\263 \000:\2164", 64 },
	{ "^\372x\204\356\231\244)r\277\370\0230\001\365\232\216\214f\3107\302K\351\020J\252@=\377\261\247cy\177yz\211\035\354w-\347\313\327\363\253w", 48, "\261\352\305:|I$\225", 900, "p\326+\010W\257\325\370`Y\007P\030\035`\373\3055\215\031\346u\033\230\025\367xs\007j\272\266\260\357\265w\365\017\264\353)\364;\275\026\215p\0212r\206\277\260\207\272\373p\245\363<\224\247\300\375", 64 },
	{ "\306N\274\353\353\372z\375Gg\351\310\0275\021O\333fd\031\246M\223\211$Pt\320\253<\226rG6\333n\030\330<\265\243.1tM\035R\276", 48, "=6\352\317\376%,\275\010\326Y\005~\330\214\350", 900, "\012\237\260X\323\007\306\233\331h\3306VN\350\366\337d\232c\364\370\360\253~\017|=K#\251p{<Y\001\250\016\324\034m\251\332\247\341Z\253\272}\010kE\342( \303\367\315\270n\336q\225\357", 64 },
	{ "\017\022\307QF\026\277\346\3408\263\230\263j\257k-\247\354{\020\337*\337\017\340|\002\2542\244\024Q\243\257\201\232u\243+\013\030\330Wa\2631*", 48, "\254\366\243\320\356/\367\316\025\264\305\010\200\241\257\320)\264^\273/\367\014\341", 900, "D\021\265}\250\3378w\241\036d\274K;\374\037\320`\246\343\237}vi>\327\260<\230\021\330N\036'\233\200Y\2201\303\177\247\224\316\236\243\2265g<\374\363#,A\340\332\326\036\1347\373\372\346", 64 },
	{ "\354t\342\3266db\242\371\260\214\214:1v{\305\361\203\325\006\360\237\220>$\341\235@\201s\345\304E$\305\021eRg\007w\272\037\252v(\334", 48, "\221\370\256\213ef\313\016\345)\3576\021\026\302\365\037\134\353c\340DhGJ6\042\355\375\3328\377", 900, "\345l\321\036\300%\257\015@E^\357Q\275\266>\303\007\334\324\323\032\346\302n\345\214w\311\031\300WU\201\030x3\361iP<\012\321\360\314\017\245\351H\3768P5Y\255b(\367\377\225QD\244G", 64 },
	{ "\212h\203\333I\202:\236Ev\276F\360I?\017\270\313\366\342\033Q\204\013\025\020\255\271\261N\327-\327H\134Of\300z!\252\020\205\330\352\3010\273", 48, "\352\304i\241\366\217\357\216\232b p\017l\214\224\346\260\014\320&@\264m\367'C*\363\343\316\223:i\032\357\312R\333q", 900, "\334\371GE\312\010\314\257m\035k\020\026\204\266\255\300\251C\343\243fR\303D^\302\365B\014\266J\034\227\214 2\215\374g\012\361\261\247E#\327\314\331\326\224\023\267\015\266\212*\371\346\014\305b\342\020", 64 },
	{ "\251\205\204\301\302\247\005<\367\134\236\323C>\205\277\311\327\013\270\256s\364\212\366{|\252\374%\311\335C]W\215\312$\377\205\206\325\231z\220\370\367\355", 48, "\222\334\262\311]\217\213J\362\262\354\035\236\301\316\300l\210\205X\233\026\034\253\372a\037\025\035\235\311\224\313lf\316\346{\300\225dB\217\267Q\303\265\277", 900, "/r\256\217\345a\345|\227\372\323\205\274i\013\367\222\222w&R4\216\337k\271\345\342\371\345\205-\263\333\263$\217\204\347%2\206?\347\216\020]\202\240\011\276A\232\031:\252\257{\245\340\177\005\017F", 64 },
	{ "o\203@)\270@p\026\240\016>\025e+\365\367\243h\253K\134\252_|Z\247\311\374\331\220!\304v\203~Y[\001\314\316&\235\3662~'T\313", 48, "3Z\266`\240\015h\363\033;H\005f\316\213\360w\276Ic\224N\006\026\241R\345\252\317M\256.\217T[9yc\2416\220q h\214X\303@\264\352X\033\013i'4", 900, "qY~e81x\267\010\355\256\346=\217E\3054\367\033\223\305\265\240iW\205p\016[\367\253\201<I\014\002\012\232\314\342Kk.\006\033\025\212\306\257\201VC\215\315\211\345\010S~\230\011\306\336\232", 64 },
	{ ",\001y/\340\256\035g8\377\042\253\220k\304\360\314\232'\302\352\004\304\215T\233\241\231\221\220R\230\332\212\214\036\310-\004\344\213\260$\013\014\236\262o", 48, "\220\277\016\213X\031\232\241\275O\313\2761\201tm\004\346\257-jr\326\207\2622\271\305\301\036Y \005\324Lt\274\234KR\366\025z3!/\244%9\372\316)\337\320q\322\034\370J\313D\011\325y", 900, "\013W)@\026\234j\033\211\263\042\252\344\244'T\030,\315\236\354\262\232\271\015\324\267\214\030jV\003\034\300\376\023$\031\334p\252\2203E|l!5'\213\201\226\005\336\303\232!\317\223\024\020\265\314E", 64 },
	{ "Py\305\207\302\350\255Ah\004\361:\243\340Gw\317e\204\246Ts\335=\240\346\326\024K%\003>\253{\327\375\3426\226_\315\323\340:,\321I\253", 48, "\210\226\334JU\226\325\266\244\370\345\005\026\340\004\024\034\261\250\302\343\237j\246\213\011\250\262\351(\221\017\263\346\252z\023\353[\234\217\022\263\270v@\042\021\360\264Qq\266\347\007\352\253Df\025*/\233(\030\261]\035\305\365;\216", 900, "\262)_\014[\213/Ped\016\343\251\006\032W\376\035\321\022f\030\360J\212\031\327\301:\342\020\324M\347\250;@\032\342As`\272\006\261\364i\333\230d\341y\361\356\001\347G\341\026C\374S\244\323", 64 },
	{ "\337\340\0338\311BN\317'\345\351\252$3\346\367\035a\346\204V\341\244P\333\351?\304\014\356V}7\274\235\011\272\134\337\023Z%RB\214\360\035\236", 48, "\342_\030\013\242\335\241\032", 1000, "\233\012\250\243\257`\267\003\230\221o\226{\3123\032L\3124\301\353\317Ky\215\320\342\013\035\236)f\025\214\315Uh\015\217\266\012\006W\021\003\210\327\263_\021}]=M\357\3613T\325\017\272m\235\341", 64 },
	{ "\337\245B\343\267\275\006*\002n,!?\206\365z)\211\020$I\326fA\217\335^0o\335f\351\004\364\177E\244\016\325%\036\342*Z='\332\303", 48, "\231\263\316\356f\366(\017.\272Af\207\263\015\237", 1000, "\366\331\243\333\005*o\210hM\134\333\007\216\207\134\001\346y\272kq\013\256\340x\260!Hb-\276^\343\243\223\015=\001\271\3758\021Y-nX|\361;|.g\352\265\341\367\236\042\324\201*\177r", 64 },
	{ "4J'\377v0\337*\246\270\014'\357>%\333\012\352\014b'e\277R!{\340\020\305\377\017\242\357\331-\042\324\042I\225\306\316i\242)\026\212\234", 48, "\370U\302\377X\352\001(\222\226\2464\316>\362\240[CF\230@\021o\215", 1000, "\003\013u\035\376g\025\240h=6\312\213\361\342_\366\363\230\237\217\246b}6\221\002~.u\315tI\200\263\370\270\200I\351\234+\266Q,}\022c\007\317\274\352&\257\317\234\276tRI\013s\221\215", 64 },
	{ "\254\355jOV%\361 (\374W\3124aq@;\207s\010\270rU\204\001N\023m\340\312p*Z\245Zt\333Kr\223\347\200a\355j\020K-", 48, "x>\324'\200\030\360\316\304\012AL|\0303!\237(\245\212P-C=S\375\037i\225\324\362\265", 1000, "3\026>\262\353\324\014S\233\316\233\302v\2516:e#\262W\273Jb}po\305MV\036\035C\355\371\317\304\306\326\026j-\345\241hW+\234B\375}f\273\244V\321;\220\343\272\376\365\214k\267", 64 },
	{ "\220\006\340z8\343\225\036\035\177:\232\026\227\343\356\342\3432\360\362R\213Y\225\217\330P<8A\277\307TOY1}\311\304\263\343\342V0\000\012\223", 48, "GG\036J\266\271\226\234\207\222\0130\014\300\244\263\233\267\215\331a\216Yxas\224\376\222\023i\317]\134\3245\306~\251/", 1000, "\363\205\315\022\320\352![\327\042\242\255v\343\252\252\243\324F\244DmR\207\347\340\215\020\224n\212\270\267{s\243d\203}\2477\342\033V\265<\270\306\020w'\330\027\301\023\006\026P\025\005\260\002\251\027", 64 },
	{ "\025@\366W\027\237i\355\013\010\332\335\263P\237\354Z\243\240\335\322\204\025\275\007\037n\304\266W\366+\321S\005\216\273[,\244v\026\372\021n\326J\323", 48, "\0339-$\266`\367\240\245\215\206\027\372x\252`\265\177.<\227\306\365\031\275\001\373\011*Nt\2434x\312\2426\344hK\336\275\240$l{\211O", 1000, "\030\363\332\336\2309\300\376\2105K\232]U\260\214I\315\372\310\005s\134\2602\367<\325\362\001uy\274\024\251\241\320\205\0200+\020\372\020\2508=\036l\371u\206\377W\306\233\317\011\034\007\335\252\262;", 64 },
	{ "\306z\302\361)\273\335\030\357Y\233 \371\307\225\013\357;(\372\177\311J\0321\030\215\300\334\016`Hp\000\031.\2527\270\223\320\243\022\255i\303/*", 48, "[\227\377\230I+\177\3633\223\205\206\332fx\307n\311?\330\333\017\314\311\260R\325\327YOA\323\267\227Z\271\255\217\363\310+'\377p\376t\011\032\024\370\265\036R\242\373\015", 1000, ",\020\2650\007=\026=\341\204a\301\0055I\266./[\231o\215T\212=UyCm\037$\370\020\360\003\335(=\205\355^\235\317n\035/\224\204EDe\277\373\240\312\267\007$\177Eo1\2219", 64 },
	{ ":b\302_(\317\016\2317B\264\327)\3143:\022\342\006\301+\232\213\330\306\230\374~\370\240\012kE\341s\335aW\251/\312+JW\027\263U\006", 48, "\3375\236Q1\357\250\336\333\006\021\304\360r\200C\021U5\340\010\245:\277\253D\271\370\334\030V\225\262\314\017r\3349\253\023p\324tn\325\244\207\271\017\030\260@cQ$\243\015U\004K\013U\354\033", 1000, "ic\217\365m#\204\032\232\010E\014\365\342\0233\020&\275\373\222\234\363\325\332\243\372\333\243D/B$\315\301\012\242b\274\2227=\267\332\014\2423ex(\366\000\246\373\345\022\210\275+)\220#\360\023", 64 },
	{ "D\315\013V\224+\374\237n\031\224'\255\013\232c\253\306\375>\262\021\031S\226\201\306k\376-w\361\307Z\310/+\217\354\275E\343\300v\012\244x\210", 48, "\020\347@\330\323d\010JOB\256\253\246u\216\337Xc\021x\267\205(\267\223\270\243O\207#\314\321?\373\013=#\364NbI1\376\353 y\200\2405J\271??\212\311\0110\343]-\367\367\2138%\310\037\307}:\331M", 1000, "\213.\303\017\302d\026\245\260\374\325\377\261\222z\035\373;\026\230BxS\007\270\331\223 \337\311O\003D\374\306\323 Q)1+\357N\200\264M]\376\207\335\007\025g\263`\004\363'Q\252\376d\277\373", 64 },
	{ "i\013]{\003\324\227Q)^>C#/Z\262\301\265\302H\322\351\253\270I\351\306jdR\201\307\204\023S\317+\362\215\225\275\217\312\245\335\263\002B", 48, "\347\245d\24117\217X", 2000, "\252\021\376z\035ajL[#\211I\212d}|;\340\330\020n\263\233\030\267\304\317\027\377\177\336\263\343\360\0338\274\357V&\232\302u\306Ni\245i7*\221\366\360\201;\363\003\3616V\250:\221\342", 64 },
	{ "!\264\005\243\327 -\361\350q\242\274\342\2628\340\356)<\202FZ\323w\270h\033\004\207!\005\362G\227\033t\377\376\243%\177\216\024\370\372h\330\246", 48, "\352\242o\245'\2623\223\200\042(Y\230L\320\226", 2000, "\355\002\347<.\274\221\344h\015\206\006(\237\036<\355\002\272X\346\332!\255\233\012\273F\243\202\252\042\004\204\344\021\253{&<z.\254hr\037\370\315\304\311\011\233\347\013\027<k\213/\373\261\247O\333", 64 },
	{ "l\274\276*e8\254J\371\240\245R\276\010\023\212M\353\255L\374\355p;Z\340e\364\024\310Q\355&\357\332C\327R\374\030*\030\365$\214\251\262\265", 48, "\013:\341#F[\241\251\0339q\334\014\322\373\242qr\222\010\253p\307*", 2000, "\306\301\274D\315\206\245#\224\343\326\363&K\334\011M\347\003\346\005\212M\011\276l\0209\340\203\336\264\223\272\353\261\362\342\377\002\261!D\252$>\375\217v\242\265h\341\224\011#\273\333\253\265\262\030\330E", 64 },
	{ "M\340\026\216z\244\214\273\267\211\2041%:\240t\355\224~\333\021\361;\271p8\025\220\007\377\356\333\213\206\037\014\320\253\034x\011oC\231\344\305ja", 48, "V\300$\325:\253Z\302E\030\214R4\216\327\232\315\2723\253\363\006\213\320\217\274\240\331\372\305s\227", 2000, "\300\357\340\235\202\210\212\275\015\205?\025\231\247\274\210H\300\263\317\2613\260\221h\271O\255?e\364\355\312\320\366\300'Y\321N2\317\253Ya\236)G\221Z\325\307g;\354k\014\271\354\365/\332b\374", 64 },
	{ "\375\212C\210Q\364\343)\3230\344U\330u\321J\021\357\233|%z\031\015\224\241\327m\017\327\222\002\233\261!*\363\227\262,\331\352\026\015X\204\276U", 48, "\353\2518\267\016r\004l\332\207\315\035\225Q\350.\006l\206\032'\016\333\214\320\363\351+\376w5\2366\373\012RQk\240\376", 2000, "[\320\320>\243{\326ur\261\213\262\233\332D(\015:f\345\350\311\373\331f\264=\035\377F\014\354\0119\003e\335\251\014Y\342h\2705e\257\012\253\330D\355\226\312\220\255\263\316\253\274IF\256\302\356", 64 },
	{ "\233L\025j\314\030PY\235@\036B\204\001\210\244\2427)\011\255m<\372 :\324\337Vp\024g\214\254\042\336\240j\367\322\003\367+\266(eK\206", 48, "\012b\352\220P\200x\257\204\203\205h.\013!\247\214\243x\255\203\215\375\200\042\217g\262Gn\275\245\222\217C\304\222\326\020\026\304\270}\031\202\310\003\001", 2000, "\215\256n\367\035\246VM[\303\337\002;\371u1j\3772\365\025Om\376\344\206\203\247Z-aS\367\315f\306j\272\034zt\223\313\317\267x\015K\304\321\024\340\214e\252\014\225\346\021\311\266y\377G", 64 },
	{ "PP\000\272\244\310c\353\031@\350dg\375\031\012\334\360l\235Z\306\031\201\024A\311\376\023C\261xB/\247Kx\210-5\042\234B\261U\025\235F", 48, "c\314\347\257\272\001\350w\215\300\317Z\254\214\231\266&\201v\245!a\032\305\253h\316\363NG\326r\271F\324\370\312'f\001~Lw\337\375\333\257\225\002l\315\022\134\305\246\300", 2000, "F\355\345\302=rO0\210\341-\350\007}5\237]\220\200\010\001\312N\215Y\252\374&\343a\011\012\030\017\220\324\377VB\224\315\307.\351\310}\372\321rl\277oX>\311T\007\321\312\377\036\211^\250", 64 },
	{ "\357Q\2640\367\013[\237\343\200\235(\262\251\2104[\000J\360\000\337\260\264\205/\273\016\033\005\373\036\336{~4{L_\017eNq\302\342\023\270\350", 48, "\035\320\035\370\304\326\354$\262\261\351a\327\357&\263gU\030y}\207^\200\217\270\316rL\335\304\012;e\250by\134H\042\325G\326\314\360\211\262\355\020\275m^\031;\350\020=\367$)\024\305#\042", 2000, "\275UOs\241\037c\027[@\215b\316\014\2558]G\202\346o\365\223\301+\226a\361\303\012\031m\304\244\371'\212\034-\036Q\264\374\317\241G\001f\211z\306O\225\360/B\366\0345\376\301\332\354\253", 64 },
	{ "\241\344U\007\300\201.$O@f\017\377\351>\243\003G\317\366\271\324\000\012B\235u\021\217\332\226\032N\2350\350\223\241g\303S\312\264\372>\012\257\213", 48, "\033L\372\351F\221i\236\310\273\3213\354\232_TrQ\266\310[\225J\034\220\354\236\205\360K\271\223\320\273\002\205@\313\335eI\267\232\246\236\3417\266\210\246c\244=\260\314\365]\367\312\246\010\202\372\015H\354\336\337)$f2", 2000, "\3719\006\261\234\375]Z\246B\227ji\320]\221@\263\354;\223\373B\252\216T\375\271\263\220\366\353\266\260\016\241y\261\217\2078\300\263 \204\331b\000\304kQ\233\363\250\030\306%\263\217]r\276\217\376", 64 },
	{ "\011\251\033\027W\032\0163\012\321\2718\307\354N\317\266+\246\213\235\254d\323\344\203\001T\2328\303\001\340\213\032\251\253\022\007H\223\334\250^\267e\357\214", 48, "\242\250(\362\371\203\3470", 3000, "\042jz{\220q\271\020]\035\344V\275\242\245H\266\275\212<\0156\354\231\375\252\263\362l\037\365\361\002\315\262m\246l\241c\270|\220\254\317v\042k-\255h\006\332\232\305l\243\316+\344\324U\200N", 64 },
	{ "\350\372\007\023\273Z\254\346\261\245&\340\367v\216\222\034\012u\277\003`\227\271Cu\015d\332D;\000Y\247{\273\313\250\003\024WVV8\262\325\314\237", 48, "\365\245\257\230\323\214\245\206\206c\036\016\026L0\313", 3000, "\230\372\346\242a\010!u\234Fd\303\013\324&\361L\036\033\344\240$\260\013A}\304\010b\323\321\177\031\326Ti\042q\312\276\223\242\254 \042\366\264\306o\274\247\310\367\005u\0322\2355|r\250\357\313", 64 },
	{ "p\327\375E\323.;\341\267\210\266\314\244\010\210n\353\204\352\260\221\357N_\042s\242\006\374\315a\013\276m\015\316\012H\257\307C|\215*\224c\235\341", 48, "\304\250-\345$'x\301i!= \226\320V\310\361z\213p^\225\033]", 3000, "\232\022\311\007\230\342#z\334\363\375\304\274\337\346\272i\321\333\304\301\320\341N\377\270u0!my\300\311\023\3241\255\277s\206-&\245t\245$\375^\347#Gg\332\015~%*\243fL\236x_\317", 64 },
	{ "\011\241]\247\315\307\354\015\314\272\351hk\3047U\354O\260n5\374V\023\366\353XmY\257\270+\276\364\370\333\273\213\257\216\2041\267\2101\320\221i", 48, "N\200\330\312\255\302\343\305\340N\326\361U\305c\242s(8\370d\276\306u\2260U\214_\215\367>", 3000, "\255\011'p\346%'UV\324\025/\215\356\265\262N(`w'\023\371\010\005C\272\370\331\325\222\307~\374L\016\042\027>\244\355{\001\227\246?\2450`\222\264d4Le\242o\323>\271\344\264\237\326", 64 },
	{ "\022B[x\327\005\226EU*\134\207%J9\322\366\315\277q\036\275;\027\277px\362\012y]/w\035;\014*\255i\356\364\034\272/ \217\234\346", 48, "\210\320K\265\034C\207t\341\010j\232\321\037\012\214\344\320\233v/z\244\206\375\325\303\327\324\325\350r\313\243\321\332<-\260\016", 3000, ")\377\352\240]\226\024\322\357[P\205j\005\234AS\2677\036 vu\034q5\250G\325:P9\311\021\344\177]\214\307\342\016\374p\234[\2658\370\351\267\237n\340\355EM%b\317efO\005\230", 64 },
	{ "\037\032\0421\375.\312\217\315%\333}%\301R\310To\202s\210\221\3768\216\022LG\216 \236\267\025\222\177\240=\014\013m\377-\271\253}\362> ", 48, "d\302P_\366e\211,\215\037\344^St-9a$\030\033A\235\004T~}5\344\260)*\205\031\312\215\305\221\330\3048IJ1\352\351\271d\225", 3000, "he\347\374\343\203\012\310T\325/\311of%\225\362s^\023\021\027dh\004\210\207\245ou\033\207\036\215:\006\015\3118{\272I\014{4\247\373\231g\306m\022\221\227)\211s\370\026|\000\261\035h", 64 },
	{ "\325\337\347\355~\224n\005\241p+e\350\351\034b;oP\302\025\342\211_\254\374t,#\241jSh]\366[\003\2036\310\2625\354\224+\276\207%", 48, "\015\371\213\314\256\360\017\223+\036\362\003S#\004\032\256\260\301\321\352A\357?NTh{Q\235\027\272\252I\216d\332\0320W\224\0204%\372!\265\313;\344\2342\365\3002\225", 3000, "\004\331\012\301k\262\314'@+*\314+\134!c\306\224\030\310\241\013=\017J\234\207Gr\304\212\220\032g\232\315Z~qg\217\336\2405se\260\355\177\302u\134\370\251l\213\342\325\207\207h\362 \017", 64 },
	{ "\2202=\274\020\024\341re\233w\032m3\255\235\237\234\253\224=V`\344\002\214C\036J\364B\261v\211L\236\246a2\365+a\212\300\375\3218\244", 48, "a\177\237Z\273m\345Q\025%2\012+\265\024\252\357\037f\271i%x6'\276\211*\373bKs\331\252E~\211>\010\215\020\013\256\322\205N\323\337$\251\342\017\306F\033=bu\331K\251\214\203/", 3000, "\035\344A\362\262 GZ\226\226b(\332\021>\336I\375\360\241\373QhAXD\247SM\300\205\362z\327\330s\017\351\257i\036\001\324\255IgD\3202\227\021\300\274\232\223\370\202i\033\311\260I\266\376", 64 },
	{ "\034\210\177n\354\347\241t\016\207;\333n\370w\247\036\226\214\1346\362\015[x^(\2728j\264\006\225D\240\217,\315\235=\246\250\012\3513~\335\355", 48, "F|\371\315\340\304\207u\251\277/\356\375\342\305\036\023\245\250g~\346\306X .\024\010\250:q\310\0231\307\020A\204P\351\004H$h\327W\015\024Z\027hi\226\323\232F\312\231\211\321\367\235\340\0053f\345s\031\315\237\004", 3000, "\342\210\306\337\352@7g\277\0363\037\232\2449W\324\213\345'6\016\325\354\247<\253[%\224\3461\3136\267D\373~o\255\344\215\211hX\313\200\217\240n&:Q]\257\343&\323\321J&\247~\256", 64 },
	{ "8\374\360\327\244\242\3112V\356\023\253\201\343J\333\370k\247\304~\341G\326E\021o\333\262\016-\233\134#E\3341bpM\001aD\246\230\027\003q", 48, "+\355\360\253\224iM\011", 4000, "\203\026BJ\336\023^h\371\300\255\212\342\245<v/\024\012\220xn\212\272'\301{y\020\202\013\370\300\216\267\020\345o\316\202}OR\374a\376\204\304\020\3279-Kba\371\033\247\013\254\261vq\024", 64 },
	{ "\357\023\232*\001\372\2751\230{\316\033\000\0006F\201\364\364u\217\326)S}+M\012\240\230\0128O\317\351\322\3323Y_\224\367\232\371\304\022l|", 48, "\336\226\337\332\234~\346\022X\371\312-\022\247\342\365", 4000, "%\217\250\325izsgW[\271K{\023\001\035y+M\033\221\374\302.\355\366\270'?\331\222\323\353k\207\213#\372\206\315M\004\235\134\332\225'\042\234\233E\2252\2318\016\277\134m\234~R\016\210", 64 },
	{ "\205\033\342\032\242\024\211-\314G}\227\251\023\004P[\277\240\311<\257X\337\032\276\302\3136P\000\265\201\233\3301[,\225\355\206\357S\320\016D.Z", 48, "\324\363IS\003\357[4\372k\037K\325\035\253ZE\233\301\212\213\003t;", 4000, "G\351\236\245\016\345\371\320\225\202;1u\201`\333\042\016\362x\355\317\177|\003\365\306\334\346K\312CFV\250\031\367*\367X\376\377\246\374Y:\260r\236BF\372\314H\345\0215Qx`\273\241\220\250", 64 },
	{ "\364\027mR\260\232XLw^\364\256\271\344'\301\223\216'e\021\220d\255\202\255\016+\210\206\244\0261\313h\034\371:\377lP\273\025Lx\247[\365", 48, "\317~\373\314\230\331\321\003'\012\363\274\343\370s\350\324\321\256\206i\323\315\273VE\310\032j\223\312\037", 4000, "i?\351\304\337\377&C\367bm\253^m\335\311~|Rj\244\225L\302\237j\311\330\2759\234\276\343\241FmO\024d\247\301 \314\011\303Gu\177J\311\3435\272\004oB\2203\325h\212\235\001\370", 64 },
	{ "\246\201\265\310\201(\371\206\011\310od\207'\360\134\226\366\025\316J\217\005]\357\240\020\331\242\042\366x\253t\343-\017\245\261\373Z\327;\023\205\233\360,", 48, "I$\373e\314\232)\033\256\376\322\324\234\213%cb\266\313\271\003\235\011-s\360\310\033\225\326\263\211-\2736\337\341V\307\302", 4000, "\012\003[\344\302\016B\006\036\370\247n\236\325\204{\312e\304\321\320\342\031\353\326\231\212\010\237\007B\334\245l0W/\327\342^\331\312\2517\261,\215\027\310\010\343\2025\3477\013\271)\345\177G\3765,", 64 },
	{ "\231]\314\344\213\022\042\205z\247\246{e5\362\243\330?\032<9\244\374\270yP\025\261L\014\223J\0228\270\352&\034\307\231\202\337\031)\356\201\032\012", 48, "z\200\004\375\370\325\264\223,\022\271\014d\354\005\320*}\206\375/\365\306\333&\032\255\337\276g!\007\034uIhI\311\247\312\244;\307\204\317\306y\277", 4000, "\327\177\031G\255\205\003\021\034\242\022\201X\002\200]@^\322mi\245\320p]L`\266\252\302\343j\134s`ku:\360\367DHnT\2411}\346(\022\036\315\266\362\347SKdh\213'\204 \016", 64 },
	{ "\223&t\237.\0160\037h<\244\272\326lA\017\006\301\367c\042>\242\212$\313\275\010\022q\317\023=M?\245\3243f\242^)V\011\001'\321v", 48, "R\134\353\337\330,\216\250\301*\3737\0046d$\362\331\335\366\362HZ\236\213p\247\214\241\134\225\304\016\200p\234B%\332\372D\377u6\226\017g\354\233\232\014\2565\2067+", 4000, "'\035y~\311L\376\346\274\277s\377c\376_lgN\042X\313\265\257\207\042.\264\262\016\023\006R\326\332<\000\013[\001\023I\224\134\007|\277\203,\322\353cF \331E\021\331l\217!\220\221$\365", 64 },
	{ "F=\037\315#\006\331\015D\027\243}\342\276\200\275\364Q\265,l\353\350\011\021\234U\026\333\260\372\274bM\244\323\344\001dt\347~\265PFr\301\252", 48, "\007\302\227'\205~H\223\003<\261\020D\200\337\311K\216\017y\360\204\337pxm\323Po-\275\304\207\032\314V\310\247X\254|s~\313\335@}i\371\226\254\374\304C\215|\327<\023S\2637\330:", 4000, "\012\324\351\266\333\245\343\256\371\303x\256\005v\321&\235(\235\235B\240z\352\335\266\204\344H\312\030\306\221,u\021\343 \365\005\204\023\330\001\202\271v\355\215\254\363j\254'\327X1\360\201\252o\034LU", 64 },
	{ "\023\234F\343\274\225qk\015\243\251\233\275\030\345\306\312\253\305\027a5@i\226\232J<x:*\325\334\230\306jb\273\315R\210\231\302\223\370\216\007i", 48, ")C\310h\001\024\202\337\375t2\222;9\225Ut\204G\017\012p}\134E[\376B\371\233+=Jqj\215\210L\367\334\366\241\374\017\036\032\201\324\003h\345\022!\370oW{7\212\377@\374\264\363\330-\013\2515f\242\327", 4000, "\200H\231]z\021\355\235\325%\2032\355\177\341\361\262?I\042\314\031w\306Z\203\342\265q\266\010\376\257V\377\364\326J\314\302\032\357F\207\371h#\276\266IU.z\242\036\2219\332\303\035\343\042\003@", 64 },
	{ "\243`q\363\217\265\014\242\232\340\356\222\246\3719\025,kK\360\210\012\226z\370,pV!\375?\225;q2\340\213Z\261b\203&\314,\177\264\260n", 48, "5J\251t2B\353\337", 5000, "\3733\350Za}\257\370\210\310u\363e\234\216F\255\222\205\230\212\367m\303\3756`\015\023v<\203\215\240\360)\275\370\274\213*%m0\350z\354_\3135\261]\265tV\134\255\377\357\314r\324\217\226", 64 },
	{ "!\351\373\2400\311\327\326\217fW[J\246\207\300Zb\352\320\366i\234Sk\275\372(\343!\261\227\273\305r9\372\000$\270}\304\020<_\231W\232", 48, "!Q\264\271\377\245NB\344d\203\015\206\306o\005", 5000, "\356\265\266\204\011\266\353\022\304\037xoV\320\350\3215\373\350\305f\020q\307X3\202\356)\346-\375\017n\265f\376(\015\262\366b\3703\024'\265A\242iA\363\134%\011r\344\261\012\340O\031f\232", 64 },
	{ "\241\315913\212\201\274\363\366\203rR\0043Z.[\204,{\321\210{M\212\000\310a@\2032\303F\256\251J\320;CQ\022}\225D\202\367\327", 48, "\016t\343\351\005\223\2432\311\257\2026H\004\2600/\324\353v\331\305\335\373", 5000, "\032\352i\346\351\034\370P\347\257\331Lvi\315h\226\026\352\026/w+\021\022\204\010?\201\010\343X4}\361X\372\275m&\312Z\330g\003\236mP\026\022E\356\031\300]@.Z\33603\352G\355", 64 },
	{ "\337)\013{\377\265{\015\2248\250\226\241\243\237\004\266\374\037\033>\343\242g|qW\267\315:\377kB\352h\357|\252+\362O\376\305!1\015\320\235", 48, "Kr\275\216o\247\366\204\374\356\325\271$P\244\030\0234\347\212\332\246\337\236I\273\134\210<\006\266\263", 5000, "\370\355\024\360\323t\303\313J\336\317\261\275\231\002\363\366\250\222]\007\367\367\240\245\271\177SZ\273\025\034\326qy\234H\007\261P1\345\241\327\313,\2257\004\345\255\036\2435\220\244L\024gF\326\210;\016", 64 },
	{ "\213c\353\311\230pI\234N\210\337s\351<{\011\206\001=\331\330^\024\341\004\202\351\210\330_\264\334E\233\376,\002=U}r\014\246\210\254\272`t", 48, "q\237\222\276+\321|\252\350S>\357%2U\365\355\314\213\272\2704\037\276\346j\342\352\226\225\366\273\030\353=\236\234M\230;", 5000, "\324\240\327/UF\025\207\247\256\031\207\333\020K\320\331\0038\221\217n)\032\310$\235\345\027\373\233\247$^\206[\274\211Z9\245\002\344\010\345\277K\300\201{\317\304\204e2\027&\301[\213}\020\270g", 64 },
	{ "\352l\231\276\004\222(\213@-\210\331gUw\021\350\216'\036V\204\271\373[6e,\225\246\3039\030d!,\222\226/Q#\351HUT\325\245B", 48, "z\356\375_\243'\235\334\0145\211\240\031&Y\256\211\205T\210\024K\262N\235\021?\211\014\305]\345\271\337\341\213p}=\306\027\203\220\303\273TQ\315", 5000, "K\037\010^\360\223\277'\320\341!N\015q\037- 2\363\277F\177\304n\221E\272}\364\231\333\340\003\030H\014\027\213I}87\214\2126\204\272\235\326\232\0349\371\312\311\334\262\341\257\356\034\034\233\042", 64 },
	{ "\323\332\347\327&\217\310\364'\3106\2004\223\013\330\317\201v\306\357{\246H\315\260c\274\334O\356\374\234\272\021\311a\251\233nN\252\326\226\343r\276G", 48, "\245\374\354p\243\215\017\253\253q?\323m\006\333\335\311\223IC\033z&\370\177\245\363\042\202*\363\0069\216\343\353eY;=C\013\274\022z\233\011]\374\352\250\366\317\267\3122", 5000, "s\376^^}\223\305-\342\007\035\301):\022)k\266\363\037kcv_}\310\345\223\324\361q\355G\300\365\242\266u\213\275\252\246\022Tha*\002\262&\330\005\366&\011\223\025\217\347\035\134\2571\365", 64 },
	{ "'\355\206\021\304B\220,\312,1\246/\371@>\275\032\265\313\014\223\366\343\310|\000\210\331<7\375.k\236>D\325@+ {\017\254\343\255\267\272", 48, "\365\271\004\226\353\033n\356\215F\020R\271\301r\254\335\357\251\256\211\021\015R \375L\372[\327&\266\207\350\304\230\226\246\276\333G\240M\234\316!\361]\313\017V\316\300XIM^\366\234\252\042.\227\007", 5000, "\030\024\256\214\270\375'\000z\200#\000\342\203\321\267I\351\212,\357\3654\231\213`\264[`K\347\224sC\321\303d\347S\245\336\241\330-:Bxe\370\002\264\265&\335=F{\362\025P\324\214OQ", 64 },
	{ "]0\343\335\304\302\210y\374P\037\267j\222\3041\375eq\216\007\265{\327k\025\205QV\274\002C\300\272@\262\316\304\302\260\024|\237\261U\274;\304", 48, "\346\021\323\003\216\205t\265\022\345\335W\352\347\346\324F6E\227\201;\012\262\372\304\255dPhVx\277}\011.\001\255\004\232\356\031\300\313\247Q\034`\225#\025qq\231\207nM\222\370\207mI\216k\227D{\304\342?\322\367", 5000, "\264\246\376Y\226\205\015\312\251\312=\370Y\213\241'\375\372\275\202\011Cg\307j\320\312\2272\377\302\240\232u-oE\244\222A\036\0045\322\221%#\212\036\014\263\302\366\326\333\376\035aT+C\244\302\335", 64 },
	{ "&\314\267\351\254\337\360\243|\246g\134p7\225-\222\352\376\325\207\333Q\306\217\230x\247]\134\375\037\273\360\373B\235\241\333\236U\007\315\005\250\345O\035", 48, "t\335\342\323\366\315\332\216", 6000, "\340\342\325\222\362\036\255\2425Ep\336H\004\027\315\256\270\275+Q\224\273\256\230\036\303\351\035\220\023\326#\270\342\265\2144!\320+U=\200C\326\367\012\343-^r\305(\255\311\2550b\014\013,C1", 64 },
	{ "r\226\021\010\302\035\242\206Iv\266,\365u\252\220\200\200\311N\366G\25216.Y5j\234\023W\006\326:\254\007\222n\314\037\334^\244@\020\2737", 48, "J\220\003R\307\360\321\302\352\204\255\226\271O\352\332", 6000, "\374\236\255\373E\223\332\214\005\205\320\376\311\314\214\366\326Q\314z\220\264\035\263\031\201q\360\007L\235\205\014\307\256\241\342\230\027?+\364\001\263\362\346\016\355\300P\033\201\365enL\223\010]`\262Lh\210", 64 },
	{ "L;\320\273\354\350\215;4\315j\215\244\020Ym8Y\220\042\235*\315\303\340\317\301g\231nx\226e\253\344\033\317'\241~%\252\241\225n\375\016\361", 48, "\017\357\243\317\226\303r\217\325\237t\264\2722\236:\221ov\211q\316\304'", 6000, "\337\331f_H\255\303\312P^^\373PR&\322\000\3774\337{\251u\2611,\232a-\021P(xPMnO\335\3768n\246\207\307\015w\367\326\210\022\303\013\242u\316\325\254\373\363\223\340\235\3568", 64 },
	{ "\026z\355g\254\372\266\217i\200|\033\341+\333\302w\014e\257a\261\235\233=\360\325\206\361\007\245;\004P6\201\307\272\3722i\333Y\365\2472\004\357", 48, "\203g \356\266\241!\202M\221\302\274\374\222\227\2624=\3567(\304T\030 \034[\042\313\321,\353", 6000, "^\326\234H\2378\261\330\300\316=_\220\206\013N\342\376\352m\316\311VD\021\237\273\213/\341\362\341>\246\200\037\375b\013D\242\226I\324\253w\266\036Q\015\366\032\030\337\033\042,\033\020\002\254\354\032\242", 64 },
	{ "\343\340C\210\270\266$\260:&\177c[$\253\002\002~\312\023_QP\314T\343c\260\322\315\325Z\001\311\313\260v6\367J<$\023\231\263B~\321", 48, "|\254\3234\277\240\314|\231\223\315%\307N\027i\3460\277\353\341\257oJ\350\007\313[b\264\373\320\352\013\323D\310w\374L", 6000, "\276?Q\275\236*\251p\201\300\011\221f\203b\316\220/SF\371TjN\241\354hM\244\263\336\360>)Q\3546\312\022\247k\042\207=\216I\230\324\242\202\242\372gw\034Gk\357Z6\277\370\336/", 64 },
	{ "R\361\275*\210\356\262[\2123\366\242\260\237^\2774\177V!\237\033\303\032\034\206\256\346\021\357u'\215M\241\026\305\350\3443\015&\003_n\247d\327", 48, "\311\353\274\027EKE\022\363\277+\202P\324{V\201?\220(\266,\344\216w\024l\263LYKx\214s$\3730\354M\002\371\234\015\201\305\035\012M", 6000, "\344,\004\363\340\373>(\311\007)\224J\235\227\177\373$m\252\205G\011\205\301\276\222j\245\360\316\262\214%\220\272Q\311\246\373\335\343\026\317%\245\223\330*\005\025\215\304)\370\031\363$<\030\217\347\302\035", 64 },
	{ "\342\000.k!\021\356\317\366\030e\177\037^\321B\177\272(3\267]\3522!\323\025\263B\365L\343\245\343\277BdJ\334G\255\230H\354'S\316\227", 48, "9\223\367\206\021\213\002\275\002\235\362\017\016\306\277J\314\357\220{O\1340\026\233\310\267g\276\322\205\023\347\343\357\024\361\263\354>\324\226\336\303\243Xr\3423\324\245\243\034}fL", 6000, "\277j\214\037\253\214\326\003\337pzF\020\200\307\210\002T\256\214\340\356\266Z\261\262\220D<V\266\316T\361\0337\273\337bj\215b\251\004B\310\037\216(\272\363PV;<\256\227S\350,\017\373\042\263", 64 },
	{ "\201\211{\341a\230\360U^G\377\226\217);\202\371\230a[+N\361\005\035\261\365\021\322\023H\256\346\261:\3271\342\367~m\350K\372\275P\255\305", 48, "\323\277v\210ie=\134!\314X\220\223\236\370\033\213.\2469\331W\262A\275\364\015MK\347\357\2207HDR.\300`yx\270\042\351m\235\356\255\033m+t\240\310z\225\263\327\177#\037\236\372\302", 6000, "<zB\316/\266k\375g)\2221\310\273\203\030Z\270\326&?\235d\260\326\001l^\267\2221\230\227,np\1345\220\330$\340\307\315;\373\252\372\250\342j\341\025\201=\236\300=c\034W\375{\243", 64 },
	{ "\362\024\344Z%\336\260\242&f\027\317\242g[Q\261\012\337\274\273Y\227\277\342\202\011\341\030\363M\347-\271R\312\315G\203\276\327\212 \035\361\016\324\363", 48, "\030@\373\337\177T\302\006\362\220\253\315\232\217\237H~\336\212\017\320\226w\014\314\232\252\315\351|\215\263\357\016\025?\200\241O\375q\362\3135O\366/\270\202v>\264\003\315\362$W\333\271D\305\223A\330[\302\240q\251\211\350\235", 6000, "W<\311\356\037\256j\327\035\206b\373\235\343\260\363$\224\3011U\214\334\247\035\241\037\326V\235\270^\346\375\375\251\042w \222\302\0153\202\017>Fi`\345\210Zt\014+\305u\204`\004\326hI\306", 64 },
	{ "\207\335.W\320\222^,#\374\342\226\224\016\236\210Xx*5R\005\0368G%\357?|\305\355@L\032\372|j\020\376\251\275\336\351\230%{Q\222", 48, "\204\232\373f\211Nj\361", 7000, "\312\237\260\312r\315\032\210jz\302I\276\243\250\265/\027u\037?4(i\216\025G\352\033\272\362D8\230\304\304D\007C\223\335v+wm\371>\244\313\275\223\226\255O\273\265\322\302\026\266\210\033,\032", 64 },
	{ "\351\315\015\007s\036N?;K\276\313\305\027\3443\241`\3168\353\264\273\021N\000x5m\020%O\372\011d\210MeY\303\316<8\033\026\027\330\274", 48, "L\250\331\250\232\324\035\255\344\227\313\334\367T\221\343", 7000, "\345O\261\350\203\357\344\350bs\264=\3658\343\337\373H\266BtY\252\352a?1\330\244\323\366w\357`\327\316\312\253\327Z\277\032\330!)Y\277\270\214Hh\372\277\371t\017\365j\246\204Cn\257\277", 64 },
	{ "\015\316\026\222\224Vf0\216\243\304\215\330\317\303\245\261~\333zMF\362\033q\266\2464\351#\206\247\244\002d\315H\356IV\200\226\352\023\230Lr\220", 48, "\201\320\347\200BI\226\316\323f^=n}\360o\302\253\021\364_\017#\230", 7000, "\263\315,\274\011\320\250\250\204a%qyyc\203\305\334;\271;\226\307\342\337\331\311\252\211\374O\211\222\3216\275\355\335Ct-\357nS:W\367/o\330\263\026\033\026\220CmA\011gr@\025\270", 64 },
	{ "XxQ`/\267\322\333\311\314\2604r\247.,N%,<\343{\260]\203\213\224\341e\267\016&\300%\223\372\306\356\344\036m5\376\277_\307\215\365", 48, "a\322\236\225\2352\213D\371F;T\265`6*\242\252\354\005\254\235\222x[\026\373{\347\364S\311", 7000, "\037\000\251\334x\275\265\323,\026\256\3703\206\375:x!\373\337\270\306\005\202\315\354\015\3161B,\235m\366\267\037\374h\273jgM\244+@\366H\217=\223E*\203 \372p\214B`\372\223\250\355(", 64 },
	{ "\320r\000A\354\217\332}\235\330O\006~\362\321\212\242!\204\377\275y\337[Mv\355f\370\334\365\207\260\247\262a\355\353\306\323\207\305:\356\023aE\227", 48, "\006\374\337\262\336\367\244\022\313\134\371\266\263\003\206\301\262\300\260\217!N\274\352Z\031\267\376\264\305\024]\027XK\006J\244o<", 7000, "\275\245\364\263\007\213\236a\353{\250\227\231\027\263\320\254\216\376Z\275\260\311\251\001O-\266\364h;\001\236oZ\035\211rI X\234?i;\013\330\267\254\223\310\001\367\327\216lU\371\212\277=x\334t", 64 },
	{ "4\253\333\315\017d3=\373D4DP\354\305eE\237uAh\337\2405\362\3017E\345\377\225\222\345\321kD\240\365\222\334IZr\011\277a\307T", 48, "\017\205\042\033O\271\030)}c*\006\037j~\34208\276\254\373\233V\266Y\317\2051\215\277i\003U\375>\320\234\334$`\271\301\251Ir=]\025", 7000, ".\331\203H\033\314\212\327R\264g\305d\305\252IS\300\202\265\017[\263cj\353\222\274\363\302\245\326q\270LV\257\262\177t4*\177\213\365\347,Xx\027]\325w\210\362u\205\334\305`_\343W\251", 64 },
	{ "\302\357\007k\362\234\310_\213K6\226\006\311\313\342\227\347\226y\210\253\273\302i)R\305\001\365o \335\206\030<\352\311\030hL\361\320\342\2430p\201", 48, "\216v\267\216\340\203`\177\232F>^~\357\222'\013#\032?*?\025(\206I\307R\227N\235\214r\266\202@\242\202\215C\356\246'\014\005-{I\331\367\240Z\224\227\247\360", 7000, "#o&\232\242\232\323\234\371`y\242\302\373\002\276\300\013\255\272\225\242\261\223\354Vvt?\372\034\265v\357\375\206`]\236\376jl\202H\207\272\250E\304\005q\357\220\300\335A\266\316\314(\377\000$\204", 64 },
	{ "\221\031\331\246\220\371y\353t\234h}\010\235\134\014\244k\273\274@\224|&\273R\254\223\012>D\333\025\273\262\012\222\370\255\201s\234\262>\311\345y$", 48, "\252Q&V\341\266\330\215E\337c\302yt\227\314\264\036c8\356\240\026-\250\0220\271\203\311\326\260\320\262\007\375q\242\200\323\345\042|\304\367I\231\202\333'$S\245\252G,X\343QRK\3553X", 7000, "\027\3340\256v\217\244\245}\245B\350s\270pF+\037t\340\3040P\325\224\2044\006,b'T\235\013:\367\273\336\255\227\230Ao\243\355\251^\324\370\325\307J\202\275\004\371\256\321\260\305hIF\023", 64 },
	{ "\325S\032^\015G\353\362^AO\356\302\266\246\251\226/6\276\271\210T\320t\252\362\034\314\366z(q\005\031\033\342A;M\235q(\005\265_\332%", 48, ".\022\232\355\300\311\020\276\304\300\331\006\273\224\244\305Bx\306\317\245%2\331\266\201zR\376oei~\325\255\025\366\320\356(\315\216\024\345\001\021O\2571G\222\244t\012\230]\327%n\353\253\3527l f\356G\364\345\213\315", 7000, "\324!\305T\363L\134\004I]\010Z\335\242p\250\335x\240J\277U\270\231\027c =\335UU\365\266g4\003\360\025*xa\304\264\017-\311\204\236\355\341\273\212\252\320%G\356\240\344\034T\267?\217", 64 },
	{ "\326+\305]3\260\0238\247\332\3650\203\234\222\232\272b\202\012\022-\363Z\022\313\261/\375\242\323\227\327\203\033R\322\221I\232\274D\002\305\207*\320\207", 48, "\322K\205\015w\314\267\314", 8000, "89A2\310\212\272\365\307\347\023%\263+\263\307~8\240\335\350\374\013\000\304\370m\244\346\311yH\273\020\002\237\366\362\346$\021\027\320\277\327\361\353^Y\024~\1340\037\203\002\035wS\273R\244\274a", 64 },
	{ "\356~cy\304\371+X^9\335\304\257\0078\262\274\237\212\326RZ\213enC\237\225$X,\265\177\226\2052\275\025QU\002\203\204'8E\230\277", 48, "\362\356$\042\252\310\332\267\355\011\303\374\341\317\023\351", 8000, "\022\336\207\312\365\207\005\232<\303THN\303x\275\201\251\320EQ\363\337\253\242H\227+\346\003W\235\321,\3438\227\205\244_\376\252k|\004\373\370\271ZY\341\332t%\235\304;.\377\343\352\310\230\334", 64 },
	{ "\203\020KLv\231\231l\311\355\270[\202H\231\350(N\333=\223\020$\271\350V\005\361!\254L~^\011\003>\223\313\216\314\334\363G~Nw\001\315", 48, "\200\016!Cw\267\245}\322\354U_*\331\015)\375}\273\2213\373\314\005", 8000, "\307\340\243\202o\300\337\213+\0209\266\311\252\251\036\371\2202T\000\037\220t\224\255gD\362a\327\314fU\246\237s\006\237\376\246'm\0250\370\206\373\234\247je\347J\256\036\004\003fB\247O\011~", 64 },
	{ "\002\342c*n\2159\201\361\007\267\221\245k5/!R\224\257\201Z\352\271\256!gJ\3163\323\204),L\204\256\257L\233\221\310\326\357\016\334B@", 48, "\255\352\265\017\375\006\365\360\372M\376\355@By#\313\251\177Q\277.\235\015\230\261\015\002h\220[\315", 8000, "\314\310\364C[\214\206\177\205\313l\373\357\226N\226O\231\005\221\251'6\257\036\234\014w0Y?\330\017\024\030\245@\015\232\373\323\361\2165\360\273n\311\203\207\313t\012\360?n\012\374\370\2178y\250\340", 64 },
	{ "F\220,\342\271\325\224T\276\021\206\271\276\014\204\027*\002T\030\003%\251\226N2\007\274\235dKT\341\320B;\220\042\021\220\240\313\025@\213\361|B", 48, "\2715\352\303y\267\260F3\042o\376\220\241\370\322+x>\006}\011\237\26568B\355.\333\217\220]\352\205\314Z\033\024\230", 8000, "\325\200\311\010\255\014\015\012\0312\227\023t0\010\257\036\321\035Ub\356\313\263rW\246\023\370\021\134d9\251\225\366\253\324\035i\003\312u=9[|F\375\343i\251\274m\2166\2128\355Kr\021\036e", 64 },
	{ "\3470~>\252\201\367\3254\2660`|\260\265\263\306!\004t\241Z\312[\234\240\316\272\001fLF^,k\034|(\360\201W\351=`a\2559+", 48, "\203>\324\207\242&;\023\272Y\300+\357\321r~\302i\341\336\335Y\271Be\313\260\345#\315\361\373C\207M^\013\276h\231{{B\255\376}\237}", 8000, "\023\012\014{u\274J\027\303\022\322HV!\015\321\376\204\332\301\306\001sN\366]\215\276\237\206\257\314\245\004:\225\260\221\327^0J\351+|\334\376\323\002\355\302\310\000\012\361\252\307\334%\303\340~h\336", 64 },
	{ "\322\200B\315\306\217\003;o\030\200\3471%$\366\005,\332wno\352\224f\360E6\215\240\374o\212\302\352\366\321\310};R\334r\265\307\356\0129", 48, "\301H\225\260?'\355,T\004\020\030a\360\221\340\207\021o\014\027\246I\262\351\226\342Y8\017\3427[\372M\316e\034\343]\335}\334s\343\006\322\255\345k>$\317\243j+", 8000, "\331n\235\013o8\255r\261\356\317\262\206\337\206BU\272\272\042\207\372}H\252\332\331\337\033\001\336\372\364\023q\360\313\020\250k\315\365.\134\201\316,\2169\3411i\357^I\204\325\374Qk7\315\205Z", 64 },
	{ "\240\276\020c\257\224(\207\033\214\361\277K5S\241\177xl\335\266\325\221[\005\220\031\376\264\277Ip]\251t\220\240a/\260,\277n\365\254=OO", 48, "\231\006\313\201\376O(1j,HT\376\334\306\242>b\356\347\360\350\353\326\033\206\252\277\021\216P\037iN\014\341\371i`ZR4\016<\215\245\013\020\255@\002\267\035D\352k{&\2365\273[`C", 8000, "\264\261\232\201\346\355\306\350\271{^\217\276\005\237S\202\320\020\322\205\334Q\345z\210\357P\217y\216\2704\015\357'\254\021\234Jo\355\322\037\0423\363\027o\227\345\316\3609\372\310$\307\236\370\322K\213\252", 64 },
	{ "{\262\366\317\260L\3010\312\213I\2542\251:\314\317^B\355\011|[o'\316\312\300?\221\021\331H[\253\2024,2\362\332\021\374g\252\221\375\213", 48, "r\254\355+\274N\204\306\266\333\332\003\272Jrn\324\352r,\322\376\253\363\031K\201\312\004\277\356V\212\231R+\306\230\341\242P\306U\014\357\227\220\306B\302\230S\211\030H\240\311\214\247x\340\033\032\302\134J~\212)}\315\324", 8000, "\336?\2265r#\010\232\375\031y\371Z\024&\357\366 \263\024i\234\316\233]\243\222\353T\224\002\005\015`L\227]V\361\256\012\203u\004\002\312KT\003]\241hy\001\306X<\211H\332>\357\210`", 64 },
	{ "\327L!\213\262\001-_\342\022\310\370-\277\240\035m\200\025\343Ae\202\257N\004\355\017\307\362^\035\325\356\277\013\271\001\320\266nda3\313\346\336\337", 48, "\303\376\271%f\011Q\244", 9000, "2t\312O\303\020s+ \231\346^\312\273\000\330N\206\362\226\254\206\362\315)f\357\316\034\002\005 \250\306\354=\336\247o\313\312a7`_\242c\356o>l^\034\267\032/d\302Ru|X\331\272", 64 },
	{ "N\326Q\311\276\010\312\331\314\341\234\342@{YA\252\3404\314\031\2613P\020\011\330\310 \224\177\030\032\247\262w\321\2302\370D\006\235\027\360j\034\042", 48, "\365\031\352lZZ\210\223\223\202\302\3472'\215e", 9000, "Q\271\224\222e\316A\255Z\177l\026\030NT\242\263\3773\025]\376l, Jk\134\221\025\316!yj\270R\242q>\260\277A\213Yr4\211\354\345qH\200\134\304j\026\030\275vG\042`\205\234", 64 },
	{ "\201\345\257gf\2623\322\007\016\3369\245$\351\216z\224\311\217;s\202/\002J\364mr\312\262\315\270ytO\001+$\273\205Y\327\212r\322\177\230", 48, "d\210\377\354v3\326\227\321\200\315\340K\022\035\2222<)\035\336\325,\376", 9000, "\013}\246\202pG\243\307! \277\177z8\307~\303G\223L\317\225\312y}\320;\033\206\360\243\227\035\374\253b\252\035\235c9\200\347@\262\231\313\330\301v4\222n\273\221M\016\025\326\331(\243B\316", 64 },
	{ "\205\031N\267\2314.\365h\210\246\265\323(\221\367f\211\300&\303D\036\251\024\331g\354\344>\001/BJ \246\226\003C\260hj!\210\343&r1", 48, "2\315\225\207\307C\267e\233\013\261r\234Sz\255 #\316_\267\355\345#\361d\376X\304S\330r", 9000, "J\222\216Z\305\020u%\261\3464\220[\353\254\271t\377\2558\313\312\262\302\341\001r\037\335\261E\210P\010\365Xe\2034B\377\254\003\256$\307s\213\000\033\371\377?0\255\031\225GGO\274\370W;", 64 },
	{ "\346 \313`\013\340\264\251M\026\365\376\001\371\362]\244\256\335\203d\355 H\355Vt\305\235\034b5.d\210\211H\317\000\001O\370\177\317k\355\277\015", 48, "8Y\351\207Y\302\312\327\343C\206\335\011)'G\206\272\366\206\037\320-l\275.$[D<\312\330\032\232\236\037\265\361\243U", 9000, "!\217x\241we\322\037-\177\375B\222Na\017\376\224{z\250\254\235N\263\355\351\215\223D\006J\366\262\342\277v\262\335\334\2752\336O\360\250\256\324\300+\257sA\257\205x\375w\271\016\263R3\006", 64 },
	{ "\214\275\361}?2\257\011a\256\243\362\270\356i\270\260-|c\227\311\0175\226C\355O\006\201R4\027a@\004tpx\271\256\371FR\016C\012d", 48, "\264OAA\274\375l\304\035\255\222\230\340KX\003\237\270\240s\134\035\213\360`#\253\256\222\346c\234!\311?\245\036\2402\225\267\033\214\002\251\266\325\363", 9000, "\221\257\256\354\355@5\025\375\014\230\203\257\005z\235\355<\316\312\201\306\265\264\376\233\001\315a\340\033B\260u3>\350~\360q\017\233\367\2368+\210+W*B8ZA\225i\313\364\3755\260,\355\021", 64 },
	{ "\024+ob\033o\000\317G\244\001\341j$\271i\270\323\214\227\313\362\022\236\230\333\002I\374\206(o\355\352\223M\367\360\015\134rl\207\275\345$%\261", 48, "\014\212\304\314\363\206\374\206\042f\035Po\265S7\011\337U\275Y\3268\271!y\255\222w`\321-(\245\314\275\326I\204\004l\251\312\3308r5mWq\302y\031\204Zd", 9000, "\007\242\343\025\014\305\013\374\007u\334'\006@\026\301D\330\241\252;00g\200\326\300S\335\327\212h\316izd;\272R\225\037\003\032\272\362\201\351\012\370&\356]m\024-\260\270\250\205\1340\374\277\311", 64 },
	{ "JO\370\260\3003\320v\033\332\353\250\340\303H\305\276\010\002|\236DK\246\312B\2345\0427~\244\341\021-\226\260\022\134\225\134\134\342X\216\320>f", 48, "o{\276\324v\343\323_\217\010\307,\371\337e\310\260Kmn\277\351\034\022\260M\226I\275\241)1uFY\372N\375\037T\234\340P\355\276\313+]p\035@\0068\301\215\207\020Xry\302\267\265\212", 9000, "N\005L\3772Y\243bo4^\207\034@Nvf\310\340\342\306\254\3429X\207uVK;\210\346\206.\042\271\013\337M\341d\352\234\335\020\371\316\034\271\134\350-\343\263\234\014#\301/\215'\017Vi", 64 },
	{ "\312\367\010X(\322\245\2355IP{\034\252p\332\316\012\224\311\245\366\216\355\261@\042C\341\134\273\021|\351\223\221\375\336\255t\011\022\372\216\370\333pN", 48, "h\201\327\177\322\026\243\273\335\206c\260\337\2178J\247\022X&\314\347\356\2576Z\371\012\036L{/\324\205C\227\352A\017\346(\001p\322\354|\306i93\274\360\214\302M\331\134y\375\021$\376]\021\333\272R\335\261=?U", 9000, "D\220\257\020#\326,%A^M)\203C\031\323\315\212*\366upkT\346(\276\340\033\351O\236T$D\030\345f\340d\370\000\325\263\372\336\246:q2\253\216\236\316\222|\273\215c\013\035\341\346\326", 64 },
	{ "\012\0021\2554K\025.\250L\177\034\021\271+\217\314\267\312\217/\201jW\304\134,w\371\030\026~b\345\252\032*l\307A\344tG\201\0277\272B2\274\342[\213\353\232\225", 56, "|\330\307\300\344TdF", 100, "f\325\322\343\327\376\252L'bX\232\025\242\260ML\370L\351\012\200\235s\234\346\035\254\214\346}H\307_\350_)Z\252dw\017a\003\323\320\2130I|r\263\260\252\250 *\314\275\316W\213\365T", 64 },
	{ "\265\277&3\336\000p\271\375\024\027\035\316\001\254\254\335?\211A\257\330\023z\275P\334^M\355I\361a\372n\220\236\333\226w#_\241\242\004\355\220\377\317\0139!]l\232\354", 56, "\303\322\337A\240\361\204\250#\325**!30\366", 100, "\261F\372\232\217\353R_7M\315\363WC\340/\014\244\373\0326\330\231}\007Yn\031\274Bp\310\200,\253\020Gq\225\237\366\265\032w\213&\343\345\320HG\004\237\312\256\225({\042\352\220\364=\232", 64 },
	{ "ZM\361\367F\257\262^\035/\022\245j\330\256\256\347\246\267\320Tb\231-\224\322\223\264qk\035\0316\326\236\010L\300w\326\031\376\304\246\022\335\200SQ\234\031\023\320\271\030R", 56, "\263\213\022g_7\373\002\213\266\332\344m\215X\035]K\200g\014I\251\370", 100, "\260\220\236&>k\310I\270&\302\250\246%\326x\371\213F#\265\251\221\023l\347\253`\253W1\240\300{;\200\264\213\251\003\240O=\214\240\001\214\227%\271P\275 ;}\216\031{3\237\203c\212e", 64 },
	{ "*\255\343C\246<&\316 i\270\001\022~\347X \214,\255R\322\223\023\317rk\231{10\012\002a\235\263&f\344\364\326\017ZN\325\377\330\323!f\314\236\372\246\371[", 56, "\254_I-'\322\233$\007\235\371\306\023\012Q\300\036\341L\233N\324\325p\317L+\013v\311\316\354", 100, ":\233\376\345\015\356\005GU\306t\212\010\042\276\274\263\205\221\353\365\320\315\330Ew\340\020\032\003\367\345\366\016\276\134B\0347%\134\2110 r\272\031\277\024\257\321\222?[T\270\251&\200\013!\206\036F", 64 },
	{ "\2373\301v\271\235\276\027\036\310\364\032\002\3031\342\220\363\343\355\315\227\032\177\264\224A\240\010\310\332m\376F\330\212\003\253\264\022'\2329\350\372\007\367\237\363\031c\312\357\015\036\247", 56, "\306\020\351%\320Q\236\371\241\204D\020\273\264\325\322\347\276\202k\347\225\312\270'\364\244\267\253\324\256)\361\362\363T\020#\177I", 100, "\307\203\024\042X\2128R\350\013i`\227\217kE@i\275/\371\365\352F\3261\013\203\253\226\024I\214\005\340\266\0024;\021.\004\325\353\333\340\353,\253V\204w!z\360gV{(\200\200\243\203\203", 64 },
	{ "x\012\013\003e\212\033\346\266y:=\322\266\034\021%h\337\263\305%\212\214\345\2142&\347\316o\331\277\344\134`\245[\256\222\134\241\323\006H0\333R\345C\035X\036\011w\343", 56, "\324+\317\332\345%*uC*\367\331\231\375:\012\344\322L8\036H2=\370\337\011\254\313<\231\341Y\037_\203bY\235\316\245D\261\275\260\277v\321", 100, "w\371\345\322vt\024H\034uV\345\273\201Y\263\336\317\352m\326\023\373\210\205\270\270\365:e:\232\341\034\340\315\362\300Z\252\227o\244\260\005s\014\373\344V\010@S\0163s\304\373)\026\215S\030u", 64 },
	{ "/\357:\266A\017\267\203\302\030\374\011\337yPe\211\002\325\371PI\036[s&\315\007\363\326\227\224h\202\345\241p\236\263\207R\233\223\255\237\201O\213\300\230h\027\372\270\342\252", 56, "\021\037\205\367\202\371=\373\311$\3276\204w8{\322\326`\222N>)\236\250\236K\333\005\134\243\255 \214\375V\204\343\333\201\031pG\236\212+A\321{\222\231\350t_\262\243", 100, "_1\033g\364\204\217\016J\201\3137(\240K\200a\241d\3443\377\266\017\3118\3247\255\343=\251\042\343>sFI(\237\022\034]\007\002\301B\376\020XE+w\344lm\273j]\236\234+q\007", 64 },
	{ "\200\315o\042J-\2216|\324{\301\366\352(\313\215\277\202\134&\354^Z~\224\360\030E\341\262\274>\234x\005\201\350j?\363\275\3310\334\303h\247\214d\251f\322\270_\261", 56, "\003Z\010\015'\3659\371\213a\032\026wr\275]\201oD;'z\336H\360\362\262&\312\372%L:\271\254U\252\177l\015jR\256Z\202\341\342^\344:\321\016\310\225W\246\350\031\260Or\247>\312", 100, "g\260\207\013\373\201\012\363\253\001Q\004\347Brs\317\333\350$\016\325\000$5\347\373\235\020\212Xaz\2310\362\310\304|\342\302qdi\272\020j\370R+ \275\357\327l\233\357p\214\020\025n\260\234", 64 },
	{ "\027\214X%t|\276uD\2646Sa\0229U\342\263\204\215\017\265\220\262nl&S\323\335\272c\313\016E\343\327{q\010u\215\271\336\350\236{\010\333`t\321\303\330\243H", 56, "\030F\023\257\276\014@tb9U;z\250\262Q\352\317\240\320\222L\177H\371\213?\334@\277$\3062\006\347)q\340\356OjJ\177q\250]C@>Bp\275f\372\203g\200N*\234.h\256\201\251\312\260\363\211\334\207\332", 100, "?L\013\234\225\011\245S\276\333\202\356\012\347X\343\223\312\310lx\307\243L!t}l\322\360KFqu\263Wy\362!\323\373}\316\276\374\350\202\361\036 \336\237x{N3\261\373\037\303\013;\254\302", 64 },
	{ "\201\024\017\256\016\004\012\266\346{\253~\241+K\242\032\340T\200\207:G\234+\336\266\321\374\240\371\313\213\322{\2001a\314vkv\253\270\347\306\241\377u\233o\340r{u\215", 56, "\351\256\262\270j\374*\375", 200, "\225\256W=\253\033\267\207\010~\367W0\375\035C/g9|\3500\237\011}\277\313\023\032\003\017~0\032w\037\327z\257\221\371\272\000\030V\257Z\203p\324\202Bc\262\302\360\266A\027\255\347\016x\277", 64 },
	{ "\361\362)H\255\223\262f!\237q}\211a\313\340\013\273\255\244\177\005&\226\216{$5\206z'&\232\273/\370G\216\201\034\205\307\236\330\2132\033\210\257\235\001j\026]^\365", 56, "=\364\001\274f\263e\006b(p\2263\035\205\231", 200, "1\337w.o\2238@\015\221\025g\241\342x\236\342\034jT!\003\023\003\3037\255lvx\252R\377bt\037\010-\263\316\326`rBb\353\202W\270\365\234\250\251\253\013\303\357\007\352Uz)\037~", 64 },
	{ "\257\277\134)\332\355d1d2+\353\373\030\375\367\033\252\200\240K`9I5\357-\216\020'p\315c#\221\222\2375\036}T?Q\357?\370\234\226d\015\014\024\362.\230\225", 56, ">\316\225q:\330\227\235\001[\025\200\360Q\020W\213\035\005d\232\310\003\362", 200, "*\337\342 5\215V\033\277\266\235S\275G\3654\274g\323\377\200\327\221\3660\342\337\242\365\025\322\264q\257\354\307z\242\355\276GS$NM\373\212|J\211E\027\234k\215F\241\214\351j\323\227\243R", 64 },
	{ ":\334\025\003\012\272\216\010\265\303dz\332\270\244\370\337\337\362]\320\001\374\247\375\211\236K\236\233/\016R\356\242\030k\224\005o\322+_\241\013\337D\345\325\246\277S\245\335\262\370", 56, "$Z\306*\301\024\365\341\272\252\241\256\004f\260\313~`\253\227\307\015.@td\027\352\023\303\037\245", 200, "\205|\242\366\361\322\316\360\003\330?\212\227d\011\367\306H\364]\321\015\013\233Cy\236\301E Y&\336\013\265hE~_d\207V\367\270\362\211\377\351\012\020\037H\323\321\356\272 \345TK%P\317U", 64 },
	{ "\231\277x%\233\335%\020O\317\273|\332\300\025Z\375`\254Y\001\374F\277\347R9Jp\257\355\305\314+\222mhE\134\364\261Y\220\253T\016\341\230\220\2049\350T.36", 56, "\273\270\005p7\266fex%\352{\216\324\317\230\347\201-p%\273\305h\030\324\317\005\012XQ\252\204\004b~%\300\350\322", 200, "\225\266#V\362>\224s\003\004\343\234\013\364\250\2561`dF\270+\257\226\314\007\014X\302{;$\376\376b\034\300\350J4U\207w`\200y\011V<6U\217\274\320\134\036\231.\263$\003@6E", 64 },
	{ "\335h\233\222\333\376\221l\310\277Qr\311\245\030\026\231~\264\376\374\010\010\352l\367\014\346\2428\204\207r\034\236\367|\202\311\014\200]\042\350\230\014\042\227\315\304\006d\037\354\022\236", 56, "\327q\034X\210F\233\134\316\225\3179\216\311\335\262\213\011+\300\242*\324]~n\300\330\301z\345\267\350M\012\036\267\222\221u\317]*\271\271\350`\027", 200, "X\025\236k\211#\272\010w\252OD(\042\234\244\252b\004\014\017G\377\206\201\367\311\346\225\347\271\013\253\022\224\375:\015M\030a\337+\371\301Y\342][\245V\202F\373\230\325\246\301\030\307\016\316\367z", 64 },
	{ "\321h\237?\226|\246\300\002<w\226F(\252\261\020<{\230w\235*7,C\331\272\007\375Tl\010\360\240C\267\007u\037\220\322\356\271\333+\352;\336_\277|\030&\035K", 56, "\304\304t\314\323)\354-\225\204\037\225\365\001\227]\242\264\3710}G\042\032r>\2461\036r\302\201\347G!\345\243\352\230\212N\212\301io\002\265\224\234r\234)\014$\371_", 200, "\265\256\260C\322\362\025UZ\373\310\042#\355V\2627\214vv\031;\305\177\026\337\033\004\255\344\201\006J\232a\227\215\134\263M+\277vvF\263B\244\366\224\321\200\336\360\273\332\030\273a\177\343WQs", 64 },
	{ "\237\177\212\014\014k\321\033U\252tY\371\002#\332.\271\206._\341A5L\365\305\026\303\231k\362\200\314)\236\250\351\212b\3224P\225\361\332\247\275F\321\310]\330\213\341\210", 56, "(\233\022(\235Z\311\220\371\003\035\315$T\361\220s\035$X\370\271\260.\013s\012/k\001s\246\001\216\221\346+\324\262\363\030\331\230#\370\246Z\004\036z\310\034\301\026$W$\322\356\270\315\241Xt", 200, "BP\254{+\275\311\2262%\303\320\352\313\334\326\347\013\025\272.\332`*\242\302\315ABZ\372\211}\352fy\377\276?tQ\002\320s\033d\343\351\036t\033E\326\336\315\335v\310\037\203}}\017\223", 64 },
	{ "T\375L\020\260q\210a\271\242\270\231'\317f\366\331\017\022\004\253\275~]S\012\253\010\022\265\134\035\332\351a\371\362d\376\021\006\300\205\010\264$\027V\322;[}2\023\346\364", 56, "~\323Y\311\222IiD\042\377EK3\021\217\306\235\250U/\033\236B\236j\032\134\302\006\304\006pm\2145cN\234aR\017$\356-wwH$^\001\015\317n\014x~;~\312\335\256\227u\237\342\312\217\323\335\250\023\331", 200, "\002s\037\213\325\205)\134>\016\217\302\001+\004B}\232\304\333\211\213\312\037?\020\374\302f\256\204aY\275j\277\020^\005\256F)G\360\212\240v\012\327\257+X\324~M\245\320d\340\360y\357\312?", 64 },
	{ "r]\363\000hr\356vY\302\354\336\273d\322\265\201X\323\205\361\277\230\224\273b\320\354\336\241ff\322\356\376\256S\025\375\012d\376J\327\360\263\250\363\265\031\217|\005\217\177\330", 56, "\035\205\201\0145\016\364\255", 300, "\234W/lg\273Pn\323\134\015\0159\035\264\330S\345T$8\376C\327\255\367-\310'\253\355wbj\016\305Yo'$`\327\177\315\254k\317|\270\300\201\016\270T\361\334\237\302\356\262\025\361\365<", 64 },
	{ "[\362\344]**s\334`9nhC\212\320(%\224\341\366\347\206\215\337\211N\346I0R5hZeU-\3144\351U\364\272\004\231\316l0\3422D\346\376]3\211\224", 56, "4\2300\026\333\211\255'B\033\267\363\204|`~", 300, ")\333\035#\321\025a\0216\306|\273\331\025\302\306\342\231\036C\012A\240\356\364\001\030y\032\023x\031i*\346\341;\212\261\263\212\274a\017\352gM/)hN\232\262\031\371\267%\032\271@\017\313\342i", 64 },
	{ "\0232\236\245\236\367\265U\031\235si\306\327\024\240\2143\261\213\265\377k{\225\2673\026\037G\007{Q\013\2020<\375\340/>\2354p\030\315\354p\375\267\321\266P\2365Z", 56, "\262\3702\216=e\326f\231R\303z\255r\345%/\315\316\340\2004\300T", 300, "\273\376\362\0214\002\345.\313\332\230g(?\206\3403]yk\360\025\233\373H\016$\354\003\240\313\304y\373\326\210[-~\360\200C\023\340\247p\323\224\3437\022\322\255i\364\317\217\354\301\015-\020yA", 64 },
	{ "T\317^\247\304\021a\362a\235R{\266[\323\3054\252\276\036\005\327\342vn\134V\340\336\257\005\327\253\236qt\253\356f\003y\333\302\217\224m\030\264I!\207V\271fXn", 56, "\336\036\015\030\323t\010\037h2V\2514\2561\325>\3605\3354\226\363\310$\355@\261\324\321\333\272", 300, "(\202\245\265$K\256\300\037%\010\230\337\266\334\305\207\016\340J\314\233\315\313\257o\363\346\253\306W\245ID\315+\321\247O\240\007\273LG\203\2564\351\371\342\326\210\234\360\356\236\300\037\256\317\313\273\363\374", 64 },
	{ "\351{\362n\251\033=\004\304\323\332\276\304\306>\375\250\360\207\263\0359\033\244}\370\0060y\275lA\037Go\351\265>\345\270:\346\011\223\356\233\003\242{\371V\372\030\011\235M", 56, "\205\300\276\134\262\237\230\026U\042O4\354Z\324\017x\370\326~\240{i\211k\326\014\350\350\223<\011\233q\315\271)\201\002V", 300, "\250\302W`\353 ;\013\354EmG\210E\344\244\346\343\303\364s3\207\352\262\012L\200c\342\275_xF\301\302!\030\310\277\305\031p;\327R4]\241\012H]\374y\271\273;\331t\323E\211\346\223", 64 },
	{ "\373\344\235\025\313\213\037\314sE\305\217\201\207\200\255>\016\002s\270\276|\2027*t\223\211\253\350\310D\202\223Q\202\273\211\341\214>,|\334\327\375\016\242\004,J\351\207\320B", 56, "\242X\031e\233f\003@\274\340z\364f\303\215\301>\234\335\243\243\334\341\254\004M\006\275\276\266\300mx\346D(\303\207\042\263\300\306\372\240I\252\016\324", 300, "\263\336h\205\364\347\361\237\246\230\226\032\372\2349\331k@\276\255Bc\217\012\0247z\304i\353\367\206\310\311\366SzJc\232\255l1\317\025\2470\235\324>E\367\200\024\027\212H\276\310\370Z\237\227{", 64 },
	{ "\242\220\207S\211\213\272\343\333L\223p\271#0\016\251\363%\213\347\017\204;R<E\204\261\204\260\205\375e3\177\203\224Hp\377<\216\361x\236d\251\001\022i\265\026\264L\321", 56, "\202v\374\247?\356Q\037\272*C[jDkw\321\233\222\244=\206D\3264\326JS\363! \025\316\211x\374\036\273\266\212\2716\332GM\275\263\352je\005\3318\315\335Q", 300, "~\201\352\3747\372\036\276\201'\037tI\014\261^a\324s]\007\251/\276\002w7\333IO\3128)R\032\012S\263\023/i5\3013\240\253\201sj\344\214C)\361\011k\327\232\267\000%\333R\004", 64 },
	{ "\017\301-\345\223\003T\010)\134\275\373Ww\257q\2155K\324\250\200\334\315\007\246\350B\263\216\202l\304R%z!\372\370\264\332\331\324B\340\024\264\274\015\202+\033oj\354 ", 56, "\22616;\243%\012\376\342\271\275\015d\222/\327\257\215\335\253\211\373\341\324'\304\031Qh\241\353zP\266\305D\3150?l_\242\344@\354\0059iI^\265\211\343\257\205;\234\263r\224\016)\277\013", 300, "\330\007\326/\254\033\134f\373[\322\022?UM\013\355\337\313\264\2425'\231\312\341p\350!\333\370\360.z\200\030`\365\011\221\371\017\305/\203\265\007J\374\012\242\341Q\030\330\245BYW\311G\0362\345", 64 },
	{ "r\272\266\025)\000\216.\306\327b\326\376\307\364\317\304\313\034\242\304\263\321x\202~\302\002\201\212\370\213\240\335\364\012}h\001L>U\010\270\216\250S@\223\243%\234\013\311'\350", 56, "\272\221\362\224\225\266O-\360\335\247\377\371\205d\236\270=;\2716\353\305B\2476\243K\034\222\007\265\025\314\307\264\230\303g}[\271\253\211\271\012\303v\301\273\214\331\236\267`\366\255\321\241(\342Y\004\224\011\210a\315:\324\264\277", 300, "Pp\361\036\353\372\221[\013\324D\014\252\0254[\234\345Z\245\367\311\234L)\373\242\273\024\233\376S+\3751\373R\030\223!>H\260\010`\015\355\361F\372\263\343G\030\375\222p|\265/_h+&", 64 },
	{ "\326.\362@\324h\237\007\317\030\307\035\215[\2572\312\232`\302\265\017\2659-\314\364\241\346\2323\251\225\204\235$OT\271\340\231\377\210\211\254O\013\036\340t\324~\350\346\305t", 56, "\362\042\271\224\360\031\217F", 400, "-\033\3460\367 `g#\240ShxVOKzW\261\330X2\333\232\370\251\274\325i\327\354-\222\257\2552:\373\305\330O\007\227\015\350\014}G\2259\021\320'\261[Gp%?Qy\014\321\240", 64 },
	{ "\004\307GI[\200\276k\233\014\225.\363xI\373Z\327\356\255AK\356]\366vV\202\377\213C\2176-\223Ty\221YWH\232\332\364H\236c&\367\375\243^\222\035:\337", 56, "\035\241\360U\224\261\261G\020\334;\225\277L\333|", 400, "\302%ni\223\031M}\257R\257\022N\314\205\367*'\177n^\272\300*_c\320b\134\251\230\346\021*\225X\245\017\336|\134}\177\277\315\310*A\247@\330:\000\370}=\034\010\203\376\373\023\236@", 64 },
	{ "\010\202\234\205\036)bJ\310\323\276\032\230%\177\200'S\377vNv\3722\217f\265XA\177\366\223\034\042s\377\317\330\371b\014\333x\240f\366\011R%Dc\366\207K\200\333", 56, "GU\2662\202\205[B\0369\034\035\232c\322W\201\372)%CIV\374", 400, "AvE*\202\274k\201o-{!IEA1,\204\352\330WY\042W+\223\2136\365\300W\324z\355-\303[\013\0224x\222>\025\014H\007\360\234\266w\310@\276\344w \301\200W}\037N\303", 64 },
	{ "\234\364\262\000\230\271b\374\255a\300\224e\024\336\346\326\220\022g?H\2258oY6d\335j\004\376\257\254],\005\0062\227\017@Dr\331\027\204\331\012#\303\012=\225\035\363", 56, "\2467\305\015/+\364L\303\350oz\253\3162\204@\375\370\257\233\305W\345-\004O\277\267\227\312v", 400, "\240k\030R\020\201\027\303\363\242$3\312Y\307\276\010\231\333A;e?\005\023Pu\036[w\277\317\300\006\262\277\276(y\334\201D\253\226Q\3711\036H\134\320\253\301\017\225\224j\371\033\320\304\336\035&", 64 },
	{ "\037\257\213\333f05\350\261v\2161\360\355\200\033\025~\206\226\363\011\331\343G\013\207O\364U\250\211\216\242\017\242\021\3148?!\024\261\211\200\265\036&\000\3374\207\022\221v\221", 56, "\256\337=\015;6\264Z\355\255\277\257\252\030\273O\375H\350\027\234|jK\222\234\331\033\2259\134\250\011f\267 gd\264\203", 400, "\317X\2557\226\351\276\234\3122\235,.\265\247\003jFE\300\0035\373\3407\001g\202W\337\335\325w\252P\030\272\356f\267\344\276M\205\334\024n(\350_(E\335|\224\303\220\020\232\2223\272\2260", 64 },
	{ "M\242\373\013\256\274i\320D\361\373`\235\216\204\374\312Jz\270\266U(W\265|\013\316\254\253?\242\357\134\020\274\352\266:nT\210r\234\034wm:J\257\264\360\023*\015r", 56, "a\273=\277\347*\301~9\022d\027};\355]\344\377\274\236\334H~\304B\202^+\240\367\335\356\204\255+\356\356-\311\371\212\324\201.-B\273&", 400, "\020[1\211\376r{\005\214\205\254G\247V\341\010X\012\020P\235jo\256\032\216\312\002\024\210\034\015\305i\246\031\023\020j\021K\257\025U\352\027\232\357\313\240B\034\214x\305l\233\345|~+\312\233\264", 64 },
	{ "\217\266\276\265'6J\215~\014/\3073\036\225JL\323\226?\272\134\216\323p\306\315\353SM\245\364\222\260W\362\242\215\031\221\276N\366E\216\177\042\366%\004\006\030~\345\374\345", 56, "\223\210\035l]P\232\362\025\350\241S\232\012\010J\023\321\374\340\247\014tWQ\307\227\307Q\243\231JO\005\312\010nt\2361\022'8U\017b\261\261%\2319\265.Gix", 400, "\333\355\310\265i%\210\022^\370\231\221\3660_\212\042\274\336\030x\267za\216\260\257c:\251vJ{\340\3651e\013\312>\016C\016V\277=\327\233\363z\244\201\317\247u\344\235\356\212\373\255x\134q", 64 },
	{ "\004\033\236\331\011'\042\323i\013\333\304e\236\371\260s8zb\252\200u\025\313D\207H\267V\215\177r\205\3439`UY\370z\033^1\322@\276,A\004Q#\371U\016\006", 56, "\001\265\022Z\004\037e;`\2647\326\311\272\316\232F\267|\344j~\373\340\306\372\263\325 \031wp\234\034\236\025\023[7\352~\330\031uU\356bF\236l%\350^\200\312\012\240\025\351x\007{\247\270", 400, "\372\2501\204\346\276.\2567i\242\306\303\001EZ\342m$\357\302JAt3\201\316\346f2Ut\322B!$\217\332B\216o_T\020\264\035\316\340\2001\243\012\364C\232\224\373\245\260\316\330g)A", 64 },
	{ "\213\223\354\023\313j\023\220q~\260\252\263\027\300\332\0118\026\252\311\332\326\212U\301\033\303Y\017\017\244\217s\307\2501\026\007$K9\260\277\361\0043j\350\220\2632\006\211\332\007", 56, "h\026\365iw\313\2138\012\2264\351\335\014\2474d\362C_\024\225\024JXC\305$\215Z\375\373-\236\227VE\254\022\267\363r\372\317\265\325\376\013\241:\256r%\256\326\272\236EA~\261\2327\005?]\316\207ZxfR", 400, "\204u1w\363K\350\277\343\042\223/\257\031nS\341.\313G\374\342,\030]C\324En\373h\031\267\237wB\2101U\314\375\023i&V%@6\310\360\252\214\335\353*\314\225\036\037\273\203\221\312\344", 64 },
	{ "8\240\204\313Z\214\303\037\032\177\020\331rM\221\265\375\375\342\313\224\205\347O\206\322\354\267\351\207\346\347k \353\272G\241E\326\336\240:K~%i\372\2757\341z\202\212\030\210", 56, "B\313\0113B\2333\215", 500, "8\362\033\014\244Aj\352OV\203\261\267\326E1\034\316R\217\026')\262}0#\220\273\377eN\224\375}z\320\226\031\315\042p\377\015\232\341\261hC\304W\322e\204\210\001*T,\323\343\223m6", 64 },
	{ "\371\222\270\331L\332\315O\2555\300\244\374Uf\224\242z\202\202e\232\205\234L\316\372\320\025\230\031\366M`\357d7\312\022\300\260\341\016\324\313\354\317VH=\265\343H\312d#", 56, "!\006\353F\360\305\222\013\012\364SEB\373\245!", 500, "\220\303\300\031\253\227e\134\203\326\373\024\247\231\262\276]\355\361\027\331\241\307\373\346?eKjt\347\371\357\205\345\313VJ3\363\252F\007\177&#\354\240\351=\010BtFa3Z+\232\042[4$D", 64 },
	{ "R\265\240lF\235\024\367Z\231\263\251\216\332\252\303m[\316=\3151j\322\3674\307!\006\356\2235\237\027c\301\344\377\230T\372\346]~Bxm9\020-\234\244\3047\010\320", 56, "*\374\372\266\201`\266q @\376w\353S\356q*A\306\230\376\301|\012", 500, "\367nb\322\341vl<\003a\327\016\340z\3251\262\025>K*c\314c\345R\24464\324\306\264\267\330\352RN\3539-\342?;n\373\013 \240\042\351J\247\001\265K\264r\232b\021\277y\325\371", 64 },
	{ "\370\336\306 \221D/\203,\255 `\010\026\322)\320\374V,\204$\2301vdmC\351jXg\225\013cB\250\272\352.\2229\222\236\177\313\206\250Y\341\330\354\313`\217\225", 56, "\377\260~\010\305\305\317\244\3077\342\345j\263\042\013\016\134]\233\263\2756\341\234\031\215\227\211\213\326\036", 500, "\315\244lW\361Y\243\037\271\365\225oJ\214\345\303\276=\210wA\243\020H\347\205\223sB#\307~\325\364\325E\201`\017\2369\223\0229\032\177\206r\024!j\020U\231R\362C\226\000%G#\353j", 64 },
	{ "\316&\225G\355\351\364B\251hv\363\000\324{>\214W\000\3614\306\205\177\302\363,\216\346\250\215\200%\335Yo\020\017\3641\377GhM\233\366Hg\354~ \031\242q-\234", 56, "a\217\345\023\221\220\317\354\275\235\300\00708\375&\267x\03222\374\236\307:zY\200\265\352qk\334\024\010\240\332\300\031y", 500, "_R\245\215_hC\024\037\024\3230j#7\210\334\245\0162\236\010zL}8\306\006\024\373\356h\317\026\364\345<r\250z\007sS\033\257\017+\3245\270\263}\014||GsYK\233\356\211'\312", 64 },
	{ "\350\205\324D}\357\233ZW\247\277\315\335\301m\313\211\254\221\234\317\205\236\337I\250^\354\242\006b\3752\266\316\316\310\365\317\020\033?{\267V`\232\255\226\0333p\032A<\201", 56, "oR\311\013AY\374\330\252\350\364\341\222\342\037Z\273\014fet\016\030\037\316&\366\360\033\345\277Fb\352\002$Y\307\017:h2\364)\205\234\357\025", 500, "Z\006\244\336\245\201\255\361\210\324T\301F\204\270\037\001\270)Ha\336\255\346\202Y8\372D\342\372\354Q\014j\254\023!H\210\024o\242\004\353\375$J\213\221\364}F\020\312\237^\357\313R^\276\342\177", 64 },
	{ "\352(\177\002\336\371'\034\021\246\3708\220tv\325\243\224\320\343\370BLL\356\134\023\356\271\201=\223\320\020\024M\233P\377\376\330\326\003\217\247\256d\204\2611\0142\326\237\313\273", 56, "\253\255\305\215\376\251\002\033\224\247\353\235p1\324^0\215J\2769\364B\241(\263da\317%\372P\326.\242A\352J\220\320W\224\230\275\3619\241o\201F\206\255Y7\304h", 500, "\265\325a$6\262\355h\243\225\302\211m\323\201\2703\230\255\210\337S.\302\002v\270\233\353\335\344\035\264..\336\201b\352sb\370\222\227\256\022\316bc<3;\274\231\257\031\037\275\206\202\227\304\214z", 64 },
	{ "\242\022<?\216\255\332\362\353\342Qf\335R\030\200\302\023x\247\224\225#\225\376*\032v\007P$\266w\274\232\021\330\3334\377\375\360\277\330b\006\206\304-\334\372\222\314\026*\330", 56, "I\311\017\202\030\344\204k\206\226Y\350\275b+wu\342S\320\036\025D\330\215$\222\372\256\011\030te\343\3403\352R\237qj\231\331\020n@\325%\357\010\253\356\377\247\264\265\347\362j\320\017\202\226\010", 500, "\254g\373!\203\263\013]\2700#dr\225\320_q\004\215RP\2773r\342\366/e\262n\232\252s\371D\263\024[\243f\333F\247_%W\336\011\335\205\207/HhC\337\272\370\242\313L\376\024\372", 64 },
	{ "\220\353\227\035+\226 \217\372F\356%y\231\335\214!\340\235%ucM\307\250|k\376\251Q\244\335W\376\346\312\002`b\261\021Qo/\030\361S\261Q\330(#Mc\364\330", 56, "\273\213\274U\371\241\270\314\332\271\034\221\235\326\374\337~\315\373\376\241%\204\300F\025W\226\032\005\333\322 \0135L\233\340y@\210=\250\314\236\006h\2274d\301\014\346\237U\243\034\364\256\234%\367>~\341p\024*B\243\277a", 500, "c\247\212b\321\262\346\313\253N\321\345\201\206\334\254[\373L\225\200\353\000\201\313\234i4\230r\223\225\371\033\203\327ZZ*\320\017\345`\302&pa\332\2166\245\0213S=_\021y\001\274\341*\337\015", 64 },
	{ "9\331\351&r\205\345X\365\201a\003T\207\241\036\347@&\221\200\242\042\237\000\277$2>\006\324;\255$\273\354\310\177\254\134\273\360--\330?\347\042\356cf(\260v&d", 56, "\204i\217\313o\315\006\017", 600, "r\332';\213H87i?\177:\367\356\233:\224vY\254\355\366u\01143\356\001Pj\3678\256\305\270\273\352\323\303\242g\006\342|\226\374\252\233<R\376\234\242\264\343\350\0028$t\275\342\321\367", 64 },
	{ "\357\267)\355\357/\241\260K(\232j3z\022\373\236\004N\233\224\010\377\300}}\016\027\214\3340\026\343\262\232\222\237A\277\031\330y+\026li\323\332\004\314J\310\000\313\016\014", 56, "\263_g\016Bk\261\020\204\236IKM5\327\251", 600, "9\375%)H\274\355\031-\255&\374\206\027\277\314\314\366L\326\336n\032\367\2477\340O.\351\233\305\202\000\376\307\272\007\210~\134*7\134-\366\341\345\250\330\301\261\031\272P8\346h\302d\023&(G", 64 },
	{ "\213\333zW\216\235UX\210\032\034\250P\370\270\217Y\361\211\210\263M\324 \205N\006p\235\010\350\320([;\341I,\034\025Vp\263\014q\245\0148_3\256\246\177O\273Z", 56, "\231\301m\336\271\2521\254\262\035\354\027VR\232d\306]d\036\362/\245\255", 600, "\031\236\356\222s\347'#\201Bs$}Hn\012\3701\225rI\276\247\305\006\240\317\245>\276\250]\324rF\024\032\301\273\256\255m\377NO\265\304\367\203\321\266\310\356\342s\225\032\357+\312\213Uw?", 64 },
	{ "\270U\034\335n\235\270\363\250U\320\023\007\303\222'\272\216\363\242\032\275SG\210\330\3754Lc\222\350\134/h\332\371<\224WF\223o\263;\233\353\345\025\350\256\364\327\224\335&", 56, "t4 \226\006\027QS\313\233i\310X\355\276a\331\261\266\2512.=\2357\312\322G\247k\357\302", 600, "$i.\353\372\375\260\262\325\351\0369\026\030\134G<g\370\012\322,P\027\015*Pz\224PUUy\263\344\333%t\367IU\304\277\010\250\025\241\333\226\037\220\026\350H\331>a\203\275,cf\355\334", 64 },
	{ "\346m\257\241#\351\207\231\301\364,(\240\272$\033\314\033\026\012~\303ZxP\361\313v9^\334n\030\017U\352\351\352\322\352\355\341\27733\330\042w\027>\247z\005\371\006\226", 56, "-\243o\371d\035\335%L\226\267O x\350\304>\214\256\213\3356:\351\277g\306 \353\221\270\345\301#\037\001\320\260B1", 600, "z\134\243\023\005\301\366\210{\310{\356\254\207t\205;\342d\330\226\274E\005\016\011A\322\242J@\327\364\026\313\016\332\201/\240\024-\004\016\304\264\222\326t\315p\274Z\242b\337\254\3725\377|jIs", 64 },
	{ "\250\225i\221wd\264\223\242\322\230Yb\362 \310l\376\353\231\016\230tp*\264\300H0\207\354\033\273@\342\207\220\006*\351\355uc\024\243\257\315\234n0M\342\373\310\033\220", 56, "O\306[7\256]\327\010\244\317`{\320\370\317\362\252\320\237\2253$;\334\266\210\327\350-\033\232A\342e\325\367\3747\222J\230\227\201q\210\315\2072", 600, "WI\236\335P\013\367\250i?\134\202\362\205u\302\026\257\265\341\343\012\007\202\211w\335\314&\321\374\271*-\014\002\214\264\367\270\326\240\3664\325\377y\372\350\244\300\304\300E\201\357\015\375\234S\264\316\271k", 64 },
	{ "\317\372\363\304\351\254J\322\330\333\343\342\273X\005eNe\311hQ#\025f\372U\2062\241vTFe\223M\342\232\340\204X\226,\307\327\301\007o\231\023\316 K\347\320\323\260", 56, "9\313\372\250|\034*S\357j\353rj\312\220/\363\032E\263s}\324\261\237S\371\347\017\337\355\250\243\214\347\031\340\346\305\0070\227\371\005A]\231\020\011+\330\310\016\221\337\373", 600, "P\263ay~\314\235\215\300\223\357\3164\035\273M\211\010\315\323\305\374\366\305\2254\345\242\245\243\334\301\202\315K>\361Y\231\214\3736\2526\205\345\362\360s\261jP9=\305\247jDcM\302x\300\203", 64 },
	{ "\231\020r\351\222\326\232\3676\363\365e,\345\2735M\305\206D\233\364\004\226\3011\021\350\335\274\332\211\220\244\333\322\233\346\235s\230\331\243\006\272\3071\273\012q\001<\330g\274S", 56, "\005|\314\037\367\277\250\037\357\241\001\177\015\223_\344\034\206\232\015f\365@(7\315$C \236\352Y\245\335\335\273\023\256\224)\3341f\177\240\264O\340s\023\007\2762\203\345\237P\274c\231\226\352\340e", 600, "\305\321\337W\216\330\313m\207O\363\360>\272\366\260\357\323\363\276*U\254\015\2625^\222KpA\305\272\325Q\033HRv\005\257\244\2535\350`\230\367iE\007\035L\370\245\351\376\271\324Z\322b2j", 64 },
	{ "\037N\217\212|}\007S\020\333\014\232\251p\372\303K\221\012\246vM2a\015R@\352\207\222L\305,:Z>\366\315\011\337\235\231\005\360\201I4\250\134wA56\272\360l", 56, "4H\225\022^\246\212\243\273\232\202\355\2763\021%\027B`\263\237\262\2154\204\243\206\216V\322\234-s\2118\231\217\231su\271\350O{H\210\3771\336\23025\202\035\033G\3415\002\222o\205h\214\270\205\3148\274b\345U", 600, "Z\265\226\035a\361\003\364\343\370\313*\260FA\335\363\252,1\224\300\031\306\215\323\230\017\032\272\275\001\3052'^Ip\223Y\367\322)\211+\206F\244}\377n\323d\322\301\237\014\223\330\215\205eY\243", 64 },
	{ "\376\017\306\373\021\035\314L\023y\325\312\233V\010\210O\177\307pK\372\207\214\273@\320\333\265C\262\224\276,\265\324\311\325\347M\324\362\034\255\025\015\351\325\232\007\216~e?\275\346", 56, ")\344;\206@JMm", 700, "}\216\030\376\247\240\353\010H\313\326\233H\314\300!\3035\032\213\011\273\247\336\015\031\356\221\021\0135IP\004(o\353\266\302\042\345 YNx\2168G\260\000\021\300\230C\263\364\246;\312X\357r'c", 64 },
	{ "\200}\3266\3355np\266\024\225\022\220\024\033\35004_\227|\244KK\035z\330\025Z\252\2433\267\366\014,\242\227Xu\243\224\202\134g\364)\343\250\254\027g,h\261\352", 56, "\277m\222\260 \221%\375l R\023\037;\012\211", 700, "\033\343\371\36231\001\307\257\236\264\211\022\323\322\317\274\255\223t^D2\042AS\201w\316\313\346\001z\177\364\274\345\3602L@\330-=\373\251\213\244\304\334\2513\257\244\241C6\257\272p\275\262\320\305", 64 },
	{ "\033B\026\222C\254\310\342\304\321\016z\205k\224\252a\000!\200M/Rt\250\353\020D@\255\215\020\246\203\347\014\306k\006\331\301\256\317\275-\012i\355\305\031O\330\225\210\235\341", 56, "\231R0\266\357i\320z\241\257\006\001\305\255t-u.\024\024h\362\303\010", 700, "l7\324@z\220\002\376\016\346\267K\353\372\312\024\27406r\310@\274?bUR\323\257\255\326v\236\242M-\017\002~\264\374\225\260\317\347Q\223\304\343\177\020\302\300\246\200~H7\244\304\200\024f\003", 64 },
	{ "=L6\333n4<\267\177\003I\226I-\012\004QV\006}~[{\361\215\263\0223\317\247\322\323\201=G8EC>\001WD\264\246\006'\035\264\255z3~\014\243C}", 56, "z\321\231E(\307\255J'\354)|=\027\244u]\012\375\005\317556\351\3456p\3569\0200", 700, "\211\261\347\230\222\312FWB\3207\257cP%+\2160\254bX\311\00638\260\344\215s\317\267\252\241\240\352\305\334\261\261\305\232\272\272\263\021\304 \261O\321\304m\371\007\265\024V\231~t\017s\321R", 64 },
	{ "\300\241\015\235w\211\316\205@\320[\230\373\257\343\177\202i1\227\325\276\376%8\257j\345d\332\205\261\374\2751\206b$\306H9x\306\323\257V\024\272\177I0\353\201\277\306V", 56, "\011\254kz\217>\305\2321\3031@m\376\376\331\021]ASZ\036\237\020\231p\263\203\263\024\372\347\264\3618\205\253\207.\306", 700, "\263\200\330C\011\000e\325XDU\233\255\324k\014\243\360i\027/\302?\241y\367<\021\315\177\032\347\277+\000\033\227\015\223\322\367\252K=\326\373\226O6+\334\250\207}?\001%\272\204\235`D\346\306", 64 },
	{ "\347\317\361o\3477X\336\203\206l\366'\212M\042\375\364\374\035\233\025\042\360\344O\241^\341O\015\016\212\341q\233\0156\312u\261\320\253!Kh\314\253\250\302\253\262\005\252\375\376", 56, ",<\3611.\312\336\360\214\022\202T_\330\303!\021\017\016\332\373\032\360\346\307\023\225u\264\236\254\323\336\275JbO\345\304\361\306\026A\032\010\252y\364", 700, "S\323\226+\001\343\205\255/\035F'B\134\273\312\365\350r\203\200\035\340,K\243:7\254\373\340\261\237\317\323\264%\310'\270P\345CE\042K\214\233X\215\214V\233@\330o\351\030A\300\224\326\305\213", 64 },
	{ "\307Ss\376.\010\032\270o\023\363\303X\345wR*f\355\2278\346\215\271\311\202\333q\372\007G\033W|\326_\222X\205l\305\372\205\246|\306\240\265\320\207\235\222\335N\233\032", 56, "\226\277\036\252Q\033'F5l\212t\261+'Ty\015L%\006\013\2471\216e\352'T\323\344\346+\362\005\270a\027\220.\242iw\336\030@\321\340\213\371\035\255}\351\330V", 700, "\223\2313\331\263\312\244\352\354\370\016\224\316\224u\3119\012\364\327\273k\037v\311h\317\221\340\275\241\231\026\265\354,-\211$\356s\213\243| \3423a@%5\276\267\3574g;\003\216\264\374\235\370\012", 64 },
	{ "\234\134l\273=\360GI\370\350U\324J\330\251Y\315\012EX\346\230\245\201-X\2156;\026r\345Q\226G\304\134\317\322\274\3055\246\2700S{\373\343C\012\366\322\231g\333", 56, "\300\372X\134wN\035\301\010o\270S\177rmj\031\356I\241\024\362\326T\031\373\025\227\310uC\233+59\216{\016\345\226\353\220aN\351!M\332\311S}\365\377\303p\302\215\307h\206\275!k\304", 700, "\233\354\022\017M\373\371\232\003P\033\216\242\3115x=k\226Cn, \327\207\227_\010\035\276j\210\304\210\260\027\237\036\021'\032\367o\2638\346^ *\233P\372C\005\355\266\326g\376\370d\177\376\315", 64 },
	{ "\236E\212\232\211L2\265\264\007\242Y\311g\321\356\341A\250\210)v\245\204\226F\020\222\354+#\042\020\233\016\335\042\350\275\313\316U>\253\373R\255\033l\000-\2604\320HL", 56, "&\326\306\023(\224\272\353Oz\021\030VyE\204C\242\325]{qB\202\337\360\302`\210\243\376\213\316\277\2300\375\251\326j=u\033y\366\256\370\320wh7\364R\270\274\200\351'\221\367H\226\355h\250pg4\305\303~\366", 700, "\010\357\316\342\301\241\177Bj\225\314Z\344\334M\326\214cK\222\035\347I\200!G\030\276k\252\322\263\333\320\310\214_\346\033{s\2359j\010\024!\361\350\275\365\025\372\354\360=2)\323[\200\260\261\367", 64 },
	{ "\331t\327\313EYj\302\250;|\000\346\337_S1\026V!\360\364\236\033\0107,n8\264\214\0155\204\260ov2\215\317u{\030\036k\314\033\217W\002\314r\006CC*", 56, "=\006\361\134\010a\223\010", 800, "\367\243k\353\347\331\003\316gv\237)tH\371#\370\312W>\217\306&\306[\2226\016\350\2446$\350G\267l\253\303\335\205\020\000\004\314\376(\252\224\373\203\031\335\021n\361 \016\274\223\036f\035\335\261", 64 },
	{ "\226\220\3256G:\242\225\364\205Qg-\354\372d\363\256XO\242\275\032\325\014a\277i\010\263Y\221\343\0047\034\231>\222\306\306\227\313\022\260QNjw\303\231O\243=\342>", 56, "H7\265\214\251:\317#Z\272Y\221\240P\025\257", 800, "T\304\334j\357\322[\306\257\254\275\360\371#fRz\253\372G\017\002\246\355\222|\300\271L\303\025NgC\025-\261\220k:\022\352\207\264*\363NB\310\010,$\333\245\351\246\352\300\376\365M\013\240'", 64 },
	{ "-\007\335\006p\013v\225\356\002\334\371uL\313\233c\317\220\307+\017\262Z}k\352\334\202\016\251g\204\224\006\356j1-\214z_\272\372\274\224\342\2422.\022\352I\246\303\262", 56, "sC\344\326\346\214\034\354UQLk\364\300}\2477/\373\327\346\210o\033", 800, "\012\223\220\202\003\013-\365\262\214*\345#'\246^9c\311\347\373\031\2731cL\230\034\340\177\213Va\002:\006\357XW+@\334\326\015qN\026\256C-\275W\215\245Euc\026\374q\307(\202\211", 64 },
	{ "92\235\215|\036EF\211\322\350\247vP\177\347\305E&u\033\2126Dz\351?\000\134\212\302\215\322\327e\374\227\356_\322\346\275\236\042\351oU\031\011UN\344\323\363\006\201", 56, "\320\011L\355\260\334\247\227`h\265 )E\350h\337\014X\334\357\352\372\260\242\013\257\317:+u\226", 800, "\177\255\370z>\216\202\260\030\342L\331\252~\027\211\035\261\325\321\3237,!\237mQ\371\377\270\221\337F\321@Qr\315\322\312o\233\311\0226\331\311\220\250\3133\335\030v\015\261\325i\362w\3025\256\263", 64 },
	{ "*\004^\322\344\321\374\214\034\274\267t\232P\373\214NJ\201BN \373vS\220\027\244m\236\255+!9\006\332\274\036Z\265\321\262\371n\042\317\345\347\3353\247\310!6M\004", 56, "\215\025t\202\003\320\234\240\002=\302\266\002v=\233]:\032#hM\237Y\362\222\366\3609Q\026\330\334\344A\027\025\271\034/", 800, "\362\042\0257\314\336J\177\213+\211\335<l\205\3046\274\305;;\372#\370\204\346_\320\306\322o\032\273\227~\017\025\370;6q\372\322\0074\215\201Y\344\300j\373W!\3409\017Ne\366\237:Z\011", 64 },
	{ "\021\224\336;\367\315-\007/I0.N\000\226\376\311\215\203=\225\267\177\245\315r\305z\371\215\214p\346\373\301!Z\253\245\177Z\350\212{\016\373Wv\202\321J5z\232v\302", 56, "\360!\367\327\302Q\327k\207D.\210\212\012\254{1\310\215\212B|W\317\005\267\257\311d\243Q\245Z\364\270/\341\355\037M2\036\260\310K\257\263\237", 800, "\364\342\201\226\254\257f\342:{\004\355>\345\350\350\260[\317\263d2\316|v\332G\021a\210\006\034\274m\006\210\3024gM\022\354bU\323\255\014#F\011nM\303\352\350_\257L\321\242B`\256\340", 64 },
	{ "L\204\346D{!\253\215\200\270p\012\237;<\264(;&m\0102{\025W\277Q7\224\354\342\2443\300nD\364\222\026'\0215e\346\234?\320K\203\2238@#\345\030\007", 56, "O\271c\371\326\253\036\205%\331\031\241?GB\177!\334\254f\303?\361\251\245\303&]ES\300;q\016\267(`\272\327\311\206\327+\017\241n$\225\210\216)\032(\230\327\360", 800, "\134vO?\214\307\042]\0237\300\314EL\026\236\320\035\311\217~\247#L\2044\032\3064K\375\312\004\0045\215\361\372vq lX\234\205Z\265\300\211\313\341\335w\025Is\230\307\035\257\351\316\337C", 64 },
	{ "\377U\373\2454QB\021\242&\356&\003\375\232\177\205tY\242\033\352\222\312\271\331\315\350\313C\014\310\010\223\360*\266\031\025$\030\275\215\177*S\177\017R\261C\341F\261\363A", 56, "\345f\014\024\251\226\271\255Q\361\034s0\251\035\322U8\360\036\266\301\327\276\002W\362\210\305\253:\360\022\213n\361rW\021\353RjyW\035\206\35532\371\334\350<\245\020\375\315C\037<Gw\003M", 800, "\000\134\317g \344o\221\374\373\213\216\042[GQ%l\220\2163k\320\255\237\253\361\272\250J\220\225\322\042\220d\203\221O\327\214\256\027\023Fp$\004<\361U\317\247\235\332\203\035\332\315\026\262\312\266[", 64 },
	{ "5m\017\256L\271\334A\266.?B\177\334\202\206\014+\031\3066\211\247\272\242\314\264\035\356\350\333\134\326\301<s\242\246#.\200\275\025^\301\351\247\377h\362\366B\245\016#\327", 56, "HpKx\255\377\325\037\333\220S\006\276N\352|\264\264t\327\310\342\042!\277\276\010\307%\214\366\247E\205\267\312\007\006r\362\027\273\242\240>J\357 \362\026\222\377\327\332\015\276Z\362'\030:c\022\242\346`3WEx\304*", 800, "g#\2761Y\327J\204\256\311\322\357P\261\342\247`c\240\247\217(<\235\314&\032\000\312\331o|\345\004H\257\042,\264\212\007j\323\334189\313\000\026\257\276\204\027oK\227M\353M\313\177\265^", 64 },
	{ "\220\033\242\276\005!h\264\205\376\341\025\311\036k\222\327Z\014\236T\253&6\303\023z1\252\263\355^g\205\020\007+'\200\253\207\340\301\252\341\023\016j\301y\374i\227\320\3376", 56, "\035\321\264\204E\217A~", 900, "Vnq\035\354?\010\220\305M\311\232I\216\374\255\027rE\002\356\033\366\276\021\270\344\215,S\306\370M\332\377\320\376G6\210$\373\220\346@!\031bv\202\021%\177\364\274\203`\332@\276\233\006\245F", 64 },
	{ "\024\234\347M\376u\337\222\007\262P\325@C%\0125\337\272\317\215\377d>\211\373\241\2224e\025\352\356,\036\335qw\227\376\274\345d\362\332\335\010%\226\342\276\315\312\037\237\341", 56, "@\361\335l\273\026\232(\007\257K\251\361\351B\314", 900, "\232\213\314\327f\002\000\256\230\244\372c\004\211`*\242\352\214\000\007 \200\306\201\305z\227\222\263!\035TU_\301\332\341\221\321E\223\032\363\370\327\377\300\327$\237\312\325\235\026\372\320\014nCrB:*", 64 },
	{ "\340\017\331\257F\302X\231b)\377\022!\347l\274\246W\312\3279\367\325\223)\246\264\223\276\350x\246^\264}\324t\301-1\042\234\263\001tO\355uG\243X\225\373\0003M", 56, "\017\260\272\262\357A\271\024X\257\014g\360\256\235\265\301\302O\022\266\003\134\022", 900, ")9\026y\321\012i]E\347\224\332\210Fl\202\025\230\032\000\374\2748\272\007$\353y\264\000{\267\134\204\210\320\011\372x\343@q\254d\3541\334\020\042\010G\003\215\023\330B\33484\372[\272\273\032", 64 },
	{ "PK'7\267K\226\322\360\027\207!\2054\016\277p\240j\225\321\204\330\216-*\352V\357\226\177\214\015\312\314\240J\042R\374hh\255\031\022-\377\001^q)L[(\036 ", 56, "\305k\374\025\247\372\352\370\350v\033\271\243\311`\205+]\336R\257\210-4d\302(&H>)o", 900, ":P\335\271b\336\203-u\005\341\313\242\377\314>\015h\021\177O\351\350\320\362*;\2159\322\266CS\253\207G\000@\323\240o\267\011\321:\361\222u\015\346\343\301n\211\375\344\271\302\210\376\342\034\254\223", 64 },
	{ "\310\330\242\212\3177\277R\322C\331\374\3326\273\314(>0\320\357\042N\012\024\244`zh\202\376+\270\036\226\026\340L\251\017\200\347\341\205\2739\235\240\034\250\210R\334\320r\241", 56, "4\273\344\355\336\027\241C\220\271\006\026\270\213~\365\236\230\230\217\042\217\317\021)j/\2372(\215\007\266\305{d\370X\272\015", 900, "\242\250\134\3703\336)l\255mX\014\020-BG\206%\351B\244\231$z\260x\276\220}\020\334\310\270\243\036?\223\020\222H\201\326\203\372\252\236\246\355\010*\030\252\003&\036K\324\201\256\262\230U\2049", 64 },
	{ "&\221\233\226\351{\314\244R\254\337\341\265v\251H%\373\210W\042\367\220\2458L\214[IM\253\234\315\370\010\0253\366\205\236\244R\207\212\302\206\221\326\351\031\336[lmq\244", 56, "\360\345\305\014\367\322\302-\3147E\243\001\352\002v\326\365\203l\367\0347\375\206z\004s\003\367\201.i\350\331\315\213\236\321\223\2241&\355T\251\366\134", 900, "S})\307C\037\213\352h\346\177\2231\021DQ\000\355\245PH\325\263\376\275U\2040\335\033\333b\306n\002\365~\330<8\024\341\205*:w\305\026X\205Kcyg;\032N\037\274U9\210\264C", 64 },
	{ "\324&\3775\250\242o9}\324w$\015O\0148\311\203\332\360\210\352\006k\027\323A\035\207\21014g\021=\230C\317\201\214\035\257\2402*\371s$Y\232\2459>\271\331\023", 56, "\201\234\241T/\225\007\206\237\356Jw\252u\2178\360\372\224\005\217\335\037&)\200k\256]\177\011\013\267KB\314\367\334\305\301\344'\255\373\310jk\371\010\321\134\032\241\241\364{", 900, "\001\351\012\372\250>\310\370\301rr\023\027\025\2269\340\330\321\374I\007\210\042\253M\227\353\361\361\240\323\310l\263\351\204\015A\225A=w~\022\027\357\007\252L1Hd\253<K\203\336\255\343F\240\017\015", 64 },
	{ "\211\277\364H\333J\012\304\247;\331\324\210n0\033`\362pE\316\264\322J\267\335\334k\366\341R\365-\0253R\371\037\347\326\324\306\366[\002\365x\204s~LR\235\267\244\355", 56, "\012d\3716\364\026x8\341\317\243\337\313\376\363\211\353\002.\2776\027Y\042\027\371\317VC\306\343\007Jq=\204+Q9\311$\307\134\370\020x\032\2024\022~R:\364lp\302\205\254\335\314=\271\275", 900, "\014q_[!\315\261\274\025\234\243I\304\204\206\337\301\237\244\254\350'\2567\030\264\300\310\271\375\334>\010\214\325\225\034{\005\263\032\033\303i\253\325\021\352\037\236tv\313;)\257\337\270\004\042\340\015L0", 64 },
	{ "M\362\244pg1R\245\331\215k\033p\253J\254\362h\362\353~\310\265\210P\277q\330KR\001\303I\223\000\031\345\336L\3653\200\360\273\376\315CN\320=\224\355\345\263\255\216", 56, "\225\250\341^\2263=\270r\030\310{\014\263\222\356\031I\256\1349#\372\347[\363\026\376\231\331\3770\304\331\350%j\344\3715\325\231F_\273\361\237_\225\351\007\031\177\330t\010\206\206\003\343\307\036\310x\226=\031\355|0\255\371", 900, "\375)M\213\204\314\340(\310\013\374\254\344\220\223F\366\003q\303\220h\237\273\320\273U0\3758]\300\042X\221\347\346\012g\263{\353\353\013@\217J<\015\337\013\254\020ruo\310\247W\304g\312\322\350", 64 },
	{ "[xF\003\370\236\377\362\276Q\310l\336o\001[0\335\005=\271\226%a\012#8\346\3715s\015\2753\344\340\030\352\264\021\347\311\226\007\315\251\354,-\351\015|F\313gB", 56, "AH\260\363\312\212\224j", 1000, "W\256\352\317P\3549\250_cu0\352\016\305\025\235\306\016\2440W\317\253\011G\365\343\220\317\00560xW\014\377\230fQ\271E]\3461\354\245)\002\233\031c\317{\300\212C|\021\213\370\025W\225", 64 },
	{ "x\340\224\033,\037\317Y\242=F\270H08\371\347\210<\350\316p{\213\333\032R\372n\263Fx\000\305H\302\023yO[\254^\365\360M4\337\360\202*\206zg\355\306\005", 56, "P\256\0302\023P\212-\015\302\334l\225\376\307_", 1000, "^\260\023\024\340\263v\275\345\340z!\263S\231?\301\016:Vym\254\015\245\251\321\303\032\247~]N\023\022\372\332\317\362s\312\233z/\031kFT\220\033\317 f9\275\031\213\233\237\014K\232\032\357", 64 },
	{ "\357\254\354\376k\307\337\363jbe0\030\3037\307M\334\220\214\350\367]\234^\326,\371\306\201\251\256:1\306\010\300\346O\233\236}p\037E\031\035\360\262\021\243\260\331,-\326", 56, "@-\204\272E\361g\205\037\222\362\361\0137\363\365\010\305\265!\030EE\325", 1000, "\272\356p\267:\251\314(\371\261\3726\356\257\274\305\263\2266QE\313#)\215\010)\342\323\273wKL\300\012\010\036\241\006O9\202\266\207p\307b\301\352\234~$\335\236M\302WEqS\272\317\300\004", 64 },
	{ "\354\325X\031\235d\376>\373\207\010\011\3468\2300\273;&\343\367\336\332\212\025\355\016M\000\303i\326uW\227\3625\2214d\202]\015\261zt\212\275#}\363\347j\177\226,", 56, "\364\232I0`\373\306\273\247P^\2322\311\355G\207HQD^\3420\333\336\322\361\017!\247\306\244", 1000, "u\336*z\365\035(2x\346\345[\305\035P9tR\237Z\2155\260X\201R\367\350\362\264\276\306&82\321\363\003+\2172g\305\336\307\346\201\032\335\233\232\000-{\012\254(\256Su&O\260\223", 64 },
	{ "A$E\354\351\002<\012j\265\273q\042e\337\317L\005k\370\346\020\014\352u\357M6\276\337\334FD\342e\335\247\262z\246\335\015\336\277\014':\263\344\313\326k\203z?\304", 56, "',Rr\221\027^\012sf\321\001\027\340\303B\305\3400\317\013i\222\235E\320,\252\177\275\330\214\344\336m-'\012v\005", 1000, "\013\222\350\277#\344j\322rT\223\033\217\340]\247\235#\372\300\360\026z\004\026\267I\201\240\215\0025\320\202O\326\005g\032\221E\327\253\257$\357|\216\315Y\351\235I\015*\251\372\272|\375\374\262Zx", 64 },
	{ ":\234E\033\211\333\024\266\034[\244X\012\237+\343+\361{\177\244,\3540Re\012\337o\365Z\272e\020t\260\244I\353\267\311\005\015t;\023\035j\246G\0349\346Nd\255", 56, "\212\265\352\026e\2642BJ\250\324\003\336\042\247\320?C\302\227\327\037\317}\276\372\2069\363\025uf\373\333SS\2317\241\213b\026\215-\275\003\353\005", 1000, "]\351\274\246#\301@[\363\331j\241\371\037\334\363\323\307\200\227xT9\227\333\326\001\033jU \011\3063\232\276\015\357Z\333-\300\022\0266:\345\241\237\015\012@t{\315\355K\305\342\023\200.\374\277", 64 },
	{ "\230\354\247\310*\307w`<^i?\212\264~\317UY\213\013\303\024\357\233\016\207\312\3043\025\341\361\222+\333\375>F\026\330F\330@\220\216\314\350\231\214\253}\266\221\211\260l", 56, "#C\261\327n\205\266O\013\321\006\257\303'|\253\025\341@,hd\311\030 \317\355^\346KO\262\303\202\002j?V]\001\201\327h\020%XV\221u\227}E0\275\344\034", 1000, "\360\364\326R\272l;dB\247@\272\217\237p\337\322iONk\241F\364\225I/+\352\273\202e\306h\2742\244G\341\325\023\217(\033V\220\311\266\200\010\325\373iA\327\334\340^\203\357s\312\314\374", 64 },
	{ "\042\362a\336\307\035\016\376\022AR\316\306:g6\025\316\365\267c]l\365\360\312L\234\021\032\353e\211\213@\366\231\3673\013)U\241^\255\370>\035\351\302\3778\020\264+\000", 56, "&D\222\354\376\333t z\037{=\346z9\354\213y\340H\377M\015\354\036W\361\214=\371\201\336\017\2402\244Sg\313N\2702\362&\037\374+\371\015\255\325\263\261\303ML`\374\016\245*\272\347v", 1000, "*\257\371@pwa\351oY\230\231\034<\205\372\023\224\034\345\372\337\021!\316\271*/9\301\307\363\275\320s\230a\315\345\225\343\336\030\306s\361<DYo\222i\255\221\3436\322 ?S\026H\232\376", 64 },
	{ "\272b\240]W\237ll\355\244\233Su\240\027B\320\207\230\333Q\330\016:\012\212\232\220\255\325MKD\367\316\217\336\237\347O\307\352\251l\364\241\3603\320E]\254\305\201RB", 56, "2\314\263\253\025\002\232'\207\034\205\224\242f\375\023\201\304\3579\2566\237()K]\032\317/\321\374{D\313\020\214\240\270\234K\245N\2420\345\273\247\256\2761\365\256\323\007\206\214\013D\007\333{'L\310\226\311\222J\263\243\260", 1000, "\037\010>z\004\301\350\365<\014hb\262\210\340\230W\372\215\245N\225\374\242_\371\134+E\240\307\026\032\257Re<4\373\216\272\336|2\332\325\204\276\333\004\2112D\322{fC\025Z\346Z\205\345O", 64 },
	{ "V\227\252\273\367\350U\350`\241\303\266\211\362\001\336\202?\340[\265\201'IR/\201`\372\203\010\250\342'?k\326y\322\242\355Qt\373G\331/\207\240]\347\216\032\205n+", 56, "\341\340\034\243\201>\0261", 2000, "\371\025\042&H)`)\277\361\026\201\356\310d\000Rr\232_\365\341\020l\304Ja\225N\253w\003T\023m\362mCz\225\317\301%\017\016m\276\233*\251W&\335G\017sm\266\015\343w3\002>", 64 },
	{ "\000\270B\346\340\316\355\311\177\227\314E\361\013[_\241\226m\370\213o\014Zm\375\343n\035\327.)\221}\006\257P\0222\027\364\007\301<i\321'a\224\266\254e7\275:\017", 56, "\032\275\247\042D\011\331z\317?Y\244\207(\363D", 2000, ":\330\255S\227\134\212\322\342\322\306{\320b\332c\276a\354\227\020~(x\347\310h\302\341V\003\033\365\305\360\327\301.\224\267\327R\347\306\203\251\2065\225\364G\000\371\332\241A3yI\315\223\364S\203", 64 },
	{ "\335\367Ji:\237\005\331\300\304\012\306\273~\350\273\003\036\213:G\337J\336\207\302\270\204\213\012d\375\220\370\3761\030\273\202\000\202!V\303\246\241\255\027\335\275\022\242(\230:\034", 56, "\253\002Y\336\007,\012\036Q\250nml\274.M\033\134-\214\301-\007\270", 2000, "\346W;x\262`y\011\252\314\241\267\312\254\032>\333\231\201\336\371\010\006\207\244\373\336\001\237s\262\261Tj\030J&\214&\202\220:\2579\346\273f\305\344\362\361|\330\335\261\227\017\3607H#\260:~", 64 },
	{ "\0161\342:\237\241\016n\241C\335\323\233\376\240\230^\303\263u\336\344\012\360\306\003%\313\345\275\311\252_\016\252:\374\233\031\330\037\001@\304w\200rE\020\025g\341\270\327\314\350", 56, "\301\2278=\351>po\352?\306\024\230\005\246\345\035S\213\035\343\275y\307\370\3432\264q\376t\366", 2000, "\312\034|dHb\251\354\355\247\345\323\315x\273\234\035:}\376\322Y\376\267\306\202g\010u\324\037Q\206\023\305.\004\251Q\256^Ov\261/\233h\004#e\356\375\2403\355\303\334*l\356aj\222|", 64 },
	{ "5\221Z\313\212\034\230J\210\243(\250\274\347$kN\323\213\327m\134n\277\263\313\017:e\353\211\223f?\364\255\252\306a\272\333\241\342\373\200\007\240\260\270\177\226<\022G\347r", 56, "\301\012\025e\324\275\356\211/\024\333\010m\340\215$\313\227\353Er\2542!\356x\343\022H^\244\340iQ\315\310\205\373GP", 2000, "\005L\2216\245Z\244\305\303*1y\216\265Iv\251\357}\252\021\266 \360\357\250\2561<\360\252'\367R'}s\300\222\272\222\362\273\213\211\342\217*\331\202\363y\320\252\024\005+\027\362\204\225\333T\350", 64 },
	{ "\357e H\330\351\0252zv\002\251-\312\306\276\001o,\362\311\252#\251\333Y\224\264\350\010QK\305\252\267<\365E\344I\027\320V\015\307\262\3329\372\000\024\014\205\275\233\345", 56, "\346\346E;a\347\331\341\314\242\273<\275-\342<\231\250\306)\017\336\244\360:MN\220\017\231\220\261,\245\310}g$G\222\012\300{\225\364\3515\204", 2000, ":\310E5\210~\277\205\206yLcX3R\005\244\000\301NzZ\320\305DY\370,\357\3507P\255\3762\377\260\230\372$\214\261\230?\322\366M\256Lq\314HtP\300L\335\327\363\2175\256\375\035", 64 },
	{ "\007\213\376-\304!\347$\204\002I&\3417\027Y;\243$$ \001\007U4J\216\000\331\274\277\232\212'Ay\275\022q^\200\000\017]\320\030\353h\266u\321\372$+&\025", 56, "\243\006g!5q\241;\2612\306Y\356\231\337.k\003\374<\016\275\210\354+\265\336\224\372\004\371\022\036\214\275?f\207\215jk\262W\241U&\006<@\341\024\015I0\034\025", 2000, "P\3443\025\023\014W\177\273\201\340\036\256\201\006\034\204\354\344\237\315\026\230\345l\014 \274\271\331\011\317#r\327G\327\277\024.,\001\323\250\251\326\025\334N f\2664P\025Cf5\312#\033?C\271", 64 },
	{ "q\020\016\307\224Z^B\014_V\3456\313\214\221\342\016\374e\207u\306%K\237\276\263\307q\250\240\302~\316\361\031\204\233\2503\261\200\321P\302I\333\372\305\357e<\017R\246", 56, "\215\246*\011\312\342\002\335~z\276\261\301\255\3702\235\375>\201\246\003s97\301\217\361$]~\357\357bpKD\177\276\330Mw\323I\327\300\241\360\010%\363\021D\377\031P`o\367s\210WiN", 2000, "\367\263X\322\212v\325\010\275\376\215ME\303\356Y\010\203_n-\256\242M\346\203\275\334'dq\207h\351\337N _\215\034\021,R2\245\311c\306r]WS\341Y\253.\235h4)t\334\024i", 64 },
	{ "\3623\374\265\252\037\207\364r\177\021\313\267\213\015\3318\010\357\361U\227\224\025=\324\274\353`\315\230\325\232\303\004V@f}~S\344p(Q\312b\353\320\326\271\365y\255\020\262", 56, "\222\356\231\372'#\017\236-\027\216\245Nl\375\225\375\202\340\326,\244\254z\316\221t\222\246\314)\2123\266E.\241\257\262\337\353\300D\007^'\035\253I\366\344\274\025\247\371\373a18/\336\037r\201VG\204\012\222Oo\327", 2000, "\024#\307\016\202=\367\037\325C\340\037\311cRcb\024\335\241\363\221eM\037\377\021\301I\333zO>Z#\225\234\267>\177\223\331\002\266\352`\261\321$>bF\370\203\267;\204\267N\234\341c\306N", 64 },
	{ "\240\275Z\322\373\303\225\042$\375\346=\213\374\323s0\245L\216\317 \333\302\032\301\334\036\266tNG*ra\263\216\352\324\323u\362-3\205\275\215\333\012\243\225\344\225\253'C", 56, "\220\021w\353\360\341\226\261", 3000, "\015Y\222H\035\213\232=\031\203\016/s\025\216v\004\0029\010\303\245R\026OES1\004\265\376\027\235b\212\2678%\261\351!\025y\317f\227a\350(q\236\270{~v\015\314\3720)z\260\021q", 64 },
	{ "gG}W\3018\377\3466b\377\031\366Z\026\034\331\252\004\307\312\014+\347\211\336\012\365\371%\301\000h\324\372\327\231\254D\272x\231\350\256\224\262\363\330\2503>\3134\007\042\035", 56, "d\243\237!U\333\364}1\256\205\030*d[\337", 3000, "]\371\224\340\342\265\361\332\335j\025z;65\363\3553\360\205\210\311\212\241\375h\321\343\010\216\025_\204\324\244\240\003J\301\034Xa}\252\365\010\232\351k\371\363|\216\360O\360\217:\016\207\214\036\375q", 64 },
	{ "}\367\206\346f\344\015=\277\240>\323\225\254\033\221\006\240K\373r\332/\360\254\315\022\355\220n]6\316qtg\373jU\211\037!\215F\301p\017\276\014\002H\301\016\011f\240", 56, "\271\340\234\017\256B\004\215X\303_\374\266l\030\302{\307BX\006Z\304\206", 3000, "\014s\2215%\226\346\340D\357\201B\3052\350\376\267\376Cy*\355,\001}%g\3242\134\012\364\251\263p\033E\275\273\215\257\243\025\013\236\033:^hC\357&\237\371\277U\265!H\242\277UIp", 64 },
	{ "\004\001=O\220Z\0158\002\250\257\3670\334\230\320\032\324\353\207\026\005\235q,\224J7\350\002\327\316\134!\3016Cn6W\3303\212d\323]bF\366|\246\015\254\225\031\277", 56, "\245(~\264\367\030+\313\250>.\277')/IC\314O\012Sa\335\212\022\276\216\255 \343\341n", 3000, "\033N+$\021\002\355\346\300`\017\223\346c\340$\347\252hPO\370\352A\263\333\322\333\003\375\361m)y\003a\310\347\250\224zSE\271`\320\264\332\322\275\012\256\001\3303\365\343\2637\360m3\033\215", 64 },
	{ "wXw\343\314\327\210\242\014(tHaGv\251\302/\202\002\006\335\343T\0174\134\244!\203E\311e\351O\316\013\371\252\372\336\334!\240\367b){\315\2225\257\374?\261\366", 56, "]U\025\035Q}x\210\277\245\337\232\231\333\370\326R\002\367\301z*0,\206=\275A{\011\317\243F\034&\232BT&\374", 3000, "X\277\340\267#\363\323&\376\305SZ\000gE\345o\254\245P\202{\306\026\263\001\2752\011\237\031\345\1778\202\033\334\003\303R\234Z\370\244\217\352\247\226\0127\134>\267R\236\371\344\361(\332\221\315\371I", 64 },
	{ "`l\246Lx\0077\366bz\205m\211\202M\321\010R\2037\231\324\262`\034i4\306\020\372\232\240.P$\346\001[\035\225\324mh\023\343\344F\3255\004\256@Mvy\331", 56, "zMu\372:U\247\274pU\027\342\003e\227\367'\031;\036:\031Pq\265>,n\200\263\322\343\020z5\357\306\326\2322\251\304\262\357\236<\264\233", 3000, "j\233\005\346w\271\237\255\003\303\210G\024\326\336'U\324x\031\014P\241x\376\215UWh,\246\312n3\355\336\347\365\027\204~P\276\234\277\240(\233`<\377\134\235\306\317\322t8\312L)07\322", 64 },
	{ "h\207V\216\261y\03652<9\227\226&p\356%W\201P7Q\327\364\247F\011\000A\356\231\263$\305\364I\257[\303 \213\352\024oa\276 \340\252\311\364\305\005FD1", 56, "\335\026^\034r\361H1\305`\226r\300\236\216\325'\321\311r\214X}\234^u\326\246|f\034Q\2267[\303J\374\203\320\255BIy@\373\345\214:]EX\262\0339\253", 3000, "E\036*~\347y6)@\261\301\345]\353\273\240B\016\177_\254\357J_\004\366e#\3220\266\306\343\013k\254\230\202\023y\232\335\257PV\227\211C`\364\244f\361Z\367\324\223\321`\024G\3558F", 64 },
	{ "\344u\365\374\030\266/\336\313\036%\372I\235\031=\263S\274\1342X\346\342\034OE\2356\342\320\2411\026\240\361\037\005\026\024\331w\307\017\333\242d\231\243\231/H\242\326%X", 56, "x\372l(*&\215\213\342\307\332\300\230N\016\251\301[(j\007\037\373c\033\225P\255\264\010E%\217\252\344\376s\257\014DZ]J\302\345\212@\364\234\276Z\262>,\336\352*#\352\366\236\351\276\307", 3000, "\203\221Z\042(\206fN:\251B\354\270\033/X\270\247N.\231e\211!\232\244;<I0\325\302\367g#\372c\262\253\014w\205r\203h^\344\221Y\214\177|\350\0002\336\312\311\317\212\241|f\262", 64 },
	{ "\002\350!k\207\037\025\225S\030X\367\326e\306\367\215\310\210\007\177A_\235\230L@\240\0255\350\356\215\332\244\005\236\215\300\376\022\207\232HQ\324\331J!\315# |}J\331", 56, "\307v(*\375\230\257b\236\360\343$\250\207\217\353\346\012X\327\372\036\340\036W\006/\322\221d}=c\010Xkb[@\362\352\266\306\342)\221t=q&C\217vC\317\245\3122\301\346O ~N\301XWf\265Z2\362", 3000, "\372\310\353\350\242\014\235c\016\324!N\375\201|~\310\342J.\260#\026\300P\035\347\011\3375\312\222\333\223\340I\227\351j\200\355+\332\223\012\227\353\302\204\265\372\206\337\300\331A{\241\341\307A\010Z\304", 64 },
	{ "\370\345\2043\373\003\330\362e\024\333\365\220\301\253u\274\272+\241\346m\256S\214\034&23\274\007\223\013KJ\233\037\374\360\327\376c\326\266\012\042\221!\215\205\257\223\261\247\000I", 56, "\260 \215p\2676n\344", 4000, "v\023x\204\270\222'\026\207b\303MY\214\026\362\2718q`\013L\351$4s9\202\031\357\250\261\227Po\376\374\307C\220\247c\234\233\211q\214ZkA\345\354\0126\257F\302\275\011+\275\361\323?", 64 },
	{ " \332\231m\244ZM\200\247\272\252S*\246z\363\203\245\375\312>\346%\016\037H\177\257S\301>f\222\232i\304\324\276\301\340\315\274\215\0334\016\216\335\306\370R\321W\267\220\241", 56, "h,\323\026\342C\263L\032\201\322\314,s\342\275", 4000, "\346\360\263\27733\200,\206\350I\346\223\022\365:{cS\036QA3/K\361\015\321~C\134N\223w+F\227\020\213t\310e8\355\235CJEN\213\036,~0GA\331\301\326t\300a\234@", 64 },
	{ "L\200\264\320\356\273-!-n\350\372\134\316\366\352\011\272\313\246}\2614\134.$\212\227b\244\333M\004kU{\372\177\342\221\227\267\301\245\202\375w\032!\352\177\014u(\354\207", 56, "\361\360\352=\212)6\356\022\223U\036\002o\321\301\246\310\341\340\225\201\341\252", 4000, "O\235\310\355\252X\357\363oKwU\363\212YD@\010\370\343KV\251\304.\376K\2662\255\262C\366\246\321\332\0244)C\316\010\023\042\240j\313p\231\217&\331\371\014\015\221\325\243\311ld8\264\274", 64 },
	{ "Q\357\325\337/\371\325\311\232\367\304Z\340D!\216\222\222+\027\031\306\265\3344i\371\134\312?6\360\300\213\326\017\2600\316\022\202\266\014\012\000<\243\224\200\325\314\340t,\367g", 56, "d\330\321\026/\236J\314\253\311.\012Qo\025\042\344\240\362\324]\330\230\356\205\307%\00267\042\345", 4000, "n \363\265\2479\017\026\366M\036\375\370+A\024\3402\376\221{MY\243\270\264\265\042\304\134O\3327\016\330%wc\013j\016\226Z\317h$\257\351\260\361AM\013\207\0366X\2763\025\212Y\354\310", 64 },
	{ "\372\353S\251N*\232\367m\316PS\270aDC\335\0057\230\276\213\354\347\353K\350\024\215\321\227\300%;\023\377\352'\017Y\177C\017\024\200K\323G\037\307:\224\340^%\341", 56, "\253\254\011\237Q\270,\360\004\332\343\026\314\360\214\227\261}\240\006\300\276\374U\0244e\3052\365\307\250\276\210\263pWU\224\372", 4000, "S\263\011c\272Q\306e\3023j\203>\261\036\274\031U8*}\365\317\253\023\255\030^J\277\331J\340]\367hpR\215\345\316{\042rr\217\236\322tB\317=\215D\274\271\371\357V\2648\236\314K", 64 },
	{ "\242\270$R\263\302\200C \233E\245^\326\265B9/6\274\201\002\223\356\263X\350\354\260\002\026]$5b\042:\257\361\004\224\207\030L\277\247\314\331\032\017n\266aP\364z", 56, "\362&\253\330W'\233\343\317%>-\037\363\223=\300(\336\20214D\240a\224R\321M\013O\221h\203\333T,\302\274\261Uz\325\276\313\346\374\033", 4000, "\204\302-S\030\327`\373\222\224v\027\247`\266\267!\216\237\241l\313\264\313}'E]r`iU\302'\037\024\375\023&i\201\305\341|\3779\305\007L\035\230\355f\357\026`\031,\031\364\3145\032r", 64 },
	{ "\273\3718\272\222\2369\211\313>\0044q\202B_\272?,:\023\313o 9ps\021m\016sc\034\312\341\202\255u\002Z\013T`!1\030>\245\2315H\177\260RJ\356", 56, "\3327\347\342\334\316\323\037n<\265\305\022\026(U\273U\321\226\303\223F\302u\024\212]\022\344\334\232\264\035E\017\254\322.\334\377\333\232\005\331\367tpQ\036\377\341\305Ng[", 4000, "\326\271\016\214\230]\256\374\2779\365\367\251\315\366\330\373<\312iV\334\202\270|\323\326{\316\301K\330\322\342*/$=\222\211\255p\315\341\306\212\011:=\264\201r`Y\201\2273\0016>C\344?\236", 64 },
	{ "7\227m\350\134\343\031f7W\004y\036\335\331Ukv*\021\231\007_8t\346\034\230\310\231\026\201\021\320\254x\200wvx\314;&\230\134\0238\205\246^j\004\240\274.Y", 56, "\201\252\334L\253x\376\302\371\036\331\347?0\006\203\256\023\370\355\360\320\024\312\2233\315\307\254l\325\270<5\010\200>l,\341\305\024\352rF*\250\375\202\341{f\303w'\276\354\347\254W\367SV\243", 4000, "\007\253\010\274\354\376#>\2160\217\243{\006:\323\322\316\042\031\353\272\0423\236\335\0314\376\315\212u\360\037\323c\363i$Kj\242]\377\241\254\004\022Z\304\220\362$4\304\343(\245JI;\032:-", 64 },
	{ "MXy\263-\363Z\231\232\325\335\271\357W\351tO\264\344\224L\367\236j\344f\313z\312\221\327\355B\3645\205L\314\242\200\017\034\217L%R|TC\241\3047Cg7i", 56, "\026\030Fd\201\364\332\313\27178\215[\022(P4\342Yv|\365\021$\371\342\367\037\220\015\331:\036\345\320!\004\3219\010\023\205R\307\232g6\031`\277\376E\335\255\035\3158e\020-\220\374([\253@\340\203T\320T\222", 4000, "\027h(\353S4\375u\200\241]h\361\360\032d\321\241\301Y\036W0\342\355\214h\253D\033r\330\266U\373\260\356\3252\301\254|\030\233\371\351\271\024\205\207\301?\206\206n\341\202\266\360\324o\373|\004", 64 },
	{ "\3277m\327|\262tWVH\216\335G\001\243%\017\322\014\233\370\351e\006\320q\332\366\031N\021T\353j\237\134\371\206\300u\246\343&\020\272[p\251?\012\312\364:\317\342\021", 56, "\212\214\351\233\011\003)\246", 5000, ">\3518\336\250\245\307\302\214\245BYr\177\036,b!E\347\326U6\343\016\373\000C\325\347\367h\000\346w\310\200\042^\276\270%p\260kv\351@\243\026\204\216&q\034K\336\315\332\276\215\352@G", 64 },
	{ "\315\332\254\231\206\366c'\237\317\177\274\326\3667\2059\214\225\255\344\206\372\010;\324[\030_pcwg\211\245g\373]X\3327C\205@6x\352(\322\351@\210e\323\237A", 56, "\327\342Ar\347I\232%-B\371\343=\376*\304", 5000, "\343\315\026K\336]\324\3025\256\241%\210}\360pQkbb\030 SL\037\362\033\223\227c\342\247\004\203\277\334)\212GEoh'\327T\327zM\354.\007[E\035\030@\306\365\344!F\204Q\253", 64 },
	{ "\231\366\007m:\350\322^\246Z:\010%^\223Uc>\203\023\307\213HY\322\336{\275\262\033\203\207\336GBWB\263\346\214eR\354\273cA\342V\303\230\336\224\212\354\230\215", 56, "E\334\345\266\361\317'G\003\260Ur\377\207f%\276[Y\336\270\034\025\263", 5000, "Uz\2652\273=\0142y8\270q\025\016\351!\314\341]\224U\004m\377_\376\0246\363\3174c\334\223Fs,VZ\016\014Xt-z\242i\372\3237\034k\360\303\011\262_2\007j\327$\032J", 64 },
	{ "\315G(\317@x\334\042\352I\265i\264\330\245\234i\007\357Bs\262u\250\275\330\2619\277\004\337\256~T\351:\376\312cD\2108+r\003?\333,>\316\214V\313\315}\024", 56, "\201F\214g\330\034\200\011\016g%i:\334\340)\213\377f>\355\237\344\350*\314D?\376B\031\342", 5000, "\206k\367\203\251N\301q\007V\375J\326\344U.j3\347I{r)\377-h]\134#\275\305\0064c\330~\042\335\207\360\326\333\235e\023|\242\243\242:3\313OZ\240\237\021\344/\317\3008e\217", 64 },
	{ "\222\356l\3701\326\313:\246\207\316k\257\360\365\302 G\011\221!\244W\325\237\225\275\242z*a!\346\001\303\334\224\202P\367\220EF\271]U\265\223\375k\366&\015j?\220", 56, "m52\324\242\260GB\307\210\314=\254=\273\244\271\313;*l\0268\203<\307\315\312\345\324S8\310`u\206#\312CU", 5000, "7\31302\342em\337\264\377\024&i\030x@\331\020\317M\332H\357\243\025\033\215\373V'6C\025\235{\027k\204\234m=#\3557\313\035\313K\3265P\226?q\215\231\004\3079G\2557+\277", 64 },
	{ "\226\373\245\177k\214Mg\014\217m\351x@\230\2028\315y\262^)>\376\002\214-\3059T\005b\300\010i5\302v\211-\215\324\222'\375\321\016\035\325\013b\033\242A\305i", 56, "Ap\266 s\336[SZ9\213>d(\362r(\022g\234\230\024\255)\364\373\215\222=\320\271\344=\012`\207E5\321\372\326\006\203G\334\331\334\033", 5000, "\364\006]2x\254\337\245\262\307S\262\342\024n8\306'\316@\024W\021\023\255\275q\337\354\274\373\337\3661%8\035\210X\350\000\030\233\344\330\223\032T\302*b}\264\020\327T\021=\211\274 C\304\030", 64 },
	{ "z0G\264\233\315\322w\013\330pI\203e\364\345H\0253QO+\233K\247\030\312)X\015\361&\177\011\362w\227%w\026\006\017\303\210\356|\237c\330\217\341\317\022\203\275\355", 56, "\002N90\334\2248\025\372\377\270e\217\177~\022\236\326\204\204\241\027\372\317\341\267E\321{]\035\010K\350\307O\376\357k(\032\353Ss\331+\003\272\227U\020Q\015\3475\211", 5000, "\036gd\256\314\235\332\200\031Mj\321\212\277s\242\212y\260\274\351R\344\306\271\260\251\225X\304\375O\311tD\323\355\354\335\356\371\242\210\372\214\321D\352\275=#\033\330\002wY\037\351W\317g\241P\266", 64 },
	{ "J\315\270(J\265\215\324wO\210\3715\354\340\262\266\275\305\007xC\334a\347\356\011&\3040\220\314d\342IP\364\035\236\200\247\236\213\013\276r\036b\034'\373\253\263\025\270\247", 56, "\357L\364\021\202#\030\377a\303\301\252\345\012\036\322\030\250\334\361L\014EO\253\2407\362[|\360\207)\3719\022\363\023\200\252\036\322\026c\354\351\214\373k\351w\237\237\320\316\247MiI\232L\204\264g", 5000, "\037\300n\247=\220\010\004>\324\254\342o\310\320\305\313u\337\240\023^hu\377\250|\342_\006\017\266\366\353\251\373,\341\332\264-\253\364\265\320\212\021\021\252\035B\252\313\372\214fV\214\2120\202T\224=", 64 },
	{ ".\364\006\326rx9x\200|\254\252\003%\344un3\024v?D\274$\201\256\336\272\357\324\032\236\307\335\320\220=\272\134]\2768\256$\211\270\013\311\314,\013\222c\315\362f", 56, "\370\015s\034K{\276\233R\352\313\025\300*7\010e\0249F\020)\232T_G\037W\226\320\215\301\204\247\266!\010\3077\206,\270\371z\037\215\353\204\331\316t\220\323~\257\036\372`(\305U1\177\205-\350~cf\226\370\322", 5000, "~0-!\013\375'\213\234~\210\307c\206\216\016&\2051\003\201\000\317_\2407\223G'F\222\370-A)j\205Iuc\363H\017\316\255\236t\005\244\273\030\3047\024\376$$\030\331\003\224\332\012\347", 64 },
	{ "\265i\217\357\251$\334\0375\021h\372pW\343\302\015\004\303\330Kt\260\023\217\327\3469\225A\256\236$\246\004\361 \333\033\262%|\262\310\312\211\321\362{\270\207\020]Q\213\247", 56, "\0379\366\2507\005\313e", 6000, "\202\242\214\005`\305n\003\017\252Z\374\202\256\201R?:4\370\220H\042wiM \337\264G:c^\260%@\361\177\033\342\223\356G\2627\252,\201\341;\035\361\015\360\361U\326\212\207\236\017v\342F", 64 },
	{ "8.g=\300]\3713\257:\002\227\211\204\307h\332\007'\304\347\274\271\243|\356pR\203Dg{g\034Y\255\325\031\273\204@\212\224GL\020t\3531\303\231:\042\025\203\371", 56, "c\272\265\314\257\347\241c\3479\007\344\302m\325\240", 6000, "\242\2346\366\377T\302\300\331\244\254~O\336o*\342\215\252\261\252K\031m\356\327\3763\213?\345\020\026\035\234\230\357W\235+\215\026z\274P\256O\2303\203%%2Z\237\220&\027\267\371\203\036\276e", 64 },
	{ "\2669\264\317\377=\221E\245\027\210r\351\2560 ~2\263]S\005\224\300\206\3775\217\226\357K\027\362\320\212e\241&3w{[\344{U\221\330\242\240X\015\312\245\346\225\217", 56, "\024\226\020\220P\001}\367\223|\347h\300!\204\314\366Vo\037U6Q\360", 6000, "{\005\313E\205\0010v\224\343\220\036\002\365a\312\337A\226ws\026\003\333\342e\351\015O\234i=\355\204\271\221\306\023\366\256\375\365e\227>\013\022<\227\264\357\310[\224\305\211 \206\366\372\333e\350>", 64 },
	{ "\341\373\346\376\351}\267\354v\235\244py\242\263\367\364\240\253\027Y\240\233\346t\334r\331\211\033q\302\330[K\374\257\002h\013\007Q\233\272b\233\205zL\353\210\234h\344$\231", 56, "a<\337v>4\001\017Li!\364_\365%\224b\335\340\255}O\321\243\322\033\266\270\371\027\272\220", 6000, "\230w\354\334c\222L\007\012\314\231>\355+?!\216\005V\3243?\014\267A\3444\240\0165[+\242J-\261\214\323\371\007o\356\240\362\007\216\2034%\225V\347RF\275\341P*\034\036\200\257\351s", 64 },
	{ "\005g\321\231 \371\325C}-Q\261\261\263VDt\323\261o\206y\253\235 \272}v\262&Q#\233>*r\335{I\225w\015bt\306\226%f\027\277\350\361\373J\304\277", 56, "jv\354\235Jn\361q<\366\253.1\343\216\323\354K\253\023\2310n\237\352\272t\327hO\211U_\333\375\274\215f\231.", 6000, "(\252\210\221r<A\353\002=\2742\241Y7>\307[{\004V\233\313Ab\022\227F%\2334\231\016 _\307\000`C\012c\303\266\213t\260\203\000N\365\002\372}\217\001\233\226\327K\332\332q_l", 64 },
	{ "\232*y&!\3075^\025\241.\2739{\274\351\310\252\236;\307Hj\002\042#\311\360\251\036\200\250\245\306\012V\377%<\134\370\0221\334n\376,\373\006\375\273\327%S\331\211", 56, "\206\223\357_\031\324\205D\332\203\312\005\304^J4\042lk\323\222\215\235n\331\350 T\260{\236\344,\227\256V\316{\273\034C;\026\343L\031\207\341", 6000, "\213q\256\366\276\227\372\017\204\037#\0034M\233\177\347\250\265B\316xv\373\371\326\260z^r\334g3\244k_\321\243z\220\356\304\026Z)\300\377\323F\302\200\026\265Q\220\376=\025,\211Is\302\264", 64 },
	{ "u\243\362\207\275\261\325\345e\024R\034\212\007\252\352\324\225\024l1h\361\331_PQ\270\030aR'G\314\312e\2649O\362z\030\303\204w|\352\342\317\313^\377>*\256\263", 56, "\355\254\364\372\037\042?\221\206\351\017\326\231\365\326\035\222\214]w\246\227\016/\370\271\312\312<\266'\367H4^3F\006\034\373\353\001\233K\031\310\036\341\316\373Y\0211\201\314u", 6000, "\252u\356\0018\177ui\252x\250\037\343 1\276b\011\327/o7+\204\372)Dp\361\042\267L\375{\330\006\201@\357\261\017\315\223RD\332]\247}\231\134\022i{D,\232\227\010\364\274\355\315Z", 64 },
	{ "\224G\316\306\324\260\011\215\134\312H\020\222'\036.\211{\211c\357.\270J\272u\217\205,\2230G\273\277\214/\026!\227N\212$\211m\313\372\311F9\231\320\210s\372\264\204", 56, "\272\026n\216\027U\033R\203\262\220\250u\214\312\246S?M\204\334>\237M\277\003\035F\317y\022\006\004}\250\233\237i-\233b\011\370C\211\303X\212\003&\265\224L\177\042p\236\3318/\020\271\261?", 6000, "\134`\303\203\364\271\322$|\256\366P\007\202\226\031\220\025\360/\267\324\273\005\356D\015\207~\356\342-\215\212`\004\033R\215\312\273CWY\000\004W\015\320#\245\202\223\327\373\205V9\241\374\034\022\3159", 64 },
	{ "\340\363\363\362\356\304o\2367\377V\014\243\003;\373`%\351\020,H\302\260\232{\260\343\327\340\265\0227A\367\313\221\002\205\242\205G\232*\001\276o\305&b\030m\007\351\027@", 56, "\004\207\302\232q\277;i\254\333!w1\033h\0278\304<\022\035\353\034\010\300\267\232\317\012Pb\207\232\342O\217\005\006\217\273\210iPc\325\252/\003\244\224_!\232\315\266{\023\227E(<\261\024JI8r\210\2710\373Z", 6000, "\334\3669t\257\252\235p\023\211U\354\343\2348\367R\003\274b \134>\313Eh\271i\205\265\000I\354\275\230\017'\271\273J\301\274\233\225xm\222\260\003s'\317\364J\373j\034\014x\250\276\276\376\016", 64 },
	{ "w\240a\223(u\245\026J\256\255\306\377\243k\225\340\221i\216\216\302\262\025\341\270U\305\372j\371\305\254\374\334\3327\037\260\012\322\342t\007\214 UMsD\134\250ZS\373\016", 56, "\374\012\220Y\213\257\2431", 7000, ":\234\204\235\271=\021\351\317\3118\177\035\330\377\03744\241q\343\275mE<\376\302\361M\255X\356\275]U\202\346\364\010R\220\374\3200r\023#\236\214\370\134\340\026\244\370\204\324V\212]TL#\251", 64 },
	{ "5\251\013\363\345(\332(V5\024,\253\357jM%\002fY\334#K4I\234\274s\233\210\217C\334rz+h\036\300t\226\307\207\245\034F*\235\326\330\011\337\226;\006\244", 56, "\207\350\215\302z\042\273.\320\233\020\200\262\021\331;", 7000, "\346\262\214\322\240\221\245s\337\350\3267Ls.\2127Q\272FR\255\366\374\303\025\231\352&\244\220\337\272]\010\037\226g\001\237\235wp\226\205\337v5\263\253\034EU\272\033\234f^]\237\042M\253\321", 64 },
	{ "\343i\022\337+\261\334\250\377\356\317\356Mr\345\361%w\312-bn\326\333\244\177p\301\034\363R/o\305\337w\244\357\233\303\372a\314\3338\3169\011\232\006\317\254\010\035\345G", 56, "\374\240\034\270<\0135\004\003\342X\001\361\307C'\202)\033J\377\231\224z", 7000, "\032J\134\325\346\021T-T\311V\221M\261V\015\2547_\276\042\373X/l\322\321Z\255\371\225\271_\211?\206\316\322\300\015\366\011\366\352\277\215\271c\315\306\134\335\201\031]\353I\332&l\315\302\322U", 64 },
	{ "\361\230\217,A\213\276\331\303XzY\367o}\366v\031q\3678\303$\216\277,\217CA<\320\234\035\211\004\033H5\271a\257c\017\254\367\351\235\031KvH\304c\241r\307", 56, "\272\240\335\247\215\351!B\254\027cB\021\030\233w\330\227\344\010_L\226\271\357\036G\242\322}\012b", 7000, "\371?.\335\334\200\306\013\030\243\232\271\360\252\345\372\305p13c\314\327\363pv\232-\273\334jp\352Y)u\305\260m\252?M\272p\377\257\012\244J\020|\212\357\232\337\026\234\245Z\350U$\305l", 64 },
	{ "\332\245\264\301\004:\003\263\257\003\277\233\207\246\365u\003F3\221;\300{\371\274\012#\242S\017\236[\006\004\327r!\363I\275\365\356\016\215\025\243\341r\201\016\036\207\306kv\021", 56, "H\314\335L'\331N\267[oM\222#x\031S\3512\206K\204$\252B\204\255\363\371s\372\034\257\334\202\003o\211\320\227\005", 7000, "W\004\203\264\313o\310\202\2079\240\353\344\271\2138\034\377\350\002\226\0277#f\224s\226\274G\225\035\214Sda\326\026$k\042u+\272\004(\341\006\343(\365k\315C;gl\331\364ZS\014\022s", 64 },
	{ "#\221p\356\360\223\223'\034\026\030\236\253(\267\033HF\324\300\371\367$\013\210\275\022\252l\203\002\232ojEe\240\204\272\24594\313\241\320\221f\216\022\357\004\320p\252\214Q", 56, "\042\224\324R\270g<z?5\270x\202(\320\245\013\341\247,,Y\264\215\316\265W.\367\317`k\373\206O\341\201<\342\227\273\245\205\300\310A\265'", 7000, "\3255.;\376Z\302\003\350\276!\3163\035\014\012\332\241\277g|\316\232X}\247\242\344\3514\356n\335G\243\207\245f\277\015}\261gg\345\010\270\266\310\344k\377\367\337\014\201g\256\314\324\207s\223\202", 64 },
	{ "~R\300o\037d@.\235\022,\305^\010C\034\207+\200\227\037\015\2074\017O\026z\251(\330c\205\200!AHDI\0017\011\315\315\342~\233\021X\177\263\347\203\325\272\363", 56, "F\375T\324\220|O\214\203q.v\211\265k\356\342\335}\255\236N\031\311^9\250]\334\255+\342\250Fgw\037\343\177\203pW\002\254!kO\3749\027M\256j\0325\225", 7000, "\252\3305\010\001\336\361\236\030\244\244\322\254\204\270\202\263\134Z\042\235\267\220=1\013\300\310\022\215\204}#\007v\303\203\310\310n\322\030\243\2415O\302\006\314\362\271\222\207m\353_\332\366\300\002\221#\323\267", 64 },
	{ "\355S\325\002\033\230\364\010\366\016\351\201\0243\266\235\264f\003\251d>\373r\243\251\005Fl\020G\233='r\255y}\004\246qg\272@pa\253\332[A+\203+\227Q\350", 56, "\367&v\332\237\321\250\311\225\235/W\272S\301\016@\326\302^\213\034\276\235O\324\005ZM~\373\273\274\301k\313W$b\215\307GW\354\023\331\352\256\332\177n\337&\3119,\356\270\042ZJ\016\206\277", 7000, "\215\036n\277\322\242\306\231gd{g\313l\203\014\256\215\335\214\036p\316\327\237\000\000\364)R\222\316\234\030\017\204\344Y*#\230\033\250!Q\275\332'p\343#D4\250.\300\234\271\032\236u\372\3566", 64 },
	{ "\304\313M\022(7c\037\226\260\033\216.g\001\242\2649\367\230\314\317b\005t\341\267#\315:\336\312\261\265\220\015A\2417\002\324\021\323$d\214\257SW\351\336\027\323\367\307\333", 56, "\134]4>Dc\364\251\357\246=;\245\301\335H\001=\247\267t\345\374\013>\340|\340\371\3316q\013C+\356\2779\257\366G\206\346\213\201\254\256>\234\241=\362*\242\303L\207e\341RY\035O\013\266=\233\260\347.7K", 7000, "w\217\204\232\275\237\303G.\343`\214\304\241\322\205\340\342\251)]\306\215\021\031q\373\037U{\037\362\355\343\001A)\337,\222\014\221\231\255\203\272$\365\343\233O\231k\2148&\262u\032\204\326&\001\302", 64 },
	{ "i\344*\341C\203y\320W\001f'3\024\375o\222%\314\224\225\314}\213\200\217\314s\333\243/h/5\210\340M\241:\240\225|,W\313\260\250*?\210\347;\232\210\270\233", 56, "\355\247{\345\203\211\353\330", 8000, "\013\202O0\212\372\013\263\373\377\240\212%\277)\275*\276\021\341a\351_\313\2053\217\012*\210\334\023\232z]<\017-}\313\002pMJ\370^\261\245s\004\342\316\232\250\015F\332 \253\027\313\210%V", 64 },
	{ "\204\312\321\371\353.\037+\256\220Q\266\226\203$a|;\020\262\301\357W\242I\313\201\223\007x2\017\363=\005\212\253\0135\220\002\037\264\0072\251\256)\346\323g\005\255\340\020\241", 56, "\005\233\241\260k\013\253\216fx\234Jq\311%K", 8000, "\277d\331>\026\270R\316\032\001\263`\347\017w[\020\201\020\021hI\007n\353\256j*\303\2069\016\335b\236\376%r\250\200\212\203\004\236{\350\326L\232hvu\234\232\376\134\267h\246\312\304l\326\332", 64 },
	{ "\026+7)l@\230\345\361\206\201\314A`\274\231\370\365\300\033 \367\273\324\226.XZ\003\206!U\3673\371\205\042\324\314\331\340D\350*BoD\357\357W\233\036\243\230\006s", 56, "!\272B\012\3167\023\1341\240\341b\270\301\356\333\350|\252J\364\323\204\031", 8000, "\3419L\027\255\212\337\020P\242\036?\037_\306 m\257\243\017\042j\224\036\365[0}>\226\0314\372\236\343\331d\336\3056D\327nP\310\347\024\031\005*U\025X\004x\332x\240\032\003\004Q\250\236", 64 },
	{ "\005\327.\210\317\303\217\314\266\376Z\216\271\252V&\314\021\307bb\010\026\315\004\327\370\015\362A\277\317\307\202\014\035\315\2031\303$\341\275\241\3575n(\357\271\355z\312R\233\361", 56, "\206\306%\304F\216\250\010\260\330\263'o\266\221\373\012I7\311\357\261\273\2506~\217l\246X\372\277", 8000, "\365\200\304y\350\342\307J\247\222M\210\251c+\345\006\230\221h\226\247\373L\212\230\375\243G\224\232\021\022j\261\243\255\230\011\201.s`\325\003\032\237\305\247H},Tu\376,(\310\365\177\007\376\001\273", 64 },
	{ "\343\204\321&\260i\336\353\031\313\254j\371#\035\010\304\330\004\331\227[\206\357d\177\205\036\371\267\214\376g\254\215\321i\031\312nR\363Iml\363\323\343\320d\260\343q\375\015}", 56, "k\213\314\005\244\252\010\220A\232`*v\276#\376\206\201\344\331\363&\276s\353F|\2328\203\2217\203\020\256\2654\222\024M", 8000, " [Wz\347\360`\373\002\177\270KD\001\337\200\322\351uWf\264\331\005\276}1;\252\325\000\225\233\236\260\3426\024t\221x\226\024\134\313S\375zf\240\221\202\361\010\367\007?\242\240\372\320\003\354\322", 64 },
	{ "\273\306\042\266\301\276\015\366\257V?Za\314\002\353\015\227\312\034\250\344`_[A\371\246\276\362t\023i\361(\363@ f\024M>_\007\272.\225\026\271\005T\042\004\021~\345", 56, "\004o^\305\371\003\222\212\020\013/,\263@A\363\345\010I\373\374\244UU\206 \306M\042o3\216\375d\003H2\034\210}U\015P\221yPa\234", 8000, "\274\240\337\035\373\013\333-\251\025n\350<3\352\010\002\331\257K\307\015vW\177\033N]\020J\200\215\226\320M5\317\030\353\0259\302\344\262R]EI\252\301J\266(S\345\351]Z\206bS\011\024\251", 64 },
	{ "\303\311}s\360\326\304\311\252\003\356\334\004,T\025x\011\304l\260\357\243QW\014\330\231 F\343\177_2\323\0069\035\003\357\221(!\214\032\3234\016\216]f\374H\254\250}", 56, "\3039\277\272\024\260z\270b\325\027\026j\255\233\221\005c\234\311\217<\030\334\134n\030\314O\263\206\305\370j\025\247\337\347\357\376\216o\243\017\255\007J\037\306\375Q\032\370NA\344", 8000, " \301\0206&\260h\2467\031\331\261 \357\331@\205R<f\312\223\213#!\015tF\221^`*&\247cH\237\2449\303J*z|\306\007\360V}\256\002`$\263\331\025Z\022%(Wt\320\016", 64 },
	{ "G8e\021\244L\350ju\373R\2218\240\274\015}\246~\343gIV\177\362\0013\366l\305\216\364\225N(H\311\303\005\001\015,n)\310\024\363X}EH\007\216\232-\246", 56, "\005\366\311\342\271\275\331I]\026\307\036\245-\340\366\213J\254\3375\226\305\246\315\376\343+U\360\236\231\015E\260\256\241\354\371\204y\223\210&(4'\256D],e\213\350\302\026\224\017\235\006\025\277-\316", 8000, "\251\015\235R?\347\252\222}\207\257\225\233\314\3006\330\215\345\331\001\330<\216\263\326xw\225\274\023\216\214\352\270\363\312\276\352A\324Q\010\265\272\033\006L\0016\221\200\340O\006Y\345q2\241*7\256\220", 64 },
	{ "S\322s\224\035\253\236\346\253\303\0233\212wR\257\216e\263\353LU=v4X\365p\314\261\274\225|\014\223\022>\267\302\356\247\372T\336\000\322\034H.\276S\217\010\014\1341", 56, "\372\0219I\011a\260\233%\216\365\330Z n\326\235U\347q\022F\336\320\221\342\002\250\357\240{\355\271:\306\200\267\210M\330L?\336\013\364G=\316!:~'\321\361\233\220\2210'\247|GB&?\334M\022\334\211\031Z", 8000, "\373\274\245a\037\033!Dp]\3008qd_\324\230\200\320R\360\243[-\242_\342\365\023\021!\033\346\347\345\232\203\365\007\215r\324XG\274\322\310\214\336\334\211\245\257\355\226\201Z\323\3741\337 \237@", 64 },
	{ "\370\221a9\304\262cxsb\235\211j\215\035\007\367\226\360\207XE\335\321y\216.\373X\005\364_-H.\271\037\033\354\276\2456:#\334`\235j\363\342h\227\353\373[\254", 56, "s\321\003c\253\276\2318", 9000, "G\032f_\366\311\216\232\014\241\207J]\022\006kT\322\317Z/%J\346\333Rfv&\025y\201\257\262\327R\236\312\235\317*\212\210\245y\330\244\227\233\014m\344c\356\332\314_V\0037\347\206\012\224", 64 },
	{ "\201\277`\274\035\031Q\005\203\236\273\347\220\035\376#\340\367W\371v[[]\337s\207\265\363\035o\317Vp\344-\302o]\365\236u|Q+\313\211\231^\015\275\302\355\025\012\276", 56, "bY\344y\232N\353{\216\223\325V\377k\015\253", 9000, "\017Qz\026\032\317\311\344\330\216\374\250\300*\025\247\003\001\000\245\212\310sh:\030\243\030\222\004$\261\000\345\253,.]\360\337\035\374\242(\322G\177\345\357\274|)oyC\224\303\330\351a\344D\031\203", 64 },
	{ "\305V\021]v\311\360M+\335\017\306\216.\271\223#u\270OyKv\223\272\257W\300;\036\022\317\246&\250Vbb\253\2122\225\300\360\266j\203J\251\314g\220\206gh\222", 56, "C\377\366\0061I|\266\311\017.\363B/\353Dr\347\231\237\301\342\323\302", 9000, "?\033~\211\011\320U\277}ye\350\012H\024\340*h\203\015\374\244-\324q4mR\207n\321\3211\213\260\311\023/\215\013\374\311\026\256\304O\200\177\375\272\021\214\227\005X2\355\330\207\276n\244<\271", 64 },
	{ "r+^\375\266{\207\022v/\232\354\272P\265P\035;\264\325.m`\017o\334\333\226\344\017\375y\376E\321\002?\134\372\036$!\035\331\341\224A=\272;)\277\374\361\3567", 56, "b\254\231v\245\267\217\012\314\266g\273\016\356\241\326N\370\343\360/(\256;\321\030G\376g\2359\007", 9000, "\023\243\234BS\134|\237\3667\244\015\265\022V\002\022\000\343z9g\230\024\331\367\015\012\253\305Z\204\220\333\255\340\027\273\260we\030\037Yq'\037\000h\361\374\207\363\204\276\210\352\343\237\225v\020rv", 64 },
	{ "\027\222\301V4\241\222\007\360uI\254\010\331xKUH7\005y\274)\241#h\340\351\346z\225\325\333/\357\354k5Nh\212O\345\215\3552OT\302M\351q\307k\272\003", 56, "\251\362\353\331h\224\336\274W\373]\345#t+\011\300\316\241%\351\232I\220u\277\037\020W\205- \253=\317\304Qgk\354", 9000, ":\356\247\042\033t\204R\017-\263\025@7\201M6\035\021\002.\031h\002\011@\307\247\033L3\227\311E_\271\232\305\224\020\3421A\000H\355\276\011\321\042Y\333=2\325l\361>\315\323\267\3218^", 64 },
	{ "L\244\250\363\025\235\235\255\3260\225\365\243\352\213>\241\320\374\321\361&,\371:5\200<#]\371\042\213\300\266\026\240I\213\320\215\224\340\030$9\212T\212GM\331\004\006\345\252", 56, "xU\307)\357\312eO-\325\035\206\250\257\222x\010K(\375\343\032:\033?\351\200\004\221\322\011\024\270\367\212\001)M\247j\015\240\234\2002Y,\265", 9000, "\034\034%B\001tR\035$c\227\2621\004K\323\375N\200,Y\220@\212\372E\325\353?\343]R'~\364\305\236)\255\255\227\211\244\221\210\345\366\026\357\321\307\372\224\001\347\253\351\207\300\257\3543u\300", 64 },
	{ "\312`\215\377\377\310\2070\277u \261;l\210-j\210\314\315\213]\335)D\375\273\345\026R\361\250o#\377\303E\030\373e\226ts]\256\177V\335\234\215\237\241d$\327\222", 56, "\347\305\001\344\333E\371{1/\335\261_\226:>U\241v~\364\216\220!\242\367\340g`M&\2664=Fj+\321f>\220\2262\300~\376\201{\341\002\3340\334\353\307\320", 9000, "\027\247P\003\356C\302\177\266j\361\206\263\033\246\011\300W2n\315\227\346\242\2635\226\233P\236B#\351\027\221a\3401$\211\033\342\225\320\241\202\005\373\272\301\342\177G\335`4\233\345z0\2748\230L", 64 },
	{ "\346\322=WAC\245\211P\230\220\321`\342\223\247\231\376\006\341\300\265\266-\335@\201\362GRT\360\214\030\247\134\024r\324\3549\254\330[j*\226\234\223\210\314\024\272!\366C", 56, "Y\212p\006\011X\241\036_B\261\231\267\205P\302\2753\212|\263\307gv\235\314+y\317\217%\243\373\3167\354\213G>\360\212xj\134\362}\306#\260\337\244\177\310\365K\375\036\002\036x\025*\374\367", 9000, "^\235\352\306\347\325!\351L8\006\321\215\263\002\366\322\031\314\224\240 P\2427\010@\325\360\003\231\324\264+\357\2474\372\347(t\042)v/\331%\3149\000$9\326\276\233,5\322\017\134\324\022\205J", 64 },
	{ "u4J\310\363\243\365\026\024j\324\372\221U\200\235\246\214\236L\300I\270\240w\274#P%\003\323\213\337t\331S^$6\230\374\005yX\374\231\035\225\025?\330\015\015\313P\271", 56, "\036\017\3424\334d\301\015\373x\265\231\300u\306\301d\332\320\350^\011DI\015\033\372\027\352\004\271H%~^W\275\367.\251\206\240\012s\211\211wkK\231\203.\204\021\364,\207\023Z\225\015c5\036\232\030\217\034\027\021\036\042", 9000, "\316\333\210\302\331v\257J\252\034;\332;\344\350\374\266\332\210?7<\307\227\211\342c\016\010\026\367cS\346\370!\266\257\031\341\337\243y\004(\307\0169\301a\313\216\327_\321\261\017\241\021\276\002\240\020|", 64 },
