#s+
custom_variable("tm_format", "slhlp");
if (tm_format == "html")
{
   tm_add_macro("vdt", "\\dtdd{\\code{$1}}{$2}", 2, 2);
   tm_add_macro("n", "\\newline", 0, 0);
   tm_add_macro("link", "\\href{#$1}{$1}", 1, 1);
}
else
{
   tm_add_macro("dl", "$1", 1, 1);
   tm_add_macro("vdt", "\\var{$1}: $2\\__newline__", 2, 2);
   tm_add_macro("n", "", 0, 0);
   tm_add_macro("link", "$1", 1, 1);
}
#s-

\function{sqlite_open}
\synopsis{Open a SQLite database}
\usage{Sqlite_Type sqlite_open(String_Type filename)}
\description
  Open the sqlite database file \var{filename}.  If the database file does
  not exist, then a new database will be created as needed.  On failure a
  \var{SqliteError} exception is thrown.
\seealso{sqlite_get_table, sqlite_get_array, sqlite_get_row, sqlite_exec, sqlite_changes}
\done

\function{sqlite_get_table}
\synopsis{Get a table of results from a SQLite query}
\usage{String_Type[] sqlite_get_table(Sqlite_Type db, String_Type query)}
\description
  This executes a query and returns the result as a 2d array of strings.
  The first row of the array contains the column headers.  This function does
  not support placeholders.
\notes
  You should only use this function if you need the column headers.
  Otherwise, use \ifun{sqlite_get_table}
\seealso{sqlite_open, sqlite_get_row, sqlite_exec, sqlite_changes}
\done

\function{sqlite_get_row}
\synopsis{Get a row of results from a SQLite query}
\usage{sqlite_get_row(Sqlite_Type db, String_Type query, ...)}
\description
  This executes a query and pushes the elements of the first row of the
  result on the stack.  This supports string, integer, float and blob
  datatatypes. Blobs are returned as bstrings.  If there are no rows, a
  \var{SqliteError} exception is thrown even if the query executed flawlessly.
  Question marks in the query are placeholders.  Extra arguments to the
  function are bound to these placeholders from left to right.
\example
#v+
   (foo, bar) = sqlite_get_row("SELECT foo, bar FROM table WHERE baz = ?", "quux");
#v-
\notes
  To get the result of a query that returns multiple rows, use
  \ifun{sqlite_get_array} or use
#v+
  foreach foo, bar (db) using ("SELECT foo, bar FROM table WHERE baz = ?", "quux")
  {
      ....
  }
#v-
\seealso{sqlite_open, sqlite_get_table, sqlite_exec, sqlite_changes}
\done

\function{sqlite_get_array}
\synopsis{Get a 2-D array from a SQLite query}
\usage{Array_Type sqlite_get_array(Sqlite_Type db, DataType_type type, String_Type query, ...)}
\description
  Executes a query and returns the result as a 2d array of type \var{type}.
  This supports string, integer, float and blob datatatypes. Question marks
  in the query are placeholders. Extra arguments to the function are bound
  to these placeholders from left to right.
\seealso{sqlite_open, sqlite_get_table, sqlite_get_array, sqlite_get_row, sqlite_exec, sqlite_changes}
\done

\function{sqlite_exec}
\synopsis{Execute a SQLite query}
\usage{sqlite_exec(Sqlite_Type db, String_Type query, ...)}
\description
  Execute a SQL query on a sqlite database, without returning a result.
  Question marks in the query are placeholders.  Extra arguments to the
  function are bound to these placeholders from left to right.
\example
#v+
  sqlite_exec("INSERT INTO table(foo,bar,baz) VALUES (?,?,?)", 1, 2, 3);
#v-
\seealso{sqlite_open, sqlite_get_table, sqlite_get_array, sqlite_get_row, sqlite_changes}
\done

\function{sqlite_changes}
\synopsis{Get the number of rows affected by a SQLite query}
\usage{Int_Type sqlite_changes(Sqlite_Type db)}
\description
  This function returns the number of database rows that were changed (or
  inserted or deleted) by the most recently completed INSERT, UPDATE, or
  DELETE statement.  The change count for "DELETE FROM table" will be zero
  regardless of the number of elements that were originally in the table.
\seealso{sqlite_open, sqlite_get_table, sqlite_get_array, sqlite_get_row, sqlite_exec}
\done
