//! This crate provides implementations of the [standards][standards] and [algorithms][algorithms] used with the IndieWeb.
//!
//! More information about what's available is in either the [algorithms][algorithms] or
//! [standards][standards] module. A required trait to use is the [HTTP Client][http::Client]
//! if you'd like to use your own networking stack that's compatible with [http][::http]. This
//! library also provides some [traits][traits] to extend common values with IndieWeb-adjacent
//! capabilities.
#[warn(missing_docs, invalid_doc_attributes, unused, deprecated, clippy::perf)]
#[deny(rustdoc::broken_intra_doc_links, dead_code, unsafe_code)]

/// A collection of algorithms commonly used in the IndieWeb.
/// This module provides a collection of implementation of known
/// algorithms when working with the IndieWeb or adjacent tooling.
pub mod algorithms;

/// A representation of errors from the IndieWeb error.
pub mod error;

/// A facade for HTTP interactions when working with this library.
pub mod http;

/// A collection of standards that the IndieWeb can support.
///
/// View <https://spec.indieweb.org> for more information.
pub mod standards;

/// Traits to extend everyday functionality with IndieWeb-adjacent tooling.
pub mod traits;

mod test;

#[doc(inline)]
pub use error::Error;

pub mod mf2 {
    #[derive(thiserror::Error, Debug)]
    pub enum Error {
        #[error(transparent)]
        Parser(#[from] parser::Error),

        #[error(transparent)]
        Types(#[from] types::Error),
    }

    #[doc(inline)]
    pub use microformats as parser;

    #[doc(inline)]
    pub use microformats::types;
}
