'use strict';

function _interopDefault (ex) { return (ex && (typeof ex === 'object') && 'default' in ex) ? ex['default'] : ex; }

var uglify = _interopDefault(require('uglify-js'));

function index () {
    var options = arguments.length <= 0 || arguments[0] === undefined ? {} : arguments[0];
    var minifier = arguments.length <= 1 || arguments[1] === undefined ? uglify.minify : arguments[1];

    return {
        transformBundle: function transformBundle(code) {
            options.fromString = true;
            delete options.inSourceMap;
            delete options.outSourceMap;

            // trigger sourcemap generation
            if (options.sourceMap !== false) {
                options.outSourceMap = 'x';
            }

            var result = minifier(code, options);

            // Strip sourcemaps comment and extra \n
            if (result.map) {
                var commentPos = result.code.lastIndexOf('//#');
                result.code = result.code.slice(0, commentPos).trim();
            }

            return result;
        }
    };
}

module.exports = index;