# coding=utf-8
# --------------------------------------------------------------------------
# Copyright (c) Microsoft Corporation. All rights reserved.
# Licensed under the MIT License. See License.txt in the project root for license information.
# Code generated by Microsoft (R) AutoRest Code Generator.
# Changes may cause incorrect behavior and will be lost if the code is regenerated.
# --------------------------------------------------------------------------
import pytest
from azure.mgmt.policyinsights.aio import PolicyInsightsClient

from devtools_testutils import AzureMgmtRecordedTestCase, RandomNameResourceGroupPreparer
from devtools_testutils.aio import recorded_by_proxy_async

AZURE_LOCATION = "eastus"


@pytest.mark.skip("you may need to update the auto-generated test case before run it")
class TestPolicyInsightsPolicyRestrictionsOperationsAsync(AzureMgmtRecordedTestCase):
    def setup_method(self, method):
        self.client = self.create_mgmt_client(PolicyInsightsClient, is_async=True)

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_policy_restrictions_check_at_subscription_scope(self, resource_group):
        response = await self.client.policy_restrictions.check_at_subscription_scope(
            parameters={
                "resourceDetails": {"resourceContent": {}, "apiVersion": "str", "scope": "str"},
                "includeAuditEffect": False,
                "pendingFields": [{"field": "str", "values": ["str"]}],
            },
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_policy_restrictions_check_at_resource_group_scope(self, resource_group):
        response = await self.client.policy_restrictions.check_at_resource_group_scope(
            resource_group_name=resource_group.name,
            parameters={
                "resourceDetails": {"resourceContent": {}, "apiVersion": "str", "scope": "str"},
                "includeAuditEffect": False,
                "pendingFields": [{"field": "str", "values": ["str"]}],
            },
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...

    @RandomNameResourceGroupPreparer(location=AZURE_LOCATION)
    @recorded_by_proxy_async
    async def test_policy_restrictions_check_at_management_group_scope(self, resource_group):
        response = await self.client.policy_restrictions.check_at_management_group_scope(
            management_group_id="str",
            parameters={
                "pendingFields": [{"field": "str", "values": ["str"]}],
                "resourceDetails": {"resourceContent": {}, "apiVersion": "str", "scope": "str"},
            },
            management_groups_namespace="Microsoft.Management",
            api_version="2024-10-01",
        )

        # please add some check logic here by yourself
        # ...
