# Merge tool docs

The merge tool is an handy tool that helps to merge an old version of a spec in a new one.

## Usage

```sh
npx @withfig/autocomplete-tools@latest merge <oldspec> <newspec> [-p, --presets <name>] [--ignore-command-props <props>] [--ignore-option-props <props>] [--ignore-arg-props <props>] 
```

## How it works

Basically it keeps everything from the old spec (which must be the one that has some manually added properties, generators...) and overrides the properties that are specified in the [options](#further-customization) or in the [preset](#presets).

## Presets

We provide some presets to be used along with our [integrations](https://fig.io/docs/guides/autocomplete-for-teams#next-steps).

For example if you regenerated a spec after an update to your CLI structure you can easily pass the `--preset <name>` option to the merge tool 
and it will merge the two specs like magic keeping the options you customized in the old one but also adding, removing and updating everything new.
```
npx @withfig/autocomplete-tools@latest merge old-spec.ts new-spec.ts --preset commander
```
> See a live example directly in this repo [package.json](https://github.com/withfig/autocomplete-tools/blob/262cc31134e95e50ee546c67d343ea6661e17592/packages/autocomplete-tools/package.json#L11).

## Further customization

If you are not using any of our integrations because you built some custom generator for your specs, 
then you can customize how the merge tool behaves through some options:
- `--ignore-command-props <props>`: the **command** props that should always be overridden
- `--ignore-option-props <props>`: the **option** props that should always be overridden
- `--ignore-arg-props <props>`: the **arg** props that should always be overridden

There is also another option that allows to specify some kind of props that should always be overridden in each of the contexts specified above:
- `-i, --ignore-props <props>`: the props that should always be overridden

### How all these options will help me?

Well, if you built a custom spec generation tool you are probably generating only some of the several props 
that Fig's Autocomplete allows you to add to a spec,
and maybe you are adding some props manually after the generation. 

With the options mentioned above you can tell the merge tool which are the properties that you are autogenerating 
so that it keeps those always updated while still maintaining your manual edits.

### Example

Your custom generation tool creates specs that only contain subcommand `name` and `description`, no args and no options.
The resulting spec may look something like this:
```ts
/* new spec autogenerated */
const completionSpec: Fig.Spec = {
  name: "my-cli",
  description: "Some description",
  subcommands: [{
    name: "my-cli-subcommand",
    description: "Some subcommand description"
  }]
  // missing options and args that have probably been manually added in the old spec
}
```

So you will call the merge tool with the following options:
```sh
npx @withfig/autocomplete-tools@latest merge <oldspec> <newspec> --ignore-command-props=name,description,subcommands
```
> **NOTE**: we are explicitly adding `subcommands` prop to the command ignored props.
