/*
 * Copyright (C) 1992, Board of Trustees of the University of Illinois.
 *
 * Permission is granted to copy and distribute source with out fee.
 * Commercialization of this product requires prior licensing
 * from the National Center for Supercomputing Applications of the
 * University of Illinois.  Commercialization includes the integration of this 
 * code in part or whole into a product for resale.  Free distribution of 
 * unmodified source and use of NCSA software is not considered 
 * commercialization.
 *
 */
#if ! defined(lint) && ! defined(LINT)
static char rcs_id[] = "$Id: palUI.c,v 1.7 1993/08/05 17:04:00 gbourhis Exp $";
#endif

/* $Log: palUI.c,v $
 * Revision 1.7  1993/08/05  17:04:00  gbourhis
 * Add a casting for parameter type checking.
 *
 * Revision 1.6  1993/06/16  21:20:14  gbourhis
 * bug fixed: second arg. of PalNewPalette() must have been
 * allocated with malloc, since it will be freed later.
 *
 */

#include <stdio.h>
#include <math.h>

#include <X11/Xlib.h>
#include <X11/Intrinsic.h>
#include <X11/cursorfont.h>
#include <X11/Shell.h>
#include <Xm/Xm.h>
#include <Xm/Form.h>
#include <Xm/BulletinB.h>
#include <Xm/DrawingA.h>
#include <Xm/ScrollBar.h>
#include <Xm/CascadeB.h>
#include <Xm/PushB.h>
#include <Xm/PushBG.h>
#include <Xm/ToggleB.h>
#include <Xm/ToggleBG.h>
#include <Xm/Frame.h>
#include <Xm/RowColumn.h>
#include <Xm/FileSB.h>
#include <Xm/Separator.h>

#include "list.h"

#include "palUI.h"
#include "fiddle.h"
#include "huePal.h"
#include "pal.h"


#define MALLOC	malloc
#define FREE	free

#define TRUE	1
#define FALSE	0

#define INIT_COLORBAR_WIDTH	256
#define INIT_COLORBAR_HEIGHT	35

#define ROUND(x)        ((int) (x + 0.5))
#define MIN3(a,b,c) ((a<b)&&(a<c)) ? a : ((b < c)? b : c)
#define MAX3(a,b,c) ((a>b)&&(a>c)) ? a : ((b > c)? b : c)


#define cpccell(a,b)    {\
                        a.red = b.red; \
                        a.green = b.green; \
                        a.blue = b.blue; \
                        a.flags = b.flags; \
                        }



static	List	palList;
static	List	palEditList;
static	XmString rgb[4];
static	XmString cmy[4];
static	XmString hsv[4];
static 	Display *myDpy;
static	Visual *myVis;
static	XColor defaultCCells[256];
static	XColor serverCCells[256];
static	Pixel saveEntries[256];
static  int numToSave;
static	Widget fileBox;
static	int fileBoxOpen;
static	Boolean palLock = False;
static void CBFileOk();
static void CBFileCancel();
static void CBFileSaveOk();
static void CBFileSaveCancel();
static void RedrawComponents();
static void UnDrawComponent();
static void DrawComponent();


extern Visual *GetVisual();


int PalGetForeground(w)
Widget w;
{
Arg argList[3];
Pixel val;
        XtSetArg(argList[0], XmNforeground, &val);
	XtGetValues(w, argList, 1);
	return(val);
}
int PalGetBackground(w)
Widget w;
{
Arg argList[3];
Pixel val;
        XtSetArg(argList[0], XmNbackground, &val);
	XtGetValues(w, argList, 1);
	return(val);
}

static void PaletteChangeComplete(pal)
Pal *pal;
{
unsigned char rgb[768];

	ConvertXColorsToRGB(pal->ccells,rgb);
/*
	NetSendPalette8(0,pal->palName,rgb,(char *)NULL,TRUE,PAL_MODULE_NAME);
*/
	NetSendPalette8(0,pal->palName,rgb,(char *)NULL,TRUE,0);
}

static void SaveForUndo(pal)
Pal *pal;
{
register int     x;
        for(x=0;x < 256; x++) {
                pal->undoCCells[x].pixel = x;
                cpccell(pal->undoCCells[x],pal->ccells[x]);
                }
}


static void StoreColors(pal,ccells,redraw,cmap)
Pal *pal;
XColor *ccells;
int redraw;
Colormap cmap;
{
register int x;
static XColor sccells[256];


	if (!cmap)
		return; 
#ifdef DEBUG
	printf("pal->useAllEntries=%d,redraw=%d,cmap = %d\n",
		pal->useAllEntries,redraw,cmap);
/*
        for(x=0;x < 256; x++) {
		printf("%d(%d):%d,%d,%d\n",x,ccells[x].pixel,
				ccells[x].red,ccells[x].green, ccells[x].blue);
		}
*/
#endif
	if (!pal->useAllEntries) {
        	for(x=0;x < 256; x++) {
               		sccells[x].pixel = x;
               	 	cpccell(sccells[x],ccells[x]);
                	}
		/* retstore Motif colors */
		for (x =0; x< numToSave; x++) {
			cpccell(sccells[saveEntries[x]],
			        serverCCells[saveEntries[x]]);
			}
		XStoreColors(myDpy,cmap,sccells,256);
		}
	else
		XStoreColors(myDpy,cmap,ccells,256);
	if (redraw)
		RedrawComponents(pal);
	return;
}

static void CBPaletteDone(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
	pal = (Pal *) client_data;

	/*
	XtUnmanageChild(pal->mainWindow);
	*/
	XtPopdown(pal->top);
}

static void CBFileCancel(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
	pal = (Pal *) client_data;
        XtUnmanageChild(fileBox);
        fileBoxOpen = FALSE;


        XtRemoveCallback(fileBox,XmNokCallback,CBFileOk,(caddr_t)pal);
        XtRemoveCallback(fileBox,XmNcancelCallback,CBFileCancel,(caddr_t)pal);
}


static void CBFileOk(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
XmFileSelectionBoxCallbackStruct *f;
Pal *pal;
char *fileName; 
XColor *newCCells;
register int x;

	pal = (Pal *) client_data;
        f = (XmFileSelectionBoxCallbackStruct *) call_data;
        XtUnmanageChild(fileBox);
        fileBoxOpen = FALSE;

        XmStringGetLtoR(f->value,XmSTRING_DEFAULT_CHARSET,&fileName);
#ifdef DEBUG
        printf("CBFileOk(): file is \"%s\"\n",fileName);
#endif
        XtRemoveCallback(fileBox,XmNokCallback,CBFileOk,(caddr_t)pal);
        XtRemoveCallback(fileBox,XmNcancelCallback,CBFileCancel,(caddr_t)pal);
	SaveForUndo(pal);
	if (ReadHDFPalette(fileName,pal->ccells)) {
		StoreColors(pal,pal->ccells,TRUE,pal->cmap);
		}
	else {
		if (ReadSEQPalette(fileName,pal->ccells)) {
			WriteMesg("Couldn't read as an HDF palette\nRead in as an SEQ palette\n");
			StoreColors(pal,pal->ccells,TRUE,pal->cmap);
			}
		else {
			return;
			}
		}
	if (!(newCCells = (XColor *) MALLOC(sizeof(XColor) * 256))) {
		ErrMesg("Out of Memory reading in palette\n");
		return;
		}
	for (x = 0; x< 256; x++) {
		newCCells[x].pixel = x;
		cpccell(newCCells[x],pal->ccells[x]);
		cpccell(pal->resetCCells[x],pal->ccells[x]);
		}
		
	PalNewPalette(fileName,newCCells);
	PaletteChangeComplete(pal);

} /* CBFileOk() */


static void CBLoadPalette(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
	pal = (Pal *) client_data;
	if (fileBoxOpen) {
		XRaiseWindow(myDpy,XtWindow(fileBox));
		ErrMesg("File Select Window already open\n");
		return;
		}
        XtManageChild(fileBox);
        XtAddCallback(fileBox,XmNokCallback,CBFileOk,(caddr_t)pal);
        XtAddCallback(fileBox,XmNcancelCallback,CBFileCancel,(caddr_t)pal);
        fileBoxOpen = TRUE;
}


static void CBFileSaveOk(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
XmFileSelectionBoxCallbackStruct *f;
Pal *pal;
char *fileName;
unsigned char rgb[768];
	pal = (Pal *) client_data;
        XtUnmanageChild(fileBox);
        fileBoxOpen = FALSE;
        f = (XmFileSelectionBoxCallbackStruct *) call_data;
        XmStringGetLtoR(f->value,XmSTRING_DEFAULT_CHARSET,&fileName);
	ConvertXColorsToRGB(pal->ccells,rgb);
	WriteHDFPalette8(fileName,rgb);

        XtRemoveCallback(fileBox,XmNokCallback,CBFileSaveOk,(caddr_t)pal);
        XtRemoveCallback(fileBox,XmNcancelCallback,CBFileSaveCancel,(caddr_t)pal);
}


static void CBFileSaveCancel(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
	pal = (Pal *) client_data;
        XtUnmanageChild(fileBox);
        fileBoxOpen = FALSE;


        XtRemoveCallback(fileBox,XmNokCallback,CBFileSaveOk,(caddr_t)pal);
        XtRemoveCallback(fileBox,XmNcancelCallback,CBFileSaveCancel,(caddr_t)pal);
}



static void CBSavePalette(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
	pal = (Pal *) client_data;
	if (fileBoxOpen) {
		XRaiseWindow(myDpy,XtWindow(fileBox));
		ErrMesg("File Select Window already open\n");
		return;
		}
        XtManageChild(fileBox);
        XtAddCallback(fileBox,XmNokCallback,CBFileSaveOk,(caddr_t)pal);
        XtAddCallback(fileBox,XmNcancelCallback,CBFileSaveCancel,(caddr_t)pal);
        fileBoxOpen = TRUE;
}

static void CBPalCompWindowExpose(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
	pal = (Pal *) client_data;
}


static void CBPalUndo(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
register int x;

	pal = (Pal *) client_data;
	for (x=0; x< 256; x++) {
		cpccell(pal->tmpCCells[x],pal->ccells[x]);
		}
	for (x=0; x< 256; x++) {
		cpccell(pal->ccells[x],pal->undoCCells[x]);
		}
	for (x=0; x< 256; x++) {
		cpccell(pal->undoCCells[x],pal->tmpCCells[x]);
		}
	StoreColors(pal,pal->ccells,TRUE,pal->cmap);
	PaletteChangeComplete(pal);
}


static void CBPalReset(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
register int x;
	pal = (Pal *) client_data;
	SaveForUndo(pal);
	for (x=0; x< 256; x++) {
		cpccell(pal->ccells[x],pal->resetCCells[x]);
		}
	StoreColors(pal,pal->ccells,TRUE,pal->cmap);
	PaletteChangeComplete(pal);
}

static PALChangeColorModel(pal,model)
Pal *pal;
ColorModel model;
{
Arg argList[2];
register int x;
	
	pal->model = model;
	switch (model) {
		case RGB:
			for (x=0; x< 3; x++ ) {
        			XtSetArg(argList[0],XmNlabelString,rgb[x+1]); 
				XtSetValues(pal->toggleDraw[x],argList,1);
				}
			break;
		case CMY:
			for (x=0; x< 3; x++ ) {
        			XtSetArg(argList[0],XmNlabelString,cmy[x+1]);
				XtSetValues(pal->toggleDraw[x],argList,1);
				}
			break;
		case HSV:
			for (x=0; x< 3; x++ ) {
        			XtSetArg(argList[0],XmNlabelString,hsv[x+1]);
				XtSetValues(pal->toggleDraw[x],argList,1);
				}
			break;
		};
}

static void CBChangeColorModelRGB(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
	pal = (Pal *) client_data;
	PALChangeColorModel(pal,RGB);

	if (pal->rgbcmyhsv & CCYAN) {
		UnDrawComponent(pal,CCYAN);
		DrawComponent(pal,CRED);
		}
	if (pal->rgbcmyhsv & CMAGENTA) {
		UnDrawComponent(pal,CMAGENTA);
		DrawComponent(pal,CGREEN);
		}
	if (pal->rgbcmyhsv & CYELLOW) {
		UnDrawComponent(pal,CYELLOW);
		DrawComponent(pal,CBLUE);
		}
	if (pal->rgbcmyhsv & CHUE) {
		UnDrawComponent(pal,CHUE);
		DrawComponent(pal,CRED);
		}
	if (pal->rgbcmyhsv & CSATURATION) {
		UnDrawComponent(pal,CSATURATION);
		DrawComponent(pal,CGREEN);
		}
	if (pal->rgbcmyhsv & CVALUE) {
		UnDrawComponent(pal,CVALUE);
		DrawComponent(pal,CBLUE);
		}
	if ((pal->compPen == CCYAN) || (pal->compPen == CHUE))
		pal->compPen = CRED;
	else if ((pal->compPen == CMAGENTA) || (pal->compPen == CSATURATION))
		pal->compPen = CGREEN;
	else if ((pal->compPen == CYELLOW) || (pal->compPen == CVALUE))
		pal->compPen = CBLUE;
}

static void CBChangeColorModelCMY(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
	pal = (Pal *) client_data;
	PALChangeColorModel(pal,CMY);

	if (pal->rgbcmyhsv & CRED ){
		UnDrawComponent(pal,CRED);
		DrawComponent(pal,CCYAN);
		}
	if (pal->rgbcmyhsv & CGREEN) {
		UnDrawComponent(pal,CGREEN);
		DrawComponent(pal,CMAGENTA);
		}
	if (pal->rgbcmyhsv & CBLUE) {
		UnDrawComponent(pal,CBLUE);
		DrawComponent(pal,CYELLOW);
		}
	if (pal->rgbcmyhsv & CHUE) {
		UnDrawComponent(pal,CHUE);
		DrawComponent(pal,CCYAN);
		}
	if (pal->rgbcmyhsv & CSATURATION) {
		UnDrawComponent(pal,CSATURATION);
		DrawComponent(pal,CMAGENTA);
		}
	if (pal->rgbcmyhsv & CVALUE) {
		UnDrawComponent(pal,CVALUE);
		DrawComponent(pal,CYELLOW);
		}
	if ((pal->compPen == CRED) || (pal->compPen == CHUE))
		pal->compPen = CCYAN;
	else if ((pal->compPen == CGREEN) || (pal->compPen == CSATURATION))
		pal->compPen = CMAGENTA;
	else if ((pal->compPen == CBLUE) || (pal->compPen == CVALUE))
		pal->compPen = CYELLOW;
}

static void CBChangeColorModelHSV(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
	pal = (Pal *) client_data;
	PALChangeColorModel(pal,HSV);

	if (pal->rgbcmyhsv & CRED ){
		UnDrawComponent(pal,CRED);
		DrawComponent(pal,CHUE);
		}
	if (pal->rgbcmyhsv & CGREEN) {
		UnDrawComponent(pal,CGREEN);
		DrawComponent(pal,CSATURATION);
		}
	if (pal->rgbcmyhsv & CBLUE) {
		UnDrawComponent(pal,CBLUE);
		DrawComponent(pal,CVALUE);
		}
	if (pal->rgbcmyhsv & CCYAN) {
		UnDrawComponent(pal,CCYAN);
		DrawComponent(pal,CHUE);
		}
	if (pal->rgbcmyhsv & CMAGENTA) {
		UnDrawComponent(pal,CMAGENTA);
		DrawComponent(pal,CSATURATION);
		}
	if (pal->rgbcmyhsv & CYELLOW) {
		UnDrawComponent(pal,CYELLOW);
		DrawComponent(pal,CVALUE);
		}
	if ((pal->compPen == CRED) || (pal->compPen == CCYAN))
		pal->compPen = CHUE;
	else if ((pal->compPen == CGREEN) || (pal->compPen == CMAGENTA))
		pal->compPen = CSATURATION;
	else if ((pal->compPen == CBLUE) || (pal->compPen == CYELLOW))
		pal->compPen = CVALUE;
}

static void FillHorizColorBar(buff,xdim,ydim)
unsigned char *buff;
int xdim,ydim;
{
register int x;
int y;
float xinc, fxval;
unsigned char xval;
unsigned char *p;

        if (!xdim)
                return;
        xval = 0;
        fxval = 0.0;
        xinc = 256.0 / ((float) xdim);
        p = buff;
        for (x = 0; x < xdim; x++) {
                p = buff;
                p += x;
                for (y = 0; y < ydim; y++) {
                        *p = xval;
                        p += xdim;
                        }
                fxval = fxval + xinc;
                xval = (unsigned char) fxval;
                }
}

static void CBPalColorBarExpose(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
	pal = (Pal *) client_data;

	XPutImage(XtDisplay(pal->colorBar),XtWindow(pal->colorBar),
			pal->colorBarGC, pal->colorBarXImage,
                        0,0,0,0,pal->colorBarWidth,pal->colorBarHeight);

}




static void FiddlePalette(pal,w,xdim,ydim,xpos,ypos)
Pal *pal;
Widget w;
int     xdim,ydim;
int     xpos,ypos;
{
double a,b;
double unit_Theta = (double) 3.14159 / (double) (ydim*2);
double up,down;
register int prej,i,j,k;
int     NUMCOLORS = 256;

        xpos = (((xpos < 0)?0:xpos)>xdim)?xdim:xpos;
        ypos = (((ypos < 0)?0:ypos)>ydim)?ydim:ypos;

        a = (double) tan((double) (unit_Theta * (double) (ydim - ypos)));

        up = 1 + (short) (127.0 * a);
        down = 256 - (short) (128.0 * a);
        if (up > down)
                b = (((double)xpos / (double)xdim) * (double)(up - down))
                         + (double) down;
        else
                b = (((double)xpos / (double)xdim) * (double)(down - up))
                         + (double) up;

        prej = 1;

        for ( i = 1 ; i <= NUMCOLORS - 2 ; i++) {
            j = (short) (a * (double) (i - (NUMCOLORS/2)) + b);
            if ((j > 0) && (j <= NUMCOLORS-2)) {
                for ( k = prej; k <= j - 1 ; k++)
                                cpccell(pal->ccells[k],pal->tmpCCells[i]);
                        cpccell(pal->ccells[j],pal->tmpCCells[i]);
                }
            else
                if (j >= NUMCOLORS-1) {
                        for ( k = prej; k <= NUMCOLORS-2; k++)
                                        cpccell(pal->ccells[k],pal->tmpCCells[i]);
                        break;
                        }
                else
                        continue;

            prej = j + 1;
            }

        for(;j < NUMCOLORS;j++)
                cpccell(pal->ccells[j],pal->tmpCCells[255]);

        StoreColors(pal,pal->ccells,TRUE,pal->cmap);

} /* FiddlePalette() */

static void Cfiddle(w,client_data,event)
/* Do linear expansion and compression on palette */
Widget w;
caddr_t client_data;
XEvent *event;
{
Window root, child;
int     root_x,root_y;
int     win_x,win_y;
unsigned int    keys_buttons;
Pal *pal;
XEvent report;

	pal = (Pal *) client_data;
	if (!pal->fiddleStart)
		return;

	XFlush(myDpy);
	XSync(myDpy,True);
	while(XCheckTypedEvent(myDpy,PointerMotionMask,&report));
	while(XCheckTypedWindowEvent(myDpy,XtWindow(w),PointerMotionMask,&report));
	while(XCheckTypedEvent(myDpy,Button1MotionMask,&report));
	while(XCheckTypedWindowEvent(myDpy,XtWindow(w),Button1MotionMask,&report));

        if (XQueryPointer(myDpy,XtWindow(w),&root,&child,
            &root_x,&root_y,&win_x,&win_y,&keys_buttons)) {
                FiddlePalette(pal,w,pal->mainWindowWidth,pal->mainWindowHeight,
                        win_x,win_y);
                }

} /* Cfiddle() */

static void CBEndFiddle(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Window root, child;
int     root_x,root_y;  /* X & Y coordinates with respect to root */
int     win_x,win_y;    /* X & Y coordinates with respect to window */
unsigned int    keys_buttons;
int     win;
Pal	*pal;

	pal = (Pal *) client_data;
        win = XtWindow(w);

        if (XQueryPointer(XtDisplay(w),win,&root,&child,
                    &root_x,&root_y,&win_x,&win_y,&keys_buttons)) {
                XWarpPointer(myDpy,win,win,win_x,win_y,
                	pal->mainWindowWidth,pal->mainWindowHeight,40,220);
                }
        XUngrabPointer(myDpy,CurrentTime);
        XtRemoveEventHandler(pal->mainWindow,Button1MotionMask,0,Cfiddle,NULL);
        XtRemoveEventHandler(pal->mainWindow,ButtonReleaseMask,0,
                        CBEndFiddle,NULL);
        PaletteChangeComplete(pal);
	pal->fiddleStart = FALSE;

} /* CBEndFiddle() */


static void CBFiddle(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
Window win;
XWindowAttributes pcw_attrib;
register int x;

	pal = (Pal *) client_data;
	win = XtWindow(pal->mainWindow);

        if(XGrabPointer(myDpy,win,False,
                PointerMotionMask|ButtonReleaseMask,
                GrabModeAsync,GrabModeSync,
		win, XCreateFontCursor(myDpy,XC_fleur), CurrentTime)) {
                        ErrMesg("Can't grab pointer for fiddle\n");
                        return;
                        }

        XtAddEventHandler(pal->mainWindow,Button1MotionMask,0,Cfiddle,(caddr_t)pal);
        XtAddEventHandler(pal->mainWindow,ButtonReleaseMask,0,
                        CBEndFiddle,(caddr_t)pal);

	SaveForUndo(pal);
        for (x=0; x< 256 ; x++) {
                cpccell(pal->tmpCCells[x],pal->ccells[x]);
                pal->tmpCCells[x].pixel = pal->ccells[x].pixel;
                }


        XGetWindowAttributes(myDpy,win,&pcw_attrib);
	pal->mainWindowWidth = pcw_attrib.width;
	pal->mainWindowHeight = pcw_attrib.height;
	pal->fiddleStart = TRUE;

	XWarpPointer(myDpy,win,win,0,0,
                	pal->mainWindowWidth,pal->mainWindowHeight,
                	pal->mainWindowWidth/2,pal->mainWindowHeight/2);

} /* CBFiddle() */


static void CBInitRotate(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Window root, child;
int     root_x,root_y;
int     win_x,win_y;
unsigned int    keys_buttons;
Pal *pal;

	pal = (Pal *) client_data;

	if (palLock) /* palette locked, can't edit */
		return;

        SaveForUndo(pal);
        if (XQueryPointer(myDpy,XtWindow(w),&root,&child,
                &root_x,&root_y,&win_x,&win_y,&keys_buttons)) {
                pal->lastx = win_x;
                }
	pal->rotateStart = TRUE;
}

static void RotatePalette(pal,xpos)
Pal *pal;
int xpos;
{
int offset;
register int x;
int new;

	if (palLock) /* palette locked, can't edit */
		return;

        if ((pal->lastx)&& (pal->lastx != xpos)) {
                for(x = 0;x < 256; x++)
                        cpccell(pal->tmpCCells[x],pal->ccells[x]);

                offset = xpos - pal->lastx;

                for(x=0; x < 256; x++) {
                        new = x + offset;
                        new = (new > 255) ? (new - 256) :
                                        (new < 0) ? (new + 256): new;
                        cpccell(pal->ccells[new],pal->tmpCCells[x]);
                        }

                StoreColors(pal,pal->ccells,TRUE,pal->cmap);
                }
        pal->lastx = xpos;
        return;
} /* RotatePalette() */


static void CBRotate(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Window root, child;
int     root_x,root_y;  /* X & Y coordinates with respect to root */
int     win_x,win_y;    /* X & Y coordinates with respect to window */
unsigned int    keys_buttons;
Pal *pal;

	if (palLock) /* palette locked, can't edit */
		return;

	pal = (Pal *) client_data;

	if (!pal->rotateStart)
		return;
        if (XQueryPointer(myDpy,XtWindow(w),&root,&child,
                &root_x,&root_y,&win_x,&win_y,&keys_buttons)) {

                if ((win_x <= 255) && (win_x > 0))
                        RotatePalette(pal,win_x);
                }
}

static void CBEndRotate(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;

	if (palLock) /* palette locked, can't edit */
		return;
	pal = (Pal *) client_data;
        PaletteChangeComplete(pal);
	pal->rotateStart = FALSE;
}

static void CBUseEntirePalette(w,client_data,call_data)
Widget w;
caddr_t client_data;
XmToggleButtonCallbackStruct *call_data;
{
Pal *pal;

	pal = (Pal *) client_data;
	pal->useAllEntries = call_data->set;
	StoreColors(pal,pal->ccells,FALSE,pal->cmap);
}
static void CBDisplayNewPalettes(w,client_data,call_data)
Widget w;
caddr_t client_data;
XmToggleButtonCallbackStruct *call_data;
{
Pal *pal;

	pal = (Pal *) client_data;
	pal->displayNewPalettes= call_data->set;
}


static void CBSetPal(w,client_data,call_data)
Widget w;
caddr_t client_data;
XmToggleButtonCallbackStruct *call_data;
{
PalGroup *pg;
register int     x;

	if (call_data->set) {
		pg = (PalGroup *) client_data;

		pg->pal->palName = pg->palette->name;
		for(x=0;x < 256; x++) {
		  cpccell(pg->pal->ccells[x],pg->palette->ccells[x]);
		  cpccell(pg->pal->resetCCells[x],pg->palette->ccells[x]);
                }
		StoreColors(pg->pal,pg->pal->ccells,TRUE,pg->pal->cmap);
	}
	
}

static int PalMakeViewList(pal, palette)
Pal *pal;
PaletteEntry *palette;
{
PaletteEntry *p;
PalGroup *pg;
Arg argList[2];
Cardinal i;
Widget b;

	p = (PaletteEntry *) ListHead(palList);
	while (p) {
		if (!(pg = (PalGroup *) MALLOC(sizeof(PalGroup)))) {
			ErrMesg("Out of Memory while getting New Palette\n");
			return(0);
			}
		pg->palette = p;
		pg->pal = pal;
		i = 0;
		XtSetArg(argList[i],XmNlabelString,p->motifName); i++;
		if (p == palette)
		  XtSetArg(argList[i], XmNset, True), i++;
		b = XmCreateToggleButtonGadget(pal->pulldown[2],
				"menuButton",argList,i);
		XtAddCallback(b,XmNvalueChangedCallback,CBSetPal,(caddr_t)pg);
		XtManageChild(b);

		p = (PaletteEntry *) ListNext(palList);
		}
	return(1);
} /* PalMakeViewList() */



static int ChooseColor(ccells,whichone)
/* pick the best entry in the palette to match color */
XColor  ccells[];       /* the palette */
int     whichone;       /* which color to find in palette */
{
int best;
int best_cmpval;
int cmpval;
int x;
int r,b,g;

        best = BlackPixel(myDpy, DefaultScreen(myDpy));
        best_cmpval = -1 - (1 >> 18);
        switch (whichone) {
        case CRED:      /* find purest red */
                for(x=0; x < 256 ; x++) {
                        g = ccells[x].green;
                        b = ccells[x].blue;
                        cmpval = ccells[x].red - g - b - abs(g-b);
                        if (cmpval > best_cmpval) {
                                best_cmpval = cmpval;
                                best = x;
                                }
                        }
                break;
        case CGREEN:    /* find purest green */
                for(x=0; x < 256 ; x++) {
                        r = ccells[x].red;
                        b = ccells[x].blue;
                        cmpval = ccells[x].green - r - b - abs(r-b);
                        if (cmpval > best_cmpval) {
                                best_cmpval = cmpval;
                                best = x;
                                }
                        }
                break;
        case CBLUE:     /* find purest blue */
                for(x=0; x < 256 ; x++) {
                        r = ccells[x].red;
                        g = ccells[x].green;
                        cmpval = ccells[x].blue - r - g - abs(r-g);
                        if (cmpval > best_cmpval) {
                                best_cmpval = cmpval;
                                best = x;
                                }
                        }
                break;
        case CCYAN:     /* find purest cyan */
                for(x=0; x < 256 ; x++) {
                        cmpval = ccells[x].green + ccells[x].blue
                                                - ccells[x].red;
                        if (cmpval > best_cmpval) {
                                best_cmpval = cmpval;
                                best = x;
                                }
                        }
                break;
        case CMAGENTA:  /* find purest magenta */
                for(x=0; x < 256 ; x++) {
                        cmpval = ccells[x].red + ccells[x].blue
                                                - ccells[x].green;
                        if (cmpval > best_cmpval) {
                                best_cmpval = cmpval;
                                best = x;
                                }
                        }
                break;
        case CYELLOW:   /* find purest yellow */
                for(x=0; x < 256 ; x++) {
                        cmpval = ccells[x].red + ccells[x].green
                                                - ccells[x].blue;
                        if (cmpval > best_cmpval) {
                                best_cmpval = cmpval;
                                best = x;
                                }
                        }
                break;
        case CHUE:      /* find purest orange */
                for(x=0; x < 256 ; x++) {
                        r = ccells[x].red;
                        b = ccells[x].blue;
                        cmpval = r-b - abs(((r+b)>>1) - ccells[x].green);
                        if (cmpval > best_cmpval) {
                                best_cmpval = cmpval;
                                best = x;
                                }
                        }
                break;
        case CSATURATION:       /* find purest purplish color?? */
                for(x=0; x < 256 ; x++) {
                        g = ccells[x].green;
                        b = ccells[x].blue;
                        cmpval = b-g - abs(((b+g)>>1) - ccells[x].red);
                        if (cmpval > best_cmpval) {
                                best_cmpval = cmpval;
                                best = x;
                                }
                        }
                break;

        case CVALUE:
        default:
                /* find purest black */
                for(x=0; x < 256 ; x++) {
                        r = ccells[x].red;
                        b = ccells[x].blue;
                        cmpval = b-r - abs(((b+r)>>1) - ccells[x].green);
                        /*cmpval = 65535 - ((ccells[x].red + ccells[x].green
                                        +ccells[x].blue)/3);
                        */
                        if (cmpval > best_cmpval) {
                                best_cmpval = cmpval;
                                best = x;
                                }
                        }
                break;
        } /* switch */

        return(best);
}

static void UnDrawComponent(pal,component)
Pal *pal;
int component;
{
Window	win;
	XSetForeground(myDpy,pal->compWinGC,pal->background);
	win = XtWindow(pal->compWindow);
	switch (component) {
		case CRED:
			XDrawPoints(myDpy,win,pal->compWinGC,
					pal->rpoints,256,CoordModeOrigin);
			break;
		case CGREEN:
			XDrawPoints(myDpy,win,pal->compWinGC,
					pal->gpoints,256,CoordModeOrigin);
			break;
		case CBLUE:
			XDrawPoints(myDpy,win,pal->compWinGC,
					pal->bpoints,256,CoordModeOrigin);
			break;
		case CCYAN:
			XDrawPoints(myDpy,win,pal->compWinGC,
					pal->cpoints,256,CoordModeOrigin);
			break;
		case CMAGENTA:
			XDrawPoints(myDpy,win,pal->compWinGC,
					pal->mpoints,256,CoordModeOrigin);
			break;
		case CYELLOW:
			XDrawPoints(myDpy,win,pal->compWinGC,
					pal->ypoints,256,CoordModeOrigin);
			break;
		case CHUE:
			XDrawPoints(myDpy,win,pal->compWinGC,
					pal->hpoints,256,CoordModeOrigin);
			break;
		case CSATURATION:
			XDrawPoints(myDpy,win,pal->compWinGC,
					pal->spoints,256,CoordModeOrigin);
			break;
		case CVALUE:
			XDrawPoints(myDpy,win,pal->compWinGC,
					pal->vpoints,256,CoordModeOrigin);
			break;
		};
        pal->rgbcmyhsv = pal->rgbcmyhsv ^ (pal->rgbcmyhsv & component) ;

}

static void DrawComponent(pal,component)
/* Draw the color components in the component window */
Pal *pal;
int     component;      /* which component to draw */
{
register int x;
register int y;
Pixel color;
Window win;
XWindowAttributes winAttrib;
float fheight;

        color = ChooseColor(pal->ccells,component);
	XSetForeground(myDpy,pal->compWinGC,color);
	win = XtWindow(pal->compWindow);
	XGetWindowAttributes(myDpy,win,&winAttrib);
	pal->compWinHeight = winAttrib.height;
	pal->compWinWidth= winAttrib.width;
	fheight = (float) pal->compWinHeight;
        switch (component){
                case CRED :
                        for (x = 0 ; x < 256 ; x++ ) {
                                y = ROUND(((float) (pal->ccells[x].red >> 8)*
                                                (float) (fheight / 255.0)));
                                pal->rpoints[x].x = x;
                                pal->rpoints[x].y = pal->compWinHeight - y;
                                }
			XDrawPoints(myDpy,win,pal->compWinGC,
					pal->rpoints,256,CoordModeOrigin);
                        break;
                case CGREEN:
                        for (x = 0 ; x < 256 ; x++ ) {
                                y = ROUND(((float) (pal->ccells[x].green >> 8)*
                                                (float) (fheight / 255.0)));
                                pal->gpoints[x].x = x;
                                pal->gpoints[x].y = pal->compWinHeight - y;
                                }
			XDrawPoints(myDpy,win, pal->compWinGC,
					pal->gpoints,256,CoordModeOrigin);
                        break;
                case CBLUE:
                        for (x = 0 ; x < 256 ; x++ ) {
                                y = ROUND(((float) (pal->ccells[x].blue >> 8)*
                                                (float) (fheight / 255.0)));
                                pal->bpoints[x].x = x;
                                pal->bpoints[x].y = pal->compWinHeight -y;
                                }
			XDrawPoints(myDpy,win,pal->compWinGC,
					pal->bpoints,256,CoordModeOrigin);
                        break;

                case CCYAN:
                        for (x = 0 ; x < 256 ; x++ ) {
                                y = ROUND(((float) (pal->ccells[x].red >> 8)*
                                                (float) (fheight / 255.0)));
                                pal->cpoints[x].x = x;
                                pal->cpoints[x].y = y;
                                }
			XDrawPoints(myDpy,win, pal->compWinGC,
					pal->cpoints,256,CoordModeOrigin);
                        break;
                case CMAGENTA:
                        for (x = 0 ; x < 256 ; x++ ) {
                                y = ROUND(((float) (pal->ccells[x].green >> 8)*
                                                (float) (fheight / 255.0)));
                                pal->mpoints[x].x = x;
                                pal->mpoints[x].y = y;
                                }
			XDrawPoints(myDpy,win, pal->compWinGC,
					pal->mpoints,256,CoordModeOrigin);
                        break;
                case CYELLOW:
                        for (x = 0 ; x < 256 ; x++ ) {
                                y = ROUND(((float) (pal->ccells[x].blue >> 8)*
                                                (float) (fheight / 255.0)));
                                pal->ypoints[x].x = x;
                                pal->ypoints[x].y = y;
                                }
			XDrawPoints(myDpy,win, pal->compWinGC,
					pal->ypoints,256,CoordModeOrigin);
                        break;
                case CHUE: {
                        double h,s,v;
                        for (x= 0; x < 256; x++ ) {
				h = 0.0; /* undefined */
                                if (!ConvertRGBtoHSV(pal->ccells[x].red,
                                        pal->ccells[x].green,pal->ccells[x].blue,
                                        &h,&s,&v)) {
                                        h = 0.0; /* undefined */
                                        }

                                y = ROUND(((double)(h * (fheight / 360.0))));
                                pal->hpoints[x].x = x;
                                pal->hpoints[x].y = pal->compWinHeight - y;
                                }
			XDrawPoints(myDpy,win, pal->compWinGC,
					pal->hpoints,256,CoordModeOrigin);
                        }
                        break; /*CHUE*/
                case CSATURATION: {
                        int r,g,b;
                        int s;
                        int max,min;

                        for (x = 0 ; x < 256 ; x++ ) {
                                r = (int) (((float) (pal->ccells[x].red >> 8))*
                                                (float) (fheight / 255.0));
                                g = (int) (((float) (pal->ccells[x].green >> 8))*
                                                (float) (fheight / 255.0));
                                b = (int) (((float) (pal->ccells[x].blue >> 8))*
                                                (float) (fheight / 255.0));

                                max = MAX3(r,g,b);
                                min = MIN3(r,g,b);

                                if (max != 0)
                                    s=ROUND((fheight *(((float) (max - min)) /
                                                ((float) max))));
                                else
                                     s = 0;

                                pal->spoints[x].x = x;
                                pal->spoints[x].y = pal->compWinHeight - s;
                                }
			XDrawPoints(myDpy,win, pal->compWinGC,
					pal->spoints,256,CoordModeOrigin);
                        }
                        break;
                case CVALUE: {
                        int r,g,b;
                        int value;
                        for (x = 0 ; x < 256 ; x++ ) {
                                r = (int) ((float) (pal->ccells[x].red >> 8)*
                                                (float) (fheight / 255.0));
                                g = (int) ((float) (pal->ccells[x].green >> 8)*
                                                (float) (fheight / 255.0));
                                b = (int) ((float) (pal->ccells[x].blue >> 8)*
                                                (float) (fheight / 255.0));

                                value = ROUND(MAX3(r,g,b));

                                pal->vpoints[x].x = x;
                                pal->vpoints[x].y = pal->compWinHeight - value;
                                }
			XDrawPoints(myDpy,win, pal->compWinGC,
					pal->vpoints,256,CoordModeOrigin);
                        }
                        break;
                } /* switch */



        pal->rgbcmyhsv = pal->rgbcmyhsv | component;
        return;

} /* DrawComponent() */


static void CBDrawComponent(w,client_data,call_data)
/* Continues after widgets realized, mapped, exposed */
Widget w;
caddr_t client_data;
XmToggleButtonCallbackStruct *call_data;
{
Pal *pal;
int component;

	pal = (Pal *) client_data;
	switch (pal->model) {
		case RGB:
			if (w == pal->toggleShow[0])
				component = CRED;
			else if (w == pal->toggleShow[1])
				component = CGREEN;
			else if (w == pal->toggleShow[2])
				component = CBLUE;
			break;
		case CMY:
			if (w == pal->toggleShow[0])
				component = CCYAN;
			else if (w == pal->toggleShow[1])
				component = CMAGENTA;
			else if (w == pal->toggleShow[2])
				component = CYELLOW;
			break;
		case HSV:
			if (w == pal->toggleShow[0])
				component = CHUE;
			else if (w == pal->toggleShow[1])
				component = CSATURATION;
			else if (w == pal->toggleShow[2])
				component = CVALUE;
			break;
		};

	if (call_data->set)
		DrawComponent(pal,component);
	else
		UnDrawComponent(pal,component);
}


static void CBSetPen(w,client_data,call_data)
/* Continues after widgets realized, mapped, exposed */
Widget w;
caddr_t client_data;
XmToggleButtonCallbackStruct *call_data;
{
Pal *pal;
int compPen;
int toggle;

	pal = (Pal *) client_data;

	/*pal locked can't do anything */
/*
	if (palLock)
		XmToggleButtonSetState(pal->toggleDraw[0],False,False);
		XmToggleButtonSetState(pal->toggleDraw[1],False,False);
		XmToggleButtonSetState(pal->toggleDraw[2],False,False);
		pal->compPen = 0;
		return;
		}
*/
#ifdef DEBEUG
	printf("pal->compPen was set to %d\n",pal->compPen);
#endif
	switch (pal->model) {
		case RGB:
			if (w == pal->toggleDraw[0])  {
				compPen = CRED;
				XmToggleButtonSetState(pal->toggleShow[0],
					True,True);
				}
			else if (w == pal->toggleDraw[1]) {
				compPen = CGREEN;
				XmToggleButtonSetState(pal->toggleShow[1],
					True,True);
				}
			else if (w == pal->toggleDraw[2]) {
				compPen = CBLUE;
				XmToggleButtonSetState(pal->toggleShow[2],
					True,True);
				}
			break;
		case CMY:
			if (w == pal->toggleDraw[0]) {
				compPen = CCYAN;
				XmToggleButtonSetState(pal->toggleShow[0],
					True,True);
				}
			else if (w == pal->toggleDraw[1]) {
				compPen = CMAGENTA;
				XmToggleButtonSetState(pal->toggleShow[1],
					True,True);
				}
			else if (w == pal->toggleDraw[2]) {
				compPen = CYELLOW;
				XmToggleButtonSetState(pal->toggleShow[2],
					True,True);
				}
			break;
		case HSV:
			if (w == pal->toggleDraw[0]) {
				compPen = CHUE;
				XmToggleButtonSetState(pal->toggleShow[0],
					True,True);
				}
			else if (w == pal->toggleDraw[1]) {
				compPen = CSATURATION;
				XmToggleButtonSetState(pal->toggleShow[1],
					True,True);
				}
			else if (w == pal->toggleDraw[2]) {
				compPen = CVALUE;
				XmToggleButtonSetState(pal->toggleShow[2],
					True,True);
				}
		};

	if (call_data->set) {
		DrawComponent(pal,compPen);
		pal->compPen = compPen;
		}
	else
		pal->compPen = 0;
#ifdef DEBEUG
	printf("pal->compPen now set to %d\n",compPen);
#endif
}

static void PlotComp(pal,x,y,comp)
Pal *pal;
int x,y;
int comp;
{
Window  win;

        win = XtWindow(pal->compWindow);
        pal->compPenDrawColor = ChooseColor(pal->ccells,comp);

        switch(comp) {
                case CRED:
                        pal->ccells[x].red = (int) ((((float) y)/
                                        ((float) pal->compWinHeight)) * 65535.0);
                        XSetForeground(myDpy,pal->compWinGC,pal->background);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->rpoints[x].y);
                        pal->rpoints[x].y = pal->compWinHeight - y;
                        XSetForeground(myDpy,pal->compWinGC,pal->compPenDrawColor);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->rpoints[x].y);
                        break;
                case CGREEN:
                        pal->ccells[x].green= (int) ((((float)y)/
                                        ((float) pal->compWinHeight)) * 65535.0);
                        XSetForeground(myDpy,pal->compWinGC,pal->background);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->gpoints[x].y);
                        pal->gpoints[x].y = pal->compWinHeight - y;
                        XSetForeground(myDpy,pal->compWinGC,pal->compPenDrawColor);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->gpoints[x].y);
                        break;
                case CBLUE:
                        pal->ccells[x].blue= (int) ((((float) y)/
                                        ((float) pal->compWinHeight)) * 65535.0);
                        XSetForeground(myDpy,pal->compWinGC,pal->background);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->bpoints[x].y);
                        pal->bpoints[x].y = pal->compWinHeight - y;
                        XSetForeground(myDpy,pal->compWinGC,pal->compPenDrawColor);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->bpoints[x].y);
                        break;
                case CCYAN:
                        pal->ccells[x].red = (int) (65535.0 - ((((float) y)/
                                                ((float) pal->compWinHeight))
                                                 * 65535.0));
                        XSetForeground(myDpy,pal->compWinGC,pal->background);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->cpoints[x].y);
                        pal->cpoints[x].y = pal->compWinHeight - y;
                        XSetForeground(myDpy,pal->compWinGC,pal->compPenDrawColor);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->cpoints[x].y);
                        break;
                case CMAGENTA:
                        pal->ccells[x].green= (int) (65535.0 - ((((float) y)/
                                                ((float) pal->compWinHeight))
                                                 * 65535.0));
                        XSetForeground(myDpy,pal->compWinGC,pal->background);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->mpoints[x].y);
                        pal->mpoints[x].y = pal->compWinHeight - y;
                        XSetForeground(myDpy,pal->compWinGC,pal->compPenDrawColor);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->mpoints[x].y);
                        break;
                case CYELLOW:
                        pal->ccells[x].blue = (int) (65535.0 - ((((float) y)/
                                                ((float) pal->compWinHeight))
                                                 * 65535.0));
                        XSetForeground(myDpy,pal->compWinGC,pal->background);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->ypoints[x].y);
                        pal->ypoints[x].y = pal->compWinHeight - y;
                        XSetForeground(myDpy,pal->compWinGC,pal->compPenDrawColor);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->ypoints[x].y);
                        break;
                case CHUE:{

                        double h,s,v;
			h = s = v = 0.0;
                        if (!ConvertRGBtoHSV(pal->ccells[x].red,pal->ccells[x].green,
                                        pal->ccells[x].blue,&h,&s,&v)) {
                                h = 0;
                                }
                        h = ((double)360.0)
                                *((double) y) / ((double) pal->compWinHeight);
			pal->ccells[x].red = 0;
			pal->ccells[x].green = 0;
			pal->ccells[x].blue = 0;
                        ConvertHSVtoRGB(h,s,v,&(pal->ccells[x].red),
                                &(pal->ccells[x].green),&(pal->ccells[x].blue));

                        XSetForeground(myDpy,pal->compWinGC,pal->background);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->hpoints[x].y);
                        pal->hpoints[x].y = pal->compWinHeight - y;
                        XSetForeground(myDpy,pal->compWinGC,pal->compPenDrawColor);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->hpoints[x].y);

                        }
                        break;
                case CSATURATION:
                        {
                        double h,s,v;

			h = s = v = 0.0;
                        if (!ConvertRGBtoHSV(pal->ccells[x].red,pal->ccells[x].green,
                                        pal->ccells[x].blue,&h,&s,&v)) {
                                h = 0;
                                }

                        s = ((double)y) / ((double) pal->compWinHeight);

			pal->ccells[x].red = 0;
			pal->ccells[x].green = 0;
			pal->ccells[x].blue = 0;
                        ConvertHSVtoRGB(h,s,v,&(pal->ccells[x].red),
                                &(pal->ccells[x].green),&(pal->ccells[x].blue));

                        XSetForeground(myDpy,pal->compWinGC,pal->background);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->spoints[x].y);
                        pal->spoints[x].y = pal->compWinHeight - y;
                        XSetForeground(myDpy,pal->compWinGC,pal->compPenDrawColor);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->spoints[x].y);

                        }
                        break;
                case CVALUE: {
                        int max;
                        double ratio;
                        double yval;

                        yval = ((double) y) *
                                        (65535.0 / ((double)pal->compWinHeight));
                        max = MAX3(pal->ccells[x].red,pal->ccells[x].green,
                                pal->ccells[x].blue);
                        if (max != 0) {
                                ratio =((double) pal->ccells[x].red)/(double) max;
                                pal->ccells[x].red = (int) (ratio *  yval);
                                ratio =((double) pal->ccells[x].green)/(double)max;
                                pal->ccells[x].green = (int) (ratio *  yval);
                                ratio =((double) pal->ccells[x].blue)/(double) max;
                                pal->ccells[x].blue = (int) (ratio *  yval);
                                }
                        else {
                                pal->ccells[x].red = pal->ccells[x].blue =
                                        pal->ccells[x].green = yval;
                                }
                        XSetForeground(myDpy,pal->compWinGC,pal->background);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->vpoints[x].y);
                        pal->vpoints[x].y = pal->compWinHeight - y;
                        XSetForeground(myDpy,pal->compWinGC,pal->compPenDrawColor);
                        XDrawPoint(myDpy,win,pal->compWinGC,
                                        x,pal->vpoints[x].y);
                        }
                        break;

                default:
                        break;
                }

} /* PlotComp() */

static void CBChangeComponent(w,client_data,event)
Widget w;
caddr_t client_data;
XEvent *event;
{
unsigned int keys_buttons;
Window	root, child;
int     root_x,root_y;
int     win_x,win_y;
float   y;
float   yinc,ydiff;
Window	win;
Pixel	color;
Pal 	*pal;
register int	x;

	pal = (Pal *) client_data;

	if(! pal->compPen)
		return;

	if (event->type != MotionNotify) 
		return;
	if (!(event->xmotion.state & Button1Mask)) 
		return;

        color = ChooseColor(pal->ccells,pal->compPen);
        XSetForeground(myDpy,pal->compWinGC,color);
        win = XtWindow(pal->compWindow);

        if (!XQueryPointer(myDpy,win,&root,&child,
                &root_x,&root_y,&win_x,&win_y,&keys_buttons))
                return;

        win_x = (win_x > 255)? 255 : (win_x <0)? 0 : win_x;
        win_y = (win_y > pal->compWinHeight)? pal->compWinHeight:
                                        (win_y < 0)? 0 : win_y;
        win_y = pal->compWinHeight - win_y; /* 4th quadrant -> 1st quadrant */
        if (pal->compLastX == 0)
                PlotComp(pal,win_x,win_y,pal->compPen);
        else {
                ydiff = (pal->compLastX > win_x)?(pal->compLastY - win_y):
                                (win_y - pal->compLastY);

                if (pal->compLastX > win_x) {
                        yinc = (float) ydiff /((pal->compLastX == win_x)?1.0:
                                        ((float)(pal->compLastX - win_x)));
                        for (x = win_x,y=win_y; x < pal->compLastX; x++,y=y+yinc)
                                PlotComp(pal,x,(int) y,pal->compPen);
                        }
                else{
                        yinc = (float) ydiff / ((pal->compLastX == win_x)?1.0:
                                        ((float)( win_x - pal->compLastX)));
                        for (x = pal->compLastX, y=pal->compLastY; x < win_x; 
								x++,y=y+yinc)
                                PlotComp(pal,x,(int) y,pal->compPen);
                        }
                }
        pal->compLastX = win_x;
        pal->compLastY = win_y;

        StoreColors(pal,pal->ccells,FALSE,pal->cmap);
}

static void CBInitChangeComponent(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
XWindowAttributes winAttrib;
Pal *pal;

        pal = (Pal *) client_data;
        SaveForUndo(pal);
        XGetWindowAttributes(myDpy,XtWindow(pal->compWindow),&winAttrib);
        pal->compWinHeight = winAttrib.height;
        pal->compWinWidth= winAttrib.width;
}

static void CBEndChangeComponent(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;

        pal = (Pal *) client_data;
        pal->compLastX = 0;
        pal->compLastY = 0;
	RedrawComponents(pal);
	PaletteChangeComplete(pal);
}

static void RedrawComponents(pal)
Pal *pal;
{
	if (pal->rgbcmyhsv & CRED ){
		UnDrawComponent(pal,CRED);
		DrawComponent(pal,CRED);
		}
	if (pal->rgbcmyhsv & CGREEN) {
		UnDrawComponent(pal,CGREEN);
		DrawComponent(pal,CGREEN);
		}
	if (pal->rgbcmyhsv & CBLUE) {
		UnDrawComponent(pal,CBLUE);
		DrawComponent(pal,CBLUE);
		}
	if (pal->rgbcmyhsv & CCYAN) {
		UnDrawComponent(pal,CCYAN);
		DrawComponent(pal,CCYAN);
		}
	if (pal->rgbcmyhsv & CMAGENTA) {
		UnDrawComponent(pal,CMAGENTA);
		DrawComponent(pal,CMAGENTA);
		}
	if (pal->rgbcmyhsv & CYELLOW) {
		UnDrawComponent(pal,CYELLOW);
		DrawComponent(pal,CYELLOW);
		}
	if (pal->rgbcmyhsv & CHUE) {
		UnDrawComponent(pal,CHUE);
		DrawComponent(pal,CHUE);
		}
	if (pal->rgbcmyhsv & CSATURATION) {
		UnDrawComponent(pal,CSATURATION);
		DrawComponent(pal,CSATURATION);
		}
	if (pal->rgbcmyhsv & CVALUE) {
		UnDrawComponent(pal,CVALUE);
		DrawComponent(pal,CVALUE);
		}
	return;
} /* RedrawComponents() */

static void CBRedrawComponents(w,client_data,call_data)
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;

	pal = (Pal *) client_data;
	RedrawComponents(pal);
}












static void CBContPalCreate(w,client_data,call_data)
/* Continues after widgets realized, mapped, exposed */
Widget w;
caddr_t client_data;
caddr_t call_data;
{
Pal *pal;
register int x;
PaletteEntry *palette;
Arg	argList[10];
Cardinal i;
Widget scroll;

#ifdef DEBUG
	printf("CBContPalCreate() I've been called\n");
#endif

	pal = (Pal *) client_data;

	XtRemoveEventHandler(pal->mainWindow,ExposureMask,0,
			CBContPalCreate,(caddr_t)pal);

	myDpy= XtDisplay(pal->mainWindow);
	/* read palette */
	palette = (PaletteEntry *) ListTail(palList);
	PalMakeViewList(pal, palette);
	if (!palette) {
		pal->palName = (char *) 0;
		for(x=0;x < 256; x++) {
                	pal->ccells[x].pixel = x;
			pal->resetCCells[x].pixel = x;
			pal->undoCCells[x].pixel = x;
			pal->tmpCCells[x].pixel = x;
			}
		}
	else {
		pal->palName = palette->name;
		for(x=0;x < 256; x++) {
			pal->ccells[x].pixel = x;
			pal->resetCCells[x].pixel = x;
			pal->undoCCells[x].pixel = x;
			pal->tmpCCells[x].pixel = x;
			cpccell(pal->ccells[x],palette->ccells[x]);
			cpccell(pal->resetCCells[x],palette->ccells[x]);
			cpccell(pal->undoCCells[x],palette->ccells[x]);
			}
		}

	pal->cmap = XCreateColormap(myDpy,XtWindow(pal->top),
			myVis,AllocAll);
	StoreColors(pal,pal->ccells,TRUE,pal->cmap);
	XSetWindowColormap(myDpy,XtWindow(pal->top),pal->cmap);
	XSetWindowColormap(myDpy,XtWindow(pal->mainWindow),pal->cmap);
	XSetWindowColormap(myDpy,XtWindow(pal->menuBar),pal->cmap);
	XSetWindowColormap(myDpy,XtWindow(pal->compWindow),pal->cmap);
	XSetWindowColormap(myDpy,XtWindow(pal->colorBar),pal->cmap);
	SetPointer(pal->colorBar,XC_sb_h_double_arrow);
	SetPointer(pal->compWindow,XC_pencil);

/*
	scroll = XmCreateScrollBar(pal->mainWindow, "temp", NULL, 0);
	i = 0;
        XtSetArg(argList[i], XmNtroughColor, &(saveEntries[0])); i++;
        XtSetArg(argList[i], XmNbottomShadowColor, &(saveEntries[1])); i++;
        XtSetArg(argList[i], XmNtopShadowColor, &(saveEntries[2])); i++;
        XtSetArg(argList[i], XmNhighlightColor, &(saveEntries[3])); i++;
        XtSetArg(argList[i], XmNforeground, &(saveEntries[4])); i++;
        XtSetArg(argList[i], XmNbackground, &(saveEntries[5])); i++;
        XtSetArg(argList[i], XmNborderColor, &(saveEntries[6])); i++;
	XtGetValues(scroll, argList, i);
        XtDestroyWidget(scroll);

	numToSave = i;
        saveEntries[numToSave++] = BlackPixel(myDpy, DefaultScreen(myDpy));
        saveEntries[numToSave++] = WhitePixel(myDpy, DefaultScreen(myDpy));
*/
	pal->finishCreate = True;

	StoreColors(pal,pal->ccells,FALSE,pal->cmap);

}


Pal *PalCreate(rootWidget)
Widget rootWidget;
{
Arg     argList[10];
Cardinal i=0;
XmString label;
Pal *pal;
Widget	b;
XGCValues gcvalues;
register int x;


	if (!(pal = (Pal *) MALLOC(sizeof(Pal)))) {
		ErrMesg("Out of Memory Trying to make palette window\n");
		return(0);
		}
	
	pal->finishCreate = False;
	pal->top = rootWidget;

	i=0;
        XtSetArg(argList[i],XmNwidth,300); i++;
        XtSetArg(argList[i],XmNheight,300); i++;
        pal->mainWindow = XmCreateForm(rootWidget,"Palette",argList,i);
	XtManageChild(pal->mainWindow);

        i=0;
        XtSetArg(argList[i],XmNwidth,280); i++;
        XtSetArg(argList[i],XmNtopAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNrightAttachment,XmATTACH_FORM); i++;
        XtSetArg(argList[i],XmNleftAttachment,XmATTACH_FORM); i++;
        pal->menuBar= XmCreateMenuBar(pal->mainWindow,0,argList,i);
	XtManageChild(pal->menuBar);

        i=0;
        XtSetArg(argList[i],XmNorientation,XmVERTICAL); i++;
        pal->pulldown[0] = XmCreatePulldownMenu(pal->menuBar,"pulldown",
							argList,i);

        i=0;
        label = XmStringCreateSimple("File");
        XtSetArg(argList[i],XmNsubMenuId,pal->pulldown[0]); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNmnemonic,'F'); i++;
        b = XmCreateCascadeButton(pal->menuBar,0,argList,i);
	XtManageChild(b);
	XmStringFree(label);

        i=0;
        label = XmStringCreateSimple("Open");
        XtSetArg(argList[i],XmNmnemonic,'O'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        pal->button[0]= XmCreatePushButtonGadget(pal->pulldown[0],
				"menuButton",argList,i);
        XtAddCallback(pal->button[0],XmNactivateCallback,CBLoadPalette,(caddr_t)pal);
	XmStringFree(label);

        i=0;
        label = XmStringCreateSimple("Save As...");
        XtSetArg(argList[i],XmNmnemonic,'S'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        pal->button[1]= XmCreatePushButtonGadget(pal->pulldown[0],"menuButton",
				argList,i);
        XtAddCallback(pal->button[1],XmNactivateCallback,CBSavePalette,(caddr_t)pal);
	XmStringFree(label);

	i=0;
	b = XmCreateSeparator(pal->pulldown[0],0, argList,i);
	XtManageChild(b);


        i=0;
        label = XmStringCreateSimple("Close");
        XtSetArg(argList[i],XmNmnemonic,'C'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        pal->button[2]= XmCreatePushButtonGadget(pal->pulldown[0],"menuButton",
				argList,i);
        XtAddCallback(pal->button[2],XmNactivateCallback,CBPaletteDone,(caddr_t)pal);
	XtManageChildren(pal->button,3);
	XmStringFree(label);


	/* Edit Pulldown */
        i=0;
        XtSetArg(argList[i],XmNorientation,XmVERTICAL); i++;
        pal->pulldown[1] = XmCreatePulldownMenu(pal->menuBar,"pulldown",
							argList,i);
        i=0;
        label = XmStringCreateSimple("Edit");
        XtSetArg(argList[i],XmNsubMenuId,pal->pulldown[1]); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNmnemonic,'E'); i++;
        pal->editButton = XmCreateCascadeButton(pal->menuBar,0,argList,i);
	XtManageChild(pal->editButton);
	XmStringFree(label);

        i=0;
        label = XmStringCreateSimple("Undo");
        XtSetArg(argList[i],XmNmnemonic,'U'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        pal->button[3]= XmCreatePushButtonGadget(pal->pulldown[1],
				"menuButton",argList,i);
        XtAddCallback(pal->button[3],XmNactivateCallback,CBPalUndo,(caddr_t)pal);
	XtManageChild(pal->button[3]);
	XmStringFree(label);

        i=0;
        label = XmStringCreateSimple("Reset");
        XtSetArg(argList[i],XmNmnemonic,'R'); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        pal->button[4]= XmCreatePushButtonGadget(pal->pulldown[1],
				"menuButton",argList,i);
        XtAddCallback(pal->button[4],XmNactivateCallback,CBPalReset,(caddr_t)pal);
	XtManageChild(pal->button[4]);
	XmStringFree(label);

	/* View Pulldown */
        i=0;
        XtSetArg(argList[i],XmNorientation,XmVERTICAL); i++;
	XtSetArg(argList[i], XmNradioBehavior, True); i++;
        pal->pulldown[2] = XmCreatePulldownMenu(pal->menuBar,"pulldown",
							argList,i);
        i=0;
        label = XmStringCreateSimple("View");
        XtSetArg(argList[i],XmNsubMenuId,pal->pulldown[2]); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNmnemonic,'V'); i++;
        b = XmCreateCascadeButton(pal->menuBar,0,argList,i);
	XtManageChild(b);
	XmStringFree(label);

	/*Option Pulldown */
        i=0;
        XtSetArg(argList[i],XmNorientation,XmVERTICAL); i++;
        pal->pulldown[3] = XmCreatePulldownMenu(pal->menuBar,"pulldown",
							argList,i);
        i=0;
        label = XmStringCreateSimple("Options");
        XtSetArg(argList[i],XmNsubMenuId,pal->pulldown[3]); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
        XtSetArg(argList[i],XmNmnemonic,'V'); i++;
        b = XmCreateCascadeButton(pal->menuBar,0,argList,i);
	XtManageChild(b);
	XmStringFree(label);

	pal->useAllEntries = FALSE;

        i=0;
        label = XmStringCreateSimple("Use Entire Palette");
        XtSetArg(argList[i],XmNset,pal->useAllEntries); i++;
        XtSetArg(argList[i],XmNlabelString,label); i++;
	b = XmCreateToggleButton(pal->pulldown[3],0,argList,i);
        XtAddCallback(b,XmNvalueChangedCallback,CBUseEntirePalette,(caddr_t)pal);
	XtManageChild(b);
	XmStringFree(label);

        i=0;
        label = XmStringCreateSimple("Display New Palettes");
        XtSetArg(argList[i],XmNlabelString,label); i++;
	b = XmCreateToggleButton(pal->pulldown[3],"displayNewPal",argList,i);
        XtAddCallback(b,XmNvalueChangedCallback,CBDisplayNewPalettes,(caddr_t)pal);
	XtManageChild(b);
	pal->displayNewPalettes = XmToggleButtonGetState(b);
	XmStringFree(label);


	/* ColorBar */
	i=0;
        XtSetArg(argList[i],XmNx,20); i++;
        XtSetArg(argList[i],XmNy,40); i++;
        XtSetArg(argList[i],XmNtopPosition,40); i++;
        XtSetArg(argList[i],XmNwidth,256); i++;
        XtSetArg(argList[i],XmNheight,40); i++;
	pal->colorBar = XmCreateDrawingArea(pal->mainWindow,0,
			argList,i);
        XtAddCallback(pal->colorBar,XmNexposeCallback,
			CBPalColorBarExpose,(caddr_t)pal);
	pal->colorBarWidth = INIT_COLORBAR_WIDTH;
	pal->colorBarHeight = INIT_COLORBAR_HEIGHT;
	if (!(pal->colorBarImage = (unsigned char *) 
			MALLOC(INIT_COLORBAR_WIDTH*INIT_COLORBAR_HEIGHT))) {
		ErrMesg("Out of Memory creating color bar\n");
		return(0);
		}
	FillHorizColorBar(pal->colorBarImage,INIT_COLORBAR_WIDTH,
					     INIT_COLORBAR_HEIGHT);
	pal->colorBarXImage =  XCreateImage(myDpy,myVis,8,ZPixmap,0,
				(char *)pal->colorBarImage,
				INIT_COLORBAR_WIDTH,INIT_COLORBAR_HEIGHT,
				8,INIT_COLORBAR_WIDTH);
	XtManageChild(pal->colorBar);
        pal->colorBarGC = XtGetGC(pal->colorBar,0,&gcvalues);
	XtAddEventHandler(pal->colorBar,ButtonPressMask,0,CBInitRotate,(caddr_t)pal);
	XtAddEventHandler(pal->colorBar,Button1MotionMask,0,CBRotate,(caddr_t)pal);
	XtAddEventHandler(pal->colorBar,ButtonReleaseMask,0,CBEndRotate,(caddr_t)pal);
	SetPointer(pal->colorBar,XC_sb_h_double_arrow);


	i=0;
        XtSetArg(argList[i],XmNx,20); i++;
        XtSetArg(argList[i],XmNy,80); i++;
        XtSetArg(argList[i],XmNtopPosition,80); i++;
        XtSetArg(argList[i],XmNwidth,266); i++;
        XtSetArg(argList[i],XmNheight,110); i++;
	b = XmCreateFrame(pal->mainWindow,0,argList,i);
	XtManageChild(b);

	i=0;
        XtSetArg(argList[i],XmNx,0); i++;
        XtSetArg(argList[i],XmNy,0); i++;
        XtSetArg(argList[i],XmNwidth,256); i++;
        XtSetArg(argList[i],XmNheight,100); i++;
	pal->compWindow = XmCreateDrawingArea(b,0, argList,i);
        XtAddCallback(pal->compWindow,XmNexposeCallback,
			CBPalCompWindowExpose,(caddr_t)pal);
	XtManageChild(pal->compWindow);
	SetPointer(pal->compWindow,XC_pencil);
        pal->compWinGC= XtGetGC(pal->compWindow,0,&gcvalues);
        XtAddCallback(pal->compWindow,XmNexposeCallback,
			CBRedrawComponents,(caddr_t)pal);
	XtAddEventHandler(pal->compWindow,ButtonPressMask,0,
				CBInitChangeComponent,(caddr_t)pal);
	XtAddEventHandler(pal->compWindow,Button1MotionMask,0,
				CBChangeComponent,(caddr_t)pal);
	XtAddEventHandler(pal->compWindow,ButtonReleaseMask,0,
				CBEndChangeComponent,(caddr_t)pal);


	/* component toggle boxes */
	i=0;
        XtSetArg(argList[i],XmNx,180); i++;
        XtSetArg(argList[i],XmNy,212); i++;
        XtSetArg(argList[i],XmNrightPosition,200); i++;
        XtSetArg(argList[i],XmNwidth,50); i++;
        XtSetArg(argList[i],XmNheight,100); i++;
        XtSetArg(argList[i],XmNpacking,XmPACK_COLUMN); i++;
	pal->toggleBox = XmCreateRowColumn(pal->mainWindow,0,argList,i);
	XtManageChild(pal->toggleBox);
	i=0;
        XtSetArg(argList[i],XmNx,205); i++;
        XtSetArg(argList[i],XmNy,210); i++;
        XtSetArg(argList[i],XmNrightPosition,100); i++;
        XtSetArg(argList[i],XmNwidth,10); i++;
        XtSetArg(argList[i],XmNheight,100); i++;
	pal->toggleBoxRadio = XmCreateRadioBox(pal->mainWindow,0,argList,i);
		XtManageChild(pal->toggleBoxRadio);

		/* Color Mode menu */
		i=0;
		XtSetArg(argList[i],XmNorientation,XmVERTICAL); i++;
		pal->pulldown[5] = XmCreatePulldownMenu(pal->menuBar,"pulldown",
								argList,i);
		i=0;
		XtSetArg(argList[i],XmNlabelString,hsv[0]); i++;
		b = XmCreatePushButtonGadget(pal->pulldown[5],"menuButton",argList,i);
		XtAddCallback(b,XmNactivateCallback,CBChangeColorModelHSV,(caddr_t)pal);
		XtManageChild(b);
		i=0;
		XtSetArg(argList[i],XmNlabelString,rgb[0]); i++;
		b = XmCreatePushButtonGadget(pal->pulldown[5],
					"menuButton",argList,i);
		XtAddCallback(b,XmNactivateCallback,CBChangeColorModelRGB,(caddr_t)pal);
		XtManageChild(b);
		i=0;
		XtSetArg(argList[i],XmNlabelString,cmy[0]); i++;
		b = XmCreatePushButtonGadget(pal->pulldown[5],
					"menuButton",argList,i);
		XtAddCallback(b,XmNactivateCallback,CBChangeColorModelCMY,(caddr_t)pal);
		XtManageChild(b);

		i=0;
		XtSetArg(argList[i],XmNx,175); i++;
		XtSetArg(argList[i],XmNy,183); i++;
		XtSetArg(argList[i],XmNsubMenuId,pal->pulldown[5]); i++;
		b = XmCreateOptionMenu(pal->mainWindow,0,argList,i);
		XtManageChild(b);

		pal->model = HSV;
		
		/* component toggles */
		i=0;
		XtSetArg(argList[i],XmNx,10); i++;
		XtSetArg(argList[i],XmNy,10); i++;
		XtSetArg(argList[i],XmNindicatorType,XmN_OF_MANY); i++;
		XtSetArg(argList[i],XmNshadowThickness,0); i++;
		pal->toggleShow[0] = XmCreateToggleButton(pal->toggleBox,0,argList,i);
		XtAddCallback(pal->toggleShow[0],XmNvalueChangedCallback,
							CBDrawComponent,(caddr_t)pal);
		i=0;
		XtSetArg(argList[i],XmNx,10); i++;
		XtSetArg(argList[i],XmNy,40); i++;
		XtSetArg(argList[i],XmNindicatorType,XmN_OF_MANY); i++;
		XtSetArg(argList[i],XmNshadowThickness,0); i++;
		pal->toggleShow[1] = XmCreateToggleButton(pal->toggleBox,0,argList,i);
		XtAddCallback(pal->toggleShow[1],XmNvalueChangedCallback,
							CBDrawComponent,(caddr_t)pal);
		i=0;
		XtSetArg(argList[i],XmNx,10); i++;
		XtSetArg(argList[i],XmNy,70); i++;
		XtSetArg(argList[i],XmNindicatorType,XmN_OF_MANY); i++;
		XtSetArg(argList[i],XmNshadowThickness,0); i++;
		pal->toggleShow[2] = XmCreateToggleButton(pal->toggleBox,0,argList,i);
		XtAddCallback(pal->toggleShow[2],XmNvalueChangedCallback,
							CBDrawComponent,(caddr_t)pal);
		i=0;
		XtSetArg(argList[i],XmNx,30); i++;
		XtSetArg(argList[i],XmNy,10); i++;
		XtSetArg(argList[i],XmNindicatorType,XmONE_OF_MANY); i++;
		XtSetArg(argList[i],XmNlabelString,hsv[1]); i++;
		XtSetArg(argList[i],XmNshadowThickness,0); i++;
		pal->toggleDraw[0] = XmCreateToggleButton(pal->toggleBoxRadio,0,
							argList,i);
        XtAddCallback(pal->toggleDraw[0],XmNvalueChangedCallback,
						CBSetPen,(caddr_t)pal);
	i=0;
        XtSetArg(argList[i],XmNx,30); i++;
        XtSetArg(argList[i],XmNy,40); i++;
        XtSetArg(argList[i],XmNindicatorType,XmONE_OF_MANY); i++;
        XtSetArg(argList[i],XmNlabelString,hsv[2]); i++;
	XtSetArg(argList[i],XmNshadowThickness,0); i++;
	pal->toggleDraw[1] = XmCreateToggleButton(pal->toggleBoxRadio,0,
							argList,i);
        XtAddCallback(pal->toggleDraw[1],XmNvalueChangedCallback,
						CBSetPen,(caddr_t)pal);
	i=0;
        XtSetArg(argList[i],XmNx,30); i++;
        XtSetArg(argList[i],XmNy,70); i++;
        XtSetArg(argList[i],XmNindicatorType,XmONE_OF_MANY); i++;
        XtSetArg(argList[i],XmNlabelString,hsv[3]); i++;
	XtSetArg(argList[i],XmNshadowThickness,0); i++;
	pal->toggleDraw[2] = XmCreateToggleButton(pal->toggleBoxRadio,0,
					argList,i);
	XtManageChildren(pal->toggleShow,3);
	XtManageChildren(pal->toggleDraw,3);
        XtAddCallback(pal->toggleDraw[2],XmNvalueChangedCallback,
						CBSetPen,(caddr_t)pal);

	pal->rgbcmyhsv = 0;

/***************** this will break on some displays */
	/* Buttons */
	pal->fiddlePixmap = XCreatePixmapFromBitmapData(myDpy,
			RootWindow(myDpy,DefaultScreen(myDpy)),
			fiddle_bits,fiddle_width,fiddle_height,
			PalGetForeground(pal->mainWindow),
			PalGetBackground(pal->mainWindow),8);
	i=0;
        XtSetArg(argList[i],XmNx,20); i++;
        XtSetArg(argList[i],XmNy,190); i++;
        XtSetArg(argList[i],XmNwidth,fiddle_width); i++;
        XtSetArg(argList[i],XmNheight,fiddle_height); i++;
        XtSetArg(argList[i],XmNlabelType,XmPIXMAP); i++;
        XtSetArg(argList[i],XmNlabelPixmap,pal->fiddlePixmap); i++;
	
	pal->fiddleButton = XmCreatePushButton(pal->mainWindow,0,argList,i);
        XtAddCallback(pal->fiddleButton,XmNactivateCallback,
				CBFiddle,(caddr_t)pal);
	XtManageChild(pal->fiddleButton);
	
	XtAddEventHandler(pal->mainWindow,ExposureMask,0,
			CBContPalCreate,(caddr_t)pal);

	pal->palName = (char *)NULL; /* important, since we don't know
					when CBContPalCreate will be called
					and PalNewPalette test it */
	pal->fiddleStart = FALSE;
	pal->rotateStart = FALSE;
	pal->cmap = 0;
	pal->compLastX = 0;
	pal->compLastY = 0;
	pal->compPen = 0;
	pal->foreground = PalGetForeground(pal->compWindow);
	pal->background = PalGetBackground(pal->compWindow);

	ListAddEntry(palEditList,pal);
	return(pal);
} /* PalCreate() */


static PaletteEntry *SearchForPaletteByName(name)
char *name;
{
PaletteEntry *p;
	p  = (PaletteEntry *) ListHead(palList);
	while (p) {
		if (!strcmp(p->name,name)) 
			return(p);
		p  = (PaletteEntry *) ListNext(palList);
		}
	return(0);
}


int PalNewPalette(name,ccells)
/* New palette to add to list */
XColor *ccells;
char *name;
{
PaletteEntry *palette;
Pal *pal;
XmString label;
Arg	argList[2];
Widget b;
PalGroup	*pg;
register int x;

	if (palette = SearchForPaletteByName(name)) {
		/* find all editors that are viewing and update */
		pal  = (Pal *) ListHead(palEditList);
		while (pal) {
			if (pal->palName && (!strcmp(name,pal->palName))) {
				SaveForUndo(pal);
				for (x=0; x<256; x++) {
					cpccell(pal->ccells[x],ccells[x]);
					}
				StoreColors(pal,pal->ccells,TRUE,pal->cmap);
				}
			pal  = (Pal *) ListNext(palEditList);
			}
		if (palette->ccells && palette->ccells != ccells)
			FREE(palette->ccells);
		palette->ccells = ccells;
		return(0);
		}

	if (!(palette = (PaletteEntry *) MALLOC(sizeof(PaletteEntry)))) {
		ErrMesg("Out of Memory while getting New Palette\n");
		return(0);
		}
	if (!(palette->name = (char *) MALLOC(strlen(name) + 1))) {
		ErrMesg("Out of Memory while getting New Palette\n");
		return(0);
		}
	strcpy(palette->name,name);
	palette->ccells = ccells;
        palette->motifName = XmStringCreateSimple(name);
	ListAddEntry(palList,palette);

	XtSetArg(argList[0],XmNlabelString,palette->motifName); 
	pal  = (Pal *) ListHead(palEditList);
	while (pal) {
	    if (pal->finishCreate) {
		if (!(pg = (PalGroup *) MALLOC(sizeof(PalGroup)))) {
			ErrMesg("Out of Memory while getting New Palette\n");
			return(0);
			}
		pg->palette = palette;
		pg->pal = pal;

#ifdef DEBUG
		printf("PALNewPalette()pg->pal->cmap  = %d\n",pg->pal->cmap);
#endif

		b = XmCreateToggleButtonGadget(pal->pulldown[2],
				"menuButton",argList,1);
		XtAddCallback(b,XmNvalueChangedCallback,CBSetPal,(caddr_t)pg);
		XtManageChild(b);
		if (pal->displayNewPalettes)
		  XmToggleButtonGadgetSetState(b, True, True);
		}
	    pal  = (Pal *) ListNext(palEditList);
	    }
	
	return(1);
} /* PalNewPalette() */



int PalInit(rootWidget)
Widget rootWidget;
{
register int x;
unsigned char pdata[768];
Arg	argList[20];
int	i;
Widget	scroll;
XColor *newCCells;

	myDpy = XtDisplay(rootWidget);
	myVis = GetVisual(myDpy);

	if (myVis->class != PseudoColor) {
	   ErrMesg("Sorry, Palette is written for PseudoColor display only");
	   return(0);
	   }

        if (DisplayPlanes(myDpy,XDefaultScreen(myDpy)) != 8 ) {
		ErrMesg("Sorry, This requires an 8 bit display only \n");
                return(0);
                }
	palList = ListCreate();
	palEditList = ListCreate();

        for(x=0;x < 256; x++)
                serverCCells[x].pixel = x;
	XQueryColors(myDpy,DefaultColormap(myDpy,DefaultScreen(myDpy)), 
				serverCCells,256);

	/* get motif colors */
	scroll = XmCreateScrollBar(rootWidget, "temp", NULL, 0);
	i = 0;
        XtSetArg(argList[i], XmNtroughColor, &(saveEntries[0])); i++;
        XtSetArg(argList[i], XmNbottomShadowColor, &(saveEntries[1])); i++;
        XtSetArg(argList[i], XmNtopShadowColor, &(saveEntries[2])); i++;
        XtSetArg(argList[i], XmNhighlightColor, &(saveEntries[3])); i++;
        XtSetArg(argList[i], XmNforeground, &(saveEntries[4])); i++;
        XtSetArg(argList[i], XmNbackground, &(saveEntries[5])); i++;
        XtSetArg(argList[i], XmNborderColor, &(saveEntries[6])); i++;
	XtGetValues(scroll, argList, i);
        XtDestroyWidget(scroll);
	numToSave = i;
        saveEntries[numToSave++] = BlackPixel(myDpy, DefaultScreen(myDpy));
        saveEntries[numToSave++] = WhitePixel(myDpy, DefaultScreen(myDpy));

	/* create default palette */
	ConvertSEQToXColors(huePal,defaultCCells);

        ConvertSEQtoRGB(huePal,pdata);

	NetPALDistribute("default", pdata, (char *)NULL, PAL_MODULE_NAME);

	if (!(newCCells = (XColor *) MALLOC(sizeof(XColor) * 256))) {
		ErrMesg("Out of Memory initializing palette tool\n");
		return 0;
		}
	memcpy(newCCells, defaultCCells, sizeof(XColor) * 256);
	PalNewPalette("default",newCCells);

	/* create motif strings */
	rgb[0] = XmStringCreateSimple("RGB");
	rgb[1] = XmStringCreateSimple("Red");
	rgb[2] = XmStringCreateSimple("Green");
	rgb[3] = XmStringCreateSimple("Blue");
	cmy[0] = XmStringCreateSimple("CMY");
	cmy[1] = XmStringCreateSimple("Cyan");
	cmy[2] = XmStringCreateSimple("Magenta");
	cmy[3] = XmStringCreateSimple("Yellow");
	hsv[0] = XmStringCreateSimple("HSV");
	hsv[1] = XmStringCreateSimple("Hue");
	hsv[2] = XmStringCreateSimple("Saturation");
	hsv[3] = XmStringCreateSimple("Value");

	fileBox =  XmCreateFileSelectionDialog(rootWidget,"fileSelectionBox",
                        argList,0);
	fileBoxOpen = FALSE;


	return(1);

} /* PalInit() */

PalSetLock(lock)
Boolean lock;
{
Pal *pal;

	palLock = lock;

	pal = (Pal *) ListHead(palEditList);
	while(pal) {
		/* turn off fiddle */
		XtSetSensitive(pal->fiddleButton,(Boolean)!lock);
	
		/* turn off Edit Menu */
		XtSetSensitive(pal->editButton,(Boolean)!lock);

		/* turn off component draw */
		if (lock && pal->compPen) {
			XmToggleButtonSetState(pal->toggleDraw[0],False,False);
			XmToggleButtonSetState(pal->toggleDraw[1],False,False);
			XmToggleButtonSetState(pal->toggleDraw[2],False,False);
			pal->compPen = 0;
			}
		XtSetSensitive(pal->toggleDraw[0],(Boolean)!lock);
		XtSetSensitive(pal->toggleDraw[1],(Boolean)!lock);
		XtSetSensitive(pal->toggleDraw[2],(Boolean)!lock);

		pal = (Pal *) ListNext(palEditList);
		}
}
