package WebService::Bonusly::Users;
$WebService::Bonusly::Users::VERSION = '0.151580';
use v5.14;
use Moose;
use Carp;
use JSON;
use URI::Escape;

has ws => (
    is          => 'ro',
    isa         => 'WebService::Bonusly',
    required    => 1,
    weak_ref    => 1,
    handles     => [ qw( token base_url ua ) ],
);


sub add {
    my ($self, %params) = @_;

    my %clean;
            
    croak "parameter email is required for users->add"
        unless defined $params{email};
    
    $clean{email} = $params{email}
        if defined $params{email};
            
    croak "parameter first_name is required for users->add"
        unless defined $params{first_name};
    
    $clean{first_name} = $params{first_name}
        if defined $params{first_name};
            
    croak "parameter last_name is required for users->add"
        unless defined $params{last_name};
    
    $clean{last_name} = $params{last_name}
        if defined $params{last_name};
        
    croak "parameter custom_properties must be a HASH for users->add"
        if defined $params{custom_properties} and ref($params{custom_properties}) ne 'HASH';
        
    $clean{custom_properties} = $params{custom_properties}
        if defined $params{custom_properties};
            
    $clean{user_mode} = $params{user_mode}
        if defined $params{user_mode};
            
    $clean{budget_boost} = $params{budget_boost}
        if defined $params{budget_boost};
            
    $clean{external_unique_id} = $params{external_unique_id}
        if defined $params{external_unique_id};
    
    my $path = $self->base_url . "users";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?access_token=' . $self->token;    my $content = encode_json(\%clean);
    my $res = $self->ua->post($path, [ 'Content-Type' => 'application/json' ], $content); 
    
    return decode_json($res->content);
}

sub delete {
    my ($self, %params) = @_;

    my %clean;
            
    croak "parameter id is required for users->delete"
        unless defined $params{id};
    
    $clean{id} = $params{id}
        if defined $params{id};
    
    my $path = $self->base_url . "users/:id";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?';
    $path .= 'access_token=' . $self->token;    while (my ($k, $v) = each %clean) {
        $path .= uri_escape($k) . '=' . uri_escape($v);
    }

    my $res = $self->ua->get($path);
    
    return decode_json($res->content);
}

sub get {
    my ($self, %params) = @_;

    my %clean;
            
    croak "parameter id is required for users->get"
        unless defined $params{id};
    
    $clean{id} = $params{id}
        if defined $params{id};
    
    my $path = $self->base_url . "users/:id";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?';
    $path .= 'access_token=' . $self->token;    while (my ($k, $v) = each %clean) {
        $path .= uri_escape($k) . '=' . uri_escape($v);
    }

    my $res = $self->ua->get($path);
    
    return decode_json($res->content);
}

sub list {
    my ($self, %params) = @_;

    my %clean;
    
    my $path = $self->base_url . "users";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?';
    $path .= 'access_token=' . $self->token;    while (my ($k, $v) = each %clean) {
        $path .= uri_escape($k) . '=' . uri_escape($v);
    }

    my $res = $self->ua->get($path);
    
    return decode_json($res->content);
}

sub redemptions {
    my ($self, %params) = @_;

    my %clean;
    
    my $path = $self->base_url . "users/:id/redemptions";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?';
    $path .= 'access_token=' . $self->token;    while (my ($k, $v) = each %clean) {
        $path .= uri_escape($k) . '=' . uri_escape($v);
    }

    my $res = $self->ua->get($path);
    
    return decode_json($res->content);
}

sub update {
    my ($self, %params) = @_;

    my %clean;
            
    croak "parameter id is required for users->update"
        unless defined $params{id};
    
    $clean{id} = $params{id}
        if defined $params{id};
            
    $clean{email} = $params{email}
        if defined $params{email};
            
    $clean{first_name} = $params{first_name}
        if defined $params{first_name};
            
    $clean{last_name} = $params{last_name}
        if defined $params{last_name};
        
    croak "parameter custom_properties must be a HASH for users->update"
        if defined $params{custom_properties} and ref($params{custom_properties}) ne 'HASH';
        
    $clean{custom_properties} = $params{custom_properties}
        if defined $params{custom_properties};
            
    $clean{user_mode} = $params{user_mode}
        if defined $params{user_mode};
            
    $clean{budget_boost} = $params{budget_boost}
        if defined $params{budget_boost};
            
    $clean{external_unique_id} = $params{external_unique_id}
        if defined $params{external_unique_id};
    
    my $path = $self->base_url . "users/:id";
    $path =~ s/:(\w+)/delete $params{$1}/ge;
    
    $path .= '?access_token=' . $self->token;    my $content = encode_json(\%clean);
    my $res = $self->ua->put($path, [ 'Content-Type' => 'application/json' ], $content); 
    
    return decode_json($res->content);
}


__PACKAGE__->meta->make_immutable;

__END__

=pod

=encoding UTF-8

=head1 NAME

WebService::Bonusly::Users

=head1 VERSION

version 0.151580

=for Pod::Coverage *EVERYTHING*

=head1 AUTHOR

Andrew Sterling Hanenkamp <hanenkamp@cpan.org>

=head1 COPYRIGHT AND LICENSE

This software is copyright (c) 2015 by Qubling Software LLC.

This is free software; you can redistribute it and/or modify it under
the same terms as the Perl 5 programming language system itself.

=cut
