/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.rmi;

import com.sun.media.jai.rmi.JaiI18N;
import java.awt.Image;
import java.awt.RenderingHints;
import java.awt.image.RenderedImage;
import java.awt.image.renderable.RenderContext;
import java.awt.image.renderable.RenderableImage;
import java.io.IOException;
import java.io.InputStream;
import java.io.InterruptedIOException;
import java.io.NotSerializableException;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.Serializable;
import java.net.InetAddress;
import java.net.ServerSocket;
import java.net.Socket;
import java.net.SocketException;
import java.net.UnknownHostException;
import java.util.Enumeration;
import java.util.Hashtable;
import java.util.Vector;
import javax.media.jai.OperationRegistry;
import javax.media.jai.remote.SerializableRenderedImage;
import javax.media.jai.remote.SerializableState;
import javax.media.jai.remote.SerializerFactory;
import javax.media.jai.tilecodec.TileCodecParameterList;
import javax.media.jai.tilecodec.TileDecoderFactory;
import javax.media.jai.tilecodec.TileEncoderFactory;
import javax.media.jai.util.CaselessStringKey;

public final class SerializableRenderableImage
implements RenderableImage,
Serializable {
    private static final int SERVER_TIMEOUT = 60000;
    private static final String CLOSE_MESSAGE = "CLOSE";
    private transient boolean isServer;
    private transient RenderableImage source;
    private float minX;
    private float minY;
    private float width;
    private float height;
    private transient Vector sources = null;
    private transient Hashtable properties = null;
    private boolean isDynamic;
    private InetAddress host;
    private int port;
    private transient boolean serverOpen = false;
    private transient ServerSocket serverSocket = null;
    private transient Thread serverThread;
    private static transient Hashtable remoteReferenceCount;
    private boolean useTileCodec = false;
    private OperationRegistry registry = null;
    private String formatName = null;
    private TileCodecParameterList encodingParam = null;
    private TileCodecParameterList decodingParam = null;

    private static synchronized void incrementRemoteReferenceCount(Object object) {
        if (remoteReferenceCount == null) {
            remoteReferenceCount = new Hashtable();
            remoteReferenceCount.put(object, new Integer(1));
        } else {
            Integer n = (Integer)remoteReferenceCount.get(object);
            if (n == null) {
                remoteReferenceCount.put(object, new Integer(1));
            } else {
                remoteReferenceCount.put(object, new Integer(n + 1));
            }
        }
    }

    private static synchronized void decrementRemoteReferenceCount(Object object) {
        Integer n;
        if (remoteReferenceCount != null && (n = (Integer)remoteReferenceCount.get(object)) != null) {
            if (n == 1) {
                remoteReferenceCount.remove(object);
            } else {
                remoteReferenceCount.put(object, new Integer(n - 1));
            }
        }
    }

    SerializableRenderableImage() {
    }

    public SerializableRenderableImage(RenderableImage renderableImage, OperationRegistry operationRegistry, String string, TileCodecParameterList tileCodecParameterList, TileCodecParameterList tileCodecParameterList2) {
        this(renderableImage);
        this.registry = operationRegistry;
        this.formatName = string;
        this.encodingParam = tileCodecParameterList;
        this.decodingParam = tileCodecParameterList2;
        if (string == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableRenderableImage2"));
        }
        if (!string.equals(tileCodecParameterList.getFormatName())) {
            throw new IllegalArgumentException(JaiI18N.getString("UseTileCodec0"));
        }
        if (!string.equals(tileCodecParameterList2.getFormatName())) {
            throw new IllegalArgumentException(JaiI18N.getString("UseTileCodec1"));
        }
        TileEncoderFactory tileEncoderFactory = (TileEncoderFactory)operationRegistry.getFactory("tileEncoder", string);
        TileDecoderFactory tileDecoderFactory = (TileDecoderFactory)operationRegistry.getFactory("tileDecoder", string);
        if (tileEncoderFactory == null || tileDecoderFactory == null) {
            throw new RuntimeException(JaiI18N.getString("UseTileCodec2"));
        }
        this.useTileCodec = true;
    }

    public SerializableRenderableImage(RenderableImage renderableImage) {
        if (renderableImage == null) {
            throw new IllegalArgumentException(JaiI18N.getString("SerializableRenderableImage1"));
        }
        this.isServer = true;
        this.source = renderableImage;
        this.minX = renderableImage.getMinX();
        this.minY = renderableImage.getMinY();
        this.width = renderableImage.getWidth();
        this.height = renderableImage.getHeight();
        this.isDynamic = renderableImage.isDynamic();
        this.sources = new Vector();
        this.sources.add(renderableImage);
        this.properties = new Hashtable();
        String[] stringArray = renderableImage.getPropertyNames();
        if (stringArray != null) {
            int n = 0;
            while (n < stringArray.length) {
                String string = stringArray[n];
                this.properties.put(new CaselessStringKey(string), renderableImage.getProperty(string));
                ++n;
            }
        }
        try {
            this.host = InetAddress.getLocalHost();
        }
        catch (UnknownHostException unknownHostException) {
            throw new RuntimeException(unknownHostException.getMessage());
        }
        this.serverOpen = false;
    }

    public RenderedImage createDefaultRendering() {
        if (this.isServer) {
            return this.source.createDefaultRendering();
        }
        Socket socket = this.connectToServer();
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            inputStream = socket.getInputStream();
            objectInputStream = new ObjectInputStream(inputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        try {
            objectOutputStream.writeObject("createDefaultRendering");
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        Object object = null;
        try {
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        RenderedImage renderedImage = object instanceof SerializableRenderedImage ? (RenderedImage)object : null;
        try {
            outputStream.close();
            objectOutputStream.close();
            inputStream.close();
            objectInputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return renderedImage;
    }

    public RenderedImage createRendering(RenderContext renderContext) {
        if (this.isServer) {
            return this.source.createRendering(renderContext);
        }
        Socket socket = this.connectToServer();
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            inputStream = socket.getInputStream();
            objectInputStream = new ObjectInputStream(inputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        try {
            objectOutputStream.writeObject("createRendering");
            objectOutputStream.writeObject(SerializerFactory.getState(renderContext, null));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        Object object = null;
        try {
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        RenderedImage renderedImage = (RenderedImage)object;
        try {
            outputStream.close();
            objectOutputStream.close();
            inputStream.close();
            objectInputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return renderedImage;
    }

    public RenderedImage createScaledRendering(int n, int n2, RenderingHints renderingHints) {
        if (this.isServer) {
            return this.source.createScaledRendering(n, n2, renderingHints);
        }
        Socket socket = this.connectToServer();
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        InputStream inputStream = null;
        ObjectInputStream objectInputStream = null;
        try {
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
            inputStream = socket.getInputStream();
            objectInputStream = new ObjectInputStream(inputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        try {
            objectOutputStream.writeObject("createScaledRendering");
            objectOutputStream.writeObject(new Integer(n));
            objectOutputStream.writeObject(new Integer(n2));
            objectOutputStream.writeObject(SerializerFactory.getState(renderingHints, null));
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        Object object = null;
        try {
            object = objectInputStream.readObject();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        RenderedImage renderedImage = (RenderedImage)object;
        try {
            outputStream.close();
            objectOutputStream.close();
            inputStream.close();
            objectInputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return renderedImage;
    }

    public float getHeight() {
        return this.height;
    }

    public float getMinX() {
        return this.minX;
    }

    public float getMinY() {
        return this.minY;
    }

    public Object getProperty(String string) {
        Object v = this.properties.get(new CaselessStringKey(string));
        return v == null ? Image.UndefinedProperty : v;
    }

    public String[] getPropertyNames() {
        String[] stringArray = null;
        if (!this.properties.isEmpty()) {
            stringArray = new String[this.properties.size()];
            Enumeration enumeration = this.properties.keys();
            int n = 0;
            while (enumeration.hasMoreElements()) {
                CaselessStringKey caselessStringKey = (CaselessStringKey)enumeration.nextElement();
                stringArray[n++] = caselessStringKey.getName();
            }
        }
        return stringArray;
    }

    public Vector getSources() {
        return this.sources;
    }

    public boolean isDynamic() {
        return this.isDynamic;
    }

    public float getWidth() {
        return this.width;
    }

    private synchronized void openServer() throws IOException, SocketException {
        if (!this.serverOpen) {
            this.serverSocket = new ServerSocket(0);
            this.serverSocket.setSoTimeout(60000);
            this.port = this.serverSocket.getLocalPort();
            this.serverOpen = true;
            this.serverThread = new Thread(new RenderingServer());
            this.serverThread.start();
            SerializableRenderableImage.incrementRemoteReferenceCount(this);
        }
    }

    private void closeClient() {
        Socket socket = this.connectToServer();
        OutputStream outputStream = null;
        ObjectOutputStream objectOutputStream = null;
        try {
            outputStream = socket.getOutputStream();
            objectOutputStream = new ObjectOutputStream(outputStream);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        try {
            objectOutputStream.writeObject(CLOSE_MESSAGE);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        try {
            outputStream.close();
            objectOutputStream.close();
            socket.close();
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
    }

    private Socket connectToServer() {
        Socket socket = null;
        try {
            socket = new Socket(this.host, this.port);
            socket.setSoLinger(true, 1);
        }
        catch (Exception exception) {
            throw new RuntimeException(exception.getMessage());
        }
        return socket;
    }

    protected void finalize() throws Throwable {
        this.dispose();
        super.finalize();
    }

    public void dispose() {
        if (this.isServer) {
            if (this.serverOpen) {
                this.serverOpen = false;
                try {
                    this.serverThread.join(120000L);
                }
                catch (Exception exception) {
                    // empty catch block
                }
                try {
                    this.serverSocket.close();
                }
                catch (Exception exception) {}
            }
        } else {
            this.closeClient();
        }
    }

    private void writeObject(ObjectOutputStream objectOutputStream) throws IOException {
        try {
            this.openServer();
        }
        catch (Exception exception) {
            if (exception instanceof SocketException && this.serverSocket != null) {
                try {
                    this.serverSocket.close();
                }
                catch (IOException iOException) {
                    // empty catch block
                }
            }
            this.serverOpen = false;
        }
        objectOutputStream.defaultWriteObject();
        Hashtable hashtable = this.properties;
        boolean bl = false;
        Enumeration enumeration = hashtable.keys();
        while (enumeration.hasMoreElements()) {
            Object k = enumeration.nextElement();
            if (this.properties.get(k) instanceof Serializable) continue;
            if (!bl) {
                hashtable = (Hashtable)this.properties.clone();
                bl = true;
            }
            hashtable.remove(k);
        }
        objectOutputStream.writeObject(hashtable);
    }

    private void readObject(ObjectInputStream objectInputStream) throws IOException, ClassNotFoundException {
        this.isServer = false;
        this.source = null;
        this.serverOpen = false;
        this.serverSocket = null;
        this.serverThread = null;
        objectInputStream.defaultReadObject();
        this.properties = (Hashtable)objectInputStream.readObject();
    }

    private class RenderingServer
    implements Runnable {
        private RenderingServer() {
        }

        /*
         * Enabled force condition propagation
         * Lifted jumps to return sites
         */
        public void run() {
            while (SerializableRenderableImage.this.serverOpen) {
                Socket socket = null;
                try {
                    socket = SerializableRenderableImage.this.serverSocket.accept();
                    socket.setSoLinger(true, 1);
                }
                catch (InterruptedIOException interruptedIOException) {
                    continue;
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
                InputStream inputStream = null;
                OutputStream outputStream = null;
                ObjectInputStream objectInputStream = null;
                ObjectOutputStream objectOutputStream = null;
                try {
                    inputStream = socket.getInputStream();
                    outputStream = socket.getOutputStream();
                    objectInputStream = new ObjectInputStream(inputStream);
                    objectOutputStream = new ObjectOutputStream(outputStream);
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
                Object object = null;
                try {
                    object = objectInputStream.readObject();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
                RenderedImage renderedImage = null;
                if (!(object instanceof String)) throw new RuntimeException(JaiI18N.getString("SerializableRenderableImage0"));
                String string = (String)object;
                if (string.equals(SerializableRenderableImage.CLOSE_MESSAGE)) {
                    SerializableRenderableImage.decrementRemoteReferenceCount(this);
                } else {
                    SerializableRenderedImage serializableRenderedImage;
                    if (string.equals("createDefaultRendering")) {
                        renderedImage = SerializableRenderableImage.this.source.createDefaultRendering();
                    } else if (string.equals("createRendering")) {
                        object = null;
                        try {
                            object = objectInputStream.readObject();
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception.getMessage());
                        }
                        SerializableState serializableState = (SerializableState)object;
                        RenderContext renderContext = (RenderContext)serializableState.getObject();
                        renderedImage = SerializableRenderableImage.this.source.createRendering(renderContext);
                    } else if (string.equals("createScaledRendering")) {
                        object = null;
                        try {
                            object = objectInputStream.readObject();
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception.getMessage());
                        }
                        int n = (Integer)object;
                        try {
                            object = objectInputStream.readObject();
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception.getMessage());
                        }
                        int n2 = (Integer)object;
                        try {
                            object = objectInputStream.readObject();
                        }
                        catch (Exception exception) {
                            throw new RuntimeException(exception.getMessage());
                        }
                        SerializableState serializableState = (SerializableState)object;
                        RenderingHints renderingHints = (RenderingHints)serializableState.getObject();
                        renderedImage = SerializableRenderableImage.this.source.createScaledRendering(n, n2, renderingHints);
                    }
                    if (SerializableRenderableImage.this.useTileCodec) {
                        try {
                            serializableRenderedImage = new SerializableRenderedImage(renderedImage, true, SerializableRenderableImage.this.registry, SerializableRenderableImage.this.formatName, SerializableRenderableImage.this.encodingParam, SerializableRenderableImage.this.decodingParam);
                        }
                        catch (NotSerializableException notSerializableException) {
                            throw new RuntimeException(notSerializableException.getMessage());
                        }
                    } else {
                        serializableRenderedImage = new SerializableRenderedImage(renderedImage, true);
                    }
                    try {
                        objectOutputStream.writeObject(serializableRenderedImage);
                    }
                    catch (Exception exception) {
                        throw new RuntimeException(exception.getMessage());
                    }
                }
                try {
                    objectOutputStream.close();
                    objectInputStream.close();
                    outputStream.close();
                    inputStream.close();
                    socket.close();
                }
                catch (Exception exception) {
                    throw new RuntimeException(exception.getMessage());
                }
            }
        }
    }
}

