/*
 * Decompiled with CFR 0.152.
 */
package com.sun.media.jai.opimage;

import com.sun.media.jai.opimage.JaiI18N;
import java.awt.Canvas;
import java.awt.Image;
import java.awt.MediaTracker;
import java.awt.Point;
import java.awt.Rectangle;
import java.awt.image.DataBufferInt;
import java.awt.image.PixelGrabber;
import java.awt.image.Raster;
import java.awt.image.SinglePixelPackedSampleModel;
import java.awt.image.WritableRaster;
import java.util.Map;
import javax.media.jai.ImageLayout;
import javax.media.jai.PlanarImage;
import javax.media.jai.RasterAccessor;
import javax.media.jai.RasterFactory;
import javax.media.jai.RasterFormatTag;
import javax.media.jai.SourcelessOpImage;

final class AWTImageOpImage
extends SourcelessOpImage {
    private int[] pixels;
    private RasterFormatTag rasterFormatTag;

    private static final ImageLayout layoutHelper(ImageLayout imageLayout, Image image) {
        MediaTracker mediaTracker = new MediaTracker(new Canvas());
        mediaTracker.addImage(image, 0);
        try {
            mediaTracker.waitForID(0);
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new RuntimeException(JaiI18N.getString("AWTImageOpImage0"));
        }
        if (mediaTracker.isErrorID(0)) {
            throw new RuntimeException(JaiI18N.getString("AWTImageOpImage1"));
        }
        mediaTracker.removeImage(image);
        if (imageLayout == null) {
            imageLayout = new ImageLayout();
        }
        imageLayout.setMinX(0);
        imageLayout.setMinY(0);
        imageLayout.setWidth(image.getWidth(null));
        imageLayout.setHeight(image.getHeight(null));
        if (!imageLayout.isValid(64)) {
            imageLayout.setTileWidth(imageLayout.getWidth(null));
        }
        if (!imageLayout.isValid(128)) {
            imageLayout.setTileHeight(imageLayout.getHeight(null));
        }
        if (imageLayout.getTileWidth(null) == imageLayout.getWidth(null) && imageLayout.getTileHeight(null) == imageLayout.getHeight(null)) {
            imageLayout.setTileGridXOffset(imageLayout.getMinX(null));
            imageLayout.setTileGridYOffset(imageLayout.getMinY(null));
            int[] nArray = new int[]{0xFF0000, 65280, 255};
            imageLayout.setSampleModel(new SinglePixelPackedSampleModel(3, imageLayout.getWidth(null), imageLayout.getHeight(null), nArray));
        } else {
            imageLayout.setSampleModel(RasterFactory.createPixelInterleavedSampleModel(0, imageLayout.getTileWidth(null), imageLayout.getTileHeight(null), 3));
        }
        imageLayout.setColorModel(PlanarImage.createColorModel(imageLayout.getSampleModel(null)));
        return imageLayout;
    }

    public AWTImageOpImage(Map map, ImageLayout imageLayout, Image image) {
        imageLayout = AWTImageOpImage.layoutHelper(imageLayout, image);
        super(imageLayout, map, imageLayout.getSampleModel(null), imageLayout.getMinX(null), imageLayout.getMinY(null), imageLayout.getWidth(null), imageLayout.getHeight(null));
        this.rasterFormatTag = null;
        if (this.getTileWidth() != this.getWidth() || this.getTileHeight() != this.getHeight()) {
            this.rasterFormatTag = new RasterFormatTag(this.getSampleModel(), 0);
        }
        this.pixels = new int[this.width * this.height];
        PixelGrabber pixelGrabber = new PixelGrabber(image, 0, 0, this.width, this.height, this.pixels, 0, this.width);
        try {
            if (!pixelGrabber.grabPixels()) {
                if ((pixelGrabber.getStatus() & 0x80) != 0) {
                    throw new RuntimeException(JaiI18N.getString("AWTImageOpImage2"));
                }
                throw new RuntimeException(pixelGrabber.getStatus() + JaiI18N.getString("AWTImageOpImage3"));
            }
        }
        catch (InterruptedException interruptedException) {
            interruptedException.printStackTrace();
            throw new RuntimeException(JaiI18N.getString("AWTImageOpImage4"));
        }
    }

    public Raster computeTile(int n, int n2) {
        if (this.getTileWidth() == this.getWidth() && this.getTileHeight() == this.getHeight()) {
            DataBufferInt dataBufferInt = new DataBufferInt(this.pixels, this.pixels.length);
            return Raster.createWritableRaster(this.getSampleModel(), dataBufferInt, new Point(this.tileXToX(n), this.tileYToY(n2)));
        }
        return super.computeTile(n, n2);
    }

    protected void computeRect(PlanarImage[] planarImageArray, WritableRaster writableRaster, Rectangle rectangle) {
        RasterAccessor rasterAccessor = new RasterAccessor(writableRaster, rectangle, this.rasterFormatTag, null);
        int n = rasterAccessor.getWidth();
        int n2 = rasterAccessor.getHeight();
        int n3 = rasterAccessor.getScanlineStride();
        int n4 = rasterAccessor.getPixelStride();
        int n5 = rasterAccessor.getBandOffset(0);
        int n6 = rasterAccessor.getBandOffset(1);
        int n7 = rasterAccessor.getBandOffset(2);
        byte[] byArray = rasterAccessor.getByteDataArray(0);
        int n8 = (rectangle.y - this.minY) * this.width + (rectangle.x - this.minX);
        int n9 = 0;
        while (n9 < n2) {
            int n10 = n5;
            int n11 = n6;
            int n12 = n7;
            n5 += n3;
            n6 += n3;
            n7 += n3;
            int n13 = n8;
            n8 += this.width;
            int n14 = 0;
            while (n14 < n) {
                byArray[n10] = (byte)(this.pixels[n13] >> 16 & 0xFF);
                byArray[n11] = (byte)(this.pixels[n13] >> 8 & 0xFF);
                byArray[n12] = (byte)(this.pixels[n13] & 0xFF);
                n10 += n4;
                n11 += n4;
                n12 += n4;
                ++n13;
                ++n14;
            }
            ++n9;
        }
    }
}

