/*
 * Decompiled with CFR 0.152.
 */
package opennlp.grok;

import gnu.getopt.Getopt;
import java.io.File;
import java.io.IOException;
import java.net.ServerSocket;
import opennlp.common.Pipeline;
import opennlp.common.PipelineException;
import opennlp.common.xml.NLPDocument;
import opennlp.grok.PipelineServerThread;

public class PipelineServer {
    /*
     * WARNING - void declaration
     */
    public static void main(String[] args) throws PipelineException, IOException {
        int optind;
        int c;
        Object input = null;
        boolean server = false;
        int port = 1058;
        Getopt g = new Getopt("opennlp", args, "f:i:sp:");
        while ((c = g.getopt()) != -1) {
            void var5_5;
            switch (var5_5) {
                case 102: {
                    input = new File(g.getOptarg());
                    break;
                }
                case 105: {
                    input = g.getOptarg();
                    break;
                }
                case 115: {
                    server = true;
                    break;
                }
                case 112: {
                    port = Integer.parseInt(g.getOptarg());
                }
            }
        }
        if (!server && input == null) {
            throw new PipelineException("No input specified");
        }
        String[] nonOptArgs = new String[args.length - g.getOptind()];
        int i = optind = g.getOptind();
        while (i < args.length) {
            nonOptArgs[i - optind] = args[i];
            ++i;
        }
        Pipeline pipe = new Pipeline(nonOptArgs);
        if (!server) {
            NLPDocument doc = pipe.run(input);
            System.out.println(doc.toXml());
        } else {
            ServerSocket serverSocket = null;
            boolean listening = true;
            try {
                serverSocket = new ServerSocket(port);
            }
            catch (IOException e) {
                System.err.println("Could not listen on port: " + port);
                System.exit(-1);
            }
            while (listening) {
                System.out.println("Waiting for Connection");
                new PipelineServerThread(serverSocket.accept(), pipe).start();
            }
            serverSocket.close();
        }
    }
}

