/*
 * Decompiled with CFR 0.152.
 */
package org.maltparser.core.options;

import java.util.Collection;
import java.util.HashMap;
import java.util.TreeSet;
import org.maltparser.core.options.OptionException;
import org.maltparser.core.options.option.Option;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class OptionGroup {
    private String name;
    private HashMap<String, Option> options;
    public static int toStringSetting = 0;
    public static final int WITHGROUPNAME = 0;
    public static final int NOGROUPNAME = 1;

    public OptionGroup(String name) {
        this.setName(name);
        this.options = new HashMap();
    }

    public String getName() {
        return this.name;
    }

    public void setName(String name) {
        this.name = name.toLowerCase();
    }

    public void addOption(Option option) throws OptionException {
        if (option.getName() == null || option.getName().equals("")) {
            throw new OptionException("The option name is null or contains the empty string. ");
        }
        if (this.options.containsKey(option.getName().toLowerCase())) {
            throw new OptionException("The option name already exists for that option group. ");
        }
        this.options.put(option.getName().toLowerCase(), option);
    }

    public Option getOption(String optionname) {
        return this.options.get(optionname);
    }

    public Collection<Option> getOptionList() {
        return this.options.values();
    }

    public String toString() {
        StringBuilder sb = new StringBuilder();
        if (toStringSetting == 0) {
            sb.append("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
            sb.append("+ " + this.name + "\n");
            sb.append("+++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++++\n");
        }
        for (String value : new TreeSet<String>(this.options.keySet())) {
            sb.append(this.options.get(value).toString());
        }
        return sb.toString();
    }
}

